DACSAUTH(1)                  DACS Commands Manual                  DACSAUTH(1)



NNAAMMEE
       dacsauth - authentication check

SSYYNNOOPPSSIISS
       ddaaccssaauutthh [--mm _a_u_t_h_-_m_o_d_u_l_e_-_s_p_e_c] [...] [--rr _r_o_l_e_s_-_m_o_d_u_l_e_-_s_p_e_c] [...]
                        [--DD_d_i_r_e_c_t_i_v_e==_v_a_l_u_e] [--aauuxx]
                        [--ffjj _j_u_r_n_a_m_e] [--ffnn _f_e_d_n_a_m_e] [--hh | --hheellpp] [--iidd]
                        [--llll _l_o_g___l_e_v_e_l] [--pp _p_a_s_s_w_o_r_d]
                        [--ppff _f_i_l_e] [--pprroommpptt] [--qq] [{--uu | --uusseerr} _u_s_e_r_n_a_m_e] [--vv]
                        ddaaccssaauutthh--mmoodduulleess

DDEESSCCRRIIPPTTIIOONN
       This program is part of the DDAACCSS suite.

       The ddaaccssaauutthh utility tests whether given authentication material
       satisfies authentication requirements and indicates the outcome through
       the process's exit status. It is similar to ddaaccss__aauutthheennttiiccaattee((88))[1] and
       ddaaccssccrreedd((11))[2].

       ddaaccssaauutthh provides a way for scripts and other programs to leverage the
       DDAACCSS authentication infrastructure. They might use successful
       authentication as a coarse form of authorization; only a user that
       provides a correct password might be allowed to run the program, for
       instance. Or they might return some type of credentials after
       successful authentication, or perhaps use ddaaccss__aauutthh__aaggeenntt((88))[3] to
       return DDAACCSS credentials.

       ddaaccssaauutthh can also be used to retrieve role information associated with
       a given user.

       ddaaccssaauutthh does not read any DDAACCSS configuration files. Everything needed
       to perform the test must be specified as an argument.

           TTiipp
           If ddaaccssaauutthh uses a built-in module to perform authentication, or
           look up roles, _n_o _s_e_r_v_e_r _c_o_m_p_o_n_e_n_t _i_s _r_e_q_u_i_r_e_d. This means that you
           can use ddaaccssaauutthh without having to access or even configure a web
           server, including Apache.

OOPPTTIIOONNSS
       The following command line flags are recognized. At least one --mm flag
       (to perform authentication testing), or at least one --rr flag must be
       specified (to form a role descriptor string for the identity and print
       it to stdout). A combination of both flags is allowed, in which case a
       role descriptor string is output only if the authentication test is
       successful.

       --DD_d_i_r_e_c_t_i_v_e==_v_a_l_u_e
           This is equivalent to setting _d_i_r_e_c_t_i_v_e, a general DDAACCSS
           configuration directive, to _v_a_l_u_e. See ddaaccss..ccoonnff((55))[4].

       --aauuxx
           The next string provided by the --pp, --ppff, or --pprroommpptt flag will be
           the value of the _A_U_X_I_L_I_A_R_Y authentication argument. This provides a
           secure way to pass sensitive auxiliary information, such as a PIN,
           to the program. A flag to obtain the password, if any, must precede
           this flag on the command line.

       --ffjj _j_u_r_n_a_m_e
           Use _j_u_r_n_a_m_e, which must be syntactically valid, as the jurisdiction
           name. If required but not provided, a value derived from the host's
           domain name will be used.

       --ffnn _f_e_d_n_a_m_e
           Use _f_e_d_n_a_m_e, which must be syntactically valid, as the federation
           name. If required but not provided, a value derived from the host's
           domain name will be used.

       --hh
       --hheellpp
           Display a help message and exit.

       --iidd
           If successful, print the authenticated DDAACCSS identity to the
           standard output.

       --llll _l_o_g___l_e_v_e_l
           Set the debugging output level to _l_o_g___l_e_v_e_l (see ddaaccss((11))[5]). The
           default level is warn.

       --mm _a_u_t_h_-_m_o_d_u_l_e_-_s_p_e_c
           Each type of authentication test that is required is described by
           an _a_u_t_h_-_m_o_d_u_l_e_-_s_p_e_c that immediately follows the --mm flag. Each
           _a_u_t_h_-_m_o_d_u_l_e_-_s_p_e_c is essentially an alternate representation of an
           AAuutthh ccllaauussee[6] and its directives, which are used by
           ddaaccss__aauutthheennttiiccaattee((88))[1]. Just as the order in which Auth clauses
           appear in a DDAACCSS configuration file, the order in which the --mm
           flags appear may be significant, depending on the _c_o_n_t_r_o_l keywords.
           Successive --mm components are assigned names, auth_module_1,
           auth_module_2, and so on, mainly for error reporting purposes.

           An _a_u_t_h_-_m_o_d_u_l_e_-_s_p_e_c has the following syntax:

           The _m_o_d_u_l_e consists of one argument if it is the name of a built-in
           module, or a valid abbreviation thereof, (equivalent to the UURRLL[7]
           directive), or two arguments where the first is the (absolute) URL
           of an external authentication module and the second is a recognized
           authentication style keyword (equivalent to the UURRLL[7] directive
           followed by the SSTTYYLLEE[8] directive). The style keyword is omitted
           in the one-argument syntax, as a convenience and because it is
           known.

           The _c_o_n_t_r_o_l keyword is identical to the CCOONNTTRROOLL[9] directive in the
           Auth clause. After the _c_o_n_t_r_o_l keyword, flags may follow, in any
           order.

           An _a_u_t_h_-_m_o_d_u_l_e_-_s_p_e_c ends when the first invalid flag (or the end of
           flags) is encountered.

           The --OO flag is equivalent to an OOPPTTIIOONN[10] directive.

           The --OOff flag is followed by an argument that is the name of a file
           from which to read options, one per line, in the format _n_a_m_e=_v_a_l_u_e.
           Blank lines and lines beginning with a '#' are ignored; note that
           these lines do not begin with "-O" and quotes are simply copied and
           not interpreted. The --OOff flag can be used to avoid putting
           passwords on the command line and makes it easier to write
           expressions that would otherwise have to be carefully escaped to
           prevent interpretation by the shell, for example.

           The --eexxpprr flag is equivalent to the EEXXPPRR[11] directive. The --vvffss
           flag is used to configure VVFFSS[12] directives required by this
           module.

       --mmoodduulleess
           Display a list of built-in authentication modules and roles
           modules, one per line, and then exit. The canonical module name is
           printed, followed by zero or more equivalent abbreviations. For
           authentication modules, the authentication style is shown. To list
           the available modules, run the command:

               % dacsauth -modules

           The set of available (enabled) built-in authentication and roles
           modules is determined when DDAACCSS is built.

       --pp _p_a_s_s_w_o_r_d
           Specify the password to use (equivalent to the _P_A_S_S_W_O_R_D argument to
           ddaaccss__aauutthheennttiiccaattee).

               SSeeccuurriittyy
               A password given on the command line may be visible to other
               users on the same system.

       --ppff _f_i_l_e
           Read the password to use from _f_i_l_e (equivalent to the _P_A_S_S_W_O_R_D
           argument to ddaaccss__aauutthheennttiiccaattee). If _f_i_l_e is "-", then the password
           is read from the standard input without prompting.

       --pprroommpptt
           Prompt for the password and read it from stdin (equivalent to the
           _P_A_S_S_W_O_R_D argument to ddaaccss__aauutthheennttiiccaattee). The password is not
           echoed.

       --qq
           Be more quiet by reducing the debugging output level.

       --rr _r_o_l_e_-_m_o_d_u_l_e_-_s_p_e_c
           Roles for _u_s_e_r_n_a_m_e can be determined by giving this flag, which is
           immediately followed by a _r_o_l_e_s_-_m_o_d_u_l_e_-_s_p_e_c. The --rr flag may be
           repeated, and the resulting roles are combined. Each
           _r_o_l_e_s_-_m_o_d_u_l_e_-_s_p_e_c is essentially an alternate representation of a
           Roles clause that is used by ddaaccss__aauutthheennttiiccaattee((88))[13]. Successive
           --rr components are assigned names, roles_module_1, roles_module_2,
           and so on, mainly for error reporting purposes.

           A _r_o_l_e_s_-_m_o_d_u_l_e_-_s_p_e_c has the following syntax: The _m_o_d_u_l_e component
           is equivalent to the Roles clause's UURRLL[14] directive and is either
           the name of an available built-in roles module, a valid
           abbreviation thereof, or the (absolute) URL of an external roles
           module.

           Flags may follow the _m_o_d_u_l_e component, in any order. A
           _r_o_l_e_s_-_m_o_d_u_l_e_-_s_p_e_c ends when the first invalid flag (or the end of
           flags) is encountered.

           The --OO flag is equivalent to an OOPPTTIIOONN[10] directive.

           The --OOff flag is followed by an argument that is the name of a file
           from which to read options, one per line, in the format _n_a_m_e=_v_a_l_u_e.
           Blank lines and lines beginning with a '#' are ignored; note that
           these lines do not begin with "-O" and quotes are simply copied and
           not interpreted. The --OOff flag can be used to avoid putting
           passwords on the command line and makes it easier to write
           expressions that would otherwise have to be carefully escaped to
           prevent interpretation by the shell, for example.

           The --eexxpprr flag is equivalent to the EEXXPPRR[11] directive. The --vvffss
           flag is used to configure VVFFSS[12] directives required by _m_o_d_u_l_e.

       --uu _u_s_e_r_n_a_m_e
       --uusseerr _u_s_e_r_n_a_m_e
           The username to authenticate against (equivalent to the _U_S_E_R_N_A_M_E
           argument to ddaaccss__aauutthheennttiiccaattee). This username is implicitly
           associated with the effective federation and jurisdiction (see the
           --ffnn[15] and --ffjj[16] flags).

       --vv
           The --vv flag bumps the debugging output level to debug or (if
           repeated) trace.

EEXXAAMMPPLLEESS
           SSeeccuurriittyy
           If ddaaccssaauutthh uses a built-in module to perform authentication, it
           must run setuid or setgid to obtain sufficient privileges to access
           the required password file (the same is true for built-in roles
           modules). If it uses an external module, that module will need to
           execute with sufficient privileges to access DDAACCSS cryptographic
           keys, specifically federation_keys and possibly DDAACCSS or system
           password files; the external module will then need to execute with
           sufficient privileges to access any files it requires.

           Be sure to use the federation_keys that are correct for your
           federation. Referencing authentication modules in two or more
           federations will probably not work.

           ddaaccssaauutthh should therefore not ordinarily run as the UID of the user
           that invokes it (unless that happens to be root) because it will
           not be able to access the information it requires. This will also
           prevent a user from "cheating" (e.g., by attaching to the running
           module with a debugger).

       This example authenticates user "bobo" with password "test" against the
       DDAACCSS password file /usr/local/dacs/conf/passwd:

           % dacsauth -m passwd required
             -vfs "[passwds]dacs-kwv-fs:/usr/local/dacs/conf/passwd" -q -u bobo -p test

       If the command's exit status is zero, the authentication test
       succeeded, otherwise it failed.

       The following example attempts to authenticate "bobo" against her Unix
       password file. The program prompts for the password.

           % dacsauth -m unix required -u bobo -prompt

       In the next example, ddaaccssaauutthh attempts to authenticate "bobo" via NTLM
       on winders.example.com:

           % dacsauth -m ntlm suff -OSAMBA_SERVER="winders.example.com" -prompt -u bobo

       This example is similar to the previous one, except that an external
       authentication module is used and the password is read from a file.
       Because of the external module, additional configuration must be
       provided; in particular, the location of federation_keys and the
       federation and jurisdiction names must be specified.

           % dacsauth -m https://example.example.com/cgi-bin/dacs/local_ntlm_authenticate \
              passwd sufficient -OSAMBA_SERVER="winders.example.com" \
             -fn EXAMPLE -fj FEDROOT -u bobo -pf mypass \
             -DVFS="[federation_keys]dacs-fs:/usr/local/dacs/federations/example/federation_keys"

       To authenticate against the GGooooggllee[17](TM) account nobody@gmail.com,
       one might use:

           % dacsauth -m http suff \
             -OAUTH_URL="https://www.google.com/accounts/ClientLogin" \
             -OUSERNAME_PARAMETER=Email -OPASSWORD_PARAMETER=Passwd \
             -Oservice=xapi -Osource=DSS-DACS-1.4 -prompt -u nobody@gmail.com

       In the following example, an expression is evaluated to determine
       whether authentication should succeed. The user ("bobo") is prompted
       for a password. Only if the string "foo" is given will authentication
       succeed. A more realistic example might call another program to help
       make the determination, for instance.

           % dacsauth -m expr suffi \
            -expr '${Args::PASSWORD} eq "foo" ? ${Args::USERNAME} : ""' -user bobo -prompt

       Authentication against an Apache hhttddiiggeesstt password file is performed in
       the following example, where the password is read from stdin:

           % echo "test" | dacsauth -m apache sufficient \
             -OAUTH_MODULE=mod_auth_digest \
             -OAUTH_FILE=/usr/local/apache2/conf/passwords.digest \
             -OAUTH_REALM="DACS Digest Auth Area" \
             -u bobo -pf -

       Authentication via the PAM module works differently than the other
       modules - and is more complicated to use - because ddaaccssaauutthh may need to
       be run several times, depending on what information PAM requires.
       Instead of returning a yes/no decision, ddaaccssaauutthh may print prompts for
       more information to stdout. Please review the operational details
       presented in ddaaccss__aauutthheennttiiccaattee((88))[18] and ppaammdd((88))[19] before attempting
       to use this module.

       The following example demonstrates use of the module from the command
       line. Once the basic ideas are understood, it should be apparent how to
       write a script to performed the necessary iterations. Details in the
       example, such as paths, may need to be adjusted for your environment.
       Note that in this example the username is not specified the first time
       ddaaccssaauutthh is run, although it could be if it were known.

           % dacsauth -m pam suffic \
            -vfs "[federation_keys]dacs-fs:/usr/local/dacs/federations/dss/federation_keys" \
            -OPAMD_HOST=localhost -OPAMD_PORT=dacs-pamd -fj EXAMPLE -fn TEST
           AUTH_PROMPT_VAR1="Login:"
           AUTH_TRANSID="10.0.0.124:57849:85748:9997c5588a6239e3"
           % dacsauth -m pam suffic \
            -vfs "[federation_keys]dacs-fs:/usr/local/dacs/federations/dss/federation_keys" \
            -OAUTH_PROMPT_VAR1="bobo" \
            -OAUTH_TRANSID="10.0.0.124:57849:85748:9997c5588a6239e3"-fj EXAMPLE -fn TEST
           AUTH_PROMPT_VAR2="Password:"
           AUTH_TRANSID="10.0.0.124:52188:88417:5ffb0015f21ea546"
           % dacsauth -m pam suffic \
            -vfs "[federation_keys]dacs-fs:/usr/local/dacs/federations/dss/federation_keys" \
            -OAUTH_PROMPT_VAR2="apassword" \
            -OAUTH_TRANSID="10.0.0.124:57849:85748:9997c5588a6239e3"-fj EXAMPLE -fn TEST

       The first time ddaaccssaauutthh is run in the example it returns a prompt for
       the username ("Login:") that is associated with the transaction
       variable _A_U_T_H___P_R_O_M_P_T___V_A_R_1 and a transaction identifier (_A_U_T_H___T_R_A_N_S_I_D).
       The latter must be passed to the subsequent executions of ddaaccssaauutthh. The
       second run of ddaaccssaauutthh passes the username ("bobo") and returns another
       prompt ("Password:") that is associated with the transaction variable
       _A_U_T_H___P_R_O_M_P_T___V_A_R_2. The third run passes the password ("apassword") but
       no prompt is returned, indicating that the session is complete and the
       program's exit status reflects the outcome of authentication.

           TTiipp
           Whether ddaaccssaauutthh requires a password to retrieve roles depends on
           the particular roles module being used. For example, a password is
           not required by llooccaall__uunniixx__rroolleess[20] or llooccaall__rroolleess[21] to obtain
           roles, but llooccaall__llddaapp__rroolleess[22] will probably need a password to
           bind to the directory and obtain roles.

       This example prints the role string for user "bobo" by calling the
       built-in llooccaall__uunniixx__rroolleess[20] module:

           % dacsauth -r unix -u bobo
           bobo,wheel,www,users

       The next example is similar to the previous one, except an external
       roles module is used:

           % dacsauth -r https://example.example.com/cgi-bin/dacs/local_unix_roles \
             -DVFS="[federation_keys]dacs-fs:/usr/local/dacs/federations/federation_keys" \
             -fn EXAMPLE -u bobo
           bobo,wheel,www,users

       The external roles module might be executed on a different host than
       the one running ddaaccssaauutthh. Provided ddaaccssaauutthh has been installed and a
       matching federation_keys file is available on the local host, the local
       host need not be a DDAACCSS jurisdiction or have any other DDAACCSS
       configuration.

       The following example prints the rroollee ssttrriinngg[23] for user "bobo", known
       within the directory by the Common Name "Bobo Baggins", using the
       (external) llooccaall__llddaapp__rroolleess[22] module and the "direct" binding method:

           % dacsauth -r https://example.example.com/cgi-bin/dacs/local_ldap_roles \
               -Of /usr/local/dacs/ldap_roles_options_direct -u "Bobo Baggins" \
               -DVFS="[federation_keys]dacs-fs:/usr/local/dacs/federations/federation_keys" \
                -fn EXAMPLE -fj FEDROOT -prompt
           DnsAdmins,Print_Operators,Domain_Admins,Administrators

       Because there are too many flags to easily and correctly place on the
       command line, the options that are needed to do this are read from a
       file that is specified by the --OOff flag. This also provides a more
       secure way to pass passwords to the program; ensure that access to the
       file is restricted appropriately. The file
       /usr/local/dacs/ldap_roles_options_direct might contain configuration
       such as this:

           LDAP_BIND_METHOD=direct
           LDAP_ADMIN_URL*="ldap://winders.example.com/CN=" . encode(url,${Args::DACS_USERNAME}) . ",CN=Users,DC=example,DC=com"

           LDAP_ROLES_SELECTOR*="${LDAP::attrname}" eq "memberOf" ? strtr(ldap(rdn_attrvalue, \
               ldap(dn_index, "${LDAP::attrvalue}", 1)), " ", "_") : ""

       The following example is like the previous one, except that it uses the
       "indirect" binding method and therefore does not need to be given the
       user's Common Name:

           % dacsauth -r https://example.example.com/cgi-bin/dacs/local_ldap_roles \
               -Of /usr/local/dacs/ldap_roles_options_indirect -u bobo \
               -DVFS="[federation_keys]dacs-fs:/usr/local/dacs/federations/federation_keys" \
                -fn EXAMPLE -fj FEDROOT -p bobospassword
           DnsAdmins,Print_Operators,Domain_Admins,Administrators

       The file /usr/local/dacs/ldap_roles_options_indirect might contain
       configuration such as this:

           LDAP_BIND_METHOD=indirect
           LDAP_ADMIN_URL=ldap://winders.example.com/CN=Administrator,CN=Users,DC=example,DC=com

           # Search under Users...
           LDAP_SEARCH_ROOT_DN=CN=Users,DC=example,DC=com

           LDAP_ADMIN_PASSWORD=theSecretAdminPassword
           LDAP_SEARCH_FILTER*="(sAMAccountName=${Args::DACS_USERNAME})"
           LDAP_ROLES_SELECTOR*="${LDAP::attrname}" eq "memberOf" ? strtr(ldap(rdn_attrvalue, \
               ldap(dn_index, "${LDAP::attrvalue}", 1)), " ", "_") : ""


DDIIAAGGNNOOSSTTIICCSS
       The program exits 0 if authentication was successful or with 1 if
       authentication failed or an error occurred.

BBUUGGSS
       This command only supplies partial support for interacting with
       ddaaccss__aauutthheennttiiccaattee. It may not be possible for an authentication module
       to return role information, as can be done by ddaaccss__aauutthheennttiiccaattee.

SSEEEE AALLSSOO
       ddaaccssccrreedd((11))[2], ddaaccss__aauutthheennttiiccaattee((88))[1], ddaaccss..eexxpprrss((55))[24]

AAUUTTHHOORR
       Distributed Systems Software (wwwwww..ddssss..ccaa[25])

CCOOPPYYIINNGG
       Copyright (C) 2003-2012 Distributed Systems Software. See the
       LLIICCEENNSSEE[26] file that accompanies the distribution for licensing
       information.

NNOOTTEESS
        1. dacs_authenticate(8)
           http://dacs.dss.ca/man/dacs_authenticate.8.html

        2. dacscred(1)
           http://dacs.dss.ca/man/dacscred.1.html

        3. dacs_auth_agent(8)
           http://dacs.dss.ca/man/dacs_auth_agent.8.html

        4. dacs.conf(5)
           http://dacs.dss.ca/man/dacs.conf.5.html

        5. dacs(1)
           http://dacs.dss.ca/man/dacs.1.html

        6. Auth clause
           http://dacs.dss.ca/man/dacs_authenticate.html#auth_clause

        7. URL
           http://dacs.dss.ca/man/dacs_authenticate.8.html#URL

        8. STYLE
           http://dacs.dss.ca/man/dacs_authenticate.8.html#STYLE

        9. CONTROL
           http://dacs.dss.ca/man/dacs_authenticate.8.html#CONTROL

       10. OPTION
           http://dacs.dss.ca/man/dacs_authenticate.8.html#OPTION

       11. EXPR
           http://dacs.dss.ca/man/dacs_authenticate.8.html#EXPR

       12. VFS
           http://dacs.dss.ca/man/dacs.conf.5.html#VFS

       13. dacs_authenticate(8)
           http://dacs.dss.ca/man/dacs_authenticate.8.html#roles_clause

       14. URL
           http://dacs.dss.ca/man/dacs_authenticate.8.html#r_URL

       15. -fn
           http://dacs.dss.ca/man/#fn_flag

       16. -fj
           http://dacs.dss.ca/man/#fj_flag

       17. Google
           http://www.google.com

       18. dacs_authenticate(8)
           http://dacs.dss.ca/man/dacs_authenticate.8.html#local_pam_authenticate

       19. pamd(8)
           http://dacs.dss.ca/man/pamd.8.html

       20. local_unix_roles
           http://dacs.dss.ca/man/dacs_authenticate.8.html#local_unix_roles

       21. local_roles
           http://dacs.dss.ca/man/dacs_authenticate.8.html#local_roles

       22. local_ldap_roles
           http://dacs.dss.ca/man/dacs_authenticate.8.html#local_ldap_roles

       23. role string
           http://dacs.dss.ca/man/dacs.1.html#roles

       24. dacs.exprs(5)
           http://dacs.dss.ca/man/dacs.exprs.5.html

       25. www.dss.ca
           http://www.dss.ca

       26. LICENSE
           http://dacs.dss.ca/man/../misc/LICENSE



DACS 1.4.27                       01/16/2012                       DACSAUTH(1)
