DACSCONF(1)                  DACS Commands Manual                  DACSCONF(1)



NNAAMMEE
       dacsconf - display configuration directives

SSYYNNOOPPSSIISS
       ddaaccssccoonnff [ddaaccssooppttiioonnss[1]] [--vvaarrss] [_d_i_r_e_c_t_i_v_e_-_n_a_m_e...]

       ddaaccssccoonnff [--iitteemm__ttyyppeess]

DDEESSCCRRIIPPTTIIOONN
       This program is part of the DDAACCSS suite.

       The ddaaccssccoonnff utility processes DDAACCSS configuration files (see
       ddaaccss..ccoonnff((55))[2]) and outputs to stdout the values of directives or
       variable references currently in effect for the specified jurisdiction.

       Although the order in which clauses appear in configuration files can
       be important, the order of configuration directives is for the most
       part not significant. The exception is the EEVVAALL[3] directive. These
       directives are listed in the order in which they would be evaluated,
       and their _u_n_e_v_a_l_u_a_t_e_d values appear in the output.

       This program is also available as a DDAACCSS web service, ddaaccss__ccoonnff((88))[4].

           SSeeccuurriittyy
           Because the configuration might reveal information that could be
           taken advantage of by an attacker, only the DDAACCSS administrator
           should be able to run this command.

OOPPTTIIOONNSS
       --iitteemm__ttyyppeess
           List the names of all predefined item types. The presence of a name
           does not imply that DDAACCSS has been configured to use the item type.

       --vvaarrss
           By default, directives that appear within a clause (e.g., <Auth> or
           <Roles>) are emitted in the context of that clause. This option
           "flattens" the output by emitting it in the form of DDAACCSS variables.

           For example, the STYLE directive in an Auth section having an id of
           foo will appear as _A_U_T_H_._F_O_O_._S_T_Y_L_E in the output.

           All variables in the _C_o_n_f namespace are displayed, including those
           set by EVAL.

       _d_i_r_e_c_t_i_v_e_-_n_a_m_e
           One or more directive names or variable references may be provided
           to limit the output. It is not an error if a _d_i_r_e_c_t_i_v_e_-_n_a_m_e is not
           defined.

FFIILLEESS
       ccoonnff..ccssss[5]

DDIIAAGGNNOOSSTTIICCSS
       The program exits 0 if everything was fine, 1 if an error occurred.
       Error messages are printed to stderr.

SSEEEE AALLSSOO
       ddaaccss__ccoonnff((88))[4], ddaaccss..ccoonnff((55))[2]

AAUUTTHHOORR
       Distributed Systems Software (wwwwww..ddssss..ccaa[6])

CCOOPPYYIINNGG
       Copyright (C) 2003-2011 Distributed Systems Software. See the
       LLIICCEENNSSEE[7] file that accompanies the distribution for licensing
       information.

NNOOTTEESS
        1. dacsoptions
           http://dacs.dss.ca/man/dacs.1.html#dacsoptions

        2. dacs.conf(5)
           http://dacs.dss.ca/man/dacs.conf.5.html

        3. EVAL
           http://dacs.dss.ca/man/dacs.conf.5.html#EVAL

        4. dacs_conf(8)
           http://dacs.dss.ca/man/dacs_conf.8.html

        5. conf.css
           http://dacs.dss.ca/man//css/conf.css

        6. www.dss.ca
           http://www.dss.ca

        7. LICENSE
           http://dacs.dss.ca/man/../misc/LICENSE



DACS 1.4.27                       01/16/2012                       DACSCONF(1)
