DACSLIST(1)                  DACS Commands Manual                  DACSLIST(1)



NNAAMMEE
       dacslist - list jurisdictions

SSYYNNOOPPSSIISS
       ddaaccsslliisstt [ddaaccssooppttiioonnss[1]] [--ff] [--jj _j_u_r_i_s_d_i_c_t_i_o_n_-_n_a_m_e] [--kk]

DDEESSCCRRIIPPTTIIOONN
       This program is part of the DDAACCSS suite.

       For a jurisdiction configured on the host where this program is run,
       the ddaaccsslliisstt utility lists information about all known jurisdictions in
       the same federation. It can also display information about the
       federation.

       This program is also available as a DDAACCSS web service,
       ddaaccss__lliisstt__jjuurriissddiiccttiioonnss((88))[2].

           SSeeccuurriittyy
           Because this program may access the federation and jurisdiction key
           files (item types federation_keys and jurisdiction_keys,
           respectively), only the DDAACCSS administrator should be able to run
           this command.

OOPPTTIIOONNSS
       The program respects the --ffoorrmmaatt flag. Except for error messages,
       information is printed to the standard output.

       --ff
           Only list information about the federation. Equivalent to -j "".

       --jj _j_u_r_i_s_d_i_c_t_i_o_n_-_n_a_m_e
           Limit the output to the specified jurisdiction name. As a special
           case, if the argument is the empty string, only federation-scoped
           information will be returned.

       --kk
           Only the federation's or a jurisdiction's public key (if known)
           will be displayed. If --jj is given and is not the empty string, that
           jurisdiction name is selected; if --jj is given and is the empty
           string, the federation is selected; and if the argument is absent,
           the current jurisdiction is selected. A PEM [RRFFCC 11442211[3], RRFFCC
           11442222[4], RRFFCC 11442233[5], RRFFCC 11442244[6]] formatted key is returned.

           NNoottee
           In the current implementation, a jurisdiction's public key can only
           be provided by one of the jurisdictions configured on the same
           host.

EEXXAAMMPPLLEESS
       To list all jurisdictions in the same federation as jurisdiction J1,
       which must be configured on this host:

           % dacslist -uj J1

       To copy the public encryption key for J1 to pubkey:

           % dacslist -uj J1 -k > pubkey

       To display the public encryption key for J1's federation:

           % dacslist -uj J1 -f -k

       To retrieve the public encryption key for J1, which must be in the same
       federation as J2:

           % dacslist -uj J2 -k -j J1

       To display information about the federation to which jurisdiction J1
       belongs:

           % dacslist -uj J1 -f


DDIIAAGGNNOOSSTTIICCSS
       The program exits 0 if everything was fine, 1 if an error occurred.
       Error messages are printed to stderr.

SSEEEE AALLSSOO
       ddaaccss__lliisstt__jjuurriissddiiccttiioonnss((88))[2], ddaaccss..ggrroouuppss((55))[7]

AAUUTTHHOORR
       Distributed Systems Software (wwwwww..ddssss..ccaa[8])

CCOOPPYYIINNGG
       Copyright (C) 2003-2011 Distributed Systems Software. See the
       LLIICCEENNSSEE[9] file that accompanies the distribution for licensing
       information.

NNOOTTEESS
        1. dacsoptions
           http://dacs.dss.ca/man/dacs.1.html#dacsoptions

        2. dacs_list_jurisdictions(8)
           http://dacs.dss.ca/man/dacs_list_jurisdictions.8.html

        3. RFC 1421
           http://www.rfc-editor.org/rfc/rfc1421.txt

        4. RFC 1422
           http://www.rfc-editor.org/rfc/rfc1422.txt

        5. RFC 1423
           http://www.rfc-editor.org/rfc/rfc1423.txt

        6. RFC 1424
           http://www.rfc-editor.org/rfc/rfc1424.txt

        7. dacs.groups(5)
           http://dacs.dss.ca/man/dacs.groups.5.html

        8. www.dss.ca
           http://www.dss.ca

        9. LICENSE
           http://dacs.dss.ca/man/../misc/LICENSE



DACS 1.4.27                       01/16/2012                       DACSLIST(1)
