DACSPASSWD(1)                DACS Commands Manual                DACSPASSWD(1)



NNAAMMEE
       dacspasswd - manage DDAACCSS accounts

SSYYNNOOPPSSIISS
       ddaaccssppaasssswwdd [ddaaccssooppttiioonnss[1]] [--pp _p_a_s_s_w_o_r_d] [--ppff _f_i_l_e] [--ssiimmppllee]
                  [--vvffss _v_f_s___u_r_i]
                  [_o_p_-_s_p_e_c] [----] [_u_s_e_r_n_a_m_e]

DDEESSCCRRIIPPTTIIOONN
       This program is part of the DDAACCSS suite.

       The ddaaccssppaasssswwdd command manages accounts that are used by the
       llooccaall__ppaasssswwdd__aauutthheennttiiccaattee[2] and llooccaall__ssiimmppllee__aauutthheennttiiccaattee[3],
       authentication modules. This utility serves a similar purpose for these
       authentication modules that AAppaacchhee''ss hhttppaasssswwdd((11))[4] command does for
       its mmoodd__aauutthh[5] and mmoodd__aauutthh__ddbbmm[6] modules (or mmoodd__aauutthh__bbaassiicc[7] and
       mmoodd__aauutthhnn__ddbbmm[8]).

       Apart from their use by llooccaall__ppaasssswwdd__aauutthheennttiiccaattee and
       llooccaall__ssiimmppllee__aauutthheennttiiccaattee, _t_h_e_s_e _a_c_c_o_u_n_t_s _a_r_e _c_o_m_p_l_e_t_e_l_y _s_e_p_a_r_a_t_e _f_r_o_m
       _a_n_y _o_t_h_e_r _a_c_c_o_u_n_t_s _a_n_d _p_a_s_s_w_o_r_d_s.

           NNoottee
           Only lowercase usernames are permitted for these accounts.

       The command allows arbitrary data to be associated with each account.
       This "private" data is opaque to DDAACCSS and is not used by DDAACCSS. Custom,
       account-specific information can be stored, retrieved, and deleted.
       Data that is not printable text must be encoded. The information is
       automatically deleted when its account is removed. Using this feature,
       account administration programs might be developed to store:

       +o   the last time a password was changed;

       +o   hashes of previous password values (so that they are not reused);

       +o   a note that the account's password must be changed;

       +o   a password reminder question and answer;

       +o   information for mutual authentication, such as a small image
           provided by the user that is displayed at login time;

       +o   an encrypted representation of the password for recovery purposes
           (when absolutely necessary)

       +o   several security questions (with answers), one of which might be
           selected at random and presented to the user at login time; or

       +o   user preferences.

       Or instead, a pointer to any of this sort of information might be
       stored. There is no size limit for the data, but if relatively large
       amounts of data are being stored for a large number of accounts, the
       storage type should be chosen with care to ensure reasonable
       performance.

       Passwords are accessed using the DDAACCSS virtual filestore through the
       passwds or simple item types. Each record in the file is keyed on the
       username. The information associated with each key consists of several
       fields separated by a "|" character, and includes a digest algorithm
       identifier, salt, the computed digest, and optional application data.

           SSeeccuurriittyy
           The password digest algorithm used depends on the
           PPAASSSSWWOORRDD__DDIIGGEESSTT[9] directive in effect. The
           PPAASSSSWWOORRDD__SSAALLTT__PPRREEFFIIXX[10] directive is also used.

           _P_l_a_i_n_t_e_x_t _p_a_s_s_w_o_r_d_s _a_r_e _n_o_t _s_t_o_r_e_d _b_y ddaaccssppaasssswwdd. This makes it
           more difficult for an attacker that gains access to the password
           file to discover plaintext passwords, but also means that forgotten
           passwords cannot be recovered (except by exhaustive search, which
           ought to be impractical).

           The salted hash of the password is stored, assuming salting has not
           been disabled, rather than the hash of the password itself. This
           makes a stolen password file more difficult for an attacker to use
           (see rraaiinnbbooww ttaabblleess[11]).

           Only a DDAACCSS administrator should be able to successfully run this
           program from the command line. Because DDAACCSS keys and configuration
           files, including the file used to store passwords, must be
           restricted to an administrator, this will normally be the case, but
           a careful administrator will set file permissions to deny access to
           all other users. An ordinary user is able to change his own
           password using the ddaaccss__ppaasssswwdd((88))[12] web service.

           TTiipp
           Even if the password file is stored as a plain text file, it is
           probably best to modify it only through this program or
           ddaaccss__ppaasssswwdd.

           It is good administrative practice to store accounts with passwords
           separately from those without.

       This program is also available as a DDAACCSS web service,
       ddaaccss__ppaasssswwdd((88))[12].

OOPPTTIIOONNSS
       By default, the program will prompt for a new password if one is
       required by the selected operation.

       The ddaaccssppaasssswwdd command recognizes these command line flags:

       --pp _p_a_s_s_w_o_r_d
           Specify the password.

               SSeeccuurriittyy
               A password given on the command line may be visible to other
               users on the same system.

       --ppdddd
           Delete the private data associated with _u_s_e_r_n_a_m_e.

       --ppddgg
           Get the private data associated with _u_s_e_r_n_a_m_e and print it to the
           standard output.

       --ppddss _s_t_r_i_n_g
           Set (or replace) _s_t_r_i_n_g as private data associated with _u_s_e_r_n_a_m_e.

       --ppddssff _f_i_l_e
           Set (or replace) the private data associated with _u_s_e_r_n_a_m_e, reading
           it from _f_i_l_e. If _f_i_l_e is "-", then the data is read from the
           standard input. This flag and --ppff cannot both be used to read from
           the standard input.

       --ppff _f_i_l_e
           Read the password to use from _f_i_l_e. If _f_i_l_e is "-", then the
           password is read from the standard input without prompting. This
           flag and --ppddssff cannot both be used to read from the standard input.

       --ssiimmppllee
           Use the simple item type expected by llooccaall__ssiimmppllee__aauutthheennttiiccaattee
           instead of the default. The program will not prompt for passwords
           because these accounts do not use them.

       --vvffss _v_f_s___u_r_i
           Add _v_f_s___u_r_i as a VVFFSS[13] configuration directive. By specifying the
           item type passwds, a location for the password file can be given,
           overriding any configuration file value. This is particularly
           useful in conjunction with ddaaccssaauutthh((11))[14].

       _o_p_-_s_p_e_c
           The following operations are recognized. The --eennaabbllee, --ddiissaabbllee,
           --ppdddd, --ppddss, and --ppddssff are the only operations that can be combined
           with another operation (for example, you can disable an account and
           set its private data at the same time).

           --aa
           --aadddd
               Add _u_s_e_r_n_a_m_e to the password file. The entry must not already
               exist. By default, the user will be prompted for the password,
               which must be retyped for confirmation. This is the default
               operation.

           --dd
           --ddeell
           --ddeelleettee
               Delete _u_s_e_r_n_a_m_e from the password file.

           --ddiiss
           --ddiissaabbllee
               Disable the account for _u_s_e_r_n_a_m_e so that authentication modules
               will not accept any password. If used with --aa, --ss, or --uu, the
               account will also be disabled. The username may subsequently be
               enabled.

           --eenn
           --eennaa
           --eennaabbllee
               Re-enable the account for _u_s_e_r_n_a_m_e, which is currently
               disabled. The authentication modules will once again accept the
               password. If used with --aa, --ss, or --uu, the account will also be
               enabled.

           --gg
           --ggeett
               Get the digest string for _u_s_e_r_n_a_m_e and print it to the standard
               output. A script can validate a password by passing this digest
               string to ppaasssswwoorrdd(())[15] along with the password obtained from
               the user.

           --ll
           --lliisstt
               List _u_s_e_r_n_a_m_e if it appears in the password file. If no
               _u_s_e_r_n_a_m_e is provided, list all usernames. A disabled account is
               indicated by a '*' (which is not a valid character in a
               username).

           --ss
           --sseett
               Set or reset the password for _u_s_e_r_n_a_m_e, which must already
               exist in the password file. The enabled/disabled status is
               preserved unless overridden by a flag.

           --tteesstt _t_e_s_t_o_p
               Test an entry for one of several attributes and report the
               outcome through the program's exit status. The _t_e_s_t_o_p is one of
               the following keywords or abbreviated keywords:

               +o   _e_n_a_b_l_e_d, _e_n_a, _e_n

                   Return an exit status of 0 if an account for _u_s_e_r_n_a_m_e
                   exists _a_n_d is enabled, or 1 if it does not exist or is
                   disabled.

               +o   _e_x_i_s_t_s, _e_x

                   Return an exit status of 0 if an account for _u_s_e_r_n_a_m_e
                   exists, or 1 if it does not exist.

               +o   _d_a_t_a

                   Return an exit status of 0 if an account for _u_s_e_r_n_a_m_e
                   exists _a_n_d has private data, or 1 if it does not exist or
                   does not have private data. If an entry's private data is
                   the empty string, it is considered to have private data.

               +o   _d_i_s_a_b_l_e_d, _d_i_s

                   Return an exit status of 0 if an account for _u_s_e_r_n_a_m_e
                   exists _a_n_d is disabled, or 1 if it does not exist or is
                   enabled.

               --uu
               --uupp
               --uuppddaattee
                   Add _u_s_e_r_n_a_m_e to the password file or update an existing
                   entry for _u_s_e_r_n_a_m_e. By default, the user will be prompted
                   for the password, which must be retyped for confirmation.
                   If the entry exists, the enabled/disabled status is
                   preserved unless overridden by a flag.


           ----
               This flag signals the end of the flag arguments; a _u_s_e_r_n_a_m_e may
               follow, possibly beginning with a "--" character.

           Since only the administrator is allowed to use this command, no
           restrictions are imposed on the length or quality of the passwords
           that the administrator supplies; a warning message will be emitted,
           however, if the password is considered to be weak based on the
           PPAASSSSWWOORRDD__CCOONNSSTTRRAAIINNTTSS[16] directive that is configured.

EEXXAAMMPPLLEESS
       To list all of the accounts configured for the jurisdiction named
       EXAMPLE:

           % dacspasswd -uj EXAMPLE -list
           auggie
           bobo*
           booboo
           jj

       Note that the account for username bobo has been disabled.

       To re-enable bobo's account:

           % dacspasswd -uj EXAMPLE -ena bobo

       To test if bobo's account is enabled:

           % dacspasswd -uj EXAMPLE -test ena bobo
           % echo $status
           0

       To test if there are accounts for usernames booboo and bob:

           % dacspasswd -uj EXAMPLE -test exists booboo
           % echo $status
           0
           % dacspasswd -uj EXAMPLE -test exists bob
           % echo $status
           1

       To reset the password for username bobo interactively:

           % dacspasswd -uj EXAMPLE -set bobo
           New password for bobo?
           Re-type new password for bobo?

       Note that the password text is not displayed.

       To reset the password for username bobo using the program's standard
       input:

           % echo $newpasswd | dacspasswd -uj EXAMPLE -set -pf - bobo

       To create a new, disabled account for username bob and store the
       private data "On vacation":

           % dacspasswd -uj EXAMPLE -add -pf ./pwfile -dis -pds "On vacation" bob

       The password is read from the file ./pwfile.

       To get the private data for username bob:

           % set x=`dacspasswd -uj EXAMPLE -pdg bob`
           % echo "$x"
           On vacation


DDIIAAGGNNOOSSTTIICCSS
       The program exits 0 if everything was fine, and non-zero otherwise. A
       "false" outcome from the --tteesstt operation is reflected by an exit status
       of 1. An error condition is indicated by an exit status of 2.

BBUUGGSS
       That password information is not represented externally as an XML
       document tends to haunt your humble narrator. The format is subject to
       change.

SSEEEE AALLSSOO
       ddaaccss__ppaasssswwdd((88))[12], ddaaccssaauutthh((11))[14], ddaaccss__aauutthheennttiiccaattee((88))[17],
       ddaaccss__aaddmmiinn((88))[18], ddaaccss..ccoonnff((55))[19]

AAUUTTHHOORR
       Distributed Systems Software (wwwwww..ddssss..ccaa[20])

CCOOPPYYIINNGG
       Copyright (C) 2003-2011 Distributed Systems Software. See the
       LLIICCEENNSSEE[21] file that accompanies the distribution for licensing
       information.

NNOOTTEESS
        1. dacsoptions
           http://dacs.dss.ca/man/dacs.1.html#dacsoptions

        2. local_passwd_authenticate
           http://dacs.dss.ca/man/dacs_authenticate.8.html#local_passwd_authenticate

        3. local_simple_authenticate
           http://dacs.dss.ca/man/dacs_authenticate.8.html#local_simple_authenticate

        4. htpasswd(1)
           http://httpd.apache.org/docs/2.2/programs/htpasswd.html

        5. mod_auth
           http://httpd.apache.org/docs-2.0/mod/mod_auth.html

        6. mod_auth_dbm
           http://httpd.apache.org/docs-2.0/mod/mod_auth_dbm.html

        7. mod_auth_basic
           http://httpd.apache.org/docs-2.2/mod/mod_auth_basic.html

        8. mod_authn_dbm
           http://httpd.apache.org/docs-2.2/mod/mod_authn_dbm.html

        9. PASSWORD_DIGEST
           http://dacs.dss.ca/man/dacs.conf.5.html#PASSWORD_DIGEST

       10. PASSWORD_SALT_PREFIX
           http://dacs.dss.ca/man/dacs.conf.5.html#PASSWORD_SALT_PREFIX

       11. rainbow tables
           http://en.wikipedia.org/wiki/Rainbow_table

       12. dacs_passwd(8)
           http://dacs.dss.ca/man/dacs_passwd.8.html

       13. VFS
           http://dacs.dss.ca/man/dacs.conf.5.html#VFS

       14. dacsauth(1)
           http://dacs.dss.ca/man/dacsauth.1.html

       15. password()
           http://dacs.dss.ca/man/dacs.exprs.5.html#password

       16. PASSWORD_CONSTRAINTS
           http://dacs.dss.ca/man/dacs.conf.5.html#PASSWORD_CONSTRAINTS

       17. dacs_authenticate(8)
           http://dacs.dss.ca/man/dacs_authenticate.8.html

       18. dacs_admin(8)
           http://dacs.dss.ca/man/dacs_admin.8.html

       19. dacs.conf(5)
           http://dacs.dss.ca/man/dacs.conf.5.html

       20. www.dss.ca
           http://www.dss.ca

       21. LICENSE
           http://dacs.dss.ca/man/../misc/LICENSE



DACS 1.4.27                       01/16/2012                     DACSPASSWD(1)
