DACSRLINK(1)                 DACS Commands Manual                 DACSRLINK(1)



NNAAMMEE
       dacsrlink - create and administer rule links

SSYYNNOOPPSSIISS
       ddaaccssrrlliinnkk [ddaaccssooppttiioonnss[1]] _o_p [_a_r_g...]

DDEESSCCRRIIPPTTIIOONN
       This program is part of the DDAACCSS suite.

       The ddaaccssrrlliinnkk command is used to create and manage special URLs called
       Rlinks (_r_u_l_e _l_i_n_k_s). Basically, an Rlink is an ordinary URL that also
       includes a special component called an Rname that indirectly specifies
       a DDAACCSS access control rule that applies to the Rlink. Depending on the
       application, the creator of an Rlink may expect it to be kept secret by
       everyone he distributes it to. A given resource may have Rlinks with
       different Rnames "pointing to it". Rlinks are processed by ddaaccss__aaccss[2]
       during authorization checking.

       A DDAACCSS identity may be attached to an Rlink through the rlink and rname
       operations. When an Rlink with an attached identity is used, that
       identity is available to ddaaccss__aaccss[3] for access control purposes. There
       are two modes of attachment: direct and indirect. Identities for use
       with the direct mode are encrypted using the jurisdiction_keys item
       type (see ddaaccsskkeeyy((11))[4]); the program's user must therefore be able to
       read these keys. Changing these keys will invalidate all existing
       encrypted identities.

       The special, temporary credentials associated with an Rlink have the
       authentication style "rlink" (refer to uusseerr(())[5] with the style
       keyword), but not passwd, even if a password is required to gain access
       to a resource.

       There are many applications of Rlinks. Perhaps their main application
       is to provide identity-restricted access to a resource without having
       to create per-identity accounts. The identity associated with an Rlink
       need not exist outside of its use by the Rlink. When the Rlink is
       invoked (possibly accompanied by a password bound to the URL), the
       identity is available to the access control rule and an invoked web
       service just as if "real" DDAACCSS credentials had been used.

       ddaaccssrrlliinnkk can also be used as a simple front end for creating ordinary
       access control rules.

OOPPTTIIOONNSS
       ddaaccssrrlliinnkk recognizes the standard _d_a_c_s_o_p_t_i_o_n_s[1], which are followed by
       an operation name (_o_p), various operation-dependent flags, and finally
       non-flag arguments. The -- flag can be used to terminate the
       operation-dependent list of flags. Flags that are not recognized by the
       selected operation are ignored. A rule is always syntax checked (as by
       ddaaccssaaccll((11))[6]) before being written; if an error is found, the
       operation is aborted. Several flags are recognized by more than one
       operation.

       By default, the virtual filestore item type rlinks specifies where
       Rlinks are stored. This can be overridden for most operations by giving
       the --vvffss flag, which can specify a DDAACCSS URI, alternate item type, or
       absolute pathname.

           SSeeccuurriittyy
           Access to the rules and to listings of their names must be
           restricted, otherwise Rnames could be revealed. Only a DDAACCSS
           administer should be permitted to create, edit, delete, etc. rules.
           ddaaccss__aaccss must be able to access the rules if Rlinks are enabled.
           Ensure that file permissions are set appropriately.

       The optional --oouutt flag is followed by a filename to which the rule
       should be written instead of a filestore; if - is given, the standard
       output is used.

       The default alphabet used to generate Rnames can be overridden using
       the --rraallpphhaa flag; _a_l_p_h_a is a character specification in the syntax of
       ssttrrttrr(())[7] (e.g., "a-zA-Z0-9", which is the default). The default
       length of an Rname can be overridden using the --rrlleenn flag.
       Alternatively, some operations take a --rrnnaammee flag that specifies the
       Rname to use.

       The following _o_p arguments are understood:

           Perform a syntax check on the rule identified by _r_n_a_m_e to the
           standard output. If no error is found, an exit status of 0 is
           returned, otherwise an error message is produced and 1 is returned.

           Create a new link identical to _r_n_a_m_e but with a new Rname. If the
           --rrnnaammee flag is given, use _r_n_a_m_e as the Rname instead of generating
           one.

       [{--aa | --aallllooww}_n_a_m_e] [{--pp _p_a_s_s_w_o_r_d} | {--ppff _f_i_l_e}]...
       [--ppaallgg _a_l_g_-_n_a_m_e] [--rr _r_e_d_i_r_e_c_t_-_U_R_L] [--rrnnaammee _r_n_a_m_e] [--rraallpphhaa _a_l_p_h_a]
       [--rrlleenn _l_e_n]
       [--eexxppiirreess {_s_e_c_o_n_d_s | _d_a_t_e}] _p_a_t_h... .fam
           Create a new Rlink and either write it to the filestore, a
           specified file, or the standard output. The optional --aa (or --aallllooww)
           flag is followed by _n_a_m_e, which is a string that will become the
           argument to the uusseerr(())[8] function that will be called from the
           allow clause of the ACL that is created. Each _n_a_m_e will therefore
           be granted access to each of the named _p_a_t_h arguments, which are
           URI path components relative to the current jurisdiction.

           A password that applies only to this user can optionally follow as
           the next argument using a --pp or --ppff flag; its hashed value will be
           embedded in the Rlink and compared against a hash of an argument
           named _P_A_S_S_W_O_R_D that must be submitted with the Rlink. If a --pp or
           --ppff flag _p_r_e_c_e_d_e_s any --aa (--aallllooww) flag, however, it establishes a
           default password for all users specified _l_a_t_e_r on the command line.
           The --ppff flag is followed by a filename from which the password is
           read; if _f_i_l_e is "-", then the password is read from the standard
           input. A password may be specified even if no --aa flag is present;
           the request will not have an identity bound to it but a valid
           _P_A_S_S_W_O_R_D argument must be provided. The --ppaallgg flag overrides the
           default password hashing algorithm (see ppaasssswwoorrdd(())[9]).

           If the --rrnnaammee flag is given, _r_n_a_m_e is used as the Rname instead of
           generating one. The --eexxppiirreess assigns an expires_expr attribute to
           the Rlink, which will render the Rlink invalid after the specified
           date. The flag is followed either by an unsigned integer, which is
           interpreted as a number of seconds in the future, or a date in one
           of the rreeccooggnniizzeedd ffoorrmmaattss[10].

           If the --rr flag appears, no usernames can be specified. An attempt
           to access any of the resources associated with the Rlink will cause
           the client to be redirected to _r_e_d_i_r_e_c_t_-_U_R_L, which may contain a
           properly encoded query component. This lets an Rlink serve as a
           "short link", akin to the services provided by bbiitt..llyy[11],
           TTiinnyyUURRLL..ccoomm[12], MMeettaammaarrkk SShhoorrtteenn((TTMM)) SSeerrvviiccee[13], and many others.

               NNoottee
               Administrators should review the rule that is created. The
               sshhooww[14] operation can be used to display the rule and the
               eeddiitt[15] operation can be used to modify it.

           Delete the Rlink named _r_n_a_m_e in the selected filestore.

           Interactively edit a copy of the Rlink named _r_n_a_m_e in the selected
           filestore. If the environment variable EEDDIITTOORR is set, it is used as
           the name of the editor to use, otherwise the compile time symbol
           DEFAULT_EDITOR is used. When editing is completed, the Rlink is
           replaced with the edited copy, provided the new version is
           syntactically correct.

           Decode and print _r_n_a_m_e_-_i_d_e_n_t, an Rname with an identity component
           produced by the rrlliinnkk or rrnnaammee operations.

           Print a listing of all Rnames in the selected filestore.

           Emit an Rlink to the standard output that integrates _r_n_a_m_e into the
           _u_r_i according to _l_i_n_k_-_m_o_d_e. The _l_i_n_k_-_m_o_d_e is one of dacs_acs (or
           just acs), query, or path, representing the three general forms of
           an Rlink. If _i_d_e_n_t is specified, it describes a user in the ccoonncciissee
           uusseerr ssyynnttaaxx[16] that is associated with the link. The _i_d_e_n_t may
           include an expiry date.

           The --iimmooddee specifies whether a direct or indirect identity should
           be associated with the Rname, or whether there is none (the
           default). For direct, _i_d_e_n_t (specified by --ii or --iiddeenntt) is used; it
           describes an identity in the ccoonncciissee uusseerr ssyynnttaaxx[16] that is
           associated with the link. For the indirect mode, a random
           identifier is generated (using the same algorithm selected for
           Rnames); if the --iippttrr flag is given, however, _i_p_t_r is used as the
           identifier string.

           If _u_r_i is a URI path component (i.e., it begins with a '/'), the
           configuration variable _r_l_i_n_k___b_a_s_e___p_r_e_f_i_x must be defined; its value
           is prepended to the URI path.

           Additional query arguments can be attached to the emitted link. If
           a password is required by the ACL for the resource, for example, a
           _P_A_S_S_W_O_R_D argument is required.

           Implementation of query and path modes is incomplete, so URLs for
           those Rlinks must be generated manually.

       [--rrnnaammee _r_n_a_m_e] .fam
           This operation emits an Rname that satisfies the given constraints
           and prints it to the standard output. The Rname is suitable for use
           with the --rrnnaammee flag. It does not create an ACL. This operation
           might be useful when Rlinks are created manually or using another
           program.

           The --iimmooddee, --ii, and --iippttrr flags are as described for the rrlliinnkk
           operation.

           Display the rule identified by _r_n_a_m_e to the standard output.

EEXXAAMMPPLLEESS
       The following examples assume that the jurisdiction EXAMPLE includes
       the following configuration:

           RLINK '"${Args::RNAME:?}" /usr/local/dacs/rlinks'
           EVAL   ${Conf::rlink_base_prefix} = "https://www.example.com"
           VFS    "[rlinks]file:///usr/local/dacs/rlinks"

       These directives enable Rlink processing by ddaaccss__aaccss, and cause URLs
       generated by ddaaccssrrlliinnkk to be prefixed by https://www.example.com and
       ACLs that it creates to be stored as files in the
       /usr/local/dacs/rlinks directory.

       This command creates an Rname called IRCl7p4Q, and associates it with
       the relative URL /cgi-bin/dacs/dacs_prenv; the Rname will expire in 300
       seconds (relative to this jurisdiction's clock):

           % dacsrlink -uj EXAMPLE create -expires 300 /cgi-bin/dacs/dacs_prenv
           IRCl7p4Q

       Once an Rname has been created, a URL can be generated that
       incorporates the Rname:

           % dacsrlink -uj EXAMPLE rlink -lmode acs IRCl7p4Q /cgi-bin/dacs/dacs_prenv
           https://www.example.com/cgi-bin/dacs/dacs_prenv?DACS_ACS=-rname+IRCl7p4Q

       In this example, the Rname has been incorporated into the URL through
       the DDAACCSS__AACCSS aarrgguummeenntt[17].

       To display the ACL for Rname IRCl7p4Q:

           % dacsrlink -uj EXAMPLE show IRCl7p4Q
           <acl_rule status="enabled" name="IRCl7p4Q" expires_expr='time(now) ge 1178917167'>
             <services>
               <service url_pattern="/cgi-bin/dacs/dacs_prenv"/>
             </services>

             <rule order="allow,deny">
              <allow>
              </allow>
             </rule>
           </acl_rule>

       Or, since the access control rule created by ddaaccssrrlliinnkk can be found in
       /usr/local/dacs/rlinks:

           % cat /usr/local/dacs/rlinks/IRCl7p4Q

       The default rule for ddaaccss__pprreennvv restricts access to a DDAACCSS
       administrator, but anyone who uses this Rlink before it expires will be
       granted access to ddaaccss__pprreennvv. This rule can be manually customized at
       anytime. Note that unlike ordinary access control rules, there is no
       index file for Rlinks.

       This command creates a rule that applies to two resources and grants
       access to two users:

           % dacsrlink -uj EXAMPLE create -a :auggie -a :harley /private/a.html /private/b.html
           7tW3SJou
           % dacsrlink -uj EXAMPLE show 7tW3SJou
           <acl_rule status="enabled" name="7tW3SJou">
             <services>
                 <service url_pattern="/private/a.html"/>
                 <service url_pattern="/private/b.html"/>
             </services>
             <rule order="allow,deny">
              <allow>
                  user(":auggie")
              </allow>
              <allow>
                  user(":harley")
              </allow>
             </rule>
           </acl_rule>

       To generate URLs to give to these two users so that they can access
       these resource, commands like the following would be used:

           % dacsrlink -uj EXAMPLE rlink -imode direct -i ":auggie" -lmode acs 7tW3SJou /private/a.html
           https://www.example.com/private/a.html?DACS_ACS=-rname+7tW3SJou:HMGxWlccUihTtgbtJg
           % dacsrlink -uj EXAMPLE rlink -imode direct -i ":harley" -lmode acs 7tW3SJou /private/b.html
           https://www.example.com/private/b.html?DACS_ACS=-rname+7tW3SJou:qouYfT7pdwuLXHxodxE2

       When the first of these links is invoked, it will appear as if
       EXAMPLE:auggie is accessing a.html. Since no expiration was specified
       for the identities or the resources, the two links will be valid
       indefinitely. The rule can be deleted at any time:

           % dacsrlink -uj EXAMPLE delete 7tW3SJou

       This demonstrates how to create a password-controlled link:

           % dacsrlink -uj EXAMPLE create -a :auggie -p abracadabra /private/c.txt
           rIPZaJeN
           % dacsrlink -uj EXAMPLE show rIPZaJeN
           <acl_rule status="enabled" name="rIPZaJeN">
             <services>
                 <service url_pattern="/private/c.html"/>
             </services>
             <rule order="allow,deny">
              <allow>
                  user(":auggie")
                  and password(check, ${Args::PASSWORD}, "2|XYZZYnahdnl3VtLqGtpbW|2GoDncq34p2EMO4PA5Uj6iWkFb9")
              </allow>
             </rule>
           </acl_rule>
           % dacsrlink -uj EXAMPLE rlink -imode direct -i :auggie -lmode acs rIPZaJeN /private/c.txt
           https://www.example.com/private/c.txt?DACS_ACS=-rname+rIPZaJeN:r6RdcTcmUyhTtgbtJg
           % http "https://www.example.com/private/c.txt?DACS_ACS=-rname+rIPZaJeN:r6RdcTcmUyhTtgbtJg&PASSWORD=abracadabra"
           Hello, world


DDIIAAGGNNOOSSTTIICCSS
       The program exits 0 if everything was fine, 1 if an error occurred.

SSEEEE AALLSSOO
       ddaaccss..aaccllss((55))[18]

AAUUTTHHOORR
       Distributed Systems Software (wwwwww..ddssss..ccaa[19])

CCOOPPYYIINNGG
       Copyright (C) 2003-2011 Distributed Systems Software. See the
       LLIICCEENNSSEE[20] file that accompanies the distribution for licensing
       information.

NNOOTTEESS
        1. dacsoptions
           http://dacs.dss.ca/man/dacs.1.html#dacsoptions

        2. dacs_acs
           http://dacs.dss.ca/man/dacs_acs.8.html#rlinks

        3. dacs_acs
           http://dacs.dss.ca/man/dacs_acs.8.html

        4. dacskey(1)
           http://dacs.dss.ca/man/dacskey.1.html

        5. user()
           http://dacs.dss.ca/man/dacs.exprs.5.html#user.style

        6. dacsacl(1)
           http://dacs.dss.ca/man/dacsacl.1.html

        7. strtr()
           http://dacs.dss.ca/man/dacs.exprs.5.html#strtr

        8. user()
           http://dacs.dss.ca/man/dacs.exprs.5.html#user

        9. password()
           http://dacs.dss.ca/man/dacs.exprs.5.html#password

       10. recognized formats
           http://dacs.dss.ca/man/dacs.1.html#date_formats

       11. bit.ly
           http://bit.ly

       12. TinyURL.com
           http://tinyurl.com

       13. Metamark Shorten(TM) Service
           http://metamark.net

       14. show
           http://dacs.dss.ca/man/#show_op

       15. edit
           http://dacs.dss.ca/man/#edit_op

       16. concise user syntax
           http://dacs.dss.ca/man/dacs.1.html#concise_user_syntax

       17. DACS_ACS argument
           http://dacs.dss.ca/man/dacs_acs.8.html#dacs_acs_argument

       18. dacs.acls(5)
           http://dacs.dss.ca/man/dacs.acls.5.html

       19. www.dss.ca
           http://www.dss.ca

       20. LICENSE
           http://dacs.dss.ca/man/../misc/LICENSE



DACS 1.4.27                       01/16/2012                      DACSRLINK(1)
