DACSVFS(1)                   DACS Commands Manual                   DACSVFS(1)



NNAAMMEE
       dacsvfs - access objects through the DDAACCSS virtual filestore

SSYYNNOOPPSSIISS
       ddaaccssvvffss [ddaaccssooppttiioonnss[1]] [_i_t_e_m___t_y_p_e | _v_f_s___u_r_i | enabled] [--FF _s_e_p]
               [_o_p [_a_r_g...]]

DDEESSCCRRIIPPTTIIOONN
       This program is part of the DDAACCSS suite.

       The ddaaccssvvffss utility is an interface to the DDAACCSS virtual filestore. It
       provides a way to examine, change, and delete items independently of
       how and where they are stored. See ddaaccss..vvffss((55))[2] and the VVFFSS[3]
       directive for additional information.

       To perform a virtual filestore operation, either an _i_t_e_m___t_y_p_e or a URI
       argument must be provided to identify the filestore. The former is used
       to find the applicable VVFFSS[3] directive that has been configured for
       the specified jurisdiction (see ddaaccss..ccoonnff((55))[4]).

       As a special case, the word eennaabblleedd can be specified; a list of enabled
       store names is printed to stdout and the program terminates:

           % dacsvfs -q -uj SomeJurisdiction enabled

       This program is also available as a DDAACCSS web service, ddaaccss__vvffss((88))[5].

           SSeeccuurriittyy
           Only the DDAACCSS administrator should be able to successfully run this
           program. Because DDAACCSS keys and configuration files must be limited
           to the administrator, this will normally be the case, but a careful
           administrator will deny access to all other users.

OOPPTTIIOONNSS
       --FF _s_e_p
           Sets the field separator character to _s_e_p. The default is a colon.
           This is used by the load and dump operations.

       If present, the _o_p argument specifies the operation to be performed on
       the filestore. If it is omitted, the program enters interactive mode
       where most of the same operations are available (type "hheellpp" for
       assistance). The following operations are available:

       delete [_k_e_y]
           Delete the item, or the item identified by _k_e_y.

       dump
           Write to stdout the contents of the filestore as _k_e_y, followed by
           the field separator character, followed by _v_a_l_u_e, one pair per
           line.

       edit [_k_e_y]
           Interactively edit the item, or the value of the item identified by
           _k_e_y. When available, the environment variable EEDDIITTOORR is used to
           determine which editor to use, otherwise a default editor specified
           at compile time is used. After editing, the user is asked for
           confirmation. If the operation is not aborted, the item or its
           value will be updated.

       exists [_k_e_y]
           Test if the item, or the item identified by _k_e_y, exists. The
           outcome is reported to stdout.

       get [_k_e_y]
           Retrieve the item, or the value of the item identified by _k_e_y. If
           successful, the result is printed to stdout.

       getsize [_k_e_y]
           Determine the size of the item, or the size of the value of the
           item identified by _k_e_y. If successful, the result is printed to
           stdout.

       help
           Prints a usage summary to stderr.

       list
           Lists the names of all items (or keys) associated with the
           _i_t_e_m___t_y_p_e.

       load
           Read key/value pairs from stdin, one pair per line. The end of the
           key is denoted by the field separator character, which may be
           repeated. Whitespace may appear on either side of the field
           separator character (unless the field separator is a whitespace
           character). For each _k_e_y do a put operation with the specified
           _v_a_l_u_e. This is intended to be a quick way to initialize a filestore
           or make many changes.

       put [_k_e_y]
           Replace the item, or the value of the item identified by _k_e_y. The
           value is read from the standard input.

       putval _k_e_y _v_a_l_u_e
           Replace the item, or the value of the item identified by _k_e_y, and
           set it to _v_a_l_u_e.

       rename [_o_l_d_k_e_y] _n_e_w_k_e_y
           Rename the item, or the value of the item identified by _o_l_d_k_e_y to
           _n_e_w_k_e_y.

       update [_k_e_y]
           This is a synonym for the edit operation.

EEXXAAMMPPLLEESS
       To store the DTDs used by DDAACCSS in a database rather than in a
       collection of files, you must configure an appropriate VFS directive
       and copy the files from the DDAACCSS distribution into the database.
       Because it is read-only, this database can be shared by all federations
       and jurisdictions on the host.

       The first step is to select the type of database to use and decide
       where to put it. This example will use a Berkeley DB database (DDAACCSS
       must have been built with support for whichever database is used) and
       put it in /usr/local/dacs/federations/dtds.db. The URI to express this
       in the VFS syntax looks like this:

           [dtds]dacs-db:/usr/local/dacs/federations/dtds.db

       The next step is to create the database and load it with the DTDs. A
       simple shell script makes this easy to do. From the dtd-xsd directory
       of the DDAACCSS distribution, and replacing example.com with the URI of a
       DDAACCSS jurisdiction on your host, execute:

           #! /bin/sh

           for i in *.dtd
           do
             dacsvfs -u example.com -q \
                 '[dtds]dacs-db:/usr/local/dacs/federations/dtds.db' put $i < $i
           done

       To configure DDAACCSS to use the database, a VFS directive must be put in
       an appropriate place in dacs.conf so that it overrides the current
       configuration:

           VFS "[dtds]dacs-db:/usr/local/dacs/federations/dtds.db"

       To list the contents of the database you can do:

           % dacsvfs -u example.com -q \
               '[dtds]dacs-db:/usr/local/dacs/federations/dtds.db' list

       or since the VFS directive has been configured, simply:

           % dacsvfs -u example.com -q dtds list

       If you omit the --qq flag, various debugging output will appear,
       including some feedback that your new database is actually being used
       by DDAACCSS.

           NNoottee
           If you copy any DDAACCSS resources, such as its DTDs, remember that
           when you upgrade your DDAACCSS software you'll need to make new copies
           because these resources may have changed.

       Other resources used by DDAACCSS would be configured similarly. The load
       and dump operations can be particularly useful for this. If the file
       /tmp/roles associates roles with identities (e.g., as used by
       ddaaccsscchheecckk((11))[6]) as follows:

           bobo:users
           auggie:admin,users
           harley:guest

       then the following command initializes or updates a database from that
       file:

           % dacsvfs -u example.com -q -F ":" \
               '[myroles]dacs-db:/usr/local/myapp/roles.db' < /tmp/roles

       The URI [myroles]dacs-db:/usr/local/myapp/roles.db can then be used
       with ddaaccsscchheecckk.

DDIIAAGGNNOOSSTTIICCSS
       The program exits 0 if everything was fine, 1 if an error occurred.

BBUUGGSS
       There should be a caching mechanism that could be used with expensive
       storage types (i.e., those that are relatively slow to access, such as
       the http scheme).

SSEEEE AALLSSOO
       ddaaccss__vvffss((88))[5], ddaaccss..ccoonnff((55))[4]

AAUUTTHHOORR
       Distributed Systems Software (wwwwww..ddssss..ccaa[7])

CCOOPPYYIINNGG
       Copyright (C) 2003-2011 Distributed Systems Software. See the
       LLIICCEENNSSEE[8] file that accompanies the distribution for licensing
       information.

NNOOTTEESS
        1. dacsoptions
           http://dacs.dss.ca/man/dacs.1.html#dacsoptions

        2. dacs.vfs(5)
           http://dacs.dss.ca/man/dacs.vfs.5.html

        3. VFS
           http://dacs.dss.ca/man/dacs.conf.5.html#VFS

        4. dacs.conf(5)
           http://dacs.dss.ca/man/dacs.conf.5.html

        5. dacs_vfs(8)
           http://dacs.dss.ca/man/dacs_vfs.8.html

        6. dacscheck(1)
           http://dacs.dss.ca/man/dacscheck.1.html

        7. www.dss.ca
           http://www.dss.ca

        8. LICENSE
           http://dacs.dss.ca/man/../misc/LICENSE



DACS 1.4.27                       01/16/2012                        DACSVFS(1)
