# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.


__maintainer__ = 'Lionel Martin <lionel@fluendo.com>'
__maintainer2__ = 'Florian Boucault <florian@fluendo.com>'

import pygtk
pygtk.require('2.0')
import gtk, gtk.glade

from elisa.base_components.context import Context
from elisa.core import common

class GladeContext(Context):

    def initialize(self):
        Context.initialize(self)
        glade_file = self.plugin.get_resource_file('test_helper.glade')
        self.glade_tree = gtk.glade.XML(glade_file)
        window = self.glade_tree.get_widget("MainWindow")
        self.viewport_handle = window
        window.connect("delete_event", self._delete_event)

    def _delete_event(self, widget, event, data=None):
        common.application.stop()
