# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.

from shaded_list_view import ListItem
from elisa.core import common

class DetailedListItem(ListItem):

    def load(self):
        super(DetailedListItem, self).load()

        text_width = self.description.width
        text_height = self.height/1.6
        text_x = self.description.x
        text_y = self.height - text_height

        self._sub_description = self._create_text()
        self.add(self._sub_description)
        self._sub_description.fg_color = (150, 150, 150, 255)
        self._sub_description.bg_color = (0, 0, 255, 0)
        self._sub_description.visible = True
        self._sub_description.font_height = 1.0

        self._description.font_height = 1.0
        self._description.height = text_height

        self._sub_description.position = (text_x, text_y, 0)
        self._sub_description.size = (text_width, text_height)

    def unload(self):
        super(DetailedListItem, self).unload()
        self.remove(self._sub_description)

    def sub_description__set(self, text):
        self._sub_description.label = text

    def sub_description__get(self):
        return self._sub_description
    
plugin_registry = common.application.plugin_registry
ShadedListView = plugin_registry.get_component_class('raval:shaded_list_view')

class DetailedShadedListView(ShadedListView):

    def create_item(self, model):
        widget = DetailedListItem()
        return widget

    def load_item(self, index):
        model = self.controller.model[index]
        widget = self[index]

        widget.load()

        self.load_from_theme(model.theme_icon, widget.thumbnail)

        text = self.frontend.translate_text(model.text)
        sub_text = self.frontend.translate_text(model.sub_text)
        widget.description = text
        widget.sub_description = sub_text

        def error_eater(error):
            # We don't want to show a warning to the user, if the thumbnailing
            # errors. We simply don't do anything in that case.
            self.debug("Eating error: %s" % error.getBriefTraceback())
            return None

        uri = model.thumbnail_source
        if uri != None:
            dfr = self._model_thumbnail_to_image(model, widget.thumbnail)
            dfr.addErrback(error_eater)

    def unload_item(self, widget):
        widget.unload()

    def element_attribute_set(self, position, key, old_value, new_value):
        super(DetailedShadedListView, self).element_attribute_set(position, key,
                                                                  old_value,
                                                                  new_value)
        if key == "sub_text":
            subtext = self.frontend.translate_text(new_value)
            self[position].sub_description = subtext
