# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.

import pgm
from pgm.graph.text import Text
from dock import Dock

class VolumeOsd(Dock):

    def __init__(self, canvas, layer, template,
                 width, height, background_image):

        Dock.__init__(self, canvas, layer, width, height, background_image)

        self._template = template
        self._volume_value = 0
        
        inner_width = width * 0.95
        inner_height = height * 0.45
        inner_x = (width - inner_width) / 2.0
        inner_y = (height - inner_height) / 2.0

        self._volume = Text()
        self._volume.label = ""
        self._volume.ellipsize = pgm.TEXT_ELLIPSIZE_END
        self._volume.fg_color = (220, 220, 220, 255)
        self._volume.bg_color = (0, 0, 0, 0)
        self.add(self._volume)
        self._volume.position = (inner_x, inner_y, 0.0)
        self._volume.size = (inner_width, inner_height)

        self._volume.visible = True
        
    def volume__set(self, value):
        self._volume_value = value
        self._volume.label = self._template % int(value)

    def volume__get(self):
        return self._volume_value
