#!/usr/bin/env python
# -*- coding: utf-8 -*-

# Copyright (c) 2007 - 2008 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Eric4 Plugin Installer

This is the main Python script to install eric4 plugins from outside of the IDE.
"""

import sys

if "--nokde" in sys.argv:
    del sys.argv[sys.argv.index("--nokde")]
    os.environ["e4nokde"] = "1"

from Utilities import Startup

import PluginManager


def createMainWidget(argv):
    """
    Function to create the main widget.
    
    @param argv list of commandline parameters (list of strings)
    @return reference to the main widget (QWidget)
    """
    from PluginManager.PluginRepositoryDialog import PluginRepositoryDialog
    return PluginRepositoryDialog(None)

def main():
    """
    Main entry point into the application.
    """
    options = [\
        ("--nokde" , "don't use KDE widgets"),
    ]
    appinfo = Startup.makeAppInfo(sys.argv,
                                  "Eric4 Plugin Repository",
                                  "",
                                  "Utility to show the contents of the eric4"
                                  " Plugin repository.",
                                  options)
    res = Startup.simpleAppStartup(sys.argv,
                                   appinfo,
                                   createMainWidget)
    sys.exit(res)

if __name__ == '__main__':
    main()
