#!/usr/bin/env python
#############################################################################
# Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1997, 1998, 1999
# All Rights Reserved.
#
# The software contained on this media is the property of the DSTC Pty
# Ltd.  Use of this software is strictly in accordance with the
# license agreement in the accompanying LICENSE.HTML file.  If your
# distribution of this software does not contain a LICENSE.HTML file
# then you have no rights to use this software in any manner and
# should contact DSTC at the address below to determine an appropriate
# licensing arrangement.
# 
#      DSTC Pty Ltd
#      Level 7, GP South
#      Staff House Road
#      University of Queensland
#      St Lucia, 4072
#      Australia
#      Tel: +61 7 3365 4310
#      Fax: +61 7 3365 4311
#      Email: enquiries@dstc.edu.au
# 
# This software is being provided "AS IS" without warranty of any
# kind.  In no event shall DSTC Pty Ltd be liable for damage of any
# kind arising out of or in connection with the use or performance of
# this software.
#
# Project:      Fnorb
# File:         $Source: /cvsroot/fnorb/fnorb/orb/IIOPProtocol.py,v $
# Version:      @(#)$RCSfile: IIOPProtocol.py,v $ $Revision: 1.10 $
#
#############################################################################
""" IIOP Protocol module. """


# Fnorb modules.
import CORBA, IIOP, IOP, Nudger, Protocol, Reactor

# IIOP protocol modules.
import IIOPAcceptor, IIOPConnection


class IIOPProtocol(Protocol.Protocol):
    """ IIOP Protocol. """

    #########################################################################
    # Protocol interface.
    #########################################################################

    def enable(self, host, port):
	""" Create an endpoint for connection requests. """

	# Create/initialise a reactor.
	self.__reactor = Reactor.Reactor_init()

	# Create an acceptor to listen for client connection requests.
	self.__acceptor = IIOPAcceptor.IIOPAcceptor((host, port))

	# Create a nudger.
	self.__nudger = Nudger.Nudger()

	return

    def disable(self):
	""" Destroy the endpoint that is listening for connection requests. """

	pass

    def start(self, timeout=0):
	""" Start the protocol event loop. """

	# Start the reactor's event loop.
	self.__reactor.start_event_loop(timeout)

	return

    def stop(self):
	""" Stop the protocol event loop. """

	# Stop the reactor's event loop.
	self.__reactor.stop_event_loop()

	# Give the reactor a nudge so that it can realise that it has been
	# stopped!
	self.__nudger.nudge()

	return

    def create_connection(self):
	""" Create a connection. """

	return IIOPConnection.IIOPConnection()

    def create_profile(self, id, components):
	""" Create an IOR profile for the protocol. """

	# Get the host and port number of the acceptor.
	(host, port) = self.__acceptor.address()
	
	# Create an IIOP tagged profile.
	version = IIOP.Version(1, 2)
	profile_body = IIOP.ProfileBody_1_1(version,
                                            host, port,
                                            id,
                                            components)
	profile = IOP.TaggedProfile(IOP.TAG_INTERNET_IOP, profile_body)

	return profile

    def get_object_key(self, ior):
	""" Extract the object key from an IOR. """

	try:
	    # If the object reference does NOT contain an IIOP profile, then
	    # this call will raise an 'INV_OBJREF' exception.
	    object_key = ior._fnorb_iiop_profile().object_key

	except CORBA.INV_OBJREF:
	    object_key = None

	return object_key

    def get_address(self, ior):
	""" Extract the address from an IOR. """

	try:
	    # If the object reference does NOT contain an IIOP profile, then
	    # this call will raise an 'INV_OBJREF' exception.
	    iiop_profile = ior._fnorb_iiop_profile()
	    address = (iiop_profile.host, iiop_profile.port)

	except CORBA.INV_OBJREF:
	    address = None

	return address

    def get_giop_version(self, ior):
	""" Extract the GIOP version from an IOR. """

	try:
	    # If the object reference does NOT contain an IIOP profile, then
	    # this call will raise an 'INV_OBJREF' exception.
	    iiop_profile = ior._fnorb_iiop_profile()

	except CORBA.INV_OBJREF:
	    address = None

	return iiop_profile.iiop_version

    def is_local(self, ior):
	""" Does the IOR reference an object in *this* ORB? """

	try:
	    # If the object reference does NOT contain an IIOP profile, then
	    # this call will raise an 'INV_OBJREF' exception.
	    iiop_profile = ior._fnorb_iiop_profile()

	    # Get the host and port number of the acceptor.
	    (host, port) = self.__acceptor.address()

	    # Is the object in *this* ORB?
	    result = (iiop_profile.host == host and iiop_profile.port == port)

	except CORBA.INV_OBJREF:
	    result = 0
		
	return result

#############################################################################
