# tests/test_user.py
#
#

__copyright__ = 'this file is in the public domain'

from gozerbot.bot import Bot
from gozerbot.generic import stringinlist, waitforqueue
from gozerbot.plugins import plugins
from gozerbot.config import config
import unittest

if config['dbenable']:
    plugins.reload('gozerplugs.dbplugs', 'user')
else:
    plugins.reload('gozerplugs.plugs', 'user')

class test_user(unittest.TestCase):
    b = Bot()
    b.userhosts['test'] = 'test@test'
    b.userhosts['test2'] = 'test@test'
    b.userhosts['ttest'] = 'ttest@ttest'
    b.userhosts['notest'] = 'notest@notest'
    
    def test_userallperm(self):
        result = self.b.test('user-allperm')
        self.assert_(stringinlist('<perm>', result))

    def test_userallperm2(self):
        result = self.b.test('user-allperm oper')
        self.assert_(stringinlist('test', result))

    def test_userallperm3(self):
        result = self.b.test('user-allperm blamekker')
        self.assert_(stringinlist('no users', result))

    def test_userallstatus(self):
        result = self.b.test('user-allstatus')
        self.assert_(stringinlist('<status>', result))

    def test_userallstatus2(self):
        self.b.test('user-addstatus test #dunkbots')
        result = self.b.test('user-allstatus #dunkbots')
        self.b.test('user-delstatus test #dunkbots')
        self.assert_(stringinlist('test', result))

    def test_userallstatus3(self):
        result = self.b.test('user-allstatus bla')
        self.assert_(stringinlist('no users', result))

    def test_usermeet(self):
        result = self.b.test('user-meet')
        self.assert_(stringinlist('<nick>', result))

    def test_usermeet2(self):
        result = self.b.test('user-meet test')
        self.assert_(stringinlist('already', result))

    def test_usermeet3(self):
        result = self.b.test('user-meet test2')
        self.assert_(stringinlist("we already have", result))

    def test_usermeet4(self):
        result = self.b.test('user-meet ttest')
        self.b.test("user-del ttest")
        self.assert_(stringinlist("added to user database", result))

    def test_useradd(self):
        result = self.b.test('user-add')
        self.assert_(stringinlist('<name> <userhost>', result))

    def test_useradd2(self):
        result = self.b.test('user-add test test@test')
        self.assert_(stringinlist('already', result))

    def test_useradd3(self):
        self.b.test('user-del test3')
        result = self.b.test('user-add test3 test3@test')
        self.b.test('user-del test3')
        self.assert_(stringinlist("added", result))

    def test_usermerge(self):
        result = self.b.test('user-merge')
        self.assert_(stringinlist('<name> <nick>', result))

    def test_usermerge2(self):
        result = self.b.test('user-merge test4 test2')
        self.assert_(stringinlist('we have no', result))

    def test_usermerge3(self):
        result = self.b.test('user-merge test test3')
        self.assert_(stringinlist("can't", result))

    def test_usermerge4(self):
        result = self.b.test('user-merge test test')
        self.assert_(stringinlist("we already", result))

    def test_usermerge5(self):
        result = self.b.test('user-merge test ttest')
        self.b.test('user-deluserhost test ttest@ttest')
        self.assert_(stringinlist("merged", result))

    def test_userdel(self):
        result = self.b.test('user-del')
        self.assert_(stringinlist('<name>', result))

    def test_userdel2(self):
        result = self.b.test('user-del owner')
        self.assert_(stringinlist("can't delete", result))

    def test_userdel3(self):
        self.b.test('user-add test5 test5@test5')
        result = self.b.test('user-del test5')
        self.assert_(stringinlist("deleted", result))

    def test_userus(self):
        result = self.b.test('user-scan')
        self.assert_(stringinlist('<txt>', result))

    def test_userus2(self):
        result = self.b.test('user-scan te')
        self.assert_(stringinlist('test', result))

    def test_userus3(self):
        result = self.b.test('user-scan temektest')
        self.assert_(stringinlist('no users', result))

    def test_usernames(self):
        result = self.b.test('user-names')
        self.assert_(stringinlist('test', result))

    def test_username(self):
        result = self.b.test('user-name')
        self.assert_(stringinlist('test', result))

    def test_getname(self):
        result = self.b.test('user-getname')
        self.assert_(stringinlist('<nick>', result))

    def test_getname2(self):
        result = self.b.test('user-getname mekkermieptest')
        self.assert_(stringinlist('userhost', result))

    def test_getname3(self):
        result = self.b.test('user-getname ttest')
        self.assert_(stringinlist("can't find", result))

    def test_getname4(self):
        result = self.b.test('user-getname test')
        self.assert_(stringinlist('test', result))

    def test_addperm(self):
        result = self.b.test('user-addperm')
        self.assert_(stringinlist('<name> <perm>', result))

    def test_addperm2(self):
        result = self.b.test('user-addperm mekkermieptest bla')
        self.assert_(stringinlist("can't find", result))

    def test_addperm3(self):
        result = self.b.test('user-addperm test user')
        self.assert_(stringinlist('already', result))

    def test_addperm4(self):
        self.b.test('user-delperm test bla')
        result = self.b.test('user-addperm test bla')
        self.b.test('user-delperm test bla')
        self.assert_(stringinlist('perm added', result))

    def test_getperms(self):
        result = self.b.test('user-getperms')
        self.assert_(stringinlist('<name>', result))

    def test_addgetperms2(self):
        result = self.b.test('user-getperms mekkermieptest')
        self.assert_(stringinlist("can't find", result))

    def test_addgetperms3(self):
        result = self.b.test('user-getperms test')
        self.assert_(stringinlist('USER', result))

    def test_perms(self):
        result = self.b.test('user-perms mekker')
        self.assert_(stringinlist('use', result))

    def test_perms2(self):
        result = self.b.test('user-perms')
        self.assert_(stringinlist("USER", result))

    def test_delperm(self):
        result = self.b.test('user-delperm')
        self.assert_(stringinlist('<name> <perm>', result))

    def test_delperm2(self):
        result = self.b.test('user-delperm mekkermieptest bla')
        self.assert_(stringinlist("can't find", result))

    def test_delperm3(self):
        result = self.b.test('user-delperm test BLAMEKKER')
        self.assert_(stringinlist('has no', result))

    def test_delperm4(self):
        self.b.test('user-addperm test BLA')
        result = self.b.test('user-delperm test BLA')
        self.assert_(stringinlist('perm removed', result))

    def test_addpermall(self):
        result = self.b.test('user-addpermall')
        self.assert_(stringinlist('<perm>', result))

    def test_addpermall2(self):
        result = self.b.test('user-addpermall oper')
        self.assert_(stringinlist("can't add", result))

    def test_addpermall3(self):
        result = self.b.test('user-addpermall BLA')
        self.b.test('user-delpermall BLA')
        self.assert_(stringinlist('perm added', result))

    def test_delpermall(self):
        result = self.b.test('user-delpermall')
        self.assert_(stringinlist('<perm>', result))

    def test_delpermall2(self):
        result = self.b.test('user-delpermall oper')
        self.assert_(stringinlist("can't delete", result))

    def test_delpermall3(self):
        self.b.test('user-addpermall bla')
        result = self.b.test('user-delpermall BLA')
        self.assert_(stringinlist('perm deleted', result))

    def test_addstatus(self):
        result = self.b.test('user-addstatus')
        self.assert_(stringinlist('<name> <status>', result))

    def test_addstatus2(self):
        result = self.b.test('user-addstatus blamekkertest bla')
        self.assert_(stringinlist("can't find", result))

    def test_addstatus3(self):
        self.b.test('user-addstatus test bla')
        result = self.b.test('user-addstatus test bla')
        self.b.test('user-delstatus test bla')
        self.assert_(stringinlist("already", result))

    def test_addstatus4(self):
        self.b.test('user-delstatus test bla')
        result = self.b.test('user-addstatus test bla')
        self.b.test('user-delstatus test bla')
        self.assert_(stringinlist("status added", result))

    def test_delstatus(self):
        result = self.b.test('user-delstatus')
        self.assert_(stringinlist('<name> <status>', result))

    def test_delstatus2(self):
        result = self.b.test('user-delstatus blamekkertest bla')
        self.assert_(stringinlist("can't find", result))

    def test_delstatus3(self):
        self.b.test('user-delstatus test bla')
        result = self.b.test('user-delstatus test bla')
        self.assert_(stringinlist("has no", result))

    def test_delstatus4(self):
        self.b.test('user-addstatus test bla')
        result = self.b.test('user-delstatus test bla')
        self.assert_(stringinlist("status deleted", result))

    def test_getstatus(self):
        result = self.b.test('user-getstatus')
        self.assert_(stringinlist('<name>', result))

    def test_getstatus2(self):
        result = self.b.test('user-getstatus blamekkertest')
        self.assert_(stringinlist("can't find", result))

    def test_getstatus3(self):
        self.b.test('user-delstatus test bla')
        result = self.b.test('user-getstatus test')
        self.assert_(stringinlist("no status set", result))

    def test_getstatus4(self):
        self.b.test('user-addstatus test bla')
        result = self.b.test('user-getstatus test')
        self.b.test('user-delstatus test bla')
        self.assert_(stringinlist("BLA", result))

    def test_status(self):
        self.b.test('user-delstatus test bla')
        result = self.b.test('user-status')
        self.assert_(stringinlist('no status set', result))

    def test_status2(self):
        self.b.test('user-addstatus test bla')
        result = self.b.test('user-status')
        self.b.test('user-delstatus test bla')
        self.assert_(stringinlist("BLA", result))

    def test_adduserhost(self):
        result = self.b.test('user-adduserhost')
        self.assert_(stringinlist('<name> <userhost>', result))

    def test_addsuserhost2(self):
        result = self.b.test('user-adduserhost blamekkertest bla')
        self.assert_(stringinlist("can't find", result))

    def test_adduserhost3(self):
        self.b.test('user-adduserhost test bla@bla')
        result = self.b.test('user-adduserhost test bla@bla')
        self.b.test('user-deluserhost test bla@bla')
        self.assert_(stringinlist("already", result))

    def test_adduserhost4(self):
        self.b.test('user-deluserhost test bla@bla')
        result = self.b.test('user-adduserhost test bla@bla')
        self.b.test('user-deluserhost test bla@bla')
        self.assert_(stringinlist("userhost added", result))

    def test_deluserhost(self):
        result = self.b.test('user-deluserhost')
        self.assert_(stringinlist('<name> <userhost>', result))

    def test_deluserhost2(self):
        result = self.b.test('user-deluserhost blamekkertest bla')
        self.assert_(stringinlist("can't find", result))

    def test_deluserhost3(self):
        self.b.test('user-deluserhost test bla@bla')
        result = self.b.test('user-deluserhost test bla@bla')
        self.assert_(stringinlist("has no", result))

    def test_deluserhost4(self):
        self.b.test('user-adduserhost test bla@bla')
        result = self.b.test('user-deluserhost test bla@bla')
        self.assert_(stringinlist("userhost removed", result))

    def test_getuserhosts(self):
        result = self.b.test('user-getuserhosts')
        self.assert_(stringinlist('<name>', result))

    def test_getuserhosts2(self):
        result = self.b.test('user-getuserhosts blamekkertest')
        self.assert_(stringinlist("can't find", result))

    def test_getuserhosts3(self):
        self.b.test('user-adduserhost test bla@bla')
        result = self.b.test('user-getuserhosts test')
        self.b.test('user-deluserhosts test bla@bla')
        self.assert_(stringinlist("bla@bla", result))

    def test_userhosts(self):
        result = self.b.test('user-userhosts')
        self.assert_(stringinlist("test@test", result))

    def test_getemail(self):
        result = self.b.test('user-getemail')
        self.assert_(stringinlist("<name>", result))

    def test_getemail2(self):
        result = self.b.test('user-getemail blamekkertest')
        self.assert_(stringinlist("can't find", result))

    def test_getemail3(self):
        self.b.test('user-delemail')
        result = self.b.test('user-getemail test')
        self.assert_(stringinlist("no email set", result))

    def test_getemail4(self):
        self.b.test('user-delemail')
        self.b.test('user-setemail test test@test')
        result = self.b.test('user-getemail test')
        self.b.test('user-delemail')
        self.assert_(stringinlist("test@test", result))

    def test_setemail(self):
        result = self.b.test('user-setemail')
        self.assert_(stringinlist("<name> <email>", result))

    def test_setemail2(self):
        result = self.b.test('user-setemail blamekkertest test@test')
        self.assert_(stringinlist("can't find", result))

    def test_setemail3(self):
        result = self.b.test('user-setemail test test@test')
        self.b.test('user-delemail')
        self.assert_(stringinlist("email set", result))

    def test_email(self):
        result = self.b.test('user-email blamekkertest')
        self.assert_(stringinlist("use getemail", result))

    def test_email2(self):
        self.b.test('user-delemail')
        result = self.b.test('user-email')
        self.assert_(stringinlist("no email set", result))

    def test_email3(self):
        self.b.test('user-delemail')
        self.b.test('user-setemail test test@test')
        result = self.b.test('user-email')
        self.b.test('user-delemail')
        self.assert_(stringinlist("test@test", result))

    def test_delemail(self):
        self.b.test('user-setemail test test@test')
        result = self.b.test('user-delemail')
        self.assert_(stringinlist("email removed", result))

    def test_usermatch(self):
        result = self.b.test('user-match')
        self.assert_(stringinlist("<userhost>", result))

    def test_usermatch2(self):
        result = self.b.test('user-match blamekkertest@test')
        self.assert_(stringinlist("can't find", result))

    def test_usermatch3(self):
        result = self.b.test('user-match test@test')
        self.assert_(stringinlist("userrecord", result))

    def test_usercheck(self):
        result = self.b.test('user-check')
        self.assert_(stringinlist("<nick>", result))

    def test_usercheck2(self):
        result = self.b.test('user-check blamekkertest')
        self.assert_(stringinlist("can't find", result))

    def test_usercheck3(self):
        result = self.b.test('user-check notest')
        self.assert_(stringinlist("can't find", result))

    def test_usercheck4(self):
        result = self.b.test('user-check test')
        self.assert_(stringinlist("userrecord", result))

    def test_addpermit(self):
        result = self.b.test('user-addpermit')
        self.assert_(stringinlist("<name> <permit>", result))

    def test_addpermit2(self):
        result = self.b.test('user-addpermit blamekkertest bla')
        self.assert_(stringinlist("can't find", result))

    def test_addpermit3(self):
        result = self.b.test('user-addpermit test bla')
        self.b.test('user-delpermit test bla')
        self.assert_(stringinlist("permit added", result))

    def test_addpermit4(self):
        self.b.test('user-addpermit test bla')
        result = self.b.test('user-addpermit test bla')
        self.b.test('user-delpermit test bla')
        self.assert_(stringinlist("already allowed", result))

    def test_permit(self):
        result = self.b.test('user-permit tes22t')
        self.assert_(stringinlist("use the user-addpermit command", result))

    def test_permit2(self):
        result = self.b.test('user-permit')
        self.assert_(stringinlist("you don't", result))

    def test_permit3(self):
        self.b.test('user-addpermit test bla')
        result = self.b.test('user-permit')
        self.b.test('user-delpermit test bla')
        self.assert_(stringinlist("test", result))

    def test_delpermit(self):
        result = self.b.test('user-delpermit')
        self.assert_(stringinlist("<name> <what>", result))

    def test_delpermit2(self):
        result = self.b.test('user-delpermit blamekkertest bla')
        self.assert_(stringinlist("can't find", result))

    def test_delpermit3(self):
        self.b.test('user-addpermit test bla')
        result = self.b.test('user-delpermit test bla')
        self.assert_(stringinlist("denied", result))

    def test_delpermit4(self):
        self.b.test('user-delpermit test bla')
        result = self.b.test('user-delpermit test bla')
        self.assert_(stringinlist("already not allowed", result))

    def test_usersearch(self):
        result = self.b.test('user-search')
        self.assert_(stringinlist("<what>", result))

    def test_usersearch2(self):
        result = self.b.test('user-search blamekkertest')
        self.assert_(stringinlist("no userhost", result))

    def test_usersearch3(self):
        result = self.b.test('user-search tes')
        self.assert_(stringinlist("test", result))
