/* Compile with "gcc -o icausers.exe -mno-cygwin icausers.c" */

#include <string.h>
#include <stdio.h>
#include <time.h>
#include <stdlib.h>

int main(int argc, char *argv[])
{

    time_t now;
    char nows[30];
    char host[65];
    char *color;
    int usercount;

    char *lookfor = " Active ";
    int limitwarn = 60; 
    int limitpanic = 65;

    char outbuf[8000];
    char l[512];


    /* Get parameters: lookfor warncount paniccount */
    if (argc > 3) {
        limitpanic = atoi(argv[3]);
    }
    if (argc > 2) {
        limitwarn = atoi(argv[2]);
    }
    if (argc > 1) {
        lookfor = argv[1];
    }

    usercount = 0; outbuf[0] = '\0';
    while (fgets(l, sizeof(l)-1, stdin)) {
        if (strstr(l, lookfor)) usercount++;
        if ((strlen(outbuf) + strlen(l)) < sizeof(outbuf)) strcat(outbuf, l);
    }

    if (usercount > limitpanic) {
        color = "red";
    }
    else if (usercount > limitwarn) {
        color = "yellow";
    }
    else {
        color = "green";
    }
    
    now = time(NULL);
    strcpy(nows, ctime(&now)); nows[strlen(nows)-1] = '\0';

    /* Get this machine's name.  Convert to FQDN if requested. */
    /* gethostname((char*)&host, sizeof(host)); */

    printf("%s %s [%s]\n\n", color, nows, "");
    printf("%s\n", outbuf);
    printf("\n%d users active\n", usercount);

    return 0;
}

