<?php
/* This file is part of JFFNMS
 * Copyright (C) <2002-2005> Javier Szyszlican <javier@szysz.com>
 * This program is licensed under the GNU GPL, full terms in the LICENSE file
 */

function poller_verify_interface_number ($options)
{
  static $static_buffer = array();

  $current_ifindex = $options['interfacenumber'];

  //Search by Interface Name (ie. Switches or not IP interfaces)
  if (($options['address']=='') && ($options['interfacenumber']!='')) // if IP is empty and it has a interfacenumber in the DB
  {
    if (!array_key_exists('ifIndex', $static_buffer) && $options['ro_community'])
    { //Get the Tables via SNMP only once
  
      $ifIndex_oid = '.1.3.6.1.2.1.2.2.1.1';
      $static_buffer['ifIndex'] = snmp_walk($options['host_ip'],$options['ro_community'],$ifIndex_oid);
      include_once(jffnms_shared('catos'));        //Load CatOS code
      if (is_catos($options['host_ip'], $options['ro_community']))  //If this host is CatOS
        $ifDescr_oid = CATOS_IFDESCR_OID;
      else
        $ifDescr_oid = '.1.3.6.1.2.1.2.2.1.2';        //Use the Standard IF-MIB OID
      $static_buffer['ifDescr'] = snmp_walk($options['host_ip'],$options['ro_community'],$ifDescr_oid);
    }
    if (is_array($static_buffer['ifDescr']))
    {
      $pos = array_search($options['interface'],$static_buffer['ifDescr']);  //Find the DB interface name and return the index
      if (is_numeric($pos))            //if we found something
        $current_ifindex = $static_buffer['ifIndex'][$pos];      //return the ifIndex at the same position we found this
    }
  } else //Search by IP Address
    if (strpos($options['address'],'.') === FALSE)   // if the address is not an IP, use that as the IfIndex
    {
      $current_ifindex = $options['address'];
    } else                       //If its an IP Address
      if (!empty($options['ro_community']))            //and has SNMP
       $current_ifindex = snmp_get($options['host_ip'],$options['ro_community'],   //Get the interface index
        '.1.3.6.1.2.1.4.20.1.2.'.$options['address']);          //by looking up the IP
  return $current_ifindex;
}
?>
