/*--------------------------------------------------------------------------+
$Id: SmokeTestlet.java 26285 2010-02-18 11:22:54Z juergens $
|                                                                          |
| Copyright 2005-2010 Technische Universitaet Muenchen                     |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package edu.tum.cs.simulink.smoke;

import java.util.IdentityHashMap;

import org.junit.Ignore;

import edu.tum.cs.commons.collections.CollectionUtils;
import edu.tum.cs.commons.collections.IdentityHashSet;
import edu.tum.cs.commons.error.NeverThrownRuntimeException;
import edu.tum.cs.commons.logging.SimpleLogger;
import edu.tum.cs.commons.test.DeepCloneTestUtils;
import edu.tum.cs.commons.test.TestletBase;
import edu.tum.cs.commons.visitor.IVisitor;
import edu.tum.cs.commons.visitor.VisitorUtils;
import edu.tum.cs.simulink.builder.SimulinkModelBuilder;
import edu.tum.cs.simulink.constraints.SimulinkConstraints;
import edu.tum.cs.simulink.model.ParameterizedElement;
import edu.tum.cs.simulink.model.SimulinkModel;
import edu.tum.cs.simulink.util.SimulinkIdProvider;
import edu.tum.cs.simulink.util.SimulinkModelWalker;

/**
 * Smoke testlet for Simulink/Stateflow. This parses a MDL file and checks if
 * deep cloning is implemented correctly.
 * 
 * @author deissenb
 * @author $Author: juergens $
 * @version $Rev: 26285 $
 * @levd.rating GREEN Hash: 43A74BF170D7E7ABF862AA250238A73D
 */
@Ignore
public class SmokeTestlet extends TestletBase {

	/** Name of file to read. */
	private final String filename;

	/** Create new testlet. */
	/* package */SmokeTestlet(String filename) {
		this.filename = filename;
	}

	/** Return name of config file as smoke test name */
	@Override
	public String getName() {
		return filename;
	}

	/**
	 * Parse MDL file and check if deep cloning is implemented correctly.
	 */
	@Override
	public void test() throws Exception {
		SimulinkModelBuilder builder = new SimulinkModelBuilder(
				useTestFile(filename), new SimpleLogger());
		SimulinkModel model = builder.buildModel();
		SimulinkConstraints.checkAllConstraints(model);
		SimulinkModel clone = model.deepClone();
		checkModelWalker(model);
		int size = checkCloning(model, clone);
		System.out.println("Model " + model + " loaded and deep cloned ["
				+ size + " elements].");
	}

	/** Test for {@link SimulinkModelWalker} */
	private void checkModelWalker(SimulinkModel model) {
		ModelElementsCollector collector = new ModelElementsCollector();

		VisitorUtils.visitAllDepthFirst(model, new SimulinkModelWalker(),
				collector);

		IdentityHashSet<Object> elements = DeepCloneTestUtils
				.getAllReferencedObjects(model, SimulinkModel.class
						.getPackage().getName());

		assertEquals(elements, collector.elements);
	}

	/** Checks if deep cloning is implemented correctly. */
	private int checkCloning(SimulinkModel orig, SimulinkModel clone) {
		IdentityHashMap<Object, Object> map = DeepCloneTestUtils
				.testDeepCloning(orig, clone, new SimulinkIdProvider(),
						"edu.tum.cs.simulink");

		for (Object origObject : map.keySet()) {
			Object cloneObject = map.get(origObject);

			checkParameters(origObject, cloneObject);
		}

		return map.size();
	}

	/**
	 * If <code>origObject</code> is a {@link ParameterizedElement} this
	 * checks if parameters are cloned correctly.
	 */
	private void checkParameters(Object origObject, Object cloneObject) {
		if (!(origObject instanceof ParameterizedElement)) {
			return;
		}

		ParameterizedElement orig = (ParameterizedElement) origObject;
		ParameterizedElement clone = (ParameterizedElement) cloneObject;

		assertEquals("Orig: " + orig + " (" + orig.getClass() + "), Clone: "
				+ clone + " (" + clone.getClass() + ")", CollectionUtils
				.sort(orig.getParameterNames()), CollectionUtils.sort(clone
				.getParameterNames()));

		for (String name : orig.getParameterNames()) {
			assertEquals(orig.getParameter(name), clone.getParameter(name));
		}

	}

	/** Simple visitor that collects all model elements. */
	private class ModelElementsCollector implements
			IVisitor<Object, NeverThrownRuntimeException> {

		/** Collected elements. */
		private final IdentityHashSet<Object> elements = new IdentityHashSet<Object>();

		/** Add object to collection */
		public void visit(Object element) {
			elements.add(element);
		}

	}

}