/**
 * GUI Commands
 * Copyright 2005 Andrew Pietsch
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * $Id: DownArrowIcon.java,v 1.1 2005/06/07 11:16:51 pietschy Exp $
 */
package org.pietschy.command;

import javax.swing.*;
import java.awt.*;

/**
 * @author andrewp
 * @version $Revision: 1.1 $
 */
public class
DownArrowIcon
implements Icon
{
   public int getIconHeight()
   {
      return 5;
   }

   public int getIconWidth()
   {
      return 7;
   }

   public void
   paintIcon(Component c, Graphics g, int x, int y)
   {
      Color old = g.getColor();
      g.setColor(Color.BLACK);
      g.translate(x,y);
      int row = 1;
      g.drawLine(0, row, 6, row);
      row++;
      g.drawLine(1, row, 5, row);
      row++;
      g.drawLine(2, row, 4, row);
      row++;
      g.drawLine(3, row, 3, row);
      g.translate(-x, -y);
      g.setColor(old);
   }
}
