package org.pietschy.command.interceptor;

import javax.swing.*;

/**
 * GlassPaneHanders are used by the ModalInterceptor to configure the glasspane
 * while a long running process is in progress.
 *
 * @see DefaultGlassPaneHandler
 */
public interface
GlassPaneHandler
{
   /**
    * Invoked by {@link GlassPaneInterceptor} to activate the glasspane and block
    * user interation.
    *
    * @param rootPaneContainer the {@link javax.swing.RootPaneContainer} whose
    *                          glass pane is to be activated.
    */
   public void activateGlassPane(RootPaneContainer rootPaneContainer);

   /**
    * Invoked by {@link GlassPaneInterceptor} to deactivate the glasspane and allow
    * user interation.
    *
    * @param rootPaneContainer the {@link javax.swing.RootPaneContainer} whose
    *                          glass pane is to be deactivated.
    */
   public void deactivateGlassPane(RootPaneContainer rootPaneContainer);
}
