/*
* JBoss, Home of Professional Open Source.
* Copyright 2006, Red Hat Middleware LLC, and individual contributors
* as indicated by the @author tags. See the copyright.txt file in the
* distribution for a full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.test.microcontainer.beans.test;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.jboss.aop.AspectManager;
import org.jboss.aop.pointcut.DeclareDef;
import org.jboss.test.aop.junit.AOPMicrocontainerTest;


/**
 *
 * @author <a href="kabir.khan@jboss.com">Kabir Khan</a>
 * @version $Revision: 1.1 $
 */
public abstract class UndeploySimpleTest extends AOPMicrocontainerTest
{
   public UndeploySimpleTest(String name)
   {
      super(name);
   }

   public void testUndeploy() throws Exception
   {
      AspectManager manager = AspectManager.instance();
      checkArtifacts(manager, false);
      
      deploy(getFileName());
      boolean error = true;
      try
      {
         checkArtifacts(manager, true);
         error = false;
      }
      finally
      {
         try
         {
            undeploy(getFileName());
         }
         catch (Throwable t)
         {
            if (!error)
            {
               // AutoGenerated
               throw new RuntimeException(t);
            }
         }
      }
      checkArtifacts(manager, false);
   }

   @SuppressWarnings("unchecked")
   private void checkArtifacts(AspectManager manager, boolean shouldBeThere)
   {
      Object o = manager.getTypedef("TypeDef");
      checkShouldBeThere(o, shouldBeThere);

      o = manager.getCFlowStack("CFlow");
      checkShouldBeThere(o, shouldBeThere);

      o = manager.getDynamicCFlow("DynamicCFlow");
      checkShouldBeThere(o, shouldBeThere);

      Map map = manager.getPointcuts();
      checkShouldBeThere(map.keySet(), 3, shouldBeThere);
      
      map =  manager.getInterfaceIntroductions(); //No name needed
      checkShouldBeThere(map.keySet(), shouldBeThere);

      List coll =  manager.getAnnotationIntroductions(); //No name needed
      checkShouldBeThere(coll, shouldBeThere);

      coll = manager.getAnnotationOverrides(); //No name needed
      checkShouldBeThere(coll, shouldBeThere);

      map = manager.getPrecedenceDefs(); // No name needed
      checkShouldBeThere(map, shouldBeThere);

      map = manager.getArrayReplacements(); //No name needed
      checkShouldBeThere(map, shouldBeThere);

      checkShouldBeThere(manager.getClassMetaData().keySet(), shouldBeThere);  
      checkShouldBeThere(manager.getClassMetaDataLoaders().keySet(), shouldBeThere);
      
      Iterator<DeclareDef> it = manager.getDeclares();
      if (shouldBeThere)
      {
         assertTrue(it.hasNext());
         o = it.next();
         assertNotNull(o);
      }
      assertFalse(it.hasNext());
      
   }

   private void checkShouldBeThere(Object o, boolean shouldBeThere)
   {
      if (shouldBeThere) assertNotNull(o);
      else assertNull(o);
   }

   @SuppressWarnings("unchecked")
   private void checkShouldBeThere(Collection coll, boolean shouldBeThere)
   {
      checkShouldBeThere(coll, 1, shouldBeThere);
   }

   @SuppressWarnings("unchecked")
   private void checkShouldBeThere(Collection coll, int sizeIfThere, boolean shouldBeThere)
   {
      if (shouldBeThere)
      {
         assertNotNull(coll);
         assertEquals(sizeIfThere, coll.size());
      }
      else
      {
         if (coll != null)
         {
            assertEquals(0, coll.size());
         }
      }
   }

   @SuppressWarnings("unchecked")
   private void checkShouldBeThere(Map coll, boolean shouldBeThere)
   {
      if (shouldBeThere)
      {
         assertNotNull(coll);
         assertEquals(1, coll.size());
      }
      else
      {
         if (coll != null)
         {
            assertEquals(0, coll.size());
         }
      }
   }
   
   protected abstract String getFileName();
}
