/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file FixedTableModeAttributes.h
    \brief Definition of FixedTableMode Attributes class.
    \author MeteoroMagLogical Visualisation Section, ECMWF

    This file is automatically generated.
    Do Not Edit!

    Generated: Tue Nov 22 10:53:39 2011
*/
   

#ifndef FixedTableModeAttributes_H
#define FixedTableModeAttributes_H

#include "magics.h"
#include "ParameterManager.h"
#include "Factory.h"



namespace magics {

class XmlNode;



class FixedTableModeAttributes 
{
public:
//  --  constructor
    FixedTableModeAttributes();
    
//  --  destructor
    virtual ~FixedTableModeAttributes();
    
    virtual void set(const std::map<string, string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const FixedTableModeAttributes&);
    virtual bool accept(const string&);

    void setTag(const string& tag) { tag_ = tag; }

    void setXmlData(const string&)  {}
/*!
    Magics Information:
    \brief  The list  
    \param levels Setting image_level_list - default=intarray()
*/
	void setLevels(intarray levels) 
		{ levels_ =  levels; } 
	intarray getLevels() const 
		{ return levels_; } 
        
/*!
    Magics Information:
    \brief  The list of indexes of the Lut to be used! (size of level_list -1 )  
    \param indexes Setting image_index_list - default=intarray()
*/
	void setIndexes(intarray indexes) 
		{ indexes_ =  indexes; } 
	intarray getIndexes() const 
		{ return indexes_; } 
        
	virtual void toxml(ostream& out, int tabs = 0) const { toxml(out, tag_, tabs); }

protected:
	//  --  method
	virtual void print(ostream&) const;
	virtual void toxml(ostream&, const string&, int tabs) const;

	//  --  members:
	string tag_;
	intarray levels_;
	intarray indexes_;

private:
  
	friend ostream& operator<<(ostream& s,const FixedTableModeAttributes& p)
	{ p.print(s); return s; }
};

} // namespace magics

#endif
