/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file LabelPlottingAttributes.h
    \brief Definition of LabelPlotting Attributes class.
    \author MeteoroMagLogical Visualisation Section, ECMWF

    This file is automatically generated.
    Do Not Edit!

    Generated: Tue Nov 22 10:53:37 2011
*/
   

#ifndef LabelPlottingAttributes_H
#define LabelPlottingAttributes_H

#include "magics.h"
#include "ParameterManager.h"
#include "Factory.h"


#include "Colour.h"

namespace magics {

class XmlNode;



class LabelPlottingAttributes 
{
public:
//  --  constructor
    LabelPlottingAttributes();
    
//  --  destructor
    virtual ~LabelPlottingAttributes();
    
    virtual void set(const std::map<string, string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const LabelPlottingAttributes&);
    virtual bool accept(const string&);

    void setTag(const string& tag) { tag_ = tag; }

    void setXmlData(const string&)  {}
/*!
    Magics Information:
    \brief 
            Quality of grid labels
           
    \param quality Setting map_label_quality - default=MEDIUM
*/
	void setQuality(const string& quality) 
		{ quality_ =  quality; } 
	const string& getQuality() const 
		{ return quality_; } 
        
/*!
    Magics Information:
    \brief 
            Colour of map labels
           
    \param colour Setting map_label_colour - default=black
*/
	void setColour(Colour* colour) 
		{ auto_ptr<Colour> tmp(colour); colour_ = tmp; } 
	const Colour&  getColour() const 
		{ return *colour_; }
/*!
    Magics Information:
    \brief 
            Height og grid labels
           
    \param height Setting map_label_height - default=0.25
*/
	void setHeight(double height) 
		{ height_ =  height; } 
	double getHeight() const 
		{ return height_; } 
        
/*!
    Magics Information:
    \brief 
            Evry Nth latitue grid is labelled
           
    \param latfrequency Setting map_label_latitude_frequency - default=1
*/
	void setLatFrequency(int latfrequency) 
		{ latFrequency_ =  latfrequency; } 
	int getLatFrequency() const 
		{ return latFrequency_; } 
        
/*!
    Magics Information:
    \brief 
            Evry Nth longitude grid is labelled
           
    \param lonfrequency Setting map_label_longitude_frequency - default=1
*/
	void setLonFrequency(int lonfrequency) 
		{ lonFrequency_ =  lonfrequency; } 
	int getLonFrequency() const 
		{ return lonFrequency_; } 
        
	virtual void toxml(ostream& out, int tabs = 0) const { toxml(out, tag_, tabs); }

protected:
	//  --  method
	virtual void print(ostream&) const;
	virtual void toxml(ostream&, const string&, int tabs) const;

	//  --  members:
	string tag_;
	string quality_;
	auto_ptr<Colour> colour_;
	double height_;
	int latFrequency_;
	int lonFrequency_;

private:
  
	friend ostream& operator<<(ostream& s,const LabelPlottingAttributes& p)
	{ p.print(s); return s; }
};

} // namespace magics

#endif
