/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.dependency;

import java.io.File;
import java.util.Iterator;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.dependency.AbstractFromDependenciesMojo;
import org.apache.maven.plugin.dependency.utils.DependencyStatusSets;
import org.apache.maven.plugin.dependency.utils.DependencyUtil;
import org.apache.maven.plugin.dependency.utils.filters.ArtifactsFilter;
import org.apache.maven.plugin.dependency.utils.filters.MarkerFileFilter;
import org.apache.maven.plugin.dependency.utils.markers.DefaultFileMarkerHandler;

public class UnpackDependenciesMojo
extends AbstractFromDependenciesMojo {
    private String includes;
    private String excludes;

    public void execute() throws MojoExecutionException {
        Artifact artifact;
        DependencyStatusSets dss = this.getDependencySets(this.failOnMissingClassifierArtifact);
        Set artifacts = dss.getResolvedDependencies();
        Iterator i = artifacts.iterator();
        while (i.hasNext()) {
            artifact = (Artifact)i.next();
            File destDir = DependencyUtil.getFormattedOutputDirectory(this.useSubDirectoryPerType, this.useSubDirectoryPerArtifact, this.useRepositoryLayout, this.stripVersion, this.outputDirectory, artifact);
            this.unpack(artifact.getFile(), destDir, this.getIncludes(), this.getExcludes());
            DefaultFileMarkerHandler handler = new DefaultFileMarkerHandler(artifact, this.markersDirectory);
            handler.setMarker();
        }
        artifacts = dss.getSkippedDependencies();
        i = artifacts.iterator();
        while (i.hasNext()) {
            artifact = (Artifact)i.next();
            this.getLog().info((CharSequence)(artifact.getFile().getName() + " already exists in destination."));
        }
    }

    protected ArtifactsFilter getMarkedArtifactFilter() {
        return new MarkerFileFilter(this.overWriteReleases, this.overWriteSnapshots, this.overWriteIfNewer, new DefaultFileMarkerHandler(this.markersDirectory));
    }

    public String getExcludes() {
        return this.excludes;
    }

    public void setExcludes(String excludes) {
        this.excludes = excludes;
    }

    public String getIncludes() {
        return this.includes;
    }

    public void setIncludes(String includes) {
        this.includes = includes;
    }
}

