#ifndef _PAYLOAD_H
#define _PAYLOAD_H

/* payload.h
  
   Data structures and function declarations for facilities
   provided in payload.c

   Copyright (C) 2007, 2008, 2009 Eloy Paris

   This is part of Network Expect.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
    
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
    
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <stdint.h>

#define PAYLOAD_ERRBUF_SIZE 256

struct payload {
    uint8_t *data;
    size_t len;
};

extern int create_payload(const char *, struct payload *,
			   char [PAYLOAD_ERRBUF_SIZE]);

#endif /* _PAYLOAD_H */
