/* OpenVAS Client
 * Copyright (C) 1998 Renaud Deraison
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef _OPENVAS_OPENVAS_H
#define _OPENVAS_OPENVAS_H

/* The default port assigned to OpenVAS for OTP by the iana is 9390, see
   http://www.iana.org/assignments/port-numbers */
#ifdef _WIN32
#ifndef OPENVAS_IANA_OTP_PORT
#define OPENVAS_IANA_OTP_PORT 9390
#endif
#endif

#define DEFAULT_SERVER "localhost"
#define PROTO_NAME "< OTP/1.0 >\n"
# define SSL_VER_DEF_NAME	"TLSv1"

#include "config.h"  /* to have ENABLE_SAVE_TESTS defined before including the
                        context */
#include "context.h"

const char * connect_to_scanner(struct context *);
#ifdef USE_OMP
const char * refresh_server (struct context *);
#endif

#endif
