/* $Id: prefs_scope_tree.h,v 1.4 2006-11-20 23:27:59 jan Exp $
 *
 * Copyright (C) 2004 by Greenbone Networks GmbH
 * Author(s):
 * Thomas Arendsen Hein <thomas@intevation.de>
 *
 * This program is free software under the GNU GPL (>=v2)
 * Read the file COPYING coming with the software for details.
 */

#ifndef PREFS_SCOPE_TREE_H
#define PREFS_SCOPE_TREE_H

#ifdef USE_OMP
int
create_omp_scope (struct context *context,
                  const char* id,
                  const char* name,
                  const char* rcfile,
                  char** scope_dir_name);
int
create_omp_report (const char *scope_dir_name, const char *id, const char *report,
                   gchar **report_dir_name_return);
struct context *scopetree_add_with_parent(struct context *, context_type,
    const char *, const char *);
#endif /* USE_OMP */

struct arglist *prefs_dialog_scope_tree(struct context *);

struct context *scopetree_new_with_parent(struct context *, context_type,
    const char *, const char *);
struct context *scopetree_new(context_type, const char *, const char *);
void scopetreeview_counters_update(struct context *, int, char*);
void scopetreeview_connected_update(struct context *);

void scope_move_menuitem_enable(struct context *, gboolean);

void task_menu_rename(GtkMenuItem *, gpointer);
void scope_menu_rename(GtkMenuItem *, gpointer);
void report_menu_rename(GtkMenuItem *, gpointer);

#ifdef USE_OMP
void server_menu_new(GtkMenuItem *, gpointer);
#endif
void task_menu_new(GtkMenuItem *, gpointer);
void scope_menu_new(GtkMenuItem *, gpointer);

#ifdef USE_OMP
void server_menu_delete(GtkMenuItem *, gpointer);
#endif
void task_menu_delete(GtkMenuItem *, gpointer);
void scope_menu_delete(GtkMenuItem *, gpointer);
void report_menu_delete(GtkMenuItem *, gpointer);

void scope_menu_open(GtkMenuItem *, gpointer);
void scope_menu_save (GtkMenuItem*, gpointer);
void scope_menu_save_as (GtkMenuItem *, gpointer);

#ifdef USE_OMP
void scopetree_refresh_reports (struct context *);
void server_menu_refresh(GtkMenuItem *, gpointer);
#endif

void scopetree_context_new(GtkWidget *, gpointer);
void scopetree_context_delete(GtkWidget *, gpointer);

void prefs_scope_tree_update_report ();

#endif /* ifndef PREFS_SCOPE_TREE_H */
