/* OpenVAS-Client
 *
 * Description: Protos for socket wrappers for W32.
 *
 * Authors:
 * Marcus Brinkmann <marcus.brinkmann@ruhr-uni-bochum.de>
 *
 * Copyright:
 * Copyright (C) 2009 Greenbone Networks GmbH
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2,
 * or, at your option, any later version as published by the Free
 * Software Foundation
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef _OPENVAS_SOCKET_H
#define _OPENVAS_SOCKET_H

#ifdef _WIN32
#include <ws2tcpip.h>
#define ETIMEDOUT EINTR
#else
#include <sys/socket.h>
#endif


/* These are socket wrapper functions to support an emulation of Unix
   domain sockets on Windows W32.  */
int openvas_sock_close (int fd);
int openvas_sock_new (int domain, int type, int proto);
int openvas_sock_connect (int sockfd, struct sockaddr *addr, int addrlen);
int openvas_sock_bind (int sockfd, struct sockaddr *addr, int addrlen);
int openvas_sock_block (int sockfd);
int openvas_sock_unblock (int sockfd);

#endif
