
/******************************************************************************
**
**  Copyright (C) 2006 Brian Wotring.
**
**  This program is free software; you can redistribute it and/or
**  modify it, however, you cannot sell it.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
**
**  You should have received a copy of the license attached to the
**  use of this software.  If not, view a current copy of the license
**  file here:
**
**      http://www.hostintegrity.com/osiris/LICENSE
**
******************************************************************************/

/*****************************************************************************
**
**  File:    md_control.h
**  Date:    May 27, 2002
**
**  Author:  Brian Wotring
**  Purpose: handle control requests from management applications.
**
******************************************************************************/

#ifndef MD_CONTROL_H
#define MD_CONTROL_H



THREAD_FUNCTION_TYPE process_client( void *client_socket );
void process_request( SSL *ssl, CONTROL_REQUEST *request );

/* control handlers. */

void process_hello( SSL *ssl, CONTROL_REQUEST *request );
void process_get_host_brief_list( SSL *ssl, CONTROL_REQUEST *request );

void process_get_user_list( SSL *ssl, CONTROL_REQUEST *request );
void process_delete_user( SSL *ssl, CONTROL_REQUEST *request );
void process_set_user( SSL *ssl, CONTROL_REQUEST *request );

void process_status( SSL *ssl, CONTROL_REQUEST *request );
void process_push_config( SSL *ssl, CONTROL_REQUEST *request );
void process_remove_config( SSL *ssl, CONTROL_REQUEST *request );
void process_remove_host( SSL *ssl, CONTROL_REQUEST *request );
void process_set_base_db( SSL *ssl, CONTROL_REQUEST *request );
void process_unset_base_db( SSL *ssl, CONTROL_REQUEST *request );
void process_remove_db( SSL *ssl, CONTROL_REQUEST *request );

void process_import_config( SSL *ssl, CONTROL_REQUEST *request );

void process_start_scan( SSL *ssl, CONTROL_REQUEST *request );
void process_stop_scan( SSL *ssl, CONTROL_REQUEST *request );

void process_get_config_brief_list( SSL *ssl, CONTROL_REQUEST *request );
void process_get_shared_config_brief_list( SSL *ssl, CONTROL_REQUEST *request );

void process_get_database_brief( SSL *ssl, CONTROL_REQUEST *request );
void process_get_database_brief_list( SSL *ssl, CONTROL_REQUEST *request );
void process_get_log_brief_list( SSL *ssl, CONTROL_REQUEST *request );

void process_get_config( SSL *ssl, CONTROL_REQUEST *request );
void process_get_log( SSL *ssl, CONTROL_REQUEST *request );
void process_get_host_brief( SSL *ssl, CONTROL_REQUEST *request );

void process_new_host( SSL *ssl, CONTROL_REQUEST *request );
void process_edit_host_brief( SSL *ssl, CONTROL_REQUEST *request );

void process_drop_config( SSL *ssl, CONTROL_REQUEST *request );

void process_get_database_errors( SSL *ssl, CONTROL_REQUEST *request );
void process_get_host_config( SSL *ssl, CONTROL_REQUEST *request );
void process_save_host_config( SSL *ssl, CONTROL_REQUEST *request );
void process_get_management_config( SSL *ssl, CONTROL_REQUEST *request );
void process_save_management_config( SSL *ssl, CONTROL_REQUEST *request );

void process_get_database( SSL *ssl, CONTROL_REQUEST *request );

void process_get_cmp_filter_list( SSL *ssl, CONTROL_REQUEST *request );
void process_save_cmp_filter_list( SSL *ssl, CONTROL_REQUEST *request );

void process_send_notify_test( SSL *ssl, CONTROL_REQUEST *request );

/* non-control handlers. */

void receive_scan_data( SSL *ssl, CONTROL_REQUEST *request, OSI_DB *db );

osi_bool generate_session_key( int keysize, unsigned char *buffer,
                               int buffer_size );

osi_bool generate_session_key_hash( unsigned char *key, int keysize,
                                    unsigned char *buffer, int buffer_size );


#endif
