--
-- PostgreSQL database dump
--

SET client_encoding = 'UTF8';
SET standard_conforming_strings = off;
SET check_function_bodies = false;
SET client_min_messages = warning;
SET escape_string_warning = off;

SET search_path = public, pg_catalog;

SET default_tablespace = '';

SET default_with_oids = false;

--
-- Name: worldboundaries; Type: TABLE; Schema: public; Owner: twain; Tablespace: 
--

CREATE TABLE worldboundaries (
    gid integer NOT NULL,
    cat bigint,
    fips_cntry character varying(80),
    cntry_name character varying(80),
    the_geom geometry,
    iso3166 character(2),
    CONSTRAINT enforce_dims_the_geom CHECK ((ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((srid(the_geom) = 3395))
);


ALTER TABLE public.worldboundaries OWNER TO twain;

--
-- Name: worldboundaries_gid_seq; Type: SEQUENCE; Schema: public; Owner: twain
--

CREATE SEQUENCE worldboundaries_gid_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.worldboundaries_gid_seq OWNER TO twain;

--
-- Name: worldboundaries_gid_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: twain
--

ALTER SEQUENCE worldboundaries_gid_seq OWNED BY worldboundaries.gid;


--
-- Name: worldboundaries_gid_seq; Type: SEQUENCE SET; Schema: public; Owner: twain
--

SELECT pg_catalog.setval('worldboundaries_gid_seq', 3807, true);


--
-- Name: gid; Type: DEFAULT; Schema: public; Owner: twain
--

ALTER TABLE worldboundaries ALTER COLUMN gid SET DEFAULT nextval('worldboundaries_gid_seq'::regclass);


--
-- Data for Name: worldboundaries; Type: TABLE DATA; Schema: public; Owner: twain
--

COPY worldboundaries (gid, cat, fips_cntry, cntry_name, the_geom, iso3166) FROM stdin;
1	15	AY	Antarctica	0106000020430D000001000000010300000001000000260000003BCF4B9120A8714134FFB1A7DDA66BC1FB029B245FA771418CE0E488BEA56BC1CA2BDBF85CA371413DF8C9140B9D6BC14A0842AABCA27141A1B28066F69A6BC1C383250A28A27141376E056C07976BC142F789784DA371410BDC077B4A926BC16428A3E1DAA3714188984188CE906BC12C637CCB9DA47141CFAA91F89F8D6BC139135027D4A47141C2B4227BED8B6BC185E35E67DFA471410319B37B278A6BC19CCDA7F999A47141792D23F427816BC1E34B3C307BA4714149B094D14F7F6BC15EF0DC94FBA371414AA6B0479F7D6BC1C7021EF447A3714129C4B05C387C6BC1D485736F88A27141438E74151E7B6BC197A8A80AEAA1714185617C85FD786BC1B3048FE675A171419A107D7702776BC1EB19811C38A171418A297D7D56736BC1E2B8FDCA43A1714160B4B493A7716BC13AA9CEC6B1A17141EA04B457486E6BC17F2E4ED85BA2714177CBFBD8416D6BC12804A72125A371417556612EFD6D6BC12C70D8AD15A771412A703A12B9716BC16B0005B892AA714149A03660BE776BC121B90602D4AF714149B094D14F7F6BC171A57A6C21B271416046ABAE41826BC1FAEFC051EDB371418C52B606018A6BC10939401265B471416A8093D9118C6BC167F1E8FA85B4714148D1161FD88D6BC1F16E1AC051B471417755B9FC8C8F6BC11403C7E8BCB371410B7850BECE926BC1100784BCF8AF7141D2A8BB3CCE986BC1A04961EB3CAD7141317B7285139C6BC1E1D29E124CAB7141FD63FBEABF9E6BC1BABFF9FFC0AA714176470E9B3DA06BC13B4C95919BA97141FE7D3FCB13A56BC1191B7C280EA97141FB2DD22491A66BC13BCF4B9120A8714134FFB1A7DDA66BC1	AY
2	15	AY	Antarctica	0106000020430D00000100000001030000000100000025000000C11493A3DABD714180FD7B15CE966BC1C616414B56BC714171887A5410966BC11ADB277D4BB97141A5C73E37C5916BC1FEE1D4609DB87141D87E810B10906BC18F27DE121CB87141E3D8C1385D8E6BC1B6BD39252CB7714158C1ED97608A6BC1E328C8C43DB7714134EB1A4BD5866BC109CC7E779CB771417E248F0A49856BC1D7BB67AEB9B971416C114102EF806BC19A84A490D4BB714182D0E62BAB7C6BC1BE1B7E7EA3BE7141A8C996D8EE766BC1F53DCB54B4BF714183FEB412ED736BC11CEEDDE98AC271415035527CB26A6BC142E15FBC6EC3714138431B24A0676BC16482678528C47141AB8B1D227D646BC1123A4C78EFC47141A70E902ADA5D6BC148065E69F5C47141A546A5B21A5C6BC1A2CF204AF3C4714180D30E2EA75A6BC1B4F191EFFAC47141B5E89897FA586BC16A2A1D745DC57141F006A006A2556BC110413753B8C571415D5D027308546BC1AA3DFF3B36C671414EF4A163E0526BC1C7CFFDBC25C77141C4A10F5C4A526BC1623CB405D0C77141282063DF95526BC12E16A9195AC97141C609F0FF52546BC11B3B6A1193CA71419B6BA99560576BC1D04A3891E0CA714124B4AC2F44596BC19F63DECC12CD7141A886792B63726BC1246F72480DCD7141C2D97EC524746BC12CBA01776ECC714182D0E62BAB7C6BC124395AA3A9CB71418D1062985C836BC1DB0764C7E9C87141F4BF5B3A11926BC1B564AD148BC871415AAA5CC2B0936BC1745E25ABD7C771419E566B561A956BC120001539E2C67141D125E238C4956BC17295CEA03CC37141424A58F581966BC1C11493A3DABD714180FD7B15CE966BC1	AY
3	15	AY	Antarctica	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	AY
4	15	AY	Antarctica	0106000020430D000001000000010300000001000000110000005F9A36BF82E5714159ACD3B4A2A469C1EDA927CC9DE37141C24D79D59AA269C13119B2788BE27141EFD8652243A069C16170FBDEAEE17141A20A67FBFA9D69C1DECD69A6EEDF71419BFFB29A689769C182CE8F62B6DF714153A46374049669C1FA993EE2A6DF71414AF686DE2E9469C16502BB26FEDF71413B9BE629AB9269C16299B7A19AE07141A984CF4A789169C157CF30CB42E17141CEBCA3E4C79069C14D75985417E27141ED26C2A9179169C19A9BE2792DE3714155409D9B4C9369C17D3FFC9DA1E37141E3E4A775A09469C1C394D41197E4714127CB9D357A9869C165BC08E9CEE47141F5045887EF9969C11C4BCF523CE671411408048C30A469C15F9A36BF82E5714159ACD3B4A2A469C1	AY
21	174	NZ	New Zealand	0106000020430D00000100000001030000000100000009000000D7BEB91B79A871412F411C86C9CC58C10FD4AB513BA871410790800D2ACD58C10FF4CE91E2A771412310C00D36CD58C11ABE55683AA7714148C9F62CE1CC58C1EB99F82340A77141F77E9CC7EECB58C196980E721EA871415A923027F0CA58C14DD199F680A871410B50706814CB58C1DD666EC884A871413DBE1B4D74CC58C1D7BEB91B79A871412F411C86C9CC58C1	NZ
22	174	NZ	New Zealand	0106000020430D0000010000000103000000010000001800000046E039DE42FC724183397ED1A63F58C1B7DA76AC12FC724113DEC36FDD4658C10F7B7C88FBFB7241A72CFE49FB4758C1CEC4BF3ECDFB7241BDD31E07C64858C11AB5F1BE7FFB724156137E54254958C109365A59A4F9724123A5DFD0CB4758C1CB386CB45EF97241198091876C4758C1BAA60CAF2AF97241D387B0BAB94658C1246983301BF972414725A0F95F4558C1EB8338980DF972416EC7051D4D4258C173B889181DF9724109F96EC70B4158C14DC5088862F972413DA8141A2F3F58C1916AABD9B3F9724108A355696A3D58C1D50F4E2B05FA7241A947A529A63B58C1D67F3C8B31FA724120C69AF7CF3A58C1B3EB8F62C6FA7241688F6B8B943858C102EBCB6C6CFB72416A7DF34A893658C1186C117AC3FB7241DDB4F6D74D3658C1B64A650C3FFC72415BABC21C6B3758C1CC5BBCB969FC72416C0C994C4D3858C1FDA8D60279FC72417768F27EA63958C15649DCDE61FC72417210AF2A9A3D58C10E5B594854FC72419CB01EB5DB3E58C146E039DE42FC724183397ED1A63F58C1	NZ
23	174	NZ	New Zealand	0106000020430D0000010000000103000000010000000A000000E5A165E26CB071410AE7F04FF62F57C19DCD9608AAB07141B365E06A513357C1EC3CC03053B071417AF61833E23557C1C11A1194D4AE7141190E5ACC203457C1F13E6ED8CEAE7141176F527C173357C1250B810BFEAF7141FB696A9F542D57C1C3C0179964B0714119D802D7FA2B57C11A41FA34A6B07141EB678B07292C57C14A655779A0B071413F882951602D57C1E5A165E26CB071410AE7F04FF62F57C1	NZ
24	174	NZ	New Zealand	0106000020430D0000010000000103000000010000000B000000CA0242DCE102734175FC28D81FF956C1711271E0730273414712498CF7F956C1745B512530027341F008000E9CF956C1EC2600A520027341206ECC5C50F856C1867DC2CA37027341E4DC7B9E3DF756C13C465FEF6D02734161163F509DF656C1F9B6B0C0AF027341E3C81DF713F656C13F1522B7E902734161163F509DF656C139DD5B6A0A03734110911F1699F756C14AD60F0BFD027341C10C6D20CEF856C1CA0242DCE102734175FC28D81FF956C1	NZ
25	174	NZ	New Zealand	0106000020430D00000100000001030000000100000010000000591508B1CDC77141E23489A359AF56C100051475B8C771418EE90411EDAF56C1BC5F712367C77141B9690E6ABEB156C12E6347747BC6714110203B65DFB356C11F8AB61330C67141D3AA592A18B456C15F60969D05C67141E4967CF04BB356C1EFF56A6F09C67141104BB6BCE0B156C12E836AB422C6714182D9EB35B9B056C1E704D67D41C67141E0DB1A53B4AF56C11B41D6CE73C67141C8D01D260AAF56C1DC3A4FA7E9C671411B62D91FFAAD56C134BB31432BC771414FC843E693AD56C192E3C88B78C7714178D4ED7166AD56C161768B02C2C77141BD1932F671AD56C1007502D5E4C77141722E070760AE56C1591508B1CDC77141E23489A359AF56C1	NZ
26	174	NZ	New Zealand	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	NZ
30	174	NZ	New Zealand	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	NZ
18	12	AS	Australia	0106000020430D000001000000010300000001000000100000004E0A5A99AC466F41FAAA7EA65B7354C1229C9E3437436F416C75B4451F7054C1BC0EC13AC23F6F41AD854EA29D7154C14BF13367E73C6F41372ADE8EB76554C12E9910EB8E406F41B7731CDDA75B54C175E7E606D4456F41697E2778814E54C1305838D815466F41E57793DCE24D54C1BE141BC589466F41BD1D9281024E54C1E138DACFF1466F4140C14720204F54C1B5F09B35EB496F415110E625985E54C147E6DA090E4A6F418D46C241556054C1377D3809EF496F4170CF0CAC276254C17D05FB1ABB476F41219E550B737154C11F16A53490476F41C812CE9D277254C10FCD257418476F41FC803593267354C14E0A5A99AC466F41FAAA7EA65B7354C1	AU
32	12	AS	Australia	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	AU
41	174	NZ	New Zealand	0106000020430D0000010000000103000000010000001800000044ECD90E6C7E72419D1CB3FC1A2453C1FC7AA078D97F72414C57ACCA952253C17E4440CC098272419CFE823C4E1E53C1C4A2B1C243827241AFA5F794C91D53C18C6D9C4CDA827241F1E64441D41A53C1CBFA9B91F38272418A32F6B6DE1953C1FC47B6DA02837241EA5091FCD41853C1B430763FE0827241D0CB7C1D501853C16DD20449A6827241FDD2BD5AB61853C11DB3A5FE5882724194D270C2971853C10D6A263EE1817241AD58FA5FD51753C1F858CF90B68172418C6A2E256F1753C198E75703AD817241AF7AFDD0831653C1DB8CFB9627837241B54DFB111F1353C13E348A876B83724187B12981D71253C18E53E9D1B8837241516DA714F61253C1EFC4605FC28372415288A48D1E1453C197B46C23AD8372419EF8AF40831853C1998D5E083D837241ACCCB14CFC1F53C1C5C2D544148372418D07C84AAA2053C114B5B42A1980724149C5563E582553C1E63331264B7E7241869C8C2C2F2553C14735BA53287E7241B30BE26EE72453C144ECD90E6C7E72419D1CB3FC1A2453C1	NZ
36	12	AS	Australia	0106000020430D00000100000001030000000100000012000000CB7750C69E496F4154A0A3D9AD2D52C1D53B68199A496F41AE063B76F32D52C1090910A56F496F4118CA7AF3922E52C19B77D65B03496F41CC81B6F5A62E52C17CA5915AC5486F41098D9012892E52C1449ACDFFED466F4172C5DF13E62C52C12FBF8DB5FD466F41FC0257510A2C52C1B12B07495A476F41F142CF25F32A52C1EF08D2ADF8476F415A6FD74E502952C1F6A6573DF0486F41D1FBDD865D2752C19A57B31B5C496F41E8CA59647B2752C123A2F8BEFE496F41C30EA80E2F2852C1D3A2BDF6814A6F41358F1050282952C180AA6CC7A44A6F4111205C03A02952C12362B23EB04A6F415D842D4E852A52C19585AC11954A6F41F5B9C6DD422B52C1F30DAD1AD8496F41E8BF076FA32D52C1CB7750C69E496F4154A0A3D9AD2D52C1	AU
42	174	NZ	New Zealand	0106000020430D0000010000000103000000010000001500000034A36C810D737241744477A7C6F652C12D22C6EF717372415AA2C96F3DF252C16B1FB494B77372415AB7760E22E952C14AD4E7B00874724129D535727FE252C122583F191A747241699E9C4777E152C1913259A742747241BD3EF16ACAE052C15AB0A5D6B777724178290ECECDD952C1D0327411EC7772417B8AD29F0ADA52C199AD937BFD77724137C31FEF1CDB52C1FA1E0B090778724126063D2F9DDD52C1E7FC9963FF777241D55B4F01CEDE52C143566EE4D07772410C1EC819ADE552C13134FD3EC97772419EA5E23E97E652C1660A3E4DE37672418D74EC89DAEF52C108529564C2767241E1863D39B0F052C1C3BFB970A07372417F3C052B20F952C15E8F037928737241B0F817B7EBF952C1B7BF1AF5E472724148054DF2AEF952C100676C30DB727241C3A30CF67CF852C11578C3DD05737241BEE99423E5F652C134A36C810D737241744477A7C6F652C1	NZ
43	174	NZ	New Zealand	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	NZ
44	174	NZ	New Zealand	0106000020430D0000010000000103000000010000000B000000AE025DA2BFC972418003F17A654D51C14D91E514B6C97241C3C3E24D484D51C18E67C59E8BC97241745C7863AC4C51C1C5ECA5347AC97241F3415908AF4B51C14D91E514B6C9724183998D321F4A51C18E47A25EE4C9724174B099BC8C4951C19EC6388296CA7241D8D78BDBD54B51C1D0A3646B79CA724119A5047DA24C51C17C951F1909CA7241D5D45209794D51C194EF560BF0C97241E10036DC5B4D51C1AE025DA2BFC972418003F17A654D51C1	NZ
45	174	NZ	New Zealand	0106000020430D0000010000000103000000010000000F0000002B93C87C18BB7241A73A61BB312C51C1CB2151EF0EBB72418CA4A146D02B51C17B42396739BB7241EB67C3F6C62851C121E964E667BB7241D0EA42DA3E2851C1E012855C92BB7241C824EF72DA2851C109FF1B54ADBB7241EBD3F5DAB92951C1D1793BBEBEBB7241A378415BB62A51C19994F025B1BB7241C71794F8782B51C1992402C684BB72410DF8DDC9412D51C16A90B6215EBB72418B025716E72D51C184A3BCB82DBB724164F992DD782E51C16C69A806EEBA7241E116B47D822E51C12B23DA1CECBA7241B3CDC057C02D51C18333CE5801BB724116B96DFAD62C51C12B93C87C18BB7241A73A61BB312C51C1	NZ
46	174	NZ	New Zealand	0106000020430D00000100000001030000000100000010000000F47620C3AF9872418ED6F50CD3BE50C1F72FEF679898724104D7460276BF50C1A5C7AFD88E98724104D7460276BF50C11DC649387F96724139B0CA856CBF50C1F064E97358947241BC99406FA1BB50C1A0B5788937947241525EE5F2E0BA50C1CA312121269472413B4B8035E7B950C1C6E840DC69947241ADBE9C1420B750C16E483B00819472415CA8083643B650C1CBDA54EB199972419FC5476B58B150C1D50B319F59997241A17C992315B150C11921C250D7997241EBF2A9A762B450C15967903AD99972418D1368D89FB550C1E3A47A3D2D9972411E8B347D48BD50C13B458019169972416510684E2FBE50C1F47620C3AF9872418ED6F50CD3BE50C1	NZ
47	174	NZ	New Zealand	0106000020430D0000010000000103000000010000001000000059F44E2BC4A9724112F1AE6B5CA150C1AEC8BB3E19A97241C70150BB2A9F50C10769C11A02A97241F41259574E9E50C147AF8F0404A97241DBFA43874B9D50C19D5680BBB5A97241DA744EB9659C50C1DE0C3D05E4A972416E3EC497A89C50C1608FAABBD3AA724138FC18139AA150C119111685F2AA7241B199CECF59A250C18F23F65FFAAA72411EDDE84936A350C163D88A0090AA72410982DD4909A450C14C9E764E50AA72410982DD4909A450C1CC5ABABF08AA7241F1227619E3A350C12DEC548DB9A97241661BA72B96A350C1858C5A69A2A97241D0CB7FAFB9A250C15C10B2D1B3A9724116C9B709B7A150C159F44E2BC4A9724112F1AE6B5CA150C1	NZ
48	174	NZ	New Zealand	0106000020430D000001000000010300000001000000150000001FC9897225907241A5D748008F8A50C1DB59FE830E907241F0A0A4AE358550C1638E4F041E90724183D4133D3D8450C192229BA844907241E89FB7A99A8350C1126657378C9072413B82F297748350C1177EFA43C490724130736779CA8350C1FD6AF4ACF490724180BC28F2468450C16D450E3B1D9172419F14FDD2DF8450C1CBFDB6233E91724169606F079F8550C17D1E9F9B68917241E6A5A9AA738750C153A2F6037A917241F0560BE6758850C10AFBA4C8839172414F0EA65F8B8950C16B6C1C568D9172416D94C350AA8A50C1ACB2EA3F8F9172410A48A139E68B50C1850F348D309172417955A6446C8C50C16ED51FDBF09072419C0DC6BFB88C50C162456FBF61907241383005C2FB8C50C11CA0CC6D109072410681763B058D50C12591615FD88F7241B6AA6646AF8C50C123D892BAEF8F72416C9A6290C98B50C11FC9897225907241A5D748008F8A50C1	NZ
49	174	NZ	New Zealand	0106000020430D00000100000001030000000100000015000000DCE6BEF84BA27241146BE523007E50C16C0CA56A23A27241523675EE007E50C174FD395CEBA1724168409FDBAA7D50C17CF8FD6AC7A07241F25498D1917A50C10C1EE4DC9EA072416B44A217F97950C1C86BE5A8D59D7241B51284C2096E50C108B2B392D79D724150E77BE23C5C50C1DA8D564EDD9D72410CB9C2381F5B50C1329E4A8AF29D7241AAB49645445A50C12FE57BE5099E7241A300C95F695950C107929052309E72412D6EBACCBD5850C1BF5A2D77669E72417BF5729B5E5850C1906CE795A69E7241B7DC0AE71B5850C15937D21F3D9F724110872D54255850C120F922E5659F72412D6EBACCBD5850C1DB56AD5878A272415BAA6771386750C16192E9B350A37241B7EC0671867950C1708B9D5443A372411894775C887A50C109A218B8E2A27241C080F5C4ED7D50C1EC2F3EB9C3A272419F386DE1AC7E50C1DCE6BEF84BA27241146BE523007E50C1	NZ
62	163	NF	Norfolk Island	0106000020430D0000010000000103000000010000000C0000009998C7E7E2D47141874754E5ACAC49C19519CFFDC2D371410C3D332EA0A649C11F9700C38ED3714177D7D60342A349C1DEE0437960D37141906BCC79F19A49C136F137B575D3714190EDBBC2E99949C17B06C966F3D37141ADBB4BBABE9849C1323F54EB55D471410CA23C9B169949C1128499A77AD47141744FD86AA39949C1157380F1C6D571413F9EB197CA9E49C1019840A7D6D57141F36A914D07A049C11EF4268362D5714166F0B696F6A849C19998C7E7E2D47141874754E5ACAC49C1	NF
61	174	NZ	New Zealand	0106000020430D0000010000000103000000010000000B000000AC3EBBED84467241AB47720A20BC4EC12DFBFE5E3D467241D0F4D1E058B94EC11531D90C2A4672418E8FE1F09AB74EC1BB67162C2C467241883CDE8C26B64EC1E10ACDDE8A46724132E7CAA16CB54EC141E399497C47724170714330B3B44EC12D311704A1477241F85D08D9EEB54EC18F32A0317E47724180158C5A50B74EC10A675236D2467241D92D894987BB4EC1549EB5119C46724188E16AE82EBC4EC1AC3EBBED84467241AB47720A20BC4EC1	NZ
2564	36	CA	Canada	0106000020430D00000100000001030000000100000015000000698295C0A23259C1CA1CA8EF04E45841C1B342D72E3259C12B4A083F36E35841BDC45B8DE23059C10064208744E05841FF4C031A222F59C13BC1B31D9EDB584146150E308F2E59C10F19F836F5D95841F43CE040592E59C1E800556B58D85841F43CE040592E59C1D7ECB4FD8AD65841E5A9EBE27E2F59C13AF0EDB306D55841AD5BB98CC33059C1D16B2C78CBD35841B981D0881F3259C15A5C7E39B4D2584148BE41FA823359C1DAFC26B2C1D158415F1ECE2C633459C1DAFC26B2C1D1584154E458F6DE3459C138E74A9A6BD25841405752EBAD3759C1918B5A63B0E25841405752EBAD3759C16EB7A17097E35841E3F6770A873759C10CF29B828AE45841B4F3D3A0033759C1BA93649271E558416F6E548F593659C137807C8D0FE658416245F80E893559C104C724F83FE658416F87702D823459C1CB18712BF7E55841698295C0A23259C1CA1CA8EF04E45841	CA
883	42	CH	China	0106000020430D000001000000010300000001000000110000007586BE3CCA536941F4F560A3AA324641D93DEC0FA85369418BD1640B9A33464103CEA7BB2453694117F08F75C73D46415C4310C61C536941C42444411C3F46413237568E5A536941A234ACAFB245464142A0F88E79536941257ADF76F6464641020031AA07556941446DFB61475246416457F5BCEF5569415ABE9E69355546413B4B3B852D566941719CD7E2F0554641F62C11516B566941E34F6EB4CE554641E3AA35A9445669410472E117274D464120B2526B9E55694160A1CF7F773446411CA348E1AA54694156F91778AC314641BE7AB1985D54694149C5976657314641F8487273085469410538D2548A314641A5704484D2536941FEC38BAB563246417586BE3CCA536941F4F560A3AA324641	CN
428	105	ID	Indonesia	0106000020430D0000010000000103000000010000000B0000000A174279823B6A41A1D7DDC599010AC19EBB1F93503B6A41317D5C669B060AC14093884A033B6A41317D5C669B060AC18ACAEB25CD3A6A416722C49600FD09C10DE603FFD43A6A41791B9726ADEC09C194EFB7ADF33A6A41B76DD3D658DC09C19A3E08B8353B6A4118F98C28AAD409C1CD4F6B37773B6A4172BAC3538CD709C15B2C7164923B6A41D98B10C0DFE709C15B2C7164923B6A41C23D237914FB09C10A174279823B6A41A1D7DDC599010AC1	ID
70	161	NC	New Caledonia	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	NC
54	12	AS	Australia	0106000020430D000001000000010300000001000000370000005174AA55E48E6E419552394D5E8852C1AEC34E77788E6E41CDEA87F7218852C1640FA29B338D6E4116972C69528652C1749867DCF98C6E41AC6A2195CF8552C1642FC5DBDA8C6E415DF633731A8552C100296283478C6E415E8BA727437E52C197DC4927098D6E4158B201BD797D52C1F604E16F568D6E412F2A8FFD007D52C164B63DF9698D6E416288E610427C52C1544D9BF84A8D6E41AB4C15AC4D7352C13422F254438D6E411D332C73847252C11650AD53058D6E414E90C1D6247152C1C790B80BD78C6E415ECA91308E7052C14D087A0B1D8C6E418256616BFC6E52C124261231168B6E410B578352566D52C111C459C9968A6E4178D03A3D656C52C1757EB19B5C8A6E4181C80ACDE26B52C127BFBC532E8A6E412D60D741426B52C1A53220802A8A6E415007085C656A52C1555308F8548A6E41BE077A7C246352C1D32DC101398B6E411EDF465AD44C52C1E2966302588B6E4191FFD32F0C4C52C16D3323AF248C6E41BF3A8FF4CB4A52C14052386EB38D6E4151C2C171274952C1DB579A1B9F8E6E418392E986054852C1EFB952831E8F6E41621997881F4752C15D4B8CCC8A8F6E41659C61591B4652C17C561230EB8F6E4198A16237E54452C18BBFB4300A906E41C0BDAA1D274452C1BA5300D530906E41115FAE6B6F4252C1AF03977B19906E41E81FC816C14052C13D59248BA58F6E4172F5B2A5E73D52C16E0D936F738F6E410802B5EA753C52C13E7947CB4C8F6E41AE8E7910E63A52C1FAE9989C8E8F6E4101DDEB1D5A3A52C13D00C0E8DB8F6E411F862A62003A52C1F27EE76FAF916E41A0A204B3F23852C1835403042B926E41953486C21A3952C1630937207C926E41D46C97BC743952C13D061A73A3966E411EFB9D86C33E52C119A214E8EC966E41FFF87173273F52C1F724F3BE0D996E411225CD2E7B4552C1C77084DA3F996E413E596573F74652C1607DD020CB996E415FB3821E905A52C1607DD020CB996E41DD1F54995D5C52C16BDB2AB5009B6E41E68FDCF5286A52C1370E83292B9B6E41433521BDC96A52C117E3D985239B6E418DF74887BA6B52C1BE2CE086A79A6E4121DD9B897A7252C1AEC33D86889A6E41CE423185397352C12B2BDCAC05996E4194573EACF07952C1D952AEBDCF986E41ABEE8E8C7D7A52C14A23AF69A2936E4121D8C7307C8152C199E810B1DA906E414B0F159BA18452C15174AA55E48E6E419552394D5E8852C1	AU
2578	36	CA	Canada	0106000020430D00000100000001030000000100000009000000007C43D797B057C1524475131EB65A41DC9EB66970B157C105F6530D9FB65A413AC74DB2BDB157C155755A486DB75A41CC35146951B157C17AE7067555B85A41B2BC4E8F69B057C18F166292E3B85A41C83039FC71AF57C1CC2485AE48B85A414B4C51D579AF57C1C1501F8E60B75A419A0B461DA8AF57C1067F11965EB65A41007C43D797B057C1524475131EB65A41	CA
1519	26	BM	Myanmar (Burma)	0106000020430D00000100000001030000000100000012000000BEE4DF1979E864416AE73A41EF20354120CFDFCB1CE964413026AA9379403541D1EFC74347E9644187A0E31E45453541008413E86DE964415E9B5E1E1D4735411AAEA33CA0E96441F5EDC7DB9648354177D63A85EDE964413AE1911E34493541DBA6867A46EA6441372078BDD54835414938C0C3B2EA64417E9FA5FC0146354177CC0B68D9EA644138C458E129443541EF97BAE7C9EA644182A254860F1E3541FA78CB7B84EA64419D2CD0CB201A3541863FDD850CEA6441990BBF29CB1735414EEAA38DD2E964412A1788A12D173541008413E86DE9644186D1593A4D173541690643A7E6E864419B01D325251935411A474E5FB8E864418253161BBE1A35415ED6FC8D76E8644149D500BAAC1E3541BEE4DF1979E864416AE73A41EF203541	MM
1520	26	BM	Myanmar (Burma)	0106000020430D000001000000010300000001000000250000003F1126A2C9DF64410220C86DDE08354174F32BB662E06441F81A0BB51F13354145E6582FCBE064418A9DA478371C3541F50641A7F5E0644108CC10001524354193A54D77F9E06441ACE198562D2D3541554FFB2FEAE06441EE9B0776A22F35417FD43C4A1DE064419EFCB927B0423541C984270858DF64418676D6D3536735413BA821DB3CDF6441C2843B177E6C35410D14D63616DF644185808E4F447A35410D14D63616DF6441CFE3D56C577D35411C7D783735DF64411A841039CD7F35414F20CE654FE06441F7ACC31BCF8E35415EC673E69AE26441BCFC784E1A8C35413D7BA702ECE264416FF27E525D8B35412D8F4E0248E46441F9E9CB5FDC833541543F61971EE76441A24066392672354108EFC4144DE76441172E0E108D703541A72D83A9E7E76441170FE8142C6935415FF61FCE1DE864418F87D947DE64354184C97D1E31E86441356E61A2686235412581C3953CE8644179A984C10E43354105561AF234E864415E14863FD6393541FC942C9E21E86441D0DCB15580373541163844D5C4E7644196185D1F1C313541E7A3F8309EE76441D8EF6337442F3541EAFF9FD389E4644194A7DBA2460A3541A55AFD8138E4644111CE0785B6063541B0BEC41578E2644102B5ABB4E1F53441979434C145E26441DDAF973D68F43441874BB500CEE16441F4E314B112F23441922CC69488E164413E68CFB736F134412634376E34E06441999F667244F53441F689F7A67ADF6441CE83EAF2B4F83441C3DC725B4CDF64417C3167E74DFA34418366FDD395DF6441584B8B65410435413F1126A2C9DF64410220C86DDE083541	MM
1521	26	BM	Myanmar (Burma)	0106000020430D0000010000000103000000010000001100000026C11A077BDB6441BC07D79AB4453541C09A946E40DB64413237DB395C473541AD18B9C619DB64413AE1911E34493541681AB2D2FEDA64414619503E4B4B3541681AB2D2FEDA6441EE2F4F245E4E3541C542491B4CDB6441AD0FDE855358354178F2AC987ADB64412EB30D52CD593541A6ED4D1A89DC6441CB27BA80BC5D3541D0EFD83437DD6441753B43E8C45B354186FFA7F6ADDE644160FCA61E084C35410D34F976BDDE6441DC24C19C92493541068C44CAB1DE6441FD44ED3CDE463541D8F7F8258BDE64413B9AB53D06453541BFCD68D158DE644138C458E12944354148C5B6D13BDC64414C8486DA3E3F35411389B68009DC644145A193569D3F354126C11A077BDB6441BC07D79AB4453541	MM
784	218	TH	Thailand	0106000020430D00000100000001030000000100000012000000DBE4569DB1606541A43CB7AC4E093641487690E61D61654120B2495A22023641AAACE644296165411B74D787C7003641487690E61D616541618AFA634DFF354119E24442F7606541E65100A5AFFE3541E5A544F1C4606541ED477C3590FE354159F4DB959A6065419C36B52D0EFF35410A99C5817F606541F38B2106EBFF3541BCCE56A80760654101168E8C360536416E734094EC5F654190ED6572CC073641D0D433C4E85F6541C572E7D74609364178342EE8FF5F65416FF8EE08430A364154D0285D4960654161C217E39D0B3641877DADA877606541F678AA6EFC0B3641FAAB210DA6606541F678AA6EFC0B36416319A81DC1606541D96C0CAD1F0B364104D1ED94CC6065410C614AD3C4093641DBE4569DB1606541A43CB7AC4E093641	TH
787	218	TH	Thailand	0106000020430D0000010000000103000000010000000F0000003C665814C0676541CF9BD123136E36416D6768192B686541CD2E3DC556633641923AC6693E6865413DECE125885E3641DB712945086865418E5164FFF45A364154687596E967654143A6429EF8593641725D07D7B6676541262DE40AD95936416EE0EFFB9B676541DD8F97F5B55A36413F4CA45775676541EA0CB8072D5D3641293B4DAA4A67654112157E483E613641A7AEB0D64667654166710075D8623641A7AEB0D64667654143FED7E8D06D36410FB858B34E676541686A91046B6F3641DB86D2F365676541F41EC02487703641E6AB9E7B8C676541FBD09972677036413C665814C0676541CF9BD123136E3641	TH
696	218	TH	Thailand	0106000020430D0000010000000103000000010000001E0000006DD2EF26E6E06441927B4D8D4BA32B41A30EF07718E1644121873CB260892B4163987AF061E1644136FC2FA9FB752B41922CC69488E164417CE11B3F8F732B41EF91605D02E4644138418672F45E2B419578D39EA8E46441DB5775F4C55C2B41812F860391E564410B43BCD6F5222B41812F860391E5644162B9467F8A132B4105AB079D8EE464415697A53E89032B41D45E37868BE46441CF38B3ACF1E22A418C9F129D4FE564412C4E67E48CC22A41A1E0112A58E664415A2D794BFDC82A418E0D2272C9E6644178E7EF46DAC32A41358D3FD687E66441AB6AC510CFA52A41E83649C9EEDF644143AC7BD037432A414BF1A09BB4DF64414ADCD3B6CB402A41ECC8095367DF644131C685C301422A41D3DEBF7E83DE6441BFE6231DFE512A41A54A74DA5CDE644139F03316A0552A41186E6EAD41DE64419B56C23EFC592A41F842C5093ADE6441612BD1A7505F2A41D4E8EE9B97DD64410F366AEBE7D12A41CE562E121FDE6441F514E85D14B32B41700E74892ADE6441EC593E7269B82B415BF3EDBEEBDE644170F53DE9E5B82B41BD34BEAE40DF6441ADD0C5C52BB82B41FB31AC5386DF6441904E57083BB62B4189EE8E40FADF6441BB2EB68761B12B4174F32BB662E064410BA1385CCEAB2B416DD2EF26E6E06441927B4D8D4BA32B41	TH
706	218	TH	Thailand	0106000020430D0000010000000103000000010000000A0000003042B1E94FE86441A352E55EA33C304188E2B6C538E864412E435D7A613B30414F8D7DCDFEE76441F3BC46F9483A3041F164E684B1E764410B1363C2E43A3041EC4BADDDA9E76441604D8E6F153D30411CE0F881D0E7644163B8779FC93E3041D7C1CE4D0EE864410D670351014030413042B1E94FE8644150B0FAE2A33F3041B35DC9C257E8644165610228923D30413042B1E94FE86441A352E55EA33C3041	TH
78	12	AS	Australia	0106000020430D0000010000000103000000010000000F000000E45060298106704136E55230AE2244C12BCFF45F62067041E69BF0BC062244C1EA88267660067041B8D31ADD261F44C1BA64C93166067041DB57F321B71D44C11375BD6D7B0670411ED80026BC1C44C1A0A18EBA1B0770418003B0DCE61744C1B00A31BB3A077041247602CA711744C11FE54A4963077041B7B2C755C51744C1088B13577C0770412487C0CF9E1844C1BFE3C11B86077041B78B3A22ED1944C117F4B5579B077041EA7CDD99371F44C1F030DC649507704177F4CD87A72044C1C744456D7A077041FE8A3BE7C32144C1D9F6C7B255077041E69BF0BC062244C1E45060298106704136E55230AE2244C1	AU
101	15	AY	Antarctica	0106000020430D0000010000000103000000010000003A00000052DC6C5F0FF865416B49343C777962C12D1489A045F86541F3061EF9F57A62C1A1FBCA6733F76541423870773A7E62C13FBAFA77DEF665418CB2F62AFE7E62C1AC1F4C7B24F665419045D3CEA57F62C1D8FAC73839F565416BF1AD71F07F62C1736DECC216F46541DC580C20CB7F62C115D2381310EF6541E6164DD3A17C62C1455239F250E76541DCE56E7A557762C146927F729FE66541EFCB2777D37662C17E3FD2986DE565418FF42629BD7562C121709FF2E9E46541C3D8877DFA7462C1D898A5D715E4654176AD2118347362C1DFA3ED43FFE26541E2FA0D9D207062C1B19DD230A7E1654163723479416C62C104D669E0D2E065413577691D736A62C1BB019AC4E6DF6541D6153B2FD36862C1D7FAEB9E6BDF65414D4755A92C6862C136BC2D0AD1DE6541C3A5ECD08F6762C15FB2F31E00DE65419C1C6A31216762C13609CDA61BDD6541249215DBE86662C157F448CB0EDB6541665AB7FFF26662C1F18D7A2E33D96541EB73470DB26662C17D1E75D580D86541844431503A6662C169BCBC6D01D86541ED275BD46A6562C19C9A4906D8D26541735B395DF65662C11A0333A18AD2654157514ECFF45562C14AB7A18558D265417C005AC3EA5462C1BDDA9B583DD26541545578EEBA5362C120A06DBC4CD265411923C81DBA5262C1F504387F86D2654186A943EFF85162C133D78852DBD26541021283BB2F5162C10E2599B6A4D36541DC623F6B9B4F62C171722EAC78D56541CC9DE669D14D62C1B3480F7877D665412F5FE298624D62C1AD6B8EDC66D765410FBB1947354D62C1BB27288045DA654156463C44BE4D62C1770A49C0B8DB6541667C09156D4E62C1586752BD85E965416E983C23485662C14A1ED58060EB654130A4A2F2535862C1A4D4CE7FDCEB6541C0554AB3F95862C14D6AE0062EEC654103BB767BFB5962C1F273A08763EC6541730F2774065B62C1D248F7E35BEC65417F67102D235C62C1E2D1BC2422EC6541457A8AE5EA5F62C11DCB1AD1BDEB6541FBD5BCBBAE6162C1C89CB23EA6EB654158A0E072A16362C1A971099B9EEB6541628497E3BE6462C1352372F6C8EB65414F71E2B5DF6662C1944B093F16EC65419D1A20DF006962C1C266CD00CCEC6541C5D12991CF6A62C1C37292064BEE6541C95A78FE726D62C1E51DCA2E42EF6541FA70A16BB76E62C162D85FF87EF06541483CEF450D7062C150B6EF94A0F16541FEC4AB42647162C16AD650CCBEF26541EBE3130FC47262C1AC1F4C7B24F66541878BB5AFF87662C152DC6C5F0FF865416B49343C777962C1	AY
105	105	ID	Indonesia	0106000020430D00000100000001030000000100000015000000C4332C9E7D596641D8965C95441826C155296B72A0596641EC0028FC3B2226C1C84C65458559664154797940855A26C1C4332C9E7D5966419A24A3DCD55F26C1D82E8F2815596641E725B7F73A7126C1755E4333BC58664158177507837726C19BDEA9E00F566641BEB2AC04109A26C1C0D12A71CA5566414DCB6FE9C09B26C10048A0F8805566414DCB6FE9C09B26C182C9C23A3B556641BEB2AC04109A26C1028E5378D9516641073762E0656C26C1C4BB02A5845166419E589FBCDF6526C17A792538715166413FB7C8E60A6126C17A79253871516641997807FA735C26C1698C81C39751664119C6D633D45826C1FF71F2553C546641E8C23B3C513526C1DA7442A86D5566417FB2CC14B02A26C1755E4333BC586641994C49C77F1326C1D82E8F28155966413B22BF3A041326C1959FE0F956596641C52EC4A46E1526C1C4332C9E7D596641D8965C95441826C1	ID
102	45	CK	Cocos (Keeling) Islands	0106000020430D0000010000000103000000010000000700000090C5EDDA27936441B26FAA195EBE34C1D44A6DECD19364418D68A9A920A934C13C34F288329464416C82D88D3FB034C16BC83D2D599464418AEC4B45C1B634C11D0949E52A946441B52859C88FBA34C1B41FC448CA936441D1ADB51C82BD34C190C5EDDA27936441B26FAA195EBE34C1	CC
103	45	CK	Cocos (Keeling) Islands	0106000020430D0000010000000103000000010000000A000000148E0E117090644118D27A4B1FBE34C15EE5942CE18F6441DE28243DA6BC34C1D128B23F6D8F644107EEB0FA50BA34C1E22AFF62A48E6441ACE45E2EABB434C1554EF935898E6441B2EEED46A2AF34C107FE5CB3B78E64413D1A3AB188A034C16526F4FB048F6441E8E16127B19E34C1687C30233991644183F80A8316B934C12F27F72AFF906441DE28243DA6BC34C1148E0E117090644118D27A4B1FBE34C1	CC
87	12	AS	Australia	0106000020430D00000100000001030000000100000012000000326BE0420C086D41B3F92C7A84ED3AC185633172E9076D414614D19CA5EB3AC1993E71BCD9076D41D932E38008E63AC1C047E66F27086D416AB5EDBE60C03AC1E28BC8BA36086D4161225EAAA2BD3AC1548F9F4D74086D41C1BA6B9343BC3AC1F7196968DC096D419AC195E0E3BB3AC12F252DC3B30B6D41D24E29F742BD3AC1D063EB574E0C6D41079BAFF1A1BE3AC190AD2F50490D6D41C1A3E79E5CC63AC13EB5DE206C0D6D41A38F28A2FBC73AC18C3B9206780D6D41DEDA0CCB79CA3AC18722595F700D6D41E992F5BE77CD3AC14C3EA461320D6D41496DD1F3F4D13AC1BD0133F0CE0B6D4170429F3F4DDE3AC13770BBAFEB096D416FA47591E7E73AC1521D0204A3086D419016E93965EC3AC1326BE0420C086D41B3F92C7A84ED3AC1	AU
88	12	AS	Australia	0106000020430D0000010000000103000000010000000E00000043AD865BD4FC6C41B60EE853C3BC3AC17FD181D960FC6C419AC195E0E3BB3AC169039BAB6CFB6C41B9D4DC4107B73AC130F269518BFC6C41C5B7294D84913AC1D9675A1C88FF6C41B9B96563F2803AC1176548C1CDFF6C414929570033803AC101D13A141E016D410DADBD59AE853AC170BBD8FF53016D418FBF691D0D873AC1A04F24A47A016D41D8072FBD868E3AC1E3FEF512E0006D41F67E1CDA8EAC3AC1221C07F8CC006D414433DBCC4CAF3AC1A5212BAE41006D4160228C0DA7B73AC1204981D01DFD6C417092EFA063BC3AC143AD865BD4FC6C41B60EE853C3BC3AC1	AU
89	12	AS	Australia	0106000020430D0000010000000103000000010000001000000018D851B3440E6D41F30887CFE6B73AC17C92A9850A0E6D41F0C41093A9B33AC19BDD7569B90D6D41A1C774E971A83AC1FA2530F2AD0D6D4154A4D2FDF3A53AC1478CC097120E6D41C5B7294D84913AC1096FAFB2250E6D4115552F95C68E3AC1A5741160110F6D4142DE376910833AC103444406950F6D418E39B183747E3AC1561C72F5CA0F6D41307076C8157D3AC19419609A10106D413940C592167C3AC16465F1B542106D41143BCC7FFC9A3AC1CFFD14984E106D41F28F8C1D36A33AC1A3FB897DA00F6D4175238FB9ABB03AC113064BA97D0F6D41C250E342CAB23AC1F88C85CF950E6D41925ECB1067B73AC118D851B3440E6D41F30887CFE6B73AC1	AU
97	161	NC	New Caledonia	0106000020430D0000010000000103000000010000000E000000E94998F4286471416A63E27E9A4E41C1786F7E6600647141102D9FD9274E41C1DC49F9786D6371410B44BC143C4941C113CFD90E5C637141AAE9A94F364841C18339053D5863714123CC871D204741C1CA2788D365637141BBD034BFD84541C180F024F89B6371411029969F604441C16906DC65E16371418F43DC156B4341C100A4CFE60F6471414351EEB1AC4341C178DF6CC62C6471411029969F604441C14F63C42E3E647141FAA6755D664541C1F01A0AA649647141420EBEBE8C4641C1A2CB03BE4764714170566E45074E41C1E94998F4286471416A63E27E9A4E41C1	NC
99	161	NC	New Caledonia	0106000020430D00000100000001030000000100000012000000303E87481760714198F2B563030A41C18A276D69BC5F714139A8B66D090541C1B4A31501AB5F7141A5D3B127040441C16414C856315F7141CDA0D3B378F840C189D13184B15E7141114A27EE82E740C1F1DAD960B95E714118BA99F11BE640C1C75E31C9CA5E71411BB1029006E540C1B5ACAE83EF5E7141A08C26F147E540C1B074E836105F714126929768CAE540C123CEF96C2F5F71418C5A81DE7DE640C16484B6B65D5F7141CACC467536E840C1001A2A041D607141DF8C02A8F1F340C10D1AC97FD8607141B373BD0FD90141C12EA5DC25FF6071411B9EAAEC4A0541C1AD184052FB60714116DC6178910641C131EEBC6ABB607141A6FD2B83B70741C1DCB6BA13366071418C13C81EC20941C1303E87481760714198F2B563030A41C1	NC
100	161	NC	New Caledonia	0106000020430D0000010000000103000000010000000E000000B36DFD5B475E7141652313671EE040C18C3A3509155E71418F3D28B0FDDF40C11C601B7BEC5D7141A233D6738BDF40C137934452635D7141362E51E1EAD840C194DBFEDA575D7141D1DA7F73C5D740C1B406A87E5F5D71415F47969E5ED640C1944BED3A845D7141B531B80B34D440C1BE3784329F5D7141C55BCA9D80D340C10ACEBB75B85D7141D1F0C3E95FD340C15ACDF77F5E5E7141881C6B1867DB40C1A12B6976985E71412E7317DF34DE40C18100C0D2905E714171B06F424ADF40C1012DF2A3755E7141D85321130EE040C1B36DFD5B475E7141652313671EE040C1	NC
2670	36	CA	Canada	0106000020430D00000100000001030000000100000012000000A264D104694C61C1F0DCCE9232FF5941D11840E9364C61C15C6C2EEA4FFE5941EA9B34E0324C61C1BBA4D6C23AFD5941FFAC8B8D5D4C61C1C327819564FC594162EE5B7DB24C61C1ACC6AFE0D9FB5941F4C377112E4D61C173604527B4FB59418003FE88E45561C1151B07E73EFC59418901EF5C245861C13EAA0083E2FC594115454A67275961C10A293FEB6CFD5941CC0DE78B5D5961C1C1ABC3A636FE594116BED149985861C1829CF8830CFF5941E1916B91315261C1D74C1881EC035A41E7BCD63DC25061C1C75F39D683045A41B3A0F92C375061C1BBDCAAC944045A415C3C78B3924D61C1796E16D200025A41962A5CCEE44C61C18E7BC8BDDE005A41BA8E61599B4C61C141ECD5003B005A41A264D104694C61C1F0DCCE9232FF5941	CA
111	12	AS	Australia	0106000020430D0000010000000103000000010000000D0000008CF4750C6DF469419CCD05E0F7B74EC10F30B1251CF46941A8A91DC462B74EC1F476A5CBE5F3694124E136C5A8B64EC168C53C70BBF36941855D7A36B7B54EC14E9BAC1B89F36941E4F22B4BCCAD4EC1D6CFFD9B98F369410B1D88CC33AC4EC1ADC34364D6F36941C7D4261867AB4EC19CE1198146F469417FFF2F4A42AB4EC1F0CF3B930FF569412519513582AD4EC1C55FA3273AF56941CD45480599AE4EC17DAC41C02AF569418B6D4D0732B04EC191A7A44AC2F46941855D7A36B7B54EC18CF4750C6DF469419CCD05E0F7B74EC1	AU
112	12	AS	Australia	0106000020430D0000010000000103000000010000000B00000078A9EA9C56276A41FD903F7212AD4EC19790D84CF2266A418ADACF7DB5AC4EC12A0A1995CF266A410CCD6CA0C1A64EC14398871D15276A41857EA33C1AA64EC11F2DCA1E1F296A411DE1FA3CFFA34EC158E6E14A6C296A41C2DA3C4894A44EC162A7CF9E7F296A415CBEC9D607A64EC19B800A0B74296A417170DFAFA0A74EC1E5B76DE63D296A41C99D98DD9AAA4EC1CA29FF5DF8286A41A96F29B154AB4EC178A9EA9C56276A41FD903F7212AD4EC1	AU
113	12	AS	Australia	0106000020430D00000100000001030000000100000010000000D7334B8972706A414FA6BFE6AD623AC1EC594BE5FA6F6A4107C23C331A563AC1FDC85AE5236D6A413DA61ED48E413AC113CF3701056D6A419A10D0F8903F3AC1860826F77C6D6A41A16C5A6AC42D3AC1318159C29B6D6A419D4C3BC7862B3AC17A8E6A40AA6E6A41F975DDDE361D3AC1122C5EC1D86E6A4112C223DC981B3AC14A8197B9126F6A41E174E3625A1A3AC1C83C78F784716A415603BBF265103AC18CCA926878726A41BB1A77CBA60F3AC1455C869749776A41CD06AE78E24D3AC1EBB0062A17776A418B4D18B5804F3AC1DC5C0DD855766A41CF6F17F55D523AC1660AE63AD6756A416FB9E74FDC533AC1D7334B8972706A414FA6BFE6AD623AC1	AU
114	12	AS	Australia	0106000020430D0000010000000103000000010000001300000074D62CECC2686A4144FD78E0652C3AC1EC9661DA69686A411D916DAAA62B3AC1607EA3A157676A419577107F09293AC1C9917A9B73666A41ACC677A38E243AC11E1947D054666A41481118F190223AC17A36648758666A419631BA11D41F3AC1CD392F487F666A413569A40C161E3AC127BA11E4C0666A41BF046338F71C3AC113721141316B6A41D6DDE6006C0B3AC1F00D0CB67A6B6A4167EFDA81CC0A3AC1135D6892D36B6A41E277D144EC0A3AC1AF7773EE1C6C6A41D6B4BE47EB0B3AC1E9F749B8476C6A411B877C36A90D3AC196D45BB7796C6A41C5E87042E4113AC17C5167C07D6C6A41EBDD2B2761143AC104FF3F23FE6B6A4178E0936711223AC14E56C63E6F6B6A415C8BF300EC263AC1988D291A396B6A410CE285854A283AC174D62CECC2686A4144FD78E0652C3AC1	AU
115	12	AS	Australia	0106000020430D000001000000010300000001000000120000009D29F55A937F6A41459AD336391B3AC1EB080DE3687F6A41EC64FE17BB193AC1DB9F6AE2497F6A41BAB5DA74BD173AC1B8F7A963277F6A41B216B15A880E3AC1BD74C13E427F6A41ECACAFF3CE083AC18EEBEF2B657F6A418DFD0D8B91063AC121450D349B7F6A4124216E4433053AC169E3C5EC4C806A41D97EBDE672053AC1810327246B816A41CEAF9A2DD1063AC100576710C0816A41EA16E7AA70073AC1C1E0F18809826A41B0B8AD706F083AC177A98EAD3F826A4143354C7DED093AC196D4375147826A41137B78C96A0C3AC16740ECAC20826A41D512B45C680E3AC1F52621F74F816A4177C3BC8041143AC1CCB311E2A5806A41774F88DE1C183AC1D1504CFD67806A41B408BBEA1B193AC19D29F55A937F6A41459AD336391B3AC1	AU
128	105	ID	Indonesia	0106000020430D0000010000000103000000010000009900000002F0A7022C4F69415182DC9CF98630C13516B430CB4E69415182DC9CF98630C1D8E2A256344E6941F04D3613E18530C19699A7A7CE4A6941730FF3C9D77D30C1EF072495D4486941D893A0E6BA7830C10163D55AD5476941D6BFD99BF47430C11F3F4979274769415331E0F26C7130C12CA45B819C4669418B6EDEACEB6C30C179484D90A540694104D71E925D3730C169DFAA8F8640694197A3C9DE4B3530C1A234E487C04069411957D8053D2E30C1EFD777AD51436941AE11E196B20F30C153A8C3A2AA436941E74E07AB690C30C18F018D938E4469416D7C3797BF0430C17BF1805A9945694171BB56015CFC2FC194268B40154669414BEE640339F82FC1D88BE711184769415B29EE6262F22FC148BBDA932E4C6941B73DD35515D92FC1907F10174F536941DA9969FFACBA2FC1EEA7A75F9C536941C5E5CAD875B92FC131C9483D335469417B39BE5FE4BB2FC175391FA07F556941F0D39676E4C42FC11678DD341A566941D98FFF3C53C72FC1323C65A4EC5869419ACA7741F2CB2FC1D7EDF8814B646941562D2D6300AF2FC1EDDE2CEFCE646941ECA504145AAB2FC11A6CC01FB6666941D9613BABDDAA2FC15DE6C59F16676941D9613BABDDAA2FC13A82C01460676941C013DB7CD6AB2FC14E687AF09967694124C25B6F45AE2FC11EB40B0CCC676941B63CC85930B12FC1F02A3AF9EE676941D8CA94ADD6B42FC1BFFD4332B0686941BA0E4BE4C1C02FC1DA962C4C3F69694198BA7ADAACC32FC140B23AD7826B6941B31792B1DDCE2FC1C349513CD06B6941E3A30C8A15D02FC18BB2F4BCE76F6941391C028A00D32FC1B001519940706941DC44041D84D22FC18063D6D7057169412BBA62A629CD2FC17B6D371A7A716941A2ACA7144CC82FC178DCC388897569412B0ACBC761982FC1125E24C2BA766941BFDAC8FBD7872FC17291359C51776941A49599807E792FC1CA111838937769418D0DCA07CB772FC103675130CD776941020A0D6C397A2FC1475FEB24DE7A6941374D04D159B42FC184313CF8327B6941DA9969FFACBA2FC134E4161F367C6941B31792B1DDCE2FC16867490DA97D6941E3CBA0611DF32FC13E7183F8797E69411F70E53BD40130C17C43D4CBCE7E6941BF33A5D0FD0430C1089CD8842F7F6941CA32F777080830C1D34A2F859F7F6941189ECB3B580A30C18F86B467DC806941ED934D5C740F30C1CAE667F15F8169418F3CB369281130C1A9A6159FFA8169415F292AC95F1230C1F7EC8204B88269415F292AC95F1230C115942A34058369413CEBB327C41130C191593A8F8B846941F008CE702B0C30C10FAD7A7BE0846941B1A62A0BCE0B30C14802B4731A8569418CBCC167050D30C11DFABB59628769417DADFF1D801B30C16BB9B0A1908769410C891908151D30C1B5FB8D0EA487694133A1BAC4641F30C16B4029BF1F88694194B3CFFBE43A30C18F13870F33886941A2F941CA3F4030C1D3ADAFCF3A886941C7919457BB4E30C1C9733A99B68869412DE525F9AF5930C1D4980621DD886941311B5E8B835B30C10CEE3F191789694172459BC69B5C30C1B640E3A4848C6941C22AA5E7ED6730C114697AEDD18C6941431BA8F6896830C1C050067E4D8D694163B8B615786630C1CB1C6E63AA8D6941672360EE6C6330C1185861371E8E6941361E5C9EAD5E30C1F26F5A38AD8E6941E4CC18AE4B5A30C1E4F10E89308F694124F10773785830C1A12A6CF0D7926941ED6664603C5330C1A8DD9A2E2D936941696237EFDE5230C1C584425E7A9369418FBB4DA27A5330C15C02139F0194694149BF00AB8C5530C197E1A795BD9A69413B75CE74A98430C1B00B38EAEF9A694160E4AE5A1F8630C1E09F838E169B69416BB69211F38730C1FF3CFCA04F9C6941C4C29AA20A9C30C104BA137C6A9C694111F9DAB51C9E30C10E7B01D07D9C6941001B82A364A630C1324E5F20919C69417A4DDC0BB5A830C1AA248831CB9C69410211912FD9AC30C1D46D45E9B99E69413A2BA1BCFDC330C155055C4E079F69414372DE4086C730C1DD198A8E6F9F69418D77E41734CA30C17314A4CF71A16941F005FED6E0D130C129BD1DB400A2694162C4042A57D330C14E17F421A3A269410C0617A450D430C105C06D0632A369416154C3F8C6D530C158AE8F18FBA369418A736BE174D830C1C95802096FA46941922494B8C5DA30C1EDB2D87611A569412E53E7B0ABDE30C1A55B525BA0A569410C726E8D0EE330C14FCA5609ABA6694173C5B2768FEC30C1A3D89B5B1BA76941A9F1F6F6EBF130C131957E488FA769417C912B7B35FA30C169F531D212A8694148E1EE53C80A31C1E83DF82C1EA869413FD7CF76631031C1BE51613503A86941905001BF621531C1AE84E000D1A769418373E945E51931C131957E488FA7694168636476AC1D31C1FC4D046613A769413511B018CB2231C143E7AD0833A26941EB623FCFE04B31C129BD1DB400A26941F537E075574D31C16327005B98A16941E8EC4F2E065031C15F237062EEA069418FFAB4608F5331C163B530EC66A06941570237C6635531C1BF0A420D059D6941B23769D8EC5D31C104BA137C6A9C69414077F9F1245F31C1BA9C7956809569411F135077C16931C1110DD34AE68F6941D7C6D5955D6A31C1C90B9A4799866941248E5F77AE6231C10BBE93319483694123673B0E3E5B31C1B33DB195528369410CE157B1635A31C185EF1871847F69415E386BB0834131C15DBB0468F37C6941CC0F9C737F2931C134E4161F367C69418DBE8BA5BF1A31C1C339A42EC27B6941BE9C521B890F31C16ED2FA39887B6941A176513A640B31C1CD731965467B6941FD2FD6F07D0731C1086C2C9DAC796941078738344FF630C18AB196D36F78694143FADC9E57EB30C1CE4045022E78694117A49E187DEA30C103675130CD77694117A49E187DEA30C142DDC6B783776941994A951219EB30C1E1BB1908D676694129727729B5EB30C114E225367576694129727729B5EB30C1C1A519132C766941994A951219EB30C181FB3586E86E6941B522025746CC30C180BAA20D126C694101F566623DBF30C1125E35B3AA6A6941D6A95BD9C8B830C1B4997C9E706A6941B1A3A71E91B730C166C49333AF69694134E8EC4499B130C13BD8FC3B946969418E5054AA9AAC30C162AB5A8CA76969410DAF34432BAA30C166C49333AF69694196F4772991A430C13BD8FC3B946969413FE41C107FA230C10D44B1976D69694139927193CAA030C1EF918FD6D66869412E5107C0A69C30C1894BE479A2666941D7E423ED4C9230C1CBDA92A860666941D796D773539130C18E7B6F2DB55E6941825474DA6F8830C1ECD8D264075E69416BB69211F38730C164072695C55069412DA224BCE78430C13930384C085069412DA224BCE78430C102F0A7022C4F69415182DC9CF98630C1	ID
2696	36	CA	Canada	0106000020430D000001000000010300000001000000190000005F14C42192C660C13A1C3CB4FEBE5C418976B678E3C360C18E5F8200C6C25C41F78077A4C0C360C16F658953E1C25C419F0095087FC360C128C1B31D57C25C4106D425824CC360C12358D3258FC05C41F1E2F114C9C260C1AD9CE4298CB75C41D9DEDE8A05C960C14C28F5109B985C4101289C42F4CA60C10B9EDCFD368F5C415516BE54BDCB60C12DD2A7B71A8C5C4134ABCE3067CC60C1B06110257F8A5C417D69AA29C0CC60C1E0F0E981038A5C41686E479F28CD60C14EE3E0E0CC895C41A76B35446ECD60C1430D2276DA895C41B6D4D7448DCD60C11E4A29051F8A5C410F75DD2076CD60C14FB74D4BD18A5C41F0A2981F38CD60C11C694A9CF18B5C412E8A92A1EACC60C129F11F84B18C5C41F53459A9B0CC60C1A3AD42DA9A8D5C4110F89320FBCB60C14D002A348E905C41AEB6C330A6CB60C1F89C82A553925C41E438770131C860C184BFD5DC6EA95C41587C9414BDC760C1C86EDFDE8DAC5C41234094C38AC760C1E92943B82BAE5C414833155445C760C1A92A833CF1B15C415F14C42192C660C13A1C3CB4FEBE5C41	CA
3198	193	RS	Russia	0106000020430D00000100000001030000000100000018000000C881E25AB8365741FB91CD4A90356E416AF061D06A35574136833164C4366E41DFCC29060F345741E3CEEF676B386E415E8FC2B7C0345741A4E91BC9863A6E41C818F918B83557411783247F453C6E41A0F8E0A6CD3757413E3B9C40C13E6E4125D18A84F13A5741DA11CBBEC33F6E411E8AADC4D34A574180460C87AC3F6E41A4784BC58A4E5741C08D719209406E41035E7412F45157416BA6352EAF406E41E0291B6FC0575741AC84C6A471436E41D49B017EC55A574151435E38A0436E41ED22B892CB5C5741391BCA0EF9416E4150849AD1D7685741D6A8E06E92346E41E7A3973AD46C5741CC10B150712F6E41AD667E9ACC6C5741D4E14BA56D2D6E41990EF54F616B5741F2BDA3153C2B6E4118C2B171EE60574185E3099E7B246E4116EF2B4A3F5D5741159B324C1F246E41E2457C915D555741E0E3C76536246E41C326AB68174D5741DC43AD72AB256E41B0F8737B674A57419EDEAFAB20276E4120CCAF17123957419F0860441A336E41C881E25AB8365741FB91CD4A90356E41	RU
3199	193	RS	Russia	0106000020430D0000010000000103000000010000001F000000D6092549F7985641E1417B4F5C346E41EB7D0FB6FF975641E20CC4ECF0356E41D7E53FEB45975641EF12B150C6376E418C3F844A1F97564159BB0405D03B6E418D2B2610F79856417F16D39C27426E41911A0D5A439A564104041C9B74446E41B6D8102A389E56416D1222D13F496E41DC77EDFF7BA056413472965B5F4B6E41EDC7736272A256413564277BC54D6E41659322E262A256416424320BB74F6E41C51761CD9B9F56418D68154631516E41771475D8049256418603CC71F7536E4111F81BD98B8E56410177549A2A556E41F88659E7188D56411BB71D30ED566E41D04D25D705915641B94F1AEC93606E4156502112E5925641E837DD4B3F626E415B2BAA21099656411111D11546636E416738A57F3C99564185F9022458626E4131862161FCAC56410EAFED9426596E41E5B9C48F34BC5641FE7CD957583A6E41EBB0AEC1F5BC56410F85089282386E4139A8E6A1FDBC56413D4FFAC47E366E41ECDA001FB1BB564108DAD7974B346E416054480ABAB1564190B2F22E3B2A6E41C9E0A6E646B056417525B64F23296E4193F143AE0CAC5641C8A824C77F296E411F744B96E9A75641C84DCCF1982A6E41659322E262A25641D4E14BA56D2D6E416E3A5871869D5641C8E189735B306E41CA651735699B56414C5C0068EA316E41D6092549F7985641E1417B4F5C346E41	RU
3203	193	RS	Russia	0106000020430D0000010000000103000000010000002B000000185264C875915741AE45345492796E416ACBC2992A975741E67E66901A7C6E415975AD554AB0574108AD917135856E41D11ABBA499BF57419C7FEF24B6866E4153EE414979EC5741F85E12170B8B6E41B71174F0A1FB57415FC0F8A8438C6E419F41E2E0ADFF5741C20E19C92B8C6E41627ECF40FF035841133D4D14CB8B6E410DA33AEB741C5841E4EA3E99C97D6E410A8B8AF5F12C58416FF0FBE4DF706E4152FFF050E82E5841822F7DE6486F6E4140A767067D2D5841F8374C2F22656E41A444DF98BD2A58411270512275636E4105D9CA91041858413EF0251C7E5C6E41F4B2968CC9145841D59D1FAD905B6E41D4FA3EA79DF75741E7D13F6639586E41EE7A1C14F4ED57415CE6B5DBC55C6E41A6C66F38AFEC5741825B8B29885E6E414AFA7F924DE957413FE4FE2CD55F6E41C713E5790BE55741AC851B8B34606E41C5BE556A8EDD5741AF71532EA65F6E412B914ABD94D65741D19CD52F595E6E419A68378659D35741D88B4617545D6E419616D0F171C9574101F08972B95A6E41F30861C874BD57416681893BD25A6E41B89D449E97B057415943B7D9235D6E41E2CF9F06FBA05741A16FFB4FF3606E413E25B127999D574185F9022458626E41B61AB204459C5741C30521AB03646E4186EDBB3D069D5741579D276E3F666E41991BF32AB69F57411E955BDCEC676E41D034A8C0ABA2574155E3669439696E410956603E16A55741F0A5641E476B6E41355FF2FA42A7574189B4A566B36D6E41406F15D40BA857418ED6C542D96F6E41B86416B1B7A657415E04A7AC9F716E41A11DA61C00A45741472AFC5E1F736E41991BF32AB69F574178360AF27D736E41B39EF812A293574199E10DED96736E410943D381D78B5741B37128A84E736E4195A97947178A5741AE88D92C86746E41AC1A3C398A8B57415336D2A6DC766E41185264C875915741AE45345492796E41	RU
3205	193	RS	Russia	0106000020430D0000010000000103000000010000003B000000339A15EDDFEE56417475AE109A9C6E41FD4D797F8FF256416DA4BF1EA0A16E41AF3AE07CEAF45641A5FEEE0EB7A36E41C060148225F856414933490CC2A46E41579AB63ACF0A57416D99DDAEF1A66E410C4187C1B0125741D38F19D351A76E41885E9DD5881C57416829AA9D25A36E41CEB6A20EE22057416F08D433C4A26E41FB51A3F485425741CD99799DA6A86E41FDD4358ED8565741FF8AC72B76B06E4133EEEA23CE595741C1245006E4B16E41026D50A2185D5741E99CBB37F0B26E41AF5FA5F21C615741C5C3FB6382B36E41F952EDBA4B695741C5C3FB6382B36E41C3C60ACDAC6D5741CE78E48E20B36E4138ED36AFC376574121F0BB89BEB06E41ED00C88E447A57413DF826DF68AF6E41FBFFD1B1597C5741E1315CBAC9AD6E419DC78D5BFE8B5741D31B9A750BA56E4142683C2C5C9C5741DAB7F648689E6E41A984952BD59F5741FB0B8399149D6E41CBCB7B8B47B35741AB4BFB4BB9986E41A296F8A74EC55741F67054E1FF936E415FE72639E9C557412DFDBDA71C926E41EE905803ECC25741A09CA54ACA906E41594F0C25A9BF5741FCAEB1FCC08F6E411278257F17B55741A901C19CC68D6E41DC8060EDA89457413F110C9FC8886E41DCBA5F587283574156F3DDB116876E4106503B0B717C57419A19F982C5856E415689753EB76A57412FC9A2681B826E41D0B0CB6093675741D6AF742F82806E4119985F1433625741DA184922227D6E41C34050B8C45B5741341B6EFE127B6E4113FC93D3D84D57419F8FC2F743786E41F3A745EACC49574131AE179B5B786E41368491318345574110EF53B2A2786E417A2FB273CE3657416F99C8750A7D6E4136AA32622436574139EC5177EA7E6E41FE4ACA4CD636574143A2ED0912816E4111A3539741385741FDC7AA7A54836E41947E25F0FA38574176DAC71F7E856E41DC1CDEA8AC395741C3592826A8876E4129141689B439574191C3E27BB9896E41D1360D2D9F37574135DF759A528B6E4167017B861E3457415E567761A48C6E4127CAB1DC412F5741EA996B6CAD8D6E411AA7C25B7B2B57412A0C49F94D8D6E4119DB54C73A1D5741CEBC52ECF18A6E410DF4FA99A80A57413F110C9FC8886E41E0FEC617A40657413F110C9FC8886E41C099426F050257416B56117988896E41DAEFCD7EA0F956419E8271F3E28B6E41B758F490D1F656412A0C49F94D8D6E41CE55007916EF5641A4A4EDAED3916E4132DD83E8C3EB5641565A49886A956E41F48631A1B4EB564127D807847B996E415CD5DFE55DED564198C048C6779B6E41339A15EDDFEE56417475AE109A9C6E41	RU
3206	193	RS	Russia	0106000020430D0000010000000103000000010000003400000070FC4EC6289B58418F040CC5BD9D6E41297B7CD9F3A3584148706C6BD1A16E41A1A9ABA37FAC58411222DB4AD8A66E412A8A586918AF5841F06FBB1CD8A86E41F5E459DD50B558411DB715DA80AB6E4188E0F23B3BBC58415719DEB11FAD6E411414904740D9584190D444509AB16E4183713725EDE75841FE6697909AB36E414A89AD9462EF58413720B3A076B46E41B5D4335E76F35841396E67725EB46E41A21DDBF589F758417D52386308B36E4142AF902DE4FA584190D444509AB16E4141D2CAF7300459415719DEB11FAD6E41EA81944372095941B4EBB38CFBA96E41AAC1A91E590B5941EDAC110845A86E415AA3E5B8A91059414F0A41FB2F9B6E415FF19B20770C594168B3FE61B2906E4170CA43FEA90759419E8271F3E28B6E41C6FE1890CB0459414F9419E6318A6E41A56F428A71015941CD97100041896E41E74B8ED127FD5841EF0E0557D1896E4164E3E9D017F558414653A9B6748C6E4100CF93B913F158410E2DDC808C8C6E41A532637077E958414DFBA0FF138C6E414445373B99E6584160D15E9E618A6E413A272327B2E45841A5C968DD7F886E41D09DECC5BAE3584133A44BBC6E866E41684F3E8111E25841B2F08C1C2D846E416AABE523FDDE5841FFDE513DDC826E414D3548C5AADB5841AE403D9AEA816E415BCB649E1AD85841FA241FEB42816E41C98C5D444CD4584143A2ED0912816E41AE56066648D05841B4DF88202B816E41F03252ADFECB58414E475F4DA3816E415F3491D37EC75841970881D17B826E4119B2393D6AC45841205EAA4E85836E41BAE06E2A29BF58414B62D04F9E866E419E6AD1CBD6BB58417D32916D07886E41B53A63DBCAB75841879249DA58896E410251245905B35841D04E9064798A6E416E392AD87DAE584135DF759A528B6E41B015761F34AA5841133D4D14CB8B6E41C8E5072F28A658419E8271F3E28B6E41B786A53C0D995841339BCE89958D6E41C04139065992584128EE8F7169906E41E7501BB9B08F5841B132C699EB916E41A3F5ED04C28D5841611300EF9E936E41AA162A943E8D5841101E1B7A82956E418D6B0F75268E5841B5EF5E04AE976E414992EBA80590584141E0706793996E41B920FD76DC92584144D5F8E1479B6E4170FC4EC6289B58418F040CC5BD9D6E41	RU
1759	93	GR	Greece	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	GR
151	105	ID	Indonesia	0106000020430D00000100000001030000000100000030000000D0B1B6B4E1156A413FD1EA0D644332C1198B93620D1A6A4172DBA4EE9B3932C191EE8E1B9E216A41E556AD79862232C10E42CF07F3216A41E6A0DD763A1F32C19A9AD3C053226A4183009C394C1C32C1DB15585E9C276A4139BCD20FEFF631C1B3E79DDFD22B6A41D13060A0DBDA31C176E58F330B326A41A148CD097DB631C1EEBBB84445326A413187648344B531C1D95C77869A326A417EB33A1906B531C112168FB2E7326A41D1002A2783B531C170DA47C721336A418A862374BBB631C1E308BC2B50336A41E22D0D1320BB31C120DB0CFFA4336A41FFDE16F3B1FB31C170DA47C721336A416DC263B8282232C1051E3D03122F6A41791E859BFF2832C14A656E205A2C6A4185AE9D04EC3632C166B6D928732A6A4174F2C167604E32C1574D3728542A6A41AD4D01F1735032C1A0A4BD43C5296A412025F56DC85732C1D0B190CA5C296A41295F13A1785A32C154D7D7C078286A414EE581703C5F32C15869984AF1276A41848E625BF26032C17AD4876E47276A41F7C9F8C38E6132C1547AB100A5266A410FBD7FDCB36032C1496A8E27DC256A4176D1C6BD035E32C122F77E1232256A418D201B73675D32C15CC53FEDDC246A413E4A9905C55D32C1DD6BA576C01D6A41F897B0CAA16E32C19E6EB7D17A1D6A41BD072CB87C6F32C1CB8CA30EC61B6A4106633726937632C17625FA198C1B6A41898E17E8CB7732C113E4292A371B6A41AC254DA1F97A32C1EF10CCD9231B6A419D3EEB646B7D32C15D2607974A1B6A4136023830217F32C14661028EE2156A41F39CD2A4AC8D32C1C3C9EB2895156A413FDA67FE488E32C102DC827C38156A413FDA67FE488E32C14C330998A9146A418E269570D18C32C1BFDA04DF48146A4106D3E391E28932C18BC9A15F07146A41A2A3C36FF98532C1FABD6E6851136A419D36E455265832C1B07B91FB3D136A41C181DB6CC65232C1570629F145136A415FCA2244165032C1027F5CBC64136A414C73729E024E32C1C8864984FE146A41DC5E1BE5114632C1BE4CD44D7A156A4175DB062DFE4332C1D0B1B6B4E1156A413FD1EA0D644332C1	ID
153	105	ID	Indonesia	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	ID
143	12	AS	Australia	0106000020430D0000010000000103000000010000000F000000F0B4352CF7FC6C41E1F926E8BA1134C1E26BB66B7FFC6C41AA6EFB63080F34C13564079B5CFC6C4106D06D3F120D34C1A215642470FC6C41EC5126C25F0A34C1001ED82C16FD6C41710E9287DB0434C11BD7E3864CFD6C4102949322240334C18CDABA198AFD6C413CD9C990090234C12F4563789D016D41394A5D7692F333C16F42511DE3016D4147A31A5C34F333C18D4DD78043026D41939DFB8953F333C11F43165566026D410641C1CC49F533C11F43165566026D41E38BD847FCF733C19DD69CC109026D4120D62AB34BFB33C1955F240B59006D41847D753C1A0534C1F0B4352CF7FC6C41E1F926E8BA1134C1	AU
144	12	AS	Australia	0106000020430D0000010000000103000000010000001400000015B874BBAFE06C4196FEB2F760EA33C13E47E5F2F6DE6C41DA6DBF9146E933C1A221600564DE6C4111E8BFE411E733C155BBCF5FFFDD6C41A3AA8721E2E333C12A40BD62E0DD6C4125325CF1EBE133C1F739D474E8DD6C410C10C603FBDE33C155BBCF5FFFDD6C4172F6E9FCA6DC33C1E5B00E3422DE6C41843F4B8B91DA33C1B28A020683DE6C41C3D47F6081D733C1238ED998C0DE6C41D85CA96B86D633C1638BC73D06DF6C417312853D8BD533C156AE78C755E16C416B86C0ADB3CD33C196AB666C9BE16C41D7F4866BF7CC33C141FA47DAFEE26C4130E02E03CECE33C160CC8CDB3CE36C412AA05C3CE8CF33C16C1CF63454E36C41FB2D0485FDD133C15CB3533435E36C416594EFEC12D433C1543CDB7D84E16C4142BC5367FCE433C1F56CA8D700E16C41EFEC47DF02EA33C115B874BBAFE06C4196FEB2F760EA33C1	AU
2770	36	CA	Canada	0106000020430D00000100000001030000000100000011000000475BA60130826BC12DA6CB8F88815A416ABFAB8CE6816BC1BF6B462F487F5A41D850E5D552826BC178AE13F1AD7C5A41B52C284F3D846BC1536193F0AD7A5A41239E3E5802856BC12CC80047E1795A41902F78A16E856BC11094E850A1795A41ABE883FBA4856BC1694DFEEC6D7A5A41D55164F33A876BC1F81E1A5163845A41D0382B4C33876BC11E36579F63855A410E83B88DC3856BC1CAC481404A865A41FE3939CD4B856BC10F3511F663865A41F0F0B90CD4846BC13A79A4D516865A418A51AA0DD6826BC19BBB685470845A419833D4F065826BC14B3B5A21E3835A415A36E64B20826BC1FCC19B992F835A41B97EA0D414826BC1D277356C3C825A41475BA60130826BC12DA6CB8F88815A41	CA
1760	93	GR	Greece	0106000020430D00000100000001030000000100000011000000CF1EDCDFAD584441AE88DA7C8710524183081B62735D4441EF81E4E51E0E52419AA32FB1A15D44417ADFD4709D0D5241739F7861545D4441DF789A6E120D5241F5848AC811514441EB673E64A80152413459D327534D4441DC01C82390FF5141B9196E9E34444441AB16B541CDFB5141644D9B01B2424441FF4DF00A4CFB514180F8B520CA4144416B6ED9C087FB5141648218C2773E4441F6CEADDD7FFC5141F9415BB8EC3D4441C115510F64FD5141C0CCFE7F0B3E4441456BF63EF9FD51412BF2E3187E514441DF789A6E120D52412010266D0C574441530A54AE1C115241C1BD3CC703584441D7C805A130115241CF1EDCDFAD58444173ACAA16E1105241CF1EDCDFAD584441AE88DA7C87105241	GR
1762	93	GR	Greece	0106000020430D000001000000010300000001000000150000001393298FD73E4541BB4E128330375241F40BF4CD7041454132EF5E748636524134E44FFD4D454541FF06454B153552412BD104A9EF464541A8E392FAF333524101C54A712D4745414B09F171FA3252416F80D61755464541D65525A2EC3152418F82DA7558424541CC9C5408282F524190ECD4F6E33945418EC788B8EF2952414FB8D1241B394541DF8FF902B42952414257320C71384541C9A7D4D8E5295241FCF301700D3745410C5D0B97A62B5241EF926257633645413EECC20D822C5241581FC133F03445411F70D21DC82F52413D7CA9FC4C3545413902A29BFD305241ADEB93D0723645412E7E04A7543352412500BCA7CF3645418AB5F035E0335241EE5DE5969D3A45416A60141FEB36524188D989A2853B454169929A28513752417568E4B9F13B454180AC3231763752411716FB13E93C45412C3824388A3752411393298FD73E4541BB4E128330375241	GR
1764	93	GR	Greece	0106000020430D0000010000000103000000010000003C0000009631EBA68C9B4541F3A23179BC7552411DCEA0BFBC90454177E58215516E524116981BA1118945418C49483C6F6852411CA3630DFB874541F5107236886752412D68ADB0058545415A664AFB1E645241470BC5E7A88445413A1F0B6F92635241A4E2DFF014854541EAA598970160524113C59579628545411F0EC76E935F52415F52357C60874541C026CF4C0C5E524123DA93BF0A8845411C0A18FBB15D5241F6C5D69FD388454155260D066C5D524151BC18A3F08A45417B1E066A715C5241CF8CA28FC08C4541091D743BE05A5241F8985CC7828C45416EE23CBE5D5A52416D4009E0E2884541A4428913EC5652416B6D83B833854541F353160B465752415FDB56F79C8045412F081259FA5752410C1787428F7E45417E8461FF685852415D08D1CFED7C4541446011CEF45852410F732EE57A7B4541DCCB8F95955952411AADA31BFF7A4541B156CF7FF95952411084C6478F754541742F1EB86F625241E393EE8509784541FF1ABC0E60655241BA87344E47784541072C8471E2655241B350049C377845419AE06E066F66524171FDD9CFBD7545410BE539D15A685241B5ACAB3E23754541224EE514AB685241FC638095FD734541E9866388DD68524136099C2AA46F45419FC4686FE768524102A445C2AC6E454115BC1C67C9685241FCECA1103A6D4541C08B5EC93C685241E8A87600F7694541D12F722683665241D618AA1DB268454102FB14FE69655241D9C8F57A1463454164387C168E6052410E0F25E95A624541E2243C366B5F52410E0F25E95A6245419B7BFB9FE85E524197ECA9335E67454149FD3D5DB75C5241657900EDC66B4541BA98B71B545A52411FC22B96EC6C4541DCCB8F95955952410F598995CD6C45418430C030095952413C6D46B5046C45417F50D7B9C25852415AD141AC1E6045419AAC6530CD58524123D7B310DA5E4541446011CEF4585241E7CD8E7F134A45418449EC17D55E5241A8A18E95BF48454176384A9D9D5F524119605FC05B4745419F6B4BDD60615241D80C35F4E14445411350961DE36F5241CDD2BFBD5D4545414874E85BC0725241E5FA0858644645416EE522BD9D73524143321A8D54584541B80E70A1D07552411FDD0307055A4541DDB6B09B027652410F598995CD6C45412D65D44A8075524136EA7430F36D45415644C1226C755241C29A7FA2A5764541FC6FE3316B7352411E76E934AA8B45416657B9C9E47552411D3CEAC9E09C454119EBF801D2795241A8492E71A99D4541B53BC0F6DB7952419E0FB93A259E454104E1C1A28179524128765F00659C45418BCCCB9A717652419631EBA68C9B4541F3A23179BC755241	GR
1768	93	GR	Greece	0106000020430D000001000000010300000001000000180000009AB6F1466ACA4541B9E7E9EA04BB52413EE3E90D9AD1454128855BEEEEB75241E090006891D24541AF1F67D22EB75241410A14F0BFD24541F9E40452ABB652415073B6F0DED245415EB0608BCEB15241797F7028A1D245419326A3684BB152412440D2D6F6D145417978C146FAB052419FE51E1105CB454150F88F168EAF52411FC32D904DBF4541D605255094AD5241343718FD55BE454178E3A30980AD5241088D555EAAB645411471915176AD52410D1027E3BBB445417E5AC366F9AD52419B0234A8ACAB45417978C146FAB052415D06F31A1EA64541981B6B3A08B3524110A6CDF070A045413DDB53CF99B5524144ECFC5EB79F45416D52D2FBFEB5524142197737089C45413F1A4FFD90B85241392966ADF6A64541815354747EBB524140D774E4C9AD45418B1DDF68FFBC52416F462E1388B14541403C0EB582BD524127B33E1A5FB44541F8A3A353ABBD5241B9A30EB9C0B7454109C6F801A1BD52412F3D68F380B945411CE480B06EBD52419AB6F1466ACA4541B9E7E9EA04BB5241	GR
1771	93	GR	Greece	0106000020430D0000010000000103000000010000001E000000024D6AF208EE44419807D9E919C65241EBB155A3DAED4441E499AE9793C652410F8FE21002ED4441FF67435868C75241890D0569EAE444416B39A2DEB9CB52415F55EFEB9EE24441ABF86714A3CC52413476AF8C2DDF444153D92400B5CD5241FD7B21F1E8DD4441DD8488B0DDCD5241C168BC511ED6444132679C2F31CD5241302448F845D54441BBE16EDF59CD52418ECAD558C5D1444125B6ECCB87CF5241A76DED8F68D144415AE7DA8CF7CF52416297F13EDDD0444174D2ED248BD2524103642F9385D3444112F92D4E80D75241C168BC511ED6444180B7479E8EDA5241FAFC3F84B0D744412C292E26F2DB52412159AE5E10DD44411D20B1B6C1DF52412807BD95E3E344418EEE35A487E35241B219BFA0ACE444413DD062E2CEE352414631B92134E944416FEE5F9665E5524105556DDA7DED4441645A64C259E65241E8A952BB65EE44413386028E82E652413B6E227073F04441E299B3B94FE65241B6AD87F991F944419C75ACC40BE4524175A4C1D98A014541598462B2E6E15241B098FF7EA40745410663B3EB8EDF52411CD9BC882F084541A5CFE8DA18DD52410155CC4B3D0A4541604577EAC6CE524162AFB8D9BA0845412AC8664BE2CB52412ED8059703F44441E6F9BBF93FC75241024D6AF208EE44419807D9E919C65241	GR
1579	62	EG	Egypt	0106000020430D0000010000000103000000010000000F0000002AF31DC695DF4C41FE32C4312567474156021D82CCDE4C4151CDBD1A056847414EA9805197DD4C4134AEACA91A6A4741F9112B75DAD74C4147027CC8D3774741AEABB55402D74C41979F6FCA3F7A47416AFCE3E59CD74C418A091E65537B47410BA2F7571FD94C41133BB9B2647B4741A215997B92DA4C415F6A0293737A47417401DC5B5BDB4C41A6A61D9393794741F485C47529DF4C410D339966F9714741C998313818E14C4196896E4ADA6B474156AE78C755E14C41ED7C9BFB816A4741D901D43837E14C4177F57D7BD36847411EB1A5A79CE04C41621FC205AF6747412AF31DC695DF4C41FE32C43125674741	EG
1730	62	EG	Egypt	0106000020430D000001000000010300000001000000150000003D2D42FAA13E4C413A58418DEAC24B41EA687245943C4C41A4C83F558CC34B41A7773F1231324C4105831C2B96C54B4115638A151E2D4C4109855B0838C64B41A705E337711E4C4151697910DEC54B410E924114FE1C4C41916DFAFAA7C54B41068D499E3F194C414C52061D1CC44B410348679CD0014C418829D9F2C2B64B419994DEDD1D024C416E60C39660B84B417040D25CF2184C418F4B9AFCB9C54B410639A5E3C81B4C41BE2C70EAFDC64B414584CCC7CD1E4C4135455EE569C74B4152E0E935742C4C41764F6AE357C74B41CB54CC7F58314C41EDB1E7FC0FC74B419D872E881F3D4C41D242855576C44B4181DC1369073E4C410406443040C44B41F97D708B3C3F4C416E6B4568B0C34B41A665FC1BB83F4C41144B074CFCC24B41A665FC1BB83F4C411259445690C24B4101B0E2D94B3F4C411259445690C24B413D2D42FAA13E4C413A58418DEAC24B41	EG
1575	195	SA	Saudi Arabia	0106000020430D00000100000001030000000100000029000000A84D84DB6CC751415D8E85461A203D417314B00D75C95141D28F4DA0321E3D418A6911DD4ACD5141C5865B80AD193D41D7FEB3C7BDCE5141E06189E609163D414590ED102ACF51418753567FA8143D41A3B8845977CF5141B9FEC61EC6123D413E6FB181ADCF5141FA3B751784103D412775CD14FED45141503A95D14EB23C41D8B5D8CCCFD451416926773D8DB03C416A249F8363D45141BD5DC7060CAF3C41755E14BAE7D35141141DDB68EBAD3C412DC05B0136D35141BE58176C4BAE3C411CAE853623CE51415C6BC3F10FB43C411A05526C2FC95141859DA7CE1BC33C41517DD61FA6C65141BEAA68EB87D13C418B0E947A24C451414F6AF39017E33C41A9CAE458CFC3514135CBBFFDDBE73C41B9338759EEC3514199DF117BDEEA3C41EA362BC371C4514138F92D78C2EE3C416B4A40B404C551412F9A1DE7A2EF3C4106ADC821C4C75141433FC80FA4F03C41710CAD2500CA51415FF6280AE7F33C4166D237EF7BCA51416AC8527908F53C41AA031346AFCD5141A6B8C71C10FD3C419060FB0E0CCE51413260D4A2D1FE3C41A7FB0F5E3ACE5141DD92168A54013D413B80CA3761CE5141A49E720D1A073D41B764B25E59CE5141BE5DE822FD093D41A3E2D6B632CE5141BDEE7502800C3D4122CFC1C59FCD514137935BA943103D415615F133E6CC5141722741F486133D41AE469E4A72CC514192AFD877E8143D41814BFDC863CB51419A3CDDB60A173D414A86ECEDE4C551417D92283AEF1A3D41485FC20BBFC4514110D135E9B01C3D41EA362BC371C451412221847CF31E3D4185ED57EBA7C45141464FDFE455213D416F63795B0CC551410F7BBC2F97223D41AFCFBFC5AEC55141CBDB8A0E58233D41746854C8EBC65141B7FD555696213D41A84D84DB6CC751415D8E85461A203D41	SA
889	42	CH	China	0106000020430D00000100000001030000000100000017000000E6EB26EAF1E16941617E0B8FD9AD49419B5E87E7F3DF6941061FB71FC7B8494119D2EA13F0DF6941DB9F0CE838BA4941033D92F20AE0694197E0E455BCBB4941AF4FBB5477E06941D1C2C62A86BD4941DDC3E3B8F6E06941FB5E0D54E6BE494199220385AFE26941A038C86AEDC149417F7FEB4D0CE36941B8D5251034C2494143868DA170E36941D9A2AB5E22C249416D7D9E2AD5E369413BD7FC0BFFC149416944424326E46941A539A04372C14941459252A7EFE469413B35D3B637BC4941B218125F12E5694116714D460CBB4941B2F8EE1E6BE569417013327501B1494192CD457B63E5694112498D317EAF4941C608FB5760E46941114E9A9C59A649410B27258C22E4694190D633B3A9A54941E66870EA6CE3694145489CCE74A54941FCF24E7A08E3694188A0101798A5494135C10F55B3E26941EB74A4B724A6494147D8052748E169417CBA3498ECA9494132D2280B67E169417DD8F9C56FAB4941E6EB26EAF1E16941617E0B8FD9AD4941	CN
890	42	CH	China	0106000020430D00000100000001030000000100000018000000085D830D52DE6941287482D554944A412E861B0147DE6941D6391F605D9D4A41B112B8D44ADE6941D031E236F69E4A412F66F8C09FDE694166BB4B8979A34A41878D76BA17DF6941E00B2B7A12A54A41E93D9F6FC9DF69418694EAF48EA54A41174EE99F35E06941DFE2910F36A54A41F4E9E3147FE06941CB12142584A44A413F97A65724E26941D6391F605D9D4A4189D983C437E26941781A40E50B9C4A412B91C93B43E269411FA34F3133994A41560162A718E269413066754F118F4A414BDC951FF2E16941723174C5BF8D4A41F8036830BCE16941FCE7BB05D98C4A413B93165F7AE16941FF6C9379278C4A41DFE306F99DE06941220C29C9A08A4A41033D92F20AE06941E529E109A8894A4181D0185FAEDF6941B119709F84894A41EA47CE8CDDDE6941105D1537368A4A41B59A4941AFDE69414FF4397C408B4A41FB491BB014DE69415163FCBD8D8F4A41F0882D5C01DE69411EB4DC0CDF904A417315CA2F05DE6941EC92331866924A41085D830D52DE6941287482D554944A41	CN
893	42	CH	China	0106000020430D0000010000000103000000010000001A000000BE38C06309EE6941AD45C9C2ED424A4133F23A5A1EED69416D8EA6D805494A41FA9C0162E4EC6941892D0D27EC494A41047E12F69EEC6941A59644399D4A4A41441EDADA10EB6941FA693642C24C4A411C8BA785BFEA6941486C76797B4C4A41BA5306B37EE969411830EF4FF4484A41DDE2A80F26E969414724615C29494A410C6C7A2203E9694149901672564A4A410C6C7A2203E96941252B9F15504D4A4165EC5CBE44E96941C817414A26504A41998FB2EC5EEA694176F20F7714594A41742BAD61A8EA6941E2D4D59F90594A41B57ED72D22ED6941C1A86D379C5C4A41921AD2A26BED6941DEE69D19325C4A41A356FACA39F169416DEE294CD7454A41D2EA456F60F1694147910F3748434A41656486B73DF16941E33001622B404A41170970A322F16941C78BEE9CB73E4A415F1536ADFBF06941518FE72B673D4A4102183C369FF069411FDF93B2303B4A4146A7EA645DF06941173092BC7F3A4A41BA985B495FEE6941ECD2BFED433D4A415CD4A23425EE6941FEA4E9DE293E4A41A9243FB7F6ED69413653FD261B424A41BE38C06309EE6941AD45C9C2ED424A41	CN
171	105	ID	Indonesia	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	ID
191	105	ID	Indonesia	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	ID
201	161	NC	New Caledonia	0106000020430D0000010000000103000000010000000F00000011F15A4243D17141E88B7084654342C15187F309A1D07141CE4FBED3253F42C16B9AF9A070D0714128F147FA683D42C153D0D34E5DD0714119AE439E713C42C141AE62A955D071416EDE262C283B42C124AC760A63D071411A743BBDDE3942C17CBC6A4678D07141887619F4F73842C16A0AE8009DD07141B115C514953842C102A8DB81CBD07141896143C5843842C1808B2D0EF4D071418C63CF67E73842C1282B6FF482D17141766E26C7883F42C1FEAEC65C94D171413204FEDC7F4042C1B60775219ED1714196E15E5CC94142C16F19F28A90D171410066B31B134342C111F15A4243D17141E88B7084654342C1	NC
202	161	NC	New Caledonia	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	NC
203	161	NC	New Caledonia	0106000020430D0000010000000103000000010000000900000025F25EE1DDAA7141061CC42999E541C17D9BFD3F0BAA71415E89B0E952E241C17CE22E9B22AA71417A4E5111BFE141C171A8BAA6C7AB714193BD83D3F9E041C1164FE625F6AB7141D96B3961E9E041C14673436AF0AB714195FBEE9EAEE141C1F01B1ED3C3AB7141B285C4C97AE341C1B8264FDDA8AB7141E9E2390B40E441C125F25EE1DDAA7141061CC42999E541C1	NC
204	161	NC	New Caledonia	0106000020430D000001000000010300000001000000340000006475304B0CAD7141416AFD7D76E041C106638D2552AD714133EA8892FDD741C1C383141938AE7141AEAD1FA8CDD041C1C4F3027964AE7141883D117AF1CE41C162F2794B87AE71413AACD074D3CC41C1AAE0FCE194AE71411C953A148BCB41C167E15F53AAAE7141D6610B710DC441C17803D1F8B1AE7141E2199BB170B741C1B51A735A42AF7141FCD39C1CFEAE41C1F15E925A9FAF714111796B7E2FAC41C1AE5FF5CBB4AF7141E63663777EA941C167E16095D3AF71416E2A46650FA241C10ED16C59BEAF714121168E1CA09F41C172ABE76B2BAF7141C0121EC3279941C102D1CDDD02AF714140C9614A179941C114835023DEAE714192151DB5799941C1EB96B92BC3AE7141A1A2678B3E9A41C1DB2D172BA4AE7141A116A7212E9A41C13A76D1B398AE71412596C4E0069941C14B984259A0AE7141E6F2C31A9E9741C15B01E559BFAE714183CC70930A9741C1494F6214E4AE714165AB742AA89641C141AE9842A1AF714182D8AA21BC9441C1552FDE4FF8AF7141E22B64236A9441C1F42D55221BB07141C6EA56E4FD9441C1355400CC75B0714170B62194839841C1FFE413591AB171413F15FB8B02A041C1AF05FCD044B171410759EF1D9CA641C1402BE2421CB1714172CBC2A939A641C18F9A0B6BC5B07141933BB3B28BA641C13B1CD8B828B0714171AD9EF6D3A741C17E1B754713B07141EC79298BB9A841C1818478CC76AF7141ED63F1B1DDB041C126202ABA5BAF7141964AB595B9B341C1608976C623AF7141F7FB1D99E4BB41C1E215139A27AF7141B553CCF1CAC141C1482F3FD43CAF7141D8E7B2D63AC441C14676702F54AF71418A21B86810C541C1FFF7DBF872AF7141EB18C8FFC4C541C19EF652CB95AF7141F2B9FA7748C641C10ED16C59BEAF71414ABBB61B17C641C1DD632FD007B071416DAA148841C541C10650C6C722B07141108441B07CC441C11BD10BD579B07141108441B07CC441C1AB66E0A67DB071417743AD12A4C541C1D4E2883E6CB0714138B00645BBC641C140CEBB8248AF7141C195E77AABD741C15AE1C11918AF7141465BC99156D941C143A7AD67D8AE7141196A345E7EDA41C147194A6F80AD714187DADB976FDF41C15F0393013BAD7141B913C30B66E041C16475304B0CAD7141416AFD7D76E041C1	NC
205	161	NC	New Caledonia	0106000020430D0000010000000103000000010000000B00000091BF754AE3707141F66C751D847641C149A835AFC070714147E7CECE527641C15B5AB8F49B707141BE91F65F467441C13327F0A16970714164FA5851BB6F41C122057FFC6170714142F39FCF736E41C1BB5B412279707141CAC7EA5F8E6D41C15B5AB8F49B707141135C9F83116E41C131DE0F5DAD70714184821B90176F41C14818240FED7071419CDDE1AD777441C15A3A95B4F4707141BBD9A9DFCF7541C191BF754AE3707141F66C751D847641C1	NC
194	105	ID	Indonesia	0106000020430D0000010000000103000000010000001A000000033621F7B4036B414C7E9E21F6D819C1DC706737D3036B415F0E2E8BD9D919C1111EEC8201046B4158C7CB4C1AE019C17907711F62046B41E71D301EACF719C12CB7D49C90046B4196A26E7778091AC12CB7D49C90046B411BD3B20C04151AC105E4764C7D046B413EB01CAFA21E1AC18048D0EE85036B4147AE1A819D5E1AC1222039A638036B41CA873CDC04611AC10DD2DE78E1006B418F6F2AE3D04C1AC18741B2AC33006B419DE48C67DD3E1AC1290EA1D29CFF6A414A456060072E1AC128234A81FAFE6A417F5B60489C121AC1DBC7336DDFFE6A41E496EDF26E0A1AC1B7F4D51CCCFE6A415ADA5A254B011AC13A10EEF5D3FE6A41D8B9AAD73AF619C1726527EE0DFF6A415DA3AD44E0E519C1A2F9729234FF6A413028CD07A9DE19C1C0AB9453CBFF6A41C36018864ECE19C177540E385A006B41A68DD45017C719C1B53C532E42016B41B2E9E31DE0BF19C1F30EA40197016B411A399DA5E9BE19C1B940E326EC016B41B2E9E31DE0BF19C1D360445E0A036B41AB436AC9E6CB19C12BE126FA4B036B4110A88C8D44CF19C1033621F7B4036B414C7E9E21F6D819C1	ID
213	73	FJ	Fiji	0106000020430D0000010000000103000000010000000E000000315964ADD81573417627EC3EDF8240C1AF46E556151573416289C2957D8240C1BCDF2EF5E81473410E470DEDB58040C12D4A5A23E5147341EE40B1F04F7F40C13A6A1CDF47157341AAA58EB6207440C157DCF6DD6615734176FF8F167E7340C190A11E36CD157341C7033746E77140C149238AFFEB15734109B541E4487240C18DC82C513D167341E8BBBDE2187640C19E5A8C56711673419C967F877C7E40C1D4269E47771673417657D381E27F40C1464A981A5C167341B520E8D0A58040C1D157DB7FFB15734106EB16305D8240C1315964ADD81573417627EC3EDF8240C1	FJ
214	73	FJ	Fiji	0106000020430D00000100000001030000000100000033000000CD01E7242CE87241864ABC54ED7A40C1455DA744F0E7724120A1BF09E97940C1B780A0D5ABE672416D2E8D1F8F7740C1A16F492881E672415D7B70D77E7740C1D36C98510BE67241D1A5540D2A7A40C176440109BEE57241864ABC54ED7A40C1AF82B04395E57241059D40FDDC7A40C10314AC958AE47241882197837A7640C14A9240CC6BE47241EB3EF9E0D77540C132C81A7A58E4724184A3E7B9E37440C1AA93C9F948E47241F4324817BF7340C1BDB53A9F50E47241FB75C92B597240C12B4774E8BCE47241F4809756D66D40C148B94EE7DBE472413F209BBD336D40C1765AF66D7AE7724173792626D16440C10A5CFB8945EA72412B9BC7CFB35540C1983801B760EA7241A727983E5A5340C1A1F9EE0A74EA7241FC10F48C665240C1D9EEBD008FEA72415A109F7BA35140C11A38B9AFF4ED7241F60BCC97F94640C1077D9DE7D4EE72416E08BD56224540C17657B775FDEE7241029AAC6AE14440C1D2A65CD9BAEF7241E0424D2E164640C1C001367657F2724140DCF129BC4B40C16F492C09F2F27241723D191AC84E40C157EFF4160BF372414C294F6B9B4F40C1DF2346971AF37241D65FD8BDAF5040C12512C92D28F37241F537AA916A5340C1E4CBFA4326F372415C7ED67EDC5740C1F60D8F29D5F272412F1B0736055A40C1A937102444F272410E0E3011735D40C1858D6E961CF172411D3551CD1D6040C115B35408F4F07241EAA4E4466F6040C10BFC95D1F4EF72411198D6D1936140C1745EA250C6EF72411D5E2B6CB46140C1DD00F54FE6EE7241C0C132D9526140C10FDE2039C9EE72412A569484426140C1B65D3E9D87EE724148123C6B0D5C40C1F7A30C8789EE724129D3C4538F5840C1C87FAF428FEE7241AF0ABDB9295740C1E0D9E63476EE724167F2988A565640C19CC45583F8ED7241ED3BC9F3825540C1E342EAB9D9ED7241ED3BC9F3825540C117ECABA5D4EA72412BFDCE212E6040C1890FA678B9EA72414A297B46F16040C1806EDB644DEA7241FE9E884BD56540C1EA3052E63DEA72411AF1FAB8E96640C18227AA0936EA72414CBA24F3E56940C13A8058CE3FEA724128C56B5A2B6B40C11BEE594D50E9724173CC103F357540C1CD01E7242CE87241864ABC54ED7A40C1	FJ
215	73	FJ	Fiji	0106000020430D00000100000001030000000100000011000000B2EECE5A43F372419DEC9DEDC84640C114F0578820F37241DDD99A07984640C16000AD487AF272412128396F474240C1D8CB5BC86AF27241E5A2A4F5224140C1A8A7FE8370F272419E34768F273E40C1F9566F6E91F27241EBC48265FB3A40C145EDA6B1AAF2724119D42D73383A40C1FADC51F150F37241F8048EECE73540C199DBC8C373F37241C244EE21663540C1496C9F9BCAF3724111E72F07A73540C1178F73B2E7F372415ACFBF62493640C19FC3C432F7F3724123E0D5855D3740C1E621362931F4724168B2AE5F133D40C1E621362931F472412C27CB36583E40C15FEDE4A821F472410E15FA596C3F40C19FC3C432F7F37241B3A2FC8E534140C1B2EECE5A43F372419DEC9DEDC84640C1	FJ
206	165	NH	Vanuatu	0106000020430D00000100000001030000000100000020000000D9D59E477D07724101ECCBF37D7541C1FEF27135F3057241F9625E0E5B7241C1C59D383DB905724114EFA5ADF27041C1AEBD1EC8120572419217CD69FF6A41C1CBBF0A67050572411198E17ED86941C1B3F5E414F2047241F5C50D1AE16541C173AF162BF0047241405CBCA3686441C1A4FC3074FF047241D9B08F2E986141C1CA2FF9C631057241ADE56515555E41C12340ED0247057241C396359A5F5D41C14C2C84FA6105724183BD227DAB5C41C10FD59B188305724166476BD2075C41C1EF19E1D4A7057241D21A7B93A55B41C1A3797A747A067241FD4E6B16E15A41C1E42F37BEA806724196FBE542C05A41C1600AF0C78C077241BE0D1522955B41C1A1C0AC11BB077241F278328DD65B41C1E6654F630C087241B00731A98A5C41C15367770CA50872411B27BBD87B5F41C1B9972D041D0972414A8ED7DF3B6241C15FF7272834097241D92D99D9106341C1A7E5AABE410972419AF4A06A376441C1CA298D0951097241A48998EC0D6841C1489DF0354D0972410AC7270D976941C1A03DF6113609724161D91448266C41C1370B91301909724142F39FCF736E41C17CC3FC63EC087241FBB0F7EA4E7041C1ED4D4BD28F0872414541F3BF817341C1DDE4A8D1700872419E239A5D157441C1FD9F63154C08724123792313887441C12F0DA19E02087241D564763D0B7541C1D9D59E477D07724101ECCBF37D7541C1	VU
210	165	NH	Vanuatu	0106000020430D0000010000000103000000010000000B0000006C4453CBF71172414F99F05AECD540C1540A3F19B81172418DBAECBD1ED340C195500D03BA1172413B76CA0BDACE40C13708537AC5117241DE05268AE5CD40C10CD3DB3DEE11724154E5C651A4CD40C19257F8DD82127241CAEAA4B2B4CD40C1AA211E3096127241D87B3B7209D240C18AF6748C8E1272418DBAECBD1ED340C1A250AC7E751272416C0BEB7DE2D340C10B43CA9D1A1272412B455CA6CBD540C16C4453CBF71172414F99F05AECD540C1	VU
207	161	NC	New Caledonia	0106000020430D0000010000000103000000010000000C0000004ABE3C47966771419917AB44836341C1D9E322B96D677141DCB377AB626341C13A75BD861E677141AAF471239E6241C152CFF4780567714186D781A70A6241C1FC07E181AC6671414561815B865E41C1B6195EEB9E667141C396359A5F5D41C1E53DBB2F996671415079C834185C41C17E947D55B0667141AA0876E3325B41C19B065854CF667141F188C1AB9F5A41C1A43734080F6771417145A0FEE65B41C1CB4AD91A9A6771414A8ED7DF3B6241C14ABE3C47966771419917AB44836341C1	NC
208	161	NC	New Caledonia	0106000020430D00000100000001030000000100000011000000A7E39497666F71419311B788256141C12A00430B3E6F71414F961037C36041C1AD957861866E7141001DCF81965E41C142631380696E71416A673F72E25D41C15C761917396E71416943E469285C41C1E7136E1CAC6D7141EDF90910EA5641C136F385A4816D714119EF1B970F5541C1304BD1F7756D71415E48E4E9E85341C17F9AD7DF776D714182E4DE727E4C41C191BC48857F6D7141A3D0FD04064B41C15A3768EF906D714173428F3C004A41C14785E5A9B56D7141092E57A9DF4941C10BBE0FAAD36E7141086AA3F6815541C192624F8A0F6F7141C5A72B3C525841C1174EC0C5626F714108A0D4D4F25D41C1413A57BD7D6F71410FED4F5C406041C1A7E39497666F71419311B788256141C1	NC
209	161	NC	New Caledonia	0106000020430D0000010000000103000000010000000F000000AFCECFFE66687141102D9FD9274E41C188BB2AECDB677141088A67D38E4C41C1E9BCB319B9677141A314AB0B0C4C41C1A25E42237F67714140A1620EA44A41C1425DB9F5A1677141F92D7F80CB3D41C1FADE24BFC0677141073C20C77E3B41C11851FFBDDF6771415457316B3D3B41C1882B194C086871418AFD48939F3B41C12182DB711F687141798D5974843C41C1384C01C4326871411B90B7C4793D41C136730FDFA26871417F4070BD5B4641C18F83031BB86871410A1FB23E834A41C12E128C8DAE68714170C8A53BEB4B41C1D7BA66F681687141D5FCCFE0C54D41C1AFCECFFE66687141102D9FD9274E41C1	NC
2921	36	CA	Canada	0106000020430D000001000000010300000001000000180000007F3FFF0EB00561C1E9F3BC7742A05F416FDA1E2C9B0761C1F6E62590689E5F410BE080D9860861C1DFC9B9B4559D5F4172C90576E70861C1217152B67F9C5F410A67F9F6150961C1F5C9055E5D9B5F41FADD33B64F0961C17ABD9413DC985F41917B27377E0961C1A1557D51BA975F4171305B53CF0961C1B8D3D5FED4965F41C51E7D65980A61C1A70B661D76955F41DF97423F800B61C11D41142963945F41CD123F1CC40D61C1F2D8346604935F416A38C409570E61C189061BE313935F4188EAE5CAED0E61C1919880476F935F41D7A9DA121C0F61C1ECE8FBC181945F410A77829EF10E61C113E77E7BD1955F416533E99C770C61C151088A2B37A15F4123EAEDED110961C10B7BC8EE4FAB5F41EBB4D7357F0861C10933723CF4AA5F416AD543BFBB0561C1E2B0323729A95F414B43453ECC0461C1E912AF5B06A85F41577DBA74500461C142E51FCF11A75F416B6EEEE1D30461C135BD87701CA25F41945A85D9EE0461C151088A2B37A15F417F3FFF0EB00561C1E9F3BC7742A05F41	CA
1705	216	TC	United Arab Emirates	0106000020430D000001000000010300000001000000160000006206BAE8505756415EFF6A880F1F4541F05B47F8DC56564125BD1114C91F45410E42EA3343555641815EF849252345415912F83125545641277DFF2FB7254541FBE960E9D7535641D4E44111C526454175BD12513D5356413233CB20432A45412F3090571E53564136A897B6942B45412B1757B016535641E82BF6D9182D45413A80F9B03553564153CF7DAB53304541BD5BCB09EF535641FC090BDCF333454189159C9BA8545641BB3D4E71CC35454183F45F0C2C5556415760B711863645415BBB2BFC1859564109BE910F1B3845419E40AB0DC35956411365DBCC4D3845416AFA7B9F7C5A56419293741B0A384541016E1DC3EF5B56419AB05DC188354541C1D784FB915C56414C5F0F5B0A32454163AFEDB2445C564192132ACA862A454189A26E43FF5B564160552FE0782945418BE821C3575856410CEEF52B3F2045411D57E879EB57564111A996BE741F45416206BAE8505756415EFF6A880F1F4541	AE
1706	216	TC	United Arab Emirates	0106000020430D0000010000000103000000010000000C0000007AC4C035678C5641E0906D3735294541B52B2C332A8B56419832DF52B92A4541D6EF7FF9498A564153388204F72C4541127E15D9328A56415B03F3DD232F4541E55822FA688A5641717044B250314541666C37EBFB8A5641678BAFBC6C334541717C5AC4C48B5641F4814C59263445411783F045128C56412D26ED779F334541F88659E7188D564122C80889DA304541DEE341B0758D56419C26C23FC72B4541EE4CE4B0948D5641F36D6D769A2945417AC4C035678C5641E0906D3735294541	AE
223	73	FJ	Fiji	0106000020430D000001000000010300000001000000160000000D4564E397FA724177FF2E2A1C743EC1180FEBB9EFF97241533A01DF59643EC1DA81EB74D6F9724131F0A10FEE4E3EC1EAEA8D75F5F97241F82A30BC5E473EC1D50F4E2B05FA724136BB66763A453EC146EA67B92DFA72410F695C9A72413EC16ED6FEB048FA724148E0AE84EF3F3EC12356BB90C2FA7241619C394C063B3EC19948782B23FB72412FF15D9C9F373EC1B9B36891A2FB7241C04002F35E373EC11E14C626CFFB7241F69D546BBF373EC1FDC8F94220FC7241F14AF83022393EC1B64A650C3FFC72412746340B653A3EC1B591966756FC7241A09933A3E73B3EC16ACA21ECB8FC72410E5D192EA1483EC18294473ECCFC72419F0D5D20AB4D3EC10421E411D0FC7241F6C42B7B1C563EC1C4DA1528CEFC7241CCB38E0BAC5D3EC1DC344D1AB5FC724110C6E7B055623EC15649DCDE61FC7241ED229C8CE5693EC106BA8E34E8FB72412EA32515D06E3EC10D4564E397FA724177FF2E2A1C743EC1	FJ
225	73	FJ	Fiji	0106000020430D00000100000001030000000100000014000000920005D1350B73417E5C06854AD33DC1A52276763D0B7341377F737AF1C33DC1158DA1A4390B7341D65C3023A6BC3DC160EDC184180B73416420482E4EAD3DC1D84882A4DC0A73412C03ED0181A43DC1C3C73C97850A7341955597694A953DC1F3EB99DB7F0A7341D233D024C8933DC112047BDF2E0C7341701B0FE83C8C3DC1DDDD6EB18F0C73412D8F07D8FC8B3DC16582AE91CB0C73411C985642808E3DC14E28779FE40C7341E5B14F2C23903DC1A090B62EEE0C7341458290BCA6923DC15C9119A0030D73415FE30976A5A73DC157E964F3F70C73416420482E4EAD3DC1D71597C4DC0C73410A1AD9491AB53DC1EF6FCEB6C30C73411CF3DA75C1B93DC10913E6ED660C73410F3DBD79F6C63DC1216D1DE04D0C73418A4A15A378C83DC12C37A4B6A50B734168721E73E6D03DC1920005D1350B73417E5C06854AD33DC1	FJ
226	73	FJ	Fiji	0106000020430D0000010000000103000000010000000B00000086795D7227CD7241B2A26D8ACDAC3DC1D5C8635A29CD7241E286741D10993DC125E8C2A476CD7241CB0F2B8B47933DC17F7E99634BCE72411C985642808E3DC16624627164CE7241F123A5E8818F3DC1BDEB7568BDCE72412B3DDFF16B963DC1BDEB7568BDCE7241C43F7627AE973DC1D2E6D8F254CE72415A06D52120A43DC1E411E31AA1CD7241405AA7CCCBAB3DC145136C487ECD72411B7AFE34ADAC3DC186795D7227CD7241B2A26D8ACDAC3DC1	FJ
1707	216	TC	United Arab Emirates	0106000020430D0000010000000103000000010000000D000000A462E996A0AB564174C2714DB62B454107CE0BE4B0AA56414EFA99F6042E45418E025D64C0AA5641FFFF18D531304541AF9C5ECD24AB5641E6A2F67723354541B8E4C43EC7AB5641B5C5D7C23F3745416D14B740E5AC5641991E64676F3845412344A94203AE56410F18905B8038454187632ABD11AF56419293741B0A384541C1AE349837B056419F1C0384C9364541BEA631B0C2B05641689DD6A18B3445415D6561C06DB05641812879AE5E324541A951D0E0ECAC56415B5CA03CC42C4541A462E996A0AB564174C2714DB62B4541	AE
1709	216	TC	United Arab Emirates	0106000020430D0000010000000103000000010000000D00000028C600B02721574115E5322AB942454167F9182DEA175741D57743BA894745411DB22CAA44125741E9267CF8A04B45414BD71F890E1257417185C310D14C4541A9FFB6D15B1257417783D834F04D4541E863FA538913574100C9E10D83504541951E0C0CB4175741AD051BC2FA5645414B4EFE0DD218574141C47470EC5545411D8C8B79A321574132A3F4828C4645410702ADE907225741C3BAE11AB14545410702ADE907225741B9DD0C9B3D444541A9D915A1BA215741C6EA797F1E43454128C600B02721574115E5322AB9424541	AE
1710	216	TC	United Arab Emirates	0106000020430D0000010000000103000000010000000A000000E810DF4A97265741DC39E57643554541ABAC9BC86925574149138EF397554541726191ED432457416EFC76C9E9564541BD319FEB25235741FF5D122290584541924F37111F225741E18BB92F8B5A4541D7FE088084215741D8158FCEC95C45414BB17E586D21574134DAF42D2A5F4541652A44325522574131C13743366145415173EBC968265741937DB6CC81574541E810DF4A97265741DC39E57643554541	AE
1711	216	TC	United Arab Emirates	0106000020430D0000010000000103000000010000000D0000007EFAD541491E5741F8706E44A65645410A72B2C61B1D5741F8706E44A656454115EC6D7DEE1B5741AD051BC2FA5645415053D97AB11A5741DF329BAEA35745418080CF41F01957418EAAF83EE25945416AF6F0B1541A574135154EF7FE5B45411887B00CC41F5741FD1949D93F6B4541DA060C68F9205741AD1DA9FBC66B4541997073A09B21574123EEBE60DA6A4541BD5BF148E1215741C8A22CD3796845413138B97E85205741993B58855D5845417B08C77C671F57416F0F2FAB0B5745417EFAD541491E5741F8706E44A6564541	AE
1713	216	TC	United Arab Emirates	0106000020430D00000100000001030000000100000008000000D9DBDD4FCF9D5741433D372DE054464168316B5F5B9D574120BE95B59B5546417BB34607829D574133C87D7CBD564641370475981C9E5741450E1013F0584641A595AEE1889E574118FE993201594641952C0CE1699E57411687169B01574641C451FFBF339E57419C53EFE3BD554641D9DBDD4FCF9D5741433D372DE0544641	AE
1551	180	PK	Pakistan	0106000020430D0000010000000103000000010000000F000000CDE27E3F30A35C413A66DFA525E044413B8816C3C4A15C41F1C4142747E04441669CD3E2FBA05C41DDC2923F9BE04441AA4BA55161A05C414100CDE632E144413CBA6B08F59F5C41A00C8BAAFCE1444139E178E13B9F5C4160A9A1F4D3E344416730BE1DC19D5C4186D7039BC2E84441BBFAFAD1D89C5C41E4AACB240CEC44410955B3FC7BA55C418BF6382D4CED444142A0BDD7A1A65C41CD423A5560EC44419F880EA0A0A75C4183CEA92FEEEA4441C9AABCFAF5A75C418B5FA373F1E944410955B3FC7BA55C41BA88F3FF86E144414DB64DB074A45C41C47045BE79E04441CDE27E3F30A35C413A66DFA525E04441	PK
1558	22	BG	Bangladesh	0106000020430D0000010000000103000000010000001700000077021258BC81634129FCA9FDADF54241321D29861C826341247748EB0DF24241F2A6B3FE658263418CD0C123FAED42418944A77F948263415DB55BC172E942418083B92B818263415BF0B4D26FE54241D823BF076A826341E94D575735E4424148D15973738063418B2B1F5741CF424123778305D17F63412803C92B26CA4241CF0FDA10977F63415C04CB915FC94241F05AA6F4457F63413543E9633EC94241BCAD21A9177F6341659C1D8D15CA4241B6056DFC0B7F6341B5F77987A2CB4241389209D00F7F63418E74333EBFD24241CF0FDA10977F634147D18FD21CF04241F4E23761AA7F63413F08B11347F1424186D87635CD7F6341AB870E1F50F24241EAA8C22A2680634101475D0720F4424131477BE3D7806341DCD45C56AFF7424137CF0C503C8163417EFE4F824DF942417024464876816341808BE03497F842419FB891EC9C81634189BB871C8EF74241AF2134EDBB8163417E9FAD3753F6424177021258BC81634129FCA9FDADF54241	BD
244	29	BP	Solomon Islands	0106000020430D0000010000000103000000010000002E0000007901CD04F0097141C58F0672EA2134C1B35F9F7F6E09714160554F55EF2034C1C41122C549097141644638AA712034C12613ABF226097141C46D4C8E761F34C1397EFB9AC1077141EEBAF445771234C18BA6F367530771418DF3E35E700D34C1ECC79FD5D7067141B11D3EFF530634C1EE806E7AC0067141710E9287DB0434C1EE806E7AC00671415F5EA19FE8FB33C180CF11F1AC067141134AC9D73FF733C190C8C5919F0671414EB2E7642AF533C1B2CC601A37067141C6CD04AAA4E933C1D739FEE508047141C83891EF2FC833C1FA0DF2D0EB037141A8F23956F6C633C1C2B8B8D8B10371412B31C550A2C433C16938D63C700371417681F77F68C333C11082DC3DF40271413C5556314EC233C15258BCC7C90271416B385CDD8CC233C1B25945F5A60271417681F77F68C333C14AE0AEB872027141D53EE1CE1AC633C1331689665F027141CB4FE1FAD1C733C173EC68F0340271418671400075CD33C15D22439E210271413574E69DAECE33C17CDDFDE1FC01714147E1925E4BCF33C117ED8D6AD3007141D7F4866BF7CC33C14E0280A095007141521CB78E5ACC33C1C1257A737A007141665F04CFBDCB33C14EFF52DB31FD70412B4FABB6BFB833C185144511F4FC7041340A16C36BB633C1F8C75084ACFC7041F6946DAB02B233C1A5491DD20FFC704190CF043BFCA633C1D7D67D9B6DFB70414E6376C90F9733C1682521125AFB704135CDF984E59233C1F059729269FB704140CC3A9A5D8E33C17E3678BF84FB7041472957F76C8B33C196009E1198FB7041CB9C0D03B68933C1D3DD687636FC70417B74232AB07E33C1149425C064FC7041FB86A6D9BF7B33C118830BC887FC7041AC89EE74E47A33C16257DC259DFE704132EA12597C8833C19C5876AD2E0771413574E69DAECE33C1D85C4F2D3D0871415E2004411ED833C1A77F23445A0871413560BFE557D933C186917D207F0A71415682BCFCDCF733C1DE1160BCC00A7141F781047B3D1134C17901CD04F0097141C58F0672EA2134C1	BP
247	29	BP	Solomon Islands	0106000020430D0000010000000103000000010000000F000000ACC7969E47F8704183259F33B33C33C1CF7B66075AF770412CF6DD49C33933C15038AA7812F770414522D1394B3833C18115D661F5F670413DF579FE113733C1E33682CF79F6704109D081B3F82F33C1CB6C5C7D66F6704164DF4B12422E33C1847ED9E658F67041C57A5E9C2D2C33C19B48FF386CF67041284D07A4572A33C15A721FAF96F67041FA5DCE96B52A33C11B6C98870CF7704172A14FCDAA2C33C1FCA6AE261DF8704153BA228EE83233C10D390E2C51F870412AD7A1D3993533C16BF1B61472F870418F76B2AF843933C1DC5BE2426EF87041BBE8FE85163C33C1ACC7969E47F8704183259F33B33C33C1	BP
249	29	BP	Solomon Islands	0106000020430D0000010000000103000000010000000F000000B4B93FBD893F71410D24E77A056E32C114BBC8EA663F71415B1165542A6D32C18525F418633F71414EE581703C5F32C114BBC8EA663F7141DADF00BB285D32C19CEF196B763F7141B60F7F24155B32C1444F148F8D3F71413731A7BC9D5932C194FE8479AE3F7141D02699D8C25832C1956E73D9DA3F71414167600D655832C13BCE6DFDF13F7141E98E1988FB5932C1D022813964407141393B3368006432C14F96E465604071412F22088FB06632C1627124B050407141C02D576BC46832C1BB112A8C394071411B9EB8A43B6A32C194FE8479AE3F714172114840886D32C1B4B93FBD893F71410D24E77A056E32C1	BP
241	161	NC	New Caledonia	0106000020430D00000100000001030000000100000013000000EA717623E6FA704151601FA6A4A440C192F19387A4FA7041B9C3544253A440C1EA9199638DFA70413FBE041A6FA340C1E4E9E4B681FA7041A046730A4AA240C101ECD05574FA70416271AD83BE9F40C1D35785B14DFA704190B79382148F40C17AB77FD564FA70417657D381E27F40C1DA28F7626EFA704153950543C57C40C101CCAD15CDFA704142C45082697240C1B2EC958DF7FA70417695EA17717040C1CF5E708C16FB7041311B46D2DE6F40C1286F64C82BFB704188E98819EF6F40C1082498E47CFB704123C5BB9C387240C1AD3AB2C3D7FB7041119F29F0F57C40C10ECC4C9188FB70417CE599735F9C40C1676C526D71FB70415639AE0AFB9E40C19DF1320360FB7041BB70E5F30FA040C1C9B6BBDF0AFB704194B42DE642A440C1EA717623E6FA704151601FA6A4A440C1	NC
237	165	NH	Vanuatu	0106000020430D000001000000010300000001000000350000003528CF77C1D9714133B52EE4B5FE3BC1C13EAB5FA5D871411B23006AD4F63BC1FD05815F87D77141C1FE874233F03BC14EBE8ACCECD671416C84EAC572ED3BC16F0957B09BD67141AF4E2EB272EE3BC10AA9F91A6FD671410EDF85BE92EE3BC16C2D3806A8D37141E4C3DDE40ED33BC1253FB56F9AD37141990BA105CFD03BC185403E9D77D37141A6A38F8C4DC63BC1C6860C8779D371410A8529A62DC33BC195A9E09D96D37141A6F18E17ADBE3BC1BE957795B1D3714118273AF52CBD3BC1ADE3F44FD6D371415D060B534DBC3BC175E4F77ED0D571417DD9B926CDB23BC14AAF8042F9D57141E92414F56CB23BC1BFB8C79ABCD67141ED760F2B6DB33BC18D2B67D15ED77141A69CC7064DB33BC1FD05815F87D771417DD9B926CDB23BC172682C5A14D871410BA78ADB2CAC3BC1F23BFA882FD87141851CEA43ADAA3BC1FEAB876417D97141B56EF414AE993BC12E40D3083ED97141B8854E04AE953BC1977238EA5AD971417022F5A12E913BC1E7C13ED25CD971414FC7ED190F8E3BC13FD2320E72D97141EC127E67CF883BC1C54DB5E998D97141A6EFEEFECF843BC1644C2CBCBBD97141C275E90D10843BC1678BDDE363DA714158DF4F8370823BC1E196D325CCDA71415AA52C3050843BC1AFB9A73CE9DA71414E16E6F2AF853BC16DE3C7B213DB714176C2D4AD4F893BC16A7AC42DB0DB7141004527610DAA3BC126526BDCD9DC7141F863EB3F2ECC3BC1B205B54609DE7141C5B4E734EFD53BC188F9FA0E47DE7141ECF9D2C46FD83BC1073DB79D8EDE71413207FEFB4FDD3BC14E2B3A349CDE7141E0CE616690DF3BC1D65F8BB4ABDE71416B439D5691E43BC131294E95A9DE714107BC048C11E73BC18F71081E9EDE7141AEF520C691E93BC1C6F6E8B38CDE7141BF7C3239B2EB3BC1B175A3A635DE7141B80DDAC4F3F23BC188890CAF1ADE714157FBBFAD73F43BC16276679C8FDD7141908F8F6AF4F73BC19373B6C519DD7141695B6332D5F93BC1CD4177A0C4DC714115688E3A75FA3BC16AE1190B98DC714167ABBDC9F4F93BC1CAE2A23875DC71416D847BC7D4F83BC15A0889AA4CDC714180AB509514F83BC13365D2F7EDDB714160BBC07074F73BC1F2AE15AEBFDB7141F2B6759B94F73BC196AF3A285EDA714138E7CDD4F4F83BC13528CF77C1D9714133B52EE4B5FE3BC1	VU
238	165	NH	Vanuatu	0106000020430D000001000000010300000001000000270000004E98FBCE64DB7141CDD928D8F75A3BC1D41C172DD0DA7141294ED833FA513BC1704CCB3777DA7141A5FEBA7BA72A3BC198F81A6D1ADA71412D0273C477053BC161034C77FFD9714115AA28FB19013BC111E4EC2CB2D97141D10A6CEF9DF93AC12AF7F2C381D97141FFDA6EBB3FF63AC1E408702D74D971411BE944D500F43AC1E751507230D971415896319228E63AC18929B929E3D871416C0CAC41D8CC3AC148E3EA3FE1D871410DA07140FAC93AC1A0F3DE7BF6D87141FCA7C463A3BC3AC16F86A1F23FD971414761492213A73AC1B052525F01DA7141BE2B615DBA773AC1BE0BC07FA5DA714111520FE8777A3AC13B768A295DDB7141BA7F2452EC873AC11F749E8A6ADB71410195264E2A8A3AC13B768A295DDB7141978B56D5599E3AC153D0C11B44DB7141F28F8C1D36A33AC1F517193323DB7141B0CD55A092A73AC1FD789C8417DB714108383BDBF0A93AC15CC1560D0CDB7141BB07D73CECAF3AC19C0725F70DDB714171EFA553AAB23AC1D2F35A6AE4DB71416FA47591E7E73AC1FCDFF161FFDB7141AD42092845EC3AC1A43FEC8516DC71419AB7773AE4ED3AC15A0889AA4CDC714192166E08C1F33AC1FFAEB4297BDC7141034E468B1DFA3AC1A066FAA086DC7141F1C3707B5CFC3AC17CA9907306DD7141570AAEF9AC1C3BC103DEE1F315DD7141B17D89BEAA213BC1A695276B21DD71416138E2A8A4313BC17671CA2627DD71415A39840C013C3BC1F4E42D5323DD71414EA212D71F3F3BC1C550E2AEFCDC7141BCD28CD69A4F3BC16A712BAB6BDC71410383044458593BC1892CE6EE46DC714154E45DFE375A3BC14D08EA2E91DB7141ED9596D9D75A3BC14E98FBCE64DB7141CDD928D8F75A3BC1	VU
239	165	NH	Vanuatu	0106000020430D000001000000010300000001000000200000007863138DF9BF7141C8473E0624EE3AC138AD5643CBBF7141CB90BC80C4ED3AC1354E82DB7BBF7141086A993325EC3AC16CF385B111BF714127F360B646E93AC13B29226887BD7141778F88E2AEDB3AC1D43F9DCB26BD714138CE350531D83AC11D7700A7F0BC7141971148EA12D53AC178D0D427C2BC7141DAEB2E1FD5D13AC1A24C7DBFB0BC71416D0E014AF6CF3AC17860E6C795BC71411C04A21B79CB3AC1663E75228EBC71413046B3FFDAC83AC180C169198ABC71417A5110E73EC33AC1F6D349F491BC7141CADFD0CC80C03AC1988B8F6B9DBC71419908167B02BE3AC1B916A311C4BC714139D8001925BA3AC170DF3F36FABC7141FD71E74E27B73AC1E6610E712EBD7141C9F1F19028B53AC1B464BF47A4BD7141FB01D9D169B33AC1BB4CBBB627BE714171EFA553AAB23AC1D675B5708ABE71419065FE030AB33AC1B2283BE55FC0714120CA7090A7B63AC115F986DAB8C0714160228C0DA7B73AC17F2BECBBD5C071412704840206B93AC1943C436900C17141460B3B5683BC3AC137F488E00BC17141E4526AFFC1BE3AC1C6895DB20FC171412A46F4CB9FC13AC1ED4C37A515C17141DEA201BA09E43AC1F5ADBAF609C17141A362915C68E63AC1C6196F52E3C0714164F2F22E66EA3AC1FE2E6188A5C071418C356A05A5EC3AC19F06CA3F58C071419AB7773AE4ED3AC17863138DF9BF7141C8473E0624EE3AC1	VU
242	12	AS	Australia	0106000020430D00000100000001030000000100000010000000010AC4197A2C6F41FEE1BA8B2F7F40C1C42CF9B4DB2B6F419C967F877C7E40C1A55AB4B39D2B6F41C23FF0DBD97D40C163A4F627462A6F41D6CAE437E87540C16D2FCD181F2A6F4161D3B901F47440C1AB4CDEFD0B2A6F412CA29AC0AE7340C158548DCE2E2A6F410FEFE29C797240C188E8D872552A6F41F00B5146A67140C1F9EBAF05932A6F41F5B082B4137140C13683C7EAD82E6F418FD08A72A56D40C1F60C5263222F6F410B34C863176E40C1E7838C225C2F6F41F60FC2FDB96E40C1EA9CC5C9632F6F41B546AB18307040C1A72D3ADB4C2F6F4153537FD9FB7240C169304C36072F6F41216DE6986F7B40C1010AC4197A2C6F41FEE1BA8B2F7F40C1	AU
2934	36	CA	Canada	0106000020430D0000010000000103000000010000000F000000CB0AE92A54165FC1C089054C21DD6141055C600584145FC17E992CB1EBDC61414A4B78F437135FC199DD5100A5DC6141D169D551B4125FC1DCA181ED0DDC61413AE2D5F318135FC17B49289C6EDB6141E929BA539A1E5FC126FC872456D461410DF3E886991F5FC153E20BA367D461414280371DDE295FC1236436C145D661417ACB41F8032B5FC12A3FEAC28CD661412BCC0630872B5FC1A97A93601AD7614124D51CFEC52A5FC11F801626DFD961410E3A08AF972A5FC1AD5DD4A575DA61413530CEC3C6295FC1631F5CDDF1DA61414F301F3080215FC19C224C8DC5DA6141CB0AE92A54165FC1C089054C21DD6141	CA
2947	36	CA	Canada	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	CA
251	165	NH	Vanuatu	0106000020430D000001000000010300000001000000100000005BDE70EE81C171410AEA1054D6A23AC18CBB9CD764C17141F1F1CDDE16A23AC1BE98C8C047C171412A858100B8A03AC105175DF728C171418032EC329B9C3AC1D608F4D5C1C171414121AC7505903AC1908A5F9FE0C171414EC53381E68E3AC10065792D09C27141C7BDD54F068F3AC120F08CD32FC271415F64F3A6E58F3AC1FC1B99E84CC27141BD03718824913AC1DD60DEA471C271412D035C7801953AC1C506A7B28AC2714129B5209E7D993AC1B4E4350D83C271411A97D7755B9C3AC1CEF73BA452C27141C5C793FE989F3AC1F803F6DB14C2714192C9BD20D7A13AC1FF849C6DB0C1714162C44266B6A23AC15BDE70EE81C171410AEA1054D6A23AC1	VU
265	73	FJ	Fiji	0106000020430D0000010000000103000000010000000F00000019581289E7CC724194D948960C4B35C123B2AAFF12CC72410DEB4C988E4A35C1C549CCF44DCB7241137F9DD73C4735C117421D242BCB724107B4F917414635C1EEC5748C3CCB7241454AD808954135C1448D888395CB724144DE4479043E35C1CC31C863D1CB724174DDC76CAE3B35C13C0CE2F1F9CB7241DC4FCF11113B35C1480C816DB5CC7241F4E8922B503B35C186C92892ACCD724162E5F8E44B3C35C1C45628D7C5CD7241EE5B1E5FC53D35C19CDA7F3FD7CD724183ACA5A6CF4235C1670E6E4ED1CD72414FAD1C3A844535C12C0066B1AECD72418FAB5D74734935C119581289E7CC724194D948960C4B35C1	FJ
266	29	BP	Solomon Islands	0106000020430D0000010000000103000000010000001B0000006977CCBF6EB6714120F8E49673E033C10B4F357721B6714106A36EED39DF33C1EEE5F3FA46B57141C570244272DA33C1A88782040DB571415E2004411ED833C1304CE524F0B47141C28086D408D633C14809B0D6B4B37141623186F137BA33C11E1D19DF99B37141340A16C36BB633C114E3A3A815B47141AF3D8A47D8AD33C1112AD5032DB47141B8427C1660AC33C1896572E349B471416FBEB85526AB33C1AAF0858970B47141A719188489AA33C1983E034495B47141A719188489AA33C1E95D628EE2B47141A719188489AA33C1BD08C81164B57141DF65CC26AEA933C165A809F8F2B57141DF65CC26AEA933C104176F2A42B67141A719188489AA33C1F94CE853EAB6714192A4E6A6F2AE33C1C86FBC6A07B771414FFD5C302CB033C1B24B9D1D84B87141B9D7681684CA33C1CF2D667CCFB871413D43ECF917D333C1A0090938D5B8714185ACB94990D433C13F9891AACBB871418C47EB25CAD533C190C089775DB8714108075D74D0DA33C11885EC9740B87141AD2211396DDB33C10896671462B77141F445E33D5EDE33C11A98B43799B671411E1DE7E634E033C16977CCBF6EB6714120F8E49673E033C1	BP
267	29	BP	Solomon Islands	0106000020430D0000010000000103000000010000001400000086A649B499AD71418044AB114E4F33C136F7D8C978AD7141E268B8740F4F33C1C2BDEAD300AD7141E2084050A74A33C1C576B978E9AC71413D00E16C2F4933C1D46F6D19DCAC71417CFDB49F1A4733C1ADAC9326D6AC7141F1876341694433C13571F646B9AC7141A457709F463333C195E26DD4C2AC714173F8C3E4802E33C1ADAC9326D6AC7141F1DA4EFCBA2933C1CF4D9BEF8FAD7141BDBAD6F0772433C1B48A607845AE7141D7B41EA62E2633C109C262CFCAAE714119FAA7711E2933C114835023DEAE7141284D07A4572A33C1415ECD221CAF7141F6953B5D953033C16FF218C742AF714128C886EBD73B33C15828F3742FAF714121EAFA988E3D33C1F3F73C7DB7AE7141D2F5908ABC4633C14B984259A0AE7141F70B02D0F54733C1DE961AB007AE7141DA5271B7584D33C186A649B499AD71418044AB114E4F33C1	BP
268	29	BP	Solomon Islands	0106000020430D0000010000000103000000010000002000000049E2C4DF4D9C71416E5A6497797532C128810397E29A71411B9EB8A43B6A32C19964B6A74F9A7141B51601D4EB6C32C169D06A03299A71413860EA674F6C32C1530645B1159A71414BC5C7247A6A32C19C5DCBCC869971412C85478BB15B32C19F169A716F997141B89477724B5732C18493A57A73997141E2F0DF2FD34532C12CF39F9E8A997141737E51115C4432C1C78813EC499A71410DE48581823832C1D6BECA0C699C714137E8D3526D2132C1B773FE28BA9C714155F60035211E32C1E5074ACDE09C7141075A35C4841D32C1962832450B9D7141B5DD8D4D461D32C1ACACA417C6A07141534A4EC0BB1932C1D9046C59A8A3714155F60035211E32C14E873A94DCA37141F907D8FDD02032C1494F7447FDA371415B067923C12832C1101A5E8F6AA37141E3C7B1C3344032C1CA2BDBF85CA37141A756045B484232C1B261B5A649A3714175DB062DFE4332C1BFE40A228AA2714158394905394A32C1EB19811C38A17141C181DB6CC65232C1BC85357811A17141F3E043B4625332C182CA3C3DBF9F7141C4CE2474355032C1623F2997989F7141AB07E310994F32C1251B2DD7E29E71415A18735F004932C137CDAF1CBE9E71415649F02D834832C108396478979E71415649F02D834832C12884305C469E714193E3D9C34C4C32C170857B92AC9C714102670F058E6C32C149E2C4DF4D9C71416E5A6497797532C1	BP
269	29	BP	Solomon Islands	0106000020430D0000010000000103000000010000000D000000BFC1848333C071414322CFDCBCE530C10098640D09C071414322CFDCBCE530C1317590F6EBBF7141603DBB06A4E430C18B1596D2D4BF7141E132D61ED0E230C151304B3AC7BF714177BEEF521BE130C1F1BED3ACBDBF71412E53E7B0ABDE30C151304B3AC7BF71411C4ACC2B5BDC30C16741A2E7F1BF714163580D87FDDB30C118628A5F1CC07141CB15EBE073DD30C12AF4E96450C07141A46318D321E030C170E26CFB5DC071417D53372734E230C15FC0FB5556C07141603DBB06A4E430C1BFC1848333C071414322CFDCBCE530C1	BP
270	29	BP	Solomon Islands	0106000020430D0000010000000103000000010000000D000000D55FC14DF7BD714118068F1AADC130C1243FD9D5CCBD71415BA476CC6EC130C1C68630EDABBD7141BAB0E05A75C030C1DEE067DF92BD7141D16B9414FFBE30C1AEBC0A9B98BD71419F892AF550BC30C14141C574BFBD71418DD6CE5038BB30C182F781BEEDBD71418DD6CE5038BB30C133186A3618BE714180E2AED776BB30C1023B3E4D35BE714134239194AEBC30C14ED175904EBE7141EDFD4ED924BE30C163ACB5DA3EBE71415B39EB0C37C030C1EA7018FB21BE71415BA476CC6EC130C1D55FC14DF7BD714118068F1AADC130C1	BP
278	29	BP	Solomon Islands	0106000020430D0000010000000103000000010000001E000000FD038E5CB5267141C841A021A09D30C1424C0AEE3225714199981456478030C1E13D26200724714192BEC0C4FD7C30C1F136DAC0F9237141C067C4BA0F7F30C1B3A9DA7BE023714133F0EE9C858030C1AAD868CABF237141A1E8F1DC5F8130C18A4D5524992371410841A015E38030C1BB2A810D7C237141BA1DFA79AB7F30C11FB5300064227141296B79C7C36430C150925CE94622714108D8462BA06030C10695D00A6F2271416539F02CAA3230C1999E22F31F227141851A4A3DB82330C1F5C8990849227141982111B52B1630C1D48C07509B22714104856797660E30C1D82B22383922714146FB49830E0030C15D85A0C4B32171412BEA1CFC7DEE2FC1466BAF521B217141731882917CB82FC13DAAC1FE07217141562D2D6300AF2FC1466BAF521B2171412C560E52F2A72FC1D0C8BDD73F217141CD4E6CAD29A92FC1A6C95E40CC22714120FA494ABBD32FC1D55DAAE4F222714109CFD89EC9DA2FC1B3A9DA7BE0237141C5046C181D0530C177A82EC1352671419565223C824430C1B6150BC6A7267141132FA6E3735430C1CEDF3018BB267141CBF1FE73335930C13D2A390610277141970D4A7EBF7C30C155F45E5823277141C652C868AA9230C13559C754EF2671419796B691309B30C1FD038E5CB5267141C841A021A09D30C1	BP
280	29	BP	Solomon Islands	0106000020430D0000010000000103000000010000000800000088A74E1F09227141231C68FE3C0E30C10DEDB997F5217141003F4393240D30C1DDC85C53FB21714193532867770A30C1DA0F8EAE1222714151286DE4920630C1E65FF7072A227141CA32F777080830C1B83B9AC32F2271412FD932A1B50A30C121FE104520227141A1C2772DC70C30C188A74E1F09227141231C68FE3C0E30C1	BP
292	29	BP	Solomon Islands	0106000020430D00000100000001030000000100000011000000F9D7EB5EA1F77041FF00818BFD172FC147B703E776F7704158762A3281172FC15F113BD95DF77041250FC53596142FC1EA8E6C9E29F7704180D8608429092FC199DFFBB308F77041504662678CFB2EC11B6C98870CF770419F743D8E5DF02EC1A2A0E9071CF77041DDA77D3166E62EC1484715874AF770415E0F726A52E02EC19F37E682B8F770410976DE16D6DF2EC1CECB3127DFF770410976DE16D6DF2EC1CD126382F6F77041FF3978F2C0E22EC166D913083AF8704170E64E2625F82EC1F56EE8D93DF870415D93479F53032FC11471D47830F87041A935EAC175072FC1CD126382F6F77041B865A30628122FC157909447C2F77041CEE65C364A162FC1F9D7EB5EA1F77041FF00818BFD172FC1	BP
293	29	BP	Solomon Islands	0106000020430D00000100000001030000000100000022000000B7E1D6610B037141F6B25F76F42A2FC176BB2BB8B00271418B8A57A8772A2FC19A8F1FA3930271412678D46D09282FC12B4517B53E027141D954A467B8182FC1F25FCC1C31027141250FC53596142FC1157731C973027141DC5D83A1A90E2FC13E0BAE50D1027141C3A5669A6F0E2FC16900DF0C5A037141C3A5669A6F0E2FC165362753CB03714174C30AAA4A062FC171F3540D2704714155677EB4C6F52EC1C52C37318804714111277C7B4CE72EC1ABB69C98B1047141842A2CB5F9D42EC1FD210627A30471412D8CA311DBC72EC1C08FFC15C6047141947CA1B522BB2EC10D263459DF047141490F326538B82EC11EB8935E130571419029158816B42EC104A58DC7430571419029158816B42EC1EA46C71EDC0571412D7852D339D02EC189B52C512B0671411CE266D964E62EC17F79D74DCB067141CDF1DFBAE1E82EC1734CBC756C0771419F743D8E5DF02EC1885D132397077141275748F9EDF62EC14AF0361E25077141D128DED2F0102FC164033DB5F40671415225938FC6162FC1ECC79FD5D7067141B9321BC134192FC1515BE98C2D067141B11A7DD955262FC16B6EEF23FD057141B11A7DD955262FC13DDAA37FD6057141744A1C671E252FC1635D36B064057141F633AD9A111E2FC19CE885C9AF0471414D920A9EB80B2FC1A1DDDA542F04714135FA427A74102FC18ECAA3DA28047141743ABE1F71212FC130FA260299037141B429C57206232FC1B7E1D6610B037141F6B25F76F42A2FC1	BP
281	12	AS	Australia	0106000020430D000001000000010300000001000000170000004FB6BD17ABFB6C4134D894CB1D7633C16E1CD45274FB6C411913D408C57433C1CC648EDB68FB6C41759E9944527233C102D7A58FD5FB6C41B282B256C56233C14546317EECFB6C419DA607EB716033C144D3032643036D41C6889F005D0C33C1993E71BCD9076D41360D527AFFC132C14646208DFC076D419F7E993FEBBF32C19093778B59086D410AECE4A3DCBC32C1C9851DC4B5096D4157EBC801A6B532C107830B69FB096D415CAEFE2BEAB432C11A3E2873440A6D41EA621238C5B532C135F733CD7A0A6D41D4BB58911DB732C1E3FEE29D9D0A6D415F4FFC1BF3B832C1658B7F71A10A6D415D442E41E2BB32C17866BFBB910A6D41E4A5BB5554BE32C185633172E9076D41D6DD5ED98D0333C1B417A056B7076D41FE96320A340833C1FAD24940DEFE6C419E056C37966B33C18C61333719FE6C4100A1D14BB57133C1BC6E06BEB0FD6C41EF3DCAEA667433C14B6B2F2B73FD6C41FD2F3B28817533C14FB6BD17ABFB6C4134D894CB1D7633C1	AU
282	12	AS	Australia	0106000020430D0000010000000103000000010000000F000000D08D3BDC49276C415D1053B2E64433C1131DEA0A08276C413D28C52C0B4433C192D093B752266C4129F9E1D7AD3D33C1D3662C7FB0256C411B6FD659313733C1AE36A86EC9236C4166809AF7180D33C103C8A3C0BE226C416BF0F97011EC32C102412BA32F226C413BFA30BBB5C332C1B2FB3C5B5A266C414ABEF95AFEB632C12ED6F5643E276C41FB7BAE9BB3C932C1398DB49B3D286C4107E6154178DF32C11B3BFE1EEF286C41AAEBF3AC5BFB32C19BAE614BEB286C416E0476F5271033C1FAF61BD4DF286C415BC081A5722533C18B45BF4ACC286C419FCCB560042833C1D08D3BDC49276C415D1053B2E64433C1	AU
283	12	AS	Australia	0106000020430D00000100000001030000000100000015000000B0BB73D567306E4188B03036064832C138939E95A32E6E4154B80B354E4132C15399498C242D6E414991C7A4FD3332C1930FBF13DB2C6E410FE79AA4533032C16694AC16BC2C6E41058183FA702B32C1637B736FB42C6E410B0A539CC71732C1358EC328C42C6E41DB5089DF171532C19628F8BAE22C6E41A3706E86231332C130556741152D6E410EB7D5B14E1132C104BA31044F2D6E4113F6E5C8F60F32C1C5B6D65FFF2F6E418AAF7223570532C14A282B603B326E412A701C78AD0132C13E2BB9A9E3346E41253B2C41EA2132C1DC908417C5346E418BF3EC1DE43232C1004EEE4445346E41EDD07DB4CA3132C14A282B603B326E411795D85D303632C10D2B3DBBF5316E4121A682E6493732C13CDFAB9FC3316E41E61EE9CCA13832C1C4FD08FD3F316E41EA2F597A843D32C1D3DF32E0CF306E417073D2C3674232C1B0BB73D567306E4188B03036064832C1	AU
284	12	AS	Australia	0106000020430D0000010000000103000000010000001A00000005ADC57210386E410AF2207FCDFC31C1700B12582A386E41021D79DEF7FF31C1D36C058826386E41B82B8E57050332C1320E24B3E4376E4168549FC10C0732C196E89EC551376E41C111E707F50A32C12405EB72BB366E41E8739939C40D32C1CA8E37F48D356E41F02EB0A3541032C19F6C899938356E416E0BA2EC731032C19C737332D8346E419844A12E161032C14B9B4543A2346E4193EE12211C0F32C1500DE38C73346E411EDF3B8B850D32C18F4A17B207346E41BB1217E8060832C1250B5872C5336E41D019D2046F0132C1896C4BA2C1336E4175CDBB65BFFE31C129249119CD336E4114F134CA0FFC31C144DD9C7303346E414992999FAAF731C1BEDE62562E346E413FB7660EF5F531C1500DE38C73346E41C326F7E2DBF431C1F16BC461B5346E41E144E4C55EF431C1F04BA1210E356E41FAB0335420F431C1DAD7B6B405366E417AF14D37A3F331C1A6918746BF366E41BABFE60C84F331C1B94CA45008376E416FACD6613FF431C112039E4F84376E41F4994F8033F631C112E37A0FDD376E41240A8FA49EF931C105ADC57210386E410AF2207FCDFC31C1	AU
285	12	AS	Australia	0106000020430D0000010000000103000000010000000E000000463C709929336E4171873C8109DE31C189C5AF448B336E4155021B9B4DE231C17903A9A1A2336E412301EF3480E431C1360DA595FC326E41C503A4C97CEF31C1CF4D725657316E417AF14D37A3F331C10EC4E7DD0D316E41B4BC7737A9F231C1E02F9C39E7306E4108533D80D4F031C1F30ADC83D7306E41C47520F724EE31C1C004F395DF306E41D8998F7175EB31C151DA0E2A5B316E41B921E89DB8E531C17F6E5ACE81316E41AA1E8C8B41E431C17DB58C6BC2326E41F56E637252DC31C1FC08CD5717336E41562A96F80DDD31C1463C709929336E4171873C8109DE31C1	AU
286	12	AS	Australia	0106000020430D0000010000000103000000010000000D000000B5BAE3C68F376E41CE93C4FAD1E631C124E5C73214376E414A7FDE0DF7E531C118B58119A4366E4111DB52D966E331C1E607FDCD75366E4147B2A1C8EFE131C138004EFD52366E4116693E3D1BE031C167DBCB3EBA376E411AD4754D51D731C165BBA8FE12386E4199D3DB3DBCDA31C18074B45849386E41C85EDF74C3DE31C1A3B896A358386E41E7C62D3415E131C18074B45849386E412B9A0FACC4E331C152E068B422386E41B93DF92D7AE531C1320E24B3E4376E412A5A1A5193E631C1B5BAE3C68F376E41CE93C4FAD1E631C1	AU
287	12	AS	Australia	0106000020430D00000100000001030000000100000012000000AC9CCFB2A8356E41AAEFFC393E6A31C19A0743E810326E414077F9F1245F31C151BAEBE9B3316E4195F23C88185C31C17105B8CD62316E4118848685AE5831C113FD43C5BC306E41C743F0D94A4F31C1EDFF9317EE316E413678EB536B3B31C19D207C8F18326E41C32CF65DB63931C1DBFD46F4B6326E419458C4A2CF3531C13B26DE3C04336E41D2C2B4B2523531C11A4E2C3CBC356E41FFAED3850E3131C17876C38409366E4195E35C1C6C3131C14297E9F3AA376E41818DF1C43F3831C190DD565968386E41319BA150264131C141DE1B91EB386E4137CDBE10AF4931C1D12CBF07D8386E411CF80CE0AE4E31C138004EFD52366E41B6C823FEB46631C109C566FBF5356E41FB8C9599E06931C1AC9CCFB2A8356E41AAEFFC393E6A31C1	AU
2962	36	CA	Canada	0106000020430D000001000000010300000001000000130000000D817960C2BE5CC11FDC1B8CE9996241CF560F5FD9BF5CC15F893B56F39962418AA73DF073C05CC1CF64C6C2349A62415B7A472935C15CC1162E8D58579B6241AC5275186BC15CC1DE8B99E4009C62418B67F76F25C15CC17B55DE54849C62418149E35B3EBF5CC1A2AE2C7B889E6241E1F773A432BB5CC1E737A49C1E9F624147DEC63161B25CC1144ECEC6F69F62412EEBFA5720AD5CC19A9A464267A06241DD183A68F4A95CC19A9A464267A06241A8E66834D6A85CC19A9A464267A06241FE4FBB86BDA15CC1846A4E8F70A062418468ABE42FA45CC1DC10072C3D9E62416CC26B32F7A65CC1A4FEDA887A9C62410383997D72B05CC179A8E36F139C6241E3AAE77C2AB35CC1ECFA3D5B429C624199830D493CB95CC1383E49CE449B62410D817960C2BE5CC11FDC1B8CE9996241	CA
894	42	CH	China	0106000020430D0000010000000103000000010000001400000082F16431ABF869419207137214804A4107A99ED69FF8694187C275BCFC804A414A43C796A7F869410C7E491A95824A418F41CE8AC2F86941861DF5A91B844A4125DFC10BF1F86941324E4DB337854A413EE92E207CF96941A50E489565864A4164C70602D9F96941655CA92F89864A414D85A583B3FC6941D6094DFCDE844A414D6582430CFD6941F1D3E9F997844A414BE180CF51FD6941C0D7057DE6834A41BE0FF53380FD69413191D30ADC824A41E98A07319FFD694183D07408C0814A41F34BF584B2FD694127FE59DE6E804A411FD1369FE5FC69414EA71C7B83664A413D1C038394FC694115183A3A95664A413565444C95FB6941885726C9F7674A41F56756A74FFB69418B6760E2BA684A41A7A8615F21FB69410B3B854CB3694A4139172816B5FA6941A6A47988066D4A4182F16431ABF869419207137214804A41	CN
697	218	TH	Thailand	0106000020430D000001000000010300000001000000130000009505A646FFEB6441BA9818DA6E732B41AEBB6EA013EF64417CC3193E975A2B418DF71ADAF3EF6441A4BF84E488442B415482BEA112F064416D3ACBC52B402B41B6E3B1D10EF06441A5C5ED8A5FFA2A41355715FE0AF06441371EA1B741EE2A41001B15ADD8EF644138968FB3F8C72A41F6592759C5EF64419200E84420C32A41C7C5DBB49EEF6441F4790C037EBF2A41F7794A996CEF64415FDCAEC495BC2A41B87C5CF426EF6441FA8CAC8C4FBD2A413BA2A3EA42EE644148911AACCAC52A416A5612CF10EE6441293A36CAF0C82A41DD790CA2F5ED64411A4C09884DCD2A41F5A6C471BDEB64418C8174A88F5B2B41479F15A19AEB64419B1031F503652B411363155068EB64410A7C3408AE7F2B41CABA2D7AA2EB644102897B60417D2B419505A646FFEB6441BA9818DA6E732B41	TH
308	29	BP	Solomon Islands	0106000020430D0000010000000103000000010000000C0000008D833872DA4671419C2D498ABB682CC17872E1C4AF467141490C184E01682CC17EAAA7118F4671410A85F8AE4E662CC166E081BF7B46714125A1D69FAA622CC166E081BF7B46714177A5772C455F2CC1D012E7A0984671411E080ACEA15B2CC1BED052BBE946714164B9E7E11D5C2CC19F1598770E477141EB9A9E69545D2CC10A7E14BC6547714164B9E7E11D5C2CC122483A0E79477141B6C024B3C15F2CC16BEF8B496F477141984E45DB64632CC18D833872DA4671419C2D498ABB682CC1	BP
3218	193	RS	Russia	0106000020430D0000010000000103000000010000001F000000BE31AE2F986B5941969C673E56426F41021094675E6E59415F48E0E436436F416C822B125E765941319C24A1A1436F41CC9A154D9D86594127ECCB5C21446F413C921465198F5941BAA03739BC436F41C0D1EFB9F2A85941CD06F2DFEF416F413E2F4C4E19B25941BC32BBD170406F41BCBC673F05B7594132A98E7B243F6F41675E405028BB594156484DC4A53D6F41464648CF91BE5941D8738DB3283C6F41FB753AD1AFBF5941A298DC22443A6F4164EE3A7314C0594139FC34BD46386F41FB753AD1AFBF5941CE72387730366F416F7C54640FBD59418C9E812CB3336F41581FF0ACC4B95941B7222F8D69326F410B2FD05F2BAF59414F75CF28872F6F411DDE25E0A2AB594101C4A26CA22E6F411309EDC6A9A35941AAA1349A3C2E6F41B8664F7E039F5941F61CFC4E212F6F419FBF861A4691594154A93282CF326F41991178E3728A594156780C98E3356F41E956662B488659418DA4432948376F4118B1D6CAD781594120D4ED64C7376F412096BCF1DE7959416DCEB54661376F415FF64E47F26C594139FC34BD46386F418C50BFE68168594159BA2803C6386F4182DD1BC31D5F59419E88B3F8A83A6F4126D1E59C6D5C5941B193F6DA413C6F414868BF8A3C5F5941D341D228593E6F4161C523428762594135149CAFBE3F6F41BE31AE2F986B5941969C673E56426F41	RU
700	218	TH	Thailand	0106000020430D000001000000010300000001000000120000005D53590334E064419A83586E07BE2E41A3B1C9B744DF64416DD0510505A52E41CDBD83EF06DF64419C1B0E9D96A22E415C3D635C4EDD64419484F03B159A2E41AB9502C794DC6441700693EF98992E41B127C3500DDC6441BF6F39397C9D2E4104201480EADB6441C7F0297C21A12E4104201480EADB6441B02B1DE310AC2E411389B68009DC64413D85607180EB2E4170B14DC956DC6441C0F815C9EA082F41C9AE796513DE6441ECC28469A5092F41566B5C5287DE6441D85E2AA5C8042F41F1F7361D02E06441693EFA2314E02E41465FE0113CE064410E3695E191D72E415A7037BF66E06441CBFBE18955CE2E41FC277D3672E0644160579DB1FCC82E415A7037BF66E06441BCC4C0D365C32E415D53590334E064419A83586E07BE2E41	TH
331	29	BP	Solomon Islands	0106000020430D000001000000010300000001000000080000008560854351BD7141A4D1116D40B530C156CC399F2ABD714195934082A4B430C13E02144D17BD714186164BFCD0B230C1B484E2874BBD7141D681A426DEB030C1953916A49CBD7141445A78BCE4AF30C1C68630EDABBD7141CABB518CF6B130C1B4F4D0E777BD714195934082A4B430C18560854351BD7141A4D1116D40B530C1	BP
2965	36	CA	Canada	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	CA
332	227	TV	Tuvalu	0106000020430D0000010000000103000000010000000D000000EFE2FC5096067341C4AD3DDBD0FF2CC14906BA6E2D067341BA9186930CB02CC161D0DFC040067341D055A97B8AAB2CC1789A0513540673410B5576D475A92CC1465A45286A06734127A411B531AB2CC15A78F633BA0673411E5A5EB473BA2CC1ED6E7F3AE9067341D9F3B20278C32CC1D2F8E4A112077341D25B80DD90CE2CC1F4D932EB1A077341E8E552645BDA2CC188EEFE641507734135BDBF6A89E72CC1BA2EBF4FFF0673417650330535F02CC1D5A459E8D50673419C03CB7F92F92CC1EFE2FC5096067341C4AD3DDBD0FF2CC1	TV
333	227	TV	Tuvalu	0106000020430D0000010000000103000000010000000A000000CD8EB9CC82EF7241A19B2866ED4F2BC1B77D621F58EF724131AD356B714F2BC1943980D448EF72412AC1C5CF524B2BC1FE6BE5B565EF7241C506F69A053D2BC1BD95052C90EF7241DB956D51A9302BC1FB220571A9EF7241A628BA9CC02D2BC1E970822BCEEF7241B0D54BDEF62E2BC1F6EA3E24CAEF7241C9E3A1E981352BC1E558DF1E96EF7241E8EBE1DE884C2BC1CD8EB9CC82EF7241A19B2866ED4F2BC1	TV
334	227	TV	Tuvalu	0106000020430D0000010000000103000000010000000C000000966F9879ACF0724105FED640C2152BC146209291AAF0724192A73C39E9182BC1A8211BBF87F07241B2B53D712E202BC17D3584C76CF072416E6D31AC16232BC1DF360DF549F072413BAF29B24C242BC108B3B58C38F07241B293E567AA202BC1F474E14041F0724105FED640C2152BC1329F4C8453F07241E67DD376E1112BC17D3584C76CF07241A302513A750F2BC15E7AC98391F072412F0FB5C63E0E2BC1A791091FB4F0724153C5752FF10F2BC1966F9879ACF0724105FED640C2152BC1	TV
324	184	PP	Papua New Guinea	0106000020430D00000100000001030000000100000014000000B8C0D3A212826E4186CB896B84ED2BC18DE55561AB806E416048ABD8E8E82BC12DBDBE185E806E41FBE187A5B2E72BC13E46845924806E41798AE30646E52BC1CB7BEE2809806E41CF37A58326E12BC1D09427D010806E4175664BD3D0DB2BC10029737437806E41076C10800DC42BC1D632AD5F08816E41A5CD53E83BBE2BC1403228A34E846E410D3468F780AD2BC1EDE072D1A7846E41DA5A99523BAE2BC13EB9A0C0DD846E41B3F85FF269B02BC193DDD935E1856E41B2E6FF11E7C82BC1B30883D9E8856E41504BFFE2CFCB2BC1C7E3C223D9856E41296DEC226BD02BC1994F777FB2856E41BFC9C6910ED42BC17EB68E6523856E417CB6E03C07DD2BC1ADC361ECBA846E41528078EE5CE22BC13402E289DE836E41606276397CE62BC1410B1946B5826E4140F9BFF4D1EB2BC1B8C0D3A212826E4186CB896B84ED2BC1	PG
325	184	PP	Papua New Guinea	0106000020430D0000010000000103000000010000001A000000E90DEDA9F8806E41466F677871AF2BC14DE867BC65806E418AD60CD24AAC2BC188E07AF4CB7E6E41045BDE394A9C2BC16D276F9A957E6E4193FC74A21B9A2BC158A593F26E7E6E4122BF3FCE78962BC19D546561D47D6E41454EE95BAE872BC16DC019BDAD7D6E41AAA231D1397E2BC14E957019A67D6E417CF2D8F7E4782BC16DC019BDAD7D6E410727FE02C6742BC10A06C2EAE77D6E41E731152759722BC1F1FF16F4667F6E41D727765E78662BC14F28AE3CB47F6E4177305813C6642BC14DE867BC65806E4142E57CFB0B642BC137545A0FB6816E411C97A67632672BC1E8541F4739826E41D1392C48976A2BC1719F64EADB826E41E731152759722BC176987A513C836E41DCDB39DD2A782BC1C2576F996A836E41F57C5F64517B2BC1218006E2B7836E41FFF39E0659822BC13402E289DE836E41FE8F1F0BCE8B2BC11D0E6998E6836E41297BAC92049D2BC13109CC227E836E41EEEFFC025AA22BC1B8272980FA826E419EE236A6FCA52BC1D599023DF0816E41FE09DFF304AD2BC177716BF4A2816E41DA5A99523BAE2BC1E90DEDA9F8806E41466F677871AF2BC1	PG
335	227	TV	Tuvalu	0106000020430D0000010000000103000000010000000B00000045FD2F5986F87241A8F3ED7DFE5329C11769E4B45FF872419FC498DDC85229C10DA8F6604CF872413B195956654F29C1AD367FD342F87241BB0203F68D4A29C10DA8F6604CF87241D87001D6F44529C1A7FEB88663F8724111395859CF4229C1A4B5D841A7F87241FF3934A3704629C12CEA29C2B6F87241A50CAC57584929C1BC7FFE93BAF872410817E184AB4E29C1A4B5D841A7F8724155465B0F4D5229C145FD2F5986F87241A8F3ED7DFE5329C1	TV
336	227	TV	Tuvalu	0106000020430D00000100000001030000000100000009000000B743C1BBB1CE7241B940592C715528C10623D94387CE72415A44053AF55428C13800052D6ACE7241201F2D2A8A5228C12136DFDA56CE724195E8A53EE94E28C1302F937B49CE72411CB6E49CCC4A28C1C0C4674D4DCE72410FEC495C7A4528C10623D94387CE72411723F9FDAF4628C13F78123CC1CE7241D6081F78D05128C1B743C1BBB1CE7241B940592C715528C1	TV
351	29	BP	Solomon Islands	0106000020430D000001000000010300000001000000120000008AFFD83549BE70410817E184AB4E29C12C47304D28BE70417E27ABA5F94C29C190B1BCFF68BD70419F069C574E3B29C178E796AD55BD704107EEC914AD3729C1F65AFAD951BD70417AB9CEC3593229C1608D5FBB6EBD704115C987950D1D29C1D69F3F9676BD7041098EA998361829C18AFFD83549BE70410E03595A200429C10CFC636979BE70410D7CDA01390129C1C0EB0EA91FBF70419C31B692A40329C1BAB3485C40BF70418FC04123560529C1A26F058DECBF7041C654C5679D1329C1AD30F3E0FFBF704178F6B492001729C1895CFFF51CC07041D11C0932791F29C1F9A607E471C070413E9FA0CC3A4529C19835905668C0704115645CEF114A29C10BE99BC920C070417E27ABA5F94C29C18AFFD83549BE70410817E184AB4E29C1	BP
352	29	BP	Solomon Islands	0106000020430D0000010000000103000000010000001400000084B324E97D8370410FC108EBD10529C108D96BDF99827041B6CE6102B50129C18F9DCEFF7C8270417B01557249FF28C10A224C2456827041E1FC058F44F828C17A8C775252827041E2957D77ABF328C122EC71766982704130E081EE11E028C1A767F4519082704171E45D6405DA28C15D106E361F837041915DF0272ACE28C1BCC8161F408370419D645D6E78CC28C1964584EEB1837041D02372F40CCA28C1328B2C1CEC8370410CAFF270D7C828C162FF54806B84704175B789AC5FCF28C1804188E1D5847041F952766CA6DD28C13933E20A2185704151D35A4FEDEB28C1802165A12E857041A065AA610AF028C1F08B90CF2A8570419749E37627F428C18812FA92F6847041081E8D8E7AF928C1CA78EBBC9F84704165AE753ABD0029C179C97AD27E847041CEFF27CA6E0229C184B324E97D8370410FC108EBD10529C1	BP
342	105	ID	Indonesia	0106000020430D00000100000001030000000100000012000000A05F540C9AC96B41CB6980BA086229C101FA889EB8C96B416ED6DCB18C6129C1681AA4BB3BCF6B4186BD7DDC916829C1C95B74AB90CF6B412B99F7051B6F29C1380DD134A4CF6B41CE554685F27329C108F20C73EECE6B41E2D6F0E84A8029C14A88A53A4CCE6B41A8BCE3F63F8929C1E0A84FBBFFCC6B41E97B7C70CE9629C1A2AB6116BACC6B4193DFA965809829C1A2EBA79608CC6B410EBD8A403A9929C1621B34CA13C86B413E3DE6AEF18A29C1D957674400C86B411E4245068E8729C1621B34CA13C86B41FD23019B407229C156ABA73055C86B41EE161874746429C1025AF25EAEC86B41BFA1B41DEB5D29C15732204EE4C86B417DC4F06ABD5B29C1B35AB79631C96B413A7F2A42B55C29C1A05F540C9AC96B41CB6980BA086229C1	ID
2973	36	CA	Canada	0106000020430D0000010000000103000000010000001400000001DC1E2ADA3C64C18A733B091B6D634140CFDDB10B3E64C12229B3F17B696341BC221E9E603E64C12A3809C3AA686341CCF2157C673F64C1108B2E36616763418DEBF8B90D4064C1BC0851642F676341A7EB36B1844164C1B22E26854D6763417C66F596514264C1230FF843A7676341F298F9F3294364C133D6354A15686341536AC4066B4864C10950FD95EC6A6341B019D46C474964C112598A8E646B6341A037AA89B74964C1DB036C4CF06B6341C50A08DACA4964C1D09A018BA36C634128E582EC374964C18A733B091B6D634191FA0244014164C1954C9A518A706341C54032B2474064C16C37CF768070634111D43C30FD3C64C16C3C16E77C6F634195D960E6713C64C1AE6DD8A20E6F6341700603965E3C64C1E555A99B646E6341405294B1903C64C130E3AF009D6D634101DC1E2ADA3C64C18A733B091B6D6341	CA
2977	36	CA	Canada	0106000020430D0000010000000103000000010000000D000000C7F0465D600362C1DF30F730464F6441369EE1C8690162C1C957ABC51A4B6441367EBE88C20162C19CFFF0A9504A64414A168E537C0262C1B72CA625464A64413A144130450362C1DE411F4CBB4A64417F42F40BE30862C1846A39BCC54E6441904E704C2E0762C1452529F845506441CA3C5467800662C150AE4505D15064411EAE2C79CE0562C111240A4931516441EB2AFA8A5B0462C17DC77C845B516441983CD878920362C15B96B398DB5064415FE79E80580362C1F2D03D4926506441C7F0465D600362C1DF30F730464F6441	CA
2978	36	CA	Canada	0106000020430D0000010000000103000000010000000F000000589987A0591763C13C2C938CCB606441C5E04B4C631963C122F09E68C46264413B9AC8C6CA1A63C145B6A823E663644194107C45F81B63C1F2E84E9275646441EB0DA8E1B41D63C1B87131EF4865644104753BB6132063C1CFDEED0A0A666441C4774D11CE1F63C1F0567A4B2B6B6441E39C9C2A0E1963C1A6F58C5B766F64419CFEE3715C1863C1DA945745AC6F644154602BB9AA1763C1A6F58C5B766F64416E0343F04D1763C1C98D5146F56E6441B73AA6CB171763C19AE1EC495E6E644182FEA57AE51663C1424C8BF92D6264418E4E0FD4FC1663C1957BA32377616441589987A0591763C13C2C938CCB606441	CA
2980	36	CA	Canada	0106000020430D0000010000000103000000010000000B000000262FC1D7501062C12FC198249F7264413F9654ACAF1262C1F6DAA7B422706441A2467D61611362C14AE31126E26F6441233040F5381562C12FC198249F7264415C8579ED721562C199493E5756736441EBFA293DA61462C1BB7A47B76A76644153EEDDF61A1462C19C628C60C1766441D6B6FE2C631162C1E8DEA47031756441A01A9397E80F62C1FB040F3A2E746441D3409FC5870F62C1E2BC85FB76736441262FC1D7501062C12FC198249F726441	CA
1557	22	BG	Bangladesh	0106000020430D0000010000000103000000010000001A0000009163CE295FE962417EC4EF12F0EE4241D5AF0CD9E6E962410ABB26C18AE84241CBF998161DEA624182F6EFDCEADF42419DB518927BEA62417D7B2EFD47D84241417E49A27FEC62415725EF2E34D54241B4B73798F7EC6241572C99AAD8D34241458D532C73ED62413EA1E03BBED0424155F6F52C92ED624185751D0994CF42418071082AB1ED6241B60BF22469CC4241E3D2FB59ADED6241D53A0540B2C94241CDC1A4AC82ED62412D66F578CAC842418AAB7D6035ED6241FE44383C46C84241417E49A27FEC624130C51BA57FC742415B2161D922EC6241579FC7066FC742419B97D660D9EB6241DFD603C3C1C74241960F45F474EB6241762A1F2170C942419399E58C99E962412BB180FF3BD442412119C5F9E0E76241247748EB0DF24241208A49F4DCE762417C6F3A287AF34241FB25446926E86241146C435D6BF54241B2EEE08D5CE862413068473B32F64241101778D6A9E862416DF47F05F0F54241496CB1CEE3E862417A32DABC39F54241FB8C99460EE962413FF87F1241F442411646A5A044E96241A090D4EA99F142419163CE295FE962417EC4EF12F0EE4241	BD
1559	22	BG	Bangladesh	0106000020430D0000010000000103000000010000000D000000EC50F4FAB83263416FDB950901E04241358857D6823263418D1D54C653E04241F18950E26732634115DFB24FF9E0424198E94A067F326341880A9B7BAFE1424145F1F9D6A13263417A2E327444E2424154B7C29794346341CA8654F92EE742419CCE0233B734634179684E0A9AE642417CA3598FAF34634100B46D6AF4E542410E12204643346341EF7F6AD233E24241DBD51FF510346341BBE5BD1BD8E04241C1AB8FA0DE336341C6BCDD6764E04241BC23FE337A3363416535490022E04241EC50F4FAB83263416FDB950901E04241	BD
1582	22	BG	Bangladesh	0106000020430D00000100000001030000000100000014000000066BC650ED4E63413501555860244341CD158D58B34E6341350155586024434195C05360794E6341F75239A6A224434112C55EC7184E6341696BA5325925434180CF1FF3F54D6341EADCBF0CDE25434131102BABC74D634134C49FD42927434142D2314EB04D634186E98E36D92843412C6876FEBB4D634167D58447D229434146E13BD8A34E6341EE315629D6394341172DCDF3D54E6341606F6720293A43419DE89691744F6341D307B05BCF3A4341F7F7F432BA4F6341E50DE169F03A434169C28A63D54F6341C5C1E9185B3A434111228587EC4F6341DDC996308A38434136F5E2D7FF4F6341CCB92565062C43412F4D2E2BF44F63417F0169FC032A434101B9E286CD4F6341F4C28296542843415098FA0EA34F6341EA78DE2919274341552ABB981B4F634183EBCDEBC3244341066BC650ED4E63413501555860244341	BD
1584	22	BG	Bangladesh	0106000020430D0000010000000103000000010000001000000044A5B7755F516341C489DB61213443416EB171AD21516341A3344E6E42344341FBE6DB7C06516341B4547EAE093543413F1D2609FB5063419C65989CE1354341833B503DBD506341F5ADC715713E4341A77F3288CC5063414BB8D20445424341BC908935F7506341D4B6A484D3434341E67C202D12516341864BB97E584443419C259A11A15163417967482F6C464341D7094F0FDF51634178F082408D464341030F1FAE01526341FAEF84D2F74543410AB7D35A0D526341085B41D81F454341B116CE7E245263410C8DBCBDD43E434178E1B7C6915163415D56AFFB7D354341F1AC664682516341AC183F0EA634434144A5B7755F516341C489DB6121344341	BD
1585	22	BG	Bangladesh	0106000020430D0000010000000103000000010000001400000015B44511654F6341AADECC6B673D43415EEBA8EC2E4F63419B48E2B7883D434120EEBA47E94E6341EB13AD00A33E4341FDA9D8FCD94E63419545130F9540434100C311A4E14E6341E8A7CBAF7D414341BD091118685063410E108700B65B4341D633A16C9A5063413B05E81E345D4341A77F3288CC506341D312856A875D4341E163E7850A5163418C392FDF975D434114116CD13851634110FD7BC1445D43419C45BD5148516341AB3751B3F15C4341245AEB91B051634105A7C155165A4341DB2288B6E6516341BCB3ADAFF856434177C19486EA5163410BC8561DDB534341C1F8F761B4516341D4DD33800A4D43419264ACBD8D516341DB134BE37B4B4341DBBB32D9FE5063419F6B1EDD22474341D8CC4B8FB24F6341F366DF583F3E434164733A59934F6341FFFE3465BA3D434115B44511654F6341AADECC6B673D4341	BD
1596	22	BG	Bangladesh	0106000020430D00000100000001030000000100000021000000CE55F73E34386341E75595F45DAA4341FD6CF9E2DF366341AFF2625220B743414C4C116BB536634180EB7E088FB843416C97DD4E64366341482FE03A83BA4341BB76F5D639366341F0C8FEF4F7BA434178F175C58F356341C7B6E8BE6CBB4341EA3493D81B35634176A342AA02BC4341A68FF086CA346341C7620CC3CABC43417CA3598FAF346341206E377E71BD43419B557B5046356341A7F30348EBD3434142B575745D35634173E68D49C4D44341F0BC2445803563418DF10BA149D5434177D15285E83563413F1DCAC1ADD54341D7CC6FF5E439634158C1DA347BD84341EF53260AEB3B6341A83663726AD843412154A2F8D83E634186B1140F9DD5434185E4A76DE33F6341A19D8D2960D443414A7D3C70204163413A142CC6C4D14341D1916AB08841634169D1FACD23D043410026B654AF4163412871CE9D82CE43415E6E70DDA341634114F78A8188CD43414F05CEDC844163417C4EECD6D6CB43413FBC4E1C0D416341D6CD0E1F20C843410B804ECBDA4063417B8ACEDEF3C64341DCEB0227B4406341EEE372876EC64341AFF061A5A53F63416CF4CE4148C4434176BB4BED123F6341991409AD5EC34341E4CF3B36043E63415ED1E2E753C24341E8E6914AB43A6341AD88D60C56C1434159A7F6D96839634183F9885A30C1434199FA1E22903963417FA00C9BB1B94341880D7BADB639634121E0914A3EB24341CE55F73E34386341E75595F45DAA4341	BD
1597	22	BG	Bangladesh	0106000020430D0000010000000103000000010000001A000000E4AF18F65C3E63411F72C2DB20E8434127BC1025963F634145B18EEE79E44341B4981652B13F634103B5EA0DD3E343419AF5FE1A0E406341A8ACA55805E14341FD56F24A0A4063419A49C0160BE043416B61B376E73F634161F2117685DF43412C64C5D1A13F634106B9A4B274DF43414079F11119386341B95E281710E84341CFCE7E21A537634165CC22C195E843411806E2FC6E3763417EB5119EB1E94341D9AF8FB55F37634190F2601D85EB43412D1739AA993763416969FFFEF9EE4341666C72A2D337634118D4CC1937F04341693B36AC783963416DC7B131C3F843412AC5C024C2396341423AC5EBEFF943414EFF7352BD3A634138B91A6E54FD43416E603459FF3A6341506E47B586FD4341C2386248353B6341DE769E3565FD4341109FF2ED993B6341D9ED0533BEFC43416EC78936E73B634199A2FB6906FC4341E6721576303C6341B28B88E10BFB4341BE5904A6C43F6341CD7BD4EA20EB43418EA595C1F63F6341FE8CCBDAD2E94341466E32E62C40634172324AAB8AE743416B61B376E73F634172324AAB8AE74341E4AF18F65C3E63411F72C2DB20E84341	BD
1598	22	BG	Bangladesh	0106000020430D000001000000010300000001000000120000002779B31AA23663415E9C316DD9FA4341873AF5850736634146B8F2BA7AF64341F95DEF58EC3563410425513BE4F5434128125E3DBA35634127DF3D44B2F54341521E18757C3563419527CBC1D3F54341C541124861356341E6BF373D59F64341BA8024F44D3563412416FEB421F743410F08F1282F356341DAF2176DCEF943414EFA643C2B35634110B043C348FD4341593F5404F934634195B42E0039FF43418CECD84F273563414E0F599EF601444121C7CF508237634100B92B29BF024441762E7945BC3763419D96ACE59D02444186971B46DB376341ACE06DE7280244418F58099AEE37634184E8915D600144418B3FD0F2E6376341C991F3C27BFF434137D826FEAC376341D0E9F1B82DFE43412779B31AA23663415E9C316DD9FA4341	BD
1563	22	BG	Bangladesh	0106000020430D000001000000010300000001000000150000003987D8B89A2D6341E94D575735E4424182BE3B94642D6341B754FA8377E442412E57929F2A2D6341AA3035A2C2E542419111EA71F02C634148C0135C0FE9424171E640CEE82C6341BD541321E8EB42419111EA71F02C63418CD0C123FAED4241DB5E41704D2D634101475D0720F4424114B47A68872D63417F1143877DF7424122D3A7CB432F6341909CBBB5F4044341D37A0861FD2F6341D4ECA27C840843418082B731203063411FE590FB080943410797E57188306341863126B88D094341AA84424CCE306341F87BAC796C0943412BF1BBDF2A3163416B4A57FAE70843414102138D55316341D4ECA27C840843414BC300E1683163411CD021449C074341E2B95804613163413959634AB4064341EFB6CABAB82E63416E1960204AEA42415EE1AE263D2E634100B46D6AF4E542411FE4C081F72D6341B1549178EBE442413987D8B89A2D6341E94D575735E44241	BD
355	29	BP	Solomon Islands	0106000020430D0000010000000103000000010000000F000000A96A102604927041380D93D324A527C1B1EBB6B79F9170418260A739738D27C164A54952E290704101AC7C591D3827C10334D2C4D89070412ED1ADE3473327C193C9A696DC907041C025B396F62D27C16E6637A6F59070411256DA00432527C1FAB22B333D9170418786FF8FB11827C1249FC22A58917041193341C4461627C11B1E1C99BC9170412D2BE98FF51027C1D8FE5BCA2A92704157AAB217FE0F27C1A62130E1479270410359A4F42A1227C1BECB32F3B39270416868EE71FA6727C145008473C392704173A3463AF77627C1BECB32F3B3927041BAB77D85137B27C1A96A102604927041380D93D324A527C1	BP
2984	36	CA	Canada	0106000020430D000001000000010300000001000000110000003A306D7958AD60C1551400BE24FE6341ED09235442AC60C10489E993BDFB6341FEEB4C37D2AB60C14DC345153CFA6341BE75D7AF1BAC60C11D9EFFFB6BF9634156F3A7F0A2AC60C14DAC775CBBF863418976DADE15AE60C1FE26A11B45F76341340502CDC7AE60C10893F924DDF663414C38142757B360C137F0F5D808F56341CEA48DBAB3B360C1B3E365D13CF56341A5B8F6C298B360C146B1EAE54AF663418626F841A9B260C12BFBD02681F963415D4EBF84B6B060C164C1A4CAE5FD6341ACA65EEFFCAF60C1D1A28E22F5FE634148F6353A4BAF60C138220BFE71FF6341792D5B1E9EAD60C1246B9988230064416AC4B81D7FAD60C1F32805530E0064413A306D7958AD60C1551400BE24FE6341	CA
357	184	PP	Papua New Guinea	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	PG
1565	22	BG	Bangladesh	0106000020430D000001000000010300000001000000140000003216A99BC13E63416A6D74CEFEF34241E4AF18F65C3E63413B535A15B5F442419FB11102423E6341DF7400B95AF542411D25752E3E3E6341E26DD0503BF74241B0A92F08653E6341641B5396E2F942419A1F5178C93E634102CEBA178AFC4241CE3B2E89543F634166B87B6E9CFE4241E7459B9DDF3F6341A50BDAEF94FF424126438942254063411982C42BB6FF424155D7D4E64B406341786625E320FF42417AAA32375F40634121FCB9DFA3FD4241D34A381348406341CBFACED2F4FB4241466E32E62C40634157439F264FFB424155505CC9BC3F634128A2BC89C1F942418FC5B8019E3F634175AF65E01BF94241DEA4D089733F63413DEDD7BDBFF74241319D21B9503F63416DF47F05F0F542417AD484941A3F6341AFD84ADC93F44241E8DE45C0F73E6341D0BA636E30F442413216A99BC13E63416A6D74CEFEF34241	BD
1566	22	BG	Bangladesh	0106000020430D0000010000000103000000010000000D0000006F509AC0334163416BD1ABDE47FC4241995C54F8F54063415E3DA3DC68FC42410B804ECBDA406341D5903F8A0EFD4241D8D2C97FAC4063413F8282CA6AFE4241D8D2C97FAC4063413C2F8B5984FF424160071B00BC406341C768A7DD5B004341995C54F8F54063414E939F4486014341CD783109814163411690E6AFB90343414A730D530C426341A4AFEDDA7E024341F1D2077723426341EF5BE2BCE90143415ADCAF532B426341C2193A91E0004341DBC1B0C9F84163413C2F8B5984FF42416F509AC0334163416BD1ABDE47FC4241	BD
1567	22	BG	Bangladesh	0106000020430D0000010000000103000000010000001600000010D51CC616326341202657BE81F24241D77FE3CDDC3163417E2E818BB3F242411C0F92FC9A316341C333DD3DCDF34241E8610DB16C3163417A32DABC39F54241C38EAF60593163411887ED4A0BF94241E240D121F03163415BA2B2E6CC0E4341D75FC08D35326341AEF445621111434125C650339A3263414B4285E0AF1243415AE22D4425336341418B2D31B913434111ABCA685B33634149D1490BEB13434144584FB489336341E1F92F2D98134341BBA04734F5346341F95D2CA48A0E4341B2BF36A03A356341D003E6B6700D4341F3D55DEC873563418A9EBC337F0B43410E6F460617366341B464F0274006434147C47FFE50366341E9499D5303034341E4628CCE54366341EF5BE2BCE90143413E0392AA3D36634127EC46482A004341B046AFBDC93563411DE5D08179FC42413F3F160D82336341D0398A720FF442417FBFBAB14C326341D343DDF6A2F2424110D51CC616326341202657BE81F24241	BD
1568	22	BG	Bangladesh	0106000020430D00000100000001030000000100000010000000A0F7D5728A2E6341975AC99E3C0243412E2D40426F2E6341F1DAF153E20243410E02979E672E6341F885EB29FC03434119C384F27A2E6341F38DCA14AB054341E90E160EAD2E6341DD57F0A531084341AF405533022F6341FA301B5B2C0B4341AF1603D646306341C556C74C47154341F72D437169306341BC2170D4AA1543419473EB9EA3306341ED552B72DC1543414C3C88C3D93063410E07CE92891543415BA52AC4F8306341EB1EE30605154341020525E80F3163410E49E2F83D144341DD31C797FC30634139642AB33B124341C4073743CA3063412767D996C50F4341B32F3C7D4E3063412C654F73670C4341A0F7D5728A2E6341975AC99E3C024341	BD
1569	22	BG	Bangladesh	0106000020430D000001000000010300000001000000160000004079F11119386341F2D4056E49074341EEA0C322E337634170E79DDA8B07434122E7F290293763419634A936F1094341DE41503FD8366341EE59C3B3E20B4341873AF5850736634105DABD347E124341873AF58507366341E75918EC76134341861AD24560366341632DAEB4A01B43410E4F23C66F3663413D516E3A781C4341F4AB0B8FCC366341FCB0A821381E4341770B2E8A7F3A6341F47B6643252A4341AC3DFFBD9D3B634160BDBCCE412D43413E131B52193C6341394B800D7D2E4341CA56765C1C3D6341CE1C85B6D2304341136EB6F73E3D6341C334F2D04D3043416B0EBCD3273D6341111D2CF1012F4341443E86FEA93A6341553CAA9F8E124341770B2E8A7F3A63419B3B69BA00114341B781A311363A6341D7BA458EDD0E434179A4D8AC973963419BA640B2FA0A4341E7AE99D874396341F9EB2FF4750A434122BDA0336E3863412E4A21C1FF0743414079F11119386341F2D4056E49074341	BD
1571	22	BG	Bangladesh	0106000020430D00000100000001030000000100000018000000E934B73E4E1F6341D487B4BD2708434188D0990F6A1F6341849BA15120094341AC4DBDBC9B1F63413371EDF23C0B4341AB2D9A7CF41F6341C647EDF25A104341F9932A2259206341EADDE002451343416A1E7AD2252163411C0E3EFE731843416A717175E5236341F833E639062543414A26A591362463411E24C1F6302643410ED2EAB6E42863414211F6430C374341991F75DEFB286341296218054C35434111EB235EEC286341AD67BD7649334341D9B50DA659286341A4290FDD75284341C3A4B6F82E286341EA78DE2919274341B45B3738B727634183EBCDEBC32443414D72B29B56276341A84A38600D24434142426C82E6266341FE434D32992343416DA78A5C72266341D3F1EB7F67234341DFEAA76FFE256341485B9C77BA23434157D6792F962563412451F1AD4F2443415EF7B5BE12256341F1CCA5A52E2443412ADBD8AD87246341C4C7CC2E2C2243416AF427756A226341862DF2B16C194341D9283BFE022163419542305B4C124341E934B73E4E1F6341D487B4BD27084341	BD
1586	22	BG	Bangladesh	0106000020430D00000100000001030000000100000020000000FF520CC7CD53634176E62FE3A21D43416B4B9BED2155634155E13F472F324341943732E53C556341B4547EAE09354341A480B1A5B45563411C91DB5A644C4341A9286652C0556341F396A8D39E57434189FDBCAEB855634153CF2A8DBC5A4341AFD01AFFCB556341BF5DF9F3FE6443412523429C4B56634194DED7469C80434155B78D4072566341E50FB16F46834341E393936D8D56634138F069CEEC83434140BC2AB6DA56634198A3F5EBD5844341993C0D521C576341C99E7356E6844341CCE9919D4A5763413973002E93844341895AE36E8C576341F4AA469799834341E0DAC50ACE576341D49042C89581434176B5BC0B295A634138B578749B694341BF4946A7C65B63411552E048065543413C9D86931B5C634118160488E24D43411D72DDEF135C6341E9B64B9BD9474341F79E7F9F005C6341013C6BD2F443434161018C1ED25B63414A824D63143D434190B5FA02A05B63416060508572394341A63FD9923B5B63410325DAA5AF354341436F8D9DE25A6341258AEA15AD3343412E9E7C70065A63413FA4838CB82F43415EAB4FF79D596341E079C70E2A2E43413B147609CF566341873A6B31E52443412CCBF64857566341D3F1EB7F67234341B482FEC8EB546341146433AD941F434123ADE2347054634131778F65591E43411E2551C80B546341BAA0B38CB31D4341FF520CC7CD53634176E62FE3A21D4341	BD
1587	22	BG	Bangladesh	0106000020430D000001000000010300000001000000150000001893B4A4C53E634118891AD709524341DF3D7BAC8B3E6341943F12E4625B4341D3ED1153743E6341BE6563E3265F4341C5846F52553E634165DF2D56D0614341C936531C753D63419CE8FE50136C43411EBE1F51563D6341ABB09F75986C43410ACDEBE3D23C6341BA237EE9DA6C4341722FF862A43C634118E234B63E6D43412D31F16E893C63410580A6F7E46D43418C79ABF77D3C6341898D0FA5B66F434158AC036CA83C634198251A8924714341BBEDD35BFD3C634107E4A75128734341E9811F00243D63412C01F19A9C734341C07565C8613D6341D5947D40AD73434186A7A4EDB63D6341EAC202FB1D724341D25467305C3F63419083C2B86C66434127BC1025963F63416E5751BE5864434160114A1DD03F6341B3F2830C096143416B61B376E73F6341B9952F493E5E434165B9FEC9DB3F634110FD7BC1445D43411893B4A4C53E634118891AD709524341	BD
380	105	ID	Indonesia	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	ID
368	184	PP	Papua New Guinea	0106000020430D0000010000000103000000010000001A0000000E444172AB6A70410C5B1DAFBA7222C1612508E4256A70415DAB1AED1A5B22C1DDE9CB884D697041CF2AE9AAE60F22C141C4469BBA68704136E0296EDAD421C11010D774C36770418494EDC5FE5821C1F30DEBD5D067704125492F20E04E21C1BCF8F89F0E687041A17E3965F93E21C1EA8C44443568704104E9B7EBBE3721C12F32E79586687041B7396063412A21C10CEE058DA06970410DBDC2EC9CFF20C1A28BF90DCF697041B638457B97F920C12AA0274E376A704190CF0C7B03F520C15532C408B96A704152EC4E2C16F320C1D62E4F3CE96A704152EC4E2C16F320C1C57CCCF60D6B704189F4AD8B4AF420C12CF66233426B7041B638457B97F920C1BCFB2565726B70410DBDC2EC9CFF20C1EB8F7109996B7041E86F9B7D990621C1A647F5771B6D704181C81BA7EE8F21C15DA0A33C256D7041EE29ED7FC09421C15DA0A33C256D7041A9FC74348FA021C1DB1D3686356C7041EF516072C64F22C188B5F6F62B6C7041D86F06BE985422C19A67793C076C704119758139965B22C1BAB24520B66B7041A336CD034D6322C10E444172AB6A70410C5B1DAFBA7222C1	PG
369	184	PP	Papua New Guinea	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	PG
370	184	PP	Papua New Guinea	0106000020430D00000100000001030000000100000011000000A4827D3E33AB6F4181F65AFBA1A220C1FA13799028AA6F4161329FF4A59B20C15DCED062EEA96F417E68D84E3D9920C1DD7A907699A96F415FF47881BC9220C14135E8485FA96F41293DCA484E8A20C13D1CAFA157A96F41908164D6018520C1ACCD0B2B6BA96F41991CA6856E8020C1DC6157CF91A96F41E5F161E7057E20C162F3CE0F75AB6F412785F5A97F7120C19FF0BCB4BAAB6F4177F62441047120C1F3C8EAA3F0AB6F41800D3BC7387220C1EC362A1A78AC6F4170193B19227B20C11CCB75BE9EAC6F4171CF1618817E20C14F78FA09CDAC6F412DDD94766A8720C121E4AE65A6AC6F4114101C68078B20C162F3CE0F75AB6F418DCAA7C826A220C1A4827D3E33AB6F4181F65AFBA1A220C1	PG
387	184	PP	Papua New Guinea	0106000020430D00000100000001030000000100000017000000A9EB8334A5CC6E4107D449C1E8EE1BC18BE0FDD044CC6E4107D449C1E8EE1BC12D11CB2AC1CB6E41D2A448CE18EA1BC13D9A906B87CB6E41B198D724C4E51BC1DF71F9223ACB6E4150948F5554D71BC18C99CB3304CB6E410AFD5954F8C61BC11EE86EAAF0CA6E41AA0E84F358BD1BC12F7134EBB6CA6E41D2D18EAD61891BC11EE86EAAF0CA6E41BB057EA38A781BC1DF71F9223ACB6E4167A3D1F3956A1BC11D6FE7C77FCB6E41D62657AABC661BC14B2A42C93FCD6E419B7158BB87521BC164C32AE3CECD6E4193D8738B57571BC1E19DE3ECB2CE6E4167A3D1F3956A1BC143DFB3DC07CF6E41685E24A693771BC1A2074B2555CF6E413CA9A5BFF9861BC1EFC63F6D83CF6E41DBFDB35C53A41BC1D19B96C97BCF6E416B4D5140E9AE1BC140E69D75A7CE6E413527344424DC1BC193DEEEA484CE6E41442DE0E3E0E21BC1F59846774ACE6E412769B31D2CE81BC10209D31009CE6E418EE774368AEB1BC1A9EB8334A5CC6E4107D449C1E8EE1BC1	PG
391	184	PP	Papua New Guinea	0106000020430D00000100000001030000000100000016000000CBEAD85FEF0C6F4192ADD7ADCA6920C14D9798739A0C6F415A68457E4F6920C1C1533D69970B6F41C3B8CC1F036420C16F7B0F7A610B6F41B4F252899A6120C153E22660D20A6F41F31E2C51B15820C14379845FB30A6F41323FE545995420C183969544A00A6F41D804D35AC84F20C1AE11A841BF0A6F41DAF173B4AA4520C1730DD003DA0A6F41B82EF7B1924120C1C1533D69970B6F41D54BCFC3C02F20C15D99E596D10B6F41BBAF853B582D20C13D2EF6727B0C6F41BBAF853B582D20C13C0ED332D40C6F416DAC6397452F20C16BA21ED7FA0C6F4128AE61E7AD3120C10FA66FD4D30D6F41B82EF7B1924120C152BC9620210E6F41E0A0E6A98E4820C1DB7F63A6340E6F41A8ABDCC95F4D20C1DB7F63A6340E6F41A57F9FB3305220C14EA35D79190E6F41D89C9AF6485620C192522FE87E0D6F4182D658E6E66620C12C2CA94F440D6F415A68457E4F6920C1CBEAD85FEF0C6F4192ADD7ADCA6920C1	PG
392	184	PP	Papua New Guinea	0106000020430D000001000000010300000001000000190000003BEA35F6F4C06F411A7C8C62A9E51FC1D9A86506A0C06F4166259C9EB2E41FC18C2F243ECABC6F41872E7FF349D51FC14B19FDF17CBC6F41CCF2EB0BE1D21FC18EA8AB203BBC6F41801FB3E306CF1FC19E31716101BC6F41A8C2055BB1CA1FC1201772D7CEBB6F4116337EC06EC41FC14009DA18B4BB6F4137F57BA43EBC1FC1D2577D8FA0BB6F411C48197A0EA71FC14009DA18B4BB6F41C1D13E2E6D9D1FC1209EEAF45DBC6F419FDEBFDE6B831FC1C1E86D8F77BE6F419EE037A103671FC13E3CAE7BCCBE6F41EF075C8591651FC1A17D7E6B21BF6F419EE037A103671FC15DCEACFCBBBF6F41EDE369FFD36B1FC15D55251A4BC06F41742BAD1C9B711FC1A9141A6279C06F41F4465DAD62771FC1093DB1AAC6C06F4181E4D3BBD4851FC127EFD26B5DC16F410C32BB9A3DA21FC175AEC7B38BC16F41439EC5FD0EB41FC1C4347B9997C16F41A8C2055BB1CA1FC157831E1084C16F416ED0E9CED7D31FC1471A7C0F65C16F419B53F08307DC1FC1F75A87C736C16F41E1079B264AE21FC13BEA35F6F4C06F411A7C8C62A9E51FC1	PG
394	184	PP	Papua New Guinea	0106000020430D000001000000010300000001000000090000001C8FFABF30EF7041C9690C1C6AF41EC13891E65E23EF70418D639972BFEB1EC1B1CC833E40EF70412CB4893DB6AB1EC14A23466457EF7041FF2521ECEEA51EC1486A77BF6EEF7041017DAA50F8BE1EC119461A7B74EF7041CB6EAF8199D51EC17FEF57555DEF7041BC20A935EFE61EC1682532034AEF70414FC354CA27EE1EC11C8FFABF30EF7041C9690C1C6AF41EC1	PG
397	184	PP	Papua New Guinea	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	PG
382	105	ID	Indonesia	0106000020430D0000010000000103000000010000000F0000008565C95C3F976B411EE06FC27DA41EC199E7A40466976B410DB2157444B71EC1653A20B937976B41CF9C5E8314C91EC198602CE7D6966B4139DBD3261ED51EC1A8E9F1279D966B41F9A72E5FEED91EC1AA62790A0E966B41217397C0B5DF1EC1EF5191F9C1946B417BC5CE9757DC1EC1AC3B6AAD74946B41F9A72E5FEED91EC1BA11CF8A85926B41CF9C5E8314C91EC17CF4BDA598926B41A5904105EFBF1EC197ADC9FFCE926B412917FB611EBB1EC198602CE7D6966B41821179DBDD731EC135A6D41411976B41B34E49B245761EC1C382DA412C976B41F1F58E3E757E1EC18565C95C3F976B411EE06FC27DA41EC1	ID
383	105	ID	Indonesia	0106000020430D0000010000000103000000010000000F00000023F1240AD2936B41489B31DAB2771EC1538570AEF8936B4140F8EED6E67F1EC1538570AEF8936B4131BA0ADAEF8B1EC123F1240AD2936B41C7CD2D64AD921EC1EA65D4AE5D936B4180B5B2254E9C1EC1DAC3F04B1C936B41D8582E26AD9F1EC17882205CC7926B412F84D4E4B69E1EC1EAA51A2FAC926B4135F6984A87961EC148EED4B7A0926B4131BA0ADAEF8B1EC10AD1C3D2B3926B41802ADC204F821EC138650F77DA926B41E58FFF43167B1EC16B1294C208936B415E8C0A734F751EC12883E5934A936B414807B1EBF0711EC12863C253A3936B4174C0CBE27E701EC123F1240AD2936B41489B31DAB2771EC1	ID
384	105	ID	Indonesia	0106000020430D00000100000001030000000100000011000000463089DAF5F26B41D2C50C6F88F51DC1DBB0831A65F36B4127C41D59B2031EC1C5C311CBEBF46B417F2C07A77F491EC1F5575D6F12F56B419F0C0B71B8501EC1E5CE972E4CF56B4107652AFB16611EC103FA40D253F56B41E7ADC553AE6B1EC1E5CE972E4CF56B41C1EA7F25588E1EC1B53A4C8A25F56B41E1ED17C11EA11EC1667B5742F7F46B413FF96F9FE5A61EC1033A8752A2F46B4191DD7DAC57A81EC1C73C99AD5CF46B413FF96F9FE5A61EC147E958C107F46B41E2740C4AE6991EC15938458189F16B411BD2D99170F01DC1A6F739C9B7F16B4155BEC3EAA9EA1DC1D1F9C4E365F26B4155BEC3EAA9EA1DC192834F5CAFF26B415C6DE62112ED1DC1463089DAF5F26B41D2C50C6F88F51DC1	ID
402	105	ID	Indonesia	0106000020430D00000100000001030000000100000014000000E9F15C0E87FE69414AFA1A521B0317C1C2667CCFE9006A41930B22401B5117C182496BEAFC006A41B8609042515817C1C3F4AC60B8FF694177F078573F8C17C12B57B9DF89FF69410D51477B7F9217C1AF0379F334FF6941AEC73A6B759317C175AE3FFBFAFE6941A13A8767A68E17C1F2B24A629AFE6941890039841C8317C13149E329F8FD694169FDDA1EB46717C1DE451869D1FD694154EDEE177E6017C11397C16861FD6941D692E6F7503F17C1EEC363184EFD69413C9E1F412E3617C1EEC363184EFD69411556A375241E17C161F2D77C7CFD69417FFCBF6ACBF416C16B17A404A3FD694100FDB2090BE216C19BABEFA8C9FD694131D26729D5DA16C1B95297D816FE69419F62DC476DD816C12C810B3D45FE69413D18B28232DE16C17FE8B4317FFE6941523DA73A90FA16C1E9F15C0E87FE69414AFA1A521B0317C1	ID
403	105	ID	Indonesia	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	ID
404	105	ID	Indonesia	0106000020430D00000100000001030000000100000013000000B2FF5D6D43166B41099339AE220F16C1BD2FA60A06196B417FB2FCBB1F6316C1B4EB01B76D1A6B414310639CA8A016C159BC80D5801A6B414D2F144946AA16C1CE8E19EE101A6B41FA0767F9E3B316C16B17329B81196B41DA937CBAA8B916C16584269DD3186B41EF5641B60FBC16C127B2D5C97E186B4115DF14A29EBA16C12609A2FF8A136B41C9B16763558316C10D0AAF7C49136B418111B9EA7C7F16C17AA517E3C9126B41F9F3D4CF507716C13B16378FAB116B4153F08B7EBD5316C17580193643116B418C4B6B96253D16C183515C887F136B41E8A13B8D040216C179704BF4C4136B419707BD50A7FE15C1723A66B6EA146B4182635F319DFF15C115FD25BF3F156B41E2C8183B0E0116C16E93FC7D14166B41A0872883300A16C1B2FF5D6D43166B41099339AE220F16C1	ID
422	105	ID	Indonesia	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	ID
3589	36	CA	Canada	0106000020430D0000010000000103000000010000000D0000004FA61A6E28F466C1D4104799664F6341EF88FB32D2F166C1919CF830F04B63418779F9CB02EB66C1A79726236B446341E43383C328EC66C14DBF071B4D426341CEA9A4338DEC66C1557CE7909B4163416BB05155AEEE66C1AE95EA412F3E63419E68503226EF66C1191F2AA89B3D6341BD1A72F3BCEF66C14060C8BA4C3D63410075543376F066C1C5CE3235883D6341688976A1C7F066C1C97307C51B3E63410DADEC629AF366C133E529144547634133804AB3ADF366C180FC42A7004863414FA61A6E28F466C1D4104799664F6341	CA
434	105	ID	Indonesia	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	ID
3591	36	CA	Canada	0106000020430D00000100000001030000000100000011000000CBE05E1AE2DB66C1F2FA9BE093756341D63AF7900DDB66C1D7ED49E2657163411B5921C5CFDA66C1C76287AF366F634115B16C18C4DA66C1C0CC2CBBB06D6341C6D15490EEDA66C1AEF98A71D56C6341A26D4F0538DB66C158BAF5E1E56B6341C6BCABE190DB66C1BD87D46C1E6B6341FA74AABE08DC66C1FA6F54E1886A63413EFA29D0B2DC66C12E018303576A6341BA3C832BB4DF66C168F6CE8053746341A94FDFB6DADF66C1B7D7E3DFC5756341BA3C832BB4DF66C1599108C8A1766341DDA088B66ADF66C1D239471292776341E8CF835BA5DE66C16E1DF0A26E7863416C8E7574D9DC66C1950A1CEC69776341E0D1928765DC66C1917516B4DD766341CBE05E1AE2DB66C1F2FA9BE093756341	CA
702	218	TH	Thailand	0106000020430D000001000000010300000001000000100000005A1D6482D9C7644140B0DC7BB3CB2F411EF96680FAC56441C05407C0F2DD2F410F90C47FDBC56441DC22F6EBE4DF2F41EABC662FC8C5644131AF588753E22F41480521B8BCC564418D06F3C8F9E52F41B47637C181C664418B7C9456AEF92F4109DEE0B5BBC664418B7C9456AEF92F413C8B6501EAC66441B158311F77F82F411C40991D3BC7644162CF6195D0F42F4160E53B6F8CC7644198C198A4BBEE2F413131CD8ABEC76441BFD2AC6423E92F41E8F969AFF4C7644130BA568B98E12F413C6113A42EC8644139616E1C15D92F41EE81FB1B59C86441DF57D48AD6CF2F41C49564243EC86441E74D06A0A5CD2F415A1D6482D9C7644140B0DC7BB3CB2F41	TH
703	218	TH	Thailand	0106000020430D00000100000001030000000100000010000000B3BD695EC2C76441A5634B5F99F32F41FE83483F90C7644162CF6195D0F42F41D4A1E06489C664410777CCD5000030412E42E64072C66441F4A6849E760130414C6D8FE479C664414CE77AB9B10630415315449185C66441F5714BC0650830410DF7195DC3C6644158CCD275960A3041E251B502E9C76441677C58E8350F30419501198017C86441143CD3A5D10F304165F445F97FC86441143CD3A5D10F3041C9C491EED8C86441AB46BB7C1D0E30413636A8F79DC964417AB0BCF3380A3041E2AEDBC2BCC964416E6288D23F09304101FAA7A66BC96441644C8A395E003041D80D11AF50C96441E65D75C74DFE2F41B3BD695EC2C76441A5634B5F99F32F41	TH
704	218	TH	Thailand	0106000020430D00000100000001030000000100000012000000DC2D6D7BB93F6541FDC89FE6532E3041CFAA16BE4F3F6541DE1E6A74F70E3041AAD7B86D3C3F6541AF71CCB9880C304182078398BE3C6541DE6D429B23F22F4128F824F7783C654143184FBC6FF02F41D71B35EA383A6541323811B961E92F4179F39DA1EB396541323811B961E92F41E727B12A84386541A0055572C9EC2F41AED277324A386541ED864F6976EF2F410C8CB6B53A386541EBB5C92454F42F4121169545D63765414320A609172F304154161134C43A654184D505F9DD3B3041272BF959913F6541ECEC789B19413041AF6AC46BEA3F65419B0DD614584130418E9BF61381406541B2C0CC0BD3383041ADC69FB788406541971C8CB706363041CE116C9B37406541FF61171C7F323041DC2D6D7BB93F6541FDC89FE6532E3041	TH
705	218	TH	Thailand	0106000020430D0000010000000103000000010000000F000000099920C3262B6541AF2551DA092D3041DC7003E5742B654126EAFDF2A72C304115C63CDDAE2B6541C5ACA668702B30413A999A2DC22B654196ABF155012930416E6642B9972B6541AD7AD671232430412F695414522B654166060CB65D203041BC2F661EDA2A6541DA794CAFEE1D30411549F3DC332A65413A0EA5C1331D3041B7205C94E62965413A0EA5C1331D304121A38B535F296541792F0D4F261F3041F10E40AF3829654118EC2478F92030416ADAEE2E2929654156BE2C8268233041FD5EA90850296541E0CCB6AE3B25304183DA2C26A02A6541FA3A3420C72C3041099920C3262B6541AF2551DA092D3041	TH
707	218	TH	Thailand	0106000020430D0000010000000103000000010000000A00000051BA8F7B5D2A65415F4493EE1C4F3041FBA5DBA5902A65415716C62D264D304183DA2C26A02A6541D40E76F6B64A30414E9E2CD56D2A6541DBFDB03741493041F71D4A392C2A6541D5D983F066483041BDC81041F2296541B25B4BA79E493041AE5F6E40D32965415259E162CF4B30410CA828C9C72965414376A7F71C53304165280B65092A65419DCFE4B62352304151BA8F7B5D2A65415F4493EE1C4F3041	TH
709	218	TH	Thailand	0106000020430D0000010000000103000000010000000F0000004D5764E671E56441666DE692CA8A3041AA49E4CB84E564417A11FD69EC8830413B3F23A0A7E564411B790D39BD813041BE5A3B79AFE5644162E1E032F07E3041AA49E4CB84E56441162FE8BC1C7D30417114CE13F2E46441BDD1D5355D7830410E64A55E40E4644151B63F31D5743041F539150A0EE46441BE4FACBACE7530417B5872678AE36441F6FF4D98B87D30415C2DC9C382E36441FB487B6385803041038DC3E799E3644117B63087D582304177E6D41DB9E364414B37BBB406853041F9481F9401E56441D324A907349130412CF6A3DF2FE56441391094AB3A9030414D5764E671E56441666DE692CA8A3041	TH
448	105	ID	Indonesia	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	ID
458	105	ID	Indonesia	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	ID
3628	36	CA	Canada	0106000020430D0000010000000103000000010000000A000000BB256C58E80965C1250165197F1B64412E0C63ABA00765C143F91BE7B8176441C58933EC270865C1805CBA466D156441D382D00F330D65C1AD150EFF6D1A64413A6C55AC930D65C141F090980B1B644111609B74D10D65C18942D4A5BE1B6441605FD63C4E0D65C146B73B4F5C1C64413C0F2FECBF0B65C11DC7C6EF511C6441DF5F1F86E30A65C1897DAB92081C6441BB256C58E80965C1250165197F1B6441	CA
465	105	ID	Indonesia	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	ID
468	105	ID	Indonesia	0106000020430D0000010000000103000000010000000E0000009C2A8BA0F59D6941FB5AED3473DDFC40277110AAE09E6941564BC9637292FC4060C649A21A9F69410AE29FBC3E7FFC40DD198A8E6F9F6941F85EC38E674BFC40C6AFCE3E7B9F69412A05D213401FFC40DD198A8E6F9F6941C65649FF00F5FB406543617D359F69419E305D26CFE1FB40EC97D53DEC9E69411BE92DF568EBFB408B0E883C219C69416FEEDA0787F0FC400E7B01D07D9C6941116B72652C11FD40CAEB52A1BF9C6941CDF7E33C8820FD40522B1EB3189D6941F24E4478C41AFD400E9C6F845A9D6941AAA7348D540DFD409C2A8BA0F59D6941FB5AED3473DDFC40	ID
489	105	ID	Indonesia	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	ID
498	105	ID	Indonesia	0106000020430D00000100000001030000000100000016000000A42E6CF77B1E664158F44B9A8959F540B530B91AB31D66414F649D18D871F64060C90F26791D664173D8AB000AB5F6404117EE64E21C6641F4CEC7755026F740969340087A1C6641D496D5348D50F740604CC625FE1B664108CDF7473071F740EFCBA592451A66417B0DE8712FD1F7405EF689FEC919664133EC6F1BC62AF9405EF689FEC9196641917846E1DA58F940BC1E2147171A6641C7AC0D8D7392F94072C79A2BA61A66416E2C57137DA9F940906E425BF31A664195429B19E59FF9404332F19D0723664130C370445A6DF740B560650236236641F6EE14386354F7407CEB08CA54236641633D5327C033F740C085318A5C2366415B09546B8309F740C085318A5C23664168E522CE84D9F640FEA2426F4923664173D8AB000AB5F640AB9F77AE22236641C9574FFE3C98F640764D833A5D226641C38DCB1E6834F640D907DB0C23226641393BAACD3421F640A42E6CF77B1E664158F44B9A8959F540	ID
499	105	ID	Indonesia	0106000020430D00000100000001030000000100000011000000E17E9B8F38F86541C8A301D53B42F840313B66D87EF865417AECCB8FD2F1F740560EC42892F86541893CBB886DCBF7405A27FDCF99F8654108CDF7473071F740277A78846BF86541443478E4265AF7404BFEA04FC9F76541E468CFE7FC5DF74046CF73852EF7654108CDF7473071F7409B404C977CF6654157AC04A5F2A6F740A1965415FEF46541BE50147E0635F840FFD3940CA9F46541C268FB4BDB68F840FA2BE05F9DF46541B2A6D13B8089F84032811958D7F46541FE8EEFAAB39CF8405109E9BBB2F665419F14129AC6CAF8409F7AF3F260F76541392A27C718C3F84017267F32AAF7654112607C0E7FB9F84090FCA743E4F76541CC76E49D4BA6F840E17E9B8F38F86541C8A301D53B42F840	ID
510	184	PP	Papua New Guinea	0106000020430D0000010000000103000000010000001100000010C4B286EB526E41B50E34655D6607C10022CF23AA526E41C1A7C537726407C19170729A96526E412B0F26243D5107C1B19B1B3E9E526E41CF409BE71C3C07C110C4B286EB526E414128BCC52BF206C13F58FE2A12536E41649CEF0DBAE406C1DF96BCBFAC536E4134274D9D0BDD06C14C6F28A659556E41EEE5D4CEECDF06C147FD8A5C88556E4164AFE35A73EB06C16728340090556E41A091D4A7C71307C1D432F52B6D556E41E408486D2F2207C17B23978A27556E41C745CDDBE72807C1F9B61DF7CA546E412311D074E61007C1B6A0F6AA7D546E4197819833190C07C158785F6230546E412311D074E61007C1BC32B734F6536E41E358F0F7801A07C110C4B286EB526E41B50E34655D6607C1	PG
522	184	PP	Papua New Guinea	0106000020430D00000100000001030000000100000008000000045515724BAF6E411A0E4EBA59E002C128D93D3DA9AE6E41BAF21136A0C102C11357629582AE6E418E1500E32FB402C123C00496A1AE6E419C58099CE7A202C14272265738AF6E41F442B5C9B3A702C114BEB7726AAF6E418E1500E32FB402C1D7B9DF3485AF6E411631AE95BFD602C1045515724BAF6E411A0E4EBA59E002C1	PG
525	184	PP	Papua New Guinea	0106000020430D0000010000000103000000010000000A00000031E9601672AF6E41145596EF7442FEC04272265738AF6E41145596EF7442FEC0B495202A1DAF6E41A8800237D121FEC0D4C0C9CD24AF6E410971034D92C7FDC0E4296CCE43AF6E412C8E76A1EEA6FDC0D4A0A68D7DAF6E419C3FDB7D88B0FDC0C0C566438DAF6E41999E66F2EFD6FDC0617DACBA98AF6E4179AEE9812D01FEC0C0C566438DAF6E41A8800237D121FEC031E9601672AF6E41145596EF7442FEC0	PG
3667	36	CA	Canada	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	CA
521	105	ID	Indonesia	0106000020430D000001000000010300000001000000180000004F96197FDDB06C419EF90E1B8EFC03C1598D1E362BB16C415150D857140804C1648423ED78B16C41E9946C76E10C04C1BF26C1351FB66C41C4E74FD2661804C1CCF04B141CBA6C416A83A6D17A1604C1F9ABA615DCBB6C41CFED8DB38F1404C1675D039FEFBB6C418512B330CE2604C1C6FE21CAADBB6C41EFDBCD11884504C11B17963932BB6C4107055540DC6D04C1EF140B1F84BA6C412D131332AA8A04C1FC8497B842BA6C41D6955876629104C1383CE55272B46C41F93B1F0997A404C1548E9BCFC0B36C413483A82982A604C11CD0761134B06C41BE7152BFFC9A04C11B49FEF3A4AF6C4129022C56778F04C12CD2C3346BAF6C419AB62E0EDD8504C1CB90F34416AF6C411A403A3EF06B04C13DB4ED17FBAE6C418D2962109C4304C1E2846C360EAF6C41E6D5188E673004C11119B8DA34AF6C41552D0911012204C1B98EA621DFAF6C412B087EA427EE03C18FF370E418B06C4180E8166A8DE403C10C47B1D06DB06C41545B50876EE703C14F96197FDDB06C419EF90E1B8EFC03C1	ID
523	105	ID	Indonesia	0106000020430D000001000000010300000001000000130000006880D33890936B41E53790A365EDFEC0163BE5F0BA976B4151A70D37E088FFC0D3AB36C2FC976B412959672E3C98FFC0E214D9C21B986B410AE6F50FE0B8FFC074637C3908986B414D7C32C747DFFFC0A4D0B88095966B41D0FEA297865200C14AC15ADF4F966B41E875E99A345A00C1725D22AF40916B416ED25E96B1C600C1101C52BFEB906B418C8DF7A8CFC300C1C43BBB192E8C6B4124767EA5EC6000C1375FB5EC128C6B41AA2AA1A59A5000C1D4A45D1A4D8C6B41C20616D6FF1600C12F5B5719C98C6B414D7C32C747DFFFC00DF067F5728D6B41D2FD3E36ACA5FFC01ECC265D4B926B416C2F447395E7FEC07CF4BDA598926B41EEA4118DFBDDFEC0A7166C00EE926B415517147425DAFEC008583CF042936B41EEA4118DFBDDFEC06880D33890936B41E53790A365EDFEC0	ID
524	105	ID	Indonesia	0106000020430D0000010000000103000000010000003300000042B0462A10CB6B41C83291A6EE10F8C0C29DC9579FCC6B413F18F5CE8930F9C0105DBE9FCDCC6B4187A8064F9347F9C06D8555E81ACD6B41D4CA640B2D51F9C0B959278859D06B41E52D6CE2220AF9C0DE093899DDD06B412A87D39941EFF8C0356D21F45FD16B41F958DBE558CAF8C0B90C88EB0ED26B41421872DFDB98F8C0B8EC64AB67D26B417016F7D80595F8C00AC5929A9DD26B416C95B38337A8F8C0D5C595C997D46B416623D85C1743FAC0C243BA2171D46B41DE9EDCC61743FDC0B2A1D6BE2FD46B41F84679779D0EFEC00AC5929A9DD26B414B8623A62BBB00C1B8EC64AB67D26B4148B54AA3D0DB00C13DAB56C49BD06B415978D32CCDE401C1B959278859D06B41544C8F947B0402C146AFB497E5CF6B411A3AF2F9BA2E02C104604CE975CF6B416ECC7947EE4102C18C9ECC8699CE6B41BCF14C84405202C12A5DFC9644CE6B412F9D6D6D555002C101FA889EB8C96B41DB023ED49A1902C1D65E51DD9FC76B4195CF46C28EBA01C1F8EFD040A7C36B41FB6BB0AEB1DE00C1D8E44ADD46C36B416ED25E96B1C600C1C3626F3520C36B414C837C9B4AB800C1107DF454B7C26B41BC7DF092207400C1DEEF924930C26B412FEC14DE27FAFFC0AA3649F882C06B41F8DEDAA8F1C6FEC01ED3CAADD8BF6B41B05803FBD44FFEC072F70323DCC06B412C8E76A1EEA6FDC0E3C19953F7C06B41971E7F0C5F84FDC003ED42F7FEC06B4165DAF28D215AFDC0E833379DC8C06B41C3601351DA18FDC087128AED1AC06B417467AA4F2B51FCC0BD78DC9B08BF6B41E398017E695BFBC01F33346ECEBE6B410BCBEDE83548FBC0FFA035EDDEBD6B41193C48822A31FBC04430E41B9DBD6B41B6070BC2CE21FBC0D285712B29BD6B410258848853FDFAC080AD433CF3BC6B41911308DB20BAFAC0DDF5FDC4E7BC6B41105034B8E38FFAC080AD433CF3BC6B4138F5839AA665FAC0F177D96C0EBD6B416623D85C1743FAC0E1EE132C48BD6B41D13364D7E32FFAC0ECA5D26247BE6B413BFB254373F2F9C02EE96296F5C66B4178818670A885F8C0621B34CA13C86B417098DF899557F8C013FCD5C1EFC86B41A550147E0635F8C027AA99AF3CCA6B419406FB49FB1DF8C042B0462A10CB6B41C83291A6EE10F8C0	ID
526	105	ID	Indonesia	0106000020430D0000010000000103000000010000001A000000DCB2761D37A46C41AF97C1397B77F9C024EE9B160BA66C41EF0B7B82D9E8F9C092D8390241A66C418B4C13040DFCF9C034DC8C836CA96C41E4EE0DF5A485FBC06470D82793A96C411A2D595A72A2FBC06470D82793A96C41E9B3CB7387D0FBC044452F848BA96C41A944331DD9E8FCC0A38DE90C80A96C411FC595511813FDC0084841DF45A96C41D97CD0794B56FDC0AEF1B0A0BFA76C419425F052B46CFEC060AB433B02A76C41A830E4FDB39CFEC0C06C85A667A66C41FE8369C6E7AFFEC0E1D774CABDA56C4172E821AB81B9FEC023D4E5D56DA36C4162CC7DB0B3CCFEC0656A7E9DCBA26C41B66DB4C357BDFEC073F343DE91A26C41F76653FA23AAFEC0D3618EA6379F6C41B5ACAFF9ED26FCC06DAE206D119F6C41EF0BE088200AFCC0A1B4095B099F6C41CF8165FBE3AFFBC02E1888A5B39F6C415FE113C4B993FAC0EFFA76C0C69F6C4163C2A13AEE76FAC066436F4032A16C41C6750FF82B81F9C03BA839036CA16C41E0CC0A7DF86DF9C03044726F2CA36C4106A351B78860F9C0DCD2995DDEA36C41017AE3846064F9C0DCB2761D37A46C41AF97C1397B77F9C0	ID
3677	36	CA	Canada	0106000020430D00000100000001030000000100000014000000D8AF351F00346BC1C7A52CE13D6965411979BB4AB0336BC1404FBBE960686541490D07EFD6336BC1676F00BC84666541CA79808233346BC186E1A5EB6D65654177610C13AF346BC1B81C8D32A8646541B7BE5287FA3F6BC1D8088642C35F6541A4E3123D0A406BC1249906A542606541489AD9962D3B6BC1FBE3F7294A7165419DEB8E68D43A6BC1A47ECFFB61726541DC812730323A6BC1969A690CE27265419EC47F0B3B396BC1040701C9A7726541999F815EB4376BC10C0BD39BA771654139A464EEB7336BC18BA6BCED486E6541FBC6998919336BC1C0FEA85CB16D65414FDF0DF99D326BC175F8834C0E6D6541A130C3CA44326BC153AB5844546C65416F833E7F16326BC1A491523D836B65413F968E3826326BC18B61C0A59A6A65411AF2422D21336BC1DEBAA4BE03696541D8AF351F00346BC1C7A52CE13D696541	CA
3679	36	CA	Canada	0106000020430D00000100000001030000000100000013000000974AA8A912786AC11290A9EF9B916741CDBB74E949776AC170D5D02257916741717A72D494756AC12A6EA5185F906741388457281B736AC19A8F8794DD8E6741483BE439BA726AC1478E9858F38D67413E2C0CD526736AC1B127ACEB098D6741DFCEA89DD4736AC146B11640658C67415159F84DA1746AC19109D3D3DB8B674156D75A9DF1756AC1C5CF626FE98B6741184C3C67DD766AC1E416A3F2568C6741D1FC0762207A6AC1836EA7AB618E6741915C407DAE7B6AC1E332D6C0748F674166508645EC7B6AC15E7BABAB88906741F9BE4CFC7F7B6AC13D0A1B597291674105245F04F57A6AC174EEC23C33926741EF27B105287A6AC15737F6EDBC926741C22C108419796AC1EEC4E72BF4926741C2363FA12D786AC1D9CFF5B085926741974AA8A912786AC11290A9EF9B916741	CA
531	124	KR	Kiribati	0106000020430D0000010000000103000000010000000B000000D3F88C653385724128074FDC889BF1C0AD7E9275C0837241CBB10E75CDA5F0C08EE3FA718C8372416B5B8A51917BF0C0DB8CFB9627837241CF5C647E5521F0C03E348A876B8372414666D6E18804F0C05FBF9D2D9283724183F3316B220EF0C0028DD8095A8572411DF980E3763DF1C04E23104D73857241C88571BC8154F1C0D1AFAC20778572419608AA09A880F1C03759EAFA5F857241BC1A87E5B297F1C0D3F88C653385724128074FDC889BF1C0	KI
533	124	KR	Kiribati	0106000020430D00000100000001030000000100000012000000F6C274570B6F7241C61B6A63A893D440F6C274570B6F724139F80AB9426DD440F8B33A2C0A6F72414AA0296AADBBD34025E7D19B056F7241D06D891D5F1BD3404F637A33F46E7241F3BCECF238E8D14010D67AEEDA6E7241BC3D96DC20CCD0406B2F4F6FAC6E724199650286AFA7CE404AA43BC9856E72416C035E00FADACC4061FE72BB6C6E7241271D1D3CB422CC40A2D45245426E724157352E827F6FCC40734007A11B6E72416F38241D270ECE40FD2D27C6136E7241BF4569174641CF40D4B17E2E256E724160C619A545F2D640B11DD205BA6E72417D06C0A1684ED7407047F27BE46E7241BC21DEAF7665D7406E8E23D7FB6E7241B18EF258A401D740F6C274570B6F7241BB0150FB372DD540F6C274570B6F7241C61B6A63A893D440	KI
530	105	ID	Indonesia	0106000020430D0000010000000103000000010000000800000042D07A5BA7BE6B416342BBFF6728E1C07862B54FBBBE6B41185A7C084388E1C04ACE69AB94BE6B41781D44B1DBC1E1C0ECA5D26247BE6B41BEC11BE536D1E1C05FC9CC352CBE6B413BC21967F28FE1C07EF475D933BE6B417C0411097B3BE1C0FC0E756366BE6B4197304DE7650DE1C042D07A5BA7BE6B416342BBFF6728E1C0	ID
541	184	PP	Papua New Guinea	0106000020430D00000100000001030000000100000018000000DE5555906934704164CA1E158BCF15C1E48D1BDD48347041A34A9245B2CB15C1E5C007FF71337041AFD1AACA5BA215C1C79EF7DDAE32704184C1BA7F367415C180206265A43170415B8B38552AF914C1BBBE7BA29A317041FE2741B78DEF14C1BBBE7BA29A31704185AB3EABF0E514C102ADFE38A83170413F181B0EC5DD14C1FA2B58A70C327041AF07D547A5BB14C17167F586293270419B076ACAD6B614C16CB511BD0933704196F36153719B14C11B1D2B904B3370416B6DDB33B79414C11A8D19F07733704193AA823D469314C14EC080BE65347041407F1B8C108C14C1AD7829A78634704138BC22BDE88F14C1951EF2B49F3470410B78AA07AD9514C1EA55F40B25357041D1CF38F4892115C1FD7765B12C3570414E8C2D5FB44215C1FD7765B12C35704177BEA6B13D4E15C1EA55F40B2535704134B9F670DA5715C1463FDA2CCA347041F5AE844FFDB715C1F3D69A9DC03470417979DD0C1FC115C10DEAA03490347041F29BDDBD23CD15C1DE5555906934704164CA1E158BCF15C1	PG
532	170	NR	Nauru	0106000020430D00000100000001030000000100000013000000B763402ABCB8714170A2642FD0D0EDC0285E7DF88BB8714170A2642FD0D0EDC04819383C67B871416E2922269DBDEDC091509B1731B8714190556E202569EDC03298F22E10B87141298CF21347EEECC03298F22E10B8714108CAAE834B8EECC0DAF7EC5227B87141A12B3AC016A4EBC0134D264B61B87141016A90C14BF7EAC0E16FFA617EB871414915B44EE9D0EAC06EBCEEEEC5B87141C0D8B5E9D3A2EAC00E9B428141B971414915B44EE9D0EAC06B53EB6962B97141016A90C14BF7EAC08DDEFE0F89B97141098217BE4A57EBC0A661F30685B97141D2A1963746B7EBC07614D9BD75B9714157C797893A00ECC04F71220B17B9714190556E202569EDC0B51A60E5FFB8714198603039BEA2EDC0688428A2E6B87141367A2C4B24C9EDC0B763402ABCB8714170A2642FD0D0EDC0	NR
3680	36	CA	Canada	0106000020430D0000010000000103000000010000000E000000378EE562390967C1235C650E02C86641F4E98D851D0A67C1E58989BCB4C26641C959D2D9A00A67C12251A9C4D8C166418F766850980B67C199179F4F19C26641EB627B36A10E67C193AF0EF36DC5664125270DF4370F67C1F9F2501823C666412EC8D707A40F67C1D6883716E5C66641BBA4DD34BF0F67C1140887F8DAC766419C793491B70F67C12764D37CDEC86641A10BF51A300F67C17AD347E75FC96641DA46764E7A0A67C1214F8028EEC96641C02615175C0967C189CA413BBAC9664168A6327B1A0967C12764D37CDEC86641378EE562390967C1235C650E02C86641	CA
864	42	CH	China	0106000020430D0000010000000103000000010000001500000024341E993C1B68410397231405B7434160B034C9AF1B6841424177D636B64341525D86EB231C684127971FA7B7B44341DE956764DD1C68410C310F2A44B143418FB79A503D1E6841868FE9F6F9A943414F4125C9861E6841EF55CC88F5A74341D331A0D09D1E68419D4502155BA543414A99701C7B1E68419F4D9A1E7EA24341360C1BE30A1E6841C651BCA90FA14341AFF7ECA2A21D6841FF25551031A1434112D267B50F1D684134A9268E3BA2434160B034C9AF1B6841BFE6CB0387A64341137541F53B1B68419E8A470706A843411E52906BEC18684148CE97D18CB04341E6FC5673B2186841B8A0D54276B143419DE516D88F1868419159A93570B24341B8680BCF8B1868417454649BEFB34341875B3848F41868418B3E0A2590B543412068848E7F196841597DBB9F79B643415D454FF31D1A6841CD8F72940FB7434124341E993C1B68410397231405B74341	CN
865	42	CH	China	0106000020430D0000010000000103000000010000001900000031570D1A031F6841989921AA56BD4341E7BEF5090E1F68417B86DE6813BC434193BB2A49E71E6841DB8E76B308BB4341DDF28D24B11E68410008859D40BA4341BD406C631A1E68419C1DBE3789B943413CC9783E741D6841AD8E5FF024B9434146F873E3AE1C68419C1DBE3789B94341525D86EB231C684101C36457B5BA434184E5D8E01817684112DF5B5EE2C94341759C5920A1166841FA052B4C51CB4341B9B938E02D15684153A6F945DBD043411DBE0550561368410BCBF72986D94341B6DFFA443F13684148947E97B2DA43412EABA9C42F1368416CA5DF4000DC43416700E3BC69136841C612EFD9B7DC434185BD7E0F4A146841F2CC434FE4DD4341BF76963B97146841C03F037748DE434107154FF448156841D3D7D8278BDE43414F9FA972D2176841F2BBC89EA1DD4341336D16362B186841EC4BECB05EDD43418D7C74D770186841AE669B8DC8DC4341FF26E7C7E41868417F7C43B848DB43417F6DD01B901C68417F4C91E92FCB43415B66F150AD1E684135659D5544BF434131570D1A031F6841989921AA56BD4341	CN
866	42	CH	China	0106000020430D000001000000010300000001000000150000001FA1FEA4D6DD68414193F5388D634441561E90EA8CDE6841B1A464C50A5F4441E16B1A12A4DE68417E21843EDD5D4441FBEE0E09A0DE6841D04CD8D05B5C44416F3DA6AD75DE68418EF60E77215344413C90216247DE6841CCB652A347524441DE678A19FADD68412573B4DFF351444190211DB43CDD68412573B4DFF3514441C21B3F1863D96841904C1CB3105344417CC339DF09D56841D579F4D7FD56444151CC2856A5D4684166ACF79EA058444186FDAE158ED4684192315F1BDF59444186FDAE158ED4684137FBF9BB4F5B44410F3D7A27E7D468416AA1DA4D465D444104F88A5F19D5684140E8EF44205E444190B46D4C8DD56841E89595F2905F4441E83450E8CED56841CC7294E2166044412C51D1BEE3DC68418E905E047D6744416A4EBF6329DD6841B84C9D07E666444108744451BCDD684108EA4782586444411FA1FEA4D6DD68414193F5388D634441	CN
897	42	CH	China	0106000020430D0000010000000103000000010000000C0000006738575322F6694188E46B8681054B417B13979D12F669416C97B58BF9064B4147E210DE29F66941051B4A1C17084B417AF3735D6BF66941E3C4876DDB084B4119391C8BA5F66941E3C4876DDB084B41824E8BF17EFA69415A9708A317054B413D8ED2F1C5FD69412BE38D6189014B414CCCD720F4FD6941E09492C07D004B41842111192EFE694199FBB6B3AFF84A412CA12E7DECFD6941823D771CFDF74A415207DD6550F6694159197BCE5AFD4A416738575322F6694188E46B8681054B41	CN
841	241	VM	Vietnam	0106000020430D0000010000000103000000010000000D0000006BDB278666D1664125A84E3A2D1B424189EA6D837ED16641C8A66E9D911B42418E72FFEFE2D1664109DEF2D54F1B42417EB0F84CFAD1664172D92282BB1A42419EDBA1F001D26641AF38DCA4E51942415FDEB34BBCD16641C9AC8A6D32174241E732280C73D166410E3D5CDD96154241BE3B17830ED1664105AFD3435E14424188FF1632DCD0664105AFD3435E1442411C79577AB9D06641E2924F08C11442419D05F44DBDD0664129789A673B1642417F1E069E21D16641D4791EF4371A42416BDB278666D1664125A84E3A2D1B4241	VN
2259	61	EC	Ecuador	0106000020430D00000100000001030000000100000013000000D755CE00B9C360C193CFF78EC5AC0041357E654906C460C1A92EDAA387B20041269C3B6676C460C17403909CBBC50041591F6E54E9C560C1F36915E1C7240141646FD7AD00C660C1CB3AB7F40F360141E153BFD4F8C560C17E484418394A0141A276F46F5AC560C111237672E88101417E1C1E02B8C460C1387D29CBA2B8014145E7074A25C460C10205A31F3DDA01417C4998DA08C160C1C114D4E6E572024127E2EEE5CEC060C1B6752EF8BC7602416C00191A91C060C10071228E035802413E6CCD756AC060C1B8D593E67B1C024118996F2557C060C1827E3939EBE1014118996F2557C060C12CD9DCE4041F0141049E0C9BBFC060C1450B63AFE4D90041DEAA8B0A05C160C1D874DF9F21BC004138BAE9AB4AC160C1C24E69AC35BA0041D755CE00B9C360C193CFF78EC5AC0041	EC
2262	61	EC	Ecuador	0106000020430D0000010000000103000000010000001A00000053C75C30602E63C1F10425CB4318F5C0F627D6715F3363C1861DBF8378CBF4C0AE201F7E183963C108F64B8130C3F2C036354DBE803963C187281632F498F2C0A3C68607ED3963C1B3457FD06D26F1C0020F4190E13963C1B0D1B030CB05F1C0DDB46A223F3963C1E1EA31774C0AF0C0461777A1103963C181BEE88B8786EFC0139444B39D3763C198603039BEA2EDC0B0C3F8BD443763C15A9D0C2E133BEDC04252E2B47F3663C1D2728E179C86ECC043F5BBF4AB3463C1B6D77FA2F5BEEBC067C2BFBAF72D63C1FD393BDF0516EBC0264F72AED62B63C1374AEB77F0E7EAC06DFDC4FF532663C1C7974D35464EEDC006144063F32563C126F11CD441AEEDC049A3EE91B12563C1600994754785EEC0297845EEA92563C1B266C84697DDEEC049A3EE91B12563C11F3C54660F32EFC0643CD7AB402663C1720D486C41BAF1C0D03E95EFA82663C1A9BCDDDE8D72F2C0B1824411FE2663C1F0C825C063A6F2C007E7C58AA22963C17001E39E5C26F4C05C4E6F7FDC2963C1DEAAABD98F39F4C0365BEEEE212A63C19B728773FF46F4C053C75C30602E63C1F10425CB4318F5C0	EC
562	185	PS	Pacific Islands (Palau)	0106000020430D0000010000000103000000010000000D00000027ABAE1EE0126C41116DA40D59E221416C3A5D4D9E126C41BEDC9C8BD4E221419AEECB316C126C41ECD875D5B8E5214109F98C5D49126C41DD13DF5D56E9214149169E4236126C4187C8BE3228EE214149169E4236126C411E02E483BCF22141FA16637AB9126C41B9EA46D959F6214186D345672D136C410C07F0BEC5F121412319EE9467136C41890EA1B65CEF2141465DD0DF76136C4152AA2CA88AEA21412319EE9467136C41ECD875D5B8E5214188EC7E0E35136C41BEDC9C8BD4E2214127ABAE1EE0126C41116DA40D59E22141	PS
564	185	PS	Pacific Islands (Palau)	0106000020430D00000100000001030000000100000014000000A566227C4B7C6C41B83F6BB4C2492741A48645BCF27B6C41858A02477C4A274113B12928777B6C412599AC3B984E2741E88E7BCD217B6C41107135161F5527410981E30E077B6C41BF65F14A3B592741D9EC976AE07A6C41DB74D085A8622741F917410EE87A6C41FFB3424E056E2741BBFA2F29FB7A6C417C63B53A9D72274138152FB32D7B6C41E1D9BBD1837527412CA5A2196F7B6C41414DD7E17277274157C75074C47B6C416F277BC2EE772741C291CB1F537C6C415E0F7BA23D762741363C3E10C77C6C417C63B53A9D722741615EEC6A1C7D6C4193B81A41166C2741406C8429377D6C419B78E538FA672741AE1DE1B24A7D6C41496D5510575D27412141DB852F7D6C41E3E8D21030532741C318443DE27C6C41B5AA0F5B2D4C274107A8F26BA07C6C41858A02477C4A2741A566227C4B7C6C41B83F6BB4C2492741	PS
565	185	PS	Pacific Islands (Palau)	0106000020430D0000010000000103000000010000000E000000E56FD7AA62806C41100D89B25F9E2741D4CDF34721806C4100527CCF4EA02741A739A8A3FA7F6C410F6F2360B1A3274159B3F4BDEE7F6C4160A794CB40A92741CA10C81118826C41E690B09176E52741FAA413B63E826C4100BD800417E92741CAF0A4D170826C4122E4C70CFEEB2741A68C9F46BA826C4122E4C70CFEEB27417AF16909F4826C41AA1723EE92E9274108CE6F360F836C41E690B09176E5274108CE6F360F836C41A4F1FF15DEE027411BC9D2C0A6826C41B645145063BB274157CDAAFE8B826C41C5F0E24B47B72741E56FD7AA62806C41100D89B25F9E2741	PS
566	185	PS	Pacific Islands (Palau)	0106000020430D000001000000010300000001000000110000000FA6D0CA9D886C41D3B76009BA27284102AFCB1350886C41A76B1CDEEF28284172D9AF7FD4876C416C3094680C2D284188D4120A6C876C41591371935E322841F6FEF675F0866C41756D1340873C28416822F148D5866C41FF3F00D8A3402841C66AABD1C9866C4173084B14F645284128AC7BC11E876C41EB265455484B2841676923E615886C4145CBAB873B542841A566118B5B886C4196F793ACEC5528412DD1796EA5886C4196F793ACEC5528415D65C512CC886C41DA921BF1895228415CEC3D305B896C41591371935E322841FEA383A766896C416C3094680C2D2841C9F6FE5B38896C414091F640252A28418DF910B7F2886C41E06F63EF732828410FA6D0CA9D886C41D3B76009BA272841	PS
869	42	CH	China	0106000020430D000001000000010300000001000000180000005FA435E3F3F06841488FB37A09A644412FFF002A27F168416F914EDC37A64441EECC4696DCF1684105E7088B59A6444173645DFB29F26841A202D5DDE3A5444166FF4AF3B4F2684168D428A6A4A44441B465DB9819F36841D5338FC7EFA2444185DC09863CF368417EF54214E3A14441CA76324644F36841A3C3793793A04441BA0D904525F36841D52C27C1219F4441670AC584FEF26841430B7416159E44412B88564E16EE6841EF9E8FC3D2814441F7E40020FCEC6841E9DF465ED37D444175FB3D8C24EB68413C1332EB277A44410F12B9EFC3EA6841686C10C4387A444144063C2F80E86841E06A76F6837C4441F41BAA1561E868413B8B9655907D444120140613FBE968413BA7F86AB8974441661914A994EB684128B11D4912A74441324C6C1DBFEB684117F823081FA844419935F1B91FEC6841918E7E9BE4A944415F6730DF74EC6841F888F9EC16AA4441AFAD9D4432ED684115C2434B06AA4441930A860D8FED6841D2669459B2A944415FA435E3F3F06841488FB37A09A64441	CN
882	42	CH	China	0106000020430D00000100000001030000000100000015000000062B08892F12694118FC4A2AEE474541B3443609C81169411A865EB85149454156807DF48D116941393FD36E1C4A4541426F2647631169413B3C9AC6084B454112B03DD14B1169416A4151DD384C45414B30149B7611694111E0CF226A534541B98C81F5DD12694152BF9CC43362454112380163101369419B6451530F6345414F0A523665136941C2A461ACED624541E85AA89E9B1769413DC6F7DF505D45417BBF3F381B186941D6E740BE1E564541C4011DA52E1869416196C3CBEE544541C4011DA52E18694111E0CF226A534541C11C6578F61569417D28602B9D464541AB36AB9CBC15694185D22D71E34545414F9215C829156941E2775B0A0845454187D15A9DD014694160778451C4444541BEA605111B14694177E167B3A2444541D8491D48BE1369413CF95914F7444541BDDBD1FF1F136941B7C4C157F4454541062B08892F12694118FC4A2AEE474541	CN
884	42	CH	China	0106000020430D0000010000000103000000010000001D000000571881B3596A69416F229BBE43334641946359691F6A69416C224C2FBC3346411874F7B0DD6969418412B2FADC3546413E71A75EAC6869419E3363C7A3404641D5D9CEF0D5696941D7AD2B19EF5B46413DB8D9FBEC696941ED26D022555D4641ED550B74926B694147FE055A42664641FB9FD5A83F6D6941A23F02F0746B46415EE1A598946D69415DB437E6966B46410F188233526E69413B234F731F6B46418CDC461AA36E69414E9DCC0D976A4641FF0ABB7ED16E69417FBFEC1AA86946411801CA5834716941A243BAE3CD584641E336997633726941A950001EAF4E4641664737BEF17169410876D97D594F4641FE5DB2219171694101F069C4BF4F4641BAE3ACA13071694101F069C4BF4F4641384C963CE3706941C79645AA7B4F4641B00151994070694152E72CEC044D4641FEE068211670694100F7764CF44B464131AE10ADEB6F6941EEB3B5A1D24A4641B88C2506C76D6941AFE99631683146417E17C9CDE56D6941E0AFA30A47304641E078BCFDE16D69413D78E978D02E4641C84E2CA9AF6D6941B18B671FF32D4641D22F3D3D6A6D6941D21ADED56A2D4641BE976D72B06C694178690A25372E4641AA346A96FB6A6941CCEB2976DF314641571881B3596A69416F229BBE43334641	CN
885	42	CH	China	0106000020430D00000100000001030000000100000018000000CF61FD06C24F69412883D36951CE4641194D0CBA76526941C639A4AE2AC74641F4598B29BC526941ED72CA557FC6464118B461975E5369414C9501B97EC546414833048D2754694177E31892D3C44641161C02E97B556941B390B5D98FC546415B960769DC556941B390B5D98FC546413B4B3B852D566941CD90771307C54641969EA3481E5A6941E8A46F0723BC4641F743526C865A6941FD649A3D66BA46411EDE6E5A775A69412BCC14F40FB9464148438D34035A694134D93EBEA7B54641BB9124D9D85969415CF2341B96B4464182AD6FDB9A596941211B9C00DAB34641A7A0F06B555969417790572F62B346414E0A1AAD80586941211B9C00DAB346410FF373434B536941FD649A3D66BA4641CA4DD1F1F9526941EB774C06EFBA46415EFCDD28DC51694141A0F3C1F1BE4641626E7B72AD516941C7C3966EE1BF4641DCF2F7545D50694108F59077B3C74641C801C4E7D94F6941261A03050CCC464120A2C9C3C24F694163812C6851CD4641CF61FD06C24F69412883D36951CE4641	CN
888	42	CH	China	0106000020430D000001000000010300000001000000150000005D3FE1C70BB86941F74811A5A5BA484192908AC79BB7694147BFEFB359BC4841C6C1108784B769419C982FA193BD484163FC3E2375B76941585981504CC348411AC5DB47ABB76941DBAD9BA040C44841663E1D1081BB6941291B213133D44841A53B0BB5C6BB69416610F334ADD4484133238B732BBC69416272B7ED9BD44841F1F34789B5BD6941804A6A33EDD348413B1602B621BE694114AE3976A7D34841F7EDA8644BBF69416E872CECA1CF48412E43E25C85BF6941215E3907BFCE4841CE8F42FEFEBD694100B66681C9B74841ECF9E6AD1FBC69413E38E46E06B0484112D7731B47BB6941ECD2B20787AE4841EB83874644BA6941C75ACBC0FBAD4841B7E031182AB969414D4010CFD8AD4841F5F2C86BCDB86941394A276441AE4841A104A75904B869414F6E7D7780B048416E2C853CE5B76941D25B3E5D97B148415D3FE1C70BB86941F74811A5A5BA4841	CN
895	42	CH	China	0106000020430D0000010000000103000000010000002100000096F1F8B3B4E56941CE2A2AD5CEA14A41007428732DE5694165492B0145B24A41C056178E40E569416474D2FEEFB34A417DC7685F82E569412C25D7B2B3B44A41D96BFE3315E66941FA5786A0ACB54A41BFC8E6FC71E6694159B5814CD0B54A4159B2E787C0E969414FDAF61337B44A4133F23A5A1EED694165492B0145B24A41E87E531C10F0694124F4CB3B48AF4A41C41A4E9159F069417299CB5DEFAE4A418FE4A7CAEEF6694162DED84304A24A419FAA708BE1F86941D36810D3E8964A4130A0AF5F04F9694198D74E95CC954A4155730DB017F96941895DB7247B944A4112D9E4EF0FF96941427C0D8BE2924A4185AA32946AF76941CFDC9CA1C7804A41CFE1956F34F76941CC2AA0BFE07F4A41F2459BFAEAF6694178D8C575647F4A41DFB845C17AF66941B6660895AB7F4A414C8AC58A35F6694127FE59DE6E804A41A798D8B745F569414DBC728849854A41299EFC6DBAF46941AB6D01C456884A41973965D43AF469413C89BE30EF894A41DC24BBA5E4F06941A723AF849F8F4A4120BAD44F5AEB69419E8435C2E5944A415AB332FCF5EA6941A585C758F7944A41ECF65BE198EA69419E8435C2E5944A41AE19917CFAE96941969548E8EC934A41F1A83FABB8E96941007AA68729934A4148D3E51FC6E76941DFEDE6BA42924A41B61CA257BCE569417B5DAA579D9E4A416DDAC4EAA8E569417E2F6353DD9F4A4196F1F8B3B4E56941CE2A2AD5CEA14A41	CN
551	124	KR	Kiribati	0106000020430D0000010000000103000000010000000B000000F28941205D5F7241676FA5365AF80241548BCA4D3A5F7241C490514409000341E440C25FE55E7241298A6DC3F51903414BEAFF39CE5E724176EA5DED8F2303413320DAE7BA5E7241A00F2F4BF63103411C56B495A75E72411B08F01D685703418CC0DFC3A35E7241A1AB447A886C0341ABEB8867AB5E724192A1A7F9BB7F03410BE47812445F72411BD387077B2503413A78C4B66A5F72410BF5326CA3090341F28941205D5F7241676FA5365AF80241	KI
561	105	ID	Indonesia	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	ID
549	184	PP	Papua New Guinea	0106000020430D0000010000000103000000010000001F00000010A851E6B5CA6F410203FBB3F6A405C195CD98DCD1C96F413553E437814F05C135A5019484C96F41CD22D612B33205C1B438880028C96F41D4888F3FA71B05C117F3DFD2EDC86F41DD856BEB0C1205C1FA60E151FEC76F41B04D8373910505C1387EF236EBC76F416C4F721AC61805C1FA60E151FEC76F413E46DCBBFB4305C1DA3538AEF6C76F41D7CC75911B5905C1AAA1EC09D0C76F4176E56919836705C14C7955C182C76F414BC12847506C05C1510B164BFBC66F41387790BEE85D05C1FF32E85BC5C66F4123C591644E5405C19912CD3E42C16F419EB187F1B04104C1585C0FB3EABF6F411991C4131CD703C12AC8C30EC4BF6F41E1FE51BFB4C803C1FA33786A9DBF6F41954F58C94CA203C19BEBBDE1A8BF6F41F9C0F1452D8D03C1095DD4EA6DC06F41B6B92BC5FF1803C119C676EB8CC06F41B057126EAD0803C1C4347B9997C16F414CC34918617F02C175151D9173C26F419E359860884B02C16938CE1AC3C46F4190C11FA5EE5902C15CC8418104C56F41ECCD1EACA76002C1510B164BFBC66F41DCBA5FF606B802C1D75C470B90C96F414014432F013103C1027FF565E5C96F41EB5DE9B8ED4A03C13013410A0CCA6F41E292751B545903C1627A12D6E1CD6F41E7ED06E8C84805C182A5BB79E9CD6F41D7CC75911B5905C110A851E6B5CA6F410203FBB3F6A405C1	PG
570	185	PS	Pacific Islands (Palau)	0106000020430D000001000000010300000001000000240000005DD2747A7B906C41F92C6F36F9E22841FDA9DD312E906C41AAC658BF2EE4284132D0E95FCD8F6C41EE4BD78DFDE92841EA94C466F98D6C4158F787A6D02B2941AB18E2DF38916C41238CF38E8DB529419A36B8FCA8916C41BA338BC172C02941C9AAE06028926C411F36DCA590C42941318A36E074936C41ED5ABA6178C7294134834C47D5936C41ED5ABA6178C7294114185D237F946C41E14DF01AAEC8294190F2152D63956C4123C3A3EA11CC29418C6055A3EA956C41BE9966C5B3CF294129A6FDD024966C4116CDC0741FD2294153C8AB2B7A966C4123F04F51A9D8294113AB9A468D966C410B0818BE50E32941D7ADACA147966C4156A8E229B0F629414E4344BEFD956C4196F9B094C3032A411BB6E2B276956C41F7D3015C43132A417D703A853C956C41E13074687F1B2A41BB8D4B6A29956C4135790F4357202A417D703A853C956C415B214E4EF1242A4190F2152D63956C412FB2E66293282A41EE1AAD75B0956C41F2A44B6AC9292A4182D57EB211966C41F2A44B6AC9292A413F46D08353966C410DC54E3CD9272A41C0B24917B0966C414BABAF2809222A4100B037BCF5966C41758F4D9913192A41C5AB5F7E10976C41B8AAC776F5142A41D514027F2F976C41E991C05B070B2A41715AAAAC69976C41B158556F10EB2941715AAAAC69976C41FC0D5DFC32DF2941D514027F2F976C41EEBF2E5B2FB929415EF8F144EA966C41D76988FCD0A529415CCC09FFC3956C41B5AAEE7B5159294127F39AE91C926C41D11CA2B237F228415DD2747A7B906C41F92C6F36F9E22841	PS
3689	36	CA	Canada	0106000020430D000001000000010300000001000000360000008E5975C4FBBB64C1B0E272C0CADE67413031DE7BAEBB64C12A5CF5A659DE6741507CAA5F5DBB64C120C88ADB41DC67417A8864971FBB64C17472F5B2F2D9674199B30D3B27BB64C11D93DB33A3D767413AF2CBCFC1BB64C1A1B4660C62D567413F7A5D3C26BC64C17B01EAB749D467413EE1B2190EBD64C156F6592909D2674157D7C1F370BF64C1DA405FAAF0CC67417689E3B407C064C13259224FD8CB674103C30FA2F6C164C190D8528CB8C867412FFBB3A331C564C1478FFD17D7C46741D49B62748FD564C105DAF9712EB367418B5AD07BB1D664C12D7A1A8D34B26741701E0E22F6D764C16479B883A9B1674182161B3729E464C15138A7FDAAAC67412AB0F05FD7E864C12ED87DD726AB674104ADC2C10EF964C1951739D97DA66741041A7229BE0065C11213D25A07A567411868CC56150365C18B5E3C84DDA46741A009CD3ED40A65C1348099F5A6A667415087DB76D20C65C15BD20B245CA76741BB1FEE67EE1865C12DE0028669B0674161E63D69ED1965C15895578355B16741CCB47A32861C65C112FD83AFBDB567413A46B47BF21C65C127330158C6B66741B21163FBE21C65C1FA128955CEB76741CCB47A32861C65C1337EEAC1F2B86741C72CE9C5211C65C160983CA98CB967414B5230BC3D1B65C1EF1244C25DBA6741ED9297AE851465C1825C1A5B9DBE674163123924561165C12BDBBC5A45BF6741184E03A1350A65C148A107329EC16741A3E82AE1440665C1C90B0ABD06C767414D2783A7CC0165C1E53F883DBFCA67418CB7C1E462FA64C14960CF6095CE674118989CA4CAF264C1FB3F508736D1674170FEC67B1CEE64C1FB3F508736D16741DA23D07AC1EB64C10884B0F160D1674174DD241E8DE964C1ADFC7FEDC2D16741DE2C807AEDE564C1B244A589AED3674134FAFF2E27E264C1FA542C6F5FD66741EFA1FAF5CDDD64C11933C7679ED967419BD3FB23ACDC64C1DC31996B8DDA6741933C602D54DB64C10687D5437DDB67411D26BDF218D864C173BBA5BC4DDD674155EE2343FCD064C10B47ACB8F2DF6741F988897A82CE64C1BF31CB9DA9E067412F05E3C045C464C1D862BF3CA6E267412627152DADC164C1A5BE368B7BE26741A4FD0B1987C064C1F39970ED42E267410A91548EB3BE64C1A15C29F18BE167415E022DA001BE64C16CA086D30CE167418E5975C4FBBB64C1B0E272C0CADE6741	CA
896	42	CH	China	0106000020430D000001000000010300000001000000170000009429DAA80CEC69415635B0606ADC4A419144240027EC69416A70782DE6DC4A41389AEF062AED6941A3BFB6A5C0DF4A4151A45C1BB5ED6941354A79A6EFE04A4184A4D809A3F06941C68E11A6E7E44A4102F818F6F7F069416EA97EB640E54A41B2954A6E9DF269411A1148233AE64A41E7A6ADEDDEF26941E0E801D004E64A41CB9FB78228F36941E6B5E85B52E54A41A2BE9A1C57F36941602C900A47E44A416C4DCEDC1FF469417A6C90A9FCDE4A41202784B709F3694124046B0E5BCE4A410C41CADBCFF26941A8B4D17073CD4A414404112531F269416AC688F99DCC4A41D2EA456F60F169410B2D1F9408CD4A41C444A0EE14EF69417D68A7BEADCF4A411E5E2DAD6EEE694131C78A4ADCD04A412A517046B2EC694188D0F0E708D54A41580F0E4894EB69417A0D9A39F5D74A41C2711AC765EB69412545496800D94A41AD6B3DAB84EB694116A1398576DA4A41C8244905BBEB694169745C1770DB4A419429DAA80CEC69415635B0606ADC4A41	CN
845	42	CH	China	0106000020430D00000100000001030000000100000025000000CECD982BD673674107C9B4550A2F42418292A7DBB4756741EB6C7BAD1C334241D595729CDB756741A96022FD6E334241BBA47054B87667413878EE13873442414EFE8D5CEE766741211B3F1CA834424124F2D3242C776741580BAD9F97344241A1AC69EE687867415940192515324241410B4BC3AA7867415EEB34A62E314241EEE75CC2DC786741B033EDE426304241F38F116FE8786741862097AF712F42412D056EA7C9786741C49EF7346D2A4241E96A45E7C178674122C6D291C8294241B6E712F94E7767414075524B1E1B4241961FFD1425766741655123BB84174241F06327A56F75674122933C67F41B42410BFCC44AC9746741C878FDBCE91E424169390542747467412D8D82EC53204241A8AF7AC92A746741DAFBC04A192142412CEBB5E2D9736741969EA3A5AD214241076642A346736741A892B377312242410ED1F3CF25716741F285D88BE6224241CD87F820C06D6741A9ABE6BC832242410776DC3B126D6741879507A28C214241C8821DB4E06B674197494A25241E4241F327820EBB6A6741B19F644F601B42415602FD20286A67414A730F84DC1A42418B684FCF1569674196404836AB1A424129277FDFC0686741A476574D3F1B424195A2C4059A68674188DFA533781C424190FA0F598E686741BB318E22031E42410D6E73858A6867410F0D9F50042742417CF57DB1E269674132CFBED2172E42418F775959096A67418BD946AA7A2E4241C277D547F76C6741130872B53D334241F4D0B5D8AE6F674153EE1F40453442419461209CD37167416B98C608F72D4241CECD982BD673674107C9B4550A2F4241	CN
849	42	CH	China	0106000020430D0000010000000103000000010000002500000013F08601F577674105D5F274C14F42415AC1131DBF7B6741B0DB5BEE66504241D1133BBA3E7C6741448C030DA14F424182342332697C67412CB3DAAB4E4F424188DCD7DE747C674154B425CC884E424182342332697C6741140E4C6DD34D4241FD46D0A5E77967415C7C8DF8A23C424155DC5BF086796741B7F241BA723A4241707F73272A796741D565C8C018394241410B4BC3AA786741C267380253384241D479117A3E786741754BBA3532384241C53B0C4B107867415FFE6F8E6338424194DE699C4E736741023D9CB611454241DE15CD7718736741C4823A67F8454241F27F88C70C736741ACC6223ABE464241E83A99FF3E7367418AA66981EC4C424164357549CA736741B0DB5BEE66504241BDAB28C8F7746741CE683279555242417474C5EC2D75674183D177F965524241A7214A385C75674137D07B693452424134DE2C25D07567413C2367233D514241A16F666E3C766741BFB08AFD03504241A8171B1B487667412CB3DAAB4E4F4241BBF25A653876674154B425CC884E4241DB3D2749E7756741AA830FCE044E42414E81445C73756741AA830FCE044E4241DB6779A6A274674154B425CC884E42412A47912E78746741DD286DEB464E42419951525A55746741A468EA7BF44D42414A925D122774674187204030BB4C42416ABD06B62E7467415F568C62164C4241F7990CE349746741BE260F15824B42412A47912E787467417804A887504B42410F0BCFD4BC75674179CB66F4C34B42415EE0B73F7E76674156EEB3C1684C42416E293700F67667418AD1EA6F4F4D424113F08601F577674105D5F274C14F4241	CN
855	42	CH	China	0106000020430D0000010000000103000000010000000E000000FD5DED2DD6FF66412BA2C7DED2B942411FA5F977CDFF66414C20794341BC4241E6CBBE0BD9FF66410DC054C907BD42414891906FE8FF6641692A4BB3BDBD4241BCBF04D4160067416383F6F1D6BE4241ABD2605F3D0067411777B9363ABF4241C1E3B70C68006741C27CF17FE7BE42414818098D77006741DA7544E541BE42414818098D77006741BD9B51E993BC4241D64D735C5C006741E662BBFD2FBA4241B17A150C49006741F7C40DA68AB94241629083F229006741323A67D816B94241F0F08A93FFFF66410507250238B94241FD5DED2DD6FF66412BA2C7DED2B94241	CN
856	42	CH	China	0106000020430D000001000000010300000001000000160000004E416D95EBF26741E3AF31F3F0A64241D37CA8AE9AF2674127156D5001A742418EECAE0BA7F1674172A4FAF753A7424189C8FBD255F16741D483F30D75A7424127234DAFEDF06741A5837AEA01A94241C444107F76EF6741B2A2961FDAAF4241183D61AE53EF67418547F0B3E2B042410A8D8C10F4ED6741F1C60433F0BF424192C1DD9003EE6741A1135C1F5CC14241F4F87E6344EF6741BCD78AD2A0C74241DA55672CA1EF6741762A1F2170C942416EA1E227F8F16741E18AF3CBF9D34241B246857949F267412BB180FF3BD44241A230DA1BEAF467417880E19076D54241249D53AF46F567417880E19076D542413C19903203F7674196AE2317A7D342413C19903203F767417AFD8D572AD24241EEBD791EE8F667417EE537CEEFD042418137BA66C5F66741DCC69307E7CF42410E09460297F66741DA7B6035FFCE4241B7356CC395F367419182F3EE58B942414E416D95EBF26741E3AF31F3F0A64241	CN
858	42	CH	China	0106000020430D0000010000000103000000010000000E000000FA07549615126841F87BAC796C094341301180842F0F684161335B9BDB0C4341F21392DFE90E68414777CA1E600D43416ADF405FDA0E68411C0BDBA6AB0E4341301180842F0F68412C7A34DEAD104341748156E77B10684163D6CA9784184341FAE730566E12684195D5C2FE4F1D4341B6588227B0126841B4BB77D0D41D4341EFADBB1FEA126841E0E86C42711D4341F4E7627BCE136841974C3B85121A4341B446502227146841722D73946A1743414C7DEEC56D136841FDA7705A4A104341DBD27BD5F91268413EAA0732250C4341FA07549615126841F87BAC796C094341	CN
583	189	RM	Marshall Islands	0106000020430D00000100000001030000000100000008000000604E9BA0EB3B72412B44AE15668B2441030F7A9A3B3B72416FC956BFE18B244126E36D851E3B72412E1F409E4B8E2441B6784257223B7241B2F4DD969A9324415677B929453B72417007D1AF539B24410DD067EE4E3B72412FF6D1A1889C2441922BC789CE3B72418C3D2B0FC78E2441604E9BA0EB3B72412B44AE15668B2441	MH
595	189	RM	Marshall Islands	0106000020430D00000100000001030000000100000009000000C5174487E00F72412BDF32A1F05430413C2A2462E80F7241C4199AEC9D57304153F449B4FB0F7241F5867A4D525930410C76B57D1A107241B55913C16A5A304121F7FA8A71107241E82FEE7FE75A3041013C404796107241960F687E2C5A3041EA711AF58210724149589839785830414A73A32260107241C4199AEC9D573041C5174487E00F72412BDF32A1F0543041	MH
596	189	RM	Marshall Islands	0106000020430D0000010000000103000000010000000A000000502BF3A9600B724152E987C96FB331419F0A0B32360B7241CFCE16D7ECB33141D1E7361B190B724100A3E93F25B53141B5056EBCCD0A7241C5D76FDB89B931416356FDD1AC0A7241C634ED0FBCBB31414943F73ADD0A72414F9045AF9CBB3141E209A8C0200B72410FC798E5A8B93141B12C7CD73D0B7241DEE0E29670B83141F2E238216C0B7241984CD04944B53141502BF3A9600B724152E987C96FB33141	MH
597	189	RM	Marshall Islands	0106000020430D0000010000000103000000010000000B00000057E56DFC63B771411C768AC74FEC3241984B5F260DB77141EB2649B20BED3241AB76694E59B67141251FA1BB97F03241DB171093CEB77141A1FFC11552F7324109AC5B37F5B77141A1FFC11552F732415C149BC6FEB77141E09E39B9DFF4324138D0B87BEFB771417B659781CBF232417CCF550ADAB771414C1E5AA3F5F03241FAD2CAD6A9B77141C2C4CE2D06EE3241DD60F0D78AB771411A76E921CDEC324157E56DFC63B771411C768AC74FEC3241	MH
598	189	RM	Marshall Islands	0106000020430D00000100000001030000000100000007000000DDE4A8D17008724127FC2C77B9123341DD74BA71440872413EBD99A136133341FD9F63154C0872419F2C60BAE715334185D4B4955B0872415D4FEFAF5F173341AE303AEDA2087241FEC9CD24A91533417DE31FA4930872416148CDAC94133341DDE4A8D17008724127FC2C77B9123341	MH
601	105	ID	Indonesia	0106000020430D000001000000010300000001000000160000004E0A4473681166410F58EA278900F940A69FCFBD071166410F58EA278900F940D12F8B6984106641A494C5716A1BF9406BE9DF0C500E66411BDDDFC840AFF9409992D45FD40D66417FF6BE10E4CFF940A0C8B99DAE0C664138E9C51F202AFA4019B48B5D460C66413BF040FB5E54FA40FF251DD5000C6641644EA5DBCD91FA408CF7A870D20B6641C9B2E252D8D8FA408CF7A870D20B66418268E339D908FB40C0080CF0130C6641EB057CFF4946FB401DCDC4044E0C664115F377CF7B59FB405686DC309B0C66413BBA5C9A1563FB40455EFFCDB2106641BCF3D30F4916FB404449561F551166418268E339D908FB401E56D58E9A116641B14C7CB67BF9FA40779347ABA5126641731736E2B933FA40532F4220EF1266418D9607420CCCF9406398E4200E1366418EE23C086A7BF9400F951960E71266419D9E8CD09C5EF940A68A260FAA1166414AAD1CEAF80DF9404E0A4473681166410F58EA278900F940	ID
602	105	ID	Indonesia	0106000020430D0000010000000103000000010000000E0000008AA5D5A953436641D6FE4092A929FA40E1EFA0E25A43664102ED346BC41AFA40CE6DC53A344366414028550EE3FFF940272EEE56C4426641C9C4BDD07DD9F94027439705224266418D9607420CCCF940A5AB80A0D4416641F4EB80DFBBD3F940CF658EA90C406641FF7CADC87C89FB408BA0C8171440664115CE503D20AAFB403268638D48426641FF7CADC87C89FB40F2F1ED0592426641A8DBAFFCE27FFB40025B9006B1426641213A96A2535DFB40E1EFA0E25A4366410081B9BD9067FA40271945A8664366415F4FE9A4533DFA408AA5D5A953436641D6FE4092A929FA40	ID
606	105	ID	Indonesia	0106000020430D0000010000000103000000010000001E000000AAC911D842F66541CBFB4C4883ADFB405BCAD60FC6F66541C9B2E252D8D8FA4056B19D68BEF6654180EB62F234B8FA409B404C977CF66541FD289237D9A8FA40E5307DD505F565418EC67B6601A5FA401FFF3DB0B0F46541FD289237D9A8FA40051ED884ABF16541BCF3D30F4916FB40F6DFD2557DF16541716CAAAF522DFB405B5E721C4CF0654135916061CDE1FB40BA9BB213F7EF6541598D817EA415FC40F36973EEA1EF654131F1E4BF7C79FC40AE40CF2896EF654159389C20BAA3FC40AE40CF2896EF654151766FAF1FCAFC40B076E68BD0EF6541AAA7348D540DFD40A9B9883067F06541EC32AAA3B0ACFD405F620215F6F06541EA80D45FBB23FE40551D134D28F165411DA99BFCC63AFE4001059FDDA3F16541692B0AA6565DFE40A24ED70388F26541DE323C88227AFE4020A217F0DCF265415F8A0065FA7DFE400A43D63132F36541DE323C88227AFE40696B6D7A7FF365410191886A8A70FE40E141968BB9F36541692B0AA6565DFE40EB0284DFCCF365413FE8B020EF36FE405365905E9EF365417B21EAECE3EFFD40696B6D7A7FF36541E1715CB2409FFD400B2E2D83D4F36541AAA7348D540DFD401BA249153DF46541266829931683FC40C1D6A66763F465416D79361A4966FC40AAC911D842F66541CBFB4C4883ADFB40	ID
3711	36	CA	Canada	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	CA
610	105	ID	Indonesia	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	ID
3713	36	CA	Canada	0106000020430D00000100000001030000000100000017000000112A7CAFF6B169C190826C57D71C6A4111AD32AF7BB069C1FC00653DA11D6A413089A6CDCDAF69C1ABD11192C21D6A41BF0F3EAE54AC69C18D2B11E97F1D6A41621C73540CAB69C1B86FA470711C6A41244A2281B7AA69C1C6582ABE731B6A4179A651E4A7AA69C1D60FB72D121A6A410A9C90B8CAAA69C1C82265D570176A4168AF7E52BAAB69C174D6E02F53166A41CECA8CDDFDAD69C1D3A098A1E0146A41BDDE33DD59AF69C1233DF3279E146A412C8B705FEBB569C1E8ABA21424156A41208DB3345EB769C17DCA1AE256156A4115B064BEADB969C1EB9EEFF630166A41E90A0064D3BA69C166F991AC1C176A411F4700B505BB69C18158977308186A416C26183DDBBA69C18590AFF74B186A417D12713D7FB969C1EE8A7F28A0186A41595145F2F4B769C1A2E89AD8F7176A4103945FD686B569C19611400293176A419BB409573AB469C17EB62D1E19186A41031716D60BB469C12A0FA0A25C186A41112A7CAFF6B169C190826C57D71C6A41	CA
3722	36	CA	Canada	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	CA
859	42	CH	China	0106000020430D0000010000000103000000010000001A0000003034CF4711116841CE101A1CF1284341F20963C2D50F6841E0E86C42711D4341BDCD6271A30F68410DF54027AA1C4341B316A43AA40E6841A011939D9E19434137274282620E68416DB7592709194341709C9EBA430E684137A7BB8DF8184341B5BAC8EE050E684137A7BB8DF81843411711428DB80D6841042347185C19434166F059158E0D6841767120A3BF19434176D283F81D0D68413F11758E2C1B434113023803C50C68413D516E3A781C43413E9D6D408B0C68414B9FAE8ECD1E4341DAD79BDC7B0C6841276705C0222143419BBA8AF78E0C6841D3F1EB7F6723434108414AAFB10C6841C1C4F73892244341EE9D32780E0D6841FF0EBE3C522643416F87F50BE60E68410FE0C7C1812B4341CD215CC364106841E079C70E2A2E434144748360E4106841ED3E533AD02E43415E02F2E829116841ED3E533AD02E43413EB725057B116841394B800D7D2E434114AB6BCDB8116841AFEBE8BBE72D434178703D31C8116841D25DEE86202D434173C88884BC1168416FBCC948382C43415EE2CEA88211684100BDC6E1FC2A43413034CF4711116841CE101A1CF1284341	CN
861	42	CH	China	0106000020430D000001000000010300000001000000150000003A8DBD00BB3F6841EA592F6B884C4341D3B8E3960A4168419F153E5BE34843414C8F0CA844416841051A909B2C4843413B8245F3C34168418CD3F51373454341E889F4C3E641684122EB3F5B69444341D8C7ED20FE416841F716E0193E434341F7F296C4054268413304FDC48C3A4341C85E4B20DF416841C91A2E23833943410CEEF94E9D41684161BAE5D3ED384341EFF4A5F0C53F68412E5AEEA6E23C4341401A71F8F33B68410AF12B73B54543419E4C375E553B6841E0CDFB5B0B4843410C57F889323B684164F11D6D04494341CD00A642233B6841AA9C64CE504A4341D82572CA493B68410A3810436B4B43416A7F8FD27F3B68413BB521F8214C434111862554CD3B684160ABE4AA854C4341B86C9895733C68419EAE0730E94C4341C1D9E12E103F6841310DAAEB244E4341CCA549146D3F684118160488E24D43413A8DBD00BB3F6841EA592F6B884C4341	CN
862	42	CH	China	0106000020430D000001000000010300000001000000160000000FBDCE49323768411B369E1FD756434110769CACF13568411FFB07C1B65143413A050DE438346841F18CAC4A3D484341A90FCE0F163468419F6B1EDD224743410C71C13F123468415E37E2243B414341D4D455AA9732684132508D54F33C43417215F145922F68413B9BD270053843414FE6B7A9E02E6841782297DBC2374341026347C4F62B68412DE6F02B3E37434115D25848722B6841AE1BCEBD48384341FE5EB7CB4C2B6841707B5C1562394341CEBFF195DC2A6841AADECC6B673D434161B5306AFF2A684158ADCB1342404341134571A7862B68419CBB49CC1C4343417E472FEBEE2B6841A55D9068BC44434101A04A44232E6841268AAD45BE4B4341A2FE2B19652E6841191282BA534C4341FB898846F02E6841421C68E34C4D43416DFA0E41DD36684137C9EADF80594341E5D03752173768414329852E7059434192D8E6223A376841D638EEFC765843410FBDCE49323768411B369E1FD7564341	CN
863	42	CH	China	0106000020430D0000010000000103000000010000000D000000BC9181496545684158098A488A5E4341E64341448E4568413E2776F41C5E43418DA33B68A5456841AB3751B3F15C43418DA33B68A5456841699C1E0A845B434168D0DD179245684105A7C155165A4341307BA41F5845684136D9728C5F5943414FC670030745684137C9EADF80594341F19DD9BAB94468410CCF663FF55943413FEE753D8B446841D5416B2FCD5A4341B7B924BD7B446841B5359FBF195C43419C3630C67F44684165083658915E434144962AEA9644684182C3480AFF5F4341BC9181496545684158098A488A5E4341	CN
624	105	ID	Indonesia	0106000020430D0000010000000103000000010000002600000009C4FA4E813C6B413D9ED7341D3C0B41FF85C3FAF23A6B4105A391459F340C41CFF17756CC3A6B41DBE27075155A0C41289CAC4FC9396B41E0A3FC965E520E4186C44398163A6B414D2CC3EFD1220F41615AD10D563D6B411CBBC4F781521041AFA03E73133E6B415330EBA90D7610416C31B5084F406B41CF2D6B2828C91041E3531D4909456B4160B6F1E9AD5B1141ADCDA75A74466B41BF5ED1FF0F7711418611BD4ADC4B6B4197D91120EEC31141E2395493294C6B4165A7292255C61141447B24837E4C6B418BAB394EE4C4114102EC7554C04C6B419BE8808F87C11141F262B013FA4C6B41BAAB348CB9BC11412CE895F3B6526B41B3900CEC25BD104117ED32691F536B412F94BDA58F9A1041D8CF218432536B412CD1D1DD6C851041D8CF218432536B41064BA2C7E26D10417535EDF113536B41EB5734B7B34D10412D3A0E798E506B41C3655DF7ADC40E41D111773041506B418E46E740D98F0E41BAEA2B60834F6B41C9039DC3B1190E41BB0A4FA02A4F6B41689DA328B4E80D41361282825F4C6B41118F5E5AF6A50C416C51C5D3B3496B41E86EF04156DA0B41A177D10153496B4100D6F1B952C20B41CD12073F19496B412F5517AFAEB90B4105ABB0B689486B411B856A5632AD0B41AB54207803476B418A14A41511980B417F193976A6466B418A14A41511980B411FF1A12D59466B415C723F94DE9C0B41C0CFF47DAB456B4124812113ACA10B410751CDF6D7436B41FE8E995797A30B417BED4EAC2D436B41147F1AECBF9F0B419C583ED083426B41A8BD546DF29A0B41BD501311733F6B41422E61E7B96F0B4109C4FA4E813C6B413D9ED7341D3C0B41	ID
3727	36	CA	Canada	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	CA
3728	36	CA	Canada	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	CA
3729	36	CA	Canada	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	CA
639	105	ID	Indonesia	0106000020430D0000010000000103000000010000000D0000005909B4685F036941F9642476555E1941E3A933AFE30369415CF2F2BD455D194121A7215429046941B81AD9D06C591941E7D860797E046941D7E85260704C1941C30503296B046941DD2AE9DF4C431941FCD3C3031604694143DAEEA4DB411941709068F912036941D9E90E8EB44519411268D1B0C5026941BD7C753C1C4819415C9F348C8F026941D7E85260704C1941079C69CB68026941E7526A6EA75319415C9F348C8F026941A973CA7EDE5A19411710865DD1026941593A10323C5E19415909B4685F036941F9642476555E1941	ID
640	105	ID	Indonesia	0106000020430D00000100000001030000000100000016000000E7B330A7970169413672665811221A41079C69CB68026941D9FF3417FA151A41BAD245662603694132C62CB5F3091A4161AF898AB8046941C3C0B1CFC2E81941A742C8B120056941A8E0FECA2DDE19410F2C4D4E8105694174D2A41527D2194120044814FD056941E6D87D696EBE194120044814FD056941F158AC3668B21941F5883517DE05694164A779043BAA1941BD33FC1EA405694143751B936BA519413FE0BB324F056941FBB7E351FAA31941505016A7AD0369413B37620A31AB19415065BF550B0369411F0364050AAF19411268D1B0C5026941F158AC3668B219410FF27149EA006941019B561700D6194181358F5C760069411888F50F9FDF194128BFDBDD48FF68411521E5DB61181A41D7C68AAE6BFF6841A635D8A0C91A1A410F071BF847006941C697D88AF6221A416C2FB24095006941E577F2505E251A4177FB1926F2006941E577F2505E251A41E7B330A7970169413672665811221A41	ID
641	105	ID	Indonesia	0106000020430D0000010000000103000000010000002E000000890C3BF7B5F1664100EBD9020C041A41BB41815056F1664148C8508434101A41294C427C33F1664118DCC121F0161A41D77D43AA11F06641893D04D0215E1A417F8B919F9EEE66416AAC688EDDBD1A4175DF4CFAE8ED664113BFECB6712E1B41C18C0F3D8EEF66416ADB1929D7701B416D10BD99F6EF6641D76CB3F26C7B1B410BBA43FB43F06641894CCE50D57D1B41C1E935FD61F16641894CCE50D57D1B411F12CD45AFF16641826E26CC3C801B41D5DA696AE5F16641DFC2B3A60C851B413DC4EE0646F266412157E89598901B413E6D22D139F76641CD14DD035A301C41EF1FFDF73CF8664179F868A5C5581C415B60093007FC66410E93099D613C1C41CA7544ED2DFC664164C1A51B01061C415A40E6EF5FFC6641FB7F2CAC2BE81B416F311A5DE3FC66416F62FC57D3BD1B4112F4D96538FD6641FD9F127AD5B01B417B9B3B7BEA016741E4083239161E1B4102B069BB5202674107E6459E80131B411CD0CAF27003674144EDF85672FB1A41BA795154BE036741F2FB0A6B7EED1A41CF5F0B30F803674119C9A2DCA7DC1A41C83ECFA07B046741340DD9218C2D1A41603527C473046741C697D88AF6221A41BE928AFBC50367410F557A4E5ED919414B64169797036741C0DEA71B92C719418532D771420367411F0364050AAF194153527EC3FBFF6641FC6389E283E51841B18FBEBAA6FF6641D9AB74B387D8184154CB05A66CFF664173B4AADFB8D31841F6A26E5D1FFF6641B7BB693D51D11841EF1FFDF73CF86641ECD99F1330A2184124AAE759EFF76641ECD99F1330A21841FC8A7CFFBBF4664173B4AADFB8D3184180D0E6357FF366414B735BC0F1F31841D437902AB9F36641B5A8DFA44B04194103CCDBCEDFF366416C58449C820B1941D80654345EF56641BD7C753C1C481941D0423E65B5F766410B9A9E423B8419414904BEC791F86641ABC208F76E9819411FAA197F4FF96641FBB7E351FAA319414ED6C4D158F76641BABDA4D003C91941890C3BF7B5F1664100EBD9020C041A41	ID
381	105	ID	Indonesia	0106000020430D0000010000000103000000010000000F000000A671424D63F86B4163937D4979B71FC145433C81B9F86B413F33A9F434BD1FC1A6840C710EF96B418F58C3F935CA1FC1003B06708AF96B418F1B0D80FEE91FC10FA4A870A9F96B415AC1E2A438FE1FC1A1F24BE795F96B414A5FDA4AED0320C1B6EDAE712DF96B41B8E4A63D061520C158C51729E0F86B41AA4533533F1C20C117AFF0DC92F86B41116ED5E2351D20C1E71AA5386CF86B41B2CFF908D71920C1975BB0F03DF86B410938A418EE1020C16E5925D68FF76B412237409DFCC21FC16940EC2E88F76B41B69E0E8164B81FC13FA5B6F1C1F76B4167A71C9D93B31FC1A671424D63F86B4163937D4979B71FC1	ID
385	105	ID	Indonesia	0106000020430D000001000000010300000001000000150000005C9809B0204F6C41C34C59FF65BF1BC15620FDE2F24F6C41719A6073E5C81BC1F265A5102D506C41021A26EDB4CD1BC1CFF448EDCC536C41A108C17152241CC1343619DD21546C41B112104ED5301CC1CBF5C70AB5586C413B4EB14FB0741CC1E88EB02444596C41A02A9789767A1CC1355C96A7905A6C416790848D448C1CC1001667394A5B6C4170FF63F642991CC12D6A6C5D225C6C419606912579AD1CC1FA43602F835C6C413C09909E06B91CC1171D914DB35E6C41962C59813F0D1DC1A9AB7A44EE5D6C4127227938E1091DC1DF1DA56D9D546C417533134316841CC18514B2470F4F6C41ECFCACB9DE2F1CC1568066A3E84E6C410F7A5828A7281CC15BF203EDB94E6C41B15A647BD9161CC1F8B033FD644E6C4138476D0BABCE1BC137CE44E2514E6C4194D2D39A7FB91BC197F6DB2A9F4E6C4195D3DA3517B71BC15C9809B0204F6C41C34C59FF65BF1BC1	ID
386	105	ID	Indonesia	0106000020430D0000010000000103000000010000000F0000008805FAF5A9E06B418770B8C643841BC16315A5E829E36B41A29BB0711CD01BC1C25D5F711EE36B416D5B2253EAE11BC1E8D396015EE16B41461FABF310DE1BC10D389C8C14E16B411AE6FBFBA8DB1BC1AA16EFDC66E06B41021A26EDB4CD1BC17FF4408211E06B4116345205B7C01BC1F3375E959DDF6B410DBD63318BAB1BC11ED393D263DF6B4112B5DA0BB49A1BC1FEA7EA2E5CDF6B41B991D08B16841BC12E3C36D382DF6B419445C30A5A7D1BC103A10096BCDF6B41BB057EA38A781BC1DF3CFB0A06E06B41BB057EA38A781BC11C3AE9AF4BE06B416C5DBC1BE97B1BC18805FAF5A9E06B418770B8C643841BC1	ID
647	34	BX	Brunei	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	BN
388	105	ID	Indonesia	0106000020430D00000100000001030000000100000010000000FF8D34EEBEDC6B41794F6933F0EE1AC13E32BEF03ADD6B4152A5A4DE1DF71AC1CBEEA0DDAEDD6B41F3769156BD001BC1F982EC81D5DD6B41B4955AF3F4071BC1BE7E1444F0DD6B41DF5327A822101BC1BE7E1444F0DD6B41905AD40C2A1C1BC1F982EC81D5DD6B41CB6CF8D37D531BC1E9194A81B6DD6B4136FB23EB265C1BC12DA9F8AF74DD6B41C0E24BA44D581BC1AB3C7F1C18DD6B41C7BEF8D3C14C1BC191C3B94230DC6B41D6E5FAE6EF211BC1931C1EE5F9DB6B4170AADC7294111BC12F82E952DBDB6B416684111058F11AC1F164D86DEEDB6B41D1480F9FB8E71AC152A6A85D43DC6B415DBD4C8BC2E61AC1FF8D34EEBEDC6B41794F6933F0EE1AC1	ID
389	105	ID	Indonesia	0106000020430D000001000000010300000001000000160000006A1A82D95BE76B419102B5B503C81AC18A18AF20C0E86B41BDD3787B594A1BC1F8C90BAAD3E86B41BF78D75E855F1BC1F8C90BAAD3E86B41D5850E7F8C6B1BC1E86069A9B4E86B41CF1BC783B8801BC1EDD206F385E86B411FC6E9EA7E861BC18EAA6FAA38E86B4150F53F67E6881BC1F762B6CCEBE76B4150F53F67E6881BC1EE3270B37BE76B4173560023477F1BC122D203C48BE66B413613B9D6EC611BC1A57EC3D736E66B41AE1243A3EF541BC16681D532F1E56B41D1C6D51F8A451BC12A1D92B0C3E46B414959474431F51AC18CD7E98289E46B41606DD4AF5AE41AC1CF0D340F7EE46B41B9DE13F2BDCD1AC1AB890B4420E56B4189BCD818C1C01AC1A6F74ABAA7E56B411AFD186404BA1AC17058B7A997E66B4119AA6D64C3B31AC1EEABF795ECE66B415F69EC2835B51AC1AB1C49672EE76B41E27EC81093B81AC1BE9E240F55E76B41320D5395CABF1AC16A1A82D95BE76B419102B5B503C81AC1	ID
390	105	ID	Indonesia	0106000020430D0000010000000103000000010000000E000000E2908C7D347B6C41ECE368369F7F1AC122DA85A8477C6C41C56F664003941AC11F880D23707E6C414959474431F51AC1B3AFA13CC37C6C416684111058F11AC11DB587FBC07A6C419DA7CC7494DE1AC121474885397A6C41544A73575DD71AC149A461F3FD776C41B9C2F1EC37A81AC11E82B398A8776C4127E3D277BF9A1AC159868BD68D776C4167101E7E91921AC11B697AF1A0776C412906D8A8F2881AC123203928A0786C41D38EF3F7087A1AC1250016E8F8786C4147BAE3A897781AC11843EAB1EF7A6C41D38EF3F7087A1AC1E2908C7D347B6C41ECE368369F7F1AC1	ID
415	105	ID	Indonesia	0106000020430D0000010000000103000000010000001800000092C1736057BC6641B5B30184BFA813C12AD8EEC3F6BB6641B5B30184BFA813C1A840D85EA9BB6641A2C7B0CD58A613C1ECCF868D67BB66411DDE1969FBA213C1D7E9CCB12DBB6641EA3ADB1A2D9E13C13F4CD930FFBA6641A99BA9E3ED9713C1070C49E722BA6641210F5386336C13C19E9EC2D607BA664109CD59AC045813C1C37120271BBA66413A63569A684E13C18262007D4CBB6641356AFAE1B41513C193D61C0FB5BB6641EDC5F8AC220B13C12AD8EEC3F6BB66416636CE742C0A13C106DB3E1628BD66413DA2B073542B13C1C544A64ECABD6641B0D11FBE823F13C11948710FF1BD6641BF33BEFF3C4613C1DA2A602A04BE664167DE7F80D94F13C1CBEC5AFBD5BD6641511A65012D7913C1A519FDAAC2BD66419F423C21C98213C197B05AAAA3BD6641BE54195BF48A13C13888C36156BD664128C8C53E5F9913C106DB3E1628BD6641FEF2CA57239F13C1F1F4843AEEBC66415ADA31A6F1A313C134843369ACBC6641DAA584994EA713C192C1736057BC6641B5B30184BFA813C1	ID
655	159	MY	Malaysia	0106000020430D000001000000010300000001000000140000002143ED3B474C6541D722605FE3672241900A3EE8ED4C6541CCF26944F85722414BEC13B42B4D65412DC75AB23B2F22414B0C37F4D24C654135D131881D0A224166BAC8BCBF4C6541FA1ABA29890522416095CA0F394B654108DB04C004C321416CDAB9D7064B65410D178C8220C021411CC1C64A9A4665419809836F08D02141D39E0C1E2E4665410294C0D04FE32141164364FB49456541DF95C1BABA572241A31F6A28654565418B051565017222416BAA0DF0834565416FAD30B41A762241A9A7FB94C9456541C3DBD59ACA772241B6B4F6F2FC48654168486945B8792241E65E36BAB64965412257FC08F6792241A6C89DF2584A65413BB2595E0878224118C24568824B6541433B6B283F72224111A109D9054C654124E78B9E636E2241E8BFEC72344C65411D190B237F6B22412143ED3B474C6541D722605FE3672241	MY
659	218	TH	Thailand	0106000020430D00000100000001030000000100000013000000C2D05090D3106541792A63CC5D392641B9F9709D7F126541021E046A903C2641E31B1FF8D41265416AEA2DBDD63B26413C9C019416136541477E540DE83926416B304D383D136541B3E86793483626418A5BF6DB44136541470E62FCB93026412C335F93F7126541A0565A86B8292641A5A1E75214116541E002C5BA9A1726410E2417128D1065412112ABFD38142641A73A92752C10654119E978E0761426414912FB2CDF0F6541903CA315AC1526417906B091FB0E6541E9A578608919264121A6F035610E654165E6FBAF311C2641832A31A5EC0D6541EB81B15206212641B217E1EBDC0D65414DF3F531DB252641505D8919170E65416240F169452826419C0A4C5CBC0F6541209E8C22C4362641F48A2EF8FD0F65411F9952ED74382641C2D05090D3106541792A63CC5D392641	TH
667	159	MY	Malaysia	0106000020430D00000100000001030000000100000012000000811706E0E47368410EEE04635DD42141BFD4AD04DC746841FA1ABA29890522418506ED2931756841FC79D88A1112224180742CA0B8756841C6A391E0771B22416F72DF7C817668414099844F8E262241EC4C988665776841D69AB67E32302241205EFB05A7776841A90C468FE2312241A89DC617007868410A9B6CD39B322241011EA9B3417868416ED8C0FFE42A2241C2BD274F1E796841A66B9C28B6EC2141E2E8D0F22579684160FC53D668E72141B254854EFF7868411EBFC74ECBE3214183CA68C7EC7768417147043274CB214117C8AA838477684133AA82F526C62141E3D15DB2AA7368419A2A3F0D3CBD214172A3E94D7C7368417B439EC329BF2141B768AFDF74736841EC7F91FB76C42141811706E0E47368410EEE04635DD42141	MY
669	159	MY	Malaysia	0106000020430D0000010000000103000000010000000B0000002C00ED27168F6841086A7449534923419FC6C03A278D6841131C4280F75923415107CCF2F88C68412C4ED08EDC5C23419FC6C03A278D684134C29665C15F234169272D2A178E6841D29684CFE3622341A8F97DFD6B8E68414D0169655F63234121D0A60EA68E684174F210EAF56023412C00ED27168F6841631AFE84595623418280CFC3578F68410B8439C6A14E23416D161474638F684159281E3C884A23412C00ED27168F6841086A744953492341	MY
656	105	ID	Indonesia	0106000020430D00000100000001030000000100000010000000483075BA6B35644158A1301256052341B14F11BA063664411CCB5C9EFCF92241D17ABA5D0E36644109C2E895AEF4224183BBC515E0356441612C4CAFC9F122415FFA99CA553464413032ABE5DDE82241E74E0E8B0C346441357B9202A9E72241081D916E403264411D58C2E6DBEF224118FFBA51D031644109C2E895AEF42241E96A6FADA9316441EDF061624CF82241EE83A854B1316441015E76349AFD224118FFBA51D03164418FF9B1CDB3012341F3A8A601383364414B1AFDBC91202341E8C7956D7D336441C07908C941222341AFF9D492D2336441C3043970C6212341E74E0E8B0C346441F66DF2095D1F2341483075BA6B35644158A1301256052341	ID
657	105	ID	Indonesia	0106000020430D0000010000000103000000010000001500000036B8B73E69406441AE98362AB1BB2341CA92ACBB71406441433EB6F0BBAB2341AB6703186A406441D97CF14765A023412F26F5309E3E64414CBEEFC75886234172B5A35F5C3E6441683D686CA88423418E58BB96FF3D6441683D686CA8842341F87DC495A43B6441631B47208C8E23414A963805293B64419C9FDBCFA5922341E3ACB368C83A6441D0702675AD98234172AF49D5943764412287B3D602E223411387B28C47376441DF1AF1C93FE923410AC6C438343764410600464BD5ED2341EA9A1B952C376441B84C910524F32341106E79E53F3764410E9CD386C2F6234172AF49D5943764411ABBC6E545FD23412E209BA6D6376441AB4AD955FFFD2341C6CD17CFE03D6441184CAC55C3EF23414EE2450F493E6441B678D99D74EA2341B428F16B7D4064411B1A51CA44C62341DAFB4EBC904064419BC2BFCC71C1234136B8B73E69406441AE98362AB1BB2341	ID
661	105	ID	Indonesia	0106000020430D000001000000010300000001000000130000009E42D5EB09EB6641E885CF986DB51F4147F809B302EB6641E0415E3EE9C41F41B50D457029EB66417324A59B22CC1F41AE3486F222EE6641FE6ADB8A481B20417F8B919F9EEE66419D3997B4601F2041D836110DD1EE66416252480EB11D20410123A804ECEE66412DF4561294132041E2F7FE60E4EE6641B054E9E6470E2041DEC8D19649EE6641E0415E3EE9C41F4117979271F4ED6641998594495AAC1F41C8D79D29C6ED6641CAB2DD4717A61F41B4F1E34D8CED6641FC835DDA46A11F411D74130D05ED66415DE00FEE889A1F41BE4002336EEC6641E6AAFE11B8951F4157577D960DEC6641E6AAFE11B8951F41D4BF6631C0EB66418BAFDE7F20981F41377ABE0386EB664186AAF5EAF09C1F41F9A76D3031EB66416C046D67F1A91F419E42D5EB09EB6641E885CF986DB51F41	ID
662	191	RP	Philippines	0106000020430D0000010000000103000000010000001D00000035305980785D6941E2B1AF78EF5B1F412B4F48ECBD5D6941B4CF4CE123E61F4160276A09DD5D69411286B293FC152041BD4487C0E05D694104A25EDF1E262041DD8F53A48F5D694167B5A27BAA45204175A6CE072F5D6941069481F3315F2041C2F66A8A005D69414DF2C7297A6B20416A7688EEBE5C69416688D78997752041F7ABF2BDA35C69419D16D48CDA7B20414F215BC89B5C6941CD6791C12C872041FCC42B65AB5C694144FDFACAFD8B2041071595BEC25C694129F655A55390204137A9E062E95C6941F41118172E94204108200F500C5D6941C79404D4DD952041C201E51B4A5D69411AED9A1EA0952041D6E79EF7835D694119B64A056C9420410B249F48B65D6941DD8300DE40922041B383996CCD5D694185CBD23AD88F2041240EE91C9A5E6941651D5F3ED575204134778B1DB95E69413D39BF8CC6702041E706CC5A405F69418E5D56741455204196D9C9C1EA5F6941FD0967221021204178E76180056069418F5FE52A27182041F5F6E678EE5F694128DD7EF5D50C204145D6FE00C45F6941C58625A6120020415DC70049E75E6941A7F1EA9850AD1F414FA91E5A605E694134854332FA811F414479D840F05D6941B258A61C7E671F4135305980785D6941E2B1AF78EF5B1F41	PH
663	191	RP	Philippines	0106000020430D00000100000001030000000100000006000000108A40B1937B6941CD9E24A5DAFF2041B6E93AD5AA7B69411A3A047C21FF204159CC1D1EA77B69415EA3C862AFFD2041ED455E66847B6941CD2872D32AFE2041FB0765096D7B6941D6BFECB39CFF2041108A40B1937B6941CD9E24A5DAFF2041	PH
664	191	RP	Philippines	0106000020430D0000010000000103000000010000000A000000976493EC647769414DAB33B6BF2321416228939B32776941C11475E278242141349447F70B77694189A113BDA3262141050B76E42E776941F91D892A412A2141DAFEBBAC6C776941660353ED622D2141AAE66E948B776941660353ED622D2141DE226FE5BD77694127A3D4852E2C214103675130CD776941D2A136444A2921413D408C9CC1776941936818A39A272141976493EC647769414DAB33B6BF232141	PH
3736	36	CA	Canada	0106000020430D0000010000000103000000010000000F000000E695094DD85464C113BCD1816D0B6741BC937E322A5464C1D53EFF606A09674151349A2EEE5164C1631F8E9A5FFF66417AC7CC833F5264C11F69046757FC6641CD75A815BA5364C125D5CEEA42F96641C23B33DF355464C1A324EEF063F86641EC3DBEF9E35464C10B3F8EFAC5F76641598FB1C2015664C1A23045FAABF76641DF2A5820F95664C14FFB39453CF8664129588CDEAE5764C168CAAB5A7EFA6641A53245E8925864C14EFAFF013E056741CFE1D85F815664C1AF3432EE020E674144BEA095255564C1AAC82597900C67416ECA5ACDE75464C1A28F8F64FF0B6741E695094DD85464C113BCD1816D0B6741	CA
681	105	ID	Indonesia	0106000020430D000001000000010300000001000000240000002ED69C2582E96A419C625E24AFE81A41981BC964CEE66A415E28E6F15EFD1A413A4C96BE4AE66A41894CCE50D57D1B41A864482546E76A419A14F4C01D901B4188197C4197E76A41F5FD6EAA4B981B412AC7929B8EE86A4164378FD56BBB1B41289688CA93EB6A412B2CB2E86D6E1C41941C4882B6EB6A41A4936C3E6C7B1C41B09F3C79B2EB6A418811EF6AB49A1C41289688CA93EB6A41C8A3DCD770A11C41CA6277F0FCEA6A41A1A0E25ED7B01C410A7CC6B7DFE86A41D8FB1A3B93C41C418EA10DAEFBE76A41B91C820080C61C41F49F3BF9B9E76A41D97CEE03CBCB1C41309999A555E76A41CC8507E444D91C41E7C4C98969E66A414FCAA06287391D419EAD89EE46E66A4171DCBD5EC4731D41CB9381C1F7E76A41B7595A3A296C1E41E74C8D1B2EE86A4179C9AE0C6B7F1E41BCBCD16FB1E86A4136AF07A999A11E419B71058C02E96A41D598112990AF1E41FA999CD44FE96A41D7DA2FCF14AF1E417B0761DCE1EA6A41FB748A7AEEA51E41BFDE8C1C16ED6A41FE7FE83E15951E413E4FC8CD7CEF6A41084FFEA73C501E416322261E90EF6A416925040D594D1E419A3BDBB385F26A414B4CAB7E43E61C41BA6684578DF26A41C93469EC8FDE1C410DEE508C6EF26A41FA61F71733CE1C41DF5905E847F26A41B2C6026589C51C411423EB5513F06A41D0CF4E77FC6C1C417F7246B273EC6A414429E58E02531B411370886E0BEC6A419C2D61D9AB281B41A1EF67DB52EA6A41E8CD8F9E57F11A41ACD0786F0DEA6A41292C47140DEC1A412ED69C2582E96A419C625E24AFE81A41	ID
682	105	ID	Indonesia	0106000020430D0000010000000103000000010000000C000000DC59820BCFA46A411999EF86F5F71F41E53A939F89A46A41197969E970F81F41DC79A54B76A46A41DCF94B9FE2F91F41595E8D726EA46A41E757A3DF41FD1F415F11BCB0C3A46A41C4AC37C95E0520416A368838EAA46A412879AFE34B072041A28BC13024A56A41D1E41271420820414D04F5FB42A56A411CC8399589072041DBE0FA285EA56A419992332CDA052041F68E8CF14AA56A41148D9CE9A9FF1F411F70A9571CA56A41DA00D3015EFA1F41DC59820BCFA46A411999EF86F5F71F41	ID
687	191	RP	Philippines	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	PH
673	159	MY	Malaysia	0106000020430D00000100000001030000000100000010000000B1A59CB89CA26841BF54E965036C24414C6A6D7104A368418F34812A826C2441A8CEBCC548A46841797272148B6B24415B7E204377A46841321780C667682441FC40E04BCCA46841E72A890B11562441FC40E04BCCA46841130BB9477B51244173A8B097A9A46841E9FAAFD1DC4D2441D662086A6FA46841094BBB08734B244135A048611AA46841868D659CF74A244120BA8E85E0A368417E788E59234D24413135638B88A26841CAF1E012605B2441A578809E14A268414FD669B0336024417B8CE9A6F9A16841E8DFBCD64D642441AB20354B20A2684105923358EC672441DCCDB9964EA26841C71A4A99D16A2441B1A59CB89CA26841BF54E965036C2441	MY
675	159	MY	Malaysia	0106000020430D0000010000000103000000010000000F000000E2F848A9118B6841C89C9619ABFA244147E9B7DE118B68417909E6E849FE2441D5C5BD0B2D8B68417DA0F1A4640225415BDAEB4B958B68410ABC24F6B30725419EF01298E28B68417680F8FAE8082541FD18AAE02F8C68410ABC24F6B3072541B0C80D5E5E8C6841D47FFE73CE042541D8B4A455798C6841C7B576EFB3002541C34AE905858C68415337B56A64FB2441508053D5698C6841D7103A130CF724418034C2B9378C6841080A205F26F42441E832F004F68B684138AB22AD75F22441477030FCA08B684146E4F35CBCF12441045A09B0538B6841F1F6EE5DF1F22441E2F848A9118B6841C89C9619ABFA2441	MY
680	159	MY	Malaysia	0106000020430D000001000000010300000001000000140000001BF26ECCC8CF68418264C8136D4E28416529D2A792CF6841539104541651284137F964377FCF6841645A579C815328410C5F7A6EEED06841C4DB178ED69B28413A8FE7DE01D16841A89CF3F4419E28416386F86766D168414830A5D05EA228410CF67B3359D7684165A64BB44FE02841A3F74DE89AD7684198E07F393FE22841756E7CD5BDD768410194A17301E22841D6AF4CC512D86841677A436E53D82841C7CD22E282D86841DB23016FCEBA284194007B56ADD86841DB450BD7DE9A28411110004F96D868414613EC0846962841A489409773D868410A268F989494284152B77FA747D568418D128019BE8028410FD5D9D5C9D26841C3AAD8F6737A2841679502F259D2684184CD6155C27828416918B9F1DED06841D4C4519604712841AE36E325A1D06841C872818CDF6D28411BF26ECCC8CF68418264C8136D4E2841	MY
3747	36	CA	Canada	0106000020430D000001000000010300000001000000100000002B664E22604961C17BFD9CEF75976941F2B3EE69524761C1F6F0A7372A9969412E3B7DA7BC4561C1842589E2DC996941DC0F5815C74261C1CCF83ED9EC99694141837D4A4C4161C1CCF83ED9EC9969419C3FE448D23E61C1A6D1D71B6B996941DA66244BD33D61C109039A7268986941B17A8D53B83D61C1806F2BC8A6976941B6021FC01C3E61C190FF897C639669419C79BF4D694361C17B2688619791694159E0E101974461C1C30E892CB690694113A2948D2D4561C1B943096F85906941F6F5CC565E4B61C12F10AE4AAA92694173F0A8A0E94B61C1D95093B95B93694115C811589C4B61C155418EC96E9469412B664E22604961C17BFD9CEF75976941	CA
691	218	TH	Thailand	0106000020430D0000010000000103000000010000000C000000EF720AC09958654173084B14F645284129C843B8D3586541C8B2437A824428417CCB0E79FA5865412CDD053817422841D5CFF288F6586541AB737AB6403D284148F3EC5BDB5865419DA2F2592439284177A75B40A95865419E4B782C3D362841DB81D652165865416CDA7639563328418301F4B6D4576541EE74FA85453528418301F4B6D457654148AE10011C3A28416DFB169BF35765415E8D5397383E2841B71DD1C75F5865415BA976D18A432841EF720AC09958654173084B14F6452841	TH
699	241	VM	Vietnam	0106000020430D00000100000001030000000100000015000000D593B6747EA566413E084D409FB12D415E29BC29B9A5664169DA4B496BAF2D412AF8356AD0A56641B6DEAF3F3CAD2D41B22C87EADFA56641DC985F54CEAA2D414A23DF0DD8A566417A69D8DC60A82D416D87E4988EA5664192B39E13B19D2D416A3BD78E6EA26641D2C374125C4C2D417B287B0348A2664188FD86BC634B2D41CE1552A1DBA16641E037161FE74A2D41867799E829A166412BE54006D14D2D41F4815A1407A166419DA17AFA454F2D4124155B44F89F6641EA1EACA908682D41B58E9B8CD59F66416BC14006E46C2D411E984369DD9F66413B2B6A60516F2D41FA3EB86F70A06641EF5287487C7A2D41A0E5E430C8A16641A26B02A647922D41715C131EEBA16641BE2B73AEBC932D4199A5D0D5D9A36641605DADF6B4A52D412B9B0FAAFCA366414F2446CEEBA62D41FCDC71A81AA566410B8B655AE0B02D41D593B6747EA566413E084D409FB12D41	VN
701	241	VM	Vietnam	0106000020430D0000010000000103000000010000001000000085CDAC9EA9F86541D6F3B0C19C8F2F41980F42C681F96541584AC12E8B922F41702E2560B0F96541A395743FD0912F4111E66AD7BBF9654114A92FFE378C2F414A5BC70F9DF965414FB93BB15A872F41BE02C3563CF96541E0906938167F2F411C60268E8EF865413AB3365CDF742F41BE378F4541F865416C9B9A5DED722F418FA343A11AF8654190642E96E6732F41C971047CC5F76541AC3A49EDC9802F41034B3FE8B9F76541132F44A576832F41AFEE0F85C9F76541FEAB6D82E5852F41803AA1A0FBF76541467E7290C9892F416697896958F86541A29D6490688E2F411C60268E8EF865417E71EB4A1C902F4185CDAC9EA9F86541D6F3B0C19C8F2F41	VN
708	241	VM	Vietnam	0106000020430D0000010000000103000000010000001B0000006BDA1093708666417451C948048A3041861A978E8889664104A75B27F26B30417FAFE561A98B66413EC7DE38BD573041661748BC4F8C66414E2CF327815230415BBDAF45248D6641FA6E8DECE74C30414F6E9160428E664177D7CEFF8C473041C7A095BD1A8F6641BDC6853D7B453041EEBCD494139066418DD8AA311F44304148AA7B91999066418B8323884A433041A6D212DAE6906641B344CED4124230419BF101462C916641A480AD1B9D40304154E2113D6B9166416C23D801053E30416CE42EBF94916641AAD7A52F423B3041C9014C7698916641DE4DD8AB253630415C7B8CBE75916641B5F54155E3313041868746F637916641E0C356549A2E30416D7DD9E1AC9066414C849ACE192A3041B00C88106B906641B599F3A1842830411F376C7CEF8F66415101A4092E273041C7A095BD1A8F66415101A4092E273041980C4A19F48E6641A12949EAC92730415098E3BDFD8C66417FC8A6103A333041D29D0774728C664142FE93979B37304112147DFB288C664196387938873A30410E4FE80E9889664146F6137CB6583041773F251F38886641FA0A8290FF6930416BDA1093708666417451C948048A3041	VN
689	191	RP	Philippines	0106000020430D00000100000001030000000100000007000000FE510F8059CD6A41D3AF6B9BA67D2E41EA40B8D22ECD6A41D20817A7987F2E41DF7FCA7E1BCD6A4132F36AE274842E41EEE86C7F3ACD6A41B55AF602C68A2E41D85E8EEF9ECD6A416132C91A58882E41D85E8EEF9ECD6A41AC2411C0A4862E41FE510F8059CD6A41D3AF6B9BA67D2E41	PH
690	191	RP	Philippines	0106000020430D0000010000000103000000010000001A000000D7B08398FD7D6A41419C6150B9C02E412DFA01D97C7A6A41ADBEA38A37DB2E41D70750CE09796A414FFB662EDBE72E41CC5091970A786A41785D3D8ED2F12E4135D3C05683776A4140A527E64DFB2E41A5FDA4C207776A4182D1104037072F411741C2D593766A412A60126A19142F41215B14CC70766A41F5B026D5F9322F41215B14CC70766A419A8D1A6EAD342F419F751356A3766A4197C32D44AC3D2F416B2FE4E75C776A4126C5DCCD344E2F41697616859D786A4115963049CC5C2F41F5AF42728C7A6A41FAEB5F69A9612F41C377D219047B6A412034D672B75F2F4103601710EC7B6A41226261F45D5A2F41C966B963507C6A415741497087542F414BDFF7FC2B7E6A41DC02F73791382F41C226A508627E6A419A8D1A6EAD342F4145229AA1C27E6A41355A1AA08C272F41731D3B23D17F6A416F9F71C17DFD2E412F8E8CF412806A413716AA3E27E62E41B11A29C816806A41A70562CAEADC2E412BE6D74707806A415CBAE5713EDA2E4155AB5FE2887E6A411BF7EBBF6CC22E411C2B89185E7E6A41DC2EF91E74C12E41D7B08398FD7D6A41419C6150B9C02E41	PH
447	105	ID	Indonesia	0106000020430D00000100000001030000000100000010000000DDFD39DF290B6B419EA2483B358402C1A8A1164E500B6B41E0125A0CE8BA02C11224460DC90A6B41926A129C650F03C177B78E82F5086B41A7297F935F7003C16C87486985086B41E87E8113938303C12E8A5AC43F086B41314CD4F7A78103C10AE951B95C066B414064D38B534103C1C76E4C39FC056B41A9E9791E522903C1C1C6978CF0056B41FDA886B0321403C1DC54061536066B410EF7381F79F502C10ED83803A9076B4124F02B217F7C02C180787CD608096B41BACFE28AF95802C10310933B56096B41BACFE28AF95802C11224460DC90A6B418AC395C7416A02C1CE9497DE0A0B6B41B27BEFECF97002C1DDFD39DF290B6B419EA2483B358402C1	ID
449	105	ID	Indonesia	0106000020430D000001000000010300000001000000160000003957FC2CE2156B41CB3BA1C0D7CBFFC0BCEE12922F166B41C32CE7EE8DF0FFC0082A0666A3166B414DBBC4D67A0B00C1C59A5737E5166B41ABF435D6281300C1563178BF47196B41AA2AA1A59A5000C159BC80D5801A6B4124767EA5EC6000C147DD7E6D86186B4189FBDEB389FA00C1A4FFBB2B0C126B419A14BFD9F02001C1F617309B90116B4146EC27C39E1001C1BAD30F590A106B41E50B00957ECB00C123361CD8DB0F6B4179CB5DA4F8BF00C1CBC0B3CDE30F6B416C3E1BA2E3A900C153CA677C02106B4122F3B999919900C1FDB5B52A88126B4139FCB2DEAD0600C15A7A6E3FC2126B412FEC14DE27FAFFC083515C887F136B417079F1EA13CCFFC05E6955890E146B419974B7031EB3FFC0B7C914E5A8146B4140F7A81AD6A1FFC05E34899A09156B4140F7A81AD6A1FFC01EBE131353156B41AD18E41684A9FFC015DD027F98156B410AE6F50FE0B8FFC03957FC2CE2156B41CB3BA1C0D7CBFFC0	ID
450	105	ID	Indonesia	0106000020430D0000010000000103000000010000001B0000007ECF480C15046B4105DC5C2A3496F0C09DE54801BF046B4135C348F63CB3F0C0FBA90116F9046B413E9C1F0F70C6F0C09BBE6D4DD8066B41E11A44530897F2C0C5AA0445F3066B41042C720CABB7F2C06C87486985086B4154B40D739440F5C0EFA260428D086B4192678900D16AF5C0818D258566086B41658221EE9D87F5C022C96C702C086B4133D14438D19AF5C02A14FB5C64066B41171F9D747DD2F5C083A986A703066B41171F9D747DD2F5C0B53C532E42016B41A2D663213961F5C0D57CA580A7006B41DF1AD3D9054EF5C03EFFD43F20006B41A18A12F03831F5C08636381BEAFF6A41ABAD208CF11FF5C0DB59261CB8FF6A41D2D92F68FC06F5C0D60AD61176FF6A4193419EA28CC9F4C0D08DBE365BFF6A4109AA46A7E978F4C0F0B867DA62FF6A41D2BCE730AD4EF4C0033B438289FF6A4179A748ECCD03F4C070778D9C49016B417DB463811B2EF1C0C37A585D70016B41F525E7D64E11F1C027F23FB0FF016B41D17B680446CAF0C07A59E9A439026B41CDCA5FB014B7F0C032026389C8026B41A8CC1CDE09A0F0C05975729E72036B41FAA846527096F0C07ECF480C15046B4105DC5C2A3496F0C0	ID
713	179	PG	Spratly Islands	0106000020430D00000100000001030000000100000008000000D32593FEB94868416A9BE27408723041A491475A93486841E6BC437EC37230411D5DF6D9834868415E1325A65874304122DA0DB59E4868413D948D3B90753041F9F8F04ECD486841BE4FACBACE753041314E2A470749684151B63F31D5743041C944826AFF48684197AACF565F733041D32593FEB94868416A9BE27408723041	PG
718	179	PG	Spratly Islands	0106000020430D0000010000000103000000010000000F000000FA3FA6C886976841332E09315F2E324153E0ABA46F976841E1722C427E2E32418DAE6C7F1A976841AAD572C541333241ACD9152322976841D9DA005E7A343241481FBE505C9768414C4D3D51AD363241B6B0F799C8976841E801E0AC49373241D5579FC915986841DD14FBCAEB36324109949F1A489868414B46468C4F3632410EB8525399986841F74B256BFD333241AF6F98CAA49868414C69E3D2C4323241813F2B5A919868418C6EB44CAB313241F48DC2FE66986841B105E6202E31324168D1DF11F39768417C3ADBA7EF3032412E7CA619B99768410B0BF96A53303241FA3FA6C886976841332E09315F2E3241	PG
719	179	PG	Spratly Islands	0106000020430D0000010000000103000000010000000F0000000CE5CC2BEA9468419818A64B073D32415FDD1D5BC79468419818A64B073D324136F18663AC9468418E35D023E23D324146B38D06959468417E56E2DF783F324146B38D069594684168B6C7CBD040324136F18663AC946841C7B9889C864232417F08C7FECE946841C272FB2BA043324135D16323059568410FC962F3FD433241CD6E57A43395684189C04DA7DE4332413F9DCB08629568411551D34742433241538385E49B9568414D0083F1CA4132415A2B3A91A795684176ECD45092403241F22192B49F9568419F595694B73F324120AB63C77C956841E1DEB4B0FB3E32410CE5CC2BEA9468419818A64B073D3241	PG
3753	36	CA	Canada	0106000020430D0000010000000103000000010000001C0000008F81FEE4CCC260C191314F1483A46641C7DCA258BEBD60C1A770B0D6DDA066417EAF6E9A08BD60C13622C25C37A066410A3CA59FF9B760C157E502107B996641DBC77C3B7AB760C1E2FA6CF7959866410E750187A8B760C13CDEA155E397664138576961AFB860C109BDFF107D976641DC5ABCE2DABB60C13ADA01B6D6976641CD8E8622DEBC60C1E1576E16CA976641B252C4C822BE60C1D975E2EF499766419C171BBE3CBF60C1A57A8E41B1966641580FE5AC0DC060C13E8C4A28F29566415CFECBF659C160C1B23FFD864D9466414803696CC2C160C177E98A918E93664198620F7987C260C12D6C9ED7A9926641F2F8E5375CC360C11705982F6A926641B40B813AF2C860C156ECBC300A976641F81779692BCA60C1B157A5CA9E9E6641F3FE3FC223CA60C175E0AB91D19F66419F9796CDE9C960C16CB5AB85C4A066410252EE9FAFC960C15861C2E6B6A16641A5C2017A7AC860C1C86BC84DDDA26641F564168223C660C110DB506EF6A46641C33A48367AC460C1CD73517036A66641CE94E0ACA5C360C1501EB77210A666417485820B60C360C126F8D5C7A9A5664175DEE6AD29C360C17E96577250A566418F81FEE4CCC260C191314F1483A46641	CA
3755	36	CA	Canada	0106000020430D00000100000001030000000100000012000000D25119F46CFE60C116B6B3C10CB3664184DBFFA62CF860C158D9F0DA77A9664189A3D793DFF760C1F652F83484A86641C2D8ED4B72F860C1CB68BBD9A9A66641055E6D5D1CF960C1C05A0BCAA9A46641F0E982F013FA60C14088EE47C3A2664167FC630D45FB60C103F426AA43A166413C7722F311FC60C12611E34977A06641B538A255EEFC60C1EED0A97CF79F664161C7C943A0FD60C10386CFA284A06641BBD0BC692E0361C1E68174434AB166418102FC8E830361C18ACA45AB58B26641B0964733AA0361C1EB0E390A9AB36641FEE6E3B57B0361C1985FB0C440B46641E5DC76A1F00261C1B27619F6F4B466415DC84861880261C1B27619F6F4B4664169C5BA17E0FF60C1D8A4899E67B46641D25119F46CFE60C116B6B3C10CB36641	CA
978	125	KS	South Korea	0106000020430D0000010000000103000000010000001200000049BB901A4CCC6B41DD312599071C51417F87A20B52CC6B413F041E507B175141743739B23ACC6B411B064DEEC21651415C571EFB6ACA6B41694986599413514150803C84C4C96B41BB88093F2013514185A648B263C96B412E95004A3D135141EFEB74F1AFC66B41303581958C1551413DCB8C7985C66B413DA2C4021E1651414D5452BA4BC66B41AF4686DC671751416E9F1E9EFAC56B418F782566EE1A51416E9F1E9EFAC56B4123DD2151BA1B5141B10EAA8C11C66B41CDE29982721C5141B9852243C2C76B41BFA6DA1B0A1E5141E4A7D09D17C86B4177EAC5A53A1E514166EEB9F1C2CB6B41B94352C429205141B2544A9727CC6B41ACDBA43020205141C2F62DFA68CC6B41276A7B8B8F1C514149BB901A4CCC6B41DD312599071C5141	KR
3019	125	KS	South Korea	0106000020430D0000010000000103000000010000001D0000002F2690B3DED86A415356444AD5435141C95D7B4FADDB6A418595257C2F4051412E596416F7DB6A4126825C3AC43F514122F4510E82DC6A415EAAEC71DA3E51411D82B4C4B0DC6A414558ACAC483E5141A58B6873CFDC6A41A6C9381BA33D51412DC0B9F3DEDC6A41FE204F0FEA3C5141894FA61914DE6A41C9F97233652B51411D82B4C4B0DC6A417B3A1E453827514119EFA8C602DC6A4198A64F24D726514125457F1F24D96A4188E6827689265141DDB0F58386D76A419268B31493265141CD6776C30ED76A41BFE222A9C326514185C9BD0A5DD66A41BD47CC6F72275141C9788F79C2D56A41617C870E52285141ABA64A7884D56A419A028095D0285141C54962AF27D56A417E1DB1C1F32951419ACE4FB208D56A4159731C618F2A5141129AFE31F9D46A411BE3A01F482B514109F9331E8DD46A41109603E00B385141B500E3EEAFD46A41B9DCD3FBDE405141BFC1D042C3D46A41466735C8A1415141659E146755D66A4147BA57683F45514137EAA58287D66A41420FFB498D455141E671E3D799D76A41F8C4BA5CF845514154031D2106D86A41392F392CDB455141B22BB46953D86A41AD3BC9197045514164B07A1591D86A41D016773FF14451412F2690B3DED86A415356444AD5435141	KR
3005	125	KS	South Korea	0106000020430D0000010000000103000000010000001F00000051CD033A79D56A41069CBC98CF0E4F411858A70198D56A41C8A8DA06C50C4F41BE53C3F19BD56A41380B43B74F0B4F414B5E90EF8FD56A41DE76C0F9A1094F41D844C539BFD46A410CFFC3C7AF014F41EB66359D9DD36A410D8FA8FFFDF74E41B082809F5FD36A414B1AF8951EF74E41671142BFFECE6A4159DE610B40EF4E4108E9AA76B1CE6A41D69F546AD0EE4E413E4B3B0795CB6A411DA9F57C84EA4E419DA89E3EE7CA6A41B671976D02EA4E41F53D2A8986CA6A4197C9D180EFE94E4187ACF03F1ACA6A4150787B4527EA4E419226ACF6ECC86A41167E2240CFEA4E41C9DB332A90C86A418C0991031AEB4E415B744C3EDFC66A413404C48237F14E41D434812C86C66A41AC18075A67F34E411953AB6048C66A411BB81883E1F54E418FBA7BAC25C66A41EEB7F99D93F84E410E2EDFD821C66A41254832131BFA4E4114D693852DC66A41B253E970C8FB4E41BF4EC7504CC66A415EC0476D50FD4E4104DAA0ECBDCD6A415A829B4E64234F41BEBB76B8FBCD6A411ABCACA544244F4157C8C2FE86CE6A41229F782432244F41C95D8C409DCF6A413FC6E0FE4B224F415381C40AF9D06A4162245310AB1F4F414380C25BF7D26A4191F90E20821B4F415097ECD63ED56A4178B8814EB5104F41C3C5603B6DD56A411E62CE4D9D0F4F4151CD033A79D56A41069CBC98CF0E4F41	KR
3007	125	KS	South Korea	0106000020430D00000100000001030000000100000012000000682EA75F4F216B41E81AA2C5D8194F41F7E75F4DDB216B4115A8AFD81B164F41795F537281226B4155317134980E4F41795F537281226B41454135E80F0D4F4189BD7BE156226B417F67F401AD0B4F41CEDBA51519226B41B51BFDEBCC0A4F41F13FABA0CF216B41635339C3240A4F4198BFC8048E216B41119341AE5C0A4F41BAA33F0B55206B413BEFC216B80D4F41239EAB38091E6B41072F3F0686154F4196EC42DDDE1D6B415661B12B9E164F410EB8F15CCF1D6B412D6F912E01184F41C6808E81051E6B414FA7385C19194F4156BDFFF2681F6B41DD50AFBB371B4F414F2B3F69F01F6B414A212205051C4F41F77590DEA9206B417B744FA0BA1B4F4180B55BF002216B41C0D4B744121B4F41682EA75F4F216B41E81AA2C5D8194F41	KR
3008	125	KS	South Korea	0106000020430D00000100000001030000000100000012000000FE535E7242236B41064BBB6D2A364F41A8DEF5674A236B415AC1EA5F0C314F41C59A4646F5226B4120736CCE75264F419706FBA1CE226B41FD413892DA244F41C2A130DF94226B41A3719939FA234F4101B4C73238226B411ABCACA544244F417974FC20DF216B414429B483FF244F41619F5BFB58206B416669127BDE284F412197F3C4C91F6B41E3DECDCA792A4F41268D9282551F6B4113426BA2722C4F41FD3C1D57271F6B41325F92028B2D4F41EDD37A56081F6B4174C43AF7C82E4F41CA8F980BF91E6B41F8A6EDE62B304F414803FC37F51E6B41DFB56FDDB3344F419BDB29272B1F6B4150793A6ACC354F415021104CDC206B41DD57D8D4273C4F4101892A6147226B41618993C36C3B4F41FE535E7242236B41064BBB6D2A364F41	KR
3009	125	KS	South Korea	0106000020430D00000100000001030000000100000013000000FE2178916BC06A41CFFB06EEA4474F41B304C972ECC06A410B291B6EA9454F4102C4BDBA1AC16A41C3AC8B2290444F41359CDFD739C16A41431915ED51434F416325B1EA16C16A413C2BB424C9414F414BFB2096E4C06A417820E0F99D404F412ABA83CF49C06A41D9CEB27D2E3D4F41D84F63313BBF6A4101290B00B3374F41D4F26E96C7BE6A410923BA7B10384F41BC6BB881C1BC6A4107954279663D4F416CA149A849BC6A418C472BC24C3F4F4181A726C42ABC6A4136D877E88A404F41FA72D5431BBC6A4133C564ACDB414F417E8EED1C23BC6A41691EBA768A434F41521E55B14DBC6A414390BCBDED444F41A75A61D496BC6A41609A94E596454F410400421D5FBE6A41D6AD65B7F3484F4111B016BBBEBF6A4176A24B760C4A4F41FE2178916BC06A41CFFB06EEA4474F41	KR
3010	125	KS	South Korea	0106000020430D000001000000010300000001000000290000007F2CA755CDC06A419E5159B0CE5D4F41953DFE02F8C06A41857716654B5D4F4102C4BDBA1AC16A41D46D27D20C5C4F41B304C972ECC06A41A1764E45D4584F413A0E7D210BC16A4108ED45C395574F41359CDFD739C16A4156E3FBC57C564F4155C7887B41C16A41EE8C9FDD63554F4150A3D542F0C06A4156437D9FE0544F41659E38CD87C06A41B2C6233006554F4179999B571FC06A417BA23C5D89554F412119B9BBDDBF6A4156437D9FE0544F41EE6B3470AFBF6A41299238157D534F418B9BE87A56BF6A4151CEDF8044534F41E23074C5F5BE6A41EB5E653BED534F41EA71D39419BE6A41717E93F282544F41815DB126C8BD6A414B6A13C7FF534F41AB696B5E8ABD6A41CE5885650C534F41FE61BC8D67BD6A41CDC1FCDA82514F41030A713A73BD6A41CA992758F94C4F4153E988C248BD6A413FBC2C65954B4F41C08F6BBA12BD6A410DE293176A4A4F41677D966FF8BB6A4176A24B760C4A4F41A1E7781690BB6A417329A88B444A4F41F583EEF9CEBA6A41CA992758F94C4F41E71A4CF9AFBA6A41D490EB38254E4F418FA5E3EEB7BA6A41B86E1042D44F4F419DE3E81DE6BA6A41CE5885650C534F416AB2625EFDBA6A416789C1396A564F417E981C3A37BB6A4185A2C09F4A574F41BCA08470C6BB6A41EC87AF3FC1584F41FF1A8AF026BC6A41EC87AF3FC1584F41246AE6CC7FBC6A41BB3A83640C594F41E0A56BAFBCBD6A413276F13189584F41296447A815BE6A41A1764E45D4584F41A5E224665BBE6A41FF4D26A98F594F41080F4CA752BF6A412F96A1E8385D4F416637E3EF9FBF6A4183ED8122BC5D4F412696D096F8BF6A41DC54FC44F45D4F41360AED2861C06A419E5159B0CE5D4F41220F8A9EC9C06A41857716654B5D4F417F2CA755CDC06A419E5159B0CE5D4F41	KR
711	191	RP	Philippines	0106000020430D00000100000001030000000100000017000000F7E56FFA63D868413C873323E96B2A4170C6C728B2D76841812F5E44C1702A4140327C848BD768419D9F9D5BF7712A4127A40DFC45D768417D4ADED305782A4131F32BE127D66841AB6AC510CFA52A41A5BA4A686ED56841B10CE2C47CC72A41816BEE8B15D56841DDA8D86090E42A41AA77A8C3D7D4684193F84A21DF312B41816BEE8B15D568413CD62C164B3C2B415C786DFB5AD56841A4BF84E488442B418B37567172D56841D9F725EC3A462B41F215617C89D56841001142E6B6462B41D13A6C7B1FDB68410193BA5C595A2B41879F2A6C42DB684185E1774A23592B41784C7C8EB6DB68417F580749984A2B41F4FB97C6A9DC6841D750A19A46C62A416CC746469ADC68419200E84420C32A41784C7C8EB6DB68412B01C5F46AA22A41A0221F633EDB68419D5AAC8465932A41A1A620D7F8DA68410C55F809218C2A416E6A2086C6DA6841082ACA0303882A41823E74B3C4D8684174EF680D0F6F2A41F7E56FFA63D868413C873323E96B2A41	PH
712	191	RP	Philippines	0106000020430D00000100000001030000000100000018000000051EF73898E768419009D5844AB42B4145946CC04EE768414486F7E004B52B4180A2731B48E66841532F339181C52B4174520AC230E66841A85E83FB33C72B4141A5857602E6684140E1B11CFECD2B41A0ED3FFFF6E56841D737ED4D44D52B412B3BCA260EE668412558E2D297132C41510E287721E6684131476D16EE202C41A3E6556657E66841B5A8DEA96B292C41D72256B789E6684100B024AAC12E2C410AD0DA02B8E668418A62E33674302C4144063C2F80E86841F558BEAC84362C418DC41728D9E86841681388D1C2362C41059B403913E9684188AF336308362C4166A7443A63EA684131476D16EE202C4119F3C9837EEA68419441025D811E2C415954965CD7EA6841665DD42A780F2C4129B5D02667EA6841E264108334CF2B41A6C4551F50EA6841BF2D000B99CA2B41D44D27322DEA68419834171B72C72B41587EE8B992E968416B24DF5B79BE2B410A23D2A577E968411B146CFEBEBD2B4198771441CEE7684177410A89C6B42B41051EF73898E768419009D5844AB42B41	PH
714	191	RP	Philippines	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	PH
728	191	RP	Philippines	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	PH
740	37	CB	Cambodia	0106000020430D000001000000010300000001000000120000003B029B411709664126FEB287ACD7314173019A966F09664124BDA7A512D731418C8F081FB5096641EC770500BBD531410E271F84020A66418A09C3FF36D13141965B7004120A6641FA9ECA520ACE3141DF72B09F340A66413E942806D0C23141230DD95F3C0A664185F6AD3D65BF3141DF72B09F340A664155CA593CCFBD314115CFD3300E0A66414F9045AF9CBB3141A9D6440ABA08664126AB4188F3B73141D88AB3EE87086641DB83327ED4B73141B33B57122F0866414B2B335545BA3141CED3F4B7880766416A22CD6D78C131411163A3E646076641957B150ED7C631415FC9338CAB0766410B349A2157D63141A4C73A80C607664149D5F30732D7314155E822F8F00766419C7CF829CED731413B029B411709664126FEB287ACD73141	KH
732	241	VM	Vietnam	0106000020430D0000010000000103000000010000001300000053CA29969099664142C10ECB4AD53041B9F0AF2ECB996641FDB54E5EECD43041216C277A049B664127EDBAD4A8D0304184FC2CEF0E9C6641D169C008D0CA30410478E231BF9E664180E3E01866B430418B8C1072279F664170F0F49BBEB03041222A04F3559F664133032C7C8DAE304129D2B89F619F664114EAE69236AD304129D2B89F619F6641F690F5BC62AB3041BB205C164E9F664191C5BC092BAA30419134C51E339F664166FA249D50A9304162A0797A0C9F6641D44F6C06D4A83041FBB6F4DDAB9E6641142DC55112A930411A02C1C15A9E6641FDE9E5B80BAA304109F0EAF647996641E0BA8824E7D03041C56A6BE59D986641389BF86224D630410EA2CEC0679866415AA38D9FF1D830413D361A658E986641A01ED1778DD9304153CA29969099664142C10ECB4AD53041	VN
735	241	VM	Vietnam	0106000020430D0000010000000103000000010000001100000044E8EC3DBEA3664153AA2182F8653141C7A07157E8A466414A3858F424643141490DEBEA44A566412BE480D269633141A735823392A5664174FCBE9E50623141392BC107B5A5664112D8FF4395613141DB718284C4A566410E213F0C5D6031413ABA3C0DB9A56641BC3EA113445F3141A735823392A566411A38F719C75E3141C7804E1741A566411A38F719C75E31419E176E1FABA36641EE13513E126231410736BFAA10A3664136B7D54F4464314102A03C038EA16641E2B61B2A766631419A1D0D4415A26641730CF66895663141400FFA1605A3664136C6BDB01E65314193E727063BA3664136C6BDB01E653141999A564490A36641EC3A5068F965314144E8EC3DBEA3664153AA2182F8653141	VN
739	241	VM	Vietnam	0106000020430D000001000000010300000001000000160000002362D67A10B4664138C507542BD93141153AC56E75B46641FA58EF1CC8D8314144CE10139CB466414DF398064BD83141F5EEF88AC6B46641F0066FE4AED731412E44328300B56641E4E681B318D6314153BE2B314AB566415EEB1D2856D13141E59166B6C0B466415E90FCE247BB314133490DF0DFB666416A854B0730A93141AB14BC6FD0B66641126FC388F7A73141EFC38DDE35B6664124595769C5A5314136286B9250B2664145C4F2E11499314150CB82C9F3B16641E006F67359983141DD9C0E65C5B166410B655039B79831417AD73C01B6B166418D70D7AEEF9931410285156436B16641977541C54FAE31415BFA7D6E2EB166415B1F5B71BAB131416049CE7870B1664108BBCF778CC831411CBA1F4AB2B166414B6AE62CCDD23141807FF1ADC1B166418174D3C11ED5314111753082E4B16641880C7145DAD5314197FB2D317EB3664149758CAE89D831412362D67A10B4664138C507542BD93141	VN
730	191	RP	Philippines	0106000020430D000001000000010300000001000000240000006EB2412A8DAD6A418B01AA207DA73041C3FBBF6A0CAA6A41A7AB573657A83041306DD673D1AA6A41359E922DEEB73041FC11FE562DAC6A41C9C67EF721C830414E2A72C6B1AB6A415B590F266DDE3041C6E5979EC6A56A41731C46695612314116C5AF269CA56A41F3CD963F0B143141E53A939F89A46A41777935AE472331412F72F67A53A46A41DA8F848DD62A3141C793EB6F3CA46A41365549063A2F314105EEFFD455A66A4130C5BAF18F803141C6D0EEEF68A66A41E6C8582145823141E6A7420739AC6A41AA438EA70DBE3141F1CC0E8F5FAC6A4185F6AD3D65BF31413896641902AD6A417F71639A91C2314148DFE3D979AD6A41E3453A838BC33141292393FBCEAD6A417E7803B297C13141E5CF9CD807AF6A41A7BE90AFB3AD3141F85CF21178AF6A4182A8607BB8A231411D3050628BAF6A4100BACB9A28A031417CFBC0EA04AE6A4123FB84B0826431417CFBC0EA04AE6A414438CC5FDB3D314192ECF45788AE6A413740184BE3283141677C5CECB2AE6A419289F9589226314162DF21D1F0AE6A414BC21A92FC24314138D367992EAF6A410E265BF302243141E5DA166A51AF6A41DC053DA4AB2231413101618F67B06A413E29079749143141DF8F887D19B16A41D86A287F47C73041BF64DFD911B16A41CCF55A1BB2C5304102F48D08D0B06A41548901E23EBA30418619D5FEEBAF6A41157921A415B23041B646CBC52AAF6A415EAFD7C1B9AC3041192146D897AE6A417C45716DCDA9304191E17AC63EAE6A41D44F6C06D4A830416EB2412A8DAD6A418B01AA207DA73041	PH
741	191	RP	Philippines	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	PH
742	191	RP	Philippines	0106000020430D0000010000000103000000010000001C000000FDF21923E6046A419ABD1EE59FA63141582CCA21E7036A4137AAA4EF1CA7314100ACE785A5036A41781655D693A83141CB6FE73473036A417E955BC123AB31414061581975016A41EDAE3F6898C6314155CB136969016A4102A6B50AD8CB3141963E61758A036A41C26F060091F63141D0F778A1D7036A41743748973AFA31413CE58D36E2046A412B6131EED30532415FEE3693E2086A410A498B914B2C32410D6C45CBE00A6A419818A64B073D324147255DF72D0B6A4180D0B8525F3E32410312AD54B50B6A411384875D843D3241E4555C760A0C6A413CED07572C3C32416CE7D3B6ED0D6A418C6EB44CAB3132412C715E2F370E6A41B47C7E3FD62F3241565DF526520E6A41ED18C4A99D2E3241B4858C6F9F0E6A416218932B362532419AE27438FC0E6A4169825FDA210E324100C17F43130F6A414C3ED82DF9043241FE5FC98A950C6A413E1C9A9A0BD33141E98EB85DB90B6A41A3855B4BFCC5314176C4222D9E0B6A41FF74904402C53141E61859F6DD096A41DEE0E29670B8314116305B9A89086A4152E987C96FB33141FDB695C0A1076A41CFCE16D7ECB33141D9F5697517066A4175B7353B18B23141FDF21923E6046A419ABD1EE59FA63141	PH
762	179	PG	Spratly Islands	0106000020430D0000010000000103000000010000000C000000E13F68D10F96684116A7A111E06E32410B4C2209D29568411508837E7C6F32411B39C67DAB9568417935D98AD4703241D2F6E81098956841E295B2F0A972324173AE2E88A3956841E26431FF01743241E13F68D10F966841BE948DEC92763241B3B696BE32966841368B5B9D737632414410B4C66896684111E46E2B5A75324143E516F57796684148FE499D407432412E7B5BA5839668419ACD61451371324143E516F577966841163D690819703241E13F68D10F96684116A7A111E06E3241	PG
2537	36	CA	Canada	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	CA
2538	36	CA	Canada	0106000020430D00000100000001030000000100000017000000469B235DF3615BC13EB97541641F57416240D17C01645BC18126D36978155741B418FF6B37645BC1683F9ABC7B145741F6957B956C655BC11DE063E89C115741100F416F54665BC1CBF2A130F40F57415783A7CA4A685BC15B6CA369E70C5741EE9779D03C6F5BC1EC2882FB08045741ABE8A761D76F5BC1960194C28A0357418F292F0897725BC18329E51405025741D7DDDBE3DB735BC1AFC796CDB40157413799B2D389785BC1205069E1CB04574195C1491CD7785BC11E74D11A9A05574186848F61DE795BC11DFF038C2D10574140A9D5AC52795BC10212260932125741B99ED689FE775BC145944532CC145741722A702E08765BC167A44CC92C175741F1165B3D75755BC1D37726B8CD1757414675822C52715BC11BC7FF6F0C1A5741B5F8CA3AA0705BC132EDB59E5C1A57419766CCB9B06F5BC1BE4DA249681A57417E1F5C25F96C5BC1B44DABD0171A57412ADCAA03B3645BC1695C1B2B251D5741469B235DF3615BC13EB97541641F5741	CA
2539	36	CA	Canada	0106000020430D00000100000001030000000100000018000000A9DCF34C48625BC177505FA3D02E5741469B235DF3615BC132F29828182E57417D21994B88605BC190C436AECB275741AC0E499278605BC132EE5036F1265741BF90243A9F605BC17F8C49A5242557412B225E830B615BC16F69C2903E245741E327FE276E635BC15DC07A24FF215741B326F0A655655BC1CC9F73B6832057414B2DD171296B5BC1B4D45F696D1C57411C00DBAAEA6B5BC1C81FC6ED331C574140C909DEE96C5BC1B4D45F696D1C5741013371168C6D5BC1018FAC64F71C5741AC1AFDA6076E5BC1BF72711B981D57417F2D4D60176E5BC1296B44A9721E574172DDE306006E5BC12AC2C9F86F1F5741F8811D5B44675BC17A15723A4F2F57417FA07AB8C0665BC1B19D799D353057410CF607C84C665BC166CF9508D73057411668C096AA655BC1870F90A755315741427C7DB6E1645BC155AD013E8F3157415A09A1CAF1635BC13FE4A86F273157410DFC74C756635BC10E66E2B5913057415DFBAF8FD3625BC1E82E1F4CF02F5741A9DCF34C48625BC177505FA3D02E5741	CA
752	241	VM	Vietnam	0106000020430D0000010000000103000000010000002A00000013F1F8E024AC6641157B2DAFED1832415635E9819DAE66417C5956AA310632418E1F3F2898AF664157350DC3B3023241468EE10F35B06641D788FAE3DDFE3141DE8FB3C476B066411CD574B7D5F7314146B97EE125B06641C16FBCB851F43141125B7A4147AF6641BD08A295E1F2314155BF8B9E14AF66417DCEB541D8EF3141E4E79C51FDAF6641173836602FE03141DDB1B71323B16641DE8E2F29E6D33141FCDC60B72AB16641C7F0FD1750D231417D985AF6D6B066413A416587E3CF31413F36F882AEB066417D7B9AF439C43141159A2CAB18B1664151B3E9D879BE31417EC3F7C7C7B0664143161E825BBD314183F043835DB06641016D49D8F7B631414CD121EE5DB066416A854B0730A93141E80B508A4EB06641CB4A2C20B9A7314122DA1065F9AF6641A0552787DEA631416C3197806AAF66414C98A97342A63141C54A243FC4AE6641D47F14DC80A6314167228DF676AE664115859CB77AA731418E150E8731AE6641F4788F9EF1A83141730A56FE70AC66419AA54D0519B73141731FFFACCEAB6641807598B196BC314107AEE8A309AB664190FC876C85C4314126F9B487B8AA6641B864CD5009C93141950376B395AA66414171DBA92FCD31418F5BC1068AAA6641D8F51DFF5BD03141BEE4921967AA6641439C9F9642E93141A4619E226BAA66411D1E1AA5ADEC314136BBBB2AA1AA66417DCC319282EE31415462635AEEAA6641B475659D9BEF31411FA3AC0937AC6641A0750DD87BF031411C22D59464AC66418123EE2C85F331417A6DB91C41AC6641EABF6077E9F93141234F2150FAAB664168630159BE0132412027AE7DF1AB6641457A6B3AC8073241ED9AE20C3AAB6641EEB2C759ED10324136827AC87EAA6641AE3F1CB333163241B590692698AA664113718EDDF517324113F1F8E024AC6641157B2DAFED183241	VN
754	37	CB	Cambodia	0106000020430D0000010000000103000000010000001900000062D352663FED65418B3861D9CE1B3241930BC3BEC7EC6541D0C4CB1E88273241D69A71ED85EC6541D7F7C714652D324188DB7CA557EC6541CEDD08F2143032414436DA5306EC65410D679AD36C3132410BE1A05BCCEB6541DC10D6C5E931324110938425ECEA6541BC09D82EB1303241D83D4B2DB2EA65417C3ADBA7EF303241B3EEEE5059EA65410A4EFF3E28323241F77D9D7F17EA65416F458FE43B34324111365E6518E965417C69495AEA413241669D075A52E96541CED3152750463241220E592B94E9654167D07B5DA24832410C847A9BF8E96541264319E3134B3241C34C17C02EEA654158CBDEAB714B324192EA540AEBEB6541BDA1DA0D0E4C32417E1A8F5144EC65416271402DD54A3241AEAEDAF56AEC654173498B4FFA4932414C0A79CA8AEF65416F458FE43B3432415C731BCBA9EF6541AAD572C541333241E4A76C4BB9EF65418C6EB44CAB31324103D315EFC0EF6541219E18190D2C3241A4AA7EA673EF6541C3B135C043283241761633024DEF65418449EDA64927324162D352663FED65418B3861D9CE1B3241	KH
753	241	VM	Vietnam	0106000020430D0000010000000103000000010000001A000000933A0EB80AB26641DFB779AE06083241ACC1C4CC10B466412E63E324FCF93141B7112E2628B466418A18E8F36BF73141056D443A43B4664162A877A754E631413F467FA637B46641C4E444CEDDE43141FBA0DC54E6B36641FF1D24382EE2314130072F03D4B26641D556F24F5EDA3141C71DAA6673B26641C5C9292DC2D93141603425CA12B26641D556F24F5EDA3141A43C5BDB41B16641E4CB2CCC84DE3141CE48151304B166417C7AA5031BE03141990C15C2D1B06641B1AFFBF10EE231412882C51105B06641BD863EF155EB314140A1DBD4EDAF664194D755346FEC3141560B9724E2AF66418743FA12E6ED314188F2F26C02B06641331912CCA4F03141D9626709E1B06641B883DBDCC1F531417B17838104B1664169BB35E430FB3141D837CA37F0B06641B01A940F4E003241DE8FB3C476B066411C0C873D9405324122DA1065F9AF6641C38D046B64083241F734AC0A1FB166411160D3AAAA0C3241BD66EB2F74B166419BE79D51850D3241EDFA36D49AB16641D3693568080D324130A0D925ECB16641386E1B80580A3241933A0EB80AB26641DFB779AE06083241	VN
744	191	RP	Philippines	0106000020430D0000010000000103000000010000001A000000449F0708706A6A4176A63B49E7073241640AF72BC6696A41C66B7FE5770A3241FB91F68961696A415D7B675E7F0E32416E446C624A696A418A5337784E113241682330D3CD696A415668E43AC31D3241AE2137C7E8696A41F91AEE74D61F32417DF44000AA6A6A4123F1D603BB2932412D152978D46A6A410FBEA8EE8F2B324180F8D0F8536B6A41E1722C427E2E324161B87EA6EE6B6A41FB827511B72F3241AC105036956C6A41FB827511B72F32414DB3ECFE426D6A41C41BDC25842D32414CFA1E9C836E6A41EDBC52D0C62732418AF70C41C96E6A4164F7651611263241D1A03F8BC46F6A411A3B8C4FBD1E3241EC594BE5FA6F6A41AD404E9D071D32411BC3F9B730706A410FE47C107D1932417E24EDE72C706A412164313D4A1732415AE00A9D1D706A41A9BEFE06D3153241BE9A626FE36F6A415533CDE6DE133241F788468A356F6A41D52C48A5790F32412CAF52B8D46E6A419BE79D51850D32419AD93624596E6A41726396E7CF0B324127D5141DE66C6A41BC404E53E1083241135D6892D36B6A417F01EBF625083241449F0708706A6A4176A63B49E7073241	PH
745	191	RP	Philippines	0106000020430D000001000000010300000001000000160000007999AC480FB46A41ADFDC70DC5223241FBBEF33E2BB36A41940071D5992432417749DD20E5AE6A413634A6DCED3B3241CA61519069AE6A417E56E2DF783F3241396C12BC46AE6A4177F367FB4D413241396C12BC46AE6A41A0C7B0B0614332413E854B634EAE6A41E0E52528B04B3241DA23583352AE6A4186623DE8C34D3241EF34AFE07CAE6A415A44D1EAF05032410EC7AD616CAF6A419426321FB75A3241AE056CF606B06A41D45F8FB57A5F3241DE99B79A2DB06A4167F729209A5F324185042C508EB06A415901CFEB9F5E324165C4D9FD28B16A41B5D4C59B4D5C3241A0A22380AFB66A41C22287D76E36324190EB966E10B76A411795637A22333241FA581D7F2BB76A41B47C7E3FD62F3241D585BF2E18B76A4194DAC550012E3241A0A22380AFB66A41BD14FA6CAD263241614CD138A0B66A41413C7754B325324138AE245205B66A41E0A4C6133C2432417999AC480FB46A41ADFDC70DC5223241	PH
746	191	RP	Philippines	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	PH
748	191	RP	Philippines	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	PH
2540	36	CA	Canada	0106000020430D0000010000000103000000010000000900000023D04D5151C658C10AFC7E5BEADC5741908BD9F778C558C126A21E3325DD57412F4A090824C558C1466750C668DC5741667F1FC0B6C558C159E998B4ACDB57412E20B7AA68C658C10DE04BBF36DB5741FDF2C0E329C758C170607850F0DA5741CDC5CA1CEBC758C103CB9B192BDB57415B1B582C77C758C17D0BE4FA2DDC574123D04D5151C658C10AFC7E5BEADC5741	CA
2541	36	CA	Canada	0106000020430D0000010000000103000000010000001C000000519F1BDCF3FB56C1CD6708CDB9F25641A64ACFF2D8FF56C19CFB631FB8E15641DF22AC75550857C126ABD797B2CC56418B0A3806D10857C1142E1399FCCB5641D4BEE4E1150A57C1359F654EEBCA56411C5D9D9AC70A57C13DE9630E85CA5641AA88D84C980B57C12DDCDB3A6ECA56417E60BDF2380E57C1AA53C5FABDCA5641602FA9D3791357C19AFB87AAC3CB5641DCFF32C0491557C1515D838790CC56416D7CEAB1FB1557C18941116E24CD564134078E791A1657C17489239DF1CD5641749D2641781557C11CAD3BD1BECE5641FAFEF199D81157C1A2455A8EF2D15641555403BB760E57C19D800DF615D45641504F284E970C57C11C46912CD2D55641DDC604D3690B57C102759DB033D75641DFCE07BBDE0A57C1CE8F71140CD8564132E77B2A630A57C10AC31BEF06D956417CCBE7626D0757C19C777E10E4DF5641F59696E25D0757C17F9200E52BE4564159340E759E0457C18618DBFE21EB564106CF0DDE11FD56C11C16520D1BF75641765256EC5FFC56C1417CA4CE81F7564132CDD6DAB5FB56C10AD0E027EDF656416F5B6CBA9EFB56C1D260E0F61EF65641F3768493A6FB56C11E50531F51F55641519F1BDCF3FB56C1CD6708CDB9F25641	CA
2543	36	CA	Canada	0106000020430D0000010000000103000000010000001A00000078215126E7BF57C18BB9F5A57DF8564147F45A5FA8C057C1A221993DA1F5564147F45A5FA8C057C1C7A6CA14D3F45641F41B2D7072C057C161DD1E7B37F35641D230AFC72CC057C19C3E135180F25641B196AD5EC8BF57C1D19F77C7D4F15641E0ADAF0274BE57C1F3F575EDB6F0564105A4580EC4BB57C15800832032EF5641BA27EFCA58BA57C1E11DC81609EE5641FEAC6EDC02BB57C1DF51BEF568ED564190C790D81FBD57C18E6B03B08FEC5641CB39C5956BBF57C15B9CCFD111EC56415733AB020CC257C137ECABC478EC5641443EA2023CC957C1E11DC81609EE56417CD638056AD257C1ACB4356394F0564157F9AB9742D357C13AE432A51DF15641416FCD07A7D357C150A95E7FC9F15641363558D122D457C104EDD2B359F35641A3B09DF7FBD357C1669250D327F45641E85F6F6661D357C1F3E9B959F5F456419FC1B6ADAFD257C192D1A4685CF55641EC3647496BC857C1E6F640A812F9564113AE2BF161C157C12F84F0AB80FA5641C0BF09DF98C057C1A74D2D615EFA5641888AF32606C057C1E0668F03BEF9564178215126E7BF57C18BB9F5A57DF85641	CA
2544	36	CA	Canada	0106000020430D00000100000001030000000100000026000000043865D6FBBE56C18D5304189F4B57418C9608B4C6BD56C13C1766A5054D5741F1092EE94BBC56C1743157FD844D57415EC5B98F73BB56C15C6D882D9C4D57417479EA7CCAB956C1E9D9F73F794D5741DFE3F9E310B956C1DB9C1003E34C5741228BC86A01B956C111D394AD124C5741704ABDB22FB956C137861EA42A45574107E8B0335EB956C1693B44A1434457418A99302F5CBB56C1F29136508D3C57418FC85DF9F6BB56C160833587D43B5741A220E74362BD56C1D3AD0D56103B5741C5E1128FECBE56C18DD47B6E7A3A574192587525C2C256C1984271C29339574128B0B52698C656C17382EFCAE6385741FF268E8828DB56C1D609BD63BD3B5741ABE4C7BBE8DC56C1850958CE023C5741F29071AFB8DE56C1CCBC5EB2983C57416311924271E056C1F7D26DBDAD3D5741931436ACF4E056C13BEEAB6B4F3E574193CB5AB106E756C139EDE75EBB485741314A444163E756C161AA351D504A5741CE0874510EE756C1DB9C1003E34C5741AE6E72E8A9E656C1EC74C07FB14E5741DF9B68AFE8E556C1E64946DE304F5741243D49E32FE456C1DA40A26ED44E574195110E315FE356C1821D2AD63D4E57415E22ABF824DF56C17315BCDA00495741E95EFF60A9DE56C11B1746D5474857415600E6B723CF56C1D54A28B6D94457419291A312A2CC56C14447C38D9444574187818039D9CB56C182898DB7AB445741D972CAC637CA56C1CF0D21DF1E455741FA6070EA12C856C1F1833F4DE34557410F29FF1192C456C17BF29308E04757415B156E3211C156C17868EA930A4A57411CE96D48BDBF56C12E5B294EE64A5741043865D6FBBE56C18D5304189F4B5741	CA
2546	36	CA	Canada	0106000020430D0000010000000103000000010000001B000000997EAFD9E0D356C1294E0BDC9E7E5741EFF61975E9E456C11F1544E9F4745741E43383C328EC56C1E37AE8FC0E6F5741B835BAC684ED56C171477CD8266E57413B118C1F3EEE56C183097857E16D57413D0E64A4A8F056C1EAB056CC9B6D5741546EF0D688F156C141B4854AA76D57414D2362EA50F356C19017E2900F6E5741EFD0784448F456C151ADAFAF6C6E57411EE20DE9E9F556C10315A1DB606E57412A43AD0194F656C19017E2900F6E5741F5BC3713FFF756C19460C9AE046D574189FE83F141FB56C1E773387D086857412CAC9A4B39FC56C14AD58F0821665741FE9C9B8F02FD56C1CEC3638C4F66574164F7A4265FFD56C11C56F3B9146757418AC0D3595EFE56C1DBB68598566C574179AEFD8E4BF956C122CE1F146B71574135297E7DA1F856C1C0CCA27BF6715741E693DB922EF756C18B8247B0A4725741843C178046F656C1722BC19A6A7257414DF90F8D95F456C164BC29CA5371574133804AB3ADF356C1365D02B719715741AB9F9DED14F156C1BB356665C87057410CFA897B92EF56C1A46BAB4A48715741F16AD07E17EE56C17974EAFBEA715741997EAFD9E0D356C1294E0BDC9E7E5741	CA
2548	36	CA	Canada	0106000020430D00000100000001030000000100000013000000B17DE4C9893557C16C69B4EEC71C58410B821708C53857C1AA8C5B0711165841ED9B74CC5E3A57C150FDEEFF491358413021F4DD083B57C1EB06B5D2BB12584187284F97D93B57C14B6EB57F5D125841904663ABC03D57C133D7AF8F26135841115A789C533E57C19D3EA52FD81358411D563D3BF44057C135677ACC0E1858415EFD0BC2E44057C1D664A9C5EF185841693781F8684057C106272B94F4195841E7236C07D63F57C1CBF537F2D51A584170820FE5A03E57C1E8FB0CA1451C58411DF3BCF0583857C12693E1BFF82158418EC7813E883757C12AEAE08B10225841AF8BD504A83657C10B766E1C82215841C110D927643457C1BE65D291DD1E58419C5D9E17F83357C114AC3EA92B1E58412492EF97073457C132B9F68A4A1D5841B17DE4C9893557C16C69B4EEC71C5841	CA
2549	36	CA	Canada	0106000020430D0000010000000103000000010000001400000014FA6D52A4A257C19D07B1A9322D584193E6586111A257C1680246348C2C5841D174EE40FAA157C1BAA82E73B62B58412034E38828A257C175621BE5C82A5841773B3E42F9A257C1E1C1D97347285841597FED634EA357C1801532F14D275841D54F77501EA557C14794BBF11F2558411DEE2F09D0A557C13C857D42A9245841B34BDD09B0A657C1F07831FE79245841CCA841C1FAA957C1110619A23E24584197621253B4AA57C1AB1997DED8245841BA4D90FBF9AA57C1A0DE3EFA96255841CAB632FC18AB57C1482D883A6C2658417DBFFA1B11AB57C1801532F14D275841C16ECC8A76AA57C19923C86FEC2A5841EB64929FA5A957C187D03648F72C58419EADA03FECA857C1E37F9D52622D5841C4DED1678AA557C17E4928EB852D58412D812467AAA457C17E4928EB852D584114FA6D52A4A257C19D07B1A9322D5841	CA
2550	36	CA	Canada	0106000020430D00000100000001030000000100000022000000F436F646F32757C17684B1EFB13958418FED226F292857C1BD245E21BE3758410EB0BB20DB2857C15881AA4AEF3158418FC3D0116E2957C168BA3B6519315841C5DC85A7632C57C1835CF23CB52D5841096205B90D2D57C177AA55D51A2D584134C7FF2C674257C1364FF5D84B22584111A704C45B4657C13442578552215841A1CF17FB964957C1B096FA59B82058411EA0A1E7664B57C1B096FA59B8205841718EC3F92F4C57C1609951E4DB2058419439FB21274D57C1BBE873063B215841A4A29D22464D57C15BB526CC042258418E046158824F57C12E235F1AC63058415076CB78994F57C19F9568EB8F315841F7666DD7534F57C116AA71F1713258412CAD9C459A4E57C152A85B0EDD3258412318AAACEF4557C18660D1F253335841D48207C27C4457C10ED5620D792F58419B0DAB899B4457C1ACCCC59E7F2E58414C4EB6416D4457C1FFB6AD4DC12D584167F1CD78104457C187D03648F72C5841F5465B889C4357C1B34B37E45C2C58413F017563EB4157C1396B49151C2B5841216F76E2FB4057C19923C86FEC2A58412CD33D763B3F57C1D7F9B9F4D42A58410812122BB13D57C1A7C23C7E572B5841DF59FCAD653B57C1601BC7A7682C5841B403DEC9303157C184E6E5FF0B3558416FABD890D72C57C18C3F0C69ED3958415F6C88ED732B57C19966B528FF3C58414B14FFA2082A57C1BA19B0DF103E584184B3AD38A52857C1BA94A77BC33E5841F436F646F32757C17684B1EFB1395841	CA
2557	36	CA	Canada	0106000020430D0000010000000103000000010000001C000000524674CB44125EC1BA11816E028C5641D9F1A3D017195EC1F296A2BB55815641D604536F361A5EC1F7D2E40E25805641D3D2FD29061C5EC14B0789CF8E7E564177CA783070275EC1429CC34AD1775641BAE55F64102A5EC1C8BEC115747656415BCBB956E12A5EC128F2922B2576564132A87969612F5EC1C189EC0D00755641B880234785325EC119762A678F745641C7A97FC755335EC11B2C693F84745641207997E84C345EC1076EB897BC745641105E2CA39A345EC181C72EB6707556412BC9004264345EC11A82A7A46876564125D21610A3335EC1122BC4784D785641699A041D31315EC1B3A6E416177C5641C6164020F52E5EC14B0789CF8E7E56413580E3DE951F5EC1C820E80C158B564133EDA337351B5EC14B7B6EAE648E564125D8A5F18C185EC165F7CF821D9056419CCDA6CE38175EC1FC098E64B0905641F2D729039F155EC1740B10EDE8905641D02CF2DAA7145EC1FC098E64B0905641C80EDEC6C0125EC1537EBDB2E48F56410ED7E8DC2D125EC103BAB7585D8F5641D1325FDAB1115EC17675B3D2B38E564182736A9283115EC111903E07DD8D5641D54B9881B9115EC13FC6CD06FB8C5641524674CB44125EC1BA11816E028C5641	CA
2559	36	CA	Canada	0106000020430D0000010000000103000000010000003900000089A4FCC811A75DC1BCBC79B0B14757410BA308EC17B15DC19A6917E4D24F574104587AFFDFB25DC1501A96D9B9505741195937143FB95DC1360BEA13AA5357415F1BD52AA2BB5DC120F2940F865457417B949A048ABC5DC11FBE6EAFA85457412AA350772BBE5DC1A5AE356563545741CB26157467C05DC1360BEA13AA5357415756015352CF5DC113CDCAF45357574168CD948E8FD05DC12FA1C3C780585741DD3C9C6B94D35DC10A1A1897955A5741249DA48C62D75DC18826B7132A5D57410FCAEA01D9DD5DC167BD3FE92660574149A834845FE35DC1AE751994816257411BE6C1EF30EC5DC111617417736557416028D305F7EF5DC14AD58F08216657414C4728404FF55DC1DE599DC3A06657418D3094443A0D5EC16E74A515AD6557416B2CFAFDCB0E5EC1262CDE94446557413C3F4AB7DB0E5EC17ABE6FFA916A574108EB290E770E5EC1CFD126139D6B57415BC357FDAC0E5EC1709FE1DE6D6C5741CC6DCAED200F5EC18D8FA577106D5741AB6930A7B2105EC199EA8D12046E574160E844B9431C5EC158BAB9DD8D715741670D3275DA295EC1A7E3FD1BD274574161C2A388A22B5EC18D7A07B50075574135EE2CE9B92B5EC142FE7F82237557416C66B19C30295EC168886128237757410F302919C5275EC1F2FC4A6ED17757412D2FE8F253245EC1E109F671E87757410A980E0585215EC11B18BA0B80775741111D9C5C860E5EC180DF0DF58C735741C176C3B2800C5EC1294C9506F672574197945BD8790B5EC1B0AE7EF6657257413F770CFC150A5EC1DFB2265E82715741C3BC7632D9085EC173082A4C5470574170AB1A56C3FE5DC101493EDF336C5741BE03DE263CE85DC1780CCEFD65675741E7F9A33B6BE75DC1DEDDC67971675741EA5F8BEC5AD75DC1CA50EAC999615741BAC44B1BF8CB5DC1DC01303A2D5A574183D2C06728CA5DC12702C0AB455957412FF5B70B13C85DC12FA1C3C7805857417EFA5FD399C45DC1F609407C1858574188CBE7BF78BE5DC1F609407C185857418B43F08401B95DC125B5B32251595741B2207DF228B85DC176D860E45C59574197A7B71841B75DC12702C0AB4559574189706A5D52B55DC158C0C55B755857413F7D229523AD5DC1868DF1A316515741FEBF5FEB9FAC5DC1C48316CA8B50574127B62500CFAB5DC1E64946DE304F5741F5A14BD7B8AA5DC1BCDA8CDDF94C5741DC68CC7D1FA95DC1014F61EF384A5741F2DCB6EA27A85DC1A7A27EB8E948574189A4FCC811A75DC1BCBC79B0B1475741	CA
2560	36	CA	Canada	0106000020430D000001000000010300000001000000160000007100758CB6B25CC1919FB3CA518D5E411332EFFDE9AC5CC1ED3D80E6DC875E411572357E38AC5CC1A6A008851D875E41E5364E7CDBAB5CC175E3509423865E4135F642C409AC5CC112DCFB20FE845E41B60958B59CAC5CC15CEB993FD8835E411C10BD9182AF5CC149E354844F7F5E41E0971BD52CB05CC187749749737E5E414F507F00BFB15CC1619C3DD5F57C5E415F657D4667B45CC13CF29269957B5E41C5AB28A39BB65CC13CF29269957B5E413C5B7600EFB85CC1491423D8B27B5E41F120D02403BC5CC1302797345C7D5E41CD4343B7DBBC5CC17BA9886C0C7E5E41296CDAFF28BD5CC181764A88237F5E411E1C71A611BD5CC14CD336CF1C805E41BDDAA0B6BCBC5CC15A21EEF05F815E41142BD76A7BB75CC12E4FD231EB8C5E4168434BDAFFB65CC1337D34CFC78D5E41427A1CA700B65CC157F958E71F8E5E41C0A64D36BCB45CC1CB6AECE1F38D5E417100758CB6B25CC1919FB3CA518D5E41	CA
2561	36	CA	Canada	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	CA
2562	36	CA	Canada	0106000020430D0000010000000103000000010000000C00000038C5E845CA1C58C1E228C0B3535258412351FED8C11D58C1FFBEE2AA3A505841E3BA6511641E58C1AED333B8AB4F5841B28D6F4A251F58C1F13C51F8634F58413A6E1C10BE2158C1CBA11D8D044F584119AAC8499E2258C10C0A2A0A4C4F5841F3B647B9E32258C19C6E3AEB16505841BC813101512258C1FD8F3ABED550584177FCB1EFA62158C1BBF32F03655158417110F320F01D58C196F74C001F5358413BDE21EDD11C58C1F3438BB45A53584138C5E845CA1C58C1E228C0B353525841	CA
772	191	RP	Philippines	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	PH
781	37	CB	Cambodia	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	KH
2563	36	CA	Canada	0106000020430D00000100000001030000000100000017000000D8DCD9E97A215BC13E887C9C29A058410305F543DA1E5BC19FCDF7CDCE9D5841BF7F7532301E5BC1C1DD22F0319D5841C6A0B1C1AC1D5BC185326A75899C584174C883D2761D5BC13645B2A5BC9B584100160EFA8D1D5BC1CB5244BBCB9A5841D60954C2CB1D5BC1D9822EBCC2995841BF7F7532301E5BC16811B99FA198584119658176BA1F5BC1933164151198584160112B6A8A215BC15E0060011D985841442ECDB298225BC1A8A5D62D59985841E3C2AA6588235BC1512D10B2C598584139CA051F59245BC1248C31534A995841B2ABA8C1DC245BC15B3E340AF3995841E1A64943EB255BC1ADE4B2D1289C58416CF4D36A02265BC1C0DDB6D80D9D5841E1A64943EB255BC11B195EC9FE9D5841C00C48DA86255BC1CA431870209F58410584D6B012255BC11664A87011A05841C1FE569F68245BC1CE15DAE295A05841F644860DAF235BC1DCEBF74BEAA058411709DAD3CE225BC17910737802A15841D8DCD9E97A215BC13E887C9C29A05841	CA
2565	36	CA	Canada	0106000020430D0000010000000103000000010000000C00000048105B0914CE58C11E96C927D44F59415D9A3999AFCD58C13E74FDA70C4E5941D044AC8923CE58C1D78DBBDDEB4A5941B74AC81C74D358C1AB989C23FA465941B9AA20EC79DE58C1FBA37ECB174959410451DC8CA0DE58C16B3E12A6F5495941210D2D6B4BDE58C1C65BDF0EF84A5941DE87AD59A1DD58C17105F705984B5941BD2229B102D958C114363FFC714F5941EE4F1F7841D858C17BC23093055059415CA82AD4CDCE58C10C5F40E52051594148105B0914CE58C11E96C927D44F5941	CA
797	178	PF	Paracel Islands	0106000020430D00000100000001030000000100000009000000D09DA6FB409C6741950140FDBDF83A41C578DA731A9C674155AB8FB49DF93A412396F72A1E9C6741BE778FCC5CFB3A416DE34E297B9C6741A0370366FBFD3A41A6388821B59C67413D6E5C97BBFD3A41CF241F19D09C6741ADBC0E197CFC3A41C66331C5BC9C674143EB85C31CFB3A4128BAAA636F9C6741D7F6B3E65DF93A41D09DA6FB409C6741950140FDBDF83A41	PF
2566	36	CA	Canada	0106000020430D0000010000000103000000010000000E0000002E588C37EB2358C16BDB262D0E115B41FCAA09700F2658C18DDFB839150D5B41D201D082E82E58C14A146DD5540A5B41D9ED8E519F3258C1DACE41644C0B5B41A28BFEC0BB3558C1889BE9E209105B4184CFADE2103658C1628DB5E7DA105B4165FD68E1D23558C1848AF4DEB8115B41A8AC3A50383558C1567C3D8F89125B41DDF269BE7E3458C10639F28833135B41F4A69AABD53258C12DE6F84E38145B41676D6EBEE63058C12DE6F84E38145B41D3DE95B89B2558C1B4B7514726135B41BB57DFA3952358C11D34633621125B412E588C37EB2358C16BDB262D0E115B41	CA
799	178	PF	Paracel Islands	0106000020430D0000010000000103000000010000000A0000001553AE8E3BB86741481F3F6720253C418E3306BD89B76741A5CD82FFE1293C41DCE780736EB767410CCDABA1022B3C41CC257AD085B767411FC754AAE22B3C4163C36D51B4B76741C08232EC222C3C41D2AD0B3DEAB76741514BA67AC22B3C41720CED112CB8674158D7FE40222A3C4183D96D465EB867411726BC57E1273C412AD5893662B86741D57497C400263C411553AE8E3BB86741481F3F6720253C41	PF
2567	36	CA	Canada	0106000020430D000001000000010300000001000000170000006941733078CD58C1C4CA2C280D495B41DF83FC2C87CF58C1C866DC5967455B416F00B41E39D058C1E782BF41BC445B41055E611F19D158C1C9879BE145445B41F7E060E4D1D258C172585E7EB5435B41F23E06C28DD958C141BFBC61DC415B41D693EBA275DA58C1DF01DBB1A7415B4186AAA4FD8BDB58C18A122B08B5415B412958BB5783DC58C1AA7ED0B9F6415B4166BCFED9B0DD58C11360EDAF6C425B4199D8DBEA3BDE58C15573DC630A435B4199D8DBEA3BDE58C12990DB841E445B41B062BA7AD7DD58C1845ECA4818455B417B46DD694CDD58C10C4C012112465B41C01F01366DDB58C18D23E64054485B4108F336AFE4D758C158317F7B5C4B5B41FEE880D525D458C1164A9A00854D5B41B6741A7A2FD258C1C4F57024FB4D5B41A735CAD6CBD058C1160DA35DAC4D5B410B00BC415DCA58C17F69C264074C5B411121F8D0D9C958C1DC73873C914B5B4183CB6AC14DCA58C11F8CF0F5CB4A5B416941733078CD58C1C4CA2C280D495B41	CA
2568	36	CA	Canada	0106000020430D000001000000010300000001000000160000000812B5BA245258C19C12489BB2A25B41B0F1395B864E58C1104FC2B84B995B41BB41A3B49D4E58C1C382B9EE76985B4166372080375058C1C6B99B8CA2975B4111D9F8905A5458C1DE87DBAED1955B4173F07623F45558C14729F85B3F955B41F5D939B7CB5758C115F8AA75EF945B4100118772BA5958C10EFAC75BE2945B4127DAB5A5B95A58C176E7F14132955B4124D2B2BD445B58C1186E1C438F955B41685732CFEE5B58C1F20767FF48965B41BE4D57C92C5C58C17CEB96F552975B41C67FC9173C5C58C171E605DF34985B41633EF927E75B58C18F04EDF5479A5B4182FA4906925B58C1D370EC9A5F9B5B41126C3838BB5858C1AAE58AAC65A15B41A0F908E0205858C1037F90E662A25B41D33F384E675758C18FC781752AA35B416F3F40718B5158C1601214F623A55B4157A42B225D5158C14A026A8934A45B41C94E9E12D15158C18FC781752AA35B410812B5BA245258C19C12489BB2A25B41	CA
2569	36	CA	Canada	0106000020430D0000010000000103000000010000002E00000071E5C408C69A58C148E8AB9E7AE25B41EB59A752AA9F58C19F360FEBB9DA5B4149823E9BF79F58C1EA8DC2610BDA5B412FDF266454A058C1C5565DB4C3D35B411A7F9A31749F58C14BEE3ACFCDCD5B412F0979C10F9F58C18D87CDF41FCD5B41C8987B07209E58C14C8E322005CD5B418513FCF5759D58C1DA6D65FC47CD5B4102382A9DBC9C58C1BB24BED7F5CD5B411CDB41D45F9C58C1EFF050A17BCE5B41F1FB0175EE9858C1C6F62609C7D15B412299FD18419358C1F225880359D35B4153C6F3DF7F9258C18272257B73D35B411EAA16CFF49158C18533450D16D35B41290EDE62349058C195C6AB3041D15B41062360BAEE8F58C1093EF44193D05B418E57B13AFE8F58C177FC69E9BCCF5B41591182CCB79058C18FCB464DB1CE5B4108F6E5E19D9358C1DD11AFA221CC5B41D7C8EF1A5F9458C176C7BEE39BCB5B414E6EFD69AEA358C1A3CFEB3307C55B41EE02DB1C9EA458C1AA0468CCB6C45B415373D8D68DA558C1BDBB139581C45B41BEAB92F8A3A658C197E265D08EC45B419845E40F40AE58C1A3CFEB3307C55B413701ECA455B058C14C14BD3957C55B41566998C889B258C1B6A9B3B41FC65B418061F4C523B458C117B2370F53C75B41A765AB1571B458C189EFDD4DE6C75B41DCE1F1E6F1B358C12D8E69ACE1CC5B41FA53CD273AB558C150961836FBCE5B410208495E17B958C161CEDDAE3FD25B416549194E6CB958C18533450D16D35B413624266FA2B958C13FDFD19F06D45B4142748FC8B9B958C1ADB8374EDAD65B4142748FC8B9B958C14225552735D95B41BA3F3E48AAB958C1550E2A29FED95B4177BABE3600B958C139487F3090DB5B41DE540E4EABB858C17E9CB03716DC5B41D0F36E3501B858C188FF7D55FBDB5B417E5540B194A658C1A0DAC6F2F7DE5B415B0742BEB39D58C19520B5A9D7E35B41C4BDF2F7FB9A58C13DDE14A6F1E45B41E9B07388B69A58C134D84494AEE45B4153138007889A58C11CCE72C0BCE35B4171E5C408C69A58C148E8AB9E7AE25B41	CA
2570	36	CA	Canada	0106000020430D00000100000001030000000100000017000000545A358141E958C126660AB8A4F15B41A772A9F0C5E858C19DF9E38406EC5B410FD5B56F97E858C1462D1DEE31E85B41E2AFC290CDE858C1ABDFBD185CE65B41D7754D5A49E958C1620B51C078E45B41E0BDB3CBEBE958C14F2C078E94E35B41275C6C849DEA58C1319BC2DCE5E25B4142D5315E85EB58C1A917FE6EB0E25B418D08C0A602F358C116C1879636E35B4186E7831786F358C1B3509FDF43E35B416C446CE0E2F358C19A199DB91AE45B41219EB03FBCF358C12BAB4C2427E55B412CD8257640F358C1ABDFBD185CE65B41D22797F27BED58C1A1F0A0CFF4F25B41E27A45D007ED58C1D305A574BEF35B4199DC8C1756EC58C16D951D966DF45B41523ED45EA4EB58C1636CBECBB0F45B4137C50E85BCEA58C1CA618766E6F45B41794DB611FCE858C1E6FEB51CBEF45B41AE93E57F42E858C1C8A2B0542AF45B41EB217B5F2BE858C1E09F4AF952F35B411C251FC9AEE858C1B3096AAD60F25B41545A358141E958C126660AB8A4F15B41	CA
2573	36	CA	Canada	0106000020430D000001000000010300000001000000140000001EB150EFD58D57C1D2DA307F8FFC5841683883F2C99257C1D0F8D1CE09F25841F55BBBBC259457C1763E1DCAD9F058419F27E62A049757C10949CDB4B5EE5841E3AC653CAE9757C174AB4FC760EE5841EDBC8815779857C153BC1B9917EE584120E75661209A57C127CDB2BBDAED5841C1946DBB179B57C160E374320BEE584101A2E40739A157C1C2420D945FF1584149409DC0EAA157C1F85FD62B16F2584193E6586111A257C1F26306D3CCF258414743C53B809F57C1C7B591D5FCFB5841164021D2FC9E57C123336F7B15FD58415AEFF240629E57C107242063CCFD5841AC06DEFE618D57C1161B3F9446005941928D18257A8C57C1ADB5D327B4FF584124FCDEDB0D8C57C1A030E18EFDFE584199AE54B4F68B57C1191E765409FE584196A651CC818C57C1419859023AFD58411EB150EFD58D57C1D2DA307F8FFC5841	CA
785	218	TH	Thailand	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	TH
792	191	RP	Philippines	0106000020430D000001000000010300000001000000180000000798EFCE30B66941ED2EDD2004D93441CC7E6EE2EDB669410620088D9CCC34411F6361D7A2B8694162EC2E4B87AE34411F6361D7A2B86941D17CA7154DAD3441DA39BD1197B869410A48070471AC3441D1A36C8F74B8694143F7C80F95AB344124F521611BB8694195F6BA3E17AB344188CF9C7388B769418937F2CF36AB3441985862B44EB769410A48070471AC3441A046CAE0B2B369419A127611B3C73441754FB9574EB36941D395954262CB34412C0DDCEA3AB36941EBA1B03759CD3441F4B7A2F200B369415577FF6F50D63441DA34AEFB04B36941BCD5CA9C1ADB34416249DC3B6DB36941570A5D1ECAE5344166F190E878B369414623335B67E6344121B343740FB46941863F7AC6E0E734419F31213255B46941EBCC0B047EE83441AAFD8817B2B4694171FA9E429DE834418599838CFBB46941AC21FB2F3FE83441899D1385A5B5694155C8D7B450E4344175973669C4B5694103B9F6EE35E33441460E6556E7B56941FF276C6CA1E034410798EFCE30B66941ED2EDD2004D93441	PH
794	191	RP	Philippines	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	PH
791	241	VM	Vietnam	0106000020430D00000100000001030000000100000012000000F6DCEC9CBC366741A8340CB1B0C7344112318428103767418D704A5459C63441B5F3433165376741C62051557DBE34413680E00469376741DA0D2FD1E4BC3441AF4B8F84593767411E46AE91AABB34417A2FB273CE366741FE02D40DF7B83441D5D66FC3F63467410F7832C962B634412A73E5A6353467414381F73E9DB734416913AD8BA7326741477AC1CE93C0344115AC03976D32674136F60BE94BC234416EA56D1520326741DBBA2A69F6C63441C19DBE44FD3167415E9358BC4BC93441256390A80C326741136F560586CA34417D0E10163F32674167F9310FC5CA344114F480A8E3346741519FBF98A5CA3441C0D092A715356741F687DAC866CA3441E95996DF52366741686D179D6FC83441F6DCEC9CBC366741A8340CB1B0C73441	VN
793	241	VM	Vietnam	0106000020430D0000010000000103000000010000000B00000063F8CA86F2396741BB80605DF50635415A17BAF2373A67418386333BA40335413AEC104F303A67416B652D210B023541302B23FB1C3A6741B18647B1D00035410197D756F63967417A005A0253003541CC5AD705C43967414F57CCD991003541E060B421A5396741C932EACB45033541A36E400EA93967417DE59AD12F083541169DB472D73967417DE59AD12F08354131481C3CDC396741A8166CAD7007354163F8CA86F2396741BB80605DF5063541	VN
795	191	RP	Philippines	0106000020430D00000100000001030000000100000019000000F8C73FBD8E8969416776D77C554937417F315D2CA3886941649C5502AD563741519D11887C8869410B80D05F285837417690921837886941799900A0C359374103EF03D1A1856941BCBD66761B673741F50963443D856941194C4B4238683741E023A968038569413C447B7577683741FA42BF2BEC846941C0D0FC7C1868374187984C3B788469416C94BBA1B96737418970F269A9816941A8FE84505A723741AFD1804B8B8069414E6D1BCCA17A3741317E405F36806941A4DAD73A377E374143606A42C67F6941F81D73FD2584374152D33B60F97E694183F39C97C7993741089CD8842F7F6941432FFF609F9C374108872FD6D17F6941D671568E15A0374103CAD17A68806941D65004B3B3A03741715B0BC4D4806941D671568E15A0374115182CA8BF82694155923739A29B3741973EF2BBC386694128A08365EF8B37417261654E9C87694157B2DE497C873741C9733A99B68869410F31708CD57E3741699D4F7FF3896941C93BD4B6826F37410194A7A2EB896941B8017BEBBE503741F8C73FBD8E8969416776D77C55493741	PH
2574	36	CA	Canada	0106000020430D00000100000001030000000100000013000000255F5F26A99457C10A40F006341C594143C70B4ADD9657C1C98F667EDF0E594148F63814789757C12F1319CA1B0E59412B4B1EF55F9857C10DD643B9DE0D5941066E9187389957C1A7A8A248030E59413050F9613F9A57C1FCAAD4F4640E594133158E4ED09C57C1CD51BA111D1059417179D1D0FD9D57C1484075507F115941194824BA719E57C19FE16B0A371259415BDB94063AA057C1A9FED72331195941508B2BAD22A057C18220180B021B59414743C53B809F57C1917D0BA3B91B5941790A133D8E9857C11C4D0314BD1E5941A61ED05CC59757C1EADE4D51FA1E5941CAFB5CCAEC9657C1A3741A001F1F5941F9609629059657C1979427E0121F5941E1AF8DB7439557C15E21C573731E5941731E546ED79457C10F01B6CBBB1D5941255F5F26A99457C10A40F006341C5941	CA
811	178	PF	Paracel Islands	0106000020430D0000010000000103000000010000000C0000002CB50D3966F06741F63B02F80C823C4175EC701430F067412D4964826D823C414658257009F06741CE236B8D2D833C41DE6EA0D3A8EF67417F250FEA6F863C41D8C6EB269DEF6741C727F3CE30883C41E3EBB7AEC3EF67417FC18E53F1883C41FEA4C308FAEF6741B68D1C5B91883C4116A4B68B3BF067416251521AF0863C41C4AB655C5EF067416FD0BB43EF853C4151886B8979F0674125D24691AE843C419522944981F06741CE236B8D2D833C412CB50D3966F06741F63B02F80C823C41	PF
812	178	PF	Paracel Islands	0106000020430D0000010000000103000000010000000A000000AFF06CB847DA67418292B63808D23C41C99384EFEAD967416F1D023649D33C41C4166D14D0D96741FAED85348AD43C41AA68DB4BE3D96741D3B8C656EBD53C41F927D09311DA67411D99535C8CD63C412C39331353DA67418CC68C08ACD63C41FDAF610076DA6741299608488BD53C41E845A6B081DA6741835251A6E9D33C41803CFED379DA6741166DDD5A28D23C41AFF06CB847DA67418292B63808D23C41	PF
2576	36	CA	Canada	0106000020430D0000010000000103000000010000001B0000005CC4561DE17857C11801467BC8CB59415CC4561DE17857C11271C6EE89CB5941EF08CB76B97957C103567DAB24C959414B3F53FA247B57C159AAE233DEC55941564F76D3ED7B57C1F50040371CC459416DACDA8A387F57C1866A0CC09DBD59419CA77B0C478057C1D49F46E0DBBB594127CBB3D6A28157C19D6AC3E064BA5941A8DEC8C7358257C1B769E30E01BA5941360A047A068357C158975549B6B959410BF6465ACF8357C1C7C60090A9B959419821820CA08457C1A3D99803E8B95941AA3358D7B28957C165D7A20978BB5941BA9CFAD7D18957C1A38C78D3C2BB5941CA059DD8F08957C17B2357581ABC594142D14B58E18957C17B95E41EAABD59414C0BC18E658957C110254A5946BF5941EEE22946188957C190DD9CB0E8BF59419D50AFD63A8557C195E1E61EC5C559416040100F848157C11110F6F26FC9594192DD0BB3D67B57C1FA830AC99ECE59418ABFF79EEF7957C161833BC016D05941BF05270D367957C17539D59E48D059416B1705FB6C7857C1FEC54AE0F0CF5941DBB0412C4E7857C1D55F462E99CF5941910A868B277857C10F0C7B3FC4CE59415CC4561DE17857C11801467BC8CB5941	CA
2577	36	CA	Canada	0106000020430D0000010000000103000000010000001500000098193758C6B057C1B38C8AD59D915A4114339C3F84AC57C17B0DDC4F758E5A41901784667CAC57C1D32D4BD9A78D5A411D7B02B126AD57C156981A05F2885A416C3AF7F854AD57C1835EB698F1875A41FDB6AEEA06AE57C1BD5DDF9E4A875A41F5B8AC25D7B757C141801D12BD845A41934D8AD8C6B857C1398EE0C2C9845A4135FBA032BEB957C1495DCF8F56855A41BA27EFCA58BA57C111A747D6F0865A416D30B7EA50BA57C193F71388E4875A4187D3CE21F4B957C12FA510C7E5895A412592FE319FB957C1DCE2F755F38A5A4121A317E852B857C1CA657679288E5A413C462F1FF6B757C116336FF7E88E5A41FCD9E8B453B757C1B0C5B723B68F5A41B268AAD4F2B257C1C9F28F1D78925A41D74537421AB257C1033DCB1DDF925A4105AB70A132B157C1787D9B5DC5925A41D25650F8CDB057C1BD50F63C2B925A4198193758C6B057C1B38C8AD59D915A41	CA
2579	36	CA	Canada	0106000020430D0000010000000103000000010000001600000085E1BF5C12BB57C17E4F53AF21DA5A4108E7E31287BA57C106CE49782EDA5A419CDECB4457B357C1026AACE5ACD95A41F46E487964AD57C1CED03939D7D65A41779EBE8C94AB57C11BF95139BAD55A41B1052A8A57AA57C15BC1E07876D45A41B51E63315FAA57C1C534C87E8DD35A410CCCAC30AFB057C112DF4A1D57C95A41C81CDBC149B157C1422D0900E3C85A41AB71C0A231B257C1229349B009C95A412E27F1CA49C257C1B3678371E9CF5A419497EE8439C357C1B477D9649ED05A416648A948B4C457C155254023BED25A413A34EC287DC557C1CB1069805CD45A41BE4F040285C557C1A0EB1AE72BD55A4161276DB937C557C1CDF19B59E1D55A41A0E757DE50C357C10E93AB7D99D75A41C095B781DDC157C13A12459BB6D85A4169CEA2485BC057C1026AACE5ACD95A418FAB2FB682BF57C1A4A51DDDFAD95A4137A4D4FCB1BE57C17D87F5B107DA5A4185E1BF5C12BB57C17E4F53AF21DA5A41	CA
2581	36	CA	Canada	0106000020430D0000010000000103000000010000001300000096A27400C0E159C15983D1CD2EA55C41150D56275FDD59C1052A3340F29E5C417A5629FF28DD59C127DD525BFA9D5C417335ED6FACDD59C10FA5064FE79C5C413AD6845A5EDE59C18FE2669A349C5C41979F4C852AE459C1B434B9A45B995C41A1BD609911E659C1859FE65EED985C4152D419F427E759C1053D34F008995C418A1F24CF4DE859C15D1F8FAF4D995C41227DD1CF2DE959C1C7FFEC470E9A5C41E7C1C117F4EC59C11F9B41697B9F5C41E3B9BE2F7FED59C15B50596265A05C413EC91CD1C4ED59C1E886F6BC33A15C410362B1D301EF59C192688EDDBDA65C418667D58976EE59C1550B9E46D1A75C41C20E870788EC59C1C6081F1C16A85C4185AA43855AEB59C104ACFEE5ECA75C413977B53CDDE359C1213587605DA65C4196A27400C0E159C15983D1CD2EA55C41	CA
2582	36	CA	Canada	0106000020430D000001000000010300000001000000180000003B3AD622E3CB59C18D5CB00766A55C41BE9EC9F6D8C559C1F3BD6E1229A45C41024E9B653EC559C1EAAC93D283A35C41500D90AD6CC559C177D97BC099A25C4149EC531EF0C559C1EFA5A08886A15C411AD5517A44C759C1D3368BCFDB9F5C416C832D0CBFC859C13DA0ECDC919E5C415CEACBAEDACC59C16784DBF3739B5C411509A5FA44CF59C11E8D785CA59A5C415E5E82B808D659C1BA17F5A1B6985C41A1B9AF6CF7D759C1AC0FA9F071985C4161F9C447DED959C17499EBC348985C41A38C3594A6DB59C1EFDC9D5464985C41E711B5A550DC59C1859FE65EED985C41D187D615B5DC59C1C12C6E91BB995C413AEAE29486DC59C164E44652B39A5C4186EC45D898D959C1A953E70CB6A75C411D74453634D959C14CFD1C16D7A85C41695A4757A9D859C1F32AB8D97CA95C41D6FFDEDA3DD759C18997CC9CF8A95C41468A3F7CFACB59C1550B9E46D1A75C412DD9360A39CB59C1B8820D658CA75C413D42D90A58CB59C1ED5EEA7BD9A65C413B3AD622E3CB59C18D5CB00766A55C41	CA
2583	36	CA	Canada	0106000020430D00000100000001030000000100000017000000D20A69AF07F159C1ED2CD8D4B1D35C413EC91CD1C4ED59C1371D863EB1D15C4126585ADF51EC59C1E17E3B2C8ED05C41EDD321174CE159C12AFB635B18C55C41608697EF34E159C108872B3B2DC45C413CBD68BC35E059C1C316F730B7B55C41BFD880953DE059C1B2ACFE35DAB45C41DD6A7F162DE159C1EA4DA798EFB35C416E2065F5BEEB59C1D3F32AA7AAB35C41FF1E26CF3EF059C1B2ACFE35DAB45C41A06D6D0BB5F659C11512DD76A1B65C4131968042F0F959C16F4862DB31B85C41A62FDA7CB0FB59C1DA550E3E38B95C4170CD49ECCCFE59C1B6AF18EEA5BB5C41A3E926FD57FF59C1A487C2B682BC5C41FBF081B628005AC167142447F0BE5C41A9D80D47A4005AC14733BB2DC6C05C41B42877A0BB005AC15A725C2242C35C41A9D80D47A4005AC167FC0BA656C45C41E76EA60E02005AC1EC67C442B0C55C41BD8C3E34FBFE59C16145C4E32CC65C41FE22D7FB58FE59C1679CB7AA56C65C41D20A69AF07F159C1ED2CD8D4B1D35C41	CA
2584	36	CA	Canada	0106000020430D00000100000001030000000100000019000000CA3999F6C3225AC13A3D9522DAFE5C41EA54B9F2EF1C5AC118E917BBA0015D41B422E8BED11B5AC157A9FE33F4015D41D5E63B85F11A5AC157A9FE33F4015D418E4883CC3F1A5AC1B8FB11C684015D41FC7314507B145AC153C2620D13FC5C4113FEF2DF16145AC171C3795334FB5C418BC9A15F07145AC1F497605839FA5C415354452726145AC109E4A32449F25C41BFE57E7092145AC1BE7A8DC26AF15C411E240ADC72155AC1ED7EDB4C09F15C41B422E8BED11B5AC14BFEBC5606EF5C418B8FA2F43D255AC1091F8F1217F15C4141BF94F65B265AC19B4C6F8878F15C4124EA277A88285AC1EF6C7EF180F25C4133760445F4315AC19D1009B965F75C41B12D72939B355AC11A977119F4F95C41433FFF14193D5AC1A908DA7DCA015D41F1268BA5943D5AC1F635650A64025D414F4F22EEE13D5AC15079222D35035D4193FEF35C473D5AC178079D98C0035D41C74423CB8D3C5AC178079D98C0035D4113E405C404315AC121C338B0BC015D41ABCAD43F212B5AC1ECA03BEFA5005D41CA3999F6C3225AC13A3D9522DAFE5C41	CA
813	178	PF	Paracel Islands	0106000020430D000001000000010300000001000000080000005BEDA1F720DA674128AD67CBF7043D414B2021C3EED9674128AD67CBF7043D41DE99610BCCD967410010598EF8053D41DA802864C4D96741990848487A073D41E9BE2D93F2D967416AD604667B083D415BEDA1F720DA6741C1B20DDCDA073D41A52F7F6434DA67412DAA8C6679063D415BEDA1F720DA674128AD67CBF7043D41	PF
821	26	BM	Myanmar (Burma)	0106000020430D0000010000000103000000010000000B000000CC3640299ABC6441F301CC0029983A41154E80C4BCBC6441C088119D22933A41A743BF98DFBC6441FAE835558C873A4125B722C5DBBC6441A6EED7B0CE843A413F5A3AFC7EBC6441D4189604F8793A4110C6EE5758BC64416B671BCC967B3A41ACF5A262FFBB6441B5CB222CA78D3A41A8DC69BBF7BB6441D7C6A2D7A4903A419372AE6B03BC6441BE5C899A599E3A414FC3DCFC9DBC6441AC80C1577A9D3A41CC3640299ABC6441F301CC0029983A41	MM
820	42	CH	China	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	CN
803	191	RP	Philippines	0106000020430D0000010000000103000000010000000D000000CAF7CE2C6AEF6941C022763EFBCF36417709AD1AA1EE69413E611E4A14D23641A6927E2D7EEE694159584EC872D236418C68EED84BEE6941EA182790EAD436415CD4A23425EE694139131F8EBAD93641FE8BE8AB30EE6941DEAE7DA6D3DB3641074DD6FF43EE6941FD5FEA2632DC3641E4E8D0748DEE6941B9B98209F3DB3641F8607DFF9FEF6941910201E5EDD3364101226B53B3EF6941EDBB8590F4D13641A0EB14F5A7EF69412EBAC94AD8D03641D51C9BB490EF69419301B0BD1AD03641CAF7CE2C6AEF6941C022763EFBCF3641	PH
824	129	LA	Laos	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	LA
822	241	VM	Vietnam	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