///////////////////////////////////////////////////////////////////////////////
//
//  Copyright (2008) Alexander Stukowski
//
//  This file is part of OVITO (Open Visualization Tool).
//
//  OVITO is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  OVITO is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
///////////////////////////////////////////////////////////////////////////////

#ifndef __ATOMS2POVRAY_H
#define __ATOMS2POVRAY_H

#include <core/Core.h>
#include <povray/export/POVRayExportInterface.h>

#include <atomviz/atoms/AtomsObject.h>

namespace AtomViz {

/******************************************************************************
* Exports an AtomsObject to POV-Ray.
******************************************************************************/
class ATOMVIZ_DLLEXPORT Atoms2POVRayExportInterface : public POVRayExportInterface
{
public:
	/// The default constructor.
	Atoms2POVRayExportInterface() : POVRayExportInterface() {}

	/// Exports the given scene object in the POV-Ray format and returns true.
	/// Return false if the scene object type is not supported by this interface class.
	/// Throws an exception if an error occured.
	virtual bool ExportSceneObject(SceneObject* sceneObj, POVRayWriter& writer, ObjectNode* contextNode, const AffineTransformation& objToWorldTM);

private:
	Q_OBJECT
	DECLARE_PLUGIN_CLASS(Atoms2POVRayExportInterface)
};

};	// End of namespace AtomViz

#endif // __ATOMS2POVRAY_H
