///////////////////////////////////////////////////////////////////////////////
// 
//  Copyright (2008) Alexander Stukowski
//
//  This file is part of OVITO (Open Visualization Tool).
//
//  OVITO is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  OVITO is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
///////////////////////////////////////////////////////////////////////////////

/** 
 * \file GridSnappingProvider.h 
 * \brief Contains the definition of the Core::GridSnappingProvider class. 
 */

#include <core/Core.h>
#include <core/viewport/Viewport.h>
#include <core/viewport/snapping/SnappingProvider.h>

namespace Core {

/**
 * \brief The marker class for the GridSnappingProvider.
 * 
 * \author Alexander Stukowski
 * \sa GridSnappingProvider
 */
class GridSnappingMarker : public SnappingMarker 
{
public:
	
	/// Renders the marker for the given world point in the viewport.
	virtual void render(Viewport& vp, const Point3& worldPoint);

	/// The viewport where snapping was done.
	Viewport* snapViewport;
};

/**
 * \brief A snapping provider that snaps to the viewport grid.
 * 
 * \author Alexander Stukowski
 * \sa ViewportGrid
 * \sa GridSnappingMarker
 */
class GridSnappingProvider : public SnappingProvider
{
public:
	
	/// Constructor
	GridSnappingProvider() : gridMarker(new GridSnappingMarker()) {}

	/// This methods computes hits on the scene objects and records them using the
	/// given context object.
	virtual void snap(SnappingContext& context);

private:
	
	/// The shared marker instance.
	shared_ptr<GridSnappingMarker> gridMarker;

	Q_OBJECT
	DECLARE_PLUGIN_CLASS(GridSnappingProvider)
};

};
