///////////////////////////////////////////////////////////////////////////////
// 
//  Copyright (2008) Alexander Stukowski
//
//  This file is part of OVITO (Open Visualization Tool).
//
//  OVITO is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  OVITO is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
///////////////////////////////////////////////////////////////////////////////

#ifndef __POVRAY_EXPORTER_H
#define __POVRAY_EXPORTER_H

#include <core/Core.h>
#include <core/data/importexport/ImporterExporter.h>
#include "../POVRay.h"
#include "POVRayExportInterface.h"
 
namespace POVRay {

class POVRayRenderer;			// defined in POVRayRenderer.h

/******************************************************************************
* This file export plugin writes the scene to a text file in the POV-Ray format.
******************************************************************************/
class POVRAY_DLLEXPORT POVRayExporter : public ImporterExporter
{
public:
	/// Default constructor.
	POVRayExporter(bool isLoading = false) : ImporterExporter(isLoading) {}

	/// Exports the scene to the given file.
	/// Return true if the file has been exported.
	/// Return false if the export has been aborted by the user.
	/// Throws an exception when the export has failed.
	virtual bool exportToFile(const QString& filePath, DataSet* dataset, bool suppressDialogs = false);

	/// Writes the scene to the given IO device.
	/// Return true if the file has been exported.
	/// Return false if the export has been aborted by the user.
	/// Throws an exception when the export has failed.
	bool ExportToPOVRay(QIODevice* device, DataSet* dataset, TimeTicks time, const CameraViewDescription* view = NULL, POVRayRenderer* renderer = NULL);

private:
	
	/// Loads all installed scene object export interfaces.
	void LoadExportInterfaces();

	/// Writes the global POV-Ray settings to the POV file.
	void WriteGlobalSettings(POVRayWriter& writer);
	/// Writes the background color etc. to the POVRay file.
	void WriteEnvironment(POVRayWriter& writer);
	/// Writes the camera to the POVRay file.
	void WriteView(POVRayWriter& writer);
	/// Writes the lights to the POVRay file.
	void WriteLights(POVRayWriter& writer);
	/// Writes the scene geometry to the POVRay file.
	void WriteScene(POVRayWriter& writer);

private:

	/// The list of installed object exporters.
	QVector< intrusive_ptr<POVRayExportInterface> > exportInterfaces;

	Q_OBJECT
	DECLARE_SERIALIZABLE_PLUGIN_CLASS(POVRayExporter)
};

};	// End of namespace POVRay

#endif // __POVRAY_EXPORTER_H
