/* Generated by re2c 0.13.5 on Tue Sep 13 17:29:46 2011 */
#line 1 "Zend/zend_language_scanner.l"
/*
   +----------------------------------------------------------------------+
   | Zend Engine                                                          |
   +----------------------------------------------------------------------+
   | Copyright (c) 1998-2011 Zend Technologies Ltd. (http://www.zend.com) |
   +----------------------------------------------------------------------+
   | This source file is subject to version 2.00 of the Zend license,     |
   | that is bundled with this package in the file LICENSE, and is        |
   | available through the world-wide-web at the following url:           |
   | http://www.zend.com/license/2_00.txt.                                |
   | If you did not receive a copy of the Zend license and are unable to  |
   | obtain it through the world-wide-web, please send a note to          |
   | license@zend.com so we can mail you a copy immediately.              |
   +----------------------------------------------------------------------+
   | Authors: Marcus Boerger <helly@php.net>                              |
   |          Nuno Lopes <nlopess@php.net>                                |
   |          Scott MacVicar <scottmac@php.net>                           |
   | Flex version authors:                                                |
   |          Andi Gutmans <andi@zend.com>                                |
   |          Zeev Suraski <zeev@zend.com>                                |
   +----------------------------------------------------------------------+
*/

/* $Id: zend_language_scanner.c 316628 2011-09-13 13:30:18Z dmitry $ */

#if 0
# define YYDEBUG(s, c) printf("state: %d char: %c\n", s, c)
#else
# define YYDEBUG(s, c)
#endif

#include "zend_language_scanner_defs.h"

#include <errno.h>
#include "zend.h"
#include "zend_alloc.h"
#include <zend_language_parser.h>
#include "zend_compile.h"
#include "zend_language_scanner.h"
#include "zend_highlight.h"
#include "zend_constants.h"
#include "zend_variables.h"
#include "zend_operators.h"
#include "zend_API.h"
#include "zend_strtod.h"
#include "zend_exceptions.h"
#include "tsrm_virtual_cwd.h"
#include "tsrm_config_common.h"

#define YYCTYPE   unsigned char
#define YYFILL(n) { if ((YYCURSOR + n) >= (YYLIMIT + ZEND_MMAP_AHEAD)) { return 0; } }
#define YYCURSOR  SCNG(yy_cursor)
#define YYLIMIT   SCNG(yy_limit)
#define YYMARKER  SCNG(yy_marker)

#define YYGETCONDITION()  SCNG(yy_state)
#define YYSETCONDITION(s) SCNG(yy_state) = s

#define STATE(name)  yyc##name

/* emulate flex constructs */
#define BEGIN(state) YYSETCONDITION(STATE(state))
#define YYSTATE      YYGETCONDITION()
#define yytext       ((char*)SCNG(yy_text))
#define yyleng       SCNG(yy_leng)
#define yyless(x)    do { YYCURSOR = (unsigned char*)yytext + x; \
                          yyleng   = (unsigned int)x; } while(0)
#define yymore()     goto yymore_restart

/* perform sanity check. If this message is triggered you should
   increase the ZEND_MMAP_AHEAD value in the zend_streams.h file */
#define YYMAXFILL 16
#if ZEND_MMAP_AHEAD < YYMAXFILL
# error ZEND_MMAP_AHEAD should be greater than or equal to YYMAXFILL
#endif

#ifdef HAVE_STDARG_H
# include <stdarg.h>
#endif

#ifdef HAVE_UNISTD_H
# include <unistd.h>
#endif

/* Globals Macros */
#define SCNG	LANG_SCNG
#ifdef ZTS
ZEND_API ts_rsrc_id language_scanner_globals_id;
#else
ZEND_API zend_php_scanner_globals language_scanner_globals;
#endif

#define HANDLE_NEWLINES(s, l)													\
do {																			\
	char *p = (s), *boundary = p+(l);											\
																				\
	while (p<boundary) {														\
		if (*p == '\n' || (*p == '\r' && (*(p+1) != '\n'))) {					\
			CG(zend_lineno)++;													\
		}																		\
		p++;																	\
	}																			\
} while (0)

#define HANDLE_NEWLINE(c) \
{ \
	if (c == '\n' || c == '\r') { \
		CG(zend_lineno)++; \
	} \
}

/* To save initial string length after scanning to first variable, CG(doc_comment_len) can be reused */
#define SET_DOUBLE_QUOTES_SCANNED_LENGTH(len) CG(doc_comment_len) = (len)
#define GET_DOUBLE_QUOTES_SCANNED_LENGTH()    CG(doc_comment_len)

#define IS_LABEL_START(c) (((c) >= 'a' && (c) <= 'z') || ((c) >= 'A' && (c) <= 'Z') || (c) == '_' || (c) >= 0x7F)

#define ZEND_IS_OCT(c)  ((c)>='0' && (c)<='7')
#define ZEND_IS_HEX(c)  (((c)>='0' && (c)<='9') || ((c)>='a' && (c)<='f') || ((c)>='A' && (c)<='F'))

BEGIN_EXTERN_C()

static size_t encoding_filter_script_to_internal(unsigned char **to, size_t *to_length, const unsigned char *from, size_t from_length TSRMLS_DC)
{
	const zend_encoding *internal_encoding = zend_multibyte_get_internal_encoding(TSRMLS_C);
	assert(internal_encoding && zend_multibyte_check_lexer_compatibility(internal_encoding));
	return zend_multibyte_encoding_converter(to, to_length, from, from_length, internal_encoding, LANG_SCNG(script_encoding) TSRMLS_CC);
}

static size_t encoding_filter_script_to_intermediate(unsigned char **to, size_t *to_length, const unsigned char *from, size_t from_length TSRMLS_DC)
{
	return zend_multibyte_encoding_converter(to, to_length, from, from_length, zend_multibyte_encoding_utf8, LANG_SCNG(script_encoding) TSRMLS_CC);
}

static size_t encoding_filter_intermediate_to_script(unsigned char **to, size_t *to_length, const unsigned char *from, size_t from_length TSRMLS_DC)
{
	return zend_multibyte_encoding_converter(to, to_length, from, from_length,
LANG_SCNG(script_encoding), zend_multibyte_encoding_utf8 TSRMLS_CC);
}

static size_t encoding_filter_intermediate_to_internal(unsigned char **to, size_t *to_length, const unsigned char *from, size_t from_length TSRMLS_DC)
{
	const zend_encoding *internal_encoding = zend_multibyte_get_internal_encoding(TSRMLS_C);
	assert(internal_encoding && zend_multibyte_check_lexer_compatibility(internal_encoding));
	return zend_multibyte_encoding_converter(to, to_length, from, from_length,
internal_encoding, zend_multibyte_encoding_utf8 TSRMLS_CC);
}


static void _yy_push_state(int new_state TSRMLS_DC)
{
	zend_stack_push(&SCNG(state_stack), (void *) &YYGETCONDITION(), sizeof(int));
	YYSETCONDITION(new_state);
}

#define yy_push_state(state_and_tsrm) _yy_push_state(yyc##state_and_tsrm)

static void yy_pop_state(TSRMLS_D)
{
	int *stack_state;
	zend_stack_top(&SCNG(state_stack), (void **) &stack_state);
	YYSETCONDITION(*stack_state);
	zend_stack_del_top(&SCNG(state_stack));
}

static void yy_scan_buffer(char *str, unsigned int len TSRMLS_DC)
{
	YYCURSOR       = (YYCTYPE*)str;
	YYLIMIT        = YYCURSOR + len;
	if (!SCNG(yy_start)) {
		SCNG(yy_start) = YYCURSOR;
	}
}

void startup_scanner(TSRMLS_D)
{
	CG(parse_error) = 0;
	CG(heredoc) = NULL;
	CG(heredoc_len) = 0;
	CG(doc_comment) = NULL;
	CG(doc_comment_len) = 0;
	zend_stack_init(&SCNG(state_stack));
}

void shutdown_scanner(TSRMLS_D)
{
	if (CG(heredoc)) {
		efree(CG(heredoc));
		CG(heredoc_len)=0;
	}
	CG(parse_error) = 0;
	zend_stack_destroy(&SCNG(state_stack));
	RESET_DOC_COMMENT();
}

ZEND_API void zend_save_lexical_state(zend_lex_state *lex_state TSRMLS_DC)
{
	lex_state->yy_leng   = SCNG(yy_leng);
	lex_state->yy_start  = SCNG(yy_start);
	lex_state->yy_text   = SCNG(yy_text);
	lex_state->yy_cursor = SCNG(yy_cursor);
	lex_state->yy_marker = SCNG(yy_marker);
	lex_state->yy_limit  = SCNG(yy_limit);

	lex_state->state_stack = SCNG(state_stack);
	zend_stack_init(&SCNG(state_stack));

	lex_state->in = SCNG(yy_in);
	lex_state->yy_state = YYSTATE;
	lex_state->filename = zend_get_compiled_filename(TSRMLS_C);
	lex_state->lineno = CG(zend_lineno);

	lex_state->script_org = SCNG(script_org);
	lex_state->script_org_size = SCNG(script_org_size);
	lex_state->script_filtered = SCNG(script_filtered);
	lex_state->script_filtered_size = SCNG(script_filtered_size);
	lex_state->input_filter = SCNG(input_filter);
	lex_state->output_filter = SCNG(output_filter);
	lex_state->script_encoding = SCNG(script_encoding);
}

ZEND_API void zend_restore_lexical_state(zend_lex_state *lex_state TSRMLS_DC)
{
	SCNG(yy_leng)   = lex_state->yy_leng;
	SCNG(yy_start)  = lex_state->yy_start;
	SCNG(yy_text)   = lex_state->yy_text;
	SCNG(yy_cursor) = lex_state->yy_cursor;
	SCNG(yy_marker) = lex_state->yy_marker;
	SCNG(yy_limit)  = lex_state->yy_limit;

	zend_stack_destroy(&SCNG(state_stack));
	SCNG(state_stack) = lex_state->state_stack;

	SCNG(yy_in) = lex_state->in;
	YYSETCONDITION(lex_state->yy_state);
	CG(zend_lineno) = lex_state->lineno;
	zend_restore_compiled_filename(lex_state->filename TSRMLS_CC);

	if (SCNG(script_filtered)) {
		efree(SCNG(script_filtered));
		SCNG(script_filtered) = NULL;
	}
	SCNG(script_org) = lex_state->script_org;
	SCNG(script_org_size) = lex_state->script_org_size;
	SCNG(script_filtered) = lex_state->script_filtered;
	SCNG(script_filtered_size) = lex_state->script_filtered_size;
	SCNG(input_filter) = lex_state->input_filter;
	SCNG(output_filter) = lex_state->output_filter;
	SCNG(script_encoding) = lex_state->script_encoding;

	if (CG(heredoc)) {
		efree(CG(heredoc));
		CG(heredoc) = NULL;
		CG(heredoc_len) = 0;
	}
}

ZEND_API void zend_destroy_file_handle(zend_file_handle *file_handle TSRMLS_DC)
{
	zend_llist_del_element(&CG(open_files), file_handle, (int (*)(void *, void *)) zend_compare_file_handles);
	/* zend_file_handle_dtor() operates on the copy, so we have to NULLify the original here */
	file_handle->opened_path = NULL;
	if (file_handle->free_filename) {
		file_handle->filename = NULL;
	}
}

#define BOM_UTF32_BE	"\x00\x00\xfe\xff"
#define	BOM_UTF32_LE	"\xff\xfe\x00\x00"
#define	BOM_UTF16_BE	"\xfe\xff"
#define	BOM_UTF16_LE	"\xff\xfe"
#define	BOM_UTF8		"\xef\xbb\xbf"

static const zend_encoding *zend_multibyte_detect_utf_encoding(const unsigned char *script, size_t script_size TSRMLS_DC)
{
	const unsigned char *p;
	int wchar_size = 2;
	int le = 0;

	/* utf-16 or utf-32? */
	p = script;
	while ((p-script) < script_size) {
		p = memchr(p, 0, script_size-(p-script)-2);
		if (!p) {
			break;
		}
		if (*(p+1) == '\0' && *(p+2) == '\0') {
			wchar_size = 4;
			break;
		}

		/* searching for UTF-32 specific byte orders, so this will do */
		p += 4;
	}

	/* BE or LE? */
	p = script;
	while ((p-script) < script_size) {
		if (*p == '\0' && *(p+wchar_size-1) != '\0') {
			/* BE */
			le = 0;
			break;
		} else if (*p != '\0' && *(p+wchar_size-1) == '\0') {
			/* LE* */
			le = 1;
			break;
		}
		p += wchar_size;
	}

	if (wchar_size == 2) {
		return le ? zend_multibyte_encoding_utf16le : zend_multibyte_encoding_utf16be;
	} else {
		return le ? zend_multibyte_encoding_utf32le : zend_multibyte_encoding_utf32be;
	}

	return NULL;
}

static const zend_encoding* zend_multibyte_detect_unicode(TSRMLS_D)
{
	const zend_encoding *script_encoding = NULL;
	int bom_size;
	unsigned char *pos1, *pos2;

	if (LANG_SCNG(script_org_size) < sizeof(BOM_UTF32_LE)-1) {
		return NULL;
	}

	/* check out BOM */
	if (!memcmp(LANG_SCNG(script_org), BOM_UTF32_BE, sizeof(BOM_UTF32_BE)-1)) {
		script_encoding = zend_multibyte_encoding_utf32be;
		bom_size = sizeof(BOM_UTF32_BE)-1;
	} else if (!memcmp(LANG_SCNG(script_org), BOM_UTF32_LE, sizeof(BOM_UTF32_LE)-1)) {
		script_encoding = zend_multibyte_encoding_utf32le;
		bom_size = sizeof(BOM_UTF32_LE)-1;
	} else if (!memcmp(LANG_SCNG(script_org), BOM_UTF16_BE, sizeof(BOM_UTF16_BE)-1)) {
		script_encoding = zend_multibyte_encoding_utf16be;
		bom_size = sizeof(BOM_UTF16_BE)-1;
	} else if (!memcmp(LANG_SCNG(script_org), BOM_UTF16_LE, sizeof(BOM_UTF16_LE)-1)) {
		script_encoding = zend_multibyte_encoding_utf16le;
		bom_size = sizeof(BOM_UTF16_LE)-1;
	} else if (!memcmp(LANG_SCNG(script_org), BOM_UTF8, sizeof(BOM_UTF8)-1)) {
		script_encoding = zend_multibyte_encoding_utf8;
		bom_size = sizeof(BOM_UTF8)-1;
	}

	if (script_encoding) {
		/* remove BOM */
		LANG_SCNG(script_org) += bom_size;
		LANG_SCNG(script_org_size) -= bom_size;

		return script_encoding;
	}

	/* script contains NULL bytes -> auto-detection */
	if ((pos1 = memchr(LANG_SCNG(script_org), 0, LANG_SCNG(script_org_size)))) {
		/* check if the NULL byte is after the __HALT_COMPILER(); */
		pos2 = LANG_SCNG(script_org);

		while (pos1 - pos2 >= sizeof("__HALT_COMPILER();")-1) {
			pos2 = memchr(pos2, '_', pos1 - pos2);
			if (!pos2) break;
			pos2++;
			if (strncasecmp((char*)pos2, "_HALT_COMPILER", sizeof("_HALT_COMPILER")-1) == 0) {
				pos2 += sizeof("_HALT_COMPILER")-1;
				while (*pos2 == ' '  ||
					   *pos2 == '\t' ||
					   *pos2 == '\r' ||
					   *pos2 == '\n') {
					pos2++;
				}
				if (*pos2 == '(') {
					pos2++;
					while (*pos2 == ' '  ||
						   *pos2 == '\t' ||
						   *pos2 == '\r' ||
						   *pos2 == '\n') {
						pos2++;
					}
					if (*pos2 == ')') {
						pos2++;
						while (*pos2 == ' '  ||
							   *pos2 == '\t' ||
							   *pos2 == '\r' ||
							   *pos2 == '\n') {
							pos2++;
						}
						if (*pos2 == ';') {
							return NULL;
						}
					}
				}
			}
		}
		/* make best effort if BOM is missing */
		return zend_multibyte_detect_utf_encoding(LANG_SCNG(script_org), LANG_SCNG(script_org_size) TSRMLS_CC);
	}

	return NULL;
}

static const zend_encoding* zend_multibyte_find_script_encoding(TSRMLS_D)
{
	const zend_encoding *script_encoding;

	if (CG(detect_unicode)) {
		/* check out bom(byte order mark) and see if containing wchars */
		script_encoding = zend_multibyte_detect_unicode(TSRMLS_C);
		if (script_encoding != NULL) {
			/* bom or wchar detection is prior to 'script_encoding' option */
			return script_encoding;
		}
	}

	/* if no script_encoding specified, just leave alone */
	if (!CG(script_encoding_list) || !CG(script_encoding_list_size)) {
		return NULL;
	}

	/* if multiple encodings specified, detect automagically */
	if (CG(script_encoding_list_size) > 1) {
		return zend_multibyte_encoding_detector(LANG_SCNG(script_org), LANG_SCNG(script_org_size), CG(script_encoding_list), CG(script_encoding_list_size) TSRMLS_CC);
	}

	return CG(script_encoding_list)[0];
}

ZEND_API int zend_multibyte_set_filter(const zend_encoding *onetime_encoding TSRMLS_DC)
{
	const zend_encoding *internal_encoding = zend_multibyte_get_internal_encoding(TSRMLS_C);
	const zend_encoding *script_encoding = onetime_encoding ? onetime_encoding: zend_multibyte_find_script_encoding(TSRMLS_C);

	if (!script_encoding) {
		return FAILURE;
	}

	/* judge input/output filter */
	LANG_SCNG(script_encoding) = script_encoding;
	LANG_SCNG(input_filter) = NULL;
	LANG_SCNG(output_filter) = NULL;

	if (!internal_encoding || LANG_SCNG(script_encoding) == internal_encoding) {
		if (!zend_multibyte_check_lexer_compatibility(LANG_SCNG(script_encoding))) {
			/* and if not, work around w/ script_encoding -> utf-8 -> script_encoding conversion */
			LANG_SCNG(input_filter) = encoding_filter_script_to_intermediate;
			LANG_SCNG(output_filter) = encoding_filter_intermediate_to_script;
		} else {
			LANG_SCNG(input_filter) = NULL;
			LANG_SCNG(output_filter) = NULL;
		}
		return SUCCESS;
	}

	if (zend_multibyte_check_lexer_compatibility(internal_encoding)) {
		LANG_SCNG(input_filter) = encoding_filter_script_to_internal;
		LANG_SCNG(output_filter) = NULL;
	} else if (zend_multibyte_check_lexer_compatibility(LANG_SCNG(script_encoding))) {
		LANG_SCNG(input_filter) = NULL;
		LANG_SCNG(output_filter) = encoding_filter_script_to_internal;
	} else {
		/* both script and internal encodings are incompatible w/ flex */
		LANG_SCNG(input_filter) = encoding_filter_script_to_intermediate;
		LANG_SCNG(output_filter) = encoding_filter_intermediate_to_internal;
	}

	return 0;
}

ZEND_API int open_file_for_scanning(zend_file_handle *file_handle TSRMLS_DC)
{
	const char *file_path = NULL;
	char *buf;
	size_t size, offset = 0;

	/* The shebang line was read, get the current position to obtain the buffer start */
	if (CG(start_lineno) == 2 && file_handle->type == ZEND_HANDLE_FP && file_handle->handle.fp) {
		if ((offset = ftell(file_handle->handle.fp)) == -1) {
			offset = 0;
		}
	}

	if (zend_stream_fixup(file_handle, &buf, &size TSRMLS_CC) == FAILURE) {
		return FAILURE;
	}

	zend_llist_add_element(&CG(open_files), file_handle);
	if (file_handle->handle.stream.handle >= (void*)file_handle && file_handle->handle.stream.handle <= (void*)(file_handle+1)) {
		zend_file_handle *fh = (zend_file_handle*)zend_llist_get_last(&CG(open_files));
		size_t diff = (char*)file_handle->handle.stream.handle - (char*)file_handle;
		fh->handle.stream.handle = (void*)(((char*)fh) + diff);
		file_handle->handle.stream.handle = fh->handle.stream.handle;
	}

	/* Reset the scanner for scanning the new file */
	SCNG(yy_in) = file_handle;
	SCNG(yy_start) = NULL;

	if (size != -1) {
		if (CG(multibyte)) {
			SCNG(script_org) = (unsigned char*)buf;
			SCNG(script_org_size) = size;
			SCNG(script_filtered) = NULL;

			zend_multibyte_set_filter(NULL TSRMLS_CC);

			if (SCNG(input_filter)) {
				if ((size_t)-1 == SCNG(input_filter)(&SCNG(script_filtered), &SCNG(script_filtered_size), SCNG(script_org), SCNG(script_org_size) TSRMLS_CC)) {
					zend_error_noreturn(E_COMPILE_ERROR, "Could not convert the script from the detected "
							"encoding \"%s\" to a compatible encoding", zend_multibyte_get_encoding_name(LANG_SCNG(script_encoding)));
				}
				buf = (char*)SCNG(script_filtered);
				size = SCNG(script_filtered_size);
			}
		}
		SCNG(yy_start) = (unsigned char *)buf - offset;
		yy_scan_buffer(buf, size TSRMLS_CC);
	} else {
		zend_error_noreturn(E_COMPILE_ERROR, "zend_stream_mmap() failed");
	}

	BEGIN(INITIAL);

	if (file_handle->opened_path) {
		file_path = file_handle->opened_path;
	} else {
		file_path = file_handle->filename;
	}

	zend_set_compiled_filename(file_path TSRMLS_CC);

	if (CG(start_lineno)) {
		CG(zend_lineno) = CG(start_lineno);
		CG(start_lineno) = 0;
	} else {
		CG(zend_lineno) = 1;
	}

	CG(increment_lineno) = 0;
	return SUCCESS;
}
END_EXTERN_C()


ZEND_API zend_op_array *compile_file(zend_file_handle *file_handle, int type TSRMLS_DC)
{
	zend_lex_state original_lex_state;
	zend_op_array *op_array = (zend_op_array *) emalloc(sizeof(zend_op_array));
	zend_op_array *original_active_op_array = CG(active_op_array);
	zend_op_array *retval=NULL;
	int compiler_result;
	zend_bool compilation_successful=0;
	znode retval_znode;
	zend_bool original_in_compilation = CG(in_compilation);

	retval_znode.op_type = IS_CONST;
	retval_znode.u.constant.type = IS_LONG;
	retval_znode.u.constant.value.lval = 1;
	Z_UNSET_ISREF(retval_znode.u.constant);
	Z_SET_REFCOUNT(retval_znode.u.constant, 1);

	zend_save_lexical_state(&original_lex_state TSRMLS_CC);

	retval = op_array; /* success oriented */

	if (open_file_for_scanning(file_handle TSRMLS_CC)==FAILURE) {
		if (type==ZEND_REQUIRE) {
			zend_message_dispatcher(ZMSG_FAILED_REQUIRE_FOPEN, file_handle->filename TSRMLS_CC);
			zend_bailout();
		} else {
			zend_message_dispatcher(ZMSG_FAILED_INCLUDE_FOPEN, file_handle->filename TSRMLS_CC);
		}
		compilation_successful=0;
	} else {
		init_op_array(op_array, ZEND_USER_FUNCTION, INITIAL_OP_ARRAY_SIZE TSRMLS_CC);
		CG(in_compilation) = 1;
		CG(active_op_array) = op_array;
		zend_init_compiler_context(TSRMLS_C);
		compiler_result = zendparse(TSRMLS_C);
		zend_do_return(&retval_znode, 0 TSRMLS_CC);
		CG(in_compilation) = original_in_compilation;
		if (compiler_result==1) { /* parser error */
			zend_bailout();
		}
		compilation_successful=1;
	}

	if (retval) {
		CG(active_op_array) = original_active_op_array;
		if (compilation_successful) {
			pass_two(op_array TSRMLS_CC);
			zend_release_labels(TSRMLS_C);
		} else {
			efree(op_array);
			retval = NULL;
		}
	}
	zend_restore_lexical_state(&original_lex_state TSRMLS_CC);
	return retval;
}


zend_op_array *compile_filename(int type, zval *filename TSRMLS_DC)
{
	zend_file_handle file_handle;
	zval tmp;
	zend_op_array *retval;
	char *opened_path = NULL;

	if (filename->type != IS_STRING) {
		tmp = *filename;
		zval_copy_ctor(&tmp);
		convert_to_string(&tmp);
		filename = &tmp;
	}
	file_handle.filename = filename->value.str.val;
	file_handle.free_filename = 0;
	file_handle.type = ZEND_HANDLE_FILENAME;
	file_handle.opened_path = NULL;
	file_handle.handle.fp = NULL;

	retval = zend_compile_file(&file_handle, type TSRMLS_CC);
	if (retval && file_handle.handle.stream.handle) {
		int dummy = 1;

		if (!file_handle.opened_path) {
			file_handle.opened_path = opened_path = estrndup(filename->value.str.val, filename->value.str.len);
		}

		zend_hash_add(&EG(included_files), file_handle.opened_path, strlen(file_handle.opened_path)+1, (void *)&dummy, sizeof(int), NULL);

		if (opened_path) {
			efree(opened_path);
		}
	}
	zend_destroy_file_handle(&file_handle TSRMLS_CC);

	if (filename==&tmp) {
		zval_dtor(&tmp);
	}
	return retval;
}

ZEND_API int zend_prepare_string_for_scanning(zval *str, char *filename TSRMLS_DC)
{
	char *buf;
	size_t size;

	/* enforce two trailing NULLs for flex... */
	if (IS_INTERNED(str->value.str.val)) {
		char *tmp = safe_emalloc(1, str->value.str.len, ZEND_MMAP_AHEAD);
		memcpy(tmp, str->value.str.val, str->value.str.len + ZEND_MMAP_AHEAD);
		str->value.str.val = tmp;
	} else {
		str->value.str.val = safe_erealloc(str->value.str.val, 1, str->value.str.len, ZEND_MMAP_AHEAD);
	}

	memset(str->value.str.val + str->value.str.len, 0, ZEND_MMAP_AHEAD);

	SCNG(yy_in) = NULL;
	SCNG(yy_start) = NULL;

	buf = str->value.str.val;
	size = str->value.str.len;

	if (CG(multibyte)) {
		SCNG(script_org) = (unsigned char*)buf;
		SCNG(script_org_size) = size;
		SCNG(script_filtered) = NULL;

		zend_multibyte_set_filter(zend_multibyte_get_internal_encoding(TSRMLS_C) TSRMLS_CC);

		if (SCNG(input_filter)) {
			if ((size_t)-1 == SCNG(input_filter)(&SCNG(script_filtered), &SCNG(script_filtered_size), SCNG(script_org), SCNG(script_org_size) TSRMLS_CC)) {
				zend_error_noreturn(E_COMPILE_ERROR, "Could not convert the script from the detected "
						"encoding \"%s\" to a compatible encoding", zend_multibyte_get_encoding_name(LANG_SCNG(script_encoding)));
			}
			buf = (char*)SCNG(script_filtered);
			size = SCNG(script_filtered_size);
		}
	}

	yy_scan_buffer(buf, size TSRMLS_CC);

	zend_set_compiled_filename(filename TSRMLS_CC);
	CG(zend_lineno) = 1;
	CG(increment_lineno) = 0;
	return SUCCESS;
}


ZEND_API size_t zend_get_scanned_file_offset(TSRMLS_D)
{
	size_t offset = SCNG(yy_cursor) - SCNG(yy_start);
	if (SCNG(input_filter)) {
		size_t original_offset = offset, length = 0;
		do {
			unsigned char *p = NULL;
			if ((size_t)-1 == SCNG(input_filter)(&p, &length, SCNG(script_org), offset TSRMLS_CC)) {
				return (size_t)-1;
			}
			efree(p);
			if (length > original_offset) {
				offset--;
			} else if (length < original_offset) {
				offset++;
			}
		} while (original_offset != length);
	}
	return offset;
}


zend_op_array *compile_string(zval *source_string, char *filename TSRMLS_DC)
{
	zend_lex_state original_lex_state;
	zend_op_array *op_array = (zend_op_array *) emalloc(sizeof(zend_op_array));
	zend_op_array *original_active_op_array = CG(active_op_array);
	zend_op_array *retval;
	zval tmp;
	int compiler_result;
	zend_bool original_in_compilation = CG(in_compilation);

	if (source_string->value.str.len==0) {
		efree(op_array);
		return NULL;
	}

	CG(in_compilation) = 1;

	tmp = *source_string;
	zval_copy_ctor(&tmp);
	convert_to_string(&tmp);
	source_string = &tmp;

	zend_save_lexical_state(&original_lex_state TSRMLS_CC);
	if (zend_prepare_string_for_scanning(source_string, filename TSRMLS_CC)==FAILURE) {
		efree(op_array);
		retval = NULL;
	} else {
		zend_bool orig_interactive = CG(interactive);

		CG(interactive) = 0;
		init_op_array(op_array, ZEND_EVAL_CODE, INITIAL_OP_ARRAY_SIZE TSRMLS_CC);
		CG(interactive) = orig_interactive;
		CG(active_op_array) = op_array;
		zend_init_compiler_context(TSRMLS_C);
		BEGIN(ST_IN_SCRIPTING);
		compiler_result = zendparse(TSRMLS_C);

		if (SCNG(script_filtered)) {
			efree(SCNG(script_filtered));
			SCNG(script_filtered) = NULL;
		}

		if (compiler_result==1) {
			CG(active_op_array) = original_active_op_array;
			CG(unclean_shutdown)=1;
			retval = NULL;
		} else {
			zend_do_return(NULL, 0 TSRMLS_CC);
			CG(active_op_array) = original_active_op_array;
			pass_two(op_array TSRMLS_CC);
			zend_release_labels(TSRMLS_C);
			retval = op_array;
		}
	}
	zend_restore_lexical_state(&original_lex_state TSRMLS_CC);
	zval_dtor(&tmp);
	CG(in_compilation) = original_in_compilation;
	return retval;
}


BEGIN_EXTERN_C()
int highlight_file(char *filename, zend_syntax_highlighter_ini *syntax_highlighter_ini TSRMLS_DC)
{
	zend_lex_state original_lex_state;
	zend_file_handle file_handle;

	file_handle.type = ZEND_HANDLE_FILENAME;
	file_handle.filename = filename;
	file_handle.free_filename = 0;
	file_handle.opened_path = NULL;
	zend_save_lexical_state(&original_lex_state TSRMLS_CC);
	if (open_file_for_scanning(&file_handle TSRMLS_CC)==FAILURE) {
		zend_message_dispatcher(ZMSG_FAILED_HIGHLIGHT_FOPEN, filename TSRMLS_CC);
		zend_restore_lexical_state(&original_lex_state TSRMLS_CC);
		return FAILURE;
	}
	zend_highlight(syntax_highlighter_ini TSRMLS_CC);
	if (SCNG(script_filtered)) {
		efree(SCNG(script_filtered));
		SCNG(script_filtered) = NULL;
	}
	zend_destroy_file_handle(&file_handle TSRMLS_CC);
	zend_restore_lexical_state(&original_lex_state TSRMLS_CC);
	return SUCCESS;
}

int highlight_string(zval *str, zend_syntax_highlighter_ini *syntax_highlighter_ini, char *str_name TSRMLS_DC)
{
	zend_lex_state original_lex_state;
	zval tmp = *str;

	str = &tmp;
	zval_copy_ctor(str);
	zend_save_lexical_state(&original_lex_state TSRMLS_CC);
	if (zend_prepare_string_for_scanning(str, str_name TSRMLS_CC)==FAILURE) {
		zend_restore_lexical_state(&original_lex_state TSRMLS_CC);
		return FAILURE;
	}
	BEGIN(INITIAL);
	zend_highlight(syntax_highlighter_ini TSRMLS_CC);
	if (SCNG(script_filtered)) {
		efree(SCNG(script_filtered));
		SCNG(script_filtered) = NULL;
	}
	zend_restore_lexical_state(&original_lex_state TSRMLS_CC);
	zval_dtor(str);
	return SUCCESS;
}

ZEND_API void zend_multibyte_yyinput_again(zend_encoding_filter old_input_filter, const zend_encoding *old_encoding TSRMLS_DC)
{
	size_t length;
	unsigned char *new_yy_start;

	/* convert and set */
	if (!SCNG(input_filter)) {
		if (SCNG(script_filtered)) {
			efree(SCNG(script_filtered));
			SCNG(script_filtered) = NULL;
		}
		SCNG(script_filtered_size) = 0;
		length = SCNG(script_org_size);
		new_yy_start = SCNG(script_org);
	} else {
		if ((size_t)-1 == SCNG(input_filter)(&new_yy_start, &length, SCNG(script_org), SCNG(script_org_size) TSRMLS_CC)) {
			zend_error_noreturn(E_COMPILE_ERROR, "Could not convert the script from the detected "
					"encoding \"%s\" to a compatible encoding", zend_multibyte_get_encoding_name(LANG_SCNG(script_encoding)));
		}
		SCNG(script_filtered) = new_yy_start;
		SCNG(script_filtered_size) = length;
	}

	SCNG(yy_cursor) = new_yy_start + (SCNG(yy_cursor) - SCNG(yy_start));
	SCNG(yy_marker) = new_yy_start + (SCNG(yy_marker) - SCNG(yy_start));
	SCNG(yy_text) = new_yy_start + (SCNG(yy_text) - SCNG(yy_start));
	SCNG(yy_limit) = new_yy_start + (SCNG(yy_limit) - SCNG(yy_start));

	SCNG(yy_start) = new_yy_start;
}


# define zend_copy_value(zendlval, yytext, yyleng) \
	if (SCNG(output_filter)) { \
		size_t sz = 0; \
		SCNG(output_filter)((unsigned char **)&(zendlval->value.str.val), &sz, (unsigned char *)yytext, (size_t)yyleng TSRMLS_CC); \
		zendlval->value.str.len = sz; \
	} else { \
		zendlval->value.str.val = (char *) estrndup(yytext, yyleng); \
		zendlval->value.str.len = yyleng; \
	}

static void zend_scan_escape_string(zval *zendlval, char *str, int len, char quote_type TSRMLS_DC)
{
	register char *s, *t;
	char *end;

	ZVAL_STRINGL(zendlval, str, len, 1);

	/* convert escape sequences */
	s = t = zendlval->value.str.val;
	end = s+zendlval->value.str.len;
	while (s<end) {
		if (*s=='\\') {
			s++;
			if (s >= end) {
				*t++ = '\\';
				break;
			}

			switch(*s) {
				case 'n':
					*t++ = '\n';
					zendlval->value.str.len--;
					break;
				case 'r':
					*t++ = '\r';
					zendlval->value.str.len--;
					break;
				case 't':
					*t++ = '\t';
					zendlval->value.str.len--;
					break;
				case 'f':
					*t++ = '\f';
					zendlval->value.str.len--;
					break;
				case 'v':
					*t++ = '\v';
					zendlval->value.str.len--;
					break;
				case '"':
				case '`':
					if (*s != quote_type) {
						*t++ = '\\';
						*t++ = *s;
						break;
					}
				case '\\':
				case '$':
					*t++ = *s;
					zendlval->value.str.len--;
					break;
				case 'x':
				case 'X':
					if (ZEND_IS_HEX(*(s+1))) {
						char hex_buf[3] = { 0, 0, 0 };

						zendlval->value.str.len--; /* for the 'x' */

						hex_buf[0] = *(++s);
						zendlval->value.str.len--;
						if (ZEND_IS_HEX(*(s+1))) {
							hex_buf[1] = *(++s);
							zendlval->value.str.len--;
						}
						*t++ = (char) strtol(hex_buf, NULL, 16);
					} else {
						*t++ = '\\';
						*t++ = *s;
					}
					break;
				default:
					/* check for an octal */
					if (ZEND_IS_OCT(*s)) {
						char octal_buf[4] = { 0, 0, 0, 0 };

						octal_buf[0] = *s;
						zendlval->value.str.len--;
						if (ZEND_IS_OCT(*(s+1))) {
							octal_buf[1] = *(++s);
							zendlval->value.str.len--;
							if (ZEND_IS_OCT(*(s+1))) {
								octal_buf[2] = *(++s);
								zendlval->value.str.len--;
							}
						}
						*t++ = (char) strtol(octal_buf, NULL, 8);
					} else {
						*t++ = '\\';
						*t++ = *s;
					}
					break;
			}
		} else {
			*t++ = *s;
		}

		if (*s == '\n' || (*s == '\r' && (*(s+1) != '\n'))) {
			CG(zend_lineno)++;
		}
		s++;
	}
	*t = 0;
	if (SCNG(output_filter)) {
		size_t sz = 0;
		s = zendlval->value.str.val;
		SCNG(output_filter)((unsigned char **)&(zendlval->value.str.val), &sz, (unsigned char *)s, (size_t)zendlval->value.str.len TSRMLS_CC);
		zendlval->value.str.len = sz;
		efree(s);
	}
}


int lex_scan(zval *zendlval TSRMLS_DC)
{
restart:
	SCNG(yy_text) = YYCURSOR;

yymore_restart:


#line 989 "Zend/zend_language_scanner.c"
{
	YYCTYPE yych;
	unsigned int yyaccept = 0;
	if (YYGETCONDITION() < 5) {
		if (YYGETCONDITION() < 2) {
			if (YYGETCONDITION() < 1) {
				goto yyc_ST_IN_SCRIPTING;
			} else {
				goto yyc_ST_LOOKING_FOR_PROPERTY;
			}
		} else {
			if (YYGETCONDITION() < 3) {
				goto yyc_ST_BACKQUOTE;
			} else {
				if (YYGETCONDITION() < 4) {
					goto yyc_ST_DOUBLE_QUOTES;
				} else {
					goto yyc_ST_HEREDOC;
				}
			}
		}
	} else {
		if (YYGETCONDITION() < 7) {
			if (YYGETCONDITION() < 6) {
				goto yyc_ST_LOOKING_FOR_VARNAME;
			} else {
				goto yyc_ST_VAR_OFFSET;
			}
		} else {
			if (YYGETCONDITION() < 8) {
				goto yyc_INITIAL;
			} else {
				if (YYGETCONDITION() < 9) {
					goto yyc_ST_END_HEREDOC;
				} else {
					goto yyc_ST_NOWDOC;
				}
			}
		}
	}
/* *********************************** */
yyc_INITIAL:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128,   0,   0, 128,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
		};

		YYDEBUG(0, *YYCURSOR);
		YYFILL(8);
		yych = *YYCURSOR;
		if (yych != '<') goto yy4;
		YYDEBUG(2, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '?') {
			if (yych == '%') goto yy7;
			if (yych >= '?') goto yy5;
		} else {
			if (yych <= 'S') {
				if (yych >= 'S') goto yy9;
			} else {
				if (yych == 's') goto yy9;
			}
		}
yy3:
		YYDEBUG(3, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1769 "Zend/zend_language_scanner.l"
		{
	if (YYCURSOR > YYLIMIT) {
		return 0;
	}

inline_char_handler:

	while (1) {
		YYCTYPE *ptr = memchr(YYCURSOR, '<', YYLIMIT - YYCURSOR);

		YYCURSOR = ptr ? ptr + 1 : YYLIMIT;

		if (YYCURSOR < YYLIMIT) {
			switch (*YYCURSOR) {
				case '?':
					if (CG(short_tags) || !strncasecmp((char*)YYCURSOR + 1, "php", 3) || (*(YYCURSOR + 1) == '=')) { /* Assume [ \t\n\r] follows "php" */
						break;
					}
					continue;
				case '%':
					if (CG(asp_tags)) {
						break;
					}
					continue;
				case 's':
				case 'S':
					/* Probably NOT an opening PHP <script> tag, so don't end the HTML chunk yet
					 * If it is, the PHP <script> tag rule checks for any HTML scanned before it */
					YYCURSOR--;
					yymore();
				default:
					continue;
			}

			YYCURSOR--;
		}

		break;
	}

inline_html:
	yyleng = YYCURSOR - SCNG(yy_text);

	if (SCNG(output_filter)) {
		int readsize;
		size_t sz = 0;
		readsize = SCNG(output_filter)((unsigned char **)&(zendlval->value.str.val), &sz, (unsigned char *)yytext, (size_t)yyleng TSRMLS_CC);
		zendlval->value.str.len = sz;
		if (readsize < yyleng) {
			yyless(readsize);
		}
	} else {
	  zendlval->value.str.val = (char *) estrndup(yytext, yyleng);
	  zendlval->value.str.len = yyleng;
	}
	zendlval->type = IS_STRING;
	HANDLE_NEWLINES(yytext, yyleng);
	return T_INLINE_HTML;
}
#line 1148 "Zend/zend_language_scanner.c"
yy4:
		YYDEBUG(4, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy3;
yy5:
		YYDEBUG(5, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'O') {
			if (yych == '=') goto yy45;
		} else {
			if (yych <= 'P') goto yy47;
			if (yych == 'p') goto yy47;
		}
yy6:
		YYDEBUG(6, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1757 "Zend/zend_language_scanner.l"
		{
	if (CG(short_tags)) {
		zendlval->value.str.val = yytext; /* no copying - intentional */
		zendlval->value.str.len = yyleng;
		zendlval->type = IS_STRING;
		BEGIN(ST_IN_SCRIPTING);
		return T_OPEN_TAG;
	} else {
		goto inline_char_handler;
	}
}
#line 1178 "Zend/zend_language_scanner.c"
yy7:
		YYDEBUG(7, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) == '=') goto yy43;
		YYDEBUG(8, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1734 "Zend/zend_language_scanner.l"
		{
	if (CG(asp_tags)) {
		zendlval->value.str.val = yytext; /* no copying - intentional */
		zendlval->value.str.len = yyleng;
		zendlval->type = IS_STRING;
		BEGIN(ST_IN_SCRIPTING);
		return T_OPEN_TAG;
	} else {
		goto inline_char_handler;
	}
}
#line 1197 "Zend/zend_language_scanner.c"
yy9:
		YYDEBUG(9, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy11;
		if (yych == 'c') goto yy11;
yy10:
		YYDEBUG(10, *YYCURSOR);
		YYCURSOR = YYMARKER;
		if (yyaccept <= 0) {
			goto yy3;
		} else {
			goto yy6;
		}
yy11:
		YYDEBUG(11, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy12;
		if (yych != 'r') goto yy10;
yy12:
		YYDEBUG(12, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy13;
		if (yych != 'i') goto yy10;
yy13:
		YYDEBUG(13, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'P') goto yy14;
		if (yych != 'p') goto yy10;
yy14:
		YYDEBUG(14, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy15;
		if (yych != 't') goto yy10;
yy15:
		YYDEBUG(15, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy10;
		if (yych == 'l') goto yy10;
		goto yy17;
yy16:
		YYDEBUG(16, *YYCURSOR);
		++YYCURSOR;
		YYFILL(8);
		yych = *YYCURSOR;
yy17:
		YYDEBUG(17, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy16;
		}
		if (yych == 'L') goto yy18;
		if (yych != 'l') goto yy10;
yy18:
		YYDEBUG(18, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy19;
		if (yych != 'a') goto yy10;
yy19:
		YYDEBUG(19, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy20;
		if (yych != 'n') goto yy10;
yy20:
		YYDEBUG(20, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'G') goto yy21;
		if (yych != 'g') goto yy10;
yy21:
		YYDEBUG(21, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'U') goto yy22;
		if (yych != 'u') goto yy10;
yy22:
		YYDEBUG(22, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy23;
		if (yych != 'a') goto yy10;
yy23:
		YYDEBUG(23, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'G') goto yy24;
		if (yych != 'g') goto yy10;
yy24:
		YYDEBUG(24, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy25;
		if (yych != 'e') goto yy10;
yy25:
		YYDEBUG(25, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(26, *YYCURSOR);
		if (yych <= '\r') {
			if (yych <= 0x08) goto yy10;
			if (yych <= '\n') goto yy25;
			if (yych <= '\f') goto yy10;
			goto yy25;
		} else {
			if (yych <= ' ') {
				if (yych <= 0x1F) goto yy10;
				goto yy25;
			} else {
				if (yych != '=') goto yy10;
			}
		}
yy27:
		YYDEBUG(27, *YYCURSOR);
		++YYCURSOR;
		YYFILL(5);
		yych = *YYCURSOR;
		YYDEBUG(28, *YYCURSOR);
		if (yych <= '!') {
			if (yych <= '\f') {
				if (yych <= 0x08) goto yy10;
				if (yych <= '\n') goto yy27;
				goto yy10;
			} else {
				if (yych <= '\r') goto yy27;
				if (yych == ' ') goto yy27;
				goto yy10;
			}
		} else {
			if (yych <= 'O') {
				if (yych <= '"') goto yy30;
				if (yych == '\'') goto yy31;
				goto yy10;
			} else {
				if (yych <= 'P') goto yy29;
				if (yych != 'p') goto yy10;
			}
		}
yy29:
		YYDEBUG(29, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy42;
		if (yych == 'h') goto yy42;
		goto yy10;
yy30:
		YYDEBUG(30, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'P') goto yy39;
		if (yych == 'p') goto yy39;
		goto yy10;
yy31:
		YYDEBUG(31, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'P') goto yy32;
		if (yych != 'p') goto yy10;
yy32:
		YYDEBUG(32, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy33;
		if (yych != 'h') goto yy10;
yy33:
		YYDEBUG(33, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'P') goto yy34;
		if (yych != 'p') goto yy10;
yy34:
		YYDEBUG(34, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '\'') goto yy10;
yy35:
		YYDEBUG(35, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(36, *YYCURSOR);
		if (yych <= '\r') {
			if (yych <= 0x08) goto yy10;
			if (yych <= '\n') goto yy35;
			if (yych <= '\f') goto yy10;
			goto yy35;
		} else {
			if (yych <= ' ') {
				if (yych <= 0x1F) goto yy10;
				goto yy35;
			} else {
				if (yych != '>') goto yy10;
			}
		}
		YYDEBUG(37, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(38, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1694 "Zend/zend_language_scanner.l"
		{
	YYCTYPE *bracket = (YYCTYPE*)zend_memrchr(yytext, '<', yyleng - (sizeof("script language=php>") - 1));

	if (bracket != SCNG(yy_text)) {
		/* Handle previously scanned HTML, as possible <script> tags found are assumed to not be PHP's */
		YYCURSOR = bracket;
		goto inline_html;
	}

	HANDLE_NEWLINES(yytext, yyleng);
	zendlval->value.str.val = yytext; /* no copying - intentional */
	zendlval->value.str.len = yyleng;
	zendlval->type = IS_STRING;
	BEGIN(ST_IN_SCRIPTING);
	return T_OPEN_TAG;
}
#line 1400 "Zend/zend_language_scanner.c"
yy39:
		YYDEBUG(39, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy40;
		if (yych != 'h') goto yy10;
yy40:
		YYDEBUG(40, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'P') goto yy41;
		if (yych != 'p') goto yy10;
yy41:
		YYDEBUG(41, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '"') goto yy35;
		goto yy10;
yy42:
		YYDEBUG(42, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'P') goto yy35;
		if (yych == 'p') goto yy35;
		goto yy10;
yy43:
		YYDEBUG(43, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(44, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1712 "Zend/zend_language_scanner.l"
		{
	if (CG(asp_tags)) {
		zendlval->value.str.val = yytext; /* no copying - intentional */
		zendlval->value.str.len = yyleng;
		zendlval->type = IS_STRING;
		BEGIN(ST_IN_SCRIPTING);
		return T_OPEN_TAG_WITH_ECHO;
	} else {
		goto inline_char_handler;
	}
}
#line 1439 "Zend/zend_language_scanner.c"
yy45:
		YYDEBUG(45, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(46, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1725 "Zend/zend_language_scanner.l"
		{
	zendlval->value.str.val = yytext; /* no copying - intentional */
	zendlval->value.str.len = yyleng;
	zendlval->type = IS_STRING;
	BEGIN(ST_IN_SCRIPTING);
	return T_OPEN_TAG_WITH_ECHO;
}
#line 1453 "Zend/zend_language_scanner.c"
yy47:
		YYDEBUG(47, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy48;
		if (yych != 'h') goto yy10;
yy48:
		YYDEBUG(48, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'P') goto yy49;
		if (yych != 'p') goto yy10;
yy49:
		YYDEBUG(49, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '\f') {
			if (yych <= 0x08) goto yy10;
			if (yych >= '\v') goto yy10;
		} else {
			if (yych <= '\r') goto yy52;
			if (yych != ' ') goto yy10;
		}
yy50:
		YYDEBUG(50, *YYCURSOR);
		++YYCURSOR;
yy51:
		YYDEBUG(51, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1747 "Zend/zend_language_scanner.l"
		{
	zendlval->value.str.val = yytext; /* no copying - intentional */
	zendlval->value.str.len = yyleng;
	zendlval->type = IS_STRING;
	HANDLE_NEWLINE(yytext[yyleng-1]);
	BEGIN(ST_IN_SCRIPTING);
	return T_OPEN_TAG;
}
#line 1489 "Zend/zend_language_scanner.c"
yy52:
		YYDEBUG(52, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) == '\n') goto yy50;
		goto yy51;
	}
/* *********************************** */
yyc_ST_BACKQUOTE:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(53, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych <= '_') {
			if (yych != '$') goto yy60;
		} else {
			if (yych <= '`') goto yy58;
			if (yych == '{') goto yy57;
			goto yy60;
		}
		YYDEBUG(55, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) <= '_') {
			if (yych <= '@') goto yy56;
			if (yych <= 'Z') goto yy63;
			if (yych >= '_') goto yy63;
		} else {
			if (yych <= 'z') {
				if (yych >= 'a') goto yy63;
			} else {
				if (yych <= '{') goto yy66;
				if (yych >= 0x7F) goto yy63;
			}
		}
yy56:
		YYDEBUG(56, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 2220 "Zend/zend_language_scanner.l"
		{
	if (YYCURSOR > YYLIMIT) {
		return 0;
	}
	if (yytext[0] == '\\' && YYCURSOR < YYLIMIT) {
		YYCURSOR++;
	}

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '`':
				break;
			case '$':
				if (IS_LABEL_START(*YYCURSOR) || *YYCURSOR == '{') {
					break;
				}
				continue;
			case '{':
				if (*YYCURSOR == '$') {
					break;
				}
				continue;
			case '\\':
				if (YYCURSOR < YYLIMIT) {
					YYCURSOR++;
				}
				/* fall through */
			default:
				continue;
		}

		YYCURSOR--;
		break;
	}

	yyleng = YYCURSOR - SCNG(yy_text);

	zend_scan_escape_string(zendlval, yytext, yyleng, '`' TSRMLS_CC);
	return T_ENCAPSED_AND_WHITESPACE;
}
#line 1601 "Zend/zend_language_scanner.c"
yy57:
		YYDEBUG(57, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '$') goto yy61;
		goto yy56;
yy58:
		YYDEBUG(58, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(59, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 2164 "Zend/zend_language_scanner.l"
		{
	BEGIN(ST_IN_SCRIPTING);
	return '`';
}
#line 1617 "Zend/zend_language_scanner.c"
yy60:
		YYDEBUG(60, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy56;
yy61:
		YYDEBUG(61, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(62, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 2151 "Zend/zend_language_scanner.l"
		{
	zendlval->value.lval = (long) '{';
	yy_push_state(ST_IN_SCRIPTING TSRMLS_CC);
	yyless(1);
	return T_CURLY_OPEN;
}
#line 1634 "Zend/zend_language_scanner.c"
yy63:
		YYDEBUG(63, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		YYDEBUG(64, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy63;
		}
		if (yych == '-') goto yy68;
		if (yych == '[') goto yy70;
yy65:
		YYDEBUG(65, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1851 "Zend/zend_language_scanner.l"
		{
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	zendlval->type = IS_STRING;
	return T_VARIABLE;
}
#line 1656 "Zend/zend_language_scanner.c"
yy66:
		YYDEBUG(66, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(67, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1436 "Zend/zend_language_scanner.l"
		{
	yy_push_state(ST_LOOKING_FOR_VARNAME TSRMLS_CC);
	return T_DOLLAR_OPEN_CURLY_BRACES;
}
#line 1667 "Zend/zend_language_scanner.c"
yy68:
		YYDEBUG(68, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy72;
yy69:
		YYDEBUG(69, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy65;
yy70:
		YYDEBUG(70, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(71, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1843 "Zend/zend_language_scanner.l"
		{
	yyless(yyleng - 1);
	yy_push_state(ST_VAR_OFFSET TSRMLS_CC);
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	zendlval->type = IS_STRING;
	return T_VARIABLE;
}
#line 1689 "Zend/zend_language_scanner.c"
yy72:
		YYDEBUG(72, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy69;
			if (yych <= 'Z') goto yy73;
			if (yych <= '^') goto yy69;
		} else {
			if (yych <= '`') goto yy69;
			if (yych <= 'z') goto yy73;
			if (yych <= '~') goto yy69;
		}
yy73:
		YYDEBUG(73, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(74, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1833 "Zend/zend_language_scanner.l"
		{
	yyless(yyleng - 3);
	yy_push_state(ST_LOOKING_FOR_PROPERTY TSRMLS_CC);
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	zendlval->type = IS_STRING;
	return T_VARIABLE;
}
#line 1715 "Zend/zend_language_scanner.c"
	}
/* *********************************** */
yyc_ST_DOUBLE_QUOTES:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(75, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych <= '#') {
			if (yych == '"') goto yy80;
			goto yy82;
		} else {
			if (yych <= '$') goto yy77;
			if (yych == '{') goto yy79;
			goto yy82;
		}
yy77:
		YYDEBUG(77, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) <= '_') {
			if (yych <= '@') goto yy78;
			if (yych <= 'Z') goto yy85;
			if (yych >= '_') goto yy85;
		} else {
			if (yych <= 'z') {
				if (yych >= 'a') goto yy85;
			} else {
				if (yych <= '{') goto yy88;
				if (yych >= 0x7F) goto yy85;
			}
		}
yy78:
		YYDEBUG(78, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 2170 "Zend/zend_language_scanner.l"
		{
	if (GET_DOUBLE_QUOTES_SCANNED_LENGTH()) {
		YYCURSOR += GET_DOUBLE_QUOTES_SCANNED_LENGTH() - 1;
		SET_DOUBLE_QUOTES_SCANNED_LENGTH(0);

		goto double_quotes_scan_done;
	}

	if (YYCURSOR > YYLIMIT) {
		return 0;
	}
	if (yytext[0] == '\\' && YYCURSOR < YYLIMIT) {
		YYCURSOR++;
	}

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '"':
				break;
			case '$':
				if (IS_LABEL_START(*YYCURSOR) || *YYCURSOR == '{') {
					break;
				}
				continue;
			case '{':
				if (*YYCURSOR == '$') {
					break;
				}
				continue;
			case '\\':
				if (YYCURSOR < YYLIMIT) {
					YYCURSOR++;
				}
				/* fall through */
			default:
				continue;
		}

		YYCURSOR--;
		break;
	}

double_quotes_scan_done:
	yyleng = YYCURSOR - SCNG(yy_text);

	zend_scan_escape_string(zendlval, yytext, yyleng, '"' TSRMLS_CC);
	return T_ENCAPSED_AND_WHITESPACE;
}
#line 1832 "Zend/zend_language_scanner.c"
yy79:
		YYDEBUG(79, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '$') goto yy83;
		goto yy78;
yy80:
		YYDEBUG(80, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(81, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 2159 "Zend/zend_language_scanner.l"
		{
	BEGIN(ST_IN_SCRIPTING);
	return '"';
}
#line 1848 "Zend/zend_language_scanner.c"
yy82:
		YYDEBUG(82, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy78;
yy83:
		YYDEBUG(83, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(84, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 2151 "Zend/zend_language_scanner.l"
		{
	zendlval->value.lval = (long) '{';
	yy_push_state(ST_IN_SCRIPTING TSRMLS_CC);
	yyless(1);
	return T_CURLY_OPEN;
}
#line 1865 "Zend/zend_language_scanner.c"
yy85:
		YYDEBUG(85, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		YYDEBUG(86, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy85;
		}
		if (yych == '-') goto yy90;
		if (yych == '[') goto yy92;
yy87:
		YYDEBUG(87, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1851 "Zend/zend_language_scanner.l"
		{
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	zendlval->type = IS_STRING;
	return T_VARIABLE;
}
#line 1887 "Zend/zend_language_scanner.c"
yy88:
		YYDEBUG(88, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(89, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1436 "Zend/zend_language_scanner.l"
		{
	yy_push_state(ST_LOOKING_FOR_VARNAME TSRMLS_CC);
	return T_DOLLAR_OPEN_CURLY_BRACES;
}
#line 1898 "Zend/zend_language_scanner.c"
yy90:
		YYDEBUG(90, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy94;
yy91:
		YYDEBUG(91, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy87;
yy92:
		YYDEBUG(92, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(93, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1843 "Zend/zend_language_scanner.l"
		{
	yyless(yyleng - 1);
	yy_push_state(ST_VAR_OFFSET TSRMLS_CC);
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	zendlval->type = IS_STRING;
	return T_VARIABLE;
}
#line 1920 "Zend/zend_language_scanner.c"
yy94:
		YYDEBUG(94, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy91;
			if (yych <= 'Z') goto yy95;
			if (yych <= '^') goto yy91;
		} else {
			if (yych <= '`') goto yy91;
			if (yych <= 'z') goto yy95;
			if (yych <= '~') goto yy91;
		}
yy95:
		YYDEBUG(95, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(96, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1833 "Zend/zend_language_scanner.l"
		{
	yyless(yyleng - 3);
	yy_push_state(ST_LOOKING_FOR_PROPERTY TSRMLS_CC);
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	zendlval->type = IS_STRING;
	return T_VARIABLE;
}
#line 1946 "Zend/zend_language_scanner.c"
	}
/* *********************************** */
yyc_ST_END_HEREDOC:
	YYDEBUG(97, *YYCURSOR);
	YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(99, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(100, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
#line 2138 "Zend/zend_language_scanner.l"
	{
	YYCURSOR += CG(heredoc_len) - 1;
	yyleng = CG(heredoc_len);

	Z_STRVAL_P(zendlval) = CG(heredoc);
	Z_STRLEN_P(zendlval) = CG(heredoc_len);
	CG(heredoc) = NULL;
	CG(heredoc_len) = 0;
	BEGIN(ST_IN_SCRIPTING);
	return T_END_HEREDOC;
}
#line 1969 "Zend/zend_language_scanner.c"
/* *********************************** */
yyc_ST_HEREDOC:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(101, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych == '$') goto yy103;
		if (yych == '{') goto yy105;
		goto yy106;
yy103:
		YYDEBUG(103, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) <= '_') {
			if (yych <= '@') goto yy104;
			if (yych <= 'Z') goto yy109;
			if (yych >= '_') goto yy109;
		} else {
			if (yych <= 'z') {
				if (yych >= 'a') goto yy109;
			} else {
				if (yych <= '{') goto yy112;
				if (yych >= 0x7F) goto yy109;
			}
		}
yy104:
		YYDEBUG(104, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 2262 "Zend/zend_language_scanner.l"
		{
	int newline = 0;

	if (YYCURSOR > YYLIMIT) {
		return 0;
	}

	YYCURSOR--;

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '\r':
				if (*YYCURSOR == '\n') {
					YYCURSOR++;
				}
				/* fall through */
			case '\n':
				/* Check for ending label on the next line */
				if (IS_LABEL_START(*YYCURSOR) && CG(heredoc_len) < YYLIMIT - YYCURSOR && !memcmp(YYCURSOR, CG(heredoc), CG(heredoc_len))) {
					YYCTYPE *end = YYCURSOR + CG(heredoc_len);

					if (*end == ';') {
						end++;
					}

					if (*end == '\n' || *end == '\r') {
						/* newline before label will be subtracted from returned text, but
						 * yyleng/yytext will include it, for zend_highlight/strip, tokenizer, etc. */
						if (YYCURSOR[-2] == '\r' && YYCURSOR[-1] == '\n') {
							newline = 2; /* Windows newline */
						} else {
							newline = 1;
						}

						CG(increment_lineno) = 1; /* For newline before label */
						BEGIN(ST_END_HEREDOC);

						goto heredoc_scan_done;
					}
				}
				continue;
			case '$':
				if (IS_LABEL_START(*YYCURSOR) || *YYCURSOR == '{') {
					break;
				}
				continue;
			case '{':
				if (*YYCURSOR == '$') {
					break;
				}
				continue;
			case '\\':
				if (YYCURSOR < YYLIMIT && *YYCURSOR != '\n' && *YYCURSOR != '\r') {
					YYCURSOR++;
				}
				/* fall through */
			default:
				continue;
		}

		YYCURSOR--;
		break;
	}

heredoc_scan_done:
	yyleng = YYCURSOR - SCNG(yy_text);

	zend_scan_escape_string(zendlval, yytext, yyleng - newline, 0 TSRMLS_CC);
	return T_ENCAPSED_AND_WHITESPACE;
}
#line 2102 "Zend/zend_language_scanner.c"
yy105:
		YYDEBUG(105, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '$') goto yy107;
		goto yy104;
yy106:
		YYDEBUG(106, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy104;
yy107:
		YYDEBUG(107, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(108, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 2151 "Zend/zend_language_scanner.l"
		{
	zendlval->value.lval = (long) '{';
	yy_push_state(ST_IN_SCRIPTING TSRMLS_CC);
	yyless(1);
	return T_CURLY_OPEN;
}
#line 2124 "Zend/zend_language_scanner.c"
yy109:
		YYDEBUG(109, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		YYDEBUG(110, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy109;
		}
		if (yych == '-') goto yy114;
		if (yych == '[') goto yy116;
yy111:
		YYDEBUG(111, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1851 "Zend/zend_language_scanner.l"
		{
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	zendlval->type = IS_STRING;
	return T_VARIABLE;
}
#line 2146 "Zend/zend_language_scanner.c"
yy112:
		YYDEBUG(112, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(113, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1436 "Zend/zend_language_scanner.l"
		{
	yy_push_state(ST_LOOKING_FOR_VARNAME TSRMLS_CC);
	return T_DOLLAR_OPEN_CURLY_BRACES;
}
#line 2157 "Zend/zend_language_scanner.c"
yy114:
		YYDEBUG(114, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy118;
yy115:
		YYDEBUG(115, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy111;
yy116:
		YYDEBUG(116, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(117, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1843 "Zend/zend_language_scanner.l"
		{
	yyless(yyleng - 1);
	yy_push_state(ST_VAR_OFFSET TSRMLS_CC);
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	zendlval->type = IS_STRING;
	return T_VARIABLE;
}
#line 2179 "Zend/zend_language_scanner.c"
yy118:
		YYDEBUG(118, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy115;
			if (yych <= 'Z') goto yy119;
			if (yych <= '^') goto yy115;
		} else {
			if (yych <= '`') goto yy115;
			if (yych <= 'z') goto yy119;
			if (yych <= '~') goto yy115;
		}
yy119:
		YYDEBUG(119, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(120, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1833 "Zend/zend_language_scanner.l"
		{
	yyless(yyleng - 3);
	yy_push_state(ST_LOOKING_FOR_PROPERTY TSRMLS_CC);
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	zendlval->type = IS_STRING;
	return T_VARIABLE;
}
#line 2205 "Zend/zend_language_scanner.c"
	}
/* *********************************** */
yyc_ST_IN_SCRIPTING:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0, 192,  64,   0,   0,  64,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			192,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			 60,  60,  44,  44,  44,  44,  44,  44, 
			 44,  44,   0,   0,   0,   0,   0,   0, 
			  0,  36,  36,  36,  36,  36,  36,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   0,   0,   0,   0,   4, 
			  0,  36,  36,  36,  36,  36,  36,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   0,   0,   0,   0,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
		};
		YYDEBUG(121, *YYCURSOR);
		YYFILL(16);
		yych = *YYCURSOR;
		YYDEBUG(-1, yych);
		switch (yych) {
		case 0x00:
		case 0x01:
		case 0x02:
		case 0x03:
		case 0x04:
		case 0x05:
		case 0x06:
		case 0x07:
		case 0x08:
		case '\v':
		case '\f':
		case 0x0E:
		case 0x0F:
		case 0x10:
		case 0x11:
		case 0x12:
		case 0x13:
		case 0x14:
		case 0x15:
		case 0x16:
		case 0x17:
		case 0x18:
		case 0x19:
		case 0x1A:
		case 0x1B:
		case 0x1C:
		case 0x1D:
		case 0x1E:
		case 0x1F:	goto yy183;
		case '\t':
		case '\n':
		case '\r':
		case ' ':	goto yy139;
		case '!':	goto yy152;
		case '"':	goto yy179;
		case '#':	goto yy175;
		case '$':	goto yy164;
		case '%':	goto yy158;
		case '&':	goto yy159;
		case '\'':	goto yy177;
		case '(':	goto yy146;
		case ')':
		case ',':
		case ';':
		case '@':
		case '[':
		case ']':
		case '~':	goto yy165;
		case '*':	goto yy155;
		case '+':	goto yy151;
		case '-':	goto yy137;
		case '.':	goto yy157;
		case '/':	goto yy156;
		case '0':	goto yy171;
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':	goto yy173;
		case ':':	goto yy141;
		case '<':	goto yy153;
		case '=':	goto yy149;
		case '>':	goto yy154;
		case '?':	goto yy166;
		case 'A':
		case 'a':	goto yy132;
		case 'B':
		case 'b':	goto yy134;
		case 'C':
		case 'c':	goto yy127;
		case 'D':
		case 'd':	goto yy125;
		case 'E':
		case 'e':	goto yy123;
		case 'F':
		case 'f':	goto yy126;
		case 'G':
		case 'g':	goto yy135;
		case 'I':
		case 'i':	goto yy130;
		case 'L':
		case 'l':	goto yy150;
		case 'N':
		case 'n':	goto yy144;
		case 'O':
		case 'o':	goto yy162;
		case 'P':
		case 'p':	goto yy136;
		case 'R':
		case 'r':	goto yy128;
		case 'S':
		case 's':	goto yy133;
		case 'T':
		case 't':	goto yy129;
		case 'U':
		case 'u':	goto yy147;
		case 'V':
		case 'v':	goto yy145;
		case 'W':
		case 'w':	goto yy131;
		case 'X':
		case 'x':	goto yy163;
		case '\\':	goto yy142;
		case '^':	goto yy161;
		case '_':	goto yy148;
		case '`':	goto yy181;
		case '{':	goto yy167;
		case '|':	goto yy160;
		case '}':	goto yy169;
		default:	goto yy174;
		}
yy123:
		YYDEBUG(123, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(-1, yych);
		switch ((yych = *YYCURSOR)) {
		case 'C':
		case 'c':	goto yy726;
		case 'L':
		case 'l':	goto yy727;
		case 'M':
		case 'm':	goto yy728;
		case 'N':
		case 'n':	goto yy729;
		case 'V':
		case 'v':	goto yy730;
		case 'X':
		case 'x':	goto yy731;
		default:	goto yy186;
		}
yy124:
		YYDEBUG(124, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1874 "Zend/zend_language_scanner.l"
		{
	zend_copy_value(zendlval, yytext, yyleng);
	zendlval->type = IS_STRING;
	return T_STRING;
}
#line 2392 "Zend/zend_language_scanner.c"
yy125:
		YYDEBUG(125, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'O') {
			if (yych <= 'H') {
				if (yych == 'E') goto yy708;
				goto yy186;
			} else {
				if (yych <= 'I') goto yy709;
				if (yych <= 'N') goto yy186;
				goto yy710;
			}
		} else {
			if (yych <= 'h') {
				if (yych == 'e') goto yy708;
				goto yy186;
			} else {
				if (yych <= 'i') goto yy709;
				if (yych == 'o') goto yy710;
				goto yy186;
			}
		}
yy126:
		YYDEBUG(126, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'U') {
			if (yych <= 'N') {
				if (yych == 'I') goto yy687;
				goto yy186;
			} else {
				if (yych <= 'O') goto yy688;
				if (yych <= 'T') goto yy186;
				goto yy689;
			}
		} else {
			if (yych <= 'n') {
				if (yych == 'i') goto yy687;
				goto yy186;
			} else {
				if (yych <= 'o') goto yy688;
				if (yych == 'u') goto yy689;
				goto yy186;
			}
		}
yy127:
		YYDEBUG(127, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'O') {
			if (yych <= 'K') {
				if (yych == 'A') goto yy652;
				goto yy186;
			} else {
				if (yych <= 'L') goto yy653;
				if (yych <= 'N') goto yy186;
				goto yy654;
			}
		} else {
			if (yych <= 'k') {
				if (yych == 'a') goto yy652;
				goto yy186;
			} else {
				if (yych <= 'l') goto yy653;
				if (yych == 'o') goto yy654;
				goto yy186;
			}
		}
yy128:
		YYDEBUG(128, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy634;
		if (yych == 'e') goto yy634;
		goto yy186;
yy129:
		YYDEBUG(129, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'R') {
			if (yych == 'H') goto yy622;
			if (yych <= 'Q') goto yy186;
			goto yy623;
		} else {
			if (yych <= 'h') {
				if (yych <= 'g') goto yy186;
				goto yy622;
			} else {
				if (yych == 'r') goto yy623;
				goto yy186;
			}
		}
yy130:
		YYDEBUG(130, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'S') {
			if (yych <= 'L') {
				if (yych == 'F') goto yy569;
				goto yy186;
			} else {
				if (yych <= 'M') goto yy571;
				if (yych <= 'N') goto yy572;
				if (yych <= 'R') goto yy186;
				goto yy573;
			}
		} else {
			if (yych <= 'm') {
				if (yych == 'f') goto yy569;
				if (yych <= 'l') goto yy186;
				goto yy571;
			} else {
				if (yych <= 'n') goto yy572;
				if (yych == 's') goto yy573;
				goto yy186;
			}
		}
yy131:
		YYDEBUG(131, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy564;
		if (yych == 'h') goto yy564;
		goto yy186;
yy132:
		YYDEBUG(132, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'S') {
			if (yych <= 'M') {
				if (yych == 'B') goto yy546;
				goto yy186;
			} else {
				if (yych <= 'N') goto yy547;
				if (yych <= 'Q') goto yy186;
				if (yych <= 'R') goto yy548;
				goto yy549;
			}
		} else {
			if (yych <= 'n') {
				if (yych == 'b') goto yy546;
				if (yych <= 'm') goto yy186;
				goto yy547;
			} else {
				if (yych <= 'q') goto yy186;
				if (yych <= 'r') goto yy548;
				if (yych <= 's') goto yy549;
				goto yy186;
			}
		}
yy133:
		YYDEBUG(133, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'W') {
			if (yych == 'T') goto yy534;
			if (yych <= 'V') goto yy186;
			goto yy535;
		} else {
			if (yych <= 't') {
				if (yych <= 's') goto yy186;
				goto yy534;
			} else {
				if (yych == 'w') goto yy535;
				goto yy186;
			}
		}
yy134:
		YYDEBUG(134, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= ';') {
			if (yych <= '"') {
				if (yych <= '!') goto yy186;
				goto yy526;
			} else {
				if (yych == '\'') goto yy527;
				goto yy186;
			}
		} else {
			if (yych <= 'R') {
				if (yych <= '<') goto yy525;
				if (yych <= 'Q') goto yy186;
				goto yy528;
			} else {
				if (yych == 'r') goto yy528;
				goto yy186;
			}
		}
yy135:
		YYDEBUG(135, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'O') {
			if (yych == 'L') goto yy515;
			if (yych <= 'N') goto yy186;
			goto yy516;
		} else {
			if (yych <= 'l') {
				if (yych <= 'k') goto yy186;
				goto yy515;
			} else {
				if (yych == 'o') goto yy516;
				goto yy186;
			}
		}
yy136:
		YYDEBUG(136, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'U') {
			if (yych == 'R') goto yy491;
			if (yych <= 'T') goto yy186;
			goto yy492;
		} else {
			if (yych <= 'r') {
				if (yych <= 'q') goto yy186;
				goto yy491;
			} else {
				if (yych == 'u') goto yy492;
				goto yy186;
			}
		}
yy137:
		YYDEBUG(137, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) <= '<') {
			if (yych == '-') goto yy487;
		} else {
			if (yych <= '=') goto yy485;
			if (yych <= '>') goto yy489;
		}
yy138:
		YYDEBUG(138, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1425 "Zend/zend_language_scanner.l"
		{
	return yytext[0];
}
#line 2622 "Zend/zend_language_scanner.c"
yy139:
		YYDEBUG(139, *YYCURSOR);
		++YYCURSOR;
		yych = *YYCURSOR;
		goto yy484;
yy140:
		YYDEBUG(140, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1156 "Zend/zend_language_scanner.l"
		{
	zendlval->value.str.val = yytext; /* no copying - intentional */
	zendlval->value.str.len = yyleng;
	zendlval->type = IS_STRING;
	HANDLE_NEWLINES(yytext, yyleng);
	return T_WHITESPACE;
}
#line 2639 "Zend/zend_language_scanner.c"
yy141:
		YYDEBUG(141, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == ':') goto yy481;
		goto yy138;
yy142:
		YYDEBUG(142, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(143, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1185 "Zend/zend_language_scanner.l"
		{
	return T_NS_SEPARATOR;
}
#line 2654 "Zend/zend_language_scanner.c"
yy144:
		YYDEBUG(144, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'E') {
			if (yych == 'A') goto yy469;
			if (yych <= 'D') goto yy186;
			goto yy470;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy186;
				goto yy469;
			} else {
				if (yych == 'e') goto yy470;
				goto yy186;
			}
		}
yy145:
		YYDEBUG(145, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy466;
		if (yych == 'a') goto yy466;
		goto yy186;
yy146:
		YYDEBUG(146, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'S') {
			if (yych <= 'D') {
				if (yych <= ' ') {
					if (yych == '\t') goto yy391;
					if (yych <= 0x1F) goto yy138;
					goto yy391;
				} else {
					if (yych <= '@') goto yy138;
					if (yych == 'C') goto yy138;
					goto yy391;
				}
			} else {
				if (yych <= 'I') {
					if (yych == 'F') goto yy391;
					if (yych <= 'H') goto yy138;
					goto yy391;
				} else {
					if (yych == 'O') goto yy391;
					if (yych <= 'Q') goto yy138;
					goto yy391;
				}
			}
		} else {
			if (yych <= 'f') {
				if (yych <= 'b') {
					if (yych == 'U') goto yy391;
					if (yych <= '`') goto yy138;
					goto yy391;
				} else {
					if (yych == 'd') goto yy391;
					if (yych <= 'e') goto yy138;
					goto yy391;
				}
			} else {
				if (yych <= 'o') {
					if (yych == 'i') goto yy391;
					if (yych <= 'n') goto yy138;
					goto yy391;
				} else {
					if (yych <= 's') {
						if (yych <= 'q') goto yy138;
						goto yy391;
					} else {
						if (yych == 'u') goto yy391;
						goto yy138;
					}
				}
			}
		}
yy147:
		YYDEBUG(147, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'S') {
			if (yych == 'N') goto yy382;
			if (yych <= 'R') goto yy186;
			goto yy383;
		} else {
			if (yych <= 'n') {
				if (yych <= 'm') goto yy186;
				goto yy382;
			} else {
				if (yych == 's') goto yy383;
				goto yy186;
			}
		}
yy148:
		YYDEBUG(148, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy300;
		goto yy186;
yy149:
		YYDEBUG(149, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '<') goto yy138;
		if (yych <= '=') goto yy294;
		if (yych <= '>') goto yy296;
		goto yy138;
yy150:
		YYDEBUG(150, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy290;
		if (yych == 'i') goto yy290;
		goto yy186;
yy151:
		YYDEBUG(151, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '+') goto yy288;
		if (yych == '=') goto yy286;
		goto yy138;
yy152:
		YYDEBUG(152, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy283;
		goto yy138;
yy153:
		YYDEBUG(153, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= ';') {
			if (yych == '/') goto yy255;
			goto yy138;
		} else {
			if (yych <= '<') goto yy253;
			if (yych <= '=') goto yy256;
			if (yych <= '>') goto yy258;
			goto yy138;
		}
yy154:
		YYDEBUG(154, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '<') goto yy138;
		if (yych <= '=') goto yy249;
		if (yych <= '>') goto yy247;
		goto yy138;
yy155:
		YYDEBUG(155, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy245;
		goto yy138;
yy156:
		YYDEBUG(156, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '.') {
			if (yych == '*') goto yy237;
			goto yy138;
		} else {
			if (yych <= '/') goto yy239;
			if (yych == '=') goto yy240;
			goto yy138;
		}
yy157:
		YYDEBUG(157, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '/') goto yy138;
		if (yych <= '9') goto yy233;
		if (yych == '=') goto yy235;
		goto yy138;
yy158:
		YYDEBUG(158, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '<') goto yy138;
		if (yych <= '=') goto yy229;
		if (yych <= '>') goto yy227;
		goto yy138;
yy159:
		YYDEBUG(159, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '&') goto yy223;
		if (yych == '=') goto yy225;
		goto yy138;
yy160:
		YYDEBUG(160, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy221;
		if (yych == '|') goto yy219;
		goto yy138;
yy161:
		YYDEBUG(161, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy217;
		goto yy138;
yy162:
		YYDEBUG(162, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy215;
		if (yych == 'r') goto yy215;
		goto yy186;
yy163:
		YYDEBUG(163, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy212;
		if (yych == 'o') goto yy212;
		goto yy186;
yy164:
		YYDEBUG(164, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy138;
			if (yych <= 'Z') goto yy209;
			if (yych <= '^') goto yy138;
			goto yy209;
		} else {
			if (yych <= '`') goto yy138;
			if (yych <= 'z') goto yy209;
			if (yych <= '~') goto yy138;
			goto yy209;
		}
yy165:
		YYDEBUG(165, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy138;
yy166:
		YYDEBUG(166, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy205;
		goto yy138;
yy167:
		YYDEBUG(167, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(168, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1430 "Zend/zend_language_scanner.l"
		{
	yy_push_state(ST_IN_SCRIPTING TSRMLS_CC);
	return '{';
}
#line 2887 "Zend/zend_language_scanner.c"
yy169:
		YYDEBUG(169, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(170, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1442 "Zend/zend_language_scanner.l"
		{
	RESET_DOC_COMMENT();
	if (!zend_stack_is_empty(&SCNG(state_stack))) {
		yy_pop_state(TSRMLS_C);
	}
	return '}';
}
#line 2901 "Zend/zend_language_scanner.c"
yy171:
		YYDEBUG(171, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'E') {
			if (yych <= '9') {
				if (yych == '.') goto yy187;
				if (yych >= '0') goto yy190;
			} else {
				if (yych == 'B') goto yy198;
				if (yych >= 'E') goto yy192;
			}
		} else {
			if (yych <= 'b') {
				if (yych == 'X') goto yy197;
				if (yych >= 'b') goto yy198;
			} else {
				if (yych <= 'e') {
					if (yych >= 'e') goto yy192;
				} else {
					if (yych == 'x') goto yy197;
				}
			}
		}
yy172:
		YYDEBUG(172, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1488 "Zend/zend_language_scanner.l"
		{
	if (yyleng < MAX_LENGTH_OF_LONG - 1) { /* Won't overflow */
		zendlval->value.lval = strtol(yytext, NULL, 0);
	} else {
		errno = 0;
		zendlval->value.lval = strtol(yytext, NULL, 0);
		if (errno == ERANGE) { /* Overflow */
			if (yytext[0] == '0') { /* octal overflow */
				zendlval->value.dval = zend_oct_strtod(yytext, NULL);
			} else {
				zendlval->value.dval = zend_strtod(yytext, NULL);
			}
			zendlval->type = IS_DOUBLE;
			return T_DNUMBER;
		}
	}

	zendlval->type = IS_LONG;
	return T_LNUMBER;
}
#line 2950 "Zend/zend_language_scanner.c"
yy173:
		YYDEBUG(173, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '9') {
			if (yych == '.') goto yy187;
			if (yych <= '/') goto yy172;
			goto yy190;
		} else {
			if (yych <= 'E') {
				if (yych <= 'D') goto yy172;
				goto yy192;
			} else {
				if (yych == 'e') goto yy192;
				goto yy172;
			}
		}
yy174:
		YYDEBUG(174, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy186;
yy175:
		YYDEBUG(175, *YYCURSOR);
		++YYCURSOR;
yy176:
		YYDEBUG(176, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1881 "Zend/zend_language_scanner.l"
		{
	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '\r':
				if (*YYCURSOR == '\n') {
					YYCURSOR++;
				}
				/* fall through */
			case '\n':
				CG(zend_lineno)++;
				break;
			case '%':
				if (!CG(asp_tags)) {
					continue;
				}
				/* fall through */
			case '?':
				if (*YYCURSOR == '>') {
					YYCURSOR--;
					break;
				}
				/* fall through */
			default:
				continue;
		}

		break;
	}

	yyleng = YYCURSOR - SCNG(yy_text);

	return T_COMMENT;
}
#line 3012 "Zend/zend_language_scanner.c"
yy177:
		YYDEBUG(177, *YYCURSOR);
		++YYCURSOR;
yy178:
		YYDEBUG(178, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1972 "Zend/zend_language_scanner.l"
		{
	register char *s, *t;
	char *end;
	int bprefix = (yytext[0] != '\'') ? 1 : 0;

	while (1) {
		if (YYCURSOR < YYLIMIT) {
			if (*YYCURSOR == '\'') {
				YYCURSOR++;
				yyleng = YYCURSOR - SCNG(yy_text);

				break;
			} else if (*YYCURSOR++ == '\\' && YYCURSOR < YYLIMIT) {
				YYCURSOR++;
			}
		} else {
			yyleng = YYLIMIT - SCNG(yy_text);

			/* Unclosed single quotes; treat similar to double quotes, but without a separate token
			 * for ' (unrecognized by parser), instead of old flex fallback to "Unexpected character..."
			 * rule, which continued in ST_IN_SCRIPTING state after the quote */
			return T_ENCAPSED_AND_WHITESPACE;
		}
	}

	zendlval->value.str.val = estrndup(yytext+bprefix+1, yyleng-bprefix-2);
	zendlval->value.str.len = yyleng-bprefix-2;
	zendlval->type = IS_STRING;

	/* convert escape sequences */
	s = t = zendlval->value.str.val;
	end = s+zendlval->value.str.len;
	while (s<end) {
		if (*s=='\\') {
			s++;

			switch(*s) {
				case '\\':
				case '\'':
					*t++ = *s;
					zendlval->value.str.len--;
					break;
				default:
					*t++ = '\\';
					*t++ = *s;
					break;
			}
		} else {
			*t++ = *s;
		}

		if (*s == '\n' || (*s == '\r' && (*(s+1) != '\n'))) {
			CG(zend_lineno)++;
		}
		s++;
	}
	*t = 0;

	if (SCNG(output_filter)) {
		size_t sz = 0;
		s = zendlval->value.str.val;
		SCNG(output_filter)((unsigned char **)&(zendlval->value.str.val), &sz, (unsigned char *)s, (size_t)zendlval->value.str.len TSRMLS_CC);
		zendlval->value.str.len = sz;
		efree(s);
	}
	return T_CONSTANT_ENCAPSED_STRING;
}
#line 3087 "Zend/zend_language_scanner.c"
yy179:
		YYDEBUG(179, *YYCURSOR);
		++YYCURSOR;
yy180:
		YYDEBUG(180, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 2041 "Zend/zend_language_scanner.l"
		{
	int bprefix = (yytext[0] != '"') ? 1 : 0;

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '"':
				yyleng = YYCURSOR - SCNG(yy_text);
				zend_scan_escape_string(zendlval, yytext+bprefix+1, yyleng-bprefix-2, '"' TSRMLS_CC);
				return T_CONSTANT_ENCAPSED_STRING;
			case '$':
				if (IS_LABEL_START(*YYCURSOR) || *YYCURSOR == '{') {
					break;
				}
				continue;
			case '{':
				if (*YYCURSOR == '$') {
					break;
				}
				continue;
			case '\\':
				if (YYCURSOR < YYLIMIT) {
					YYCURSOR++;
				}
				/* fall through */
			default:
				continue;
		}

		YYCURSOR--;
		break;
	}

	/* Remember how much was scanned to save rescanning */
	SET_DOUBLE_QUOTES_SCANNED_LENGTH(YYCURSOR - SCNG(yy_text) - yyleng);

	YYCURSOR = SCNG(yy_text) + yyleng;

	BEGIN(ST_DOUBLE_QUOTES);
	return '"';
}
#line 3135 "Zend/zend_language_scanner.c"
yy181:
		YYDEBUG(181, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(182, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 2132 "Zend/zend_language_scanner.l"
		{
	BEGIN(ST_BACKQUOTE);
	return '`';
}
#line 3146 "Zend/zend_language_scanner.c"
yy183:
		YYDEBUG(183, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(184, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 2390 "Zend/zend_language_scanner.l"
		{
	if (YYCURSOR > YYLIMIT) {
		return 0;
	}

	zend_error(E_COMPILE_WARNING,"Unexpected character in input:  '%c' (ASCII=%d) state=%d", yytext[0], yytext[0], YYSTATE);
	goto restart;
}
#line 3161 "Zend/zend_language_scanner.c"
yy185:
		YYDEBUG(185, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy186:
		YYDEBUG(186, *YYCURSOR);
		if (yybm[0+yych] & 4) {
			goto yy185;
		}
		goto yy124;
yy187:
		YYDEBUG(187, *YYCURSOR);
		yyaccept = 3;
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		YYDEBUG(188, *YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy187;
		}
		if (yych == 'E') goto yy192;
		if (yych == 'e') goto yy192;
yy189:
		YYDEBUG(189, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1549 "Zend/zend_language_scanner.l"
		{
	zendlval->value.dval = zend_strtod(yytext, NULL);
	zendlval->type = IS_DOUBLE;
	return T_DNUMBER;
}
#line 3194 "Zend/zend_language_scanner.c"
yy190:
		YYDEBUG(190, *YYCURSOR);
		yyaccept = 2;
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		YYDEBUG(191, *YYCURSOR);
		if (yych <= '9') {
			if (yych == '.') goto yy187;
			if (yych <= '/') goto yy172;
			goto yy190;
		} else {
			if (yych <= 'E') {
				if (yych <= 'D') goto yy172;
			} else {
				if (yych != 'e') goto yy172;
			}
		}
yy192:
		YYDEBUG(192, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= ',') {
			if (yych == '+') goto yy194;
		} else {
			if (yych <= '-') goto yy194;
			if (yych <= '/') goto yy193;
			if (yych <= '9') goto yy195;
		}
yy193:
		YYDEBUG(193, *YYCURSOR);
		YYCURSOR = YYMARKER;
		if (yyaccept <= 2) {
			if (yyaccept <= 1) {
				if (yyaccept <= 0) {
					goto yy124;
				} else {
					goto yy138;
				}
			} else {
				goto yy172;
			}
		} else {
			if (yyaccept <= 4) {
				if (yyaccept <= 3) {
					goto yy189;
				} else {
					goto yy238;
				}
			} else {
				goto yy254;
			}
		}
yy194:
		YYDEBUG(194, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '/') goto yy193;
		if (yych >= ':') goto yy193;
yy195:
		YYDEBUG(195, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(196, *YYCURSOR);
		if (yych <= '/') goto yy189;
		if (yych <= '9') goto yy195;
		goto yy189;
yy197:
		YYDEBUG(197, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 32) {
			goto yy202;
		}
		goto yy193;
yy198:
		YYDEBUG(198, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy199;
		}
		goto yy193;
yy199:
		YYDEBUG(199, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(200, *YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy199;
		}
		YYDEBUG(201, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1467 "Zend/zend_language_scanner.l"
		{
	char *bin = yytext + 2; /* Skip "0b" */
	int len = yyleng - 2;

	/* Skip any leading 0s */
	while (*bin == '0') {
		++bin;
		--len;
	}

	if (len < SIZEOF_LONG * 8) {
		zendlval->value.lval = strtol(bin, NULL, 2);
		zendlval->type = IS_LONG;
		return T_LNUMBER;
	} else {
		zendlval->value.dval = zend_bin_strtod(bin, NULL);
		zendlval->type = IS_DOUBLE;
		return T_DNUMBER;
	}
}
#line 3307 "Zend/zend_language_scanner.c"
yy202:
		YYDEBUG(202, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(203, *YYCURSOR);
		if (yybm[0+yych] & 32) {
			goto yy202;
		}
		YYDEBUG(204, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1509 "Zend/zend_language_scanner.l"
		{
	char *hex = yytext + 2; /* Skip "0x" */
	int len = yyleng - 2;

	/* Skip any leading 0s */
	while (*hex == '0') {
		hex++;
		len--;
	}

	if (len < SIZEOF_LONG * 2 || (len == SIZEOF_LONG * 2 && *hex <= '7')) {
		zendlval->value.lval = strtol(hex, NULL, 16);
		zendlval->type = IS_LONG;
		return T_LNUMBER;
	} else {
		zendlval->value.dval = zend_hex_strtod(hex, NULL);
		zendlval->type = IS_DOUBLE;
		return T_DNUMBER;
	}
}
#line 3340 "Zend/zend_language_scanner.c"
yy205:
		YYDEBUG(205, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) == '\n') goto yy207;
		if (yych == '\r') goto yy208;
yy206:
		YYDEBUG(206, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1949 "Zend/zend_language_scanner.l"
		{
	zendlval->value.str.val = yytext; /* no copying - intentional */
	zendlval->value.str.len = yyleng;
	zendlval->type = IS_STRING;
	BEGIN(INITIAL);
	return T_CLOSE_TAG;  /* implicit ';' at php-end tag */
}
#line 3357 "Zend/zend_language_scanner.c"
yy207:
		YYDEBUG(207, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy206;
yy208:
		YYDEBUG(208, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy207;
		goto yy206;
yy209:
		YYDEBUG(209, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(210, *YYCURSOR);
		if (yych <= '^') {
			if (yych <= '9') {
				if (yych >= '0') goto yy209;
			} else {
				if (yych <= '@') goto yy211;
				if (yych <= 'Z') goto yy209;
			}
		} else {
			if (yych <= '`') {
				if (yych <= '_') goto yy209;
			} else {
				if (yych <= 'z') goto yy209;
				if (yych >= 0x7F) goto yy209;
			}
		}
yy211:
		YYDEBUG(211, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1851 "Zend/zend_language_scanner.l"
		{
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	zendlval->type = IS_STRING;
	return T_VARIABLE;
}
#line 3397 "Zend/zend_language_scanner.c"
yy212:
		YYDEBUG(212, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy213;
		if (yych != 'r') goto yy186;
yy213:
		YYDEBUG(213, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy185;
		}
		YYDEBUG(214, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1413 "Zend/zend_language_scanner.l"
		{
	return T_LOGICAL_XOR;
}
#line 3415 "Zend/zend_language_scanner.c"
yy215:
		YYDEBUG(215, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy185;
		}
		YYDEBUG(216, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1405 "Zend/zend_language_scanner.l"
		{
	return T_LOGICAL_OR;
}
#line 3428 "Zend/zend_language_scanner.c"
yy217:
		YYDEBUG(217, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(218, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1393 "Zend/zend_language_scanner.l"
		{
	return T_XOR_EQUAL;
}
#line 3438 "Zend/zend_language_scanner.c"
yy219:
		YYDEBUG(219, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(220, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1397 "Zend/zend_language_scanner.l"
		{
	return T_BOOLEAN_OR;
}
#line 3448 "Zend/zend_language_scanner.c"
yy221:
		YYDEBUG(221, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(222, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1389 "Zend/zend_language_scanner.l"
		{
	return T_OR_EQUAL;
}
#line 3458 "Zend/zend_language_scanner.c"
yy223:
		YYDEBUG(223, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(224, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1401 "Zend/zend_language_scanner.l"
		{
	return T_BOOLEAN_AND;
}
#line 3468 "Zend/zend_language_scanner.c"
yy225:
		YYDEBUG(225, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(226, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1385 "Zend/zend_language_scanner.l"
		{
	return T_AND_EQUAL;
}
#line 3478 "Zend/zend_language_scanner.c"
yy227:
		YYDEBUG(227, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) == '\n') goto yy231;
		if (yych == '\r') goto yy232;
yy228:
		YYDEBUG(228, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1958 "Zend/zend_language_scanner.l"
		{
	if (CG(asp_tags)) {
		BEGIN(INITIAL);
		zendlval->value.str.len = yyleng;
		zendlval->type = IS_STRING;
		zendlval->value.str.val = yytext; /* no copying - intentional */
		return T_CLOSE_TAG;  /* implicit ';' at php-end tag */
	} else {
		yyless(1);
		return yytext[0];
	}
}
#line 3500 "Zend/zend_language_scanner.c"
yy229:
		YYDEBUG(229, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(230, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1373 "Zend/zend_language_scanner.l"
		{
	return T_MOD_EQUAL;
}
#line 3510 "Zend/zend_language_scanner.c"
yy231:
		YYDEBUG(231, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy228;
yy232:
		YYDEBUG(232, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy231;
		goto yy228;
yy233:
		YYDEBUG(233, *YYCURSOR);
		yyaccept = 3;
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		YYDEBUG(234, *YYCURSOR);
		if (yych <= 'D') {
			if (yych <= '/') goto yy189;
			if (yych <= '9') goto yy233;
			goto yy189;
		} else {
			if (yych <= 'E') goto yy192;
			if (yych == 'e') goto yy192;
			goto yy189;
		}
yy235:
		YYDEBUG(235, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(236, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1369 "Zend/zend_language_scanner.l"
		{
	return T_CONCAT_EQUAL;
}
#line 3545 "Zend/zend_language_scanner.c"
yy237:
		YYDEBUG(237, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '*') goto yy242;
yy238:
		YYDEBUG(238, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1915 "Zend/zend_language_scanner.l"
		{
	int doc_com;

	if (yyleng > 2) {
		doc_com = 1;
		RESET_DOC_COMMENT();
	} else {
		doc_com = 0;
	}

	while (YYCURSOR < YYLIMIT) {
		if (*YYCURSOR++ == '*' && *YYCURSOR == '/') {
			break;
		}
	}

	if (YYCURSOR < YYLIMIT) {
		YYCURSOR++;
	} else {
		zend_error(E_COMPILE_WARNING, "Unterminated comment starting line %d", CG(zend_lineno));
	}

	yyleng = YYCURSOR - SCNG(yy_text);
	HANDLE_NEWLINES(yytext, yyleng);

	if (doc_com) {
		CG(doc_comment) = estrndup(yytext, yyleng);
		CG(doc_comment_len) = yyleng;
		return T_DOC_COMMENT;
	}

	return T_COMMENT;
}
#line 3588 "Zend/zend_language_scanner.c"
yy239:
		YYDEBUG(239, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy176;
yy240:
		YYDEBUG(240, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(241, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1365 "Zend/zend_language_scanner.l"
		{
	return T_DIV_EQUAL;
}
#line 3602 "Zend/zend_language_scanner.c"
yy242:
		YYDEBUG(242, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 64) {
			goto yy243;
		}
		goto yy193;
yy243:
		YYDEBUG(243, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(244, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy243;
		}
		goto yy238;
yy245:
		YYDEBUG(245, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(246, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1361 "Zend/zend_language_scanner.l"
		{
	return T_MUL_EQUAL;
}
#line 3629 "Zend/zend_language_scanner.c"
yy247:
		YYDEBUG(247, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) == '=') goto yy251;
		YYDEBUG(248, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1421 "Zend/zend_language_scanner.l"
		{
	return T_SR;
}
#line 3640 "Zend/zend_language_scanner.c"
yy249:
		YYDEBUG(249, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(250, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1349 "Zend/zend_language_scanner.l"
		{
	return T_IS_GREATER_OR_EQUAL;
}
#line 3650 "Zend/zend_language_scanner.c"
yy251:
		YYDEBUG(251, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(252, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1381 "Zend/zend_language_scanner.l"
		{
	return T_SR_EQUAL;
}
#line 3660 "Zend/zend_language_scanner.c"
yy253:
		YYDEBUG(253, *YYCURSOR);
		yyaccept = 5;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= ';') goto yy254;
		if (yych <= '<') goto yy269;
		if (yych <= '=') goto yy267;
yy254:
		YYDEBUG(254, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1417 "Zend/zend_language_scanner.l"
		{
	return T_SL;
}
#line 3675 "Zend/zend_language_scanner.c"
yy255:
		YYDEBUG(255, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy260;
		if (yych == 's') goto yy260;
		goto yy193;
yy256:
		YYDEBUG(256, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(257, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1345 "Zend/zend_language_scanner.l"
		{
	return T_IS_SMALLER_OR_EQUAL;
}
#line 3691 "Zend/zend_language_scanner.c"
yy258:
		YYDEBUG(258, *YYCURSOR);
		++YYCURSOR;
yy259:
		YYDEBUG(259, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1341 "Zend/zend_language_scanner.l"
		{
	return T_IS_NOT_EQUAL;
}
#line 3702 "Zend/zend_language_scanner.c"
yy260:
		YYDEBUG(260, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy261;
		if (yych != 'c') goto yy193;
yy261:
		YYDEBUG(261, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy262;
		if (yych != 'r') goto yy193;
yy262:
		YYDEBUG(262, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy263;
		if (yych != 'i') goto yy193;
yy263:
		YYDEBUG(263, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'P') goto yy264;
		if (yych != 'p') goto yy193;
yy264:
		YYDEBUG(264, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy265;
		if (yych != 't') goto yy193;
yy265:
		YYDEBUG(265, *YYCURSOR);
		++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		YYDEBUG(266, *YYCURSOR);
		if (yych <= '\r') {
			if (yych <= 0x08) goto yy193;
			if (yych <= '\n') goto yy265;
			if (yych <= '\f') goto yy193;
			goto yy265;
		} else {
			if (yych <= ' ') {
				if (yych <= 0x1F) goto yy193;
				goto yy265;
			} else {
				if (yych == '>') goto yy205;
				goto yy193;
			}
		}
yy267:
		YYDEBUG(267, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(268, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1377 "Zend/zend_language_scanner.l"
		{
	return T_SL_EQUAL;
}
#line 3757 "Zend/zend_language_scanner.c"
yy269:
		YYDEBUG(269, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		YYDEBUG(270, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy269;
		}
		if (yych <= 'Z') {
			if (yych <= '&') {
				if (yych == '"') goto yy274;
				goto yy193;
			} else {
				if (yych <= '\'') goto yy273;
				if (yych <= '@') goto yy193;
			}
		} else {
			if (yych <= '`') {
				if (yych != '_') goto yy193;
			} else {
				if (yych <= 'z') goto yy271;
				if (yych <= '~') goto yy193;
			}
		}
yy271:
		YYDEBUG(271, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		YYDEBUG(272, *YYCURSOR);
		if (yych <= '@') {
			if (yych <= '\f') {
				if (yych == '\n') goto yy278;
				goto yy193;
			} else {
				if (yych <= '\r') goto yy280;
				if (yych <= '/') goto yy193;
				if (yych <= '9') goto yy271;
				goto yy193;
			}
		} else {
			if (yych <= '_') {
				if (yych <= 'Z') goto yy271;
				if (yych <= '^') goto yy193;
				goto yy271;
			} else {
				if (yych <= '`') goto yy193;
				if (yych <= 'z') goto yy271;
				if (yych <= '~') goto yy193;
				goto yy271;
			}
		}
yy273:
		YYDEBUG(273, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\'') goto yy193;
		if (yych <= '/') goto yy282;
		if (yych <= '9') goto yy193;
		goto yy282;
yy274:
		YYDEBUG(274, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '"') goto yy193;
		if (yych <= '/') goto yy276;
		if (yych <= '9') goto yy193;
		goto yy276;
yy275:
		YYDEBUG(275, *YYCURSOR);
		++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
yy276:
		YYDEBUG(276, *YYCURSOR);
		if (yych <= 'Z') {
			if (yych <= '/') {
				if (yych != '"') goto yy193;
			} else {
				if (yych <= '9') goto yy275;
				if (yych <= '@') goto yy193;
				goto yy275;
			}
		} else {
			if (yych <= '`') {
				if (yych == '_') goto yy275;
				goto yy193;
			} else {
				if (yych <= 'z') goto yy275;
				if (yych <= '~') goto yy193;
				goto yy275;
			}
		}
yy277:
		YYDEBUG(277, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy278;
		if (yych == '\r') goto yy280;
		goto yy193;
yy278:
		YYDEBUG(278, *YYCURSOR);
		++YYCURSOR;
yy279:
		YYDEBUG(279, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 2083 "Zend/zend_language_scanner.l"
		{
	char *s;
	int bprefix = (yytext[0] != '<') ? 1 : 0;

	/* save old heredoc label */
	Z_STRVAL_P(zendlval) = CG(heredoc);
	Z_STRLEN_P(zendlval) = CG(heredoc_len);

	CG(zend_lineno)++;
	CG(heredoc_len) = yyleng-bprefix-3-1-(yytext[yyleng-2]=='\r'?1:0);
	s = yytext+bprefix+3;
	while ((*s == ' ') || (*s == '\t')) {
		s++;
		CG(heredoc_len)--;
	}

	if (*s == '\'') {
		s++;
		CG(heredoc_len) -= 2;

		BEGIN(ST_NOWDOC);
	} else {
		if (*s == '"') {
			s++;
			CG(heredoc_len) -= 2;
		}

		BEGIN(ST_HEREDOC);
	}

	CG(heredoc) = estrndup(s, CG(heredoc_len));

	/* Check for ending label on the next line */
	if (CG(heredoc_len) < YYLIMIT - YYCURSOR && !memcmp(YYCURSOR, s, CG(heredoc_len))) {
		YYCTYPE *end = YYCURSOR + CG(heredoc_len);

		if (*end == ';') {
			end++;
		}

		if (*end == '\n' || *end == '\r') {
			BEGIN(ST_END_HEREDOC);
		}
	}

	return T_START_HEREDOC;
}
#line 3910 "Zend/zend_language_scanner.c"
yy280:
		YYDEBUG(280, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy278;
		goto yy279;
yy281:
		YYDEBUG(281, *YYCURSOR);
		++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
yy282:
		YYDEBUG(282, *YYCURSOR);
		if (yych <= 'Z') {
			if (yych <= '/') {
				if (yych == '\'') goto yy277;
				goto yy193;
			} else {
				if (yych <= '9') goto yy281;
				if (yych <= '@') goto yy193;
				goto yy281;
			}
		} else {
			if (yych <= '`') {
				if (yych == '_') goto yy281;
				goto yy193;
			} else {
				if (yych <= 'z') goto yy281;
				if (yych <= '~') goto yy193;
				goto yy281;
			}
		}
yy283:
		YYDEBUG(283, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '=') goto yy259;
		YYDEBUG(284, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(285, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1333 "Zend/zend_language_scanner.l"
		{
	return T_IS_NOT_IDENTICAL;
}
#line 3954 "Zend/zend_language_scanner.c"
yy286:
		YYDEBUG(286, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(287, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1353 "Zend/zend_language_scanner.l"
		{
	return T_PLUS_EQUAL;
}
#line 3964 "Zend/zend_language_scanner.c"
yy288:
		YYDEBUG(288, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(289, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1321 "Zend/zend_language_scanner.l"
		{
	return T_INC;
}
#line 3974 "Zend/zend_language_scanner.c"
yy290:
		YYDEBUG(290, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy291;
		if (yych != 's') goto yy186;
yy291:
		YYDEBUG(291, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy292;
		if (yych != 't') goto yy186;
yy292:
		YYDEBUG(292, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy185;
		}
		YYDEBUG(293, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1309 "Zend/zend_language_scanner.l"
		{
	return T_LIST;
}
#line 3997 "Zend/zend_language_scanner.c"
yy294:
		YYDEBUG(294, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) == '=') goto yy298;
		YYDEBUG(295, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1337 "Zend/zend_language_scanner.l"
		{
	return T_IS_EQUAL;
}
#line 4008 "Zend/zend_language_scanner.c"
yy296:
		YYDEBUG(296, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(297, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1305 "Zend/zend_language_scanner.l"
		{
	return T_DOUBLE_ARROW;
}
#line 4018 "Zend/zend_language_scanner.c"
yy298:
		YYDEBUG(298, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(299, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1329 "Zend/zend_language_scanner.l"
		{
	return T_IS_IDENTICAL;
}
#line 4028 "Zend/zend_language_scanner.c"
yy300:
		YYDEBUG(300, *YYCURSOR);
		yych = *++YYCURSOR;
		YYDEBUG(-1, yych);
		switch (yych) {
		case 'C':
		case 'c':	goto yy302;
		case 'D':
		case 'd':	goto yy307;
		case 'F':
		case 'f':	goto yy304;
		case 'H':
		case 'h':	goto yy301;
		case 'L':
		case 'l':	goto yy306;
		case 'M':
		case 'm':	goto yy305;
		case 'N':
		case 'n':	goto yy308;
		case 'T':
		case 't':	goto yy303;
		default:	goto yy186;
		}
yy301:
		YYDEBUG(301, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy369;
		if (yych == 'a') goto yy369;
		goto yy186;
yy302:
		YYDEBUG(302, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy362;
		if (yych == 'l') goto yy362;
		goto yy186;
yy303:
		YYDEBUG(303, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy355;
		if (yych == 'r') goto yy355;
		goto yy186;
yy304:
		YYDEBUG(304, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'U') {
			if (yych == 'I') goto yy339;
			if (yych <= 'T') goto yy186;
			goto yy340;
		} else {
			if (yych <= 'i') {
				if (yych <= 'h') goto yy186;
				goto yy339;
			} else {
				if (yych == 'u') goto yy340;
				goto yy186;
			}
		}
yy305:
		YYDEBUG(305, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy331;
		if (yych == 'e') goto yy331;
		goto yy186;
yy306:
		YYDEBUG(306, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy325;
		if (yych == 'i') goto yy325;
		goto yy186;
yy307:
		YYDEBUG(307, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy320;
		if (yych == 'i') goto yy320;
		goto yy186;
yy308:
		YYDEBUG(308, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy309;
		if (yych != 'a') goto yy186;
yy309:
		YYDEBUG(309, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'M') goto yy310;
		if (yych != 'm') goto yy186;
yy310:
		YYDEBUG(310, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy311;
		if (yych != 'e') goto yy186;
yy311:
		YYDEBUG(311, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy312;
		if (yych != 's') goto yy186;
yy312:
		YYDEBUG(312, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'P') goto yy313;
		if (yych != 'p') goto yy186;
yy313:
		YYDEBUG(313, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy314;
		if (yych != 'a') goto yy186;
yy314:
		YYDEBUG(314, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy315;
		if (yych != 'c') goto yy186;
yy315:
		YYDEBUG(315, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy316;
		if (yych != 'e') goto yy186;
yy316:
		YYDEBUG(316, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy186;
		YYDEBUG(317, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy186;
		YYDEBUG(318, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy185;
		}
		YYDEBUG(319, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1684 "Zend/zend_language_scanner.l"
		{
	if (CG(current_namespace)) {
		*zendlval = *CG(current_namespace);
		zval_copy_ctor(zendlval);
	} else {
		ZVAL_EMPTY_STRING(zendlval);
	}
	return T_NS_C;
}
#line 4168 "Zend/zend_language_scanner.c"
yy320:
		YYDEBUG(320, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy321;
		if (yych != 'r') goto yy186;
yy321:
		YYDEBUG(321, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy186;
		YYDEBUG(322, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy186;
		YYDEBUG(323, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy185;
		}
		YYDEBUG(324, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1657 "Zend/zend_language_scanner.l"
		{
	char *filename = zend_get_compiled_filename(TSRMLS_C);
	const size_t filename_len = strlen(filename);
	char *dirname;

	if (!filename) {
		filename = "";
	}

	dirname = estrndup(filename, filename_len);
	zend_dirname(dirname, filename_len);

	if (strcmp(dirname, ".") == 0) {
		dirname = erealloc(dirname, MAXPATHLEN);
#if HAVE_GETCWD
		VCWD_GETCWD(dirname, MAXPATHLEN);
#elif HAVE_GETWD
		VCWD_GETWD(dirname);
#endif
	}

	zendlval->value.str.len = strlen(dirname);
	zendlval->value.str.val = dirname;
	zendlval->type = IS_STRING;
	return T_DIR;
}
#line 4215 "Zend/zend_language_scanner.c"
yy325:
		YYDEBUG(325, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy326;
		if (yych != 'n') goto yy186;
yy326:
		YYDEBUG(326, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy327;
		if (yych != 'e') goto yy186;
yy327:
		YYDEBUG(327, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy186;
		YYDEBUG(328, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy186;
		YYDEBUG(329, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy185;
		}
		YYDEBUG(330, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1639 "Zend/zend_language_scanner.l"
		{
	zendlval->value.lval = CG(zend_lineno);
	zendlval->type = IS_LONG;
	return T_LINE;
}
#line 4246 "Zend/zend_language_scanner.c"
yy331:
		YYDEBUG(331, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy332;
		if (yych != 't') goto yy186;
yy332:
		YYDEBUG(332, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy333;
		if (yych != 'h') goto yy186;
yy333:
		YYDEBUG(333, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy334;
		if (yych != 'o') goto yy186;
yy334:
		YYDEBUG(334, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy335;
		if (yych != 'd') goto yy186;
yy335:
		YYDEBUG(335, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy186;
		YYDEBUG(336, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy186;
		YYDEBUG(337, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy185;
		}
		YYDEBUG(338, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1618 "Zend/zend_language_scanner.l"
		{
	const char *class_name = CG(active_class_entry) ? CG(active_class_entry)->name : NULL;
	const char *func_name = CG(active_op_array)? CG(active_op_array)->function_name : NULL;
	size_t len = 0;

	if (class_name) {
		len += strlen(class_name) + 2;
	}
	if (func_name) {
		len += strlen(func_name);
	}

	zendlval->value.str.len = zend_spprintf(&zendlval->value.str.val, 0, "%s%s%s",
		class_name ? class_name : "",
		class_name && func_name ? "::" : "",
		func_name ? func_name : ""
		);
	zendlval->type = IS_STRING;
	return T_METHOD_C;
}
#line 4302 "Zend/zend_language_scanner.c"
yy339:
		YYDEBUG(339, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy350;
		if (yych == 'l') goto yy350;
		goto yy186;
yy340:
		YYDEBUG(340, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy341;
		if (yych != 'n') goto yy186;
yy341:
		YYDEBUG(341, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy342;
		if (yych != 'c') goto yy186;
yy342:
		YYDEBUG(342, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy343;
		if (yych != 't') goto yy186;
yy343:
		YYDEBUG(343, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy344;
		if (yych != 'i') goto yy186;
yy344:
		YYDEBUG(344, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy345;
		if (yych != 'o') goto yy186;
yy345:
		YYDEBUG(345, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy346;
		if (yych != 'n') goto yy186;
yy346:
		YYDEBUG(346, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy186;
		YYDEBUG(347, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy186;
		YYDEBUG(348, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy185;
		}
		YYDEBUG(349, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1602 "Zend/zend_language_scanner.l"
		{
	const char *func_name = NULL;

	if (CG(active_op_array)) {
		func_name = CG(active_op_array)->function_name;
	}

	if (!func_name) {
		func_name = "";
	}
	zendlval->value.str.len = strlen(func_name);
	zendlval->value.str.val = estrndup(func_name, zendlval->value.str.len);
	zendlval->type = IS_STRING;
	return T_FUNC_C;
}
#line 4369 "Zend/zend_language_scanner.c"
yy350:
		YYDEBUG(350, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy351;
		if (yych != 'e') goto yy186;
yy351:
		YYDEBUG(351, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy186;
		YYDEBUG(352, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy186;
		YYDEBUG(353, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy185;
		}
		YYDEBUG(354, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1645 "Zend/zend_language_scanner.l"
		{
	char *filename = zend_get_compiled_filename(TSRMLS_C);

	if (!filename) {
		filename = "";
	}
	zendlval->value.str.len = strlen(filename);
	zendlval->value.str.val = estrndup(filename, zendlval->value.str.len);
	zendlval->type = IS_STRING;
	return T_FILE;
}
#line 4401 "Zend/zend_language_scanner.c"
yy355:
		YYDEBUG(355, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy356;
		if (yych != 'a') goto yy186;
yy356:
		YYDEBUG(356, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy357;
		if (yych != 'i') goto yy186;
yy357:
		YYDEBUG(357, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy358;
		if (yych != 't') goto yy186;
yy358:
		YYDEBUG(358, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy186;
		YYDEBUG(359, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy186;
		YYDEBUG(360, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy185;
		}
		YYDEBUG(361, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1582 "Zend/zend_language_scanner.l"
		{
	const char *trait_name = NULL;
	
	if (CG(active_class_entry)
		&& (ZEND_ACC_TRAIT == 
			(CG(active_class_entry)->ce_flags & ZEND_ACC_TRAIT))) {
		trait_name = CG(active_class_entry)->name;
	}
	
	if (!trait_name) {
		trait_name = "";
	}
	
	zendlval->value.str.len = strlen(trait_name);
	zendlval->value.str.val = estrndup(trait_name, zendlval->value.str.len);
	zendlval->type = IS_STRING;
	
	return T_TRAIT_C;
}
#line 4451 "Zend/zend_language_scanner.c"
yy362:
		YYDEBUG(362, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy363;
		if (yych != 'a') goto yy186;
yy363:
		YYDEBUG(363, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy364;
		if (yych != 's') goto yy186;
yy364:
		YYDEBUG(364, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy365;
		if (yych != 's') goto yy186;
yy365:
		YYDEBUG(365, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy186;
		YYDEBUG(366, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy186;
		YYDEBUG(367, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy185;
		}
		YYDEBUG(368, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1555 "Zend/zend_language_scanner.l"
		{
	const char *class_name = NULL;
	
	if (CG(active_class_entry)
		&& (ZEND_ACC_TRAIT ==
			(CG(active_class_entry)->ce_flags & ZEND_ACC_TRAIT))) {
		// This is a hack, we abuse IS_NULL to indicate an invalid value
		// if __CLASS__ is encountered in a trait, however, we also not that we
		// should fix it up when we copy the method into an actual class
		zendlval->value.lval = ZEND_ACC_TRAIT;
		zendlval->type = IS_NULL;
	} else {
		if (CG(active_class_entry)) {
			class_name = CG(active_class_entry)->name;
		}
		
		if (!class_name) {
			class_name = "";
		}
		
		zendlval->value.str.len = strlen(class_name);
		zendlval->value.str.val = estrndup(class_name, zendlval->value.str.len);
		zendlval->type = IS_STRING;
	}
	return T_CLASS_C;
}
#line 4508 "Zend/zend_language_scanner.c"
yy369:
		YYDEBUG(369, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy370;
		if (yych != 'l') goto yy186;
yy370:
		YYDEBUG(370, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy371;
		if (yych != 't') goto yy186;
yy371:
		YYDEBUG(371, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy186;
		YYDEBUG(372, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy373;
		if (yych != 'c') goto yy186;
yy373:
		YYDEBUG(373, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy374;
		if (yych != 'o') goto yy186;
yy374:
		YYDEBUG(374, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'M') goto yy375;
		if (yych != 'm') goto yy186;
yy375:
		YYDEBUG(375, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'P') goto yy376;
		if (yych != 'p') goto yy186;
yy376:
		YYDEBUG(376, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy377;
		if (yych != 'i') goto yy186;
yy377:
		YYDEBUG(377, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy378;
		if (yych != 'l') goto yy186;
yy378:
		YYDEBUG(378, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy379;
		if (yych != 'e') goto yy186;
yy379:
		YYDEBUG(379, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy380;
		if (yych != 'r') goto yy186;
yy380:
		YYDEBUG(380, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy185;
		}
		YYDEBUG(381, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1273 "Zend/zend_language_scanner.l"
		{
	return T_HALT_COMPILER;
}
#line 4574 "Zend/zend_language_scanner.c"
yy382:
		YYDEBUG(382, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy386;
		if (yych == 's') goto yy386;
		goto yy186;
yy383:
		YYDEBUG(383, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy384;
		if (yych != 'e') goto yy186;
yy384:
		YYDEBUG(384, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy185;
		}
		YYDEBUG(385, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1253 "Zend/zend_language_scanner.l"
		{
	return T_USE;
}
#line 4598 "Zend/zend_language_scanner.c"
yy386:
		YYDEBUG(386, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy387;
		if (yych != 'e') goto yy186;
yy387:
		YYDEBUG(387, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy388;
		if (yych != 't') goto yy186;
yy388:
		YYDEBUG(388, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy185;
		}
		YYDEBUG(389, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1301 "Zend/zend_language_scanner.l"
		{
	return T_UNSET;
}
#line 4621 "Zend/zend_language_scanner.c"
yy390:
		YYDEBUG(390, *YYCURSOR);
		++YYCURSOR;
		YYFILL(7);
		yych = *YYCURSOR;
yy391:
		YYDEBUG(391, *YYCURSOR);
		if (yych <= 'S') {
			if (yych <= 'D') {
				if (yych <= ' ') {
					if (yych == '\t') goto yy390;
					if (yych <= 0x1F) goto yy193;
					goto yy390;
				} else {
					if (yych <= 'A') {
						if (yych <= '@') goto yy193;
						goto yy395;
					} else {
						if (yych <= 'B') goto yy393;
						if (yych <= 'C') goto yy193;
						goto yy398;
					}
				}
			} else {
				if (yych <= 'I') {
					if (yych == 'F') goto yy399;
					if (yych <= 'H') goto yy193;
					goto yy400;
				} else {
					if (yych <= 'O') {
						if (yych <= 'N') goto yy193;
						goto yy394;
					} else {
						if (yych <= 'Q') goto yy193;
						if (yych <= 'R') goto yy397;
						goto yy396;
					}
				}
			}
		} else {
			if (yych <= 'f') {
				if (yych <= 'a') {
					if (yych == 'U') goto yy392;
					if (yych <= '`') goto yy193;
					goto yy395;
				} else {
					if (yych <= 'c') {
						if (yych <= 'b') goto yy393;
						goto yy193;
					} else {
						if (yych <= 'd') goto yy398;
						if (yych <= 'e') goto yy193;
						goto yy399;
					}
				}
			} else {
				if (yych <= 'q') {
					if (yych <= 'i') {
						if (yych <= 'h') goto yy193;
						goto yy400;
					} else {
						if (yych == 'o') goto yy394;
						goto yy193;
					}
				} else {
					if (yych <= 's') {
						if (yych <= 'r') goto yy397;
						goto yy396;
					} else {
						if (yych != 'u') goto yy193;
					}
				}
			}
		}
yy392:
		YYDEBUG(392, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy459;
		if (yych == 'n') goto yy459;
		goto yy193;
yy393:
		YYDEBUG(393, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'O') {
			if (yych == 'I') goto yy446;
			if (yych <= 'N') goto yy193;
			goto yy447;
		} else {
			if (yych <= 'i') {
				if (yych <= 'h') goto yy193;
				goto yy446;
			} else {
				if (yych == 'o') goto yy447;
				goto yy193;
			}
		}
yy394:
		YYDEBUG(394, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'B') goto yy438;
		if (yych == 'b') goto yy438;
		goto yy193;
yy395:
		YYDEBUG(395, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy431;
		if (yych == 'r') goto yy431;
		goto yy193;
yy396:
		YYDEBUG(396, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy423;
		if (yych == 't') goto yy423;
		goto yy193;
yy397:
		YYDEBUG(397, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy421;
		if (yych == 'e') goto yy421;
		goto yy193;
yy398:
		YYDEBUG(398, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy417;
		if (yych == 'o') goto yy417;
		goto yy193;
yy399:
		YYDEBUG(399, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy410;
		if (yych == 'l') goto yy410;
		goto yy193;
yy400:
		YYDEBUG(400, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy401;
		if (yych != 'n') goto yy193;
yy401:
		YYDEBUG(401, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy402;
		if (yych != 't') goto yy193;
yy402:
		YYDEBUG(402, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy403;
		if (yych != 'e') goto yy405;
yy403:
		YYDEBUG(403, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'G') goto yy408;
		if (yych == 'g') goto yy408;
		goto yy193;
yy404:
		YYDEBUG(404, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy405:
		YYDEBUG(405, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy404;
			goto yy193;
		} else {
			if (yych <= ' ') goto yy404;
			if (yych != ')') goto yy193;
		}
		YYDEBUG(406, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(407, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1201 "Zend/zend_language_scanner.l"
		{
	return T_INT_CAST;
}
#line 4797 "Zend/zend_language_scanner.c"
yy408:
		YYDEBUG(408, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy409;
		if (yych != 'e') goto yy193;
yy409:
		YYDEBUG(409, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy404;
		if (yych == 'r') goto yy404;
		goto yy193;
yy410:
		YYDEBUG(410, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy411;
		if (yych != 'o') goto yy193;
yy411:
		YYDEBUG(411, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy412;
		if (yych != 'a') goto yy193;
yy412:
		YYDEBUG(412, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy413;
		if (yych != 't') goto yy193;
yy413:
		YYDEBUG(413, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(414, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy413;
			goto yy193;
		} else {
			if (yych <= ' ') goto yy413;
			if (yych != ')') goto yy193;
		}
		YYDEBUG(415, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(416, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1205 "Zend/zend_language_scanner.l"
		{
	return T_DOUBLE_CAST;
}
#line 4845 "Zend/zend_language_scanner.c"
yy417:
		YYDEBUG(417, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'U') goto yy418;
		if (yych != 'u') goto yy193;
yy418:
		YYDEBUG(418, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'B') goto yy419;
		if (yych != 'b') goto yy193;
yy419:
		YYDEBUG(419, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy420;
		if (yych != 'l') goto yy193;
yy420:
		YYDEBUG(420, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy413;
		if (yych == 'e') goto yy413;
		goto yy193;
yy421:
		YYDEBUG(421, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy422;
		if (yych != 'a') goto yy193;
yy422:
		YYDEBUG(422, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy413;
		if (yych == 'l') goto yy413;
		goto yy193;
yy423:
		YYDEBUG(423, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy424;
		if (yych != 'r') goto yy193;
yy424:
		YYDEBUG(424, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy425;
		if (yych != 'i') goto yy193;
yy425:
		YYDEBUG(425, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy426;
		if (yych != 'n') goto yy193;
yy426:
		YYDEBUG(426, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'G') goto yy427;
		if (yych != 'g') goto yy193;
yy427:
		YYDEBUG(427, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(428, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy427;
			goto yy193;
		} else {
			if (yych <= ' ') goto yy427;
			if (yych != ')') goto yy193;
		}
		YYDEBUG(429, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(430, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1209 "Zend/zend_language_scanner.l"
		{
	return T_STRING_CAST;
}
#line 4919 "Zend/zend_language_scanner.c"
yy431:
		YYDEBUG(431, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy432;
		if (yych != 'r') goto yy193;
yy432:
		YYDEBUG(432, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy433;
		if (yych != 'a') goto yy193;
yy433:
		YYDEBUG(433, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'Y') goto yy434;
		if (yych != 'y') goto yy193;
yy434:
		YYDEBUG(434, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(435, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy434;
			goto yy193;
		} else {
			if (yych <= ' ') goto yy434;
			if (yych != ')') goto yy193;
		}
		YYDEBUG(436, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(437, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1213 "Zend/zend_language_scanner.l"
		{
	return T_ARRAY_CAST;
}
#line 4956 "Zend/zend_language_scanner.c"
yy438:
		YYDEBUG(438, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'J') goto yy439;
		if (yych != 'j') goto yy193;
yy439:
		YYDEBUG(439, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy440;
		if (yych != 'e') goto yy193;
yy440:
		YYDEBUG(440, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy441;
		if (yych != 'c') goto yy193;
yy441:
		YYDEBUG(441, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy442;
		if (yych != 't') goto yy193;
yy442:
		YYDEBUG(442, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(443, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy442;
			goto yy193;
		} else {
			if (yych <= ' ') goto yy442;
			if (yych != ')') goto yy193;
		}
		YYDEBUG(444, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(445, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1217 "Zend/zend_language_scanner.l"
		{
	return T_OBJECT_CAST;
}
#line 4998 "Zend/zend_language_scanner.c"
yy446:
		YYDEBUG(446, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy456;
		if (yych == 'n') goto yy456;
		goto yy193;
yy447:
		YYDEBUG(447, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy448;
		if (yych != 'o') goto yy193;
yy448:
		YYDEBUG(448, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy449;
		if (yych != 'l') goto yy193;
yy449:
		YYDEBUG(449, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy454;
		if (yych == 'e') goto yy454;
		goto yy451;
yy450:
		YYDEBUG(450, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy451:
		YYDEBUG(451, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy450;
			goto yy193;
		} else {
			if (yych <= ' ') goto yy450;
			if (yych != ')') goto yy193;
		}
		YYDEBUG(452, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(453, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1221 "Zend/zend_language_scanner.l"
		{
	return T_BOOL_CAST;
}
#line 5043 "Zend/zend_language_scanner.c"
yy454:
		YYDEBUG(454, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy455;
		if (yych != 'a') goto yy193;
yy455:
		YYDEBUG(455, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy450;
		if (yych == 'n') goto yy450;
		goto yy193;
yy456:
		YYDEBUG(456, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy457;
		if (yych != 'a') goto yy193;
yy457:
		YYDEBUG(457, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy458;
		if (yych != 'r') goto yy193;
yy458:
		YYDEBUG(458, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'Y') goto yy427;
		if (yych == 'y') goto yy427;
		goto yy193;
yy459:
		YYDEBUG(459, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy460;
		if (yych != 's') goto yy193;
yy460:
		YYDEBUG(460, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy461;
		if (yych != 'e') goto yy193;
yy461:
		YYDEBUG(461, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy462;
		if (yych != 't') goto yy193;
yy462:
		YYDEBUG(462, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(463, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy462;
			goto yy193;
		} else {
			if (yych <= ' ') goto yy462;
			if (yych != ')') goto yy193;
		}
		YYDEBUG(464, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(465, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1225 "Zend/zend_language_scanner.l"
		{
	return T_UNSET_CAST;
}
#line 5107 "Zend/zend_language_scanner.c"
yy466:
		YYDEBUG(466, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy467;
		if (yych != 'r') goto yy186;
yy467:
		YYDEBUG(467, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy185;
		}
		YYDEBUG(468, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1197 "Zend/zend_language_scanner.l"
		{
	return T_VAR;
}
#line 5125 "Zend/zend_language_scanner.c"
yy469:
		YYDEBUG(469, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'M') goto yy473;
		if (yych == 'm') goto yy473;
		goto yy186;
yy470:
		YYDEBUG(470, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'W') goto yy471;
		if (yych != 'w') goto yy186;
yy471:
		YYDEBUG(471, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy185;
		}
		YYDEBUG(472, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1189 "Zend/zend_language_scanner.l"
		{
	return T_NEW;
}
#line 5149 "Zend/zend_language_scanner.c"
yy473:
		YYDEBUG(473, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy474;
		if (yych != 'e') goto yy186;
yy474:
		YYDEBUG(474, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy475;
		if (yych != 's') goto yy186;
yy475:
		YYDEBUG(475, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'P') goto yy476;
		if (yych != 'p') goto yy186;
yy476:
		YYDEBUG(476, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy477;
		if (yych != 'a') goto yy186;
yy477:
		YYDEBUG(477, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy478;
		if (yych != 'c') goto yy186;
yy478:
		YYDEBUG(478, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy479;
		if (yych != 'e') goto yy186;
yy479:
		YYDEBUG(479, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy185;
		}
		YYDEBUG(480, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1249 "Zend/zend_language_scanner.l"
		{
	return T_NAMESPACE;
}
#line 5192 "Zend/zend_language_scanner.c"
yy481:
		YYDEBUG(481, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(482, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1181 "Zend/zend_language_scanner.l"
		{
	return T_PAAMAYIM_NEKUDOTAYIM;
}
#line 5202 "Zend/zend_language_scanner.c"
yy483:
		YYDEBUG(483, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy484:
		YYDEBUG(484, *YYCURSOR);
		if (yych <= '\f') {
			if (yych <= 0x08) goto yy140;
			if (yych <= '\n') goto yy483;
			goto yy140;
		} else {
			if (yych <= '\r') goto yy483;
			if (yych == ' ') goto yy483;
			goto yy140;
		}
yy485:
		YYDEBUG(485, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(486, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1357 "Zend/zend_language_scanner.l"
		{
	return T_MINUS_EQUAL;
}
#line 5228 "Zend/zend_language_scanner.c"
yy487:
		YYDEBUG(487, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(488, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1325 "Zend/zend_language_scanner.l"
		{
	return T_DEC;
}
#line 5238 "Zend/zend_language_scanner.c"
yy489:
		YYDEBUG(489, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(490, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1151 "Zend/zend_language_scanner.l"
		{
	yy_push_state(ST_LOOKING_FOR_PROPERTY TSRMLS_CC);
	return T_OBJECT_OPERATOR;
}
#line 5249 "Zend/zend_language_scanner.c"
yy491:
		YYDEBUG(491, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'O') {
			if (yych == 'I') goto yy498;
			if (yych <= 'N') goto yy186;
			goto yy499;
		} else {
			if (yych <= 'i') {
				if (yych <= 'h') goto yy186;
				goto yy498;
			} else {
				if (yych == 'o') goto yy499;
				goto yy186;
			}
		}
yy492:
		YYDEBUG(492, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'B') goto yy493;
		if (yych != 'b') goto yy186;
yy493:
		YYDEBUG(493, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy494;
		if (yych != 'l') goto yy186;
yy494:
		YYDEBUG(494, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy495;
		if (yych != 'i') goto yy186;
yy495:
		YYDEBUG(495, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy496;
		if (yych != 'c') goto yy186;
yy496:
		YYDEBUG(496, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy185;
		}
		YYDEBUG(497, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1297 "Zend/zend_language_scanner.l"
		{
	return T_PUBLIC;
}
#line 5298 "Zend/zend_language_scanner.c"
yy498:
		YYDEBUG(498, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'V') {
			if (yych == 'N') goto yy507;
			if (yych <= 'U') goto yy186;
			goto yy508;
		} else {
			if (yych <= 'n') {
				if (yych <= 'm') goto yy186;
				goto yy507;
			} else {
				if (yych == 'v') goto yy508;
				goto yy186;
			}
		}
yy499:
		YYDEBUG(499, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy500;
		if (yych != 't') goto yy186;
yy500:
		YYDEBUG(500, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy501;
		if (yych != 'e') goto yy186;
yy501:
		YYDEBUG(501, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy502;
		if (yych != 'c') goto yy186;
yy502:
		YYDEBUG(502, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy503;
		if (yych != 't') goto yy186;
yy503:
		YYDEBUG(503, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy504;
		if (yych != 'e') goto yy186;
yy504:
		YYDEBUG(504, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy505;
		if (yych != 'd') goto yy186;
yy505:
		YYDEBUG(505, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy185;
		}
		YYDEBUG(506, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1293 "Zend/zend_language_scanner.l"
		{
	return T_PROTECTED;
}
#line 5357 "Zend/zend_language_scanner.c"
yy507:
		YYDEBUG(507, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy513;
		if (yych == 't') goto yy513;
		goto yy186;
yy508:
		YYDEBUG(508, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy509;
		if (yych != 'a') goto yy186;
yy509:
		YYDEBUG(509, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy510;
		if (yych != 't') goto yy186;
yy510:
		YYDEBUG(510, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy511;
		if (yych != 'e') goto yy186;
yy511:
		YYDEBUG(511, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy185;
		}
		YYDEBUG(512, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1289 "Zend/zend_language_scanner.l"
		{
	return T_PRIVATE;
}
#line 5391 "Zend/zend_language_scanner.c"
yy513:
		YYDEBUG(513, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy185;
		}
		YYDEBUG(514, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1127 "Zend/zend_language_scanner.l"
		{
	return T_PRINT;
}
#line 5404 "Zend/zend_language_scanner.c"
yy515:
		YYDEBUG(515, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy520;
		if (yych == 'o') goto yy520;
		goto yy186;
yy516:
		YYDEBUG(516, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy517;
		if (yych != 't') goto yy186;
yy517:
		YYDEBUG(517, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy518;
		if (yych != 'o') goto yy186;
yy518:
		YYDEBUG(518, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy185;
		}
		YYDEBUG(519, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1119 "Zend/zend_language_scanner.l"
		{
	return T_GOTO;
}
#line 5433 "Zend/zend_language_scanner.c"
yy520:
		YYDEBUG(520, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'B') goto yy521;
		if (yych != 'b') goto yy186;
yy521:
		YYDEBUG(521, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy522;
		if (yych != 'a') goto yy186;
yy522:
		YYDEBUG(522, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy523;
		if (yych != 'l') goto yy186;
yy523:
		YYDEBUG(523, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy185;
		}
		YYDEBUG(524, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1261 "Zend/zend_language_scanner.l"
		{
	return T_GLOBAL;
}
#line 5461 "Zend/zend_language_scanner.c"
yy525:
		YYDEBUG(525, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '<') goto yy533;
		goto yy193;
yy526:
		YYDEBUG(526, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy180;
yy527:
		YYDEBUG(527, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy178;
yy528:
		YYDEBUG(528, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy529;
		if (yych != 'e') goto yy186;
yy529:
		YYDEBUG(529, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy530;
		if (yych != 'a') goto yy186;
yy530:
		YYDEBUG(530, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'K') goto yy531;
		if (yych != 'k') goto yy186;
yy531:
		YYDEBUG(531, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy185;
		}
		YYDEBUG(532, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1111 "Zend/zend_language_scanner.l"
		{
	return T_BREAK;
}
#line 5502 "Zend/zend_language_scanner.c"
yy533:
		YYDEBUG(533, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '<') goto yy269;
		goto yy193;
yy534:
		YYDEBUG(534, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy541;
		if (yych == 'a') goto yy541;
		goto yy186;
yy535:
		YYDEBUG(535, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy536;
		if (yych != 'i') goto yy186;
yy536:
		YYDEBUG(536, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy537;
		if (yych != 't') goto yy186;
yy537:
		YYDEBUG(537, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy538;
		if (yych != 'c') goto yy186;
yy538:
		YYDEBUG(538, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy539;
		if (yych != 'h') goto yy186;
yy539:
		YYDEBUG(539, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy185;
		}
		YYDEBUG(540, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1095 "Zend/zend_language_scanner.l"
		{
	return T_SWITCH;
}
#line 5546 "Zend/zend_language_scanner.c"
yy541:
		YYDEBUG(541, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy542;
		if (yych != 't') goto yy186;
yy542:
		YYDEBUG(542, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy543;
		if (yych != 'i') goto yy186;
yy543:
		YYDEBUG(543, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy544;
		if (yych != 'c') goto yy186;
yy544:
		YYDEBUG(544, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy185;
		}
		YYDEBUG(545, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1277 "Zend/zend_language_scanner.l"
		{
	return T_STATIC;
}
#line 5574 "Zend/zend_language_scanner.c"
yy546:
		YYDEBUG(546, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy557;
		if (yych == 's') goto yy557;
		goto yy186;
yy547:
		YYDEBUG(547, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy555;
		if (yych == 'd') goto yy555;
		goto yy186;
yy548:
		YYDEBUG(548, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy551;
		if (yych == 'r') goto yy551;
		goto yy186;
yy549:
		YYDEBUG(549, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy185;
		}
		YYDEBUG(550, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1091 "Zend/zend_language_scanner.l"
		{
	return T_AS;
}
#line 5605 "Zend/zend_language_scanner.c"
yy551:
		YYDEBUG(551, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy552;
		if (yych != 'a') goto yy186;
yy552:
		YYDEBUG(552, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'Y') goto yy553;
		if (yych != 'y') goto yy186;
yy553:
		YYDEBUG(553, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy185;
		}
		YYDEBUG(554, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1313 "Zend/zend_language_scanner.l"
		{
	return T_ARRAY;
}
#line 5628 "Zend/zend_language_scanner.c"
yy555:
		YYDEBUG(555, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy185;
		}
		YYDEBUG(556, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1409 "Zend/zend_language_scanner.l"
		{
	return T_LOGICAL_AND;
}
#line 5641 "Zend/zend_language_scanner.c"
yy557:
		YYDEBUG(557, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy558;
		if (yych != 't') goto yy186;
yy558:
		YYDEBUG(558, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy559;
		if (yych != 'r') goto yy186;
yy559:
		YYDEBUG(559, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy560;
		if (yych != 'a') goto yy186;
yy560:
		YYDEBUG(560, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy561;
		if (yych != 'c') goto yy186;
yy561:
		YYDEBUG(561, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy562;
		if (yych != 't') goto yy186;
yy562:
		YYDEBUG(562, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy185;
		}
		YYDEBUG(563, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1281 "Zend/zend_language_scanner.l"
		{
	return T_ABSTRACT;
}
#line 5679 "Zend/zend_language_scanner.c"
yy564:
		YYDEBUG(564, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy565;
		if (yych != 'i') goto yy186;
yy565:
		YYDEBUG(565, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy566;
		if (yych != 'l') goto yy186;
yy566:
		YYDEBUG(566, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy567;
		if (yych != 'e') goto yy186;
yy567:
		YYDEBUG(567, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy185;
		}
		YYDEBUG(568, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1051 "Zend/zend_language_scanner.l"
		{
	return T_WHILE;
}
#line 5707 "Zend/zend_language_scanner.c"
yy569:
		YYDEBUG(569, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy185;
		}
		YYDEBUG(570, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1035 "Zend/zend_language_scanner.l"
		{
	return T_IF;
}
#line 5720 "Zend/zend_language_scanner.c"
yy571:
		YYDEBUG(571, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'P') goto yy613;
		if (yych == 'p') goto yy613;
		goto yy186;
yy572:
		YYDEBUG(572, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'T') {
			if (yych <= 'C') {
				if (yych <= 'B') goto yy186;
				goto yy580;
			} else {
				if (yych <= 'R') goto yy186;
				if (yych <= 'S') goto yy578;
				goto yy579;
			}
		} else {
			if (yych <= 'r') {
				if (yych == 'c') goto yy580;
				goto yy186;
			} else {
				if (yych <= 's') goto yy578;
				if (yych <= 't') goto yy579;
				goto yy186;
			}
		}
yy573:
		YYDEBUG(573, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy574;
		if (yych != 's') goto yy186;
yy574:
		YYDEBUG(574, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy575;
		if (yych != 'e') goto yy186;
yy575:
		YYDEBUG(575, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy576;
		if (yych != 't') goto yy186;
yy576:
		YYDEBUG(576, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy185;
		}
		YYDEBUG(577, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1265 "Zend/zend_language_scanner.l"
		{
	return T_ISSET;
}
#line 5776 "Zend/zend_language_scanner.c"
yy578:
		YYDEBUG(578, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy599;
		if (yych == 't') goto yy599;
		goto yy186;
yy579:
		YYDEBUG(579, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy592;
		if (yych == 'e') goto yy592;
		goto yy186;
yy580:
		YYDEBUG(580, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy581;
		if (yych != 'l') goto yy186;
yy581:
		YYDEBUG(581, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'U') goto yy582;
		if (yych != 'u') goto yy186;
yy582:
		YYDEBUG(582, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy583;
		if (yych != 'd') goto yy186;
yy583:
		YYDEBUG(583, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy584;
		if (yych != 'e') goto yy186;
yy584:
		YYDEBUG(584, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) <= '^') {
			if (yych <= '9') {
				if (yych >= '0') goto yy185;
			} else {
				if (yych <= '@') goto yy585;
				if (yych <= 'Z') goto yy185;
			}
		} else {
			if (yych <= '`') {
				if (yych <= '_') goto yy586;
			} else {
				if (yych <= 'z') goto yy185;
				if (yych >= 0x7F) goto yy185;
			}
		}
yy585:
		YYDEBUG(585, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1233 "Zend/zend_language_scanner.l"
		{
	return T_INCLUDE;
}
#line 5834 "Zend/zend_language_scanner.c"
yy586:
		YYDEBUG(586, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy587;
		if (yych != 'o') goto yy186;
yy587:
		YYDEBUG(587, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy588;
		if (yych != 'n') goto yy186;
yy588:
		YYDEBUG(588, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy589;
		if (yych != 'c') goto yy186;
yy589:
		YYDEBUG(589, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy590;
		if (yych != 'e') goto yy186;
yy590:
		YYDEBUG(590, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy185;
		}
		YYDEBUG(591, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1237 "Zend/zend_language_scanner.l"
		{
	return T_INCLUDE_ONCE;
}
#line 5867 "Zend/zend_language_scanner.c"
yy592:
		YYDEBUG(592, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy593;
		if (yych != 'r') goto yy186;
yy593:
		YYDEBUG(593, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'F') goto yy594;
		if (yych != 'f') goto yy186;
yy594:
		YYDEBUG(594, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy595;
		if (yych != 'a') goto yy186;
yy595:
		YYDEBUG(595, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy596;
		if (yych != 'c') goto yy186;
yy596:
		YYDEBUG(596, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy597;
		if (yych != 'e') goto yy186;
yy597:
		YYDEBUG(597, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy185;
		}
		YYDEBUG(598, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1135 "Zend/zend_language_scanner.l"
		{
	return T_INTERFACE;
}
#line 5905 "Zend/zend_language_scanner.c"
yy599:
		YYDEBUG(599, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'E') {
			if (yych == 'A') goto yy600;
			if (yych <= 'D') goto yy186;
			goto yy601;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy186;
			} else {
				if (yych == 'e') goto yy601;
				goto yy186;
			}
		}
yy600:
		YYDEBUG(600, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy607;
		if (yych == 'n') goto yy607;
		goto yy186;
yy601:
		YYDEBUG(601, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy602;
		if (yych != 'a') goto yy186;
yy602:
		YYDEBUG(602, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy603;
		if (yych != 'd') goto yy186;
yy603:
		YYDEBUG(603, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy604;
		if (yych != 'o') goto yy186;
yy604:
		YYDEBUG(604, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'F') goto yy605;
		if (yych != 'f') goto yy186;
yy605:
		YYDEBUG(605, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy185;
		}
		YYDEBUG(606, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1257 "Zend/zend_language_scanner.l"
		{
        return T_INSTEADOF;
}
#line 5959 "Zend/zend_language_scanner.c"
yy607:
		YYDEBUG(607, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy608;
		if (yych != 'c') goto yy186;
yy608:
		YYDEBUG(608, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy609;
		if (yych != 'e') goto yy186;
yy609:
		YYDEBUG(609, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy610;
		if (yych != 'o') goto yy186;
yy610:
		YYDEBUG(610, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'F') goto yy611;
		if (yych != 'f') goto yy186;
yy611:
		YYDEBUG(611, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy185;
		}
		YYDEBUG(612, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1087 "Zend/zend_language_scanner.l"
		{
	return T_INSTANCEOF;
}
#line 5992 "Zend/zend_language_scanner.c"
yy613:
		YYDEBUG(613, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy614;
		if (yych != 'l') goto yy186;
yy614:
		YYDEBUG(614, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy615;
		if (yych != 'e') goto yy186;
yy615:
		YYDEBUG(615, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'M') goto yy616;
		if (yych != 'm') goto yy186;
yy616:
		YYDEBUG(616, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy617;
		if (yych != 'e') goto yy186;
yy617:
		YYDEBUG(617, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy618;
		if (yych != 'n') goto yy186;
yy618:
		YYDEBUG(618, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy619;
		if (yych != 't') goto yy186;
yy619:
		YYDEBUG(619, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy620;
		if (yych != 's') goto yy186;
yy620:
		YYDEBUG(620, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy185;
		}
		YYDEBUG(621, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1147 "Zend/zend_language_scanner.l"
		{
	return T_IMPLEMENTS;
}
#line 6040 "Zend/zend_language_scanner.c"
yy622:
		YYDEBUG(622, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy630;
		if (yych == 'r') goto yy630;
		goto yy186;
yy623:
		YYDEBUG(623, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'Y') {
			if (yych == 'A') goto yy626;
			if (yych <= 'X') goto yy186;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy186;
				goto yy626;
			} else {
				if (yych != 'y') goto yy186;
			}
		}
		YYDEBUG(624, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy185;
		}
		YYDEBUG(625, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1023 "Zend/zend_language_scanner.l"
		{
	return T_TRY;
}
#line 6072 "Zend/zend_language_scanner.c"
yy626:
		YYDEBUG(626, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy627;
		if (yych != 'i') goto yy186;
yy627:
		YYDEBUG(627, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy628;
		if (yych != 't') goto yy186;
yy628:
		YYDEBUG(628, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy185;
		}
		YYDEBUG(629, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1139 "Zend/zend_language_scanner.l"
		{
	return T_TRAIT;
}
#line 6095 "Zend/zend_language_scanner.c"
yy630:
		YYDEBUG(630, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy631;
		if (yych != 'o') goto yy186;
yy631:
		YYDEBUG(631, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'W') goto yy632;
		if (yych != 'w') goto yy186;
yy632:
		YYDEBUG(632, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy185;
		}
		YYDEBUG(633, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1031 "Zend/zend_language_scanner.l"
		{
	return T_THROW;
}
#line 6118 "Zend/zend_language_scanner.c"
yy634:
		YYDEBUG(634, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'T') {
			if (yych == 'Q') goto yy636;
			if (yych <= 'S') goto yy186;
		} else {
			if (yych <= 'q') {
				if (yych <= 'p') goto yy186;
				goto yy636;
			} else {
				if (yych != 't') goto yy186;
			}
		}
		YYDEBUG(635, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'U') goto yy648;
		if (yych == 'u') goto yy648;
		goto yy186;
yy636:
		YYDEBUG(636, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'U') goto yy637;
		if (yych != 'u') goto yy186;
yy637:
		YYDEBUG(637, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy638;
		if (yych != 'i') goto yy186;
yy638:
		YYDEBUG(638, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy639;
		if (yych != 'r') goto yy186;
yy639:
		YYDEBUG(639, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy640;
		if (yych != 'e') goto yy186;
yy640:
		YYDEBUG(640, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) <= '^') {
			if (yych <= '9') {
				if (yych >= '0') goto yy185;
			} else {
				if (yych <= '@') goto yy641;
				if (yych <= 'Z') goto yy185;
			}
		} else {
			if (yych <= '`') {
				if (yych <= '_') goto yy642;
			} else {
				if (yych <= 'z') goto yy185;
				if (yych >= 0x7F) goto yy185;
			}
		}
yy641:
		YYDEBUG(641, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1241 "Zend/zend_language_scanner.l"
		{
	return T_REQUIRE;
}
#line 6183 "Zend/zend_language_scanner.c"
yy642:
		YYDEBUG(642, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy643;
		if (yych != 'o') goto yy186;
yy643:
		YYDEBUG(643, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy644;
		if (yych != 'n') goto yy186;
yy644:
		YYDEBUG(644, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy645;
		if (yych != 'c') goto yy186;
yy645:
		YYDEBUG(645, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy646;
		if (yych != 'e') goto yy186;
yy646:
		YYDEBUG(646, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy185;
		}
		YYDEBUG(647, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1245 "Zend/zend_language_scanner.l"
		{
	return T_REQUIRE_ONCE;
}
#line 6216 "Zend/zend_language_scanner.c"
yy648:
		YYDEBUG(648, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy649;
		if (yych != 'r') goto yy186;
yy649:
		YYDEBUG(649, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy650;
		if (yych != 'n') goto yy186;
yy650:
		YYDEBUG(650, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy185;
		}
		YYDEBUG(651, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1019 "Zend/zend_language_scanner.l"
		{
	return T_RETURN;
}
#line 6239 "Zend/zend_language_scanner.c"
yy652:
		YYDEBUG(652, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'T') {
			if (yych <= 'L') {
				if (yych <= 'K') goto yy186;
				goto yy675;
			} else {
				if (yych <= 'R') goto yy186;
				if (yych <= 'S') goto yy674;
				goto yy673;
			}
		} else {
			if (yych <= 'r') {
				if (yych == 'l') goto yy675;
				goto yy186;
			} else {
				if (yych <= 's') goto yy674;
				if (yych <= 't') goto yy673;
				goto yy186;
			}
		}
yy653:
		YYDEBUG(653, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'O') {
			if (yych == 'A') goto yy665;
			if (yych <= 'N') goto yy186;
			goto yy666;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy186;
				goto yy665;
			} else {
				if (yych == 'o') goto yy666;
				goto yy186;
			}
		}
yy654:
		YYDEBUG(654, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy655;
		if (yych != 'n') goto yy186;
yy655:
		YYDEBUG(655, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'T') {
			if (yych <= 'R') goto yy186;
			if (yych >= 'T') goto yy657;
		} else {
			if (yych <= 'r') goto yy186;
			if (yych <= 's') goto yy656;
			if (yych <= 't') goto yy657;
			goto yy186;
		}
yy656:
		YYDEBUG(656, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy663;
		if (yych == 't') goto yy663;
		goto yy186;
yy657:
		YYDEBUG(657, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy658;
		if (yych != 'i') goto yy186;
yy658:
		YYDEBUG(658, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy659;
		if (yych != 'n') goto yy186;
yy659:
		YYDEBUG(659, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'U') goto yy660;
		if (yych != 'u') goto yy186;
yy660:
		YYDEBUG(660, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy661;
		if (yych != 'e') goto yy186;
yy661:
		YYDEBUG(661, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy185;
		}
		YYDEBUG(662, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1115 "Zend/zend_language_scanner.l"
		{
	return T_CONTINUE;
}
#line 6333 "Zend/zend_language_scanner.c"
yy663:
		YYDEBUG(663, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy185;
		}
		YYDEBUG(664, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1015 "Zend/zend_language_scanner.l"
		{
	return T_CONST;
}
#line 6346 "Zend/zend_language_scanner.c"
yy665:
		YYDEBUG(665, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy670;
		if (yych == 's') goto yy670;
		goto yy186;
yy666:
		YYDEBUG(666, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy667;
		if (yych != 'n') goto yy186;
yy667:
		YYDEBUG(667, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy668;
		if (yych != 'e') goto yy186;
yy668:
		YYDEBUG(668, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy185;
		}
		YYDEBUG(669, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1193 "Zend/zend_language_scanner.l"
		{
	return T_CLONE;
}
#line 6375 "Zend/zend_language_scanner.c"
yy670:
		YYDEBUG(670, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy671;
		if (yych != 's') goto yy186;
yy671:
		YYDEBUG(671, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy185;
		}
		YYDEBUG(672, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1131 "Zend/zend_language_scanner.l"
		{
	return T_CLASS;
}
#line 6393 "Zend/zend_language_scanner.c"
yy673:
		YYDEBUG(673, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy684;
		if (yych == 'c') goto yy684;
		goto yy186;
yy674:
		YYDEBUG(674, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy682;
		if (yych == 'e') goto yy682;
		goto yy186;
yy675:
		YYDEBUG(675, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy676;
		if (yych != 'l') goto yy186;
yy676:
		YYDEBUG(676, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy677;
		if (yych != 'a') goto yy186;
yy677:
		YYDEBUG(677, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'B') goto yy678;
		if (yych != 'b') goto yy186;
yy678:
		YYDEBUG(678, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy679;
		if (yych != 'l') goto yy186;
yy679:
		YYDEBUG(679, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy680;
		if (yych != 'e') goto yy186;
yy680:
		YYDEBUG(680, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy185;
		}
		YYDEBUG(681, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1317 "Zend/zend_language_scanner.l"
		{
 return T_CALLABLE;
}
#line 6443 "Zend/zend_language_scanner.c"
yy682:
		YYDEBUG(682, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy185;
		}
		YYDEBUG(683, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1103 "Zend/zend_language_scanner.l"
		{
	return T_CASE;
}
#line 6456 "Zend/zend_language_scanner.c"
yy684:
		YYDEBUG(684, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy685;
		if (yych != 'h') goto yy186;
yy685:
		YYDEBUG(685, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy185;
		}
		YYDEBUG(686, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1027 "Zend/zend_language_scanner.l"
		{
	return T_CATCH;
}
#line 6474 "Zend/zend_language_scanner.c"
yy687:
		YYDEBUG(687, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy704;
		if (yych == 'n') goto yy704;
		goto yy186;
yy688:
		YYDEBUG(688, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy697;
		if (yych == 'r') goto yy697;
		goto yy186;
yy689:
		YYDEBUG(689, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy690;
		if (yych != 'n') goto yy186;
yy690:
		YYDEBUG(690, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy691;
		if (yych != 'c') goto yy186;
yy691:
		YYDEBUG(691, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy692;
		if (yych != 't') goto yy186;
yy692:
		YYDEBUG(692, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy693;
		if (yych != 'i') goto yy186;
yy693:
		YYDEBUG(693, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy694;
		if (yych != 'o') goto yy186;
yy694:
		YYDEBUG(694, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy695;
		if (yych != 'n') goto yy186;
yy695:
		YYDEBUG(695, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy185;
		}
		YYDEBUG(696, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1011 "Zend/zend_language_scanner.l"
		{
	return T_FUNCTION;
}
#line 6529 "Zend/zend_language_scanner.c"
yy697:
		YYDEBUG(697, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) <= '^') {
			if (yych <= '@') {
				if (yych <= '/') goto yy698;
				if (yych <= '9') goto yy185;
			} else {
				if (yych == 'E') goto yy699;
				if (yych <= 'Z') goto yy185;
			}
		} else {
			if (yych <= 'd') {
				if (yych != '`') goto yy185;
			} else {
				if (yych <= 'e') goto yy699;
				if (yych <= 'z') goto yy185;
				if (yych >= 0x7F) goto yy185;
			}
		}
yy698:
		YYDEBUG(698, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1063 "Zend/zend_language_scanner.l"
		{
	return T_FOR;
}
#line 6557 "Zend/zend_language_scanner.c"
yy699:
		YYDEBUG(699, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy700;
		if (yych != 'a') goto yy186;
yy700:
		YYDEBUG(700, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy701;
		if (yych != 'c') goto yy186;
yy701:
		YYDEBUG(701, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy702;
		if (yych != 'h') goto yy186;
yy702:
		YYDEBUG(702, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy185;
		}
		YYDEBUG(703, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1071 "Zend/zend_language_scanner.l"
		{
	return T_FOREACH;
}
#line 6585 "Zend/zend_language_scanner.c"
yy704:
		YYDEBUG(704, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy705;
		if (yych != 'a') goto yy186;
yy705:
		YYDEBUG(705, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy706;
		if (yych != 'l') goto yy186;
yy706:
		YYDEBUG(706, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy185;
		}
		YYDEBUG(707, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1285 "Zend/zend_language_scanner.l"
		{
	return T_FINAL;
}
#line 6608 "Zend/zend_language_scanner.c"
yy708:
		YYDEBUG(708, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'F') {
			if (yych == 'C') goto yy714;
			if (yych <= 'E') goto yy186;
			goto yy715;
		} else {
			if (yych <= 'c') {
				if (yych <= 'b') goto yy186;
				goto yy714;
			} else {
				if (yych == 'f') goto yy715;
				goto yy186;
			}
		}
yy709:
		YYDEBUG(709, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy712;
		if (yych == 'e') goto yy712;
		goto yy186;
yy710:
		YYDEBUG(710, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy185;
		}
		YYDEBUG(711, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1059 "Zend/zend_language_scanner.l"
		{
	return T_DO;
}
#line 6643 "Zend/zend_language_scanner.c"
yy712:
		YYDEBUG(712, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy185;
		}
		YYDEBUG(713, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1007 "Zend/zend_language_scanner.l"
		{
	return T_EXIT;
}
#line 6656 "Zend/zend_language_scanner.c"
yy714:
		YYDEBUG(714, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy721;
		if (yych == 'l') goto yy721;
		goto yy186;
yy715:
		YYDEBUG(715, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy716;
		if (yych != 'a') goto yy186;
yy716:
		YYDEBUG(716, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'U') goto yy717;
		if (yych != 'u') goto yy186;
yy717:
		YYDEBUG(717, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy718;
		if (yych != 'l') goto yy186;
yy718:
		YYDEBUG(718, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy719;
		if (yych != 't') goto yy186;
yy719:
		YYDEBUG(719, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy185;
		}
		YYDEBUG(720, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1107 "Zend/zend_language_scanner.l"
		{
	return T_DEFAULT;
}
#line 6695 "Zend/zend_language_scanner.c"
yy721:
		YYDEBUG(721, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy722;
		if (yych != 'a') goto yy186;
yy722:
		YYDEBUG(722, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy723;
		if (yych != 'r') goto yy186;
yy723:
		YYDEBUG(723, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy724;
		if (yych != 'e') goto yy186;
yy724:
		YYDEBUG(724, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy185;
		}
		YYDEBUG(725, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1079 "Zend/zend_language_scanner.l"
		{
	return T_DECLARE;
}
#line 6723 "Zend/zend_language_scanner.c"
yy726:
		YYDEBUG(726, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy788;
		if (yych == 'h') goto yy788;
		goto yy186;
yy727:
		YYDEBUG(727, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy782;
		if (yych == 's') goto yy782;
		goto yy186;
yy728:
		YYDEBUG(728, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'P') goto yy778;
		if (yych == 'p') goto yy778;
		goto yy186;
yy729:
		YYDEBUG(729, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy744;
		if (yych == 'd') goto yy744;
		goto yy186;
yy730:
		YYDEBUG(730, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy741;
		if (yych == 'a') goto yy741;
		goto yy186;
yy731:
		YYDEBUG(731, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'T') {
			if (yych == 'I') goto yy732;
			if (yych <= 'S') goto yy186;
			goto yy733;
		} else {
			if (yych <= 'i') {
				if (yych <= 'h') goto yy186;
			} else {
				if (yych == 't') goto yy733;
				goto yy186;
			}
		}
yy732:
		YYDEBUG(732, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy739;
		if (yych == 't') goto yy739;
		goto yy186;
yy733:
		YYDEBUG(733, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy734;
		if (yych != 'e') goto yy186;
yy734:
		YYDEBUG(734, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy735;
		if (yych != 'n') goto yy186;
yy735:
		YYDEBUG(735, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy736;
		if (yych != 'd') goto yy186;
yy736:
		YYDEBUG(736, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy737;
		if (yych != 's') goto yy186;
yy737:
		YYDEBUG(737, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy185;
		}
		YYDEBUG(738, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1143 "Zend/zend_language_scanner.l"
		{
	return T_EXTENDS;
}
#line 6807 "Zend/zend_language_scanner.c"
yy739:
		YYDEBUG(739, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy185;
		}
		YYDEBUG(740, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1003 "Zend/zend_language_scanner.l"
		{
	return T_EXIT;
}
#line 6820 "Zend/zend_language_scanner.c"
yy741:
		YYDEBUG(741, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy742;
		if (yych != 'l') goto yy186;
yy742:
		YYDEBUG(742, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy185;
		}
		YYDEBUG(743, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1229 "Zend/zend_language_scanner.l"
		{
	return T_EVAL;
}
#line 6838 "Zend/zend_language_scanner.c"
yy744:
		YYDEBUG(744, *YYCURSOR);
		yych = *++YYCURSOR;
		YYDEBUG(-1, yych);
		switch (yych) {
		case 'D':
		case 'd':	goto yy745;
		case 'F':
		case 'f':	goto yy746;
		case 'I':
		case 'i':	goto yy747;
		case 'S':
		case 's':	goto yy748;
		case 'W':
		case 'w':	goto yy749;
		default:	goto yy186;
		}
yy745:
		YYDEBUG(745, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy771;
		if (yych == 'e') goto yy771;
		goto yy186;
yy746:
		YYDEBUG(746, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy763;
		if (yych == 'o') goto yy763;
		goto yy186;
yy747:
		YYDEBUG(747, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'F') goto yy761;
		if (yych == 'f') goto yy761;
		goto yy186;
yy748:
		YYDEBUG(748, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'W') goto yy755;
		if (yych == 'w') goto yy755;
		goto yy186;
yy749:
		YYDEBUG(749, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy750;
		if (yych != 'h') goto yy186;
yy750:
		YYDEBUG(750, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy751;
		if (yych != 'i') goto yy186;
yy751:
		YYDEBUG(751, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy752;
		if (yych != 'l') goto yy186;
yy752:
		YYDEBUG(752, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy753;
		if (yych != 'e') goto yy186;
yy753:
		YYDEBUG(753, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy185;
		}
		YYDEBUG(754, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1055 "Zend/zend_language_scanner.l"
		{
	return T_ENDWHILE;
}
#line 6912 "Zend/zend_language_scanner.c"
yy755:
		YYDEBUG(755, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy756;
		if (yych != 'i') goto yy186;
yy756:
		YYDEBUG(756, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy757;
		if (yych != 't') goto yy186;
yy757:
		YYDEBUG(757, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy758;
		if (yych != 'c') goto yy186;
yy758:
		YYDEBUG(758, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy759;
		if (yych != 'h') goto yy186;
yy759:
		YYDEBUG(759, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy185;
		}
		YYDEBUG(760, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1099 "Zend/zend_language_scanner.l"
		{
	return T_ENDSWITCH;
}
#line 6945 "Zend/zend_language_scanner.c"
yy761:
		YYDEBUG(761, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy185;
		}
		YYDEBUG(762, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1043 "Zend/zend_language_scanner.l"
		{
	return T_ENDIF;
}
#line 6958 "Zend/zend_language_scanner.c"
yy763:
		YYDEBUG(763, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy764;
		if (yych != 'r') goto yy186;
yy764:
		YYDEBUG(764, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) <= '^') {
			if (yych <= '@') {
				if (yych <= '/') goto yy765;
				if (yych <= '9') goto yy185;
			} else {
				if (yych == 'E') goto yy766;
				if (yych <= 'Z') goto yy185;
			}
		} else {
			if (yych <= 'd') {
				if (yych != '`') goto yy185;
			} else {
				if (yych <= 'e') goto yy766;
				if (yych <= 'z') goto yy185;
				if (yych >= 0x7F) goto yy185;
			}
		}
yy765:
		YYDEBUG(765, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1067 "Zend/zend_language_scanner.l"
		{
	return T_ENDFOR;
}
#line 6991 "Zend/zend_language_scanner.c"
yy766:
		YYDEBUG(766, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy767;
		if (yych != 'a') goto yy186;
yy767:
		YYDEBUG(767, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy768;
		if (yych != 'c') goto yy186;
yy768:
		YYDEBUG(768, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy769;
		if (yych != 'h') goto yy186;
yy769:
		YYDEBUG(769, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy185;
		}
		YYDEBUG(770, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1075 "Zend/zend_language_scanner.l"
		{
	return T_ENDFOREACH;
}
#line 7019 "Zend/zend_language_scanner.c"
yy771:
		YYDEBUG(771, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy772;
		if (yych != 'c') goto yy186;
yy772:
		YYDEBUG(772, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy773;
		if (yych != 'l') goto yy186;
yy773:
		YYDEBUG(773, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy774;
		if (yych != 'a') goto yy186;
yy774:
		YYDEBUG(774, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy775;
		if (yych != 'r') goto yy186;
yy775:
		YYDEBUG(775, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy776;
		if (yych != 'e') goto yy186;
yy776:
		YYDEBUG(776, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy185;
		}
		YYDEBUG(777, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1083 "Zend/zend_language_scanner.l"
		{
	return T_ENDDECLARE;
}
#line 7057 "Zend/zend_language_scanner.c"
yy778:
		YYDEBUG(778, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy779;
		if (yych != 't') goto yy186;
yy779:
		YYDEBUG(779, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'Y') goto yy780;
		if (yych != 'y') goto yy186;
yy780:
		YYDEBUG(780, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy185;
		}
		YYDEBUG(781, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1269 "Zend/zend_language_scanner.l"
		{
	return T_EMPTY;
}
#line 7080 "Zend/zend_language_scanner.c"
yy782:
		YYDEBUG(782, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy783;
		if (yych != 'e') goto yy186;
yy783:
		YYDEBUG(783, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) <= '^') {
			if (yych <= '@') {
				if (yych <= '/') goto yy784;
				if (yych <= '9') goto yy185;
			} else {
				if (yych == 'I') goto yy785;
				if (yych <= 'Z') goto yy185;
			}
		} else {
			if (yych <= 'h') {
				if (yych != '`') goto yy185;
			} else {
				if (yych <= 'i') goto yy785;
				if (yych <= 'z') goto yy185;
				if (yych >= 0x7F) goto yy185;
			}
		}
yy784:
		YYDEBUG(784, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1047 "Zend/zend_language_scanner.l"
		{
	return T_ELSE;
}
#line 7113 "Zend/zend_language_scanner.c"
yy785:
		YYDEBUG(785, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'F') goto yy786;
		if (yych != 'f') goto yy186;
yy786:
		YYDEBUG(786, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy185;
		}
		YYDEBUG(787, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1039 "Zend/zend_language_scanner.l"
		{
	return T_ELSEIF;
}
#line 7131 "Zend/zend_language_scanner.c"
yy788:
		YYDEBUG(788, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy789;
		if (yych != 'o') goto yy186;
yy789:
		YYDEBUG(789, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy185;
		}
		YYDEBUG(790, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1123 "Zend/zend_language_scanner.l"
		{
	return T_ECHO;
}
#line 7149 "Zend/zend_language_scanner.c"
	}
/* *********************************** */
yyc_ST_LOOKING_FOR_PROPERTY:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128,   0,   0, 128,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,   0,   0,   0,   0,   0,   0, 
			  0,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,   0,   0,   0,   0,  64, 
			  0,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,   0,   0,   0,   0,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
		};
		YYDEBUG(791, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych <= '-') {
			if (yych <= '\r') {
				if (yych <= 0x08) goto yy799;
				if (yych <= '\n') goto yy793;
				if (yych <= '\f') goto yy799;
			} else {
				if (yych == ' ') goto yy793;
				if (yych <= ',') goto yy799;
				goto yy795;
			}
		} else {
			if (yych <= '_') {
				if (yych <= '@') goto yy799;
				if (yych <= 'Z') goto yy797;
				if (yych <= '^') goto yy799;
				goto yy797;
			} else {
				if (yych <= '`') goto yy799;
				if (yych <= 'z') goto yy797;
				if (yych <= '~') goto yy799;
				goto yy797;
			}
		}
yy793:
		YYDEBUG(793, *YYCURSOR);
		++YYCURSOR;
		yych = *YYCURSOR;
		goto yy805;
yy794:
		YYDEBUG(794, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1156 "Zend/zend_language_scanner.l"
		{
	zendlval->value.str.val = yytext; /* no copying - intentional */
	zendlval->value.str.len = yyleng;
	zendlval->type = IS_STRING;
	HANDLE_NEWLINES(yytext, yyleng);
	return T_WHITESPACE;
}
#line 7230 "Zend/zend_language_scanner.c"
yy795:
		YYDEBUG(795, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) == '>') goto yy802;
yy796:
		YYDEBUG(796, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1175 "Zend/zend_language_scanner.l"
		{
	yyless(0);
	yy_pop_state(TSRMLS_C);
	goto restart;
}
#line 7244 "Zend/zend_language_scanner.c"
yy797:
		YYDEBUG(797, *YYCURSOR);
		++YYCURSOR;
		yych = *YYCURSOR;
		goto yy801;
yy798:
		YYDEBUG(798, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1168 "Zend/zend_language_scanner.l"
		{
	yy_pop_state(TSRMLS_C);
	zend_copy_value(zendlval, yytext, yyleng);
	zendlval->type = IS_STRING;
	return T_STRING;
}
#line 7260 "Zend/zend_language_scanner.c"
yy799:
		YYDEBUG(799, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy796;
yy800:
		YYDEBUG(800, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy801:
		YYDEBUG(801, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy800;
		}
		goto yy798;
yy802:
		YYDEBUG(802, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(803, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1164 "Zend/zend_language_scanner.l"
		{
	return T_OBJECT_OPERATOR;
}
#line 7285 "Zend/zend_language_scanner.c"
yy804:
		YYDEBUG(804, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy805:
		YYDEBUG(805, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy804;
		}
		goto yy794;
	}
/* *********************************** */
yyc_ST_LOOKING_FOR_VARNAME:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(806, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy810;
			if (yych <= 'Z') goto yy808;
			if (yych <= '^') goto yy810;
		} else {
			if (yych <= '`') goto yy810;
			if (yych <= 'z') goto yy808;
			if (yych <= '~') goto yy810;
		}
yy808:
		YYDEBUG(808, *YYCURSOR);
		++YYCURSOR;
		yych = *YYCURSOR;
		goto yy813;
yy809:
		YYDEBUG(809, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1451 "Zend/zend_language_scanner.l"
		{
	zend_copy_value(zendlval, yytext, yyleng);
	zendlval->type = IS_STRING;
	yy_pop_state(TSRMLS_C);
	yy_push_state(ST_IN_SCRIPTING TSRMLS_CC);
	return T_STRING_VARNAME;
}
#line 7363 "Zend/zend_language_scanner.c"
yy810:
		YYDEBUG(810, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(811, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1460 "Zend/zend_language_scanner.l"
		{
	yyless(0);
	yy_pop_state(TSRMLS_C);
	yy_push_state(ST_IN_SCRIPTING TSRMLS_CC);
	goto restart;
}
#line 7376 "Zend/zend_language_scanner.c"
yy812:
		YYDEBUG(812, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy813:
		YYDEBUG(813, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy812;
		}
		goto yy809;
	}
/* *********************************** */
yyc_ST_NOWDOC:
	YYDEBUG(814, *YYCURSOR);
	YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(816, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(817, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
#line 2334 "Zend/zend_language_scanner.l"
	{
	int newline = 0;

	if (YYCURSOR > YYLIMIT) {
		return 0;
	}

	YYCURSOR--;

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '\r':
				if (*YYCURSOR == '\n') {
					YYCURSOR++;
				}
				/* fall through */
			case '\n':
				/* Check for ending label on the next line */
				if (IS_LABEL_START(*YYCURSOR) && CG(heredoc_len) < YYLIMIT - YYCURSOR && !memcmp(YYCURSOR, CG(heredoc), CG(heredoc_len))) {
					YYCTYPE *end = YYCURSOR + CG(heredoc_len);

					if (*end == ';') {
						end++;
					}

					if (*end == '\n' || *end == '\r') {
						/* newline before label will be subtracted from returned text, but
						 * yyleng/yytext will include it, for zend_highlight/strip, tokenizer, etc. */
						if (YYCURSOR[-2] == '\r' && YYCURSOR[-1] == '\n') {
							newline = 2; /* Windows newline */
						} else {
							newline = 1;
						}

						CG(increment_lineno) = 1; /* For newline before label */
						BEGIN(ST_END_HEREDOC);

						goto nowdoc_scan_done;
					}
				}
				/* fall through */
			default:
				continue;
		}
	}

nowdoc_scan_done:
	yyleng = YYCURSOR - SCNG(yy_text);

	zend_copy_value(zendlval, yytext, yyleng - newline);
	zendlval->type = IS_STRING;
	HANDLE_NEWLINES(yytext, yyleng - newline);
	return T_ENCAPSED_AND_WHITESPACE;
}
#line 7453 "Zend/zend_language_scanner.c"
/* *********************************** */
yyc_ST_VAR_OFFSET:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			240, 240, 112, 112, 112, 112, 112, 112, 
			112, 112,   0,   0,   0,   0,   0,   0, 
			  0,  80,  80,  80,  80,  80,  80,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,   0,   0,   0,   0,  16, 
			  0,  80,  80,  80,  80,  80,  80,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,   0,   0,   0,   0,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
		};
		YYDEBUG(818, *YYCURSOR);
		YYFILL(3);
		yych = *YYCURSOR;
		if (yych <= '/') {
			if (yych <= ' ') {
				if (yych <= '\f') {
					if (yych <= 0x08) goto yy832;
					if (yych <= '\n') goto yy828;
					goto yy832;
				} else {
					if (yych <= '\r') goto yy828;
					if (yych <= 0x1F) goto yy832;
					goto yy828;
				}
			} else {
				if (yych <= '$') {
					if (yych <= '"') goto yy827;
					if (yych <= '#') goto yy828;
					goto yy823;
				} else {
					if (yych == '\'') goto yy828;
					goto yy827;
				}
			}
		} else {
			if (yych <= '\\') {
				if (yych <= '@') {
					if (yych <= '0') goto yy820;
					if (yych <= '9') goto yy822;
					goto yy827;
				} else {
					if (yych <= 'Z') goto yy830;
					if (yych <= '[') goto yy827;
					goto yy828;
				}
			} else {
				if (yych <= '_') {
					if (yych <= ']') goto yy825;
					if (yych <= '^') goto yy827;
					goto yy830;
				} else {
					if (yych <= '`') goto yy827;
					if (yych <= 'z') goto yy830;
					if (yych <= '~') goto yy827;
					goto yy830;
				}
			}
		}
yy820:
		YYDEBUG(820, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'W') {
			if (yych <= '9') {
				if (yych >= '0') goto yy844;
			} else {
				if (yych == 'B') goto yy841;
			}
		} else {
			if (yych <= 'b') {
				if (yych <= 'X') goto yy843;
				if (yych >= 'b') goto yy841;
			} else {
				if (yych == 'x') goto yy843;
			}
		}
yy821:
		YYDEBUG(821, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1530 "Zend/zend_language_scanner.l"
		{ /* Offset could be treated as a long */
	if (yyleng < MAX_LENGTH_OF_LONG - 1 || (yyleng == MAX_LENGTH_OF_LONG - 1 && strcmp(yytext, long_min_digits) < 0)) {
		zendlval->value.lval = strtol(yytext, NULL, 10);
		zendlval->type = IS_LONG;
	} else {
		zendlval->value.str.val = (char *)estrndup(yytext, yyleng);
		zendlval->value.str.len = yyleng;
		zendlval->type = IS_STRING;
	}
	return T_NUM_STRING;
}
#line 7572 "Zend/zend_language_scanner.c"
yy822:
		YYDEBUG(822, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy840;
yy823:
		YYDEBUG(823, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) <= '_') {
			if (yych <= '@') goto yy824;
			if (yych <= 'Z') goto yy836;
			if (yych >= '_') goto yy836;
		} else {
			if (yych <= '`') goto yy824;
			if (yych <= 'z') goto yy836;
			if (yych >= 0x7F) goto yy836;
		}
yy824:
		YYDEBUG(824, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1862 "Zend/zend_language_scanner.l"
		{
	/* Only '[' can be valid, but returning other tokens will allow a more explicit parse error */
	return yytext[0];
}
#line 7597 "Zend/zend_language_scanner.c"
yy825:
		YYDEBUG(825, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(826, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1857 "Zend/zend_language_scanner.l"
		{
	yy_pop_state(TSRMLS_C);
	return ']';
}
#line 7608 "Zend/zend_language_scanner.c"
yy827:
		YYDEBUG(827, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy824;
yy828:
		YYDEBUG(828, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(829, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1867 "Zend/zend_language_scanner.l"
		{
	/* Invalid rule to return a more explicit parse error with proper line number */
	yyless(0);
	yy_pop_state(TSRMLS_C);
	return T_ENCAPSED_AND_WHITESPACE;
}
#line 7625 "Zend/zend_language_scanner.c"
yy830:
		YYDEBUG(830, *YYCURSOR);
		++YYCURSOR;
		yych = *YYCURSOR;
		goto yy835;
yy831:
		YYDEBUG(831, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1874 "Zend/zend_language_scanner.l"
		{
	zend_copy_value(zendlval, yytext, yyleng);
	zendlval->type = IS_STRING;
	return T_STRING;
}
#line 7640 "Zend/zend_language_scanner.c"
yy832:
		YYDEBUG(832, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(833, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 2390 "Zend/zend_language_scanner.l"
		{
	if (YYCURSOR > YYLIMIT) {
		return 0;
	}

	zend_error(E_COMPILE_WARNING,"Unexpected character in input:  '%c' (ASCII=%d) state=%d", yytext[0], yytext[0], YYSTATE);
	goto restart;
}
#line 7655 "Zend/zend_language_scanner.c"
yy834:
		YYDEBUG(834, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy835:
		YYDEBUG(835, *YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy834;
		}
		goto yy831;
yy836:
		YYDEBUG(836, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(837, *YYCURSOR);
		if (yych <= '^') {
			if (yych <= '9') {
				if (yych >= '0') goto yy836;
			} else {
				if (yych <= '@') goto yy838;
				if (yych <= 'Z') goto yy836;
			}
		} else {
			if (yych <= '`') {
				if (yych <= '_') goto yy836;
			} else {
				if (yych <= 'z') goto yy836;
				if (yych >= 0x7F) goto yy836;
			}
		}
yy838:
		YYDEBUG(838, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1851 "Zend/zend_language_scanner.l"
		{
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	zendlval->type = IS_STRING;
	return T_VARIABLE;
}
#line 7697 "Zend/zend_language_scanner.c"
yy839:
		YYDEBUG(839, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy840:
		YYDEBUG(840, *YYCURSOR);
		if (yybm[0+yych] & 32) {
			goto yy839;
		}
		goto yy821;
yy841:
		YYDEBUG(841, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 128) {
			goto yy849;
		}
yy842:
		YYDEBUG(842, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy821;
yy843:
		YYDEBUG(843, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 64) {
			goto yy847;
		}
		goto yy842;
yy844:
		YYDEBUG(844, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(845, *YYCURSOR);
		if (yych <= '/') goto yy846;
		if (yych <= '9') goto yy844;
yy846:
		YYDEBUG(846, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1542 "Zend/zend_language_scanner.l"
		{ /* Offset must be treated as a string */
	zendlval->value.str.val = (char *)estrndup(yytext, yyleng);
	zendlval->value.str.len = yyleng;
	zendlval->type = IS_STRING;
	return T_NUM_STRING;
}
#line 7744 "Zend/zend_language_scanner.c"
yy847:
		YYDEBUG(847, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(848, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy847;
		}
		goto yy846;
yy849:
		YYDEBUG(849, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(850, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy849;
		}
		goto yy846;
	}
}
#line 2399 "Zend/zend_language_scanner.l"

}
