/////////////////////////////////////////////////////////////
//                                                         //
// Copyright (c) 2007-2011 by The University of Queensland //
// Earth Systems Science Computational Centre (ESSCC)      //
// http://www.uq.edu.au/esscc                              //
//                                                         //
// Primary Business: Brisbane, Queensland, Australia       //
// Licensed under the Open Software License version 3.0    //
// http://www.opensource.org/licenses/osl-3.0.php          //
//                                                         //
/////////////////////////////////////////////////////////////

#include <boost/version.hpp>
#include "TriBoxPy.h"

using namespace boost::python;

    void exportTriBox()
    {
      // Check that Boost 1.34.0 or higher is being used.
      // If so, disable auto-generation of C++ signatures for Epydoc
      // (which stumbles over indentation in the auto-generated strings).
      #if ((BOOST_VERSION / 100000 >= 1) \
          && (BOOST_VERSION / 100 % 1000 >= 34)) \
          || (BOOST_VERSION / 100000 >= 2)
        boost::python::docstring_options no_autogen(true,false);
      #endif

      class_<TriBox, bases<AVolume3D> >(
        "TriBox",
        "A class defining a triangular prism L{AVolume3D} bounded by planes.",
        init<>()
      )
      .def(init<const TriBox &>())
      .def(
        init<Vector3,Vector3,bool>(
          ( arg("minPoint"), arg("maxPoint"), arg("inverted") ),
          "Constructs a triangular prism with the specified coordinates.\n"
          "The triangle cross-section is in the X-Y plane and may be upright or C{inverted}.\n"
          "@type minPoint: L{Vector3}\n"
          "@kwarg minPoint: Coordinate of bottom-left-front corner of the axis-aligned bounding box\n"
          "@type maxPoint: L{Vector3}\n"
          "@kwarg maxPoint: Coordinate of upper-right-back corner of the axis-aligned bounding box\n"
          "@type inverted: boolean\n"
          "@kwarg inverted: defines whether tribox is inverted (default is False)\n"
        )
      )
      .def(
        "addPlane",
        &TriBox::addPlane,
        ( arg("plane") ),
        "Adds a plane to the TriBox for fitting particles.\n"
        "@type plane: L{Plane}\n"
        "@kwarg plane: the plane to add to the TriBox\n"
        "@rtype: void"
      )
      .def(self_ns::str(self))
      ;
//      boost::python::implicitly_convertible<TriBox, AVolume2D>();
    }



