/*
    Tucnak - VHF contest log
    Copyright (C) 2002-2006  Ladislav Vaiz <ok1zia@nagano.cz>

    This program is free software; you can redistribute it and/or                                                        
    modify it under the terms of the GNU General Public License                                                          
    version 2 as published by the Free Software Foundation.

*/

#include "header.h"


struct window *cwwindow;

void draw_cwwindow(struct cwwin_data *cwwdata){
    fill_area(cwwdata->x-2, cwwdata->y-1, cwwdata->w+4, cwwdata->h+2, COL_INV); 
    draw_frame(cwwdata->x, cwwdata->y, cwwdata->w, cwwdata->h, COL_INV, 1); 
    print_text(cwwdata->x + 5, cwwdata->y, -1, VTEXT(T__CW_), COL_NORM);
    print_text(cwwdata->x + 5, cwwdata->y + cwwdata->h -1 , -1, VTEXT(T_CWW_KEYS), COL_NORM);

    print_text(cwwdata->x + 3, cwwdata->y +2 , CWW_MAXSTR>cwwdata->w-4? cwwdata->w-4:CWW_MAXSTR, cwwdata->text , COL_INV);
        
    /*dbg("draw_cwwindow: set_cursor %d %d \n", cwwdata->x +
	 * strlen(cwwdata->text), cwwdata->y+2, 0, 0);*/
    set_cursor(cwwdata->x + strlen(cwwdata->text) + 3, cwwdata->y+2, 
                     cwwdata->x + strlen(cwwdata->text) + 3 , cwwdata->y+2);
    
}

void cwwindow_func(struct window *win, struct event *ev, int fwd){
    struct terminal *term;
    struct cwwin_data *cwwdata;
    
    term = win->term;
    cwwdata = (struct cwwin_data *)win->data;
    
    dbg("cwwindow_func [%d,%d,%d,%d]\n",ev->ev,ev->x,ev->y,ev->b);

    switch (ev->ev) {
        case EV_INIT:
            win->data = cwwdata = mem_alloc(sizeof(struct cwwin_data));
            memset(win->data, 0, sizeof(struct cwwin_data));

        case EV_RESIZE:
            cwwdata->x = 10;
            cwwdata->y = (ev->y - 6) / 2;
            cwwdata->w = ev->x - 20;
            cwwdata->h = 5;
            
        case EV_REDRAW:
            draw_cwwindow(cwwdata);
            break;
        case EV_MOUSE:
            break;
        case EV_KBD:
            switch(ev->x){
                case KBD_ESC:
                case KBD_TAB:
                    /*delete_window_ev(win, (void *)win->next != &win->term->windows && 
                            win->next->handler == cwwindow_func ? ev : NULL);*/
                    delete_window_ev(win, ev);
                    break;
                case KBD_ENTER: /* delete window, CW text play on */
					ev->x=KBD_TAB;
                    delete_window_ev(win, ev);
                    break;
                case KBD_PGUP:
					cwdaemon_qrq(cwda, 2);
					redraw_later();
					break;  
                case KBD_PGDN:
					cwdaemon_qrs(cwda, 2);
					redraw_later();
                    break;  
                default:    
                    if (ev->x >= ' ' && ev->x < 256) {
						char s[2];
                        dbg("key=%c\n", ev->x);
                        if (strlen(cwwdata->text)<CWW_MAXSTR-1)
                            cwwdata->text[strlen(cwwdata->text)]=ev->x;
						s[0]=ev->x;
						s[1]='\0';
                        cwdaemon_text(cwda, s);
                        draw_cwwindow(cwwdata);
                    }
            }
            break;
        case EV_ABORT:
            /* mem_free(cwwdata);  already in terminal.c:196 (delete_window) */ 
            break;
    }
}

