/*
    Tucnak - VHF contest log
    Copyright (C) 2002-2006  Ladislav Vaiz <ok1zia@nagano.cz>

    This program is free software; you can redistribute it and/or                                                        
    modify it under the terms of the GNU General Public License                                                          
    version 2 as published by the Free Software Foundation.

*/

#include "header.h"

#ifdef HAVE_SDL

#define INFO_W 180


int olddragx, olddragy;

/* only EV_KBD */
int sw_map_kbd_func(struct subwin *sw, struct event *ev, int fw){
    int lmx,lmy;

    if (!sdl) return 0;
    /*dbg("\nsw_map_kbd_func [%d,%d,%d,%d]\n",ev->ev,ev->x,ev->y,ev->b);*/
    switch(kbd_action(KM_MAIN,ev)){
        case ACT_ESC:
            return 0;
            break;
        case ACT_LEFT:
            sw->ox+=10;
            move_map(sw, sw->screen, +10, 0);
            return 1;
        case ACT_RIGHT:
            sw->ox-=10;
            move_map(sw, sw->screen, -10, 0);
            return 1;
        case ACT_UP:
            sw->oy+=10;
            move_map(sw, sw->screen, 0, +10);
            return 1;
        case ACT_DOWN:
            sw->oy-=10;
            move_map(sw, sw->screen, 0, -10);
            return 1;
        
    }
   /* dbg("sw_map_kbd_func: %c %d\n", ev->x, ev->y);*/
    switch(ev->x){
        case '+':
        case '=':
            /*lmx = sdl->mouse_x - sw->x * FONT_W;
            lmy = sdl->mouse_y - sw->y * FONT_H;
            zoom(sw, 1.5, lmx, lmy);*/
            lmx = sw->x * FONT_W + sw->screen->w/2;
            lmy = sw->y * FONT_H + sw->screen->h/2;
            zoom(sw, 1.5, lmx, lmy);   
            break;
        case '-':
            /*lmx = sdl->mouse_x - sw->x * FONT_W;
            lmy = sdl->mouse_y - sw->y * FONT_H;
            zoom(sw, 1/1.5, lmx, lmy);          */
            lmx = sw->x * FONT_W + sw->screen->w/2;
            lmy = sw->y * FONT_H + sw->screen->h/2;
            zoom(sw, 1/1.5, lmx, lmy);
            break;
        case '1':
            sw->ox+=20;
            sw->oy+=20;
            move_map(sw, sw->screen, +20, +20);
            break;
        case 'r':
            sw->gdirty=1;
            sw_map_redraw(sw);
            break;
        
        
    }
    return 0;
}

void zoom(struct subwin *sw, double factor, int centerx, int centery){
    int oldzoom;    
    int kx, ky;
    
    px2km(sw, centerx, centery, &kx, &ky);
    
    oldzoom=sw->zoom;
    sw->zoom*=factor;
    if (sw->zoom>20000-2) sw->zoom=20000;
    if (sw->zoom<80) sw->zoom=80;
    if (sw->zoom==oldzoom) return;

    pxkm2o(sw, centerx, centery, kx, ky, &sw->ox, &sw->oy);
	sw->gdirty=1;
    redraw_later();
    dbg("zoom=%d\n", sw->zoom);
}

int sw_map_mouse_func(struct subwin *sw, struct event *ev, int fw){
    int dx,dy, lmx, lmy;
    
    if (!sdl) return 0;
    /*dbg("sw_qsos_mouse_func\n");*/
  /*  if ((ev->b & BM_ACT)!=B_DOWN) return 0; */
    if (ev->b & B_MOVE){
        plot_nearest(sw);
        plot_qrb_qth(sw, sw->screen, sdl->mouse_x, sdl->mouse_y);
        return 1;
    }
    if (ev->b & B_DRAG){
        switch (ev->b & BM_EBUTT){
            case B_LEFT:
         /*   dbg("drag %d %d\n", ev->mx, ev->my);*/
            dx=ev->mx - olddragx;
            dy=ev->my - olddragy;
            if (dx==0 && dy==0) break;
            olddragx=ev->mx;
            olddragy=ev->my;
            sw->ox+=dx;
            sw->oy+=dy;
            /*redraw_later(); */
            move_map(sw, sw->screen, dx, dy);
            return 1;
        }
        return 1;
    }
    switch (ev->b & BM_EBUTT){
        case B_LEFT:
    /*        dbg("left %d %d\n", ev->mx, ev->my);*/
            olddragx=ev->mx;
            olddragy=ev->my;
            return 1;
        case B_MIDDLE:
        /*    dbg("middle\n");*/
            break;
        case B_RIGHT:
            /*dbg("right\n");*/
            break;
        case B_WHUP:
            /*dbg("wheel up\n");*/
            lmx = ev->mx - sw->x * FONT_W;
            lmy = ev->my - sw->y * FONT_H;
            zoom(sw, 1.5, lmx, lmy);
            return 1;
        case B_WHDOWN:
            /*dbg("wheel down\n");*/
            lmx = ev->mx - sw->x * FONT_W;
            lmy = ev->my - sw->y * FONT_H;
            zoom(sw, 1/1.5, lmx, lmy);
            return 1;
    }
    return 0;
}

void move_map(struct subwin *sw, struct SDL_Surface *surface, int dx, int dy){
    SDL_Rect dst;
    
    /*dbg("move_map(%d, %d)\n", dx, dy);*/
    dst.x=dx;
    dst.y=dy;
    dst.w=sw->map.w;
    dst.h=sw->map.h;
    SDL_SetClipRect(surface, &sw->map);
    SDL_BlitSurface(surface, &sw->map, surface, &dst); 

    if (dx>0){
        dst.x=0;
        dst.w=dx;
        dst.y=0;
        dst.h=sw->map.h;
        sw_map_redraw_rect(sw, &dst);
    }
    if (dx<0){
        dst.x=sw->map.w+dx;
        dst.w=-dx;
        dst.y=0;
        dst.h=sw->map.h;
        sw_map_redraw_rect(sw, &dst);
    }
    if (dy>0){
        dst.x=0;
        dst.w=sw->map.w;
        dst.y=0;
        dst.h=dy;
        sw_map_redraw_rect(sw, &dst);
    }
    if (dy<0){
        dst.x=0;
        dst.w=sw->map.w;
        dst.y=sw->map.h+dy;
        dst.h=-dy;
        sw_map_redraw_rect(sw, &dst);
    }

    plot_nearest(sw); 
   /* SDL_UpdateRect(surface, 0,0,0,0); */
    
    /*dbg("move_map ox=%d oy=%d\n", sw->ox, sw->oy);*/
}


void sw_map_redraw_rect(struct subwin *sw, SDL_Rect *area){
 /*   static int col=0; */
/*    dbg("sw_map_redraw_rect: %dx%d%+d%+d\n", area->x, area->y, area->w, area->h);*/
    SDL_SetClipRect(sw->screen, area);
    SDL_FillRect(sw->screen, area, makecol(0, 35, 35));
   /* col%=16; */
   /* rect(sw->screen, area->x, area->y, area->x+area->w-1, area->y+area->h-1, 0x4000); */
    /*SDL_FillRect(sw->screen, &sw->map, sdl->termcol[1]);
    SDL_FillRect(sw->screen, &sw->info, sdl->termcol[2]);*/
    
    plot_cor(sw, sw->screen, area);
    if (ctest && ctest->wwlused) plot_qsos(sw, sw->screen, area);
    
}

void sw_map_redraw(struct subwin *sw){
	/*dbg("sw_map_redraw(gdirty=%d)\n", sw->gdirty); */
    if (!sdl) return;

    fill_area(sw->x, sw->y, sw->w, sw->h, 0);
	if (!sw->gdirty) return;
	sw->gdirty=0;

    /*ST_START; */

    sw_map_redraw_rect(sw, &sw->map);
    plot_info(sw, sw->screen, sw->minq);
    plot_qrb_qth(sw, sw->screen, sdl->mouse_x, sdl->mouse_y);
	/*ST_STOP; */
    
}

void sw_map_check_bounds(struct subwin *sw){

    if (!sdl) return;
    if (!aband) return;
}

void sw_map_raise(struct subwin *sw){
    sw->gdirty=1;      
}

/* km -> pixels */
void km2px(struct subwin *sw, int kx, int ky, int *px, int *py){
    *px = sw->ox + (kx * sw->zoom)/10000;    
    *py = sw->oy + (ky * sw->zoom)/10000;    
}

/* pixels -> km */
void px2km(struct subwin *sw, int px, int py, int *kx, int *ky){
    *kx = ((px - sw->ox) * 10000)/sw->zoom;
    *ky = ((py - sw->oy) * 10000)/sw->zoom;
}

void pxkm2o(struct subwin *sw, int px, int py, int kx, int ky, int *ox, int *oy){
    *ox = px - (kx * sw->zoom)/10000;    
    *oy = py - (ky * sw->zoom)/10000;    
}


void hw2km(double h1, double w1, double h2, double w2, int *kx, int *ky){
	double qrb, qtf;
    
	hw2qrbqtf(h1, w1, h2, w2, &qrb, &qtf);
/*    dbg("qrb=%f qtf=%f\n", qrb, qtf);*/
    *kx =   qrb*sin(qtf);
    *ky = - qrb*cos(qtf);
}

void km2qrbqtf(int kx, int ky, double *qrb, double *qtf){
    int dx, dy;
    
    dx=kx;
    dy=ky;
    
    *qrb=sqrt(sqr(dx)+sqr(dy));
    *qtf=atan2(dx,-dy);   
    if (*qtf<0) *qtf+=2*MY_PI;
/*    dbg("km2qrbqtf(%d, %d)=%d, %d\n",kx, ky, (int)*qrb, (int)(*qtf*180.0/MY_PI));*/
}



void plot_cor(struct subwin *sw, SDL_Surface *surface, SDL_Rect *area){
    gpointer key;
    int ikx, iky, px, py, kx, ky, oldpx=0, oldpy=0, c, color=0, i;
    struct kmarray *kma;
    struct kmpoint *kmp;
    int minkx, minky, maxkx, maxky;
    
   /* ST_START; */
    px2km(sw, area->x, area->y, &minkx, &minky);
    px2km(sw, area->x+area->w-1, area->y+area->h-1, &maxkx, &maxky);
    /*px2km(sw, 0, 0, &minkx, &minky);
    px2km(sw, sw->screen->w, sw->screen->h, &maxkx, &maxky);*/
    /*dbg("plot_cor: area=%dx%x-%d-%d kx=%d..%d ky=%d..%d  ", area->x, area->y, area->w, area->h, minkx, maxkx, minky, maxky);*/
    minkx &= COR_KM_MASK;
    minky &= COR_KM_MASK;
    maxkx &= COR_KM_MASK;
    maxky &= COR_KM_MASK;
    if (minkx<COR_KM_MIN) minkx=COR_KM_MIN;
    if (maxkx>COR_KM_MAX) maxkx=COR_KM_MAX;
    if (minky<COR_KM_MIN) minky=COR_KM_MIN;
    if (maxky>COR_KM_MAX) maxky=COR_KM_MAX;
 /*   dbg("kx=%d-%d ky=%d-%d\n", minkx, maxkx, minky, maxky);*/
    
    
    /* big wwls (JN69) */
    for (iky=minky; iky<=maxky; iky+=COR_KM_STEP)
        for (ikx=minkx; ikx<=maxkx; ikx+=COR_KM_STEP){
            km2px(sw, ikx, iky, &px, &py);
#if 0        
            int px2, py2;
            km2px(sw,ikx+COR_KM_STEP, iky+COR_KM_STEP, &px2, &py2);
            rect(surface, px, py, px2-2,py2-2 , makecol(0, 128, 0));
#endif                
            key=k2key(ikx, iky);
            if (sw->zoom<1000){ 
                kma=g_hash_table_lookup(cor->wwl2, key);
            }else{
                kma=g_hash_table_lookup(cor->wwl4, key);
            }
            if (!kma) continue;
            for (i=0,kmp=kma->data;i<kma->len;i++,kmp++){
                kx=kmp->kx;
                ky=kmp->ky;
                km2px(sw, kx, ky, &px, &py);
                
                if (kmp->c<0) {
                    oldpx = px;
                    oldpy = py;
                    switch((int)kmp->c){
                        case -128: 
                            color=makecol(184, 159, 255);
                            break;
                        case -127: 
                            color=makecol(145, 125, 122);
                            break;
                        default:
                            color=makecol(255, 159, 255);
                        /*    dbg("unknown char %d\n", (int)kmp->c);    
                            return;  */
                            break;
                            
                    }
                    continue;
                }

                c = color;
                if (overlapped_line(area, oldpx, oldpy, px, py))
                    line(sw->screen, oldpx, oldpy, px, py, c);
                        
                /*fast_putpixel(sw->screen, oldpx, oldpy, makecol(255,0,0));
                fast_putpixel(sw->screen, px, py, makecol(255,0,0));*/
                oldpx = px;
                oldpy = py;
            }
        }
    /*ST_STOP; */
    /*ST_START; */

    /* cor */
    for (iky=minky; iky<=maxky; iky+=COR_KM_STEP)
        for (ikx=minkx; ikx<=maxkx; ikx+=COR_KM_STEP){
            km2px(sw, ikx, iky, &px, &py);
                
            key=k2key(ikx, iky);
            kma=g_hash_table_lookup(cor->km, key);
            if (!kma) continue;
            for (i=0,kmp=kma->data;i<kma->len;i++,kmp++){
                kx=kmp->kx;
                ky=kmp->ky;
                km2px(sw, kx, ky, &px, &py);
                
                if (kmp->c<0) {
                    oldpx = px;
                    oldpy = py;
                    switch((int)kmp->c){
                        case -128: /* coast */
                            color=makecol(0, 255, 255);
                            break;
                        case -127: /* isle */
                            color=makecol(0, 255, 255);
                            break;
                        case -126: /* lake */
                            color=makecol(0, 95, 195);
                            break;
                        case -125: /* border */
                            color=makecol(0, 255, 255);
                            break;
                        case -100: 
                            color=makecol(255,0,0);
                            break;
                        case -101: 
                            color=makecol(0,255,0);
                            break;
                        default:
                            dbg("unknown char %d\n", (int)kmp->c);    
                            return;
                            break;
                            
                    }
                    continue;
                }

                c = color;
/*                if (abs(oldpx-px) + abs(oldpy-py) < 100)  */
                if (oldpx!=px || oldpy!=py)               
                    line(sw->screen, oldpx, oldpy, px, py, c);
               /* if (oldpx==px && oldpy==py) stejne++;
                else ruzne++;*/

                oldpx = px;
                oldpy = py;
            }
        }

  /*  dbg("stejne=%d ruzne=%d\n", stejne, ruzne);*/
    /*ST_STOP; */
}

void plot_qso(struct subwin *sw, SDL_Surface *surface, struct qso *qso){
    int kx, ky, px, py, color;
    SDL_Rect outline;

    outline.w=9;
    outline.h=9;
    kx =   qso->kx;
    ky =   qso->ky;
    km2px(sw, kx, ky, &px, &py);
    outline.x = px - 4; 
    outline.y = py - 4; 
    if (!overlapped_rect(&surface->clip_rect, &outline)) {
/*            dbg("clipped qso\n"); */
        return;
    }
/*       dbg("kreslim qso\n"); */
    color=qso==sw->minq?sdl->red:sdl->yellow;
    if (qso==&aband->tmplocqso) color=sdl->green;
    cross(surface, px, py, color, sw->zoom);
}

void map_add_qso(struct qso *qso){
    if (ctest && !ctest->wwlused) return;
    if (gses->ontop->type!=SWT_MAP) return;
    SDL_SetClipRect(gses->ontop->screen, &gses->ontop->map);
    plot_qso(gses->ontop, gses->ontop->screen, qso);
}

void plot_qsos(struct subwin *sw, SDL_Surface *surface, SDL_Rect *area){
    int i;
    struct qso *qso;
    
    if (!aband) return;
    
    for (i=0;i<aband->qsos->len;i++){
        qso=(struct qso*)g_ptr_array_index(aband->qsos, i);
        if (qso->error) continue;
        plot_qso(sw, surface, qso);
    }
    if (aband->tmplocqso.locator && *aband->tmplocqso.locator)
        plot_qso(sw, surface, &aband->tmplocqso);
}

void map_update_layout(struct subwin *sw){
/*    dbg("map_update_layout\n");*/

    sw->map.x = 0;
    sw->map.y = 0;
    sw->map.w = sw->w * FONT_W - INFO_W;
    sw->map.h = sw->h * FONT_H;

    sw->info.x = sw->w * FONT_W - INFO_W;
    sw->info.y = 0;
    sw->info.w = INFO_W;
    sw->info.h = sw->h * FONT_H;

}

int map_update_qth(struct subwin *sw){
    gchar *pwwlo;

    if (!sdl) return 0;

    
    if (ctest && ctest->pwwlo) {
        pwwlo=ctest->pwwlo;
    }else{
        pwwlo = cfg->pwwlo;
    }
    if (!pwwlo) internal("Undefined locator");
    
    if (sw->pwwlo && strcmp(sw->pwwlo, pwwlo)==0) {
        /*dbg("map_update_qth(%s (same) )\n", sw->pwwlo);*/
        return 0;
    }
    
    CONDGFREE(sw->pwwlo);
    sw->pwwlo = g_strdup(pwwlo);
    /*dbg("map_update_qth(%s)\n", sw->pwwlo);*/

    sw->ox=sw->map.w/2; 
    sw->oy=sw->map.h/2; 
	
    sw->myh = qth(sw->pwwlo, 0);
	sw->myw = qth(sw->pwwlo, 1);
    
    recalc_cor(sw, sw->pwwlo);

    return 1;
}


int maps_reload(){
    int i;
    struct subwin *sw=NULL;
    
    if (!sdl) return 0;
    /*dbg("maps_reload\n");*/
    
    for (i=0;i<gses->subwins->len;i++){
        sw=(struct subwin *)g_ptr_array_index(gses->subwins, i);
        if (sw->type!=SWT_MAP) continue;
        sw->gdirty=1;
        sw->minq=NULL;
        map_update_qth(sw);
    }
    
/*    invalidate_bkg(NULL);   in map_update_qth
    invalidate_cache(aband);
    clear_gfxstats();
    gfx->dirty=1;
    gfx->draw=1;*/
    if (sw && gses->ontop->type==SWT_MAP) sw_map_redraw(sw);
    return 0;
}

void map_clear_qso(struct qso *qso){
    int kx, ky, px, py;
    SDL_Rect outline;
    struct subwin *sw;
    
    if (!sdl) return;
    if (ctest && !ctest->wwlused) return;
    
    if (gses->ontop->type!=SWT_MAP) goto x;
    
    if (!qso->locator || !*qso->locator) goto x;
    sw = gses->ontop;
    kx =   qso->kx;
    ky =   qso->ky;
    km2px(sw, kx, ky, &px, &py);
    outline.x = px - 4; 
    outline.y = py - 4; 
    outline.w = 9;
    outline.h = 9;
    if (!overlapped_rect(&sw->map, &outline)) goto x;
    
    sw_map_redraw_rect(sw, &outline);
x:;    
    if (qso==&aband->tmplocqso) CONDGFREE(qso->locator);

}

void map_recalc_cors(){
    int i;
    struct subwin *sw;
    
    for (i=0;i<gses->subwins->len;i++){
        sw=(struct subwin *)g_ptr_array_index(gses->subwins, i);
        if (sw->type!=SWT_MAP) continue;
        recalc_cor(sw, ctest->pwwlo);
        break; /* fixme more maps with different pwwlo */
    }
} 


struct qso *find_nearest(struct band *b, int mouse_x, int mouse_y){
    int i;
    struct qso *minq, *q;
    gdouble d, min;
    int px, py, kx, ky;
    struct subwin *sw;

    if (!b) return NULL;
    sw=gses->ontop;
    if (sw->type!=SWT_MAP) return NULL;
    
    px=mouse_x-sw->x*FONT_W;
    py=mouse_y-sw->y*FONT_H;
    px2km(sw, px, py, &kx, &ky);
    

    min=G_MAXDOUBLE;
    minq=NULL;
    for (i=0; i<b->qsos->len; i++){
        q = (struct qso *)g_ptr_array_index(b->qsos, i);
        if (q->error) continue;
        
        /*compute_cache(q); */
        d = sqrt((double)(sqr(q->kx-kx)+sqr(q->ky-ky)));
/*        dbg("  %s %d %d %6.3f\n", q->callsign, q->gfx_x-mouse_x,  q->gfx_y-mouse_y, d);*/
        if (d<min){
            min=d;
            minq=q;
        }
    }
    /*if (minq) dbg("nearest: %s %s\n", minq->callsign, minq->locator);
    else dbg("nearest: NULL\n"); */
    return minq;
}

void plot_nearest(struct subwin *sw){
    struct qso *oldminq;

    oldminq=sw->minq;
    sw->minq=find_nearest(aband, sdl->mouse_x, sdl->mouse_y);
    /*dbg("sw->minq=%s  oldminq=%s\n", sw->minq->callsign, oldminq->callsign); */
    if (sw->minq==oldminq) return;
/*        dbg("minq changed %s->%s\n", oldminq->locator, sw->minq->locator); */
    SDL_SetClipRect(sw->screen, &sw->map);
/*       dbg("clip_rect %dx%d%+d%+d\n", surface->clip_rect.x, surface->clip_rect.y, surface->clip_rect.w, surface->clip_rect.h); */
    if (oldminq) plot_qso(sw, sw->screen, oldminq);
    if (sw->minq) {
        plot_qso(sw, sw->screen, sw->minq);
        plot_info(sw, sw->screen, sw->minq);
    }else{
        plot_info(sw, sw->screen, NULL);
    }
    return;
}

void plot_info(struct subwin *sw, SDL_Surface *surface, struct qso *qso){
    char s[10];
    int x,y;
    SDL_Rect rect;
 
    rect.x=sw->info.x;
    rect.y=sw->info.y;
    rect.w=sw->info.w;
    rect.h=sw->info.y+(11*FONT_H)+12;
    
    SDL_SetClipRect(surface, &rect);
    SDL_FillRect(surface, &rect, makecol(0,0,35)) ;
    if (!qso) return;

    x=sw->info.x+4;
    y=sw->info.y+4;
    fontoutf(surface, x, y, sdl->green, FONT_TRANSP, VTEXT(T_GCALL), q0(qso->callsign)); y+=FONT_H+4;
    fontoutf(surface, x, y, sdl->green, FONT_TRANSP, VTEXT(T_GWWL),  q0(qso->locator)); y+=FONT_H+4;
    fontoutf(surface, x, y, sdl->green, FONT_TRANSP, VTEXT(T_GQRB),  (int)qso->qrb); y+=FONT_H+4;   
    fontoutf(surface, x, y, sdl->green, FONT_TRANSP, VTEXT(T_GQTF),  qso->qtf); y+=FONT_H+4;
    fontoutf(surface, x, y, sdl->green, FONT_TRANSP, VTEXT(T_GSEN),  q0(qso->rsts), q0(qso->qsonrs)); y+=FONT_H+4;
    fontoutf(surface, x, y, sdl->green, FONT_TRANSP, VTEXT(T_GRCV),  q0(qso->rstr), q0(qso->qsonrr)); y+=FONT_H+4;
    strcpy(s,qso->time_str);
    s[5]=s[4];
    s[4]=s[3];
    s[3]=s[2];
    s[2]='.';
    fontoutf(surface, x, y, sdl->green, FONT_TRANSP, VTEXT(T_GTIM),  s); y+=FONT_H+4;
    fontoutf(surface, x, y, sdl->green, FONT_TRANSP, VTEXT(T_GOPE),  q0(qso->operator)); y+=FONT_H+4;
    fontoutf(surface, x, y, sdl->green, FONT_TRANSP, VTEXT(T_GREM),  q0(qso->remark)); y+=FONT_H+4;
    return;                      
}

int plot_qrb_qth(struct subwin *sw, SDL_Surface *surface, int mouse_x, int mouse_y){
    double qrb,qtf, h2, w2; 
    SDL_Rect rect;
    char buf[100];
    int x, y, kx, ky;
 
    x=sw->info.x+4;
    y=sw->info.y+(11*FONT_H)+12;
    
/*    dbg("plot_qtb_qtf\n");*/
    rect.x=sw->info.x;
    rect.y=y;
    rect.w=sw->info.w;
    rect.h=sw->info.h-y;
    
    px2km(sw, mouse_x - sw->x*FONT_W, mouse_y - sw->y*FONT_H, &kx, &ky);
    km2qrbqtf(kx, ky, &qrb, &qtf);
    
    SDL_SetClipRect(surface, &rect);
/*    SDL_FillRect(surface, &sw->info, makecol(0,0,175)) ; */
    SDL_FillRect(surface, &rect, makecol(0,0,35)) ;
    fontoutf(surface, x, y, sdl->green, FONT_TRANSP, VTEXT(T_GQRB), (int)(qrb));y+=FONT_H+4;
    fontoutf(surface, x, y, sdl->green, FONT_TRANSP, VTEXT(T_GQTF), (int)(qtf*180/MY_PI)); y+=FONT_H+4;
   /* fontoutf(surface, x, y, sdl->green, FONT_TRANSP, VTEXT(T_GINC), (int) (gst[(int)(qtf*180/MY_PI)%360]/400*100));y+=FONT_H+4; */

    if (qrbqtf2hw(sw->myh, sw->myw, qrb, qtf, &h2, &w2)==0){
        fontoutf(surface, x, y, sdl->green, FONT_TRANSP, VTEXT(T_GLON), h2*180.0/MY_PI, x2gramin(buf, h2*180/MY_PI, "EW")); y+=FONT_H+4;
        fontoutf(surface, x, y, sdl->green, FONT_TRANSP, VTEXT(T_GLAT), w2*180.0/MY_PI, x2gramin(buf, w2*180/MY_PI, "NS")); y+=FONT_H+4;
        fontoutf(surface, x, y, sdl->green, FONT_TRANSP, VTEXT(T_GLOC), hw2loc(buf, h2*180/MY_PI, w2*180/MY_PI)); y+=FONT_H+4;
    }
    
    return 0;
}

#else
int sw_map_kbd_func(struct subwin *sw, struct event *ev, int fw){
    return 0;
}

int sw_map_mouse_func(struct subwin *sw, struct event *ev, int fw){
    return 0;
}

void sw_map_redraw(struct subwin *sw){
}

void sw_map_check_bounds(struct subwin *sw){
}

void sw_map_raise(struct subwin *sw){
}

int maps_reload(){
    return 0;
}

void map_clear_qso(struct qso *qso){
}

void map_add_qso(struct qso *qso){
}
#endif
