/*
 * twclock:  A world clock implemented with openMotif widgets
 * Copyright (C) 1997 - 2007 Ted Williams WA0EIR
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have recieved a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge. MA 02139, USA.
 * See the COPYING file in this directory.
 *
 * Versions: 2.7 -  Aug 2007
 */

/*
 * TWCLOCK MAIN 
 */

#include "twclock.h"

#ifdef MAKE_ICON
#include "icons/twclock.xpm"
#endif

int main (int argc, char *argv[])
{
#ifdef MAKE_ICON 
   Pixmap pixmap, mask;
   XpmAttributes pix_attributes;
   XpmColorSymbol transparentColor[1] = {{NULL, "none", 0}};
#endif

   XtResource appRes_desc[] =
   {
      {
      XmNtzone,                     /* Name */
      XmCTzone,                     /* Class */
      XmRInt,                       /* Target data type */
      sizeof (int),                 /* size of target type */
      XtOffsetOf (AppRes, tzone),   /* Offset into struct */
      XtRImmediate,                 /* Default data type */
      (XtPointer) 0                 /* Pointer to default value */
      },

      {
      XmNblink,                     /* Same as above */
      XmCBlink,
      XmRInt,
      sizeof (int),
      XtOffsetOf (AppRes, blink),
      XtRImmediate,
      (XtPointer)1
      },

      {
      XmNbeep,                      /* Same as above */
      XmCBeep,
      XmRInt,
      sizeof (int),
      XtOffsetOf (AppRes, beep),
      XtRImmediate,
      (XtPointer)1
      },

      {
      XmNcwID,                      /* Same as above */
      XmCCwID,
      XmRInt,
      sizeof (int),
      XtOffsetOf (AppRes, cwID),
      XtRImmediate,
      (XtPointer)0
      },

      {
      XmNcwStr,                     /* Same as above */
      XmCCwStr,
      XtRString,
      100,
      //TJW sizeof (String),
      XtOffsetOf (AppRes, cwStr),
      XtRImmediate,
      (XtPointer) "n0call"
      },

      {
      XmNcwSpeed,                   /* Same as above */
      XmCCwSpeed,
      XtRInt,
      sizeof (int),
      XtOffsetOf (AppRes, cwSpeed),
      XtRImmediate,
      (XtPointer) "10"
      },

      {
      XmNcwLevel,                   /* Same as above */
      XmCCwLevel,
      XtRInt,
      sizeof (int),
      XtOffsetOf (AppRes, cwLevel),
      XtRImmediate,
      (XtPointer) "50"
      },

      {
      XmNdspDev,                    /* Same as above */
      XmCDspDev,
      XtRString,
      sizeof (String),
      XtOffsetOf (AppRes, dspDev),
      XtRImmediate,
      (XtPointer) "/dev/dsp"
      },

      {
      XmNmixerDev,                  /* Same as above */
      XmCMixerDev,
      XtRString,
      sizeof (String),
      XtOffsetOf (AppRes, mixerDev),
      XtRImmediate,
      (XtPointer) "/dev/mixer"
      },

      {
      XmNautoReset,                 /* Same as above */
      XmCAutoReset,
      XmRInt,
      sizeof (int),
      XtOffsetOf (AppRes, autoReset),
      XtRImmediate,
      (XtPointer)0
      },

      {
      XmNautobeeps,                 /* Same as above */
      XmCAutobeeps,
      XmRInt,
      sizeof (int),
      XtOffsetOf (AppRes, autobeeps),
      XtRImmediate,
      (XtPointer)5
      },

      {
      XmNflashColor,                /* Same as above */
      XmCFlashColor,
      XmRPixel,
      sizeof (Pixel),
      XtOffsetOf (AppRes, flashColor),
      XtRImmediate,
      (XtPointer)1
      },

      {
      XmNminutes,                   /* Same as above */
      XmCMinutes,
      XmRInt,
      sizeof (int),
      XtOffsetOf (AppRes, minutes),
      XtRImmediate,
      (XtPointer)10
      },

      {
      XmNseconds,                   /* Same as above */
      XmCSeconds,
      XmRInt,
      sizeof (int),
      XtOffsetOf (AppRes, seconds),
      XtRImmediate,
      (XtPointer)0
      },
  };

#ifdef XmVERSION_STRING
   extern const char _XmVersionString[];
   printf ("Compiled with %s\n", XmVERSION_STRING + 4);
   printf ("Running  with %s\n", _XmVersionString + 4);
#endif

   /*
    * Create clockShell and set some of its properties
    */

   clock_shell = XtVaAppInitialize (&app, "Twclock",
      NULL, 0, &argc, argv, NULL, 
      XmNminHeight, 175,
      XmNminWidth, 175,
      XmNmaxHeight, 250,
      XmNmaxWidth, 250,
      XmNminAspectX, 1,
      XmNminAspectY, 1,
      XmNmaxAspectX, 1,
      XmNmaxAspectY, 1,
      XmNtitle, "TWCLOCK ",
      /* XmNiconName, "TWCLOCK", */
      NULL);

   XtGetApplicationResources (clock_shell, &appRes, appRes_desc,
      XtNumber (appRes_desc), NULL, 0);

   /* Initialize libCW */
   cw_init(appRes.dspDev, appRes.mixerDev, NULL);
   cw_set_wpm (appRes.cwSpeed);
   cw_set_send_volume (appRes.cwLevel);
   cw_set_key_modes (SC);

   /*
    * If MAKE_ICON is defined, create its pixmap
    */
#ifdef MAKE_ICON
   pix_attributes.closeness = 40000;
   pix_attributes.valuemask = XpmColorSymbols | XpmCloseness;
   pix_attributes.colorsymbols = transparentColor;
   pix_attributes.numsymbols = 1;
   
   XpmCreatePixmapFromData (XtDisplay(clock_shell),
      DefaultRootWindow (XtDisplay (clock_shell)),
      twclock_xpm, &pixmap, &mask, &pix_attributes);
#endif
   /*
    * Build and Realize the rest of the widget tree
    */
   build_widgets();
   XtRealizeWidget (clock_shell);   

#ifdef MAKE_ICON
   XtVaSetValues (clock_shell,
      XmNiconPixmap, pixmap,
      NULL);
#endif
   /*
    * Enter the event loop
    */
   XtAppMainLoop (app);
   return (0);
}
