use strict;

my $webguiRoot = '/usr/share/webgui';

@INC = grep { $_ ne q{.} } @INC;

unshift @INC, $webguiRoot . "/lib";

# add custom lib directories to library search path
unshift @INC, grep {
    if (!-d $_) {
        warn "WARNING: Not adding lib directory '$_' from /etc/webgui/preload.custom: Directory does not exist.\n";
        0;
    }
    else {
        1;
    }
} readLines("/etc/webgui/preload.custom");

#----------------------------------------
# WebGUI modules.
#----------------------------------------
require WebGUI;
require WebGUI::Config;
require WebGUI::Pluggable;

# these modules should always be skipped
my @excludes = qw(WebGUI::i18n::English::Automated_Information WebGUI::PerformanceProfiler);
push @excludes, readLines("/etc/webgui/preload.exclude");

WebGUI::Pluggable::findAndLoad( "WebGUI",
    {
        exclude    => \@excludes,
        onLoadFail => sub { warn sprintf 'Error loading %s: %s', @_ },
    }
);

#----------------------------------------
# Preload all site configs.
#----------------------------------------
WebGUI::Config->loadAllConfigs($webguiRoot);

#----------------------------------------
# WebGUI::Fork initialization
#----------------------------------------
WebGUI::Fork->init();

#----------------------------------------
# Logger
#----------------------------------------
require Log::Log4perl;
Log::Log4perl->init("/etc/webgui/log.conf" );

#----------------------------------------
# Database connectivity.
#----------------------------------------
#require Apache::DBI; # Uncomment if you want to enable connection pooling. Not recommended on servers with many sites, or those using db slaves.
require DBI;
DBI->install_driver("mysql"); # Change to match your database driver.

require APR::Request::Apache2;
require Apache2::Cookie;
require Apache2::ServerUtil;

if ( $ENV{MOD_PERL} ) {
    # Add WebGUI to Apache version tokens
    my $server = Apache2::ServerUtil->server;
    $server->push_handlers( PerlPostConfigHandler => sub {
        $server->add_version_component("WebGUI/" . $WebGUI::VERSION);
    });
}

$| = 1;

print "\nStarting WebGUI " . $WebGUI::VERSION . "\n";

# reads lines from a file into an array, trimming white space and ignoring commented lines
sub readLines {
    my $file = shift;
    my @lines;
    if (open(my $fh, '<', $file)) {
        while (my $line = <$fh>) {
            $line =~ s/#.*//;
            $line =~ s/^\s+//;
            $line =~ s/\s+$//;
            next if !$line;
            push @lines, $line;
        }
        close $fh;
    }
    return @lines;
}

1;

