// generated by diplomat-tool
import type { DataError } from "./DataError"
import type { DataProvider } from "./DataProvider"
import type { Locale } from "./Locale"
import type { Weekday } from "./Weekday"
import type { WeekdaySetIterator } from "./WeekdaySetIterator"
import type { pointer, codepoint } from "./diplomat-runtime.d.ts";


/**
 * A Week calculator, useful to be passed in to `week_of_year()` on Date and DateTime types
 *
 * See the [Rust documentation for `WeekInformation`](https://docs.rs/icu/latest/icu/calendar/week/struct.WeekInformation.html) for more information.
 */


export class WeekInformation {
    get ffiValue(): pointer;


    /**
     * Creates a new [`WeekInformation`] from locale data using a particular data source.
     *
     * See the [Rust documentation for `try_new`](https://docs.rs/icu/latest/icu/calendar/week/struct.WeekInformation.html#method.try_new) for more information.
     */
    static createWithProvider(provider: DataProvider, locale: Locale): WeekInformation;

    /**
     * Returns the weekday that starts the week for this object's locale
     *
     * See the [Rust documentation for `first_weekday`](https://docs.rs/icu/latest/icu/calendar/week/struct.WeekInformation.html#structfield.first_weekday) for more information.
     */
    get firstWeekday(): Weekday;

    /**
     * See the [Rust documentation for `weekend`](https://docs.rs/icu/latest/icu/calendar/week/struct.WeekInformation.html#structfield.weekend) for more information.
     *
     * See the [Rust documentation for `contains`](https://docs.rs/icu/latest/icu/calendar/provider/struct.WeekdaySet.html#method.contains) for more information.
     */
    isWeekend(day: Weekday): boolean;

    /**
     * See the [Rust documentation for `weekend`](https://docs.rs/icu/latest/icu/calendar/week/struct.WeekInformation.html#method.weekend) for more information.
     */
    get weekend(): WeekdaySetIterator;

    constructor(locale: Locale);
}