/*
 * Decompiled with CFR 0.152.
 */
package soundfileconvert;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

public class SoundfileConvert {
    public boolean SAXException;
    private PrintWriter out;

    public static void main(String[] args) {
        String inFileStr = new String("");
        String outFileStr = new String("");
        if (args.length > 0) {
            inFileStr = args[0];
            if (args.length > 1) {
                outFileStr = args[1];
            } else {
                System.out.println("Usage: java -jar soundfileconvert.jar infile.xml outfile.dat");
                System.exit(0);
            }
        }
        new SoundfileConvert(inFileStr, outFileStr);
    }

    public SoundfileConvert(String inFileStr, String outFileStr) {
        block20: {
            String s1;
            int soundId;
            Element sound;
            int soundtypeId;
            Element soundtype;
            Document doc;
            this.SAXException = false;
            if (inFileStr.length() == 0 || outFileStr.length() == 0) {
                System.out.println("Usage: java -jar soundfileconvert.jar infile.xml outfile.dat");
                System.exit(0);
            }
            if ((doc = this.getDocument(inFileStr)) == null) {
                System.out.println("Conversion terminated on XML parse failure.");
                return;
            }
            Element root = doc.getDocumentElement();
            int errors = 0;
            int id1 = 0;
            int id2 = 0;
            boolean dup = false;
            Vector<Integer> soundtypeIds = new Vector<Integer>();
            Vector<String> soundTypes = new Vector<String>();
            Vector<Integer> soundIds = new Vector<Integer>();
            Vector<String> soundNames = new Vector<String>();
            Vector<Integer> idErrs = new Vector<Integer>();
            Vector<String> nErrs = new Vector<String>();
            for (soundtype = (Element)root.getFirstChild(); soundtype != null; soundtype = (Element)soundtype.getNextSibling()) {
                int j;
                int i;
                soundtypeId = Integer.parseInt(soundtype.getAttribute("id"));
                soundtypeIds.add(soundtypeId);
                soundTypes.add(soundtype.getAttribute("type"));
                for (sound = (Element)soundtype.getFirstChild(); sound != null; sound = (Element)sound.getNextSibling()) {
                    soundId = Integer.parseInt(sound.getAttribute("id"));
                    soundIds.add(soundId);
                    soundNames.add(sound.getAttribute("name"));
                }
                dup = false;
                for (i = 0; i < soundIds.size() - 1; ++i) {
                    id1 = (Integer)soundIds.get(i);
                    for (j = i + 1; j < soundIds.size(); ++j) {
                        id2 = (Integer)soundIds.get(j);
                        if (id2 != id1) continue;
                        dup = true;
                        idErrs.add(id1);
                        ++errors;
                    }
                }
                if (dup) {
                    for (i = 0; i < idErrs.size(); ++i) {
                        System.out.println("Duplicate sound id " + idErrs.get(i) + " for soundtype id " + soundtypeId + " (" + (String)soundTypes.get(soundtypeId) + ").");
                    }
                    idErrs.clear();
                }
                soundIds.clear();
                dup = false;
                for (i = 0; i < soundNames.size() - 1; ++i) {
                    s1 = (String)soundNames.get(i);
                    for (j = i + 1; j < soundNames.size(); ++j) {
                        if (!((String)soundNames.get(j)).equalsIgnoreCase(s1)) continue;
                        dup = true;
                        nErrs.add(s1);
                        ++errors;
                    }
                }
                if (dup) {
                    for (i = 0; i < nErrs.size(); ++i) {
                        System.out.println("Duplicate sound name '" + (String)nErrs.get(i) + "' for soundtype id " + soundtypeId + " (" + (String)soundTypes.get(soundtypeId) + ").");
                    }
                    nErrs.clear();
                }
                soundNames.clear();
            }
            if (errors > 0) {
                System.out.println(errors + " errors in file " + inFileStr + ".");
                return;
            }
            File outF = new File(outFileStr);
            if (outF.isDirectory()) {
                System.out.println("Output file cannot be a directory.");
                return;
            }
            if (outF.exists()) {
                outF.delete();
                System.out.println("Existing output file was deleted.");
            }
            try {
                if (outF.createNewFile()) {
                    this.out = new PrintWriter(new BufferedWriter(new FileWriter(outF)));
                    SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy.MM.dd kk:mm:ss");
                    String date = dateFormatter.format(new Date());
                    this.out.println("# This file is automatically generated. Do not edit.");
                    this.out.println("# Sound data file created on " + date);
                    this.out.println("# Created from " + inFileStr);
                    int nodeCount = root.getChildNodes().getLength();
                    s1 = String.format("*start|%d", nodeCount);
                    this.out.println(s1);
                    for (soundtype = (Element)root.getFirstChild(); soundtype != null; soundtype = (Element)soundtype.getNextSibling()) {
                        nodeCount = soundtype.getChildNodes().getLength();
                        soundtypeId = Integer.parseInt(soundtype.getAttribute("id"));
                        String type = soundtype.getAttribute("type").toUpperCase();
                        String prefix = soundtype.getAttribute("prefix").toUpperCase();
                        s1 = String.format("*%d|%s|%s|%d", soundtypeId, type, prefix, nodeCount);
                        this.out.println(s1);
                        for (sound = (Element)soundtype.getFirstChild(); sound != null; sound = (Element)sound.getNextSibling()) {
                            soundId = Integer.parseInt(sound.getAttribute("id"));
                            String name = sound.getAttribute("name").toUpperCase();
                            String file = sound.getAttribute("file");
                            s1 = String.format("+%d|%s|%s", soundId, name, file);
                            this.out.println(s1);
                        }
                    }
                    break block20;
                }
                System.out.println("Failed to create output file.");
                return;
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        this.out.println("*end");
        this.out.close();
        System.out.println("File " + inFileStr + " successfully converted.");
    }

    private Document getDocument(String name) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setIgnoringComments(true);
            factory.setIgnoringElementContentWhitespace(true);
            factory.setValidating(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setErrorHandler(new MyHandler());
            Document doc = builder.parse(new InputSource(name));
            return this.SAXException ? null : doc;
        }
        catch (Exception e) {
            System.out.println("exception in getDocument.");
            System.out.println(e.getMessage());
            return null;
        }
    }

    private class MyHandler
    implements ErrorHandler {
        private MyHandler() {
        }

        private void doMessage(SAXParseException e, String s) {
            System.out.println("XML parse " + s + " at line " + e.getLineNumber() + ": " + e.getMessage());
            SoundfileConvert.this.SAXException = true;
        }

        public void fatalError(SAXParseException e) {
            this.doMessage(e, "fatal error");
        }

        public void error(SAXParseException e) {
            this.doMessage(e, "error");
        }

        public void warning(SAXParseException e) {
            this.doMessage(e, "warning");
        }
    }
}

