/*
 * This source file is part of Daimonin (http://daimonin.sourceforge.net)
 * Copyright (c) 2007 The Daimonin Team
 * Also see acknowledgements in Readme.html
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 * In addition, as a special exception, the copyright holders of client3d give
 * you permission to combine the client3d program with lgpl libraries of your
 * choice and/or with the fmod libraries.
 * You may copy and distribute such a system following the terms of the GNU GPL
 * for client3d and the licenses of the other code concerned.
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place - Suite 330, Boston, MA 02111-1307, USA, or go to
 * http://www.gnu.org/licenses/licenses.html
 */

package net.daimonin.client3d.editor.ui;

import java.awt.Color;

import javax.swing.JColorChooser;
import javax.swing.JFileChooser;

import net.daimonin.client3d.editor.main.Editor3D;

/**
 * Panel to generate the Imageset.PNG file.
 * 
 * @author Rumbuff
 */
public class GeneratePanel extends javax.swing.JPanel implements java.awt.event.ActionListener,
		javax.swing.event.ChangeListener {

	/** Creates new form AllPanel */
	public GeneratePanel() {
		initComponents();
		defaultBorderColor = new Color(Integer.valueOf(Editor3D.borderColorR), Integer.valueOf(Editor3D.borderColorG),
				Integer.valueOf(Editor3D.borderColorB));
		jTextFieldStartingDir.setText(Editor3D.startingDir);
		jSliderBorderSize.setValue(Integer.valueOf(Editor3D.borderSize));
		jSliderBorderSizeStateChanged(null);
	}

	/**
   * This method is called from within the constructor to initialize the form.
   * WARNING: Do NOT modify this code. The content of this method is always
   * regenerated by the Form Editor.
   */
	// <editor-fold defaultstate="collapsed" desc=" Generated Code
  // ">//GEN-BEGIN:initComponents
	private void initComponents() {
		java.awt.GridBagConstraints gridBagConstraints;

		jTextFieldStartingDir = new javax.swing.JTextField();
		jLabelStartingDir = new javax.swing.JLabel();
		jButtonStartingDir = new javax.swing.JButton();
		jCheckBoxStartingDir = new javax.swing.JCheckBox();
		jLabelBorderSize = new javax.swing.JLabel();
		jCheckBoxBorderSize = new javax.swing.JCheckBox();
		jLabelBorderColor = new javax.swing.JLabel();
		jTextFieldBorderColor = new javax.swing.JTextField();
		jButtonBorderColor = new javax.swing.JButton();
		jSliderBorderSize = new javax.swing.JSlider();
		jCheckBoxBorderColor = new javax.swing.JCheckBox();
		jButtonAll = new javax.swing.JButton();

		setLayout(new java.awt.GridBagLayout());

		setMaximumSize(new java.awt.Dimension(550, 200));
		setMinimumSize(new java.awt.Dimension(550, 200));
		setPreferredSize(new java.awt.Dimension(550, 200));
		setRequestFocusEnabled(false);
		jTextFieldStartingDir.setEditable(false);
		jTextFieldStartingDir.setToolTipText("Directory to scan recursively for PNG images");
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 1;
		gridBagConstraints.gridy = 0;
		gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
		gridBagConstraints.weightx = 1.0;
		gridBagConstraints.insets = new java.awt.Insets(0, 0, 12, 8);
		add(jTextFieldStartingDir, gridBagConstraints);

		jLabelStartingDir.setText("Starting directory");
		jLabelStartingDir.setToolTipText("Directory to scan recursively for PNG images");
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 0;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
		gridBagConstraints.insets = new java.awt.Insets(0, 8, 12, 16);
		add(jLabelStartingDir, gridBagConstraints);

		jButtonStartingDir.setText("...");
		jButtonStartingDir.setToolTipText("chose a directory");
		jButtonStartingDir.setMaximumSize(new java.awt.Dimension(16, 16));
		jButtonStartingDir.setMinimumSize(new java.awt.Dimension(16, 16));
		jButtonStartingDir.setPreferredSize(new java.awt.Dimension(16, 16));
		jButtonStartingDir.addActionListener(this);

		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 2;
		gridBagConstraints.gridy = 0;
		gridBagConstraints.insets = new java.awt.Insets(0, 0, 12, 16);
		add(jButtonStartingDir, gridBagConstraints);

		jCheckBoxStartingDir.setText("default");
		jCheckBoxStartingDir.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
		jCheckBoxStartingDir.setMargin(new java.awt.Insets(0, 0, 0, 0));
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
		gridBagConstraints.insets = new java.awt.Insets(0, 16, 12, 8);
		add(jCheckBoxStartingDir, gridBagConstraints);

		jLabelBorderSize.setText("Border size");
		jLabelBorderSize.setToolTipText("Border size for every image in pixel");
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 1;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
		gridBagConstraints.insets = new java.awt.Insets(0, 8, 12, 16);
		add(jLabelBorderSize, gridBagConstraints);

		jCheckBoxBorderSize.setText("default");
		jCheckBoxBorderSize.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
		jCheckBoxBorderSize.setMargin(new java.awt.Insets(0, 0, 0, 0));
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 3;
		gridBagConstraints.gridy = 1;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
		gridBagConstraints.insets = new java.awt.Insets(0, 16, 12, 8);
		add(jCheckBoxBorderSize, gridBagConstraints);

		jLabelBorderColor.setText("Border color");
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 2;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
		gridBagConstraints.insets = new java.awt.Insets(0, 8, 12, 16);
		add(jLabelBorderColor, gridBagConstraints);

		jTextFieldBorderColor.setEditable(false);
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 1;
		gridBagConstraints.gridy = 2;
		gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
		gridBagConstraints.weightx = 1.0;
		gridBagConstraints.insets = new java.awt.Insets(0, 0, 12, 8);
		add(jTextFieldBorderColor, gridBagConstraints);

		jButtonBorderColor.setText("...");
		jButtonBorderColor.setToolTipText("chose a border color");
		jButtonBorderColor.setMaximumSize(new java.awt.Dimension(16, 16));
		jButtonBorderColor.setMinimumSize(new java.awt.Dimension(16, 16));
		jButtonBorderColor.setPreferredSize(new java.awt.Dimension(16, 16));
		jButtonBorderColor.addActionListener(this);

		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 2;
		gridBagConstraints.gridy = 2;
		gridBagConstraints.insets = new java.awt.Insets(0, 0, 12, 16);
		add(jButtonBorderColor, gridBagConstraints);

		jSliderBorderSize.setMajorTickSpacing(1);
		jSliderBorderSize.setMaximum(3);
		jSliderBorderSize.setMinorTickSpacing(1);
		jSliderBorderSize.setPaintLabels(true);
		jSliderBorderSize.setPaintTicks(true);
		jSliderBorderSize.setSnapToTicks(true);
		jSliderBorderSize.setToolTipText("Border size for every image in pixel");
		jSliderBorderSize.setValue(0);
		jSliderBorderSize.setValueIsAdjusting(true);
		jSliderBorderSize.addChangeListener(this);

		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 1;
		gridBagConstraints.gridy = 1;
		gridBagConstraints.weightx = 1.0;
		gridBagConstraints.insets = new java.awt.Insets(0, 0, 12, 8);
		add(jSliderBorderSize, gridBagConstraints);

		jCheckBoxBorderColor.setText("default");
		jCheckBoxBorderColor.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
		jCheckBoxBorderColor.setMargin(new java.awt.Insets(0, 0, 0, 0));
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 3;
		gridBagConstraints.gridy = 2;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
		gridBagConstraints.insets = new java.awt.Insets(0, 16, 12, 8);
		add(jCheckBoxBorderColor, gridBagConstraints);

		jButtonAll.setText("Start");
		jButtonAll.setToolTipText("Start creation of the Imageset");
		jButtonAll.setMaximumSize(new java.awt.Dimension(128, 25));
		jButtonAll.setMinimumSize(new java.awt.Dimension(128, 25));
		jButtonAll.setPreferredSize(new java.awt.Dimension(128, 25));
		jButtonAll.addActionListener(this);

		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 1;
		gridBagConstraints.gridy = 3;
		gridBagConstraints.insets = new java.awt.Insets(16, 0, 0, 0);
		add(jButtonAll, gridBagConstraints);

	}

	// Code for dispatching events from components to event handlers.

	public void actionPerformed(java.awt.event.ActionEvent evt) {
		if (evt.getSource() == jButtonStartingDir) {
			GeneratePanel.this.jButtonStartingDirActionPerformed(evt);
		} else if (evt.getSource() == jButtonBorderColor) {
			GeneratePanel.this.jButtonBorderColorActionPerformed(evt);
		} else if (evt.getSource() == jButtonAll) {
			GeneratePanel.this.jButtonAllActionPerformed(evt);
		}
	}

	public void stateChanged(javax.swing.event.ChangeEvent evt) {
		if (evt.getSource() == jSliderBorderSize) {
			GeneratePanel.this.jSliderBorderSizeStateChanged(evt);
		}
	}// </editor-fold>//GEN-END:initComponents

	private void jSliderBorderSizeStateChanged(javax.swing.event.ChangeEvent evt) {// GEN-FIRST:event_jSliderBorderSizeStateChanged
		if (jSliderBorderSize.getValueIsAdjusting()) {
			if (jSliderBorderSize.getValue() > 0) {
				jButtonBorderColor.setEnabled(true);
				jTextFieldBorderColor.setBackground(defaultBorderColor);
			} else {
				jButtonBorderColor.setEnabled(false);
				jCheckBoxBorderColor.setSelected(false);
				jTextFieldBorderColor.setBackground(null);
			}
		}
	}// GEN-LAST:event_jSliderBorderSizeStateChanged

	private void jButtonBorderColorActionPerformed(java.awt.event.ActionEvent evt) {// GEN-FIRST:event_jButtonBorderColorActionPerformed
		final Color color = JColorChooser.showDialog(this, "Choose a border color", defaultBorderColor);
		if (color != null) {
			Editor3D.borderColorR = String.valueOf(color.getRed());
			Editor3D.borderColorG = String.valueOf(color.getGreen());
			Editor3D.borderColorB = String.valueOf(color.getBlue());
			defaultBorderColor = color;
			jTextFieldBorderColor.setBackground(color);
		}
	}// GEN-LAST:event_jButtonBorderColorActionPerformed

	private void jButtonAllActionPerformed(java.awt.event.ActionEvent evt) {// GEN-FIRST:event_jButtonAllActionPerformed
		Editor3D.borderSize = String.valueOf(jSliderBorderSize.getValue());
		Editor3D.generate(this);
	}// GEN-LAST:event_jButtonAllActionPerformed

	private void jButtonStartingDirActionPerformed(java.awt.event.ActionEvent evt) {// GEN-FIRST:event_jButtonStartingDirActionPerformed

		final JFileChooser dirChooser = new JFileChooser();
		dirChooser.setDialogTitle("Choose a directory with PNG images");
		dirChooser.setFileHidingEnabled(false);
		dirChooser.setFileSelectionMode(javax.swing.JFileChooser.DIRECTORIES_ONLY);

		final int result = dirChooser.showOpenDialog(this);
		if (result == JFileChooser.APPROVE_OPTION) {
			Editor3D.startingDir = dirChooser.getSelectedFile().getPath();
			jTextFieldStartingDir.setText(Editor3D.startingDir);
		}
	}// GEN-LAST:event_jButtonStartingDirActionPerformed

	private Color defaultBorderColor;

	// Variables declaration - do not modify//GEN-BEGIN:variables
	private javax.swing.JButton jButtonAll;

	private javax.swing.JButton jButtonBorderColor;

	private javax.swing.JButton jButtonStartingDir;

	public javax.swing.JCheckBox jCheckBoxBorderColor;

	public javax.swing.JCheckBox jCheckBoxBorderSize;

	public javax.swing.JCheckBox jCheckBoxStartingDir;

	private javax.swing.JLabel jLabelBorderColor;

	private javax.swing.JLabel jLabelBorderSize;

	private javax.swing.JLabel jLabelStartingDir;

	private javax.swing.JSlider jSliderBorderSize;

	private javax.swing.JTextField jTextFieldBorderColor;

	private javax.swing.JTextField jTextFieldStartingDir;
	// End of variables declaration//GEN-END:variables

}
