/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.similarity;

import org.apache.commons.text.similarity.JaroWinklerSimilarity;
import org.apache.commons.text.similarity.SimilarityInputTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class JaroWinklerSimilarityTest {
    private static JaroWinklerSimilarity similarity;

    @BeforeAll
    public static void setUp() {
        similarity = new JaroWinklerSimilarity();
    }

    private static CharSequence wrap(final String string) {
        return new CharSequence(){

            @Override
            public char charAt(int index) {
                return string.charAt(index);
            }

            public boolean equals(Object obj) {
                return string.equals(obj);
            }

            public int hashCode() {
                return string.hashCode();
            }

            @Override
            public int length() {
                return string.length();
            }

            @Override
            public CharSequence subSequence(int start, int end) {
                return string.subSequence(start, end);
            }

            @Override
            public String toString() {
                return string;
            }
        };
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.text.similarity.SimilarityInputTest#similarityInputsEquals()"})
    public void testGetJaroWinklerSimilarity(Class<?> cls) {
        Assertions.assertEquals((double)1.0, (double)similarity.apply(SimilarityInputTest.build(cls, ""), SimilarityInputTest.build(cls, "")), (double)1.0E-5);
        Assertions.assertEquals((double)1.0, (double)similarity.apply(SimilarityInputTest.build(cls, "foo"), SimilarityInputTest.build(cls, "foo")), (double)1.0E-5);
        Assertions.assertEquals((double)0.94166, (double)similarity.apply(SimilarityInputTest.build(cls, "foo"), SimilarityInputTest.build(cls, "foo ")), (double)1.0E-5);
        Assertions.assertEquals((double)0.90666, (double)similarity.apply(SimilarityInputTest.build(cls, "foo"), SimilarityInputTest.build(cls, "foo  ")), (double)1.0E-5);
        Assertions.assertEquals((double)0.86666, (double)similarity.apply(SimilarityInputTest.build(cls, "foo"), SimilarityInputTest.build(cls, " foo ")), (double)1.0E-5);
        Assertions.assertEquals((double)0.51111, (double)similarity.apply(SimilarityInputTest.build(cls, "foo"), SimilarityInputTest.build(cls, "  foo")), (double)1.0E-5);
        Assertions.assertEquals((double)0.92499, (double)similarity.apply(SimilarityInputTest.build(cls, "frog"), SimilarityInputTest.build(cls, "fog")), (double)1.0E-5);
        Assertions.assertEquals((double)0.0, (double)similarity.apply(SimilarityInputTest.build(cls, "fly"), SimilarityInputTest.build(cls, "ant")), (double)1.0E-20);
        Assertions.assertEquals((double)0.44166, (double)similarity.apply(SimilarityInputTest.build(cls, "elephant"), SimilarityInputTest.build(cls, "hippo")), (double)1.0E-5);
        Assertions.assertEquals((double)0.90666, (double)similarity.apply(SimilarityInputTest.build(cls, "ABC Corporation"), SimilarityInputTest.build(cls, "ABC Corp")), (double)1.0E-5);
        Assertions.assertEquals((double)0.95251, (double)similarity.apply(SimilarityInputTest.build(cls, "D N H Enterprises Inc"), SimilarityInputTest.build(cls, "D & H Enterprises, Inc.")), (double)1.0E-5);
        Assertions.assertEquals((double)0.942, (double)similarity.apply(SimilarityInputTest.build(cls, "My Gym Children's Fitness Center"), SimilarityInputTest.build(cls, "My Gym. Childrens Fitness")), (double)1.0E-5);
        Assertions.assertEquals((double)0.898018, (double)similarity.apply(SimilarityInputTest.build(cls, "PENNSYLVANIA"), SimilarityInputTest.build(cls, "PENNCISYLVNIA")), (double)1.0E-5);
        Assertions.assertEquals((double)0.971428, (double)similarity.apply(SimilarityInputTest.build(cls, "/opt/software1"), SimilarityInputTest.build(cls, "/opt/software2")), (double)1.0E-5);
        Assertions.assertEquals((double)0.941666, (double)similarity.apply(SimilarityInputTest.build(cls, "aaabcd"), SimilarityInputTest.build(cls, "aaacdb")), (double)1.0E-5);
        Assertions.assertEquals((double)0.911111, (double)similarity.apply(SimilarityInputTest.build(cls, "John Horn"), SimilarityInputTest.build(cls, "John Hopkins")), (double)1.0E-5);
    }

    @Test
    public void testGetJaroWinklerSimilarity_NullNull() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> similarity.apply((CharSequence)null, null));
    }

    @Test
    public void testGetJaroWinklerSimilarity_NullString() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> similarity.apply(null, (CharSequence)"clear"));
    }

    @Test
    public void testGetJaroWinklerSimilarity_StringNull() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> similarity.apply((CharSequence)" ", null));
    }

    @Test
    public void testGetJaroWinklerSimilarity_StringString() {
        Assertions.assertEquals((double)1.0, (double)similarity.apply(JaroWinklerSimilarityTest.wrap(""), (CharSequence)""), (double)1.0E-5);
        Assertions.assertEquals((double)1.0, (double)similarity.apply(JaroWinklerSimilarityTest.wrap("foo"), (CharSequence)"foo"), (double)1.0E-5);
        Assertions.assertEquals((double)0.94166, (double)similarity.apply(JaroWinklerSimilarityTest.wrap("foo"), (CharSequence)"foo "), (double)1.0E-5);
        Assertions.assertEquals((double)0.90666, (double)similarity.apply(JaroWinklerSimilarityTest.wrap("foo"), (CharSequence)"foo  "), (double)1.0E-5);
        Assertions.assertEquals((double)0.86666, (double)similarity.apply(JaroWinklerSimilarityTest.wrap("foo"), (CharSequence)" foo "), (double)1.0E-5);
        Assertions.assertEquals((double)0.51111, (double)similarity.apply(JaroWinklerSimilarityTest.wrap("foo"), (CharSequence)"  foo"), (double)1.0E-5);
        Assertions.assertEquals((double)0.92499, (double)similarity.apply(JaroWinklerSimilarityTest.wrap("frog"), (CharSequence)"fog"), (double)1.0E-5);
        Assertions.assertEquals((double)0.0, (double)similarity.apply(JaroWinklerSimilarityTest.wrap("fly"), (CharSequence)"ant"), (double)1.0E-20);
        Assertions.assertEquals((double)0.44166, (double)similarity.apply(JaroWinklerSimilarityTest.wrap("elephant"), (CharSequence)"hippo"), (double)1.0E-5);
        Assertions.assertEquals((double)0.90666, (double)similarity.apply(JaroWinklerSimilarityTest.wrap("ABC Corporation"), (CharSequence)"ABC Corp"), (double)1.0E-5);
        Assertions.assertEquals((double)0.95251, (double)similarity.apply(JaroWinklerSimilarityTest.wrap("D N H Enterprises Inc"), (CharSequence)"D & H Enterprises, Inc."), (double)1.0E-5);
        Assertions.assertEquals((double)0.942, (double)similarity.apply(JaroWinklerSimilarityTest.wrap("My Gym Children's Fitness Center"), (CharSequence)"My Gym. Childrens Fitness"), (double)1.0E-5);
        Assertions.assertEquals((double)0.898018, (double)similarity.apply(JaroWinklerSimilarityTest.wrap("PENNSYLVANIA"), (CharSequence)"PENNCISYLVNIA"), (double)1.0E-5);
        Assertions.assertEquals((double)0.971428, (double)similarity.apply(JaroWinklerSimilarityTest.wrap("/opt/software1"), (CharSequence)"/opt/software2"), (double)1.0E-5);
        Assertions.assertEquals((double)0.941666, (double)similarity.apply(JaroWinklerSimilarityTest.wrap("aaabcd"), (CharSequence)"aaacdb"), (double)1.0E-5);
        Assertions.assertEquals((double)0.911111, (double)similarity.apply(JaroWinklerSimilarityTest.wrap("John Horn"), (CharSequence)"John Hopkins"), (double)1.0E-5);
    }
}

