/*
 * This file is generated by gdbus-codegen, do not modify it.
 *
 * The license of this code is the same as for the D-Bus interface description
 * it was derived from. Note that it links to GLib, so must comply with the
 * LGPL linking clauses.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "generated-gpiodbus.h"

#include <string.h>
#ifdef G_OS_UNIX
#  include <gio/gunixfdlist.h>
#endif

#ifdef G_ENABLE_DEBUG
#define g_marshal_value_peek_boolean(v)  g_value_get_boolean (v)
#define g_marshal_value_peek_char(v)     g_value_get_schar (v)
#define g_marshal_value_peek_uchar(v)    g_value_get_uchar (v)
#define g_marshal_value_peek_int(v)      g_value_get_int (v)
#define g_marshal_value_peek_uint(v)     g_value_get_uint (v)
#define g_marshal_value_peek_long(v)     g_value_get_long (v)
#define g_marshal_value_peek_ulong(v)    g_value_get_ulong (v)
#define g_marshal_value_peek_int64(v)    g_value_get_int64 (v)
#define g_marshal_value_peek_uint64(v)   g_value_get_uint64 (v)
#define g_marshal_value_peek_enum(v)     g_value_get_enum (v)
#define g_marshal_value_peek_flags(v)    g_value_get_flags (v)
#define g_marshal_value_peek_float(v)    g_value_get_float (v)
#define g_marshal_value_peek_double(v)   g_value_get_double (v)
#define g_marshal_value_peek_string(v)   (char*) g_value_get_string (v)
#define g_marshal_value_peek_param(v)    g_value_get_param (v)
#define g_marshal_value_peek_boxed(v)    g_value_get_boxed (v)
#define g_marshal_value_peek_pointer(v)  g_value_get_pointer (v)
#define g_marshal_value_peek_object(v)   g_value_get_object (v)
#define g_marshal_value_peek_variant(v)  g_value_get_variant (v)
#else /* !G_ENABLE_DEBUG */
/* WARNING: This code accesses GValues directly, which is UNSUPPORTED API.
 *          Do not access GValues directly in your code. Instead, use the
 *          g_value_get_*() functions
 */
#define g_marshal_value_peek_boolean(v)  (v)->data[0].v_int
#define g_marshal_value_peek_char(v)     (v)->data[0].v_int
#define g_marshal_value_peek_uchar(v)    (v)->data[0].v_uint
#define g_marshal_value_peek_int(v)      (v)->data[0].v_int
#define g_marshal_value_peek_uint(v)     (v)->data[0].v_uint
#define g_marshal_value_peek_long(v)     (v)->data[0].v_long
#define g_marshal_value_peek_ulong(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_int64(v)    (v)->data[0].v_int64
#define g_marshal_value_peek_uint64(v)   (v)->data[0].v_uint64
#define g_marshal_value_peek_enum(v)     (v)->data[0].v_long
#define g_marshal_value_peek_flags(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_float(v)    (v)->data[0].v_float
#define g_marshal_value_peek_double(v)   (v)->data[0].v_double
#define g_marshal_value_peek_string(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_param(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_boxed(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_pointer(v)  (v)->data[0].v_pointer
#define g_marshal_value_peek_object(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_variant(v)  (v)->data[0].v_pointer
#endif /* !G_ENABLE_DEBUG */

typedef struct
{
  GDBusArgInfo parent_struct;
  gboolean use_gvariant;
} _ExtendedGDBusArgInfo;

typedef struct
{
  GDBusMethodInfo parent_struct;
  const gchar *signal_name;
  gboolean pass_fdlist;
} _ExtendedGDBusMethodInfo;

typedef struct
{
  GDBusSignalInfo parent_struct;
  const gchar *signal_name;
} _ExtendedGDBusSignalInfo;

typedef struct
{
  GDBusPropertyInfo parent_struct;
  const gchar *hyphen_name;
  guint use_gvariant : 1;
  guint emits_changed_signal : 1;
} _ExtendedGDBusPropertyInfo;

typedef struct
{
  GDBusInterfaceInfo parent_struct;
  const gchar *hyphen_name;
} _ExtendedGDBusInterfaceInfo;

typedef struct
{
  const _ExtendedGDBusPropertyInfo *info;
  guint prop_id;
  GValue orig_value; /* the value before the change */
} ChangedProperty;

static void
_changed_property_free (ChangedProperty *data)
{
  g_value_unset (&data->orig_value);
  g_free (data);
}

static gboolean
_g_strv_equal0 (gchar **a, gchar **b)
{
  gboolean ret = FALSE;
  guint n;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  if (g_strv_length (a) != g_strv_length (b))
    goto out;
  for (n = 0; a[n] != NULL; n++)
    if (g_strcmp0 (a[n], b[n]) != 0)
      goto out;
  ret = TRUE;
out:
  return ret;
}

static gboolean
_g_variant_equal0 (GVariant *a, GVariant *b)
{
  gboolean ret = FALSE;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  ret = g_variant_equal (a, b);
out:
  return ret;
}

G_GNUC_UNUSED static gboolean
_g_value_equal (const GValue *a, const GValue *b)
{
  gboolean ret = FALSE;
  g_assert (G_VALUE_TYPE (a) == G_VALUE_TYPE (b));
  switch (G_VALUE_TYPE (a))
    {
      case G_TYPE_BOOLEAN:
        ret = (g_value_get_boolean (a) == g_value_get_boolean (b));
        break;
      case G_TYPE_UCHAR:
        ret = (g_value_get_uchar (a) == g_value_get_uchar (b));
        break;
      case G_TYPE_INT:
        ret = (g_value_get_int (a) == g_value_get_int (b));
        break;
      case G_TYPE_UINT:
        ret = (g_value_get_uint (a) == g_value_get_uint (b));
        break;
      case G_TYPE_INT64:
        ret = (g_value_get_int64 (a) == g_value_get_int64 (b));
        break;
      case G_TYPE_UINT64:
        ret = (g_value_get_uint64 (a) == g_value_get_uint64 (b));
        break;
      case G_TYPE_DOUBLE:
        {
          /* Avoid -Wfloat-equal warnings by doing a direct bit compare */
          gdouble da = g_value_get_double (a);
          gdouble db = g_value_get_double (b);
          ret = memcmp (&da, &db, sizeof (gdouble)) == 0;
        }
        break;
      case G_TYPE_STRING:
        ret = (g_strcmp0 (g_value_get_string (a), g_value_get_string (b)) == 0);
        break;
      case G_TYPE_VARIANT:
        ret = _g_variant_equal0 (g_value_get_variant (a), g_value_get_variant (b));
        break;
      default:
        if (G_VALUE_TYPE (a) == G_TYPE_STRV)
          ret = _g_strv_equal0 (g_value_get_boxed (a), g_value_get_boxed (b));
        else
          g_critical ("_g_value_equal() does not handle type %s", g_type_name (G_VALUE_TYPE (a)));
        break;
    }
  return ret;
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_VARIANT_VARIANT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectVariantVariantFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        GVariant *arg_line_config,
        GVariant *arg_request_config,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectVariantVariantFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 4);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectVariantVariantFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_variant (param_values + 2),
              g_marshal_value_peek_variant (param_values + 3),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 2);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_VARIANT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectVariantFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        GVariant *arg_line_config,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectVariantFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectVariantFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_variant (param_values + 2),
              data2);

  g_value_set_boolean (return_value, v_return);
}

/* ------------------------------------------------------------------------
 * Code for interface io.gpiod1.Chip
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:GpiodbusChip
 * @title: GpiodbusChip
 * @short_description: Generated C code for the io.gpiod1.Chip D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-io-gpiod1-Chip.top_of_page">io.gpiod1.Chip</link> D-Bus interface in C.
 */

/* ---- Introspection data for io.gpiod1.Chip ---- */

static const _ExtendedGDBusArgInfo _gpiodbus_chip_method_info_request_lines_IN_ARG_line_config =
{
  {
    -1,
    (gchar *) "line_config",
    (gchar *) "(a(aua{sv})ai)",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _gpiodbus_chip_method_info_request_lines_IN_ARG_request_config =
{
  {
    -1,
    (gchar *) "request_config",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gpiodbus_chip_method_info_request_lines_IN_ARG_pointers[] =
{
  &_gpiodbus_chip_method_info_request_lines_IN_ARG_line_config.parent_struct,
  &_gpiodbus_chip_method_info_request_lines_IN_ARG_request_config.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _gpiodbus_chip_method_info_request_lines_OUT_ARG_request_path =
{
  {
    -1,
    (gchar *) "request_path",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gpiodbus_chip_method_info_request_lines_OUT_ARG_pointers[] =
{
  &_gpiodbus_chip_method_info_request_lines_OUT_ARG_request_path.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _gpiodbus_chip_method_info_request_lines =
{
  {
    -1,
    (gchar *) "RequestLines",
    (GDBusArgInfo **) &_gpiodbus_chip_method_info_request_lines_IN_ARG_pointers,
    (GDBusArgInfo **) &_gpiodbus_chip_method_info_request_lines_OUT_ARG_pointers,
    NULL
  },
  "handle-request-lines",
  FALSE
};

static const GDBusMethodInfo * const _gpiodbus_chip_method_info_pointers[] =
{
  &_gpiodbus_chip_method_info_request_lines.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _gpiodbus_chip_property_info_name =
{
  {
    -1,
    (gchar *) "Name",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "name",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _gpiodbus_chip_property_info_label =
{
  {
    -1,
    (gchar *) "Label",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "label",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _gpiodbus_chip_property_info_num_lines =
{
  {
    -1,
    (gchar *) "NumLines",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "num-lines",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _gpiodbus_chip_property_info_path =
{
  {
    -1,
    (gchar *) "Path",
    (gchar *) "ay",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "path",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _gpiodbus_chip_property_info_pointers[] =
{
  &_gpiodbus_chip_property_info_name.parent_struct,
  &_gpiodbus_chip_property_info_label.parent_struct,
  &_gpiodbus_chip_property_info_num_lines.parent_struct,
  &_gpiodbus_chip_property_info_path.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _gpiodbus_chip_interface_info =
{
  {
    -1,
    (gchar *) "io.gpiod1.Chip",
    (GDBusMethodInfo **) &_gpiodbus_chip_method_info_pointers,
    NULL,
    (GDBusPropertyInfo **) &_gpiodbus_chip_property_info_pointers,
    NULL
  },
  "chip",
};


/**
 * gpiodbus_chip_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-io-gpiod1-Chip.top_of_page">io.gpiod1.Chip</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
gpiodbus_chip_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_gpiodbus_chip_interface_info.parent_struct;
}

/**
 * gpiodbus_chip_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #GpiodbusChip interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
gpiodbus_chip_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "name");
  g_object_class_override_property (klass, property_id_begin++, "label");
  g_object_class_override_property (klass, property_id_begin++, "num-lines");
  g_object_class_override_property (klass, property_id_begin++, "path");
  return property_id_begin - 1;
}


inline static void
gpiodbus_chip_method_marshal_request_lines (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_VARIANT_VARIANT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * GpiodbusChip:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-io-gpiod1-Chip.top_of_page">io.gpiod1.Chip</link>.
 */

/**
 * GpiodbusChipIface:
 * @parent_iface: The parent interface.
 * @handle_request_lines: Handler for the #GpiodbusChip::handle-request-lines signal.
 * @get_label: Getter for the #GpiodbusChip:label property.
 * @get_name: Getter for the #GpiodbusChip:name property.
 * @get_num_lines: Getter for the #GpiodbusChip:num-lines property.
 * @get_path: Getter for the #GpiodbusChip:path property.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-io-gpiod1-Chip.top_of_page">io.gpiod1.Chip</link>.
 */

typedef GpiodbusChipIface GpiodbusChipInterface;
G_DEFINE_INTERFACE (GpiodbusChip, gpiodbus_chip, G_TYPE_OBJECT)

static void
gpiodbus_chip_default_init (GpiodbusChipIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * GpiodbusChip::handle-request-lines:
   * @object: A #GpiodbusChip.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_line_config: Argument passed by remote caller.
   * @arg_request_config: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-io-gpiod1-Chip.RequestLines">RequestLines()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gpiodbus_chip_complete_request_lines() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-request-lines",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GpiodbusChipIface, handle_request_lines),
    g_signal_accumulator_true_handled,
    NULL,
      gpiodbus_chip_method_marshal_request_lines,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_VARIANT, G_TYPE_VARIANT);

  /* GObject properties for D-Bus properties: */
  /**
   * GpiodbusChip:name:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-io-gpiod1-Chip.Name">"Name"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("name", "Name", "Name", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * GpiodbusChip:label:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-io-gpiod1-Chip.Label">"Label"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("label", "Label", "Label", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * GpiodbusChip:num-lines:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-io-gpiod1-Chip.NumLines">"NumLines"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("num-lines", "NumLines", "NumLines", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * GpiodbusChip:path:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-io-gpiod1-Chip.Path">"Path"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("path", "Path", "Path", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * gpiodbus_chip_get_name: (skip)
 * @object: A #GpiodbusChip.
 *
 * Gets the value of the <link linkend="gdbus-property-io-gpiod1-Chip.Name">"Name"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use gpiodbus_chip_dup_name() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
gpiodbus_chip_get_name (GpiodbusChip *object)
{
  g_return_val_if_fail (GPIODBUS_IS_CHIP (object), NULL);

  return GPIODBUS_CHIP_GET_IFACE (object)->get_name (object);
}

/**
 * gpiodbus_chip_dup_name: (skip)
 * @object: A #GpiodbusChip.
 *
 * Gets a copy of the <link linkend="gdbus-property-io-gpiod1-Chip.Name">"Name"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
gpiodbus_chip_dup_name (GpiodbusChip *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "name", &value, NULL);
  return value;
}

/**
 * gpiodbus_chip_set_name: (skip)
 * @object: A #GpiodbusChip.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-io-gpiod1-Chip.Name">"Name"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
gpiodbus_chip_set_name (GpiodbusChip *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "name", value, NULL);
}

/**
 * gpiodbus_chip_get_label: (skip)
 * @object: A #GpiodbusChip.
 *
 * Gets the value of the <link linkend="gdbus-property-io-gpiod1-Chip.Label">"Label"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use gpiodbus_chip_dup_label() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
gpiodbus_chip_get_label (GpiodbusChip *object)
{
  g_return_val_if_fail (GPIODBUS_IS_CHIP (object), NULL);

  return GPIODBUS_CHIP_GET_IFACE (object)->get_label (object);
}

/**
 * gpiodbus_chip_dup_label: (skip)
 * @object: A #GpiodbusChip.
 *
 * Gets a copy of the <link linkend="gdbus-property-io-gpiod1-Chip.Label">"Label"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
gpiodbus_chip_dup_label (GpiodbusChip *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "label", &value, NULL);
  return value;
}

/**
 * gpiodbus_chip_set_label: (skip)
 * @object: A #GpiodbusChip.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-io-gpiod1-Chip.Label">"Label"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
gpiodbus_chip_set_label (GpiodbusChip *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "label", value, NULL);
}

/**
 * gpiodbus_chip_get_num_lines: (skip)
 * @object: A #GpiodbusChip.
 *
 * Gets the value of the <link linkend="gdbus-property-io-gpiod1-Chip.NumLines">"NumLines"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
gpiodbus_chip_get_num_lines (GpiodbusChip *object)
{
  g_return_val_if_fail (GPIODBUS_IS_CHIP (object), 0);

  return GPIODBUS_CHIP_GET_IFACE (object)->get_num_lines (object);
}

/**
 * gpiodbus_chip_set_num_lines: (skip)
 * @object: A #GpiodbusChip.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-io-gpiod1-Chip.NumLines">"NumLines"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
gpiodbus_chip_set_num_lines (GpiodbusChip *object, guint value)
{
  g_object_set (G_OBJECT (object), "num-lines", value, NULL);
}

/**
 * gpiodbus_chip_get_path: (skip)
 * @object: A #GpiodbusChip.
 *
 * Gets the value of the <link linkend="gdbus-property-io-gpiod1-Chip.Path">"Path"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use gpiodbus_chip_dup_path() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
gpiodbus_chip_get_path (GpiodbusChip *object)
{
  g_return_val_if_fail (GPIODBUS_IS_CHIP (object), NULL);

  return GPIODBUS_CHIP_GET_IFACE (object)->get_path (object);
}

/**
 * gpiodbus_chip_dup_path: (skip)
 * @object: A #GpiodbusChip.
 *
 * Gets a copy of the <link linkend="gdbus-property-io-gpiod1-Chip.Path">"Path"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
gpiodbus_chip_dup_path (GpiodbusChip *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "path", &value, NULL);
  return value;
}

/**
 * gpiodbus_chip_set_path: (skip)
 * @object: A #GpiodbusChip.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-io-gpiod1-Chip.Path">"Path"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
gpiodbus_chip_set_path (GpiodbusChip *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "path", value, NULL);
}

/**
 * gpiodbus_chip_call_request_lines:
 * @proxy: A #GpiodbusChipProxy.
 * @arg_line_config: Argument to pass with the method invocation.
 * @arg_request_config: Argument to pass with the method invocation.
 * @call_flags: Flags from the #GDBusCallFlags enumeration. If you want to allow interactive
       authorization be sure to set %G_DBUS_CALL_FLAGS_ALLOW_INTERACTIVE_AUTHORIZATION.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning "infinite") or
       -1 to use the proxy default timeout.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-io-gpiod1-Chip.RequestLines">RequestLines()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gpiodbus_chip_call_request_lines_finish() to get the result of the operation.
 *
 * See gpiodbus_chip_call_request_lines_sync() for the synchronous, blocking version of this method.
 */
void
gpiodbus_chip_call_request_lines (
    GpiodbusChip *proxy,
    GVariant *arg_line_config,
    GVariant *arg_request_config,
    GDBusCallFlags call_flags,
    gint timeout_msec,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "RequestLines",
    g_variant_new ("(@(a(aua{sv})ai)@a{sv})",
                   arg_line_config,
                   arg_request_config),
    call_flags,
    timeout_msec,
    cancellable,
    callback,
    user_data);
}

/**
 * gpiodbus_chip_call_request_lines_finish:
 * @proxy: A #GpiodbusChipProxy.
 * @out_request_path: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gpiodbus_chip_call_request_lines().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gpiodbus_chip_call_request_lines().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gpiodbus_chip_call_request_lines_finish (
    GpiodbusChip *proxy,
    gchar **out_request_path,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_request_path);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gpiodbus_chip_call_request_lines_sync:
 * @proxy: A #GpiodbusChipProxy.
 * @arg_line_config: Argument to pass with the method invocation.
 * @arg_request_config: Argument to pass with the method invocation.
 * @call_flags: Flags from the #GDBusCallFlags enumeration. If you want to allow interactive
       authorization be sure to set %G_DBUS_CALL_FLAGS_ALLOW_INTERACTIVE_AUTHORIZATION.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning "infinite") or
       -1 to use the proxy default timeout.
 * @out_request_path: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-io-gpiod1-Chip.RequestLines">RequestLines()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gpiodbus_chip_call_request_lines() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gpiodbus_chip_call_request_lines_sync (
    GpiodbusChip *proxy,
    GVariant *arg_line_config,
    GVariant *arg_request_config,
    GDBusCallFlags call_flags,
    gint timeout_msec,
    gchar **out_request_path,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "RequestLines",
    g_variant_new ("(@(a(aua{sv})ai)@a{sv})",
                   arg_line_config,
                   arg_request_config),
    call_flags,
    timeout_msec,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_request_path);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gpiodbus_chip_complete_request_lines:
 * @object: A #GpiodbusChip.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @request_path: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-io-gpiod1-Chip.RequestLines">RequestLines()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gpiodbus_chip_complete_request_lines (
    GpiodbusChip *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *request_path)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(o)",
                   request_path));
}

/* ------------------------------------------------------------------------ */

/**
 * GpiodbusChipProxy:
 *
 * The #GpiodbusChipProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * GpiodbusChipProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #GpiodbusChipProxy.
 */

struct _GpiodbusChipProxyPrivate
{
  GData *qdata;
};

static void gpiodbus_chip_proxy_iface_init (GpiodbusChipIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (GpiodbusChipProxy, gpiodbus_chip_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (GpiodbusChipProxy)
                         G_IMPLEMENT_INTERFACE (GPIODBUS_TYPE_CHIP, gpiodbus_chip_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (GpiodbusChipProxy, gpiodbus_chip_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (GPIODBUS_TYPE_CHIP, gpiodbus_chip_proxy_iface_init))

#endif
static void
gpiodbus_chip_proxy_finalize (GObject *object)
{
  GpiodbusChipProxy *proxy = GPIODBUS_CHIP_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (gpiodbus_chip_proxy_parent_class)->finalize (object);
}

static void
gpiodbus_chip_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 4);
  info = (const _ExtendedGDBusPropertyInfo *) _gpiodbus_chip_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
gpiodbus_chip_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface io.gpiod1.Chip: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
gpiodbus_chip_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 4);
  info = (const _ExtendedGDBusPropertyInfo *) _gpiodbus_chip_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "io.gpiod1.Chip", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) gpiodbus_chip_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
gpiodbus_chip_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_gpiodbus_chip_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], GPIODBUS_TYPE_CHIP);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, GPIODBUS_TYPE_CHIP);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
gpiodbus_chip_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  GpiodbusChipProxy *proxy = GPIODBUS_CHIP_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gpiodbus_chip_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gpiodbus_chip_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static const gchar *
gpiodbus_chip_proxy_get_name (GpiodbusChip *object)
{
  GpiodbusChipProxy *proxy = GPIODBUS_CHIP_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Name");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
gpiodbus_chip_proxy_get_label (GpiodbusChip *object)
{
  GpiodbusChipProxy *proxy = GPIODBUS_CHIP_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Label");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static guint 
gpiodbus_chip_proxy_get_num_lines (GpiodbusChip *object)
{
  GpiodbusChipProxy *proxy = GPIODBUS_CHIP_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "NumLines");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
gpiodbus_chip_proxy_get_path (GpiodbusChip *object)
{
  GpiodbusChipProxy *proxy = GPIODBUS_CHIP_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Path");
  if (variant != NULL)
    {
      value = g_variant_get_bytestring (variant);
      g_variant_unref (variant);
    }
  return value;
}

static void
gpiodbus_chip_proxy_init (GpiodbusChipProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = gpiodbus_chip_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, GPIODBUS_TYPE_CHIP_PROXY, GpiodbusChipProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), gpiodbus_chip_interface_info ());
}

static void
gpiodbus_chip_proxy_class_init (GpiodbusChipProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = gpiodbus_chip_proxy_finalize;
  gobject_class->get_property = gpiodbus_chip_proxy_get_property;
  gobject_class->set_property = gpiodbus_chip_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = gpiodbus_chip_proxy_g_signal;
  proxy_class->g_properties_changed = gpiodbus_chip_proxy_g_properties_changed;

  gpiodbus_chip_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (GpiodbusChipProxyPrivate));
#endif
}

static void
gpiodbus_chip_proxy_iface_init (GpiodbusChipIface *iface)
{
  iface->get_name = gpiodbus_chip_proxy_get_name;
  iface->get_label = gpiodbus_chip_proxy_get_label;
  iface->get_num_lines = gpiodbus_chip_proxy_get_num_lines;
  iface->get_path = gpiodbus_chip_proxy_get_path;
}

/**
 * gpiodbus_chip_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-io-gpiod1-Chip.top_of_page">io.gpiod1.Chip</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gpiodbus_chip_proxy_new_finish() to get the result of the operation.
 *
 * See gpiodbus_chip_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
gpiodbus_chip_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (GPIODBUS_TYPE_CHIP_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "io.gpiod1.Chip", NULL);
}

/**
 * gpiodbus_chip_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gpiodbus_chip_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with gpiodbus_chip_proxy_new().
 *
 * Returns: (transfer full) (type GpiodbusChipProxy): The constructed proxy object or %NULL if @error is set.
 */
GpiodbusChip *
gpiodbus_chip_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return GPIODBUS_CHIP (ret);
  else
    return NULL;
}

/**
 * gpiodbus_chip_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-io-gpiod1-Chip.top_of_page">io.gpiod1.Chip</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See gpiodbus_chip_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type GpiodbusChipProxy): The constructed proxy object or %NULL if @error is set.
 */
GpiodbusChip *
gpiodbus_chip_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (GPIODBUS_TYPE_CHIP_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "io.gpiod1.Chip", NULL);
  if (ret != NULL)
    return GPIODBUS_CHIP (ret);
  else
    return NULL;
}


/**
 * gpiodbus_chip_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like gpiodbus_chip_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gpiodbus_chip_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See gpiodbus_chip_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
gpiodbus_chip_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (GPIODBUS_TYPE_CHIP_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "io.gpiod1.Chip", NULL);
}

/**
 * gpiodbus_chip_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gpiodbus_chip_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with gpiodbus_chip_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type GpiodbusChipProxy): The constructed proxy object or %NULL if @error is set.
 */
GpiodbusChip *
gpiodbus_chip_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return GPIODBUS_CHIP (ret);
  else
    return NULL;
}

/**
 * gpiodbus_chip_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like gpiodbus_chip_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See gpiodbus_chip_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type GpiodbusChipProxy): The constructed proxy object or %NULL if @error is set.
 */
GpiodbusChip *
gpiodbus_chip_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (GPIODBUS_TYPE_CHIP_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "io.gpiod1.Chip", NULL);
  if (ret != NULL)
    return GPIODBUS_CHIP (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * GpiodbusChipSkeleton:
 *
 * The #GpiodbusChipSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * GpiodbusChipSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #GpiodbusChipSkeleton.
 */

struct _GpiodbusChipSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_gpiodbus_chip_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  GpiodbusChipSkeleton *skeleton = GPIODBUS_CHIP_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], GPIODBUS_TYPE_CHIP);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, GPIODBUS_TYPE_CHIP);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_gpiodbus_chip_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  GpiodbusChipSkeleton *skeleton = GPIODBUS_CHIP_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gpiodbus_chip_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_gpiodbus_chip_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  GpiodbusChipSkeleton *skeleton = GPIODBUS_CHIP_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gpiodbus_chip_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _gpiodbus_chip_skeleton_vtable =
{
  _gpiodbus_chip_skeleton_handle_method_call,
  _gpiodbus_chip_skeleton_handle_get_property,
  _gpiodbus_chip_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
gpiodbus_chip_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return gpiodbus_chip_interface_info ();
}

static GDBusInterfaceVTable *
gpiodbus_chip_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_gpiodbus_chip_skeleton_vtable;
}

static GVariant *
gpiodbus_chip_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  GpiodbusChipSkeleton *skeleton = GPIODBUS_CHIP_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_gpiodbus_chip_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _gpiodbus_chip_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _gpiodbus_chip_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _gpiodbus_chip_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "io.gpiod1.Chip", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _gpiodbus_chip_emit_changed (gpointer user_data);

static void
gpiodbus_chip_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  GpiodbusChipSkeleton *skeleton = GPIODBUS_CHIP_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _gpiodbus_chip_emit_changed (skeleton);
}

static void gpiodbus_chip_skeleton_iface_init (GpiodbusChipIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (GpiodbusChipSkeleton, gpiodbus_chip_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (GpiodbusChipSkeleton)
                         G_IMPLEMENT_INTERFACE (GPIODBUS_TYPE_CHIP, gpiodbus_chip_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (GpiodbusChipSkeleton, gpiodbus_chip_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (GPIODBUS_TYPE_CHIP, gpiodbus_chip_skeleton_iface_init))

#endif
static void
gpiodbus_chip_skeleton_finalize (GObject *object)
{
  GpiodbusChipSkeleton *skeleton = GPIODBUS_CHIP_SKELETON (object);
  guint n;
  for (n = 0; n < 4; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (gpiodbus_chip_skeleton_parent_class)->finalize (object);
}

static void
gpiodbus_chip_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  GpiodbusChipSkeleton *skeleton = GPIODBUS_CHIP_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 4);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_gpiodbus_chip_emit_changed (gpointer user_data)
{
  GpiodbusChipSkeleton *skeleton = GPIODBUS_CHIP_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init_static (&invalidated_builder, G_VARIANT_TYPE ("as"));
#else
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
#endif
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "io.gpiod1.Chip",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_gpiodbus_chip_schedule_emit_changed (GpiodbusChipSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
gpiodbus_chip_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  GpiodbusChipSkeleton *skeleton = GPIODBUS_CHIP_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _gpiodbus_chip_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _gpiodbus_chip_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
gpiodbus_chip_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  GpiodbusChipSkeleton *skeleton = GPIODBUS_CHIP_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 4);
  info = (const _ExtendedGDBusPropertyInfo *) _gpiodbus_chip_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _gpiodbus_chip_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
gpiodbus_chip_skeleton_init (GpiodbusChipSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = gpiodbus_chip_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, GPIODBUS_TYPE_CHIP_SKELETON, GpiodbusChipSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 4);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[2], G_TYPE_UINT);
  g_value_init (&skeleton->priv->properties[3], G_TYPE_STRING);
}

static const gchar *
gpiodbus_chip_skeleton_get_name (GpiodbusChip *object)
{
  GpiodbusChipSkeleton *skeleton = GPIODBUS_CHIP_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
gpiodbus_chip_skeleton_get_label (GpiodbusChip *object)
{
  GpiodbusChipSkeleton *skeleton = GPIODBUS_CHIP_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint 
gpiodbus_chip_skeleton_get_num_lines (GpiodbusChip *object)
{
  GpiodbusChipSkeleton *skeleton = GPIODBUS_CHIP_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_uint (&(skeleton->priv->properties[2]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
gpiodbus_chip_skeleton_get_path (GpiodbusChip *object)
{
  GpiodbusChipSkeleton *skeleton = GPIODBUS_CHIP_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[3]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
gpiodbus_chip_skeleton_class_init (GpiodbusChipSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = gpiodbus_chip_skeleton_finalize;
  gobject_class->get_property = gpiodbus_chip_skeleton_get_property;
  gobject_class->set_property = gpiodbus_chip_skeleton_set_property;
  gobject_class->notify       = gpiodbus_chip_skeleton_notify;


  gpiodbus_chip_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = gpiodbus_chip_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = gpiodbus_chip_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = gpiodbus_chip_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = gpiodbus_chip_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (GpiodbusChipSkeletonPrivate));
#endif
}

static void
gpiodbus_chip_skeleton_iface_init (GpiodbusChipIface *iface)
{
  iface->get_name = gpiodbus_chip_skeleton_get_name;
  iface->get_label = gpiodbus_chip_skeleton_get_label;
  iface->get_num_lines = gpiodbus_chip_skeleton_get_num_lines;
  iface->get_path = gpiodbus_chip_skeleton_get_path;
}

/**
 * gpiodbus_chip_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-io-gpiod1-Chip.top_of_page">io.gpiod1.Chip</link>.
 *
 * Returns: (transfer full) (type GpiodbusChipSkeleton): The skeleton object.
 */
GpiodbusChip *
gpiodbus_chip_skeleton_new (void)
{
  return GPIODBUS_CHIP (g_object_new (GPIODBUS_TYPE_CHIP_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface io.gpiod1.Line
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:GpiodbusLine
 * @title: GpiodbusLine
 * @short_description: Generated C code for the io.gpiod1.Line D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-io-gpiod1-Line.top_of_page">io.gpiod1.Line</link> D-Bus interface in C.
 */

enum
{
  GPIODBUS__LINE_EDGE_EVENT,
};

static unsigned GPIODBUS__LINE_SIGNALS[1] = { 0 };

/* ---- Introspection data for io.gpiod1.Line ---- */

static const _ExtendedGDBusArgInfo _gpiodbus_line_signal_info_edge_event_ARG_event_data =
{
  {
    -1,
    (gchar *) "event_data",
    (gchar *) "(ittt)",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gpiodbus_line_signal_info_edge_event_ARG_pointers[] =
{
  &_gpiodbus_line_signal_info_edge_event_ARG_event_data.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _gpiodbus_line_signal_info_edge_event =
{
  {
    -1,
    (gchar *) "EdgeEvent",
    (GDBusArgInfo **) &_gpiodbus_line_signal_info_edge_event_ARG_pointers,
    NULL
  },
  "edge-event"
};

static const GDBusSignalInfo * const _gpiodbus_line_signal_info_pointers[] =
{
  &_gpiodbus_line_signal_info_edge_event.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _gpiodbus_line_property_info_offset =
{
  {
    -1,
    (gchar *) "Offset",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "offset",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _gpiodbus_line_property_info_name =
{
  {
    -1,
    (gchar *) "Name",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "name",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _gpiodbus_line_property_info_used =
{
  {
    -1,
    (gchar *) "Used",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "used",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _gpiodbus_line_property_info_consumer =
{
  {
    -1,
    (gchar *) "Consumer",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "consumer",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _gpiodbus_line_property_info_direction =
{
  {
    -1,
    (gchar *) "Direction",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "direction",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _gpiodbus_line_property_info_edge_detection =
{
  {
    -1,
    (gchar *) "EdgeDetection",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "edge-detection",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _gpiodbus_line_property_info_bias =
{
  {
    -1,
    (gchar *) "Bias",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "bias",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _gpiodbus_line_property_info_drive =
{
  {
    -1,
    (gchar *) "Drive",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "drive",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _gpiodbus_line_property_info_active_low =
{
  {
    -1,
    (gchar *) "ActiveLow",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "active-low",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _gpiodbus_line_property_info_debounced =
{
  {
    -1,
    (gchar *) "Debounced",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "debounced",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _gpiodbus_line_property_info_debounce_period_us =
{
  {
    -1,
    (gchar *) "DebouncePeriodUs",
    (gchar *) "t",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "debounce-period-us",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _gpiodbus_line_property_info_event_clock =
{
  {
    -1,
    (gchar *) "EventClock",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "event-clock",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _gpiodbus_line_property_info_managed =
{
  {
    -1,
    (gchar *) "Managed",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "managed",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _gpiodbus_line_property_info_request_path =
{
  {
    -1,
    (gchar *) "RequestPath",
    (gchar *) "o",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "request-path",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _gpiodbus_line_property_info_pointers[] =
{
  &_gpiodbus_line_property_info_offset.parent_struct,
  &_gpiodbus_line_property_info_name.parent_struct,
  &_gpiodbus_line_property_info_used.parent_struct,
  &_gpiodbus_line_property_info_consumer.parent_struct,
  &_gpiodbus_line_property_info_direction.parent_struct,
  &_gpiodbus_line_property_info_edge_detection.parent_struct,
  &_gpiodbus_line_property_info_bias.parent_struct,
  &_gpiodbus_line_property_info_drive.parent_struct,
  &_gpiodbus_line_property_info_active_low.parent_struct,
  &_gpiodbus_line_property_info_debounced.parent_struct,
  &_gpiodbus_line_property_info_debounce_period_us.parent_struct,
  &_gpiodbus_line_property_info_event_clock.parent_struct,
  &_gpiodbus_line_property_info_managed.parent_struct,
  &_gpiodbus_line_property_info_request_path.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _gpiodbus_line_interface_info =
{
  {
    -1,
    (gchar *) "io.gpiod1.Line",
    NULL,
    (GDBusSignalInfo **) &_gpiodbus_line_signal_info_pointers,
    (GDBusPropertyInfo **) &_gpiodbus_line_property_info_pointers,
    NULL
  },
  "line",
};


/**
 * gpiodbus_line_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-io-gpiod1-Line.top_of_page">io.gpiod1.Line</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
gpiodbus_line_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_gpiodbus_line_interface_info.parent_struct;
}

/**
 * gpiodbus_line_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #GpiodbusLine interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
gpiodbus_line_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "offset");
  g_object_class_override_property (klass, property_id_begin++, "name");
  g_object_class_override_property (klass, property_id_begin++, "used");
  g_object_class_override_property (klass, property_id_begin++, "consumer");
  g_object_class_override_property (klass, property_id_begin++, "direction");
  g_object_class_override_property (klass, property_id_begin++, "edge-detection");
  g_object_class_override_property (klass, property_id_begin++, "bias");
  g_object_class_override_property (klass, property_id_begin++, "drive");
  g_object_class_override_property (klass, property_id_begin++, "active-low");
  g_object_class_override_property (klass, property_id_begin++, "debounced");
  g_object_class_override_property (klass, property_id_begin++, "debounce-period-us");
  g_object_class_override_property (klass, property_id_begin++, "event-clock");
  g_object_class_override_property (klass, property_id_begin++, "managed");
  g_object_class_override_property (klass, property_id_begin++, "request-path");
  return property_id_begin - 1;
}


inline static void
gpiodbus_line_signal_marshal_edge_event (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__VARIANT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * GpiodbusLine:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-io-gpiod1-Line.top_of_page">io.gpiod1.Line</link>.
 */

/**
 * GpiodbusLineIface:
 * @parent_iface: The parent interface.
 * @get_active_low: Getter for the #GpiodbusLine:active-low property.
 * @get_bias: Getter for the #GpiodbusLine:bias property.
 * @get_consumer: Getter for the #GpiodbusLine:consumer property.
 * @get_debounce_period_us: Getter for the #GpiodbusLine:debounce-period-us property.
 * @get_debounced: Getter for the #GpiodbusLine:debounced property.
 * @get_direction: Getter for the #GpiodbusLine:direction property.
 * @get_drive: Getter for the #GpiodbusLine:drive property.
 * @get_edge_detection: Getter for the #GpiodbusLine:edge-detection property.
 * @get_event_clock: Getter for the #GpiodbusLine:event-clock property.
 * @get_managed: Getter for the #GpiodbusLine:managed property.
 * @get_name: Getter for the #GpiodbusLine:name property.
 * @get_offset: Getter for the #GpiodbusLine:offset property.
 * @get_request_path: Getter for the #GpiodbusLine:request-path property.
 * @get_used: Getter for the #GpiodbusLine:used property.
 * @edge_event: Handler for the #GpiodbusLine::edge-event signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-io-gpiod1-Line.top_of_page">io.gpiod1.Line</link>.
 */

typedef GpiodbusLineIface GpiodbusLineInterface;
G_DEFINE_INTERFACE (GpiodbusLine, gpiodbus_line, G_TYPE_OBJECT)

static void
gpiodbus_line_default_init (GpiodbusLineIface *iface)
{
  /* GObject signals for received D-Bus signals: */
  /**
   * GpiodbusLine::edge-event:
   * @object: A #GpiodbusLine.
   * @arg_event_data: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-io-gpiod1-Line.EdgeEvent">"EdgeEvent"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  GPIODBUS__LINE_SIGNALS[GPIODBUS__LINE_EDGE_EVENT] =
    g_signal_new ("edge-event",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (GpiodbusLineIface, edge_event),
      NULL,
      NULL,
      gpiodbus_line_signal_marshal_edge_event,
      G_TYPE_NONE,
      1, G_TYPE_VARIANT);

  /* GObject properties for D-Bus properties: */
  /**
   * GpiodbusLine:offset:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-io-gpiod1-Line.Offset">"Offset"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("offset", "Offset", "Offset", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * GpiodbusLine:name:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-io-gpiod1-Line.Name">"Name"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("name", "Name", "Name", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * GpiodbusLine:used:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-io-gpiod1-Line.Used">"Used"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("used", "Used", "Used", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * GpiodbusLine:consumer:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-io-gpiod1-Line.Consumer">"Consumer"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("consumer", "Consumer", "Consumer", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * GpiodbusLine:direction:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-io-gpiod1-Line.Direction">"Direction"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("direction", "Direction", "Direction", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * GpiodbusLine:edge-detection:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-io-gpiod1-Line.EdgeDetection">"EdgeDetection"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("edge-detection", "EdgeDetection", "EdgeDetection", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * GpiodbusLine:bias:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-io-gpiod1-Line.Bias">"Bias"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("bias", "Bias", "Bias", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * GpiodbusLine:drive:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-io-gpiod1-Line.Drive">"Drive"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("drive", "Drive", "Drive", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * GpiodbusLine:active-low:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-io-gpiod1-Line.ActiveLow">"ActiveLow"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("active-low", "ActiveLow", "ActiveLow", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * GpiodbusLine:debounced:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-io-gpiod1-Line.Debounced">"Debounced"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("debounced", "Debounced", "Debounced", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * GpiodbusLine:debounce-period-us:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-io-gpiod1-Line.DebouncePeriodUs">"DebouncePeriodUs"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint64 ("debounce-period-us", "DebouncePeriodUs", "DebouncePeriodUs", 0, G_MAXUINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * GpiodbusLine:event-clock:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-io-gpiod1-Line.EventClock">"EventClock"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("event-clock", "EventClock", "EventClock", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * GpiodbusLine:managed:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-io-gpiod1-Line.Managed">"Managed"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("managed", "Managed", "Managed", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * GpiodbusLine:request-path:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-io-gpiod1-Line.RequestPath">"RequestPath"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("request-path", "RequestPath", "RequestPath", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * gpiodbus_line_get_offset: (skip)
 * @object: A #GpiodbusLine.
 *
 * Gets the value of the <link linkend="gdbus-property-io-gpiod1-Line.Offset">"Offset"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
gpiodbus_line_get_offset (GpiodbusLine *object)
{
  g_return_val_if_fail (GPIODBUS_IS_LINE (object), 0);

  return GPIODBUS_LINE_GET_IFACE (object)->get_offset (object);
}

/**
 * gpiodbus_line_set_offset: (skip)
 * @object: A #GpiodbusLine.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-io-gpiod1-Line.Offset">"Offset"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
gpiodbus_line_set_offset (GpiodbusLine *object, guint value)
{
  g_object_set (G_OBJECT (object), "offset", value, NULL);
}

/**
 * gpiodbus_line_get_name: (skip)
 * @object: A #GpiodbusLine.
 *
 * Gets the value of the <link linkend="gdbus-property-io-gpiod1-Line.Name">"Name"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use gpiodbus_line_dup_name() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
gpiodbus_line_get_name (GpiodbusLine *object)
{
  g_return_val_if_fail (GPIODBUS_IS_LINE (object), NULL);

  return GPIODBUS_LINE_GET_IFACE (object)->get_name (object);
}

/**
 * gpiodbus_line_dup_name: (skip)
 * @object: A #GpiodbusLine.
 *
 * Gets a copy of the <link linkend="gdbus-property-io-gpiod1-Line.Name">"Name"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
gpiodbus_line_dup_name (GpiodbusLine *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "name", &value, NULL);
  return value;
}

/**
 * gpiodbus_line_set_name: (skip)
 * @object: A #GpiodbusLine.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-io-gpiod1-Line.Name">"Name"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
gpiodbus_line_set_name (GpiodbusLine *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "name", value, NULL);
}

/**
 * gpiodbus_line_get_used: (skip)
 * @object: A #GpiodbusLine.
 *
 * Gets the value of the <link linkend="gdbus-property-io-gpiod1-Line.Used">"Used"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
gpiodbus_line_get_used (GpiodbusLine *object)
{
  g_return_val_if_fail (GPIODBUS_IS_LINE (object), FALSE);

  return GPIODBUS_LINE_GET_IFACE (object)->get_used (object);
}

/**
 * gpiodbus_line_set_used: (skip)
 * @object: A #GpiodbusLine.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-io-gpiod1-Line.Used">"Used"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
gpiodbus_line_set_used (GpiodbusLine *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "used", value, NULL);
}

/**
 * gpiodbus_line_get_consumer: (skip)
 * @object: A #GpiodbusLine.
 *
 * Gets the value of the <link linkend="gdbus-property-io-gpiod1-Line.Consumer">"Consumer"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use gpiodbus_line_dup_consumer() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
gpiodbus_line_get_consumer (GpiodbusLine *object)
{
  g_return_val_if_fail (GPIODBUS_IS_LINE (object), NULL);

  return GPIODBUS_LINE_GET_IFACE (object)->get_consumer (object);
}

/**
 * gpiodbus_line_dup_consumer: (skip)
 * @object: A #GpiodbusLine.
 *
 * Gets a copy of the <link linkend="gdbus-property-io-gpiod1-Line.Consumer">"Consumer"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
gpiodbus_line_dup_consumer (GpiodbusLine *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "consumer", &value, NULL);
  return value;
}

/**
 * gpiodbus_line_set_consumer: (skip)
 * @object: A #GpiodbusLine.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-io-gpiod1-Line.Consumer">"Consumer"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
gpiodbus_line_set_consumer (GpiodbusLine *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "consumer", value, NULL);
}

/**
 * gpiodbus_line_get_direction: (skip)
 * @object: A #GpiodbusLine.
 *
 * Gets the value of the <link linkend="gdbus-property-io-gpiod1-Line.Direction">"Direction"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use gpiodbus_line_dup_direction() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
gpiodbus_line_get_direction (GpiodbusLine *object)
{
  g_return_val_if_fail (GPIODBUS_IS_LINE (object), NULL);

  return GPIODBUS_LINE_GET_IFACE (object)->get_direction (object);
}

/**
 * gpiodbus_line_dup_direction: (skip)
 * @object: A #GpiodbusLine.
 *
 * Gets a copy of the <link linkend="gdbus-property-io-gpiod1-Line.Direction">"Direction"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
gpiodbus_line_dup_direction (GpiodbusLine *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "direction", &value, NULL);
  return value;
}

/**
 * gpiodbus_line_set_direction: (skip)
 * @object: A #GpiodbusLine.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-io-gpiod1-Line.Direction">"Direction"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
gpiodbus_line_set_direction (GpiodbusLine *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "direction", value, NULL);
}

/**
 * gpiodbus_line_get_edge_detection: (skip)
 * @object: A #GpiodbusLine.
 *
 * Gets the value of the <link linkend="gdbus-property-io-gpiod1-Line.EdgeDetection">"EdgeDetection"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use gpiodbus_line_dup_edge_detection() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
gpiodbus_line_get_edge_detection (GpiodbusLine *object)
{
  g_return_val_if_fail (GPIODBUS_IS_LINE (object), NULL);

  return GPIODBUS_LINE_GET_IFACE (object)->get_edge_detection (object);
}

/**
 * gpiodbus_line_dup_edge_detection: (skip)
 * @object: A #GpiodbusLine.
 *
 * Gets a copy of the <link linkend="gdbus-property-io-gpiod1-Line.EdgeDetection">"EdgeDetection"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
gpiodbus_line_dup_edge_detection (GpiodbusLine *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "edge-detection", &value, NULL);
  return value;
}

/**
 * gpiodbus_line_set_edge_detection: (skip)
 * @object: A #GpiodbusLine.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-io-gpiod1-Line.EdgeDetection">"EdgeDetection"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
gpiodbus_line_set_edge_detection (GpiodbusLine *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "edge-detection", value, NULL);
}

/**
 * gpiodbus_line_get_bias: (skip)
 * @object: A #GpiodbusLine.
 *
 * Gets the value of the <link linkend="gdbus-property-io-gpiod1-Line.Bias">"Bias"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use gpiodbus_line_dup_bias() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
gpiodbus_line_get_bias (GpiodbusLine *object)
{
  g_return_val_if_fail (GPIODBUS_IS_LINE (object), NULL);

  return GPIODBUS_LINE_GET_IFACE (object)->get_bias (object);
}

/**
 * gpiodbus_line_dup_bias: (skip)
 * @object: A #GpiodbusLine.
 *
 * Gets a copy of the <link linkend="gdbus-property-io-gpiod1-Line.Bias">"Bias"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
gpiodbus_line_dup_bias (GpiodbusLine *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "bias", &value, NULL);
  return value;
}

/**
 * gpiodbus_line_set_bias: (skip)
 * @object: A #GpiodbusLine.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-io-gpiod1-Line.Bias">"Bias"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
gpiodbus_line_set_bias (GpiodbusLine *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "bias", value, NULL);
}

/**
 * gpiodbus_line_get_drive: (skip)
 * @object: A #GpiodbusLine.
 *
 * Gets the value of the <link linkend="gdbus-property-io-gpiod1-Line.Drive">"Drive"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use gpiodbus_line_dup_drive() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
gpiodbus_line_get_drive (GpiodbusLine *object)
{
  g_return_val_if_fail (GPIODBUS_IS_LINE (object), NULL);

  return GPIODBUS_LINE_GET_IFACE (object)->get_drive (object);
}

/**
 * gpiodbus_line_dup_drive: (skip)
 * @object: A #GpiodbusLine.
 *
 * Gets a copy of the <link linkend="gdbus-property-io-gpiod1-Line.Drive">"Drive"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
gpiodbus_line_dup_drive (GpiodbusLine *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "drive", &value, NULL);
  return value;
}

/**
 * gpiodbus_line_set_drive: (skip)
 * @object: A #GpiodbusLine.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-io-gpiod1-Line.Drive">"Drive"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
gpiodbus_line_set_drive (GpiodbusLine *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "drive", value, NULL);
}

/**
 * gpiodbus_line_get_active_low: (skip)
 * @object: A #GpiodbusLine.
 *
 * Gets the value of the <link linkend="gdbus-property-io-gpiod1-Line.ActiveLow">"ActiveLow"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
gpiodbus_line_get_active_low (GpiodbusLine *object)
{
  g_return_val_if_fail (GPIODBUS_IS_LINE (object), FALSE);

  return GPIODBUS_LINE_GET_IFACE (object)->get_active_low (object);
}

/**
 * gpiodbus_line_set_active_low: (skip)
 * @object: A #GpiodbusLine.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-io-gpiod1-Line.ActiveLow">"ActiveLow"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
gpiodbus_line_set_active_low (GpiodbusLine *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "active-low", value, NULL);
}

/**
 * gpiodbus_line_get_debounced: (skip)
 * @object: A #GpiodbusLine.
 *
 * Gets the value of the <link linkend="gdbus-property-io-gpiod1-Line.Debounced">"Debounced"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
gpiodbus_line_get_debounced (GpiodbusLine *object)
{
  g_return_val_if_fail (GPIODBUS_IS_LINE (object), FALSE);

  return GPIODBUS_LINE_GET_IFACE (object)->get_debounced (object);
}

/**
 * gpiodbus_line_set_debounced: (skip)
 * @object: A #GpiodbusLine.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-io-gpiod1-Line.Debounced">"Debounced"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
gpiodbus_line_set_debounced (GpiodbusLine *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "debounced", value, NULL);
}

/**
 * gpiodbus_line_get_debounce_period_us: (skip)
 * @object: A #GpiodbusLine.
 *
 * Gets the value of the <link linkend="gdbus-property-io-gpiod1-Line.DebouncePeriodUs">"DebouncePeriodUs"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint64 
gpiodbus_line_get_debounce_period_us (GpiodbusLine *object)
{
  g_return_val_if_fail (GPIODBUS_IS_LINE (object), 0);

  return GPIODBUS_LINE_GET_IFACE (object)->get_debounce_period_us (object);
}

/**
 * gpiodbus_line_set_debounce_period_us: (skip)
 * @object: A #GpiodbusLine.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-io-gpiod1-Line.DebouncePeriodUs">"DebouncePeriodUs"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
gpiodbus_line_set_debounce_period_us (GpiodbusLine *object, guint64 value)
{
  g_object_set (G_OBJECT (object), "debounce-period-us", value, NULL);
}

/**
 * gpiodbus_line_get_event_clock: (skip)
 * @object: A #GpiodbusLine.
 *
 * Gets the value of the <link linkend="gdbus-property-io-gpiod1-Line.EventClock">"EventClock"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use gpiodbus_line_dup_event_clock() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
gpiodbus_line_get_event_clock (GpiodbusLine *object)
{
  g_return_val_if_fail (GPIODBUS_IS_LINE (object), NULL);

  return GPIODBUS_LINE_GET_IFACE (object)->get_event_clock (object);
}

/**
 * gpiodbus_line_dup_event_clock: (skip)
 * @object: A #GpiodbusLine.
 *
 * Gets a copy of the <link linkend="gdbus-property-io-gpiod1-Line.EventClock">"EventClock"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
gpiodbus_line_dup_event_clock (GpiodbusLine *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "event-clock", &value, NULL);
  return value;
}

/**
 * gpiodbus_line_set_event_clock: (skip)
 * @object: A #GpiodbusLine.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-io-gpiod1-Line.EventClock">"EventClock"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
gpiodbus_line_set_event_clock (GpiodbusLine *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "event-clock", value, NULL);
}

/**
 * gpiodbus_line_get_managed: (skip)
 * @object: A #GpiodbusLine.
 *
 * Gets the value of the <link linkend="gdbus-property-io-gpiod1-Line.Managed">"Managed"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
gpiodbus_line_get_managed (GpiodbusLine *object)
{
  g_return_val_if_fail (GPIODBUS_IS_LINE (object), FALSE);

  return GPIODBUS_LINE_GET_IFACE (object)->get_managed (object);
}

/**
 * gpiodbus_line_set_managed: (skip)
 * @object: A #GpiodbusLine.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-io-gpiod1-Line.Managed">"Managed"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
gpiodbus_line_set_managed (GpiodbusLine *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "managed", value, NULL);
}

/**
 * gpiodbus_line_get_request_path: (skip)
 * @object: A #GpiodbusLine.
 *
 * Gets the value of the <link linkend="gdbus-property-io-gpiod1-Line.RequestPath">"RequestPath"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use gpiodbus_line_dup_request_path() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
gpiodbus_line_get_request_path (GpiodbusLine *object)
{
  g_return_val_if_fail (GPIODBUS_IS_LINE (object), NULL);

  return GPIODBUS_LINE_GET_IFACE (object)->get_request_path (object);
}

/**
 * gpiodbus_line_dup_request_path: (skip)
 * @object: A #GpiodbusLine.
 *
 * Gets a copy of the <link linkend="gdbus-property-io-gpiod1-Line.RequestPath">"RequestPath"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
gpiodbus_line_dup_request_path (GpiodbusLine *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "request-path", &value, NULL);
  return value;
}

/**
 * gpiodbus_line_set_request_path: (skip)
 * @object: A #GpiodbusLine.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-io-gpiod1-Line.RequestPath">"RequestPath"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
gpiodbus_line_set_request_path (GpiodbusLine *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "request-path", value, NULL);
}

/**
 * gpiodbus_line_emit_edge_event:
 * @object: A #GpiodbusLine.
 * @arg_event_data: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-io-gpiod1-Line.EdgeEvent">"EdgeEvent"</link> D-Bus signal.
 */
void
gpiodbus_line_emit_edge_event (
    GpiodbusLine *object,
    GVariant *arg_event_data)
{
  g_signal_emit (object, GPIODBUS__LINE_SIGNALS[GPIODBUS__LINE_EDGE_EVENT], 0, arg_event_data);
}

/* ------------------------------------------------------------------------ */

/**
 * GpiodbusLineProxy:
 *
 * The #GpiodbusLineProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * GpiodbusLineProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #GpiodbusLineProxy.
 */

struct _GpiodbusLineProxyPrivate
{
  GData *qdata;
};

static void gpiodbus_line_proxy_iface_init (GpiodbusLineIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (GpiodbusLineProxy, gpiodbus_line_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (GpiodbusLineProxy)
                         G_IMPLEMENT_INTERFACE (GPIODBUS_TYPE_LINE, gpiodbus_line_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (GpiodbusLineProxy, gpiodbus_line_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (GPIODBUS_TYPE_LINE, gpiodbus_line_proxy_iface_init))

#endif
static void
gpiodbus_line_proxy_finalize (GObject *object)
{
  GpiodbusLineProxy *proxy = GPIODBUS_LINE_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (gpiodbus_line_proxy_parent_class)->finalize (object);
}

static void
gpiodbus_line_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 14);
  info = (const _ExtendedGDBusPropertyInfo *) _gpiodbus_line_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
gpiodbus_line_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface io.gpiod1.Line: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
gpiodbus_line_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 14);
  info = (const _ExtendedGDBusPropertyInfo *) _gpiodbus_line_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "io.gpiod1.Line", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) gpiodbus_line_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
gpiodbus_line_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_gpiodbus_line_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], GPIODBUS_TYPE_LINE);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, GPIODBUS_TYPE_LINE);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
gpiodbus_line_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  GpiodbusLineProxy *proxy = GPIODBUS_LINE_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gpiodbus_line_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gpiodbus_line_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static guint 
gpiodbus_line_proxy_get_offset (GpiodbusLine *object)
{
  GpiodbusLineProxy *proxy = GPIODBUS_LINE_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Offset");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
gpiodbus_line_proxy_get_name (GpiodbusLine *object)
{
  GpiodbusLineProxy *proxy = GPIODBUS_LINE_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Name");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
gpiodbus_line_proxy_get_used (GpiodbusLine *object)
{
  GpiodbusLineProxy *proxy = GPIODBUS_LINE_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Used");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
gpiodbus_line_proxy_get_consumer (GpiodbusLine *object)
{
  GpiodbusLineProxy *proxy = GPIODBUS_LINE_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Consumer");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
gpiodbus_line_proxy_get_direction (GpiodbusLine *object)
{
  GpiodbusLineProxy *proxy = GPIODBUS_LINE_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Direction");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
gpiodbus_line_proxy_get_edge_detection (GpiodbusLine *object)
{
  GpiodbusLineProxy *proxy = GPIODBUS_LINE_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "EdgeDetection");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
gpiodbus_line_proxy_get_bias (GpiodbusLine *object)
{
  GpiodbusLineProxy *proxy = GPIODBUS_LINE_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Bias");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
gpiodbus_line_proxy_get_drive (GpiodbusLine *object)
{
  GpiodbusLineProxy *proxy = GPIODBUS_LINE_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Drive");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
gpiodbus_line_proxy_get_active_low (GpiodbusLine *object)
{
  GpiodbusLineProxy *proxy = GPIODBUS_LINE_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "ActiveLow");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
gpiodbus_line_proxy_get_debounced (GpiodbusLine *object)
{
  GpiodbusLineProxy *proxy = GPIODBUS_LINE_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Debounced");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint64 
gpiodbus_line_proxy_get_debounce_period_us (GpiodbusLine *object)
{
  GpiodbusLineProxy *proxy = GPIODBUS_LINE_PROXY (object);
  GVariant *variant;
  guint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "DebouncePeriodUs");
  if (variant != NULL)
    {
      value = g_variant_get_uint64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
gpiodbus_line_proxy_get_event_clock (GpiodbusLine *object)
{
  GpiodbusLineProxy *proxy = GPIODBUS_LINE_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "EventClock");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
gpiodbus_line_proxy_get_managed (GpiodbusLine *object)
{
  GpiodbusLineProxy *proxy = GPIODBUS_LINE_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Managed");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
gpiodbus_line_proxy_get_request_path (GpiodbusLine *object)
{
  GpiodbusLineProxy *proxy = GPIODBUS_LINE_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "RequestPath");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static void
gpiodbus_line_proxy_init (GpiodbusLineProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = gpiodbus_line_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, GPIODBUS_TYPE_LINE_PROXY, GpiodbusLineProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), gpiodbus_line_interface_info ());
}

static void
gpiodbus_line_proxy_class_init (GpiodbusLineProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = gpiodbus_line_proxy_finalize;
  gobject_class->get_property = gpiodbus_line_proxy_get_property;
  gobject_class->set_property = gpiodbus_line_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = gpiodbus_line_proxy_g_signal;
  proxy_class->g_properties_changed = gpiodbus_line_proxy_g_properties_changed;

  gpiodbus_line_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (GpiodbusLineProxyPrivate));
#endif
}

static void
gpiodbus_line_proxy_iface_init (GpiodbusLineIface *iface)
{
  iface->get_offset = gpiodbus_line_proxy_get_offset;
  iface->get_name = gpiodbus_line_proxy_get_name;
  iface->get_used = gpiodbus_line_proxy_get_used;
  iface->get_consumer = gpiodbus_line_proxy_get_consumer;
  iface->get_direction = gpiodbus_line_proxy_get_direction;
  iface->get_edge_detection = gpiodbus_line_proxy_get_edge_detection;
  iface->get_bias = gpiodbus_line_proxy_get_bias;
  iface->get_drive = gpiodbus_line_proxy_get_drive;
  iface->get_active_low = gpiodbus_line_proxy_get_active_low;
  iface->get_debounced = gpiodbus_line_proxy_get_debounced;
  iface->get_debounce_period_us = gpiodbus_line_proxy_get_debounce_period_us;
  iface->get_event_clock = gpiodbus_line_proxy_get_event_clock;
  iface->get_managed = gpiodbus_line_proxy_get_managed;
  iface->get_request_path = gpiodbus_line_proxy_get_request_path;
}

/**
 * gpiodbus_line_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-io-gpiod1-Line.top_of_page">io.gpiod1.Line</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gpiodbus_line_proxy_new_finish() to get the result of the operation.
 *
 * See gpiodbus_line_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
gpiodbus_line_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (GPIODBUS_TYPE_LINE_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "io.gpiod1.Line", NULL);
}

/**
 * gpiodbus_line_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gpiodbus_line_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with gpiodbus_line_proxy_new().
 *
 * Returns: (transfer full) (type GpiodbusLineProxy): The constructed proxy object or %NULL if @error is set.
 */
GpiodbusLine *
gpiodbus_line_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return GPIODBUS_LINE (ret);
  else
    return NULL;
}

/**
 * gpiodbus_line_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-io-gpiod1-Line.top_of_page">io.gpiod1.Line</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See gpiodbus_line_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type GpiodbusLineProxy): The constructed proxy object or %NULL if @error is set.
 */
GpiodbusLine *
gpiodbus_line_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (GPIODBUS_TYPE_LINE_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "io.gpiod1.Line", NULL);
  if (ret != NULL)
    return GPIODBUS_LINE (ret);
  else
    return NULL;
}


/**
 * gpiodbus_line_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like gpiodbus_line_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gpiodbus_line_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See gpiodbus_line_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
gpiodbus_line_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (GPIODBUS_TYPE_LINE_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "io.gpiod1.Line", NULL);
}

/**
 * gpiodbus_line_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gpiodbus_line_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with gpiodbus_line_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type GpiodbusLineProxy): The constructed proxy object or %NULL if @error is set.
 */
GpiodbusLine *
gpiodbus_line_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return GPIODBUS_LINE (ret);
  else
    return NULL;
}

/**
 * gpiodbus_line_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like gpiodbus_line_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See gpiodbus_line_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type GpiodbusLineProxy): The constructed proxy object or %NULL if @error is set.
 */
GpiodbusLine *
gpiodbus_line_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (GPIODBUS_TYPE_LINE_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "io.gpiod1.Line", NULL);
  if (ret != NULL)
    return GPIODBUS_LINE (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * GpiodbusLineSkeleton:
 *
 * The #GpiodbusLineSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * GpiodbusLineSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #GpiodbusLineSkeleton.
 */

struct _GpiodbusLineSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_gpiodbus_line_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  GpiodbusLineSkeleton *skeleton = GPIODBUS_LINE_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], GPIODBUS_TYPE_LINE);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, GPIODBUS_TYPE_LINE);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_gpiodbus_line_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  GpiodbusLineSkeleton *skeleton = GPIODBUS_LINE_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gpiodbus_line_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_gpiodbus_line_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  GpiodbusLineSkeleton *skeleton = GPIODBUS_LINE_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gpiodbus_line_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _gpiodbus_line_skeleton_vtable =
{
  _gpiodbus_line_skeleton_handle_method_call,
  _gpiodbus_line_skeleton_handle_get_property,
  _gpiodbus_line_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
gpiodbus_line_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return gpiodbus_line_interface_info ();
}

static GDBusInterfaceVTable *
gpiodbus_line_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_gpiodbus_line_skeleton_vtable;
}

static GVariant *
gpiodbus_line_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  GpiodbusLineSkeleton *skeleton = GPIODBUS_LINE_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_gpiodbus_line_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _gpiodbus_line_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _gpiodbus_line_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _gpiodbus_line_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "io.gpiod1.Line", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _gpiodbus_line_emit_changed (gpointer user_data);

static void
gpiodbus_line_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  GpiodbusLineSkeleton *skeleton = GPIODBUS_LINE_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _gpiodbus_line_emit_changed (skeleton);
}

static void
_gpiodbus_line_on_signal_edge_event (
    GpiodbusLine *object,
    GVariant *arg_event_data)
{
  GpiodbusLineSkeleton *skeleton = GPIODBUS_LINE_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(@(ittt))",
                   arg_event_data));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "io.gpiod1.Line", "EdgeEvent",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void gpiodbus_line_skeleton_iface_init (GpiodbusLineIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (GpiodbusLineSkeleton, gpiodbus_line_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (GpiodbusLineSkeleton)
                         G_IMPLEMENT_INTERFACE (GPIODBUS_TYPE_LINE, gpiodbus_line_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (GpiodbusLineSkeleton, gpiodbus_line_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (GPIODBUS_TYPE_LINE, gpiodbus_line_skeleton_iface_init))

#endif
static void
gpiodbus_line_skeleton_finalize (GObject *object)
{
  GpiodbusLineSkeleton *skeleton = GPIODBUS_LINE_SKELETON (object);
  guint n;
  for (n = 0; n < 14; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (gpiodbus_line_skeleton_parent_class)->finalize (object);
}

static void
gpiodbus_line_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  GpiodbusLineSkeleton *skeleton = GPIODBUS_LINE_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 14);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_gpiodbus_line_emit_changed (gpointer user_data)
{
  GpiodbusLineSkeleton *skeleton = GPIODBUS_LINE_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init_static (&invalidated_builder, G_VARIANT_TYPE ("as"));
#else
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
#endif
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "io.gpiod1.Line",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_gpiodbus_line_schedule_emit_changed (GpiodbusLineSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
gpiodbus_line_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  GpiodbusLineSkeleton *skeleton = GPIODBUS_LINE_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _gpiodbus_line_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _gpiodbus_line_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
gpiodbus_line_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  GpiodbusLineSkeleton *skeleton = GPIODBUS_LINE_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 14);
  info = (const _ExtendedGDBusPropertyInfo *) _gpiodbus_line_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _gpiodbus_line_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
gpiodbus_line_skeleton_init (GpiodbusLineSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = gpiodbus_line_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, GPIODBUS_TYPE_LINE_SKELETON, GpiodbusLineSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 14);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_UINT);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[2], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[3], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[4], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[5], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[6], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[7], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[8], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[9], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[10], G_TYPE_UINT64);
  g_value_init (&skeleton->priv->properties[11], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[12], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[13], G_TYPE_STRING);
}

static guint 
gpiodbus_line_skeleton_get_offset (GpiodbusLine *object)
{
  GpiodbusLineSkeleton *skeleton = GPIODBUS_LINE_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_uint (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
gpiodbus_line_skeleton_get_name (GpiodbusLine *object)
{
  GpiodbusLineSkeleton *skeleton = GPIODBUS_LINE_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
gpiodbus_line_skeleton_get_used (GpiodbusLine *object)
{
  GpiodbusLineSkeleton *skeleton = GPIODBUS_LINE_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boolean (&(skeleton->priv->properties[2]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
gpiodbus_line_skeleton_get_consumer (GpiodbusLine *object)
{
  GpiodbusLineSkeleton *skeleton = GPIODBUS_LINE_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[3]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
gpiodbus_line_skeleton_get_direction (GpiodbusLine *object)
{
  GpiodbusLineSkeleton *skeleton = GPIODBUS_LINE_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[4]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
gpiodbus_line_skeleton_get_edge_detection (GpiodbusLine *object)
{
  GpiodbusLineSkeleton *skeleton = GPIODBUS_LINE_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[5]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
gpiodbus_line_skeleton_get_bias (GpiodbusLine *object)
{
  GpiodbusLineSkeleton *skeleton = GPIODBUS_LINE_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[6]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
gpiodbus_line_skeleton_get_drive (GpiodbusLine *object)
{
  GpiodbusLineSkeleton *skeleton = GPIODBUS_LINE_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[7]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
gpiodbus_line_skeleton_get_active_low (GpiodbusLine *object)
{
  GpiodbusLineSkeleton *skeleton = GPIODBUS_LINE_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boolean (&(skeleton->priv->properties[8]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
gpiodbus_line_skeleton_get_debounced (GpiodbusLine *object)
{
  GpiodbusLineSkeleton *skeleton = GPIODBUS_LINE_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boolean (&(skeleton->priv->properties[9]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint64 
gpiodbus_line_skeleton_get_debounce_period_us (GpiodbusLine *object)
{
  GpiodbusLineSkeleton *skeleton = GPIODBUS_LINE_SKELETON (object);
  guint64 value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_uint64 (&(skeleton->priv->properties[10]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
gpiodbus_line_skeleton_get_event_clock (GpiodbusLine *object)
{
  GpiodbusLineSkeleton *skeleton = GPIODBUS_LINE_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[11]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
gpiodbus_line_skeleton_get_managed (GpiodbusLine *object)
{
  GpiodbusLineSkeleton *skeleton = GPIODBUS_LINE_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boolean (&(skeleton->priv->properties[12]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
gpiodbus_line_skeleton_get_request_path (GpiodbusLine *object)
{
  GpiodbusLineSkeleton *skeleton = GPIODBUS_LINE_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[13]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
gpiodbus_line_skeleton_class_init (GpiodbusLineSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = gpiodbus_line_skeleton_finalize;
  gobject_class->get_property = gpiodbus_line_skeleton_get_property;
  gobject_class->set_property = gpiodbus_line_skeleton_set_property;
  gobject_class->notify       = gpiodbus_line_skeleton_notify;


  gpiodbus_line_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = gpiodbus_line_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = gpiodbus_line_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = gpiodbus_line_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = gpiodbus_line_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (GpiodbusLineSkeletonPrivate));
#endif
}

static void
gpiodbus_line_skeleton_iface_init (GpiodbusLineIface *iface)
{
  iface->edge_event = _gpiodbus_line_on_signal_edge_event;
  iface->get_offset = gpiodbus_line_skeleton_get_offset;
  iface->get_name = gpiodbus_line_skeleton_get_name;
  iface->get_used = gpiodbus_line_skeleton_get_used;
  iface->get_consumer = gpiodbus_line_skeleton_get_consumer;
  iface->get_direction = gpiodbus_line_skeleton_get_direction;
  iface->get_edge_detection = gpiodbus_line_skeleton_get_edge_detection;
  iface->get_bias = gpiodbus_line_skeleton_get_bias;
  iface->get_drive = gpiodbus_line_skeleton_get_drive;
  iface->get_active_low = gpiodbus_line_skeleton_get_active_low;
  iface->get_debounced = gpiodbus_line_skeleton_get_debounced;
  iface->get_debounce_period_us = gpiodbus_line_skeleton_get_debounce_period_us;
  iface->get_event_clock = gpiodbus_line_skeleton_get_event_clock;
  iface->get_managed = gpiodbus_line_skeleton_get_managed;
  iface->get_request_path = gpiodbus_line_skeleton_get_request_path;
}

/**
 * gpiodbus_line_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-io-gpiod1-Line.top_of_page">io.gpiod1.Line</link>.
 *
 * Returns: (transfer full) (type GpiodbusLineSkeleton): The skeleton object.
 */
GpiodbusLine *
gpiodbus_line_skeleton_new (void)
{
  return GPIODBUS_LINE (g_object_new (GPIODBUS_TYPE_LINE_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface io.gpiod1.Request
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:GpiodbusRequest
 * @title: GpiodbusRequest
 * @short_description: Generated C code for the io.gpiod1.Request D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-io-gpiod1-Request.top_of_page">io.gpiod1.Request</link> D-Bus interface in C.
 */

/* ---- Introspection data for io.gpiod1.Request ---- */

static const _ExtendedGDBusMethodInfo _gpiodbus_request_method_info_release =
{
  {
    -1,
    (gchar *) "Release",
    NULL,
    NULL,
    NULL
  },
  "handle-release",
  FALSE
};

static const _ExtendedGDBusArgInfo _gpiodbus_request_method_info_reconfigure_lines_IN_ARG_line_config =
{
  {
    -1,
    (gchar *) "line_config",
    (gchar *) "(a(aua{sv})ai)",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gpiodbus_request_method_info_reconfigure_lines_IN_ARG_pointers[] =
{
  &_gpiodbus_request_method_info_reconfigure_lines_IN_ARG_line_config.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _gpiodbus_request_method_info_reconfigure_lines =
{
  {
    -1,
    (gchar *) "ReconfigureLines",
    (GDBusArgInfo **) &_gpiodbus_request_method_info_reconfigure_lines_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-reconfigure-lines",
  FALSE
};

static const _ExtendedGDBusArgInfo _gpiodbus_request_method_info_get_values_IN_ARG_offsets =
{
  {
    -1,
    (gchar *) "offsets",
    (gchar *) "au",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gpiodbus_request_method_info_get_values_IN_ARG_pointers[] =
{
  &_gpiodbus_request_method_info_get_values_IN_ARG_offsets.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _gpiodbus_request_method_info_get_values_OUT_ARG_values =
{
  {
    -1,
    (gchar *) "values",
    (gchar *) "ai",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gpiodbus_request_method_info_get_values_OUT_ARG_pointers[] =
{
  &_gpiodbus_request_method_info_get_values_OUT_ARG_values.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _gpiodbus_request_method_info_get_values =
{
  {
    -1,
    (gchar *) "GetValues",
    (GDBusArgInfo **) &_gpiodbus_request_method_info_get_values_IN_ARG_pointers,
    (GDBusArgInfo **) &_gpiodbus_request_method_info_get_values_OUT_ARG_pointers,
    NULL
  },
  "handle-get-values",
  FALSE
};

static const _ExtendedGDBusArgInfo _gpiodbus_request_method_info_set_values_IN_ARG_values =
{
  {
    -1,
    (gchar *) "values",
    (gchar *) "a{ui}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gpiodbus_request_method_info_set_values_IN_ARG_pointers[] =
{
  &_gpiodbus_request_method_info_set_values_IN_ARG_values.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _gpiodbus_request_method_info_set_values =
{
  {
    -1,
    (gchar *) "SetValues",
    (GDBusArgInfo **) &_gpiodbus_request_method_info_set_values_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-set-values",
  FALSE
};

static const GDBusMethodInfo * const _gpiodbus_request_method_info_pointers[] =
{
  &_gpiodbus_request_method_info_release.parent_struct,
  &_gpiodbus_request_method_info_reconfigure_lines.parent_struct,
  &_gpiodbus_request_method_info_get_values.parent_struct,
  &_gpiodbus_request_method_info_set_values.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _gpiodbus_request_property_info_chip_path =
{
  {
    -1,
    (gchar *) "ChipPath",
    (gchar *) "o",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "chip-path",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _gpiodbus_request_property_info_line_paths =
{
  {
    -1,
    (gchar *) "LinePaths",
    (gchar *) "ao",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "line-paths",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _gpiodbus_request_property_info_pointers[] =
{
  &_gpiodbus_request_property_info_chip_path.parent_struct,
  &_gpiodbus_request_property_info_line_paths.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _gpiodbus_request_interface_info =
{
  {
    -1,
    (gchar *) "io.gpiod1.Request",
    (GDBusMethodInfo **) &_gpiodbus_request_method_info_pointers,
    NULL,
    (GDBusPropertyInfo **) &_gpiodbus_request_property_info_pointers,
    NULL
  },
  "request",
};


/**
 * gpiodbus_request_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-io-gpiod1-Request.top_of_page">io.gpiod1.Request</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
gpiodbus_request_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_gpiodbus_request_interface_info.parent_struct;
}

/**
 * gpiodbus_request_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #GpiodbusRequest interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
gpiodbus_request_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "chip-path");
  g_object_class_override_property (klass, property_id_begin++, "line-paths");
  return property_id_begin - 1;
}


inline static void
gpiodbus_request_method_marshal_release (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gpiodbus_request_method_marshal_reconfigure_lines (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_VARIANT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gpiodbus_request_method_marshal_get_values (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_VARIANT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gpiodbus_request_method_marshal_set_values (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_VARIANT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * GpiodbusRequest:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-io-gpiod1-Request.top_of_page">io.gpiod1.Request</link>.
 */

/**
 * GpiodbusRequestIface:
 * @parent_iface: The parent interface.
 * @handle_get_values: Handler for the #GpiodbusRequest::handle-get-values signal.
 * @handle_reconfigure_lines: Handler for the #GpiodbusRequest::handle-reconfigure-lines signal.
 * @handle_release: Handler for the #GpiodbusRequest::handle-release signal.
 * @handle_set_values: Handler for the #GpiodbusRequest::handle-set-values signal.
 * @get_chip_path: Getter for the #GpiodbusRequest:chip-path property.
 * @get_line_paths: Getter for the #GpiodbusRequest:line-paths property.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-io-gpiod1-Request.top_of_page">io.gpiod1.Request</link>.
 */

typedef GpiodbusRequestIface GpiodbusRequestInterface;
G_DEFINE_INTERFACE (GpiodbusRequest, gpiodbus_request, G_TYPE_OBJECT)

static void
gpiodbus_request_default_init (GpiodbusRequestIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * GpiodbusRequest::handle-release:
   * @object: A #GpiodbusRequest.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-io-gpiod1-Request.Release">Release()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gpiodbus_request_complete_release() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-release",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GpiodbusRequestIface, handle_release),
    g_signal_accumulator_true_handled,
    NULL,
      gpiodbus_request_method_marshal_release,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * GpiodbusRequest::handle-reconfigure-lines:
   * @object: A #GpiodbusRequest.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_line_config: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-io-gpiod1-Request.ReconfigureLines">ReconfigureLines()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gpiodbus_request_complete_reconfigure_lines() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-reconfigure-lines",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GpiodbusRequestIface, handle_reconfigure_lines),
    g_signal_accumulator_true_handled,
    NULL,
      gpiodbus_request_method_marshal_reconfigure_lines,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_VARIANT);

  /**
   * GpiodbusRequest::handle-get-values:
   * @object: A #GpiodbusRequest.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_offsets: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-io-gpiod1-Request.GetValues">GetValues()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gpiodbus_request_complete_get_values() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-values",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GpiodbusRequestIface, handle_get_values),
    g_signal_accumulator_true_handled,
    NULL,
      gpiodbus_request_method_marshal_get_values,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_VARIANT);

  /**
   * GpiodbusRequest::handle-set-values:
   * @object: A #GpiodbusRequest.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_values: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-io-gpiod1-Request.SetValues">SetValues()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gpiodbus_request_complete_set_values() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-values",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GpiodbusRequestIface, handle_set_values),
    g_signal_accumulator_true_handled,
    NULL,
      gpiodbus_request_method_marshal_set_values,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_VARIANT);

  /* GObject properties for D-Bus properties: */
  /**
   * GpiodbusRequest:chip-path:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-io-gpiod1-Request.ChipPath">"ChipPath"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("chip-path", "ChipPath", "ChipPath", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * GpiodbusRequest:line-paths:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-io-gpiod1-Request.LinePaths">"LinePaths"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boxed ("line-paths", "LinePaths", "LinePaths", G_TYPE_STRV, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * gpiodbus_request_get_chip_path: (skip)
 * @object: A #GpiodbusRequest.
 *
 * Gets the value of the <link linkend="gdbus-property-io-gpiod1-Request.ChipPath">"ChipPath"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use gpiodbus_request_dup_chip_path() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
gpiodbus_request_get_chip_path (GpiodbusRequest *object)
{
  g_return_val_if_fail (GPIODBUS_IS_REQUEST (object), NULL);

  return GPIODBUS_REQUEST_GET_IFACE (object)->get_chip_path (object);
}

/**
 * gpiodbus_request_dup_chip_path: (skip)
 * @object: A #GpiodbusRequest.
 *
 * Gets a copy of the <link linkend="gdbus-property-io-gpiod1-Request.ChipPath">"ChipPath"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
gpiodbus_request_dup_chip_path (GpiodbusRequest *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "chip-path", &value, NULL);
  return value;
}

/**
 * gpiodbus_request_set_chip_path: (skip)
 * @object: A #GpiodbusRequest.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-io-gpiod1-Request.ChipPath">"ChipPath"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
gpiodbus_request_set_chip_path (GpiodbusRequest *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "chip-path", value, NULL);
}

/**
 * gpiodbus_request_get_line_paths: (skip)
 * @object: A #GpiodbusRequest.
 *
 * Gets the value of the <link linkend="gdbus-property-io-gpiod1-Request.LinePaths">"LinePaths"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use gpiodbus_request_dup_line_paths() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *const *
gpiodbus_request_get_line_paths (GpiodbusRequest *object)
{
  g_return_val_if_fail (GPIODBUS_IS_REQUEST (object), NULL);

  return GPIODBUS_REQUEST_GET_IFACE (object)->get_line_paths (object);
}

/**
 * gpiodbus_request_dup_line_paths: (skip)
 * @object: A #GpiodbusRequest.
 *
 * Gets a copy of the <link linkend="gdbus-property-io-gpiod1-Request.LinePaths">"LinePaths"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_strfreev().
 */
gchar **
gpiodbus_request_dup_line_paths (GpiodbusRequest *object)
{
  gchar **value;
  g_object_get (G_OBJECT (object), "line-paths", &value, NULL);
  return value;
}

/**
 * gpiodbus_request_set_line_paths: (skip)
 * @object: A #GpiodbusRequest.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-io-gpiod1-Request.LinePaths">"LinePaths"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
gpiodbus_request_set_line_paths (GpiodbusRequest *object, const gchar *const *value)
{
  g_object_set (G_OBJECT (object), "line-paths", value, NULL);
}

/**
 * gpiodbus_request_call_release:
 * @proxy: A #GpiodbusRequestProxy.
 * @call_flags: Flags from the #GDBusCallFlags enumeration. If you want to allow interactive
       authorization be sure to set %G_DBUS_CALL_FLAGS_ALLOW_INTERACTIVE_AUTHORIZATION.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning "infinite") or
       -1 to use the proxy default timeout.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-io-gpiod1-Request.Release">Release()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gpiodbus_request_call_release_finish() to get the result of the operation.
 *
 * See gpiodbus_request_call_release_sync() for the synchronous, blocking version of this method.
 */
void
gpiodbus_request_call_release (
    GpiodbusRequest *proxy,
    GDBusCallFlags call_flags,
    gint timeout_msec,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Release",
    g_variant_new ("()"),
    call_flags,
    timeout_msec,
    cancellable,
    callback,
    user_data);
}

/**
 * gpiodbus_request_call_release_finish:
 * @proxy: A #GpiodbusRequestProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gpiodbus_request_call_release().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gpiodbus_request_call_release().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gpiodbus_request_call_release_finish (
    GpiodbusRequest *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gpiodbus_request_call_release_sync:
 * @proxy: A #GpiodbusRequestProxy.
 * @call_flags: Flags from the #GDBusCallFlags enumeration. If you want to allow interactive
       authorization be sure to set %G_DBUS_CALL_FLAGS_ALLOW_INTERACTIVE_AUTHORIZATION.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning "infinite") or
       -1 to use the proxy default timeout.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-io-gpiod1-Request.Release">Release()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gpiodbus_request_call_release() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gpiodbus_request_call_release_sync (
    GpiodbusRequest *proxy,
    GDBusCallFlags call_flags,
    gint timeout_msec,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Release",
    g_variant_new ("()"),
    call_flags,
    timeout_msec,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gpiodbus_request_call_reconfigure_lines:
 * @proxy: A #GpiodbusRequestProxy.
 * @arg_line_config: Argument to pass with the method invocation.
 * @call_flags: Flags from the #GDBusCallFlags enumeration. If you want to allow interactive
       authorization be sure to set %G_DBUS_CALL_FLAGS_ALLOW_INTERACTIVE_AUTHORIZATION.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning "infinite") or
       -1 to use the proxy default timeout.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-io-gpiod1-Request.ReconfigureLines">ReconfigureLines()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gpiodbus_request_call_reconfigure_lines_finish() to get the result of the operation.
 *
 * See gpiodbus_request_call_reconfigure_lines_sync() for the synchronous, blocking version of this method.
 */
void
gpiodbus_request_call_reconfigure_lines (
    GpiodbusRequest *proxy,
    GVariant *arg_line_config,
    GDBusCallFlags call_flags,
    gint timeout_msec,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ReconfigureLines",
    g_variant_new ("(@(a(aua{sv})ai))",
                   arg_line_config),
    call_flags,
    timeout_msec,
    cancellable,
    callback,
    user_data);
}

/**
 * gpiodbus_request_call_reconfigure_lines_finish:
 * @proxy: A #GpiodbusRequestProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gpiodbus_request_call_reconfigure_lines().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gpiodbus_request_call_reconfigure_lines().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gpiodbus_request_call_reconfigure_lines_finish (
    GpiodbusRequest *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gpiodbus_request_call_reconfigure_lines_sync:
 * @proxy: A #GpiodbusRequestProxy.
 * @arg_line_config: Argument to pass with the method invocation.
 * @call_flags: Flags from the #GDBusCallFlags enumeration. If you want to allow interactive
       authorization be sure to set %G_DBUS_CALL_FLAGS_ALLOW_INTERACTIVE_AUTHORIZATION.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning "infinite") or
       -1 to use the proxy default timeout.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-io-gpiod1-Request.ReconfigureLines">ReconfigureLines()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gpiodbus_request_call_reconfigure_lines() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gpiodbus_request_call_reconfigure_lines_sync (
    GpiodbusRequest *proxy,
    GVariant *arg_line_config,
    GDBusCallFlags call_flags,
    gint timeout_msec,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ReconfigureLines",
    g_variant_new ("(@(a(aua{sv})ai))",
                   arg_line_config),
    call_flags,
    timeout_msec,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gpiodbus_request_call_get_values:
 * @proxy: A #GpiodbusRequestProxy.
 * @arg_offsets: Argument to pass with the method invocation.
 * @call_flags: Flags from the #GDBusCallFlags enumeration. If you want to allow interactive
       authorization be sure to set %G_DBUS_CALL_FLAGS_ALLOW_INTERACTIVE_AUTHORIZATION.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning "infinite") or
       -1 to use the proxy default timeout.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-io-gpiod1-Request.GetValues">GetValues()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gpiodbus_request_call_get_values_finish() to get the result of the operation.
 *
 * See gpiodbus_request_call_get_values_sync() for the synchronous, blocking version of this method.
 */
void
gpiodbus_request_call_get_values (
    GpiodbusRequest *proxy,
    GVariant *arg_offsets,
    GDBusCallFlags call_flags,
    gint timeout_msec,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetValues",
    g_variant_new ("(@au)",
                   arg_offsets),
    call_flags,
    timeout_msec,
    cancellable,
    callback,
    user_data);
}

/**
 * gpiodbus_request_call_get_values_finish:
 * @proxy: A #GpiodbusRequestProxy.
 * @out_values: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gpiodbus_request_call_get_values().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gpiodbus_request_call_get_values().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gpiodbus_request_call_get_values_finish (
    GpiodbusRequest *proxy,
    GVariant **out_values,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@ai)",
                 out_values);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gpiodbus_request_call_get_values_sync:
 * @proxy: A #GpiodbusRequestProxy.
 * @arg_offsets: Argument to pass with the method invocation.
 * @call_flags: Flags from the #GDBusCallFlags enumeration. If you want to allow interactive
       authorization be sure to set %G_DBUS_CALL_FLAGS_ALLOW_INTERACTIVE_AUTHORIZATION.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning "infinite") or
       -1 to use the proxy default timeout.
 * @out_values: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-io-gpiod1-Request.GetValues">GetValues()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gpiodbus_request_call_get_values() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gpiodbus_request_call_get_values_sync (
    GpiodbusRequest *proxy,
    GVariant *arg_offsets,
    GDBusCallFlags call_flags,
    gint timeout_msec,
    GVariant **out_values,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetValues",
    g_variant_new ("(@au)",
                   arg_offsets),
    call_flags,
    timeout_msec,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@ai)",
                 out_values);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gpiodbus_request_call_set_values:
 * @proxy: A #GpiodbusRequestProxy.
 * @arg_values: Argument to pass with the method invocation.
 * @call_flags: Flags from the #GDBusCallFlags enumeration. If you want to allow interactive
       authorization be sure to set %G_DBUS_CALL_FLAGS_ALLOW_INTERACTIVE_AUTHORIZATION.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning "infinite") or
       -1 to use the proxy default timeout.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-io-gpiod1-Request.SetValues">SetValues()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gpiodbus_request_call_set_values_finish() to get the result of the operation.
 *
 * See gpiodbus_request_call_set_values_sync() for the synchronous, blocking version of this method.
 */
void
gpiodbus_request_call_set_values (
    GpiodbusRequest *proxy,
    GVariant *arg_values,
    GDBusCallFlags call_flags,
    gint timeout_msec,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetValues",
    g_variant_new ("(@a{ui})",
                   arg_values),
    call_flags,
    timeout_msec,
    cancellable,
    callback,
    user_data);
}

/**
 * gpiodbus_request_call_set_values_finish:
 * @proxy: A #GpiodbusRequestProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gpiodbus_request_call_set_values().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gpiodbus_request_call_set_values().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gpiodbus_request_call_set_values_finish (
    GpiodbusRequest *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gpiodbus_request_call_set_values_sync:
 * @proxy: A #GpiodbusRequestProxy.
 * @arg_values: Argument to pass with the method invocation.
 * @call_flags: Flags from the #GDBusCallFlags enumeration. If you want to allow interactive
       authorization be sure to set %G_DBUS_CALL_FLAGS_ALLOW_INTERACTIVE_AUTHORIZATION.
 * @timeout_msec: The timeout in milliseconds (with %G_MAXINT meaning "infinite") or
       -1 to use the proxy default timeout.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-io-gpiod1-Request.SetValues">SetValues()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gpiodbus_request_call_set_values() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gpiodbus_request_call_set_values_sync (
    GpiodbusRequest *proxy,
    GVariant *arg_values,
    GDBusCallFlags call_flags,
    gint timeout_msec,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetValues",
    g_variant_new ("(@a{ui})",
                   arg_values),
    call_flags,
    timeout_msec,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gpiodbus_request_complete_release:
 * @object: A #GpiodbusRequest.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-io-gpiod1-Request.Release">Release()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gpiodbus_request_complete_release (
    GpiodbusRequest *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * gpiodbus_request_complete_reconfigure_lines:
 * @object: A #GpiodbusRequest.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-io-gpiod1-Request.ReconfigureLines">ReconfigureLines()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gpiodbus_request_complete_reconfigure_lines (
    GpiodbusRequest *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * gpiodbus_request_complete_get_values:
 * @object: A #GpiodbusRequest.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @values: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-io-gpiod1-Request.GetValues">GetValues()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gpiodbus_request_complete_get_values (
    GpiodbusRequest *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GVariant *values)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@ai)",
                   values));
}

/**
 * gpiodbus_request_complete_set_values:
 * @object: A #GpiodbusRequest.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-io-gpiod1-Request.SetValues">SetValues()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gpiodbus_request_complete_set_values (
    GpiodbusRequest *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * GpiodbusRequestProxy:
 *
 * The #GpiodbusRequestProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * GpiodbusRequestProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #GpiodbusRequestProxy.
 */

struct _GpiodbusRequestProxyPrivate
{
  GData *qdata;
};

static void gpiodbus_request_proxy_iface_init (GpiodbusRequestIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (GpiodbusRequestProxy, gpiodbus_request_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (GpiodbusRequestProxy)
                         G_IMPLEMENT_INTERFACE (GPIODBUS_TYPE_REQUEST, gpiodbus_request_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (GpiodbusRequestProxy, gpiodbus_request_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (GPIODBUS_TYPE_REQUEST, gpiodbus_request_proxy_iface_init))

#endif
static void
gpiodbus_request_proxy_finalize (GObject *object)
{
  GpiodbusRequestProxy *proxy = GPIODBUS_REQUEST_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (gpiodbus_request_proxy_parent_class)->finalize (object);
}

static void
gpiodbus_request_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  info = (const _ExtendedGDBusPropertyInfo *) _gpiodbus_request_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
gpiodbus_request_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface io.gpiod1.Request: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
gpiodbus_request_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  info = (const _ExtendedGDBusPropertyInfo *) _gpiodbus_request_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "io.gpiod1.Request", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) gpiodbus_request_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
gpiodbus_request_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_gpiodbus_request_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], GPIODBUS_TYPE_REQUEST);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, GPIODBUS_TYPE_REQUEST);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
gpiodbus_request_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  GpiodbusRequestProxy *proxy = GPIODBUS_REQUEST_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gpiodbus_request_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gpiodbus_request_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static const gchar *
gpiodbus_request_proxy_get_chip_path (GpiodbusRequest *object)
{
  GpiodbusRequestProxy *proxy = GPIODBUS_REQUEST_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "ChipPath");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *const *
gpiodbus_request_proxy_get_line_paths (GpiodbusRequest *object)
{
  GpiodbusRequestProxy *proxy = GPIODBUS_REQUEST_PROXY (object);
  GVariant *variant;
  const gchar *const *value = NULL;
  value = g_datalist_get_data (&proxy->priv->qdata, "LinePaths");
  if (value != NULL)
    return value;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "LinePaths");
  if (variant != NULL)
    {
      value = g_variant_get_objv (variant, NULL);
      g_datalist_set_data_full (&proxy->priv->qdata, "LinePaths", (gpointer) value, g_free);
      g_variant_unref (variant);
    }
  return value;
}

static void
gpiodbus_request_proxy_init (GpiodbusRequestProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = gpiodbus_request_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, GPIODBUS_TYPE_REQUEST_PROXY, GpiodbusRequestProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), gpiodbus_request_interface_info ());
}

static void
gpiodbus_request_proxy_class_init (GpiodbusRequestProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = gpiodbus_request_proxy_finalize;
  gobject_class->get_property = gpiodbus_request_proxy_get_property;
  gobject_class->set_property = gpiodbus_request_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = gpiodbus_request_proxy_g_signal;
  proxy_class->g_properties_changed = gpiodbus_request_proxy_g_properties_changed;

  gpiodbus_request_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (GpiodbusRequestProxyPrivate));
#endif
}

static void
gpiodbus_request_proxy_iface_init (GpiodbusRequestIface *iface)
{
  iface->get_chip_path = gpiodbus_request_proxy_get_chip_path;
  iface->get_line_paths = gpiodbus_request_proxy_get_line_paths;
}

/**
 * gpiodbus_request_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-io-gpiod1-Request.top_of_page">io.gpiod1.Request</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gpiodbus_request_proxy_new_finish() to get the result of the operation.
 *
 * See gpiodbus_request_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
gpiodbus_request_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (GPIODBUS_TYPE_REQUEST_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "io.gpiod1.Request", NULL);
}

/**
 * gpiodbus_request_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gpiodbus_request_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with gpiodbus_request_proxy_new().
 *
 * Returns: (transfer full) (type GpiodbusRequestProxy): The constructed proxy object or %NULL if @error is set.
 */
GpiodbusRequest *
gpiodbus_request_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return GPIODBUS_REQUEST (ret);
  else
    return NULL;
}

/**
 * gpiodbus_request_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-io-gpiod1-Request.top_of_page">io.gpiod1.Request</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See gpiodbus_request_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type GpiodbusRequestProxy): The constructed proxy object or %NULL if @error is set.
 */
GpiodbusRequest *
gpiodbus_request_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (GPIODBUS_TYPE_REQUEST_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "io.gpiod1.Request", NULL);
  if (ret != NULL)
    return GPIODBUS_REQUEST (ret);
  else
    return NULL;
}


/**
 * gpiodbus_request_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like gpiodbus_request_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gpiodbus_request_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See gpiodbus_request_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
gpiodbus_request_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (GPIODBUS_TYPE_REQUEST_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "io.gpiod1.Request", NULL);
}

/**
 * gpiodbus_request_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gpiodbus_request_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with gpiodbus_request_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type GpiodbusRequestProxy): The constructed proxy object or %NULL if @error is set.
 */
GpiodbusRequest *
gpiodbus_request_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return GPIODBUS_REQUEST (ret);
  else
    return NULL;
}

/**
 * gpiodbus_request_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like gpiodbus_request_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See gpiodbus_request_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type GpiodbusRequestProxy): The constructed proxy object or %NULL if @error is set.
 */
GpiodbusRequest *
gpiodbus_request_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (GPIODBUS_TYPE_REQUEST_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "io.gpiod1.Request", NULL);
  if (ret != NULL)
    return GPIODBUS_REQUEST (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * GpiodbusRequestSkeleton:
 *
 * The #GpiodbusRequestSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * GpiodbusRequestSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #GpiodbusRequestSkeleton.
 */

struct _GpiodbusRequestSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_gpiodbus_request_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  GpiodbusRequestSkeleton *skeleton = GPIODBUS_REQUEST_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], GPIODBUS_TYPE_REQUEST);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, GPIODBUS_TYPE_REQUEST);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_gpiodbus_request_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  GpiodbusRequestSkeleton *skeleton = GPIODBUS_REQUEST_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gpiodbus_request_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_gpiodbus_request_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  GpiodbusRequestSkeleton *skeleton = GPIODBUS_REQUEST_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gpiodbus_request_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _gpiodbus_request_skeleton_vtable =
{
  _gpiodbus_request_skeleton_handle_method_call,
  _gpiodbus_request_skeleton_handle_get_property,
  _gpiodbus_request_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
gpiodbus_request_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return gpiodbus_request_interface_info ();
}

static GDBusInterfaceVTable *
gpiodbus_request_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_gpiodbus_request_skeleton_vtable;
}

static GVariant *
gpiodbus_request_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  GpiodbusRequestSkeleton *skeleton = GPIODBUS_REQUEST_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_gpiodbus_request_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _gpiodbus_request_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _gpiodbus_request_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _gpiodbus_request_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "io.gpiod1.Request", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _gpiodbus_request_emit_changed (gpointer user_data);

static void
gpiodbus_request_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  GpiodbusRequestSkeleton *skeleton = GPIODBUS_REQUEST_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _gpiodbus_request_emit_changed (skeleton);
}

static void gpiodbus_request_skeleton_iface_init (GpiodbusRequestIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (GpiodbusRequestSkeleton, gpiodbus_request_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (GpiodbusRequestSkeleton)
                         G_IMPLEMENT_INTERFACE (GPIODBUS_TYPE_REQUEST, gpiodbus_request_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (GpiodbusRequestSkeleton, gpiodbus_request_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (GPIODBUS_TYPE_REQUEST, gpiodbus_request_skeleton_iface_init))

#endif
static void
gpiodbus_request_skeleton_finalize (GObject *object)
{
  GpiodbusRequestSkeleton *skeleton = GPIODBUS_REQUEST_SKELETON (object);
  guint n;
  for (n = 0; n < 2; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (gpiodbus_request_skeleton_parent_class)->finalize (object);
}

static void
gpiodbus_request_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  GpiodbusRequestSkeleton *skeleton = GPIODBUS_REQUEST_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_gpiodbus_request_emit_changed (gpointer user_data)
{
  GpiodbusRequestSkeleton *skeleton = GPIODBUS_REQUEST_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init_static (&invalidated_builder, G_VARIANT_TYPE ("as"));
#else
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
#endif
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "io.gpiod1.Request",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_gpiodbus_request_schedule_emit_changed (GpiodbusRequestSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
gpiodbus_request_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  GpiodbusRequestSkeleton *skeleton = GPIODBUS_REQUEST_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _gpiodbus_request_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _gpiodbus_request_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
gpiodbus_request_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  GpiodbusRequestSkeleton *skeleton = GPIODBUS_REQUEST_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  info = (const _ExtendedGDBusPropertyInfo *) _gpiodbus_request_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _gpiodbus_request_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
gpiodbus_request_skeleton_init (GpiodbusRequestSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = gpiodbus_request_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, GPIODBUS_TYPE_REQUEST_SKELETON, GpiodbusRequestSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 2);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_STRV);
}

static const gchar *
gpiodbus_request_skeleton_get_chip_path (GpiodbusRequest *object)
{
  GpiodbusRequestSkeleton *skeleton = GPIODBUS_REQUEST_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *const *
gpiodbus_request_skeleton_get_line_paths (GpiodbusRequest *object)
{
  GpiodbusRequestSkeleton *skeleton = GPIODBUS_REQUEST_SKELETON (object);
  const gchar *const *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boxed (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
gpiodbus_request_skeleton_class_init (GpiodbusRequestSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = gpiodbus_request_skeleton_finalize;
  gobject_class->get_property = gpiodbus_request_skeleton_get_property;
  gobject_class->set_property = gpiodbus_request_skeleton_set_property;
  gobject_class->notify       = gpiodbus_request_skeleton_notify;


  gpiodbus_request_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = gpiodbus_request_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = gpiodbus_request_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = gpiodbus_request_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = gpiodbus_request_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (GpiodbusRequestSkeletonPrivate));
#endif
}

static void
gpiodbus_request_skeleton_iface_init (GpiodbusRequestIface *iface)
{
  iface->get_chip_path = gpiodbus_request_skeleton_get_chip_path;
  iface->get_line_paths = gpiodbus_request_skeleton_get_line_paths;
}

/**
 * gpiodbus_request_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-io-gpiod1-Request.top_of_page">io.gpiod1.Request</link>.
 *
 * Returns: (transfer full) (type GpiodbusRequestSkeleton): The skeleton object.
 */
GpiodbusRequest *
gpiodbus_request_skeleton_new (void)
{
  return GPIODBUS_REQUEST (g_object_new (GPIODBUS_TYPE_REQUEST_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for Object, ObjectProxy and ObjectSkeleton
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:GpiodbusObject
 * @title: GpiodbusObject
 * @short_description: Specialized GDBusObject types
 *
 * This section contains the #GpiodbusObject, #GpiodbusObjectProxy, and #GpiodbusObjectSkeleton types which make it easier to work with objects implementing generated types for D-Bus interfaces.
 */

/**
 * GpiodbusObject:
 *
 * The #GpiodbusObject type is a specialized container of interfaces.
 */

/**
 * GpiodbusObjectIface:
 * @parent_iface: The parent interface.
 *
 * Virtual table for the #GpiodbusObject interface.
 */

typedef GpiodbusObjectIface GpiodbusObjectInterface;
G_DEFINE_INTERFACE_WITH_CODE (GpiodbusObject, gpiodbus_object, G_TYPE_OBJECT, g_type_interface_add_prerequisite (g_define_type_id, G_TYPE_DBUS_OBJECT);)

static void
gpiodbus_object_default_init (GpiodbusObjectIface *iface)
{
  /**
   * GpiodbusObject:chip:
   *
   * The #GpiodbusChip instance corresponding to the D-Bus interface <link linkend="gdbus-interface-io-gpiod1-Chip.top_of_page">io.gpiod1.Chip</link>, if any.
   *
   * Connect to the #GObject::notify signal to get informed of property changes.
   */
  g_object_interface_install_property (iface, g_param_spec_object ("chip", "chip", "chip", GPIODBUS_TYPE_CHIP, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));

  /**
   * GpiodbusObject:line:
   *
   * The #GpiodbusLine instance corresponding to the D-Bus interface <link linkend="gdbus-interface-io-gpiod1-Line.top_of_page">io.gpiod1.Line</link>, if any.
   *
   * Connect to the #GObject::notify signal to get informed of property changes.
   */
  g_object_interface_install_property (iface, g_param_spec_object ("line", "line", "line", GPIODBUS_TYPE_LINE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));

  /**
   * GpiodbusObject:request:
   *
   * The #GpiodbusRequest instance corresponding to the D-Bus interface <link linkend="gdbus-interface-io-gpiod1-Request.top_of_page">io.gpiod1.Request</link>, if any.
   *
   * Connect to the #GObject::notify signal to get informed of property changes.
   */
  g_object_interface_install_property (iface, g_param_spec_object ("request", "request", "request", GPIODBUS_TYPE_REQUEST, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));

}

/**
 * gpiodbus_object_get_chip:
 * @object: A #GpiodbusObject.
 *
 * Gets the #GpiodbusChip instance for the D-Bus interface <link linkend="gdbus-interface-io-gpiod1-Chip.top_of_page">io.gpiod1.Chip</link> on @object, if any.
 *
 * Returns: (transfer full) (nullable): A #GpiodbusChip that must be freed with g_object_unref() or %NULL if @object does not implement the interface.
 */
GpiodbusChip *gpiodbus_object_get_chip (GpiodbusObject *object)
{
  GDBusInterface *ret;
  ret = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "io.gpiod1.Chip");
  if (ret == NULL)
    return NULL;
  return GPIODBUS_CHIP (ret);
}

/**
 * gpiodbus_object_get_line:
 * @object: A #GpiodbusObject.
 *
 * Gets the #GpiodbusLine instance for the D-Bus interface <link linkend="gdbus-interface-io-gpiod1-Line.top_of_page">io.gpiod1.Line</link> on @object, if any.
 *
 * Returns: (transfer full) (nullable): A #GpiodbusLine that must be freed with g_object_unref() or %NULL if @object does not implement the interface.
 */
GpiodbusLine *gpiodbus_object_get_line (GpiodbusObject *object)
{
  GDBusInterface *ret;
  ret = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "io.gpiod1.Line");
  if (ret == NULL)
    return NULL;
  return GPIODBUS_LINE (ret);
}

/**
 * gpiodbus_object_get_request:
 * @object: A #GpiodbusObject.
 *
 * Gets the #GpiodbusRequest instance for the D-Bus interface <link linkend="gdbus-interface-io-gpiod1-Request.top_of_page">io.gpiod1.Request</link> on @object, if any.
 *
 * Returns: (transfer full) (nullable): A #GpiodbusRequest that must be freed with g_object_unref() or %NULL if @object does not implement the interface.
 */
GpiodbusRequest *gpiodbus_object_get_request (GpiodbusObject *object)
{
  GDBusInterface *ret;
  ret = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "io.gpiod1.Request");
  if (ret == NULL)
    return NULL;
  return GPIODBUS_REQUEST (ret);
}


/**
 * gpiodbus_object_peek_chip: (skip)
 * @object: A #GpiodbusObject.
 *
 * Like gpiodbus_object_get_chip() but doesn't increase the reference count on the returned object.
 *
 * It is not safe to use the returned object if you are on another thread than the one where the #GDBusObjectManagerClient or #GDBusObjectManagerServer for @object is running.
 *
 * Returns: (transfer none) (nullable): A #GpiodbusChip or %NULL if @object does not implement the interface. Do not free the returned object, it is owned by @object.
 */
GpiodbusChip *gpiodbus_object_peek_chip (GpiodbusObject *object)
{
  GDBusInterface *ret;
  ret = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "io.gpiod1.Chip");
  if (ret == NULL)
    return NULL;
  g_object_unref (ret);
  return GPIODBUS_CHIP (ret);
}

/**
 * gpiodbus_object_peek_line: (skip)
 * @object: A #GpiodbusObject.
 *
 * Like gpiodbus_object_get_line() but doesn't increase the reference count on the returned object.
 *
 * It is not safe to use the returned object if you are on another thread than the one where the #GDBusObjectManagerClient or #GDBusObjectManagerServer for @object is running.
 *
 * Returns: (transfer none) (nullable): A #GpiodbusLine or %NULL if @object does not implement the interface. Do not free the returned object, it is owned by @object.
 */
GpiodbusLine *gpiodbus_object_peek_line (GpiodbusObject *object)
{
  GDBusInterface *ret;
  ret = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "io.gpiod1.Line");
  if (ret == NULL)
    return NULL;
  g_object_unref (ret);
  return GPIODBUS_LINE (ret);
}

/**
 * gpiodbus_object_peek_request: (skip)
 * @object: A #GpiodbusObject.
 *
 * Like gpiodbus_object_get_request() but doesn't increase the reference count on the returned object.
 *
 * It is not safe to use the returned object if you are on another thread than the one where the #GDBusObjectManagerClient or #GDBusObjectManagerServer for @object is running.
 *
 * Returns: (transfer none) (nullable): A #GpiodbusRequest or %NULL if @object does not implement the interface. Do not free the returned object, it is owned by @object.
 */
GpiodbusRequest *gpiodbus_object_peek_request (GpiodbusObject *object)
{
  GDBusInterface *ret;
  ret = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "io.gpiod1.Request");
  if (ret == NULL)
    return NULL;
  g_object_unref (ret);
  return GPIODBUS_REQUEST (ret);
}


static void
gpiodbus_object_notify (GDBusObject *object, GDBusInterface *interface)
{
  _ExtendedGDBusInterfaceInfo *info = (_ExtendedGDBusInterfaceInfo *) g_dbus_interface_get_info (interface);
  /* info can be NULL if the other end is using a D-Bus interface we don't know
   * anything about, for example old generated code in this process talking to
   * newer generated code in the other process. */
  if (info != NULL)
    g_object_notify (G_OBJECT (object), info->hyphen_name);
}

/**
 * GpiodbusObjectProxy:
 *
 * The #GpiodbusObjectProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * GpiodbusObjectProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #GpiodbusObjectProxy.
 */

static void
gpiodbus_object_proxy__gpiodbus_object_iface_init (GpiodbusObjectIface *iface G_GNUC_UNUSED)
{
}

static void
gpiodbus_object_proxy__g_dbus_object_iface_init (GDBusObjectIface *iface)
{
  iface->interface_added = gpiodbus_object_notify;
  iface->interface_removed = gpiodbus_object_notify;
}


G_DEFINE_TYPE_WITH_CODE (GpiodbusObjectProxy, gpiodbus_object_proxy, G_TYPE_DBUS_OBJECT_PROXY,
                         G_IMPLEMENT_INTERFACE (GPIODBUS_TYPE_OBJECT, gpiodbus_object_proxy__gpiodbus_object_iface_init)
                         G_IMPLEMENT_INTERFACE (G_TYPE_DBUS_OBJECT, gpiodbus_object_proxy__g_dbus_object_iface_init))

static void
gpiodbus_object_proxy_init (GpiodbusObjectProxy *object G_GNUC_UNUSED)
{
}

static void
gpiodbus_object_proxy_set_property (GObject      *gobject,
  guint         prop_id,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec)
{
  G_OBJECT_WARN_INVALID_PROPERTY_ID (gobject, prop_id, pspec);
}

static void
gpiodbus_object_proxy_get_property (GObject      *gobject,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec)
{
  GpiodbusObjectProxy *object = GPIODBUS_OBJECT_PROXY (gobject);
  GDBusInterface *interface;

  switch (prop_id)
    {
    case 1:
      interface = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "io.gpiod1.Chip");
      g_value_take_object (value, interface);
      break;

    case 2:
      interface = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "io.gpiod1.Line");
      g_value_take_object (value, interface);
      break;

    case 3:
      interface = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "io.gpiod1.Request");
      g_value_take_object (value, interface);
      break;

    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (gobject, prop_id, pspec);
      break;
  }
}

static void
gpiodbus_object_proxy_class_init (GpiodbusObjectProxyClass *klass)
{
  GObjectClass *gobject_class = G_OBJECT_CLASS (klass);

  gobject_class->set_property = gpiodbus_object_proxy_set_property;
  gobject_class->get_property = gpiodbus_object_proxy_get_property;

  g_object_class_override_property (gobject_class, 1, "chip");
  g_object_class_override_property (gobject_class, 2, "line");
  g_object_class_override_property (gobject_class, 3, "request");
}

/**
 * gpiodbus_object_proxy_new:
 * @connection: A #GDBusConnection.
 * @object_path: An object path.
 *
 * Creates a new proxy object.
 *
 * Returns: (transfer full): The proxy object.
 */
GpiodbusObjectProxy *
gpiodbus_object_proxy_new (GDBusConnection *connection,
  const gchar *object_path)
{
  g_return_val_if_fail (G_IS_DBUS_CONNECTION (connection), NULL);
  g_return_val_if_fail (g_variant_is_object_path (object_path), NULL);
  return GPIODBUS_OBJECT_PROXY (g_object_new (GPIODBUS_TYPE_OBJECT_PROXY, "g-connection", connection, "g-object-path", object_path, NULL));
}

/**
 * GpiodbusObjectSkeleton:
 *
 * The #GpiodbusObjectSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * GpiodbusObjectSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #GpiodbusObjectSkeleton.
 */

static void
gpiodbus_object_skeleton__gpiodbus_object_iface_init (GpiodbusObjectIface *iface G_GNUC_UNUSED)
{
}


static void
gpiodbus_object_skeleton__g_dbus_object_iface_init (GDBusObjectIface *iface)
{
  iface->interface_added = gpiodbus_object_notify;
  iface->interface_removed = gpiodbus_object_notify;
}

G_DEFINE_TYPE_WITH_CODE (GpiodbusObjectSkeleton, gpiodbus_object_skeleton, G_TYPE_DBUS_OBJECT_SKELETON,
                         G_IMPLEMENT_INTERFACE (GPIODBUS_TYPE_OBJECT, gpiodbus_object_skeleton__gpiodbus_object_iface_init)
                         G_IMPLEMENT_INTERFACE (G_TYPE_DBUS_OBJECT, gpiodbus_object_skeleton__g_dbus_object_iface_init))

static void
gpiodbus_object_skeleton_init (GpiodbusObjectSkeleton *object G_GNUC_UNUSED)
{
}

static void
gpiodbus_object_skeleton_set_property (GObject      *gobject,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  GpiodbusObjectSkeleton *object = GPIODBUS_OBJECT_SKELETON (gobject);
  GDBusInterfaceSkeleton *interface;

  switch (prop_id)
    {
    case 1:
      interface = g_value_get_object (value);
      if (interface != NULL)
        {
          g_warn_if_fail (GPIODBUS_IS_CHIP (interface));
          g_dbus_object_skeleton_add_interface (G_DBUS_OBJECT_SKELETON (object), interface);
        }
      else
        {
          g_dbus_object_skeleton_remove_interface_by_name (G_DBUS_OBJECT_SKELETON (object), "io.gpiod1.Chip");
        }
      break;

    case 2:
      interface = g_value_get_object (value);
      if (interface != NULL)
        {
          g_warn_if_fail (GPIODBUS_IS_LINE (interface));
          g_dbus_object_skeleton_add_interface (G_DBUS_OBJECT_SKELETON (object), interface);
        }
      else
        {
          g_dbus_object_skeleton_remove_interface_by_name (G_DBUS_OBJECT_SKELETON (object), "io.gpiod1.Line");
        }
      break;

    case 3:
      interface = g_value_get_object (value);
      if (interface != NULL)
        {
          g_warn_if_fail (GPIODBUS_IS_REQUEST (interface));
          g_dbus_object_skeleton_add_interface (G_DBUS_OBJECT_SKELETON (object), interface);
        }
      else
        {
          g_dbus_object_skeleton_remove_interface_by_name (G_DBUS_OBJECT_SKELETON (object), "io.gpiod1.Request");
        }
      break;

    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (gobject, prop_id, pspec);
      break;
  }
}

static void
gpiodbus_object_skeleton_get_property (GObject      *gobject,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec)
{
  GpiodbusObjectSkeleton *object = GPIODBUS_OBJECT_SKELETON (gobject);
  GDBusInterface *interface;

  switch (prop_id)
    {
    case 1:
      interface = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "io.gpiod1.Chip");
      g_value_take_object (value, interface);
      break;

    case 2:
      interface = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "io.gpiod1.Line");
      g_value_take_object (value, interface);
      break;

    case 3:
      interface = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "io.gpiod1.Request");
      g_value_take_object (value, interface);
      break;

    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (gobject, prop_id, pspec);
      break;
  }
}

static void
gpiodbus_object_skeleton_class_init (GpiodbusObjectSkeletonClass *klass)
{
  GObjectClass *gobject_class = G_OBJECT_CLASS (klass);

  gobject_class->set_property = gpiodbus_object_skeleton_set_property;
  gobject_class->get_property = gpiodbus_object_skeleton_get_property;

  g_object_class_override_property (gobject_class, 1, "chip");
  g_object_class_override_property (gobject_class, 2, "line");
  g_object_class_override_property (gobject_class, 3, "request");
}

/**
 * gpiodbus_object_skeleton_new:
 * @object_path: An object path.
 *
 * Creates a new skeleton object.
 *
 * Returns: (transfer full): The skeleton object.
 */
GpiodbusObjectSkeleton *
gpiodbus_object_skeleton_new (const gchar *object_path)
{
  g_return_val_if_fail (g_variant_is_object_path (object_path), NULL);
  return GPIODBUS_OBJECT_SKELETON (g_object_new (GPIODBUS_TYPE_OBJECT_SKELETON, "g-object-path", object_path, NULL));
}

/**
 * gpiodbus_object_skeleton_set_chip:
 * @object: A #GpiodbusObjectSkeleton.
 * @interface_: (nullable): A #GpiodbusChip or %NULL to clear the interface.
 *
 * Sets the #GpiodbusChip instance for the D-Bus interface <link linkend="gdbus-interface-io-gpiod1-Chip.top_of_page">io.gpiod1.Chip</link> on @object.
 */
void gpiodbus_object_skeleton_set_chip (GpiodbusObjectSkeleton *object, GpiodbusChip *interface_)
{
  g_object_set (G_OBJECT (object), "chip", interface_, NULL);
}

/**
 * gpiodbus_object_skeleton_set_line:
 * @object: A #GpiodbusObjectSkeleton.
 * @interface_: (nullable): A #GpiodbusLine or %NULL to clear the interface.
 *
 * Sets the #GpiodbusLine instance for the D-Bus interface <link linkend="gdbus-interface-io-gpiod1-Line.top_of_page">io.gpiod1.Line</link> on @object.
 */
void gpiodbus_object_skeleton_set_line (GpiodbusObjectSkeleton *object, GpiodbusLine *interface_)
{
  g_object_set (G_OBJECT (object), "line", interface_, NULL);
}

/**
 * gpiodbus_object_skeleton_set_request:
 * @object: A #GpiodbusObjectSkeleton.
 * @interface_: (nullable): A #GpiodbusRequest or %NULL to clear the interface.
 *
 * Sets the #GpiodbusRequest instance for the D-Bus interface <link linkend="gdbus-interface-io-gpiod1-Request.top_of_page">io.gpiod1.Request</link> on @object.
 */
void gpiodbus_object_skeleton_set_request (GpiodbusObjectSkeleton *object, GpiodbusRequest *interface_)
{
  g_object_set (G_OBJECT (object), "request", interface_, NULL);
}


/* ------------------------------------------------------------------------
 * Code for ObjectManager client
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:GpiodbusObjectManagerClient
 * @title: GpiodbusObjectManagerClient
 * @short_description: Generated GDBusObjectManagerClient type
 *
 * This section contains a #GDBusObjectManagerClient that uses gpiodbus_object_manager_client_get_proxy_type() as the #GDBusProxyTypeFunc.
 */

/**
 * GpiodbusObjectManagerClient:
 *
 * The #GpiodbusObjectManagerClient structure contains only private data and should only be accessed using the provided API.
 */

/**
 * GpiodbusObjectManagerClientClass:
 * @parent_class: The parent class.
 *
 * Class structure for #GpiodbusObjectManagerClient.
 */

G_DEFINE_TYPE (GpiodbusObjectManagerClient, gpiodbus_object_manager_client, G_TYPE_DBUS_OBJECT_MANAGER_CLIENT)

static void
gpiodbus_object_manager_client_init (GpiodbusObjectManagerClient *manager G_GNUC_UNUSED)
{
}

static void
gpiodbus_object_manager_client_class_init (GpiodbusObjectManagerClientClass *klass G_GNUC_UNUSED)
{
}

/**
 * gpiodbus_object_manager_client_get_proxy_type:
 * @manager: A #GDBusObjectManagerClient.
 * @object_path: The object path of the remote object (unused).
 * @interface_name: (nullable): Interface name of the remote object or %NULL to get the object proxy #GType.
 * @user_data: User data (unused).
 *
 * A #GDBusProxyTypeFunc that maps @interface_name to the generated #GDBusObjectProxy derived and #GDBusProxy derived types.
 *
 * Returns: A #GDBusProxy derived #GType if @interface_name is not %NULL, otherwise the #GType for #GpiodbusObjectProxy.
 */
GType
gpiodbus_object_manager_client_get_proxy_type (GDBusObjectManagerClient *manager G_GNUC_UNUSED, const gchar *object_path G_GNUC_UNUSED, const gchar *interface_name, gpointer user_data G_GNUC_UNUSED)
{
  static gsize once_init_value = 0;
  static GHashTable *lookup_hash;
  GType ret;

  if (interface_name == NULL)
    return GPIODBUS_TYPE_OBJECT_PROXY;
  if (g_once_init_enter (&once_init_value))
    {
      lookup_hash = g_hash_table_new (g_str_hash, g_str_equal);
      g_hash_table_insert (lookup_hash, (gpointer) "io.gpiod1.Chip", (gpointer) (guintptr) (GPIODBUS_TYPE_CHIP_PROXY));
      g_hash_table_insert (lookup_hash, (gpointer) "io.gpiod1.Line", (gpointer) (guintptr) (GPIODBUS_TYPE_LINE_PROXY));
      g_hash_table_insert (lookup_hash, (gpointer) "io.gpiod1.Request", (gpointer) (guintptr) (GPIODBUS_TYPE_REQUEST_PROXY));
      g_once_init_leave (&once_init_value, 1);
    }
  ret = (GType) (guintptr) (g_hash_table_lookup (lookup_hash, interface_name));
  if (ret == (GType) 0)
    ret = G_TYPE_DBUS_PROXY;
  return ret;
}

/**
 * gpiodbus_object_manager_client_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusObjectManagerClientFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates #GDBusObjectManagerClient using gpiodbus_object_manager_client_get_proxy_type() as the #GDBusProxyTypeFunc. See g_dbus_object_manager_client_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gpiodbus_object_manager_client_new_finish() to get the result of the operation.
 *
 * See gpiodbus_object_manager_client_new_sync() for the synchronous, blocking version of this constructor.
 */
void
gpiodbus_object_manager_client_new (
    GDBusConnection        *connection,
    GDBusObjectManagerClientFlags  flags,
    const gchar            *name,
    const gchar            *object_path,
    GCancellable           *cancellable,
    GAsyncReadyCallback     callback,
    gpointer                user_data)
{
  g_async_initable_new_async (GPIODBUS_TYPE_OBJECT_MANAGER_CLIENT, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "flags", flags, "name", name, "connection", connection, "object-path", object_path, "get-proxy-type-func", gpiodbus_object_manager_client_get_proxy_type, NULL);
}

/**
 * gpiodbus_object_manager_client_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gpiodbus_object_manager_client_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with gpiodbus_object_manager_client_new().
 *
 * Returns: (transfer full) (type GpiodbusObjectManagerClient): The constructed object manager client or %NULL if @error is set.
 */
GDBusObjectManager *
gpiodbus_object_manager_client_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return G_DBUS_OBJECT_MANAGER (ret);
  else
    return NULL;
}

/**
 * gpiodbus_object_manager_client_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusObjectManagerClientFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates #GDBusObjectManagerClient using gpiodbus_object_manager_client_get_proxy_type() as the #GDBusProxyTypeFunc. See g_dbus_object_manager_client_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See gpiodbus_object_manager_client_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type GpiodbusObjectManagerClient): The constructed object manager client or %NULL if @error is set.
 */
GDBusObjectManager *
gpiodbus_object_manager_client_new_sync (
    GDBusConnection        *connection,
    GDBusObjectManagerClientFlags  flags,
    const gchar            *name,
    const gchar            *object_path,
    GCancellable           *cancellable,
    GError                **error)
{
  GInitable *ret;
  ret = g_initable_new (GPIODBUS_TYPE_OBJECT_MANAGER_CLIENT, cancellable, error, "flags", flags, "name", name, "connection", connection, "object-path", object_path, "get-proxy-type-func", gpiodbus_object_manager_client_get_proxy_type, NULL);
  if (ret != NULL)
    return G_DBUS_OBJECT_MANAGER (ret);
  else
    return NULL;
}


/**
 * gpiodbus_object_manager_client_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusObjectManagerClientFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like gpiodbus_object_manager_client_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gpiodbus_object_manager_client_new_for_bus_finish() to get the result of the operation.
 *
 * See gpiodbus_object_manager_client_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
gpiodbus_object_manager_client_new_for_bus (
    GBusType                bus_type,
    GDBusObjectManagerClientFlags  flags,
    const gchar            *name,
    const gchar            *object_path,
    GCancellable           *cancellable,
    GAsyncReadyCallback     callback,
    gpointer                user_data)
{
  g_async_initable_new_async (GPIODBUS_TYPE_OBJECT_MANAGER_CLIENT, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "flags", flags, "name", name, "bus-type", bus_type, "object-path", object_path, "get-proxy-type-func", gpiodbus_object_manager_client_get_proxy_type, NULL);
}

/**
 * gpiodbus_object_manager_client_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gpiodbus_object_manager_client_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with gpiodbus_object_manager_client_new_for_bus().
 *
 * Returns: (transfer full) (type GpiodbusObjectManagerClient): The constructed object manager client or %NULL if @error is set.
 */
GDBusObjectManager *
gpiodbus_object_manager_client_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return G_DBUS_OBJECT_MANAGER (ret);
  else
    return NULL;
}

/**
 * gpiodbus_object_manager_client_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusObjectManagerClientFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like gpiodbus_object_manager_client_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See gpiodbus_object_manager_client_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type GpiodbusObjectManagerClient): The constructed object manager client or %NULL if @error is set.
 */
GDBusObjectManager *
gpiodbus_object_manager_client_new_for_bus_sync (
    GBusType                bus_type,
    GDBusObjectManagerClientFlags  flags,
    const gchar            *name,
    const gchar            *object_path,
    GCancellable           *cancellable,
    GError                **error)
{
  GInitable *ret;
  ret = g_initable_new (GPIODBUS_TYPE_OBJECT_MANAGER_CLIENT, cancellable, error, "flags", flags, "name", name, "bus-type", bus_type, "object-path", object_path, "get-proxy-type-func", gpiodbus_object_manager_client_get_proxy_type, NULL);
  if (ret != NULL)
    return G_DBUS_OBJECT_MANAGER (ret);
  else
    return NULL;
}


