// This file is @generated by prost-build.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Package {
    /// All releases of the package
    #[prost(message, repeated, tag = "1")]
    pub releases: ::prost::alloc::vec::Vec<Release>,
    /// Name of package
    #[prost(string, required, tag = "2")]
    pub name: ::prost::alloc::string::String,
    /// Name of repository
    #[prost(string, required, tag = "3")]
    pub repository: ::prost::alloc::string::String,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Release {
    /// Release version
    #[prost(string, required, tag = "1")]
    pub version: ::prost::alloc::string::String,
    /// sha256 checksum of "inner" package tarball
    /// deprecated in favor of outer_checksum
    #[prost(bytes = "vec", required, tag = "2")]
    pub inner_checksum: ::prost::alloc::vec::Vec<u8>,
    /// All dependencies of the release
    #[prost(message, repeated, tag = "3")]
    pub dependencies: ::prost::alloc::vec::Vec<Dependency>,
    /// If set the release is retired, a retired release should only be
    /// resolved if it has already been locked in a project
    #[prost(message, optional, tag = "4")]
    pub retired: ::core::option::Option<RetirementStatus>,
    /// sha256 checksum of outer package tarball
    /// required when encoding but optional when decoding
    #[prost(bytes = "vec", optional, tag = "5")]
    pub outer_checksum: ::core::option::Option<::prost::alloc::vec::Vec<u8>>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct RetirementStatus {
    #[prost(enumeration = "RetirementReason", required, tag = "1")]
    pub reason: i32,
    #[prost(string, optional, tag = "2")]
    pub message: ::core::option::Option<::prost::alloc::string::String>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Dependency {
    /// Package name of dependency
    #[prost(string, required, tag = "1")]
    pub package: ::prost::alloc::string::String,
    /// Version requirement of dependency
    #[prost(string, required, tag = "2")]
    pub requirement: ::prost::alloc::string::String,
    /// If set and true the package is optional (see dependency resolution)
    #[prost(bool, optional, tag = "3")]
    pub optional: ::core::option::Option<bool>,
    /// If set is the OTP application name of the dependency, if not set the
    /// application name is the same as the package name
    #[prost(string, optional, tag = "4")]
    pub app: ::core::option::Option<::prost::alloc::string::String>,
    /// If set, the repository where the dependency is located
    #[prost(string, optional, tag = "5")]
    pub repository: ::core::option::Option<::prost::alloc::string::String>,
}
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
#[repr(i32)]
pub enum RetirementReason {
    RetiredOther = 0,
    RetiredInvalid = 1,
    RetiredSecurity = 2,
    RetiredDeprecated = 3,
    RetiredRenamed = 4,
}
impl RetirementReason {
    /// String value of the enum field names used in the ProtoBuf definition.
    ///
    /// The values are not transformed in any way and thus are considered stable
    /// (if the ProtoBuf definition does not change) and safe for programmatic use.
    pub fn as_str_name(&self) -> &'static str {
        match self {
            Self::RetiredOther => "RETIRED_OTHER",
            Self::RetiredInvalid => "RETIRED_INVALID",
            Self::RetiredSecurity => "RETIRED_SECURITY",
            Self::RetiredDeprecated => "RETIRED_DEPRECATED",
            Self::RetiredRenamed => "RETIRED_RENAMED",
        }
    }
    /// Creates an enum from field names used in the ProtoBuf definition.
    pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
        match value {
            "RETIRED_OTHER" => Some(Self::RetiredOther),
            "RETIRED_INVALID" => Some(Self::RetiredInvalid),
            "RETIRED_SECURITY" => Some(Self::RetiredSecurity),
            "RETIRED_DEPRECATED" => Some(Self::RetiredDeprecated),
            "RETIRED_RENAMED" => Some(Self::RetiredRenamed),
            _ => None,
        }
    }
}
