package main

import (
	"fmt"
	"../../../golang"
	"syscall"
)

// Application test
const (
	SERVER_TYPE  = 18888
	SERVER_INST  = 17
	BUF_SIZE     = 40
)

func wait_for_server(server_srv *tipc.TipcAddr, wait int) (bool) {
	/* wait server up */
	if tipc.Srv_wait(server_srv, wait) == false {
		fmt.Printf("Client: server {%d,%d} not published within %d [s]\n",
			server_srv.Type, server_srv.Instance, wait/1000)
		return false
	}

	return true
}

func main() {
	var server_srv tipc.TipcAddr = tipc.TipcAddr{SERVER_TYPE, SERVER_INST, 0}
	var rc int

	var buf []byte = []byte("Hello World")
	var rbuf []byte = make([]byte, BUF_SIZE)

	fmt.Printf("****** TIPC client (GOLang API) hello world program started ******\n\n");

	var conn, err = tipc.NewConn(syscall.SOCK_RDM)
	if err != nil {
		fmt.Printf("Create socket failed: %s!\n", err)
		return
	}
	defer conn.Close()

	if wait_for_server(&server_srv, 10000) == false {
		return
	}

	if ret := conn.Sendto(buf, &server_srv); ret < 0 {
		fmt.Printf("Client: failed to send\n")
		return
	}

	if ret := conn.Recvfrom(rbuf, nil, nil, &rc); ret <=0 {
		fmt.Printf("Client: unexpected response\n")
		return
	}
	fmt.Printf("Client: received response: %s \n", rbuf)

	fmt.Printf("\n****** TIPC client (GOLang API) hello program finished ******\n");
}

