/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.protocol.state;

import org.signal.libsignal.internal.FilterExceptions;
import org.signal.libsignal.internal.Native;
import org.signal.libsignal.internal.NativeHandleGuard;
import org.signal.libsignal.protocol.InvalidKeyException;
import org.signal.libsignal.protocol.InvalidMessageException;
import org.signal.libsignal.protocol.ecc.ECKeyPair;
import org.signal.libsignal.protocol.ecc.ECPrivateKey;
import org.signal.libsignal.protocol.ecc.ECPublicKey;

public class PreKeyRecord
extends NativeHandleGuard.SimpleOwner {
    @Override
    protected void release(long nativeHandle) {
        Native.PreKeyRecord_Destroy(nativeHandle);
    }

    public PreKeyRecord(int id, ECKeyPair keyPair) {
        super(keyPair.getPublicKey().guardedMap(publicKeyHandle -> keyPair.getPrivateKey().guardedMap(privateKeyHandle -> Native.PreKeyRecord_New(id, publicKeyHandle, privateKeyHandle))));
    }

    public PreKeyRecord(byte[] serialized) throws InvalidMessageException {
        super(FilterExceptions.filterExceptions(InvalidMessageException.class, () -> Native.PreKeyRecord_Deserialize(serialized)));
    }

    public int getId() {
        return FilterExceptions.filterExceptions(() -> this.guardedMapChecked(Native::PreKeyRecord_GetId));
    }

    public ECKeyPair getKeyPair() throws InvalidKeyException {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            ECKeyPair eCKeyPair = FilterExceptions.filterExceptions(InvalidKeyException.class, () -> {
                ECPublicKey publicKey = new ECPublicKey(Native.PreKeyRecord_GetPublicKey(guard.nativeHandle()));
                ECPrivateKey privateKey = new ECPrivateKey(Native.PreKeyRecord_GetPrivateKey(guard.nativeHandle()));
                return new ECKeyPair(publicKey, privateKey);
            });
            return eCKeyPair;
        }
    }

    public byte[] serialize() {
        return FilterExceptions.filterExceptions(() -> this.guardedMapChecked(Native::PreKeyRecord_GetSerialized));
    }
}

