# Contributing to Neon

Neon welcomes contribution from everyone. Here are some resources to help you join us!

## Contributions

### Issue reports

We welcome issues and aim to keep the barrier low. Just [file a GitHub issue](https://github.com/neon-bindings/neon/issues)
like normal---we don't require issue templates or have any particular process.

That said, the more information you can provide to help us reproduce your issue, the better!

### Requests For Comments

If you would like to propose a design change or new feature for the Neon API or the `neon` command-line tool,
we encourage you to [submit an RFC](https://github.com/neon-bindings/rfcs)!

The [RFC process](https://github.com/neon-bindings/rfcs#the-process) has a little more overhead than
filing an issue, but it's for the goal of allowing the Neon community to have a chance to vet
design ideas and reach consensus. And even at that, we've deliberately kept the [RFC template](https://github.com/neon-bindings/rfcs/blob/main/0000-template.md)
simple and open-ended.

### Good first bugs

Search our issue tracker for anything labeled **[beginner friendly](https://github.com/neon-bindings/neon/issues?q=is%3Aissue+is%3Aopen+label%3A%22beginner+friendly%22)**.

**We are here to help you!** Join our Slack and send an at-mention to **@dherman** and we'll happily arrange
to help you get going and mentor you as much as you feel would be helpful.

## Conduct

We follow the [Contributor Covenant Code of Conduct](https://www.contributor-covenant.org/version/1/4/code-of-conduct.html).
The maintainers of Neon personally promise to work actively to uphold that code of conduct.
We aim to foster a community that is welcoming, inclusive, empathetic, and kind.
If you share those goals and want to have a ton of fun playing with Rust and JS, we hope you will come be a part of our community!

## License

Unless you explicitly state otherwise, any contribution intentionally submitted for inclusion in the work by you, as defined in the Apache-2.0 license, shall be dual licensed as described in the [README](README.md), without any additional terms or conditions.

## Communication

* Slack: <https://rust-bindings.slack.com> -- get an invite from [the Slackin app](https://rust-bindings-slackin.herokuapp.com)
