/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.SQLException;
import oracle.sql.CharacterBuffer;
import oracle.sql.CharacterRepConstants;
import oracle.sql.CharacterSet;
import oracle.sql.CharacterWalker;

class CharacterSetAL16UTF16
extends CharacterSet
implements CharacterRepConstants {
    CharacterSetAL16UTF16(int n) {
        super(n);
        this.rep = 4;
    }

    public byte[] convert(String string) throws SQLException {
        return CharacterSet.stringToAL16UTF16Bytes(string);
    }

    public byte[] convert(CharacterSet characterSet, byte[] byArray, int n, int n2) throws SQLException {
        byte[] byArray2;
        if (characterSet.rep == 4) {
            byArray2 = CharacterSet.useOrCopy(byArray, n, n2);
        } else {
            String string = characterSet.toString(byArray, n, n2);
            byArray2 = CharacterSet.stringToAL16UTF16Bytes(string);
        }
        return byArray2;
    }

    public byte[] convertWithReplacement(String string) {
        return CharacterSet.stringToAL16UTF16Bytes(string);
    }

    int decode(CharacterWalker characterWalker) throws SQLException {
        byte[] byArray = characterWalker.bytes;
        int n = characterWalker.next;
        int n2 = characterWalker.end;
        if (n + 2 >= n2) {
            CharacterSet.failUTFConversion();
        }
        byte by = byArray[n++];
        byte by2 = byArray[n++];
        int n3 = by << 8 & 0xFF00 | by2;
        characterWalker.next = n;
        return n3;
    }

    void encode(CharacterBuffer characterBuffer, int n) throws SQLException {
        if (n > 65535) {
            CharacterSet.failUTFConversion();
        } else {
            CharacterSet.need(characterBuffer, 2);
            characterBuffer.bytes[characterBuffer.next++] = (byte)(n >> 8 & 0xFF);
            characterBuffer.bytes[characterBuffer.next++] = (byte)(n & 0xFF);
        }
    }

    public boolean isConvertibleFrom(CharacterSet characterSet) {
        boolean bl = characterSet.rep <= 1024;
        return bl;
    }

    public boolean isLossyFrom(CharacterSet characterSet) {
        return characterSet.isUnicode() ^ true;
    }

    public boolean isUnicode() {
        return true;
    }

    public String toString(byte[] byArray, int n, int n2) throws SQLException {
        return this.toStringWithReplacement(byArray, n, n2);
    }

    public String toStringWithReplacement(byte[] byArray, int n, int n2) {
        char[] cArray = CharacterSet.AL16UTF16BytesToJavaChars(byArray, n, n2);
        return new String(cArray);
    }
}

