/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.SQLException;
import oracle.sql.CharacterBuffer;
import oracle.sql.CharacterSet;
import oracle.sql.CharacterSetWithConverter;
import oracle.sql.CharacterWalker;
import oracle.sql.converter.CharacterConverter;
import oracle.sql.converter.CharacterConverterSJIS;

class CharacterSetSJIS
extends CharacterSetWithConverter {
    static final String CHAR_CONV_SUPERCLASS_NAME = "oracle.sql.converter.CharacterConverterSJIS";
    static final short MAX_7BIT = 127;
    static final short MIN_8BIT_SB = 161;
    static final short MAX_8BIT_SB = 223;
    static Class m_charConvSuperclass;

    CharacterSetSJIS(int n, CharacterConverterSJIS characterConverterSJIS) {
        super(n, characterConverterSJIS);
    }

    int decode(CharacterWalker characterWalker) throws SQLException {
        int n = characterWalker.bytes[characterWalker.next] & 0xFF;
        ++characterWalker.next;
        if (n > 223 || n > 127 && n < 161) {
            if (characterWalker.bytes.length > characterWalker.next) {
                n = n << 8 | characterWalker.bytes[characterWalker.next];
                ++characterWalker.next;
            } else {
                throw new SQLException("destination too small");
            }
        }
        return n;
    }

    void encode(CharacterBuffer characterBuffer, int n) throws SQLException {
        int n2 = 0;
        int n3 = 1;
        while (n >> n2 != 0) {
            n2 = (short)(n2 + 8);
            n3 = (short)(n3 + 1);
        }
        CharacterSet.need(characterBuffer, n3);
        while (n2 >= 0) {
            characterBuffer.bytes[characterBuffer.next++] = (byte)(n >> n2 & 0xFF);
            n2 = (short)(n2 - 8);
        }
    }

    static CharacterSetSJIS getInstance(int n, CharacterConverter characterConverter) {
        if (characterConverter.getGroupId() == 4) {
            return new CharacterSetSJIS(n, (CharacterConverterSJIS)characterConverter);
        }
        return null;
    }
}

