/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.app.data;

import com.jgoodies.common.base.Strings;
import com.jgoodies.common.base.SystemUtils;
import com.jgoodies.common.internal.DateUtils;
import java.text.DateFormat;
import java.text.ParseException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Locale;

public final class DataConversions {
    private static final DateFormat DATE_FORMAT = DateFormat.getDateInstance(3, Locale.GERMANY);
    private static final DateFormat DATE_TIME_FORMAT = DateFormat.getDateTimeInstance(3, 3, Locale.GERMANY);

    private DataConversions() {
    }

    public static boolean toBoolean(String encodedBoolean) {
        return encodedBoolean.equalsIgnoreCase("true");
    }

    public static int toInt(String encodedInt) {
        return Integer.parseInt(encodedInt);
    }

    public static LocalDate toDate(String encodedDate) {
        if (Strings.isBlank(encodedDate)) {
            return null;
        }
        boolean plus = encodedDate.startsWith("+");
        boolean minus = encodedDate.startsWith("-");
        if (plus || minus) {
            int offsetDays = DataConversions.toInt(encodedDate.substring(1));
            return LocalDate.now().plusDays(offsetDays * (plus ? 1 : -1));
        }
        try {
            return DateUtils.toLocalDate(DATE_FORMAT.parse(encodedDate));
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static LocalDateTime toDateTime(String encodedDateTime) {
        if (Strings.isBlank(encodedDateTime)) {
            return null;
        }
        boolean plus = encodedDateTime.startsWith("+");
        boolean minus = encodedDateTime.startsWith("-");
        if (plus || minus) {
            int spaceIndex = encodedDateTime.indexOf(32);
            String encodedInt = encodedDateTime.substring(1, spaceIndex);
            int offsetDays = DataConversions.toInt(encodedInt);
            LocalDate date = LocalDate.now().plusDays(offsetDays * (plus ? 1 : -1));
            String encodedDate = DATE_FORMAT.format(DateUtils.toDate(date));
            String encodedTime = encodedDateTime.substring(spaceIndex + 1);
            String separator = SystemUtils.IS_JAVA_8 ? " " : ", ";
            return DataConversions.toDateTime(encodedDate + separator + encodedTime);
        }
        try {
            return DateUtils.toLocalDateTime(DATE_TIME_FORMAT.parse(encodedDateTime));
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static LocalDate getRelativeDate(int offset) {
        return LocalDate.now().plusDays(offset);
    }

    public static LocalTime toTime(String encodedTime) {
        return LocalTime.parse(encodedTime);
    }
}

