/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.app.gui.basics.icon.windows;

import com.jgoodies.common.base.Preconditions;
import com.jgoodies.common.jsdl.icon.DynamicIconValue;
import com.jgoodies.common.jsdl.icon.GlyphIcon;
import com.jgoodies.common.jsdl.icon.GlyphIconValue;
import com.jgoodies.common.swing.ScreenScaling;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontFormatException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import javax.swing.Icon;

public enum WindowsIcon implements GlyphIconValue,
DynamicIconValue
{
    ACCEPT('\ue8fb'),
    ACCOUNTS('\ue910'),
    ACTION_CENTER('\ue91c'),
    ACTION_CENTER_NOTIFICATION('\ue7e7'),
    ADD('\ue710'),
    ADD_TO('\uecc8'),
    AIRPLANE('\ue709'),
    ALL_APPS('\ue71d'),
    APPS('\ued35'),
    ASTERISK('\uea38'),
    ATTACH('\ue723'),
    BACK('\ue72b'),
    BANK('\ue825'),
    BARCODE_SCANNER('\uec5a'),
    BROOM('\uea99'),
    BULLETED_LIST('\ue8fd'),
    BUS('\ue806'),
    CALCULATOR('\ue8ef'),
    CALENDAR('\ue787'),
    CALENDAR_DAY('\ue8bf'),
    CALENDAR_WEEK('\ue8c0'),
    CANCEL('\ue711'),
    CAR('\ue804'),
    CHECKED_LIST('\ue133'),
    CHECK_MARK('\ue73e'),
    CHEVRON_DOWN('\ue70d'),
    CHEVRON_DOWN_MED('\ue972'),
    CHEVRON_DOWN_SMALL('\ue96e'),
    CHEVRON_LEFT('\ue76b'),
    CHEVRON_RIGHT('\ue76c'),
    CHEVRON_UP('\ue70e'),
    CHEVRON_UP_MED('\ue971'),
    CHEVRON_UP_SMALL('\ue96d'),
    CLOSE_PANE('\ue89f'),
    CODE('\ue943'),
    COLLAPSE_CONTENT('\uf165'),
    COLLAPSE_CONTENT_SINGLE('\uf166'),
    COLOR('\ue790'),
    COMMENT('\ue90a'),
    COMMUNICATIONS('\ue95a'),
    COMPLETED('\ue930'),
    COMPONENT('\ue950'),
    CONTACT('\ue77b'),
    CONTACT2('\ue8d4'),
    CONTACT_INFO('\ue779'),
    DATE_TIME('\uec92'),
    DELETE('\ue74d'),
    DEVELOPER_TOOLS('\uec7a'),
    DEVICE_MONITOR_NO_PIC('\ue7fb'),
    DIAGNOSTIC('\ue9d9'),
    DIALPAD('\ue75f'),
    DISLIKE('\ue8e0'),
    DOCUMENT('\ue8a5'),
    DOWNLOAD('\ue896'),
    DRAW('\uec87'),
    EAR('\uf270'),
    EDIT('\ue70f'),
    ERROR('\ue783'),
    ERROR_BADGE('\uea39'),
    EXPLORE_CONTENT('\ueccd'),
    EXPLORE_CONTENT_SINGLE('\uf164'),
    FAVICON('\ue737'),
    FAVORITE_STAR('\ue734'),
    FAVORITE_STAR_FILL('\ue735'),
    FERRY('\ue7e3'),
    FILTER('\ue71c'),
    FLAG('\ue7c1'),
    FLASHLIGHT('\ue754'),
    FORWARD('\ue72a'),
    FULL_CIRCLE_MASK('\ue91f'),
    GLOBAL_NAV_BUTTON('\ue700'),
    GLOBE('\ue774'),
    GROUP('\ue902'),
    GROUP_LIST('\uf168'),
    HEALTH('\ue95e'),
    HELP('\ue897'),
    HISTORY('\ue81c'),
    HOME('\ue80f'),
    INFO('\ue946'),
    INTERNET_SHARING('\ue704'),
    IOT('\uf22c'),
    KEYBOARD_12KEY('\uf26c'),
    KEYBOARD_ONE_HANDED('\ued4c'),
    LED_LIGHT('\uef81'),
    LIBRARY('\ue8f1'),
    LIGHT('\ue793'),
    LIKE('\ue8e1'),
    LIST('\uea37'),
    MAG_STRIPE_READER('\uec5c'),
    MAIL('\ue715'),
    MAIL_FORWARD('\ue89c'),
    MAP_PIN('\ue707'),
    MESSAGE('\ue8bd'),
    MORE('\ue712'),
    MULTITASK_EXPANDED('\ueb91'),
    NEW_WINDOW('\ue78b'),
    OEM('\ue74c'),
    OPEN_FILE('\ue1a5'),
    OPEN_IN_NEW_WINDOW('\ue8a7'),
    OPEN_PANE('\ue127'),
    PACKAGE('\ue7b8'),
    PAGE('\ue7c3'),
    PEOPLE('\ue716'),
    PERMISSIONS('\ue8d7'),
    PIE_SINGLE('\ueb05'),
    PIN('\ue718'),
    PHONE('\ue717'),
    PLAP('\uec19'),
    PLAY('\ue768'),
    POWER_BUTTON('\ue7e8'),
    PRINT('\ue749'),
    PROGRESS_RING_DOTS('\uf16a'),
    PROJECT('\uebc6'),
    PROJECTOR('\ue95d'),
    PUZZLE('\uea86'),
    RECENT('\ue823'),
    REFRESH('\ue72c'),
    RELATIONSHIP('\uf003'),
    REMOVE('\ue738'),
    REMOVE_FROM('\uecc9'),
    REPAIR('\ue90f'),
    REPORT_DOCUMENT('\ue9f9'),
    RINGER('\uea8f'),
    RINGER_SILENT('\ue7ed'),
    SAVE('\ue74e'),
    SAVE_AS('\ue792'),
    SAVE_COPY('\uea35'),
    SCAN('\ue8fe'),
    SEARCH('\ue721'),
    SEARCH_MEDIUM('\uf78b'),
    SETTINGS('\ue713'),
    SHARE('\ue72d'),
    SIGNAL_NOT_CONNECTED('\ue871'),
    SHOP('\ue719'),
    SHOPPING_CART('\ue7bf'),
    SORT('\ue8cb'),
    START_POINT('\ue819'),
    STOP('\ue71a'),
    SYSTEM('\ue770'),
    TAG('\ue8ec'),
    TILES('\ueca5'),
    TRACKERS('\ueadf'),
    TRAIN('\ue7c0'),
    TRIM('\ue78a'),
    UP('\ue74a'),
    VIEW('\ue890'),
    VIEW_ALL('\ue8a9'),
    WALK('\ue805'),
    WARNING('\ue7ba'),
    WHEEL('\uee94'),
    WORK('\ue821');

    private static final int DEFAULT_SIZE = 14;
    private static final String FONT_PATH = "com/jgoodies/app/gui/basics/icon/windows/SegoeIcons.ttf";
    private static Font segoeFluentIconsFont;
    private final char code;

    private static Font getSegoeFluentIconsFont() {
        if (segoeFluentIconsFont == null) {
            try (InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(FONT_PATH);){
                segoeFluentIconsFont = Font.createFont(0, stream);
            }
            catch (FontFormatException | IOException ffe) {
                throw new RuntimeException(ffe);
            }
        }
        return segoeFluentIconsFont;
    }

    private WindowsIcon(char code) {
        this.code = code;
    }

    public static WindowsIcon of(String familyNameSize) {
        String[] split = familyNameSize.split(":");
        Preconditions.checkArgument(split.length == 2, "The required format is \"windows:<name>\".");
        String family = split[0].toLowerCase(Locale.ENGLISH);
        Preconditions.checkArgument(family.equals("windows"), "The family must be \"windows\".");
        String name = split[1].toUpperCase(Locale.ENGLISH).replace('-', '_');
        return WindowsIcon.valueOf(name);
    }

    @Override
    public Font getBaseFont() {
        return WindowsIcon.getSegoeFluentIconsFont();
    }

    @Override
    public char getCode() {
        return this.code;
    }

    @Override
    public String getName() {
        return this.name().toLowerCase(Locale.ENGLISH).replace('_', '-');
    }

    @Override
    public Icon toIcon() {
        return new GlyphIcon((GlyphIconValue)this, ScreenScaling.toPhysical(14));
    }

    public Icon toIcon(Color color) {
        return new GlyphIcon(this, ScreenScaling.toPhysical(14), color);
    }

    @Override
    public Icon toIcon(int effectiveSize, Color color) {
        return new GlyphIcon(this, ScreenScaling.toPhysical(effectiveSize), color);
    }
}

