/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.dialogs.basics;

import com.jgoodies.application.Application;
import com.jgoodies.common.base.Preconditions;
import com.jgoodies.common.base.Strings;
import com.jgoodies.common.internal.ResourceBundleAccessor;
import com.jgoodies.common.resource.StringAndIconResourceAccessor;
import com.jgoodies.dialogs.basics.BasicDialogResources;
import com.jgoodies.dialogs.basics.BasicVerification;
import com.jgoodies.dialogs.basics.MessagePaneBuilder;
import com.jgoodies.dialogs.basics.ReturnValue;
import com.jgoodies.dialogs.basics.file.DirectoryChooserView;
import com.jgoodies.dialogs.basics.internal.BasicPreconditions;
import com.jgoodies.dialogs.core.CommandValue;
import com.jgoodies.dialogs.core.PreferredWidth;
import com.jgoodies.dialogs.core.Verification;
import com.jgoodies.dialogs.core.internal.AbstractPaneBuilder;
import com.jgoodies.dialogs.core.pane.task.TaskPane;
import com.jgoodies.dialogs.core.pane.task.TaskPaneBuilder;
import com.jgoodies.dialogs.core.pane.task.TaskPaneVisualConfiguration;
import com.jgoodies.dialogs.core.pane.task.TaskPaneWorker;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileSystemView;

public final class StandardPaneBuilder
extends AbstractPaneBuilder<TaskPane, StandardPaneBuilder> {
    private StringAndIconResourceAccessor resources;

    public StandardPaneBuilder resources(StringAndIconResourceAccessor resources) {
        this.resources = resources;
        return this;
    }

    public StandardPaneBuilder resources(ResourceBundle bundle) {
        this.resources = new ResourceBundleAccessor(bundle);
        return this;
    }

    public boolean showDeleteConfirmation(String objectName, Object ... args) {
        this.setTitleKeyIfNoCustomTitle("deleteConfirmation.defaultTitle");
        return this.showDialogReturnProceed(this.buildDeleteConfirmation(objectName, args));
    }

    public ReturnValue<File> showDirectoryChooser(String optionalMainInstructionText) {
        FileSystemView fileSystemView = new JFileChooser().getFileSystemView();
        DirectoryChooserView view = new DirectoryChooserView(fileSystemView);
        return this.showDirectoryChooser(optionalMainInstructionText, view, FileMode.REJECT_NON_FILE_SYSTEM_WITH_MESSAGE);
    }

    public ReturnValue<File> showDirectoryChooser(String optionalMainInstructionText, DirectoryChooserView directoryChooserView, FileMode fileAcceptanceMode) {
        Preconditions.checkNotNull(directoryChooserView, "The %s must not be null.", "directory chooser view");
        String mainInstructionText = optionalMainInstructionText != null ? optionalMainInstructionText : this.getI15dString("directoryChooser.defaultMainInstruction", new Object[0]);
        TaskPane pane = ((TaskPaneBuilder)new TaskPaneBuilder().mainInstructionText(mainInstructionText, new Object[0]).mainInstructionLabelsContent(true).content(directoryChooserView.buildContent()).commitCommands(CommandValue.OK, CommandValue.CANCEL).preferredWidth(PreferredWidth.MEDIUM)).build();
        this.showDialog(pane);
        if (pane.isCancelled() || directoryChooserView.isSelectionEmpty() || directoryChooserView.isSelectionValid() || fileAcceptanceMode == FileMode.ACCEPT_ALL) {
            return new ReturnValue<File>(pane.isCancelled(), directoryChooserView.getSelectedDirectory());
        }
        if (fileAcceptanceMode == FileMode.RETURN_NULL_FOR_NON_FILE_SYSTEM) {
            return new ReturnValue<Object>(pane.isCancelled(), null);
        }
        ((MessagePaneBuilder)new MessagePaneBuilder().owner(this.getOwner())).mainInstructionText(this.getI15dString("directoryChooser.notInFileSystem", new Object[0]), directoryChooserView.getSelectedDirectorySystemDisplayName()).showInformation();
        return new ReturnValue<Object>(pane.isCancelled(), null);
    }

    public boolean showExitConfirmation() {
        return this.showExitConfirmation(BasicVerification.CONFIRM_EXIT);
    }

    public boolean showExitConfirmation(Verification verification) {
        this.setTitleKeyCheckNoCustomTitle("exitConfirmation.title", "the exit confirmation.");
        if (verification.isSelected()) {
            return true;
        }
        return this.showDialogReturnProceed(this.buildExitConfirmation(verification));
    }

    public void showExitingInformation() {
        this.showExitingInformation(null);
    }

    public void showExitingInformation(TaskPaneWorker<?, ?> worker) {
        this.setTitleKeyCheckNoCustomTitle("exitingInformation.title", "the exiting information.");
        TaskPane pane = this.buildExitingInformation();
        if (worker != null) {
            worker.setTaskPane(pane);
            worker.execute();
        }
        this.showDialog(pane);
    }

    public void showFileAndFolderRenameError(String filename, Object ... args) {
        this.setTitleKeyIfNoCustomTitle("fileAndFolderRenameError.defaultTitle");
        this.showDialog(this.buildFileAndFolderRenameError(filename, args));
    }

    public boolean showRiskyDeleteConfirmation(String objectName, Object ... args) {
        this.setTitleKeyIfNoCustomTitle("riskyDeleteConfirmation.defaultTitle");
        return this.showDialogReturnProceed(this.buildRiskyDeleteConfirmation(objectName, args));
    }

    public CommandValue showSaveChangesConfirmation() {
        this.setTitleKeyIfNoCustomTitle("saveChangesConfirmation.defaultTitle");
        return (CommandValue)this.showDialogReturnCommitValue(this.buildSaveChangesConfirmation());
    }

    public CommandValue showSaveChangesConfirmation(String objectName, Object ... args) {
        this.setTitleKeyIfNoCustomTitle("saveChangesConfirmation.defaultTitle");
        return (CommandValue)this.showDialogReturnCommitValue(this.buildSaveChangesConfirmation(objectName, args));
    }

    public CommandValue showSaveAllChangesConfirmation(int numberOfUnsavedDocuments) {
        this.setTitleKeyIfNoCustomTitle("saveAllChangesConfirmation.defaultTitle");
        return (CommandValue)this.showDialogReturnCommitValue(this.buildSaveAllChangesConfirmation(numberOfUnsavedDocuments));
    }

    public CommandValue showReviewAllChangesConfirmation(int numberOfUnsavedDocuments) {
        this.setTitleKeyIfNoCustomTitle("reviewAllChangesConfirmation.defaultTitle");
        return (CommandValue)this.showDialogReturnCommitValue(this.buildReviewAllChangesConfirmation(numberOfUnsavedDocuments));
    }

    public void showNotYetAvailable(String optionalCommandName) {
        this.showNotYetAvailable(optionalCommandName, null);
    }

    public void showNotYetAvailable(String optionalCommandName, String optionalDetailsText) {
        this.setTitleKeyIfNoCustomTitle("notYetAvailable.defaultTitle");
        BasicPreconditions.checkCommandName(optionalCommandName);
        BasicPreconditions.checkNullOrTrimmedNotEmpty(optionalDetailsText, "details text");
        String mainInstruction = optionalCommandName == null ? this.getI15dString("notYetAvailable.mainInstruction", new Object[0]) : this.getI15dString("notYetAvailable.mainInstruction.commandName", optionalCommandName);
        String detailsText = optionalDetailsText == null ? this.getI15dString("notYetAvailable.defaultDetailsText", new Object[0]) : optionalDetailsText;
        ((TaskPaneBuilder)((TaskPaneBuilder)((TaskPaneBuilder)new TaskPaneBuilder().owner(this.getOwner())).title(this.getTitle(), new Object[0])).mainInstructionIcon(this.getI15dIcon("notYetAvailable.mainIcon")).mainInstructionText(mainInstruction, new Object[0]).contentText(detailsText, new Object[0]).commitCommands(CommandValue.CLOSE).preferredWidth(PreferredWidth.MEDIUM)).showDialog();
    }

    public void showNotYetImplemented(String optionalCommandName, String optionalDetailsText) {
        this.setTitleKeyIfNoCustomTitle("notYetImplemented.defaultTitle");
        BasicPreconditions.checkCommandName(optionalCommandName);
        BasicPreconditions.checkNullOrTrimmedNotEmpty(optionalDetailsText, "details text");
        String mainInstruction = optionalCommandName == null ? this.getI15dString("notYetImplemented.mainInstruction", new Object[0]) : this.getI15dString("notYetImplemented.mainInstruction.commandName", optionalCommandName);
        String detailsText = optionalDetailsText == null ? this.getI15dString("notYetImplemented.defaultDetailsText", new Object[0]) : optionalDetailsText;
        ((TaskPaneBuilder)((TaskPaneBuilder)((TaskPaneBuilder)new TaskPaneBuilder().owner(this.getOwner())).title(this.getTitle(), new Object[0])).mainInstructionIcon(this.getI15dIcon("notYetImplemented.mainIcon")).mainInstructionText(mainInstruction, new Object[0]).contentText(detailsText, new Object[0]).commitCommands(CommandValue.CLOSE).preferredWidth(PreferredWidth.MEDIUM)).showDialog();
    }

    public void showNotYetTestedInformation(String optionalCommandName, String optionalDetailsText) {
        this.setTitleKeyIfNoCustomTitle("notYetTestedInformation.defaultTitle");
        BasicPreconditions.checkCommandName(optionalCommandName);
        BasicPreconditions.checkNullOrTrimmedNotEmpty(optionalDetailsText, "details text");
        String mainInstruction = optionalCommandName == null ? this.getI15dString("notYetTestedInformation.mainInstruction", new Object[0]) : this.getI15dString("notYetTestedInformation.mainInstruction.commandName", optionalCommandName);
        String detailsText = optionalDetailsText == null ? this.getI15dString("notYetTestedInformation.defaultDetailsText", new Object[0]) : optionalDetailsText;
        ((TaskPaneBuilder)((TaskPaneBuilder)((TaskPaneBuilder)new TaskPaneBuilder().owner(this.getOwner())).title(this.getTitle(), new Object[0])).mainInstructionIcon(this.getI15dIcon("notYetTestedInformation.mainIcon")).mainInstructionText(mainInstruction, new Object[0]).contentText(detailsText, new Object[0]).commitCommands(CommandValue.PROCEED).preferredWidth(PreferredWidth.MEDIUM)).showDialog();
    }

    public boolean showNotYetTestedConfirmation(String optionalCommandName, String optionalDetailsText) {
        this.setTitleKeyIfNoCustomTitle("notYetTestedConfirmation.defaultTitle");
        BasicPreconditions.checkCommandName(optionalCommandName);
        BasicPreconditions.checkNullOrTrimmedNotEmpty(optionalDetailsText, "details text");
        String mainInstruction = optionalCommandName == null ? this.getI15dString("notYetTestedConfirmation.mainInstruction", new Object[0]) : this.getI15dString("notYetTestedConfirmation.mainInstruction.commandName", optionalCommandName);
        String detailsText = optionalDetailsText == null ? this.getI15dString("notYetTestedConfirmation.defaultDetailsText", new Object[0]) : optionalDetailsText;
        return ((MessagePaneBuilder)((MessagePaneBuilder)new MessagePaneBuilder().owner(this.getOwner())).title(this.getTitle(), new Object[0])).mainInstructionText(mainInstruction, new Object[0]).supplementalInstructionText(detailsText, new Object[0]).showRiskyActionConfirmation();
    }

    public TaskPane buildExitConfirmation(Verification verification) {
        return new MessagePaneBuilder().mainInstructionText(this.getI15dString("exitConfirmation.mainInstruction", new Object[0]), new Object[0]).verification(verification).buildConfirmation();
    }

    public TaskPane buildExitingInformation() {
        return new MessagePaneBuilder().mainInstructionText(this.getI15dString("exitingInformation.mainInstruction", new Object[0]), new Object[0]).commandContentVisible(false).cancelAllowed(false).buildInformation();
    }

    public TaskPane buildDeleteConfirmation(String objectName, Object ... args) {
        BasicPreconditions.checkMandatoryObjectName(objectName);
        String formattedObjectName = Strings.get(objectName, args);
        return new MessagePaneBuilder().mainInstructionText(this.getI15dString("deleteConfirmation.mainInstruction", new Object[0]), formattedObjectName.trim()).buildConfirmation();
    }

    public TaskPane buildFileAndFolderRenameError(String filename, Object ... args) {
        BasicPreconditions.checkMandatoryObjectName(filename);
        String formattedObjectName = Strings.get(filename, args);
        return new MessagePaneBuilder().mainInstructionText(this.getI15dString("fileAndFolderRenameError.mainInstruction", new Object[0]), formattedObjectName.trim()).buildConfirmation();
    }

    public TaskPane buildRiskyDeleteConfirmation(String objectName, Object ... args) {
        BasicPreconditions.checkMandatoryObjectName(objectName);
        String formattedObjectName = Strings.get(objectName, args);
        return new MessagePaneBuilder().mainInstructionText(this.getI15dString("riskyDeleteConfirmation.mainInstruction", new Object[0]), formattedObjectName.trim()).buildRiskyActionConfirmation();
    }

    public TaskPane buildSaveChangesConfirmation() {
        return new MessagePaneBuilder().mainInstructionText(this.getI15dString("saveChangesConfirmation.mainInstruction", new Object[0]), new Object[0]).buildConfirmation(CommandValue.SAVE, CommandValue.DONT_SAVE, CommandValue.CANCEL);
    }

    public TaskPane buildSaveChangesConfirmation(String objectName, Object ... args) {
        BasicPreconditions.checkMandatoryObjectName(objectName);
        String formattedObjectName = Strings.get(objectName, args);
        return new MessagePaneBuilder().mainInstructionText(this.getI15dString("saveChangesConfirmation.mainInstruction.objectName", new Object[0]), formattedObjectName.trim()).buildConfirmation(CommandValue.SAVE, CommandValue.DONT_SAVE, CommandValue.CANCEL);
    }

    public TaskPane buildSaveAllChangesConfirmation(int numberOfUnsavedDocuments) {
        Preconditions.checkArgument(numberOfUnsavedDocuments > 1, "The number of unsaved documents must be larger than 1.");
        TaskPane pane = ((TaskPaneBuilder)new TaskPaneBuilder().mainInstructionText(this.getI15dString("saveAllChangesConfirmation.mainInstruction", new Object[0]), numberOfUnsavedDocuments).addCommandLink(CommandValue.SAVE_ALL_CHANGES, this.getI15dString("saveAllChanges.description", new Object[0])).addCommandLink(CommandValue.DISCARD_ALL_CHANGES, this.getI15dString("discardAllChanges.description", new Object[0])).addCommandLink(CommandValue.REVIEW_CHANGES, this.getI15dString("reviewChanges.description", new Object[0])).commitCommands(CommandValue.CANCEL).preferredWidth(PreferredWidth.MEDIUM)).build();
        ((TaskPaneVisualConfiguration)pane.getVisualConfiguration()).setMarginHeaderBottom(0);
        ((TaskPaneVisualConfiguration)pane.getVisualConfiguration()).setMarginContentTop(0);
        return pane;
    }

    public TaskPane buildReviewAllChangesConfirmation(int numberOfUnsavedDocuments) {
        Preconditions.checkArgument(numberOfUnsavedDocuments > 1, "The number of unsaved documents must be larger than 1.");
        return new MessagePaneBuilder().mainInstructionText(this.getI15dString("reviewAllChangesConfirmation.mainInstruction", new Object[0]), numberOfUnsavedDocuments).supplementalInstructionText(this.getI15dString("reviewAllChangesConfirmation.supplementalInstruction", new Object[0]), new Object[0]).buildConfirmation(CommandValue.REVIEW_CHANGES, CommandValue.DISCARD_CHANGES, CommandValue.CANCEL);
    }

    @Override
    protected String getTitle() {
        if (this.title == null) {
            this.title = this.getResources().getString("application.title", new Object[0]);
        }
        return this.title;
    }

    private void setTitleKeyCheckNoCustomTitle(String key, String description) {
        if (this.hasTitle()) {
            throw new IllegalArgumentException("You must not set a title for " + description);
        }
        this.title(this.getI15dString(key, new Object[0]), new Object[0]);
    }

    private void setTitleKeyIfNoCustomTitle(String key) {
        if (this.hasTitle()) {
            return;
        }
        this.title(this.getI15dString(key, new Object[0]), new Object[0]);
    }

    private Icon getI15dIcon(String rawKey) {
        return this.getResources().getIcon("StandardPaneBuilder." + rawKey);
    }

    private String getI15dString(String rawKey, Object ... args) {
        return this.getResources().getString("StandardPaneBuilder." + rawKey, args);
    }

    private StringAndIconResourceAccessor getResources() {
        if (this.resources == null) {
            this.resources = Application.getResourceMap(BasicDialogResources.class);
        }
        return this.resources;
    }

    public static enum FileMode {
        ACCEPT_ALL,
        RETURN_NULL_FOR_NON_FILE_SYSTEM,
        REJECT_NON_FILE_SYSTEM_WITH_MESSAGE;

    }
}

